# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...core.serialization import convert_and_respect_annotation_metadata
from ...types.document_index_indexing_config_request import DocumentIndexIndexingConfigRequest
from ...types.document_index_read import DocumentIndexRead
from ...types.entity_status import EntityStatus
from ...types.paginated_document_index_read_list import PaginatedDocumentIndexReadList
from .types.document_indexes_list_request_status import DocumentIndexesListRequestStatus

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawDocumentIndexesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        search: typing.Optional[str] = None,
        status: typing.Optional[DocumentIndexesListRequestStatus] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PaginatedDocumentIndexReadList]:
        """
        Used to retrieve a list of Document Indexes.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        ordering : typing.Optional[str]
            Which field to use when ordering the results.

        search : typing.Optional[str]
            Search for document indices by name or label

        status : typing.Optional[DocumentIndexesListRequestStatus]
            Filter down to only document indices that have a status matching the status specified

            * `ACTIVE` - Active
            * `ARCHIVED` - Archived

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PaginatedDocumentIndexReadList]

        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/document-indexes",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            params={
                "limit": limit,
                "offset": offset,
                "ordering": ordering,
                "search": search,
                "status": status,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedDocumentIndexReadList,
                    parse_obj_as(
                        type_=PaginatedDocumentIndexReadList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        *,
        label: str,
        name: str,
        indexing_config: DocumentIndexIndexingConfigRequest,
        status: typing.Optional[EntityStatus] = OMIT,
        copy_documents_from_index_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[DocumentIndexRead]:
        """
        Creates a new document index.

        Parameters
        ----------
        label : str
            A human-readable label for the document index

        name : str
            A name that uniquely identifies this index within its workspace

        indexing_config : DocumentIndexIndexingConfigRequest

        status : typing.Optional[EntityStatus]
            The current status of the document index

            * `ACTIVE` - Active
            * `ARCHIVED` - Archived

        copy_documents_from_index_id : typing.Optional[str]
            Optionally specify the id of a document index from which you'd like to copy and re-index its documents into this newly created index

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DocumentIndexRead]

        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/document-indexes",
            base_url=self._client_wrapper.get_environment().default,
            method="POST",
            json={
                "label": label,
                "name": name,
                "status": status,
                "indexing_config": convert_and_respect_annotation_metadata(
                    object_=indexing_config, annotation=DocumentIndexIndexingConfigRequest, direction="write"
                ),
                "copy_documents_from_index_id": copy_documents_from_index_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DocumentIndexRead,
                    parse_obj_as(
                        type_=DocumentIndexRead,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def retrieve(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[DocumentIndexRead]:
        """
        Used to retrieve a Document Index given its ID or name.

        Parameters
        ----------
        id : str
            Either the Document Index's ID or its unique name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DocumentIndexRead]

        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/document-indexes/{jsonable_encoder(id)}",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DocumentIndexRead,
                    parse_obj_as(
                        type_=DocumentIndexRead,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        id: str,
        *,
        label: str,
        status: typing.Optional[EntityStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[DocumentIndexRead]:
        """
        Used to fully update a Document Index given its ID or name.

        Parameters
        ----------
        id : str
            Either the Document Index's ID or its unique name

        label : str
            A human-readable label for the document index

        status : typing.Optional[EntityStatus]
            The current status of the document index

            * `ACTIVE` - Active
            * `ARCHIVED` - Archived

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DocumentIndexRead]

        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/document-indexes/{jsonable_encoder(id)}",
            base_url=self._client_wrapper.get_environment().default,
            method="PUT",
            json={
                "label": label,
                "status": status,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DocumentIndexRead,
                    parse_obj_as(
                        type_=DocumentIndexRead,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def destroy(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[None]:
        """
        Used to delete a Document Index given its ID or name.

        Parameters
        ----------
        id : str
            Either the Document Index's ID or its unique name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/document-indexes/{jsonable_encoder(id)}",
            base_url=self._client_wrapper.get_environment().documents,
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def partial_update(
        self,
        id: str,
        *,
        label: typing.Optional[str] = OMIT,
        status: typing.Optional[EntityStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[DocumentIndexRead]:
        """
        Used to partial update a Document Index given its ID or name.

        Parameters
        ----------
        id : str
            Either the Document Index's ID or its unique name

        label : typing.Optional[str]
            A human-readable label for the document index

        status : typing.Optional[EntityStatus]
            The current status of the document index

            * `ACTIVE` - Active
            * `ARCHIVED` - Archived

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DocumentIndexRead]

        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/document-indexes/{jsonable_encoder(id)}",
            base_url=self._client_wrapper.get_environment().default,
            method="PATCH",
            json={
                "label": label,
                "status": status,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DocumentIndexRead,
                    parse_obj_as(
                        type_=DocumentIndexRead,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def add_document(
        self, document_id: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Adds a previously uploaded Document to the specified Document Index.

        Parameters
        ----------
        document_id : str
            Either the Vellum-generated ID or the originally supplied external_id that uniquely identifies the Document you'd like to add.

        id : str
            Either the Vellum-generated ID or the originally specified name that uniquely identifies the Document Index to which you'd like to add the Document.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/document-indexes/{jsonable_encoder(id)}/documents/{jsonable_encoder(document_id)}",
            base_url=self._client_wrapper.get_environment().default,
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def remove_document(
        self, document_id: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Removes a Document from a Document Index without deleting the Document itself.

        Parameters
        ----------
        document_id : str
            Either the Vellum-generated ID or the originally supplied external_id that uniquely identifies the Document you'd like to remove.

        id : str
            Either the Vellum-generated ID or the originally specified name that uniquely identifies the Document Index from which you'd like to remove a Document.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/document-indexes/{jsonable_encoder(id)}/documents/{jsonable_encoder(document_id)}",
            base_url=self._client_wrapper.get_environment().documents,
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawDocumentIndexesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        search: typing.Optional[str] = None,
        status: typing.Optional[DocumentIndexesListRequestStatus] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PaginatedDocumentIndexReadList]:
        """
        Used to retrieve a list of Document Indexes.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        ordering : typing.Optional[str]
            Which field to use when ordering the results.

        search : typing.Optional[str]
            Search for document indices by name or label

        status : typing.Optional[DocumentIndexesListRequestStatus]
            Filter down to only document indices that have a status matching the status specified

            * `ACTIVE` - Active
            * `ARCHIVED` - Archived

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PaginatedDocumentIndexReadList]

        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/document-indexes",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            params={
                "limit": limit,
                "offset": offset,
                "ordering": ordering,
                "search": search,
                "status": status,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedDocumentIndexReadList,
                    parse_obj_as(
                        type_=PaginatedDocumentIndexReadList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        *,
        label: str,
        name: str,
        indexing_config: DocumentIndexIndexingConfigRequest,
        status: typing.Optional[EntityStatus] = OMIT,
        copy_documents_from_index_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[DocumentIndexRead]:
        """
        Creates a new document index.

        Parameters
        ----------
        label : str
            A human-readable label for the document index

        name : str
            A name that uniquely identifies this index within its workspace

        indexing_config : DocumentIndexIndexingConfigRequest

        status : typing.Optional[EntityStatus]
            The current status of the document index

            * `ACTIVE` - Active
            * `ARCHIVED` - Archived

        copy_documents_from_index_id : typing.Optional[str]
            Optionally specify the id of a document index from which you'd like to copy and re-index its documents into this newly created index

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DocumentIndexRead]

        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/document-indexes",
            base_url=self._client_wrapper.get_environment().default,
            method="POST",
            json={
                "label": label,
                "name": name,
                "status": status,
                "indexing_config": convert_and_respect_annotation_metadata(
                    object_=indexing_config, annotation=DocumentIndexIndexingConfigRequest, direction="write"
                ),
                "copy_documents_from_index_id": copy_documents_from_index_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DocumentIndexRead,
                    parse_obj_as(
                        type_=DocumentIndexRead,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def retrieve(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[DocumentIndexRead]:
        """
        Used to retrieve a Document Index given its ID or name.

        Parameters
        ----------
        id : str
            Either the Document Index's ID or its unique name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DocumentIndexRead]

        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/document-indexes/{jsonable_encoder(id)}",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DocumentIndexRead,
                    parse_obj_as(
                        type_=DocumentIndexRead,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        id: str,
        *,
        label: str,
        status: typing.Optional[EntityStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[DocumentIndexRead]:
        """
        Used to fully update a Document Index given its ID or name.

        Parameters
        ----------
        id : str
            Either the Document Index's ID or its unique name

        label : str
            A human-readable label for the document index

        status : typing.Optional[EntityStatus]
            The current status of the document index

            * `ACTIVE` - Active
            * `ARCHIVED` - Archived

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DocumentIndexRead]

        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/document-indexes/{jsonable_encoder(id)}",
            base_url=self._client_wrapper.get_environment().default,
            method="PUT",
            json={
                "label": label,
                "status": status,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DocumentIndexRead,
                    parse_obj_as(
                        type_=DocumentIndexRead,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def destroy(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Used to delete a Document Index given its ID or name.

        Parameters
        ----------
        id : str
            Either the Document Index's ID or its unique name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/document-indexes/{jsonable_encoder(id)}",
            base_url=self._client_wrapper.get_environment().documents,
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def partial_update(
        self,
        id: str,
        *,
        label: typing.Optional[str] = OMIT,
        status: typing.Optional[EntityStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[DocumentIndexRead]:
        """
        Used to partial update a Document Index given its ID or name.

        Parameters
        ----------
        id : str
            Either the Document Index's ID or its unique name

        label : typing.Optional[str]
            A human-readable label for the document index

        status : typing.Optional[EntityStatus]
            The current status of the document index

            * `ACTIVE` - Active
            * `ARCHIVED` - Archived

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DocumentIndexRead]

        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/document-indexes/{jsonable_encoder(id)}",
            base_url=self._client_wrapper.get_environment().default,
            method="PATCH",
            json={
                "label": label,
                "status": status,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DocumentIndexRead,
                    parse_obj_as(
                        type_=DocumentIndexRead,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def add_document(
        self, document_id: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Adds a previously uploaded Document to the specified Document Index.

        Parameters
        ----------
        document_id : str
            Either the Vellum-generated ID or the originally supplied external_id that uniquely identifies the Document you'd like to add.

        id : str
            Either the Vellum-generated ID or the originally specified name that uniquely identifies the Document Index to which you'd like to add the Document.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/document-indexes/{jsonable_encoder(id)}/documents/{jsonable_encoder(document_id)}",
            base_url=self._client_wrapper.get_environment().default,
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def remove_document(
        self, document_id: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Removes a Document from a Document Index without deleting the Document itself.

        Parameters
        ----------
        document_id : str
            Either the Vellum-generated ID or the originally supplied external_id that uniquely identifies the Document you'd like to remove.

        id : str
            Either the Vellum-generated ID or the originally specified name that uniquely identifies the Document Index from which you'd like to remove a Document.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/document-indexes/{jsonable_encoder(id)}/documents/{jsonable_encoder(document_id)}",
            base_url=self._client_wrapper.get_environment().documents,
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
