# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.workspace_read import WorkspaceRead
from .raw_client import AsyncRawWorkspacesClient, RawWorkspacesClient


class WorkspacesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWorkspacesClient(client_wrapper=client_wrapper)

    @property
    def _client_wrapper(self) -> SyncClientWrapper:
        return self._raw_client._client_wrapper

    @property
    def with_raw_response(self) -> RawWorkspacesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWorkspacesClient
        """
        return self._raw_client

    def workspace_identity(self, *, request_options: typing.Optional[RequestOptions] = None) -> WorkspaceRead:
        """
        Retrieves information about the active Workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkspaceRead


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.workspaces.workspace_identity()
        """
        _response = self._raw_client.workspace_identity(request_options=request_options)
        return _response.data


class AsyncWorkspacesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWorkspacesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWorkspacesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWorkspacesClient
        """
        return self._raw_client

    async def workspace_identity(self, *, request_options: typing.Optional[RequestOptions] = None) -> WorkspaceRead:
        """
        Retrieves information about the active Workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkspaceRead


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workspaces.workspace_identity()


        asyncio.run(main())
        """
        _response = await self._raw_client.workspace_identity(request_options=request_options)
        return _response.data
