# Copyright (c) 2025 Darren Erik Vengroff
"""
Auto-generated module. It should not be edited directly.

This module contains abbreviated names for commonly used data sets.

These are typically used as the first argument to :py:func:`censudis.data.download`.

The Census Bureau routinely adds new datasets, so there many be more data sets available
than there are symbolic names here. However, we have automated the process of generating
these symbolic names so they should almost always be very close to up to date.

But you can always use raw strings. For example, even for `ACS5` you can use

`acs/acs5` instead.
"""


ABS_CB = "abscb"

ABS_CBO = "abscbo"

ABS_CS = "abscs"

ABS_MCB = "absmcb"

ABS_NESD = "absnesd"

ABS_NESDO = "absnesdo"

ABS_TCB = "abstcb"

ACS1 = "acs/acs1"

ACS1_CD113 = "acs1/cd113"

ACS1_CD115 = "acs1/cd115"

ACS1_CPROFILE = "acs/acs1/cprofile"

ACS1_PROFILE = "acs/acs1/profile"

ACS1_PUMS = "acs/acs1/pums"

ACS1_PUMSPR = "acs/acs1/pumspr"

ACS1_SDATAPROFILE_CD119 = "acs/acs1/sdataprofile/cd119"

ACS1_SPP = "acs/acs1/spp"

ACS1_SUBJECT = "acs/acs1/subject"

ACS3 = "acs/acs3"

ACS3_CPROFILE = "acs/acs3/cprofile"

ACS3_PROFILE = "acs/acs3/profile"

ACS3_SPP = "acs/acs3/spp"

ACS3_SUBJECT = "acs/acs3/subject"

ACS5 = "acs/acs5"

ACS5_AIAN = "acs/acs5/aian"

ACS5_AIANPROFILE = "acs/acs5/aianprofile"

ACS5_CPROFILE = "acs/acs5/cprofile"

ACS5_EEO = "acs/acs5/eeo"

ACS5_PROFILE = "acs/acs5/profile"

ACS5_PUMS = "acs/acs5/pums"

ACS5_PUMSPR = "acs/acs5/pumspr"

ACS5_SPT = "acs/acs5/spt"

ACS5_SPTPROFILE = "acs/acs5/sptprofile"

ACS5_SUBJECT = "acs/acs5/subject"

ACSSE = "acs/acsse"

ACS_FLOWS = "acs/flows"

ASE_CSA = "ase/csa"

ASE_CSCB = "ase/cscb"

ASE_CSCBO = "ase/cscbo"

CBP = "cbp"

CFSAREA = "cfsarea"

CFSEXPORT = "cfsexport"

CFSHAZMAT = "cfshazmat"

CFSPRELIM = "cfsprelim"

CFSPUMDEST = "cfspum/cfspumdest"

CFSPUMORIG = "cfspum/cfspumorig"

CFSTEMP = "cfstemp"

CPS_ARTS_FEB = "cps/arts/feb"

CPS_ASEC_MAR = "cps/asec/mar"

CPS_BASIC_APR = "cps/basic/apr"

CPS_BASIC_AUG = "cps/basic/aug"

CPS_BASIC_DEC = "cps/basic/dec"

CPS_BASIC_FEB = "cps/basic/feb"

CPS_BASIC_JAN = "cps/basic/jan"

CPS_BASIC_JUL = "cps/basic/jul"

CPS_BASIC_JUN = "cps/basic/jun"

CPS_BASIC_MAR = "cps/basic/mar"

CPS_BASIC_MAY = "cps/basic/may"

CPS_BASIC_NOV = "cps/basic/nov"

CPS_BASIC_OCT = "cps/basic/oct"

CPS_BASIC_SEP = "cps/basic/sep"

CPS_CIVIC_NOV = "cps/civic/nov"

CPS_CONTWORKER_FEB = "cps/contworker/feb"

CPS_CONTWORKER_MAY = "cps/contworker/may"

CPS_DISABILITY_JUL = "cps/disability/jul"

CPS_DISABILITY_MAY = "cps/disability/may"

CPS_DWJT_FEB = "cps/dwjt/feb"

CPS_DWJT_JAN = "cps/dwjt/jan"

CPS_FERTILITY_JUN = "cps/fertility/jun"

CPS_FOODSEC_APR = "cps/foodsec/apr"

CPS_FOODSEC_AUG = "cps/foodsec/aug"

CPS_FOODSEC_DEC = "cps/foodsec/dec"

CPS_FOODSEC_SEP = "cps/foodsec/sep"

CPS_IMMIGRATION_AUG = "cps/immigration/aug"

CPS_INTERNET_AUG = "cps/internet/aug"

CPS_INTERNET_DEC = "cps/internet/dec"

CPS_INTERNET_JUL = "cps/internet/jul"

CPS_INTERNET_NOV = "cps/internet/nov"

CPS_INTERNET_OCT = "cps/internet/oct"

CPS_INTERNET_SEP = "cps/internet/sep"

CPS_LIBRARY_OCT = "cps/library/oct"

CPS_MARITAL_JUN = "cps/marital/jun"

CPS_PUBARTS_AUG = "cps/pubarts/aug"

CPS_PUBARTS_JUL = "cps/pubarts/jul"

CPS_RACE_MAY = "cps/race/may"

CPS_SCHOOL_OCT = "cps/school/oct"

CPS_TOBACCO_AUG = "cps/tobacco/aug"

CPS_TOBACCO_JAN = "cps/tobacco/jan"

CPS_TOBACCO_JUL = "cps/tobacco/jul"

CPS_TOBACCO_MAY = "cps/tobacco/may"

CPS_TOBACCO_SEP = "cps/tobacco/sep"

CPS_UNBANK_JAN = "cps/unbank/jan"

CPS_UNBANK_JUN = "cps/unbank/jun"

CPS_VETS_AUG = "cps/vets/aug"

CPS_VETS_JUL = "cps/vets/jul"

CPS_VETS_SEP = "cps/vets/sep"

CPS_VOLUNTEER_SEP = "cps/volunteer/sep"

CPS_VOTING_NOV = "cps/voting/nov"

CPS_WORKSCHED_MAY = "cps/worksched/may"

CRE = "cre"

CREPUERTORICO = "crepuertorico"

DECENNIAL_AIAN = "dec/aian"

DECENNIAL_AIANPROFILE = "dec/aianprofile"

DECENNIAL_AS = "dec/as"

DECENNIAL_ASYOE = "dec/asyoe"

DECENNIAL_CD110H = "dec/cd110h"

DECENNIAL_CD110HPROFILE = "dec/cd110hprofile"

DECENNIAL_CD110S = "dec/cd110s"

DECENNIAL_CD110SPROFILE = "dec/cd110sprofile"

DECENNIAL_CD113 = "dec/cd113"

DECENNIAL_CD113PROFILE = "dec/cd113profile"

DECENNIAL_CD115 = "dec/cd115"

DECENNIAL_CD115PROFILE = "dec/cd115profile"

DECENNIAL_CD116 = "dec/cd116"

DECENNIAL_CD118 = "dec/cd118"

DECENNIAL_CD119 = "dec/cd119"

DECENNIAL_CQR = "dec/cqr"

DECENNIAL_CROSSTABAS = "dec/crosstabas"

DECENNIAL_CROSSTABGU = "dec/crosstabgu"

DECENNIAL_CROSSTABMP = "dec/crosstabmp"

DECENNIAL_CROSSTABVI = "dec/crosstabvi"

DECENNIAL_DDHCA = "dec/ddhca"

DECENNIAL_DDHCB = "dec/ddhcb"

DECENNIAL_DHC = "dec/dhc"

DECENNIAL_DHCAS = "dec/dhcas"

DECENNIAL_DHCGU = "dec/dhcgu"

DECENNIAL_DHCMP = "dec/dhcmp"

DECENNIAL_DHCVI = "dec/dhcvi"

DECENNIAL_DP = "dec/dp"

DECENNIAL_DPAS = "dec/dpas"

DECENNIAL_DPGU = "dec/dpgu"

DECENNIAL_DPMP = "dec/dpmp"

DECENNIAL_DPVI = "dec/dpvi"

DECENNIAL_GU = "dec/gu"

DECENNIAL_GUYOE = "dec/guyoe"

DECENNIAL_MP = "dec/mp"

DECENNIAL_MPYOE = "dec/mpyoe"

DECENNIAL_PES = "dec/pes"

DECENNIAL_PLNAT = "dec/plnat"

DECENNIAL_PUBLIC_LAW_94_171 = "dec/pl"

DECENNIAL_RESPONSERATE = "dec/responserate"

DECENNIAL_SDHC = "dec/sdhc"

DECENNIAL_SELFRESPONSERATE = "dec/selfresponserate"

DECENNIAL_SF1 = "dec/sf1"

DECENNIAL_SF2 = "dec/sf2"

DECENNIAL_SF2PROFILE = "dec/sf2profile"

DECENNIAL_SF3 = "dec/sf3"

DECENNIAL_SF3PROFILE = "dec/sf3profile"

DECENNIAL_SF4 = "dec/sf4"

DECENNIAL_SF4PROFILE = "dec/sf4profile"

DECENNIAL_SLDH = "dec/sldh"

DECENNIAL_SLDHPROFILE = "dec/sldhprofile"

DECENNIAL_SLDS = "dec/slds"

DECENNIAL_SLDSPROFILE = "dec/sldsprofile"

DECENNIAL_SURNAME = "surname"

DECENNIAL_VI = "dec/vi"

ECN_ADBNPROP = "ecnadbnprop"

ECN_ADMBEN = "ecnadmben"

ECN_BASIC = "ecnbasic"

ECN_BRANDDEAL = "ecnbranddeal"

ECN_BRIDGE1 = "ecnbridge1"

ECN_BRIDGE2 = "ecnbridge2"

ECN_BRORDEAL = "ecnbrordeal"

ECN_CASHADV = "ecncashadv"

ECN_CCARD = "ecnccard"

ECN_CLCUST = "ecnclcust"

ECN_COMM = "ecncomm"

ECN_COMP = "ecncomp"

ECN_CONACT = "ecnconact"

ECN_CONCESS = "ecnconcess"

ECN_CRFIN = "ecncrfin"

ECN_DIRPREM = "ecndirprem"

ECN_DISSMED = "ecndissmed"

ECN_ECOMM = "ecnecomm"

ECN_ELMENU = "ecnelmenu"

ECN_EMPFUNC = "ecnempfunc"

ECN_ENTSUP = "ecnentsup"

ECN_EOYINV = "ecneoyinv"

ECN_EOYINVWH = "ecneoyinvwh"

ECN_EQUIP = "ecnequip"

ECN_EXPNRG = "ecnexpnrg"

ECN_EXPSVC = "ecnexpsvc"

ECN_FLSPACE = "ecnflspace"

ECN_FOODSVC = "ecnfoodsvc"

ECN_FRAN = "ecnfran"

ECN_GRANT = "ecngrant"

ECN_GUEST = "ecnguest"

ECN_GUESTSIZE = "ecnguestsize"

ECN_HOSP = "ecnhosp"

ECN_HOTEL = "ecnhotel"

ECN_INSTR = "ecninstr"

ECN_INVVAL = "ecninvval"

ECN_IPA = "ecnipa"

ECN_ISLANDAREAS = "ecn/islandareas/napcs"

ECN_KOB = "ecnkob"

ECN_LABOR = "ecnlabor"

ECN_LIFOMFG = "ecnlifomfg"

ECN_LIFOMINE = "ecnlifomine"

ECN_LIFOVAL = "ecnlifoval"

ECN_LINES = "ecnlines"

ECN_LOAN = "ecnloan"

ECN_LOCCONS = "ecnloccons"

ECN_LOCMFG = "ecnlocmfg"

ECN_LOCMINE = "ecnlocmine"

ECN_MARGIN = "ecnmargin"

ECN_MATFUEL = "ecnmatfuel"

ECN_MEALCOST = "ecnmealcost"

ECN_MENUTYPE = "ecnmenutype"

ECN_NAPCSIND = "ecnnapcsind"

ECN_NAPCSPRD = "ecnnapcsprd"

ECN_PATIENT = "ecnpatient"

ECN_PETRFAC = "ecnpetrfac"

ECN_PETRPROD = "ecnpetrprod"

ECN_PETRREC = "ecnpetrrec"

ECN_PETRSTAT = "ecnpetrstat"

ECN_PROFIT = "ecnprofit"

ECN_PURELEC = "ecnpurelec"

ECN_PURGAS = "ecnpurgas"

ECN_PURMODE = "ecnpurmode"

ECN_RDACQ = "ecnrdacq"

ECN_RDOFC = "ecnrdofc"

ECN_SEAT = "ecnseat"

ECN_SIZE = "ecnsize"

ECN_SOCIAL = "ecnsocial"

ECN_TYPE = "ecntype"

ECN_TYPEPAYER = "ecntypepayer"

ECN_TYPOP = "ecntypop"

ECN_VALCON = "ecnvalcon"

EWKS = "ewks"

GEOINFO = "geoinfo"

INTLTRADE_IMP_EXP = "intltrade/imp_exp"

LANGUAGE = "language"

NONEMP = "nonemp"

PDB_BLOCKGROUP = "pdb/blockgroup"

PDB_STATECOUNTY = "pdb/statecounty"

PDB_TRACT = "pdb/tract"

PEP_AGESEX = "pep/agesex"

PEP_AGESPECIAL5 = "pep/agespecial5"

PEP_AGESPECIAL6 = "pep/agespecial6"

PEP_AGESPECIALPR = "pep/agespecialpr"

PEP_CHARAGE = "pep/charage"

PEP_CHARAGEGROUPS = "pep/charagegroups"

PEP_CHARV = "pep/charv"

PEP_COCHAR5 = "pep/cochar5"

PEP_COCHAR6 = "pep/cochar6"

PEP_COMPONENTS = "pep/components"

PEP_CTY = "pep/cty"

PEP_HOUSING = "pep/housing"

PEP_INT_CHARAGE = "pep/int_charage"

PEP_INT_CHARAGEGROUPS = "pep/int_charagegroups"

PEP_INT_HOUSINGUNITS = "pep/int_housingunits"

PEP_INT_NATCIVPOP = "pep/int_natcivpop"

PEP_INT_NATMONTHLY = "pep/int_natmonthly"

PEP_INT_NATRESAFO = "pep/int_natresafo"

PEP_INT_NATRESPOP = "pep/int_natrespop"

PEP_INT_POPULATION = "pep/int_population"

PEP_MONTHLYNATCHAR5 = "pep/monthlynatchar5"

PEP_MONTHLYNATCHAR6 = "pep/monthlynatchar6"

PEP_NATMONTHLY = "pep/natmonthly"

PEP_NATSTPRC = "pep/natstprc"

PEP_NATSTPRC18 = "pep/natstprc18"

PEP_POPULATION = "pep/population"

PEP_PRCAGESEX = "pep/prcagesex"

PEP_PRM = "pep/prm"

PEP_PRMAGESEX = "pep/prmagesex"

PEP_PROJAGEGROUPS = "pep/projagegroups"

PEP_PROJBIRTHS = "pep/projbirths"

PEP_PROJDEATHS = "pep/projdeaths"

PEP_PROJNAT = "pep/projnat"

PEP_PROJNIM = "pep/projnim"

PEP_PROJPOP = "pep/projpop"

PEP_STCHAR5 = "pep/stchar5"

PEP_STCHAR6 = "pep/stchar6"

PEP_SUBCTY = "pep/subcty"

POPPROJ = "popproj/pop"

POPPROJ_AGEGROUPS = "popproj/agegroups"

POPPROJ_BIRTHS = "popproj/births"

POPPROJ_DEATHS = "popproj/deaths"

POPPROJ_NAT = "popproj/nat"

POPPROJ_NIM = "popproj/nim"

PUBLIC_PK12_EDUCATION_FINANCE = "pubschlfin"

RHFS = "rhfs"

SBO_CS = "sbo/cs"

SBO_CSCB = "sbo/cscb"

SBO_CSCBO = "sbo/cscbo"

SIPP = "sipp"

SIPP_BENEFIT = "sipp/benefit/1991panel"

SIPP_CORE = "sipp/core/2008panel/wave9"

SIPP_TOPICAL = "sipp/topical/2008panel/wave9"

SIPP_TOPICALED = "sipp/topicaled/1993panel/wave8"

SIPP_TOPICALEDEX = "sipp/topicaledex/1993panel/wave8"

SIPP_TOPICALEX = "sipp/topicalex/1993panel/wave3"

SIPP_TOPICALRES = "sipp/topicalres/2001panel/wave8"

TIMESERIES_ASM = "timeseries/asm/value2017"

TIMESERIES_BDS = "timeseries/bds"

TIMESERIES_EITS = "timeseries/eits/vip"

TIMESERIES_GOVS = "timeseries/govs"

TIMESERIES_HEALTHINS = "timeseries/healthins/sahie"

TIMESERIES_HHPULSE = "timeseries/hhpulse"

TIMESERIES_HPS = "timeseries/hps"

TIMESERIES_IDB = "timeseries/idb/5year"

TIMESERIES_INTLTRADE = "timeseries/intltrade/imports/usdaimport"

TIMESERIES_POVERTY = "timeseries/poverty/saipe/schdist"

TIMESERIES_PSEO = "timeseries/pseo/flows"

TIMESERIES_QWI = "timeseries/qwi/se"

TIMESERIES_SOMA = "timeseries/soma"

VIUSA = "viusa"

VIUSB = "viusb"

VIUSC = "viusc"

VIUSD = "viusd"

VIUSE = "viuse"

VIUSF = "viusf"

VIUSPUF = "viuspuf"

ZBP = "zbp"


DATASET_REFERENCE_URLS = {
    ABS_CB: "http://api.census.gov/data/2022/abscb",
    ABS_CBO: "http://api.census.gov/data/2022/abscbo",
    ABS_CS: "http://api.census.gov/data/2022/abscs",
    ABS_MCB: "http://api.census.gov/data/2022/absmcb",
    ABS_NESD: "http://api.census.gov/data/2022/absnesd",
    ABS_NESDO: "http://api.census.gov/data/2022/absnesdo",
    ABS_TCB: "http://api.census.gov/data/2018/abstcb",
    ACS1: "http://api.census.gov/data/2023/acs/acs1",
    ACS1_CD113: "http://api.census.gov/data/2011/acs1/cd113",
    ACS1_CD115: "http://api.census.gov/data/2015/acs1/cd115",
    ACS1_CPROFILE: "http://api.census.gov/data/2023/acs/acs1/cprofile",
    ACS1_PROFILE: "http://api.census.gov/data/2023/acs/acs1/profile",
    ACS1_PUMS: "http://api.census.gov/data/2023/acs/acs1/pums",
    ACS1_PUMSPR: "http://api.census.gov/data/2023/acs/acs1/pumspr",
    ACS1_SDATAPROFILE_CD119: "http://api.census.gov/data/2023/acs/acs1/sdataprofile/cd119",
    ACS1_SPP: "http://api.census.gov/data/2023/acs/acs1/spp",
    ACS1_SUBJECT: "http://api.census.gov/data/2023/acs/acs1/subject",
    ACS3: "http://api.census.gov/data/2013/acs/acs3",
    ACS3_CPROFILE: "http://api.census.gov/data/2013/acs/acs3/cprofile",
    ACS3_PROFILE: "http://api.census.gov/data/2013/acs/acs3/profile",
    ACS3_SPP: "http://api.census.gov/data/2013/acs/acs3/spp",
    ACS3_SUBJECT: "http://api.census.gov/data/2013/acs/acs3/subject",
    ACS5: "http://api.census.gov/data/2023/acs/acs5",
    ACS5_AIAN: "http://api.census.gov/data/2021/acs/acs5/aian",
    ACS5_AIANPROFILE: "http://api.census.gov/data/2021/acs/acs5/aianprofile",
    ACS5_CPROFILE: "http://api.census.gov/data/2023/acs/acs5/cprofile",
    ACS5_EEO: "http://api.census.gov/data/2018/acs/acs5/eeo",
    ACS5_PROFILE: "http://api.census.gov/data/2023/acs/acs5/profile",
    ACS5_PUMS: "http://api.census.gov/data/2023/acs/acs5/pums",
    ACS5_PUMSPR: "http://api.census.gov/data/2023/acs/acs5/pumspr",
    ACS5_SPT: "http://api.census.gov/data/2021/acs/acs5/spt",
    ACS5_SPTPROFILE: "http://api.census.gov/data/2021/acs/acs5/sptprofile",
    ACS5_SUBJECT: "http://api.census.gov/data/2023/acs/acs5/subject",
    ACSSE: "http://api.census.gov/data/2023/acs/acsse",
    ACS_FLOWS: "http://api.census.gov/data/2022/acs/flows",
    ASE_CSA: "http://api.census.gov/data/2016/ase/csa",
    ASE_CSCB: "http://api.census.gov/data/2016/ase/cscb",
    ASE_CSCBO: "http://api.census.gov/data/2016/ase/cscbo",
    CBP: "http://api.census.gov/data/2023/cbp",
    CFSAREA: "http://api.census.gov/data/2022/cfsarea",
    CFSEXPORT: "http://api.census.gov/data/2022/cfsexport",
    CFSHAZMAT: "http://api.census.gov/data/2022/cfshazmat",
    CFSPRELIM: "http://api.census.gov/data/2017/cfsprelim",
    CFSPUMDEST: "http://api.census.gov/data/2017/cfspum/cfspumdest",
    CFSPUMORIG: "http://api.census.gov/data/2017/cfspum/cfspumorig",
    CFSTEMP: "http://api.census.gov/data/2022/cfstemp",
    CPS_ARTS_FEB: "http://api.census.gov/data/2020/cps/arts/feb",
    CPS_ASEC_MAR: "http://api.census.gov/data/2024/cps/asec/mar",
    CPS_BASIC_APR: "http://api.census.gov/data/2025/cps/basic/apr",
    CPS_BASIC_AUG: "http://api.census.gov/data/2024/cps/basic/aug",
    CPS_BASIC_DEC: "http://api.census.gov/data/2024/cps/basic/dec",
    CPS_BASIC_FEB: "http://api.census.gov/data/2025/cps/basic/feb",
    CPS_BASIC_JAN: "http://api.census.gov/data/2025/cps/basic/jan",
    CPS_BASIC_JUL: "http://api.census.gov/data/2024/cps/basic/jul",
    CPS_BASIC_JUN: "http://api.census.gov/data/2025/cps/basic/jun",
    CPS_BASIC_MAR: "http://api.census.gov/data/2025/cps/basic/mar",
    CPS_BASIC_MAY: "http://api.census.gov/data/2025/cps/basic/may",
    CPS_BASIC_NOV: "http://api.census.gov/data/2024/cps/basic/nov",
    CPS_BASIC_OCT: "http://api.census.gov/data/2024/cps/basic/oct",
    CPS_BASIC_SEP: "http://api.census.gov/data/2024/cps/basic/sep",
    CPS_CIVIC_NOV: "http://api.census.gov/data/2013/cps/civic/nov",
    CPS_CONTWORKER_FEB: "http://api.census.gov/data/2005/cps/contworker/feb",
    CPS_CONTWORKER_MAY: "http://api.census.gov/data/2017/cps/contworker/may",
    CPS_DISABILITY_JUL: "http://api.census.gov/data/2021/cps/disability/jul",
    CPS_DISABILITY_MAY: "http://api.census.gov/data/2012/cps/disability/may",
    CPS_DWJT_FEB: "http://api.census.gov/data/2000/cps/dwjt/feb",
    CPS_DWJT_JAN: "http://api.census.gov/data/2024/cps/dwjt/jan",
    CPS_FERTILITY_JUN: "http://api.census.gov/data/2024/cps/fertility/jun",
    CPS_FOODSEC_APR: "http://api.census.gov/data/2001/cps/foodsec/apr",
    CPS_FOODSEC_AUG: "http://api.census.gov/data/1998/cps/foodsec/aug",
    CPS_FOODSEC_DEC: "http://api.census.gov/data/2023/cps/foodsec/dec",
    CPS_FOODSEC_SEP: "http://api.census.gov/data/2000/cps/foodsec/sep",
    CPS_IMMIGRATION_AUG: "http://api.census.gov/data/2008/cps/immigration/aug",
    CPS_INTERNET_AUG: "http://api.census.gov/data/2000/cps/internet/aug",
    CPS_INTERNET_DEC: "http://api.census.gov/data/1998/cps/internet/dec",
    CPS_INTERNET_JUL: "http://api.census.gov/data/2015/cps/internet/jul",
    CPS_INTERNET_NOV: "http://api.census.gov/data/2023/cps/internet/nov",
    CPS_INTERNET_OCT: "http://api.census.gov/data/2012/cps/internet/oct",
    CPS_INTERNET_SEP: "http://api.census.gov/data/2001/cps/internet/sep",
    CPS_LIBRARY_OCT: "http://api.census.gov/data/2002/cps/library/oct",
    CPS_MARITAL_JUN: "http://api.census.gov/data/1995/cps/marital/jun",
    CPS_PUBARTS_AUG: "http://api.census.gov/data/2002/cps/pubarts/aug",
    CPS_PUBARTS_JUL: "http://api.census.gov/data/2022/cps/pubarts/jul",
    CPS_RACE_MAY: "http://api.census.gov/data/1995/cps/race/may",
    CPS_SCHOOL_OCT: "http://api.census.gov/data/2023/cps/school/oct",
    CPS_TOBACCO_AUG: "http://api.census.gov/data/2010/cps/tobacco/aug",
    CPS_TOBACCO_JAN: "http://api.census.gov/data/2023/cps/tobacco/jan",
    CPS_TOBACCO_JUL: "http://api.census.gov/data/2018/cps/tobacco/jul",
    CPS_TOBACCO_MAY: "http://api.census.gov/data/2023/cps/tobacco/may",
    CPS_TOBACCO_SEP: "http://api.census.gov/data/2022/cps/tobacco/sep",
    CPS_UNBANK_JAN: "http://api.census.gov/data/2009/cps/unbank/jan",
    CPS_UNBANK_JUN: "http://api.census.gov/data/2023/cps/unbank/jun",
    CPS_VETS_AUG: "http://api.census.gov/data/2024/cps/vets/aug",
    CPS_VETS_JUL: "http://api.census.gov/data/2010/cps/vets/jul",
    CPS_VETS_SEP: "http://api.census.gov/data/1999/cps/vets/sep",
    CPS_VOLUNTEER_SEP: "http://api.census.gov/data/2023/cps/volunteer/sep",
    CPS_VOTING_NOV: "http://api.census.gov/data/2024/cps/voting/nov",
    CPS_WORKSCHED_MAY: "http://api.census.gov/data/2004/cps/worksched/may",
    CRE: "http://api.census.gov/data/2023/cre",
    CREPUERTORICO: "http://api.census.gov/data/2023/crepuertorico",
    DECENNIAL_AIAN: "http://api.census.gov/data/2010/dec/aian",
    DECENNIAL_AIANPROFILE: "http://api.census.gov/data/2000/dec/aianprofile",
    DECENNIAL_AS: "http://api.census.gov/data/2010/dec/as",
    DECENNIAL_ASYOE: "http://api.census.gov/data/2010/dec/asyoe",
    DECENNIAL_CD110H: "http://api.census.gov/data/2000/dec/cd110h",
    DECENNIAL_CD110HPROFILE: "http://api.census.gov/data/2000/dec/cd110hprofile",
    DECENNIAL_CD110S: "http://api.census.gov/data/2000/dec/cd110s",
    DECENNIAL_CD110SPROFILE: "http://api.census.gov/data/2000/dec/cd110sprofile",
    DECENNIAL_CD113: "http://api.census.gov/data/2010/dec/cd113",
    DECENNIAL_CD113PROFILE: "http://api.census.gov/data/2010/dec/cd113profile",
    DECENNIAL_CD115: "http://api.census.gov/data/2010/dec/cd115",
    DECENNIAL_CD115PROFILE: "http://api.census.gov/data/2010/dec/cd115profile",
    DECENNIAL_CD116: "http://api.census.gov/data/2010/dec/cd116",
    DECENNIAL_CD118: "http://api.census.gov/data/2020/dec/cd118",
    DECENNIAL_CD119: "http://api.census.gov/data/2020/dec/cd119",
    DECENNIAL_CQR: "http://api.census.gov/data/2000/dec/cqr",
    DECENNIAL_CROSSTABAS: "http://api.census.gov/data/2020/dec/crosstabas",
    DECENNIAL_CROSSTABGU: "http://api.census.gov/data/2020/dec/crosstabgu",
    DECENNIAL_CROSSTABMP: "http://api.census.gov/data/2020/dec/crosstabmp",
    DECENNIAL_CROSSTABVI: "http://api.census.gov/data/2020/dec/crosstabvi",
    DECENNIAL_DDHCA: "http://api.census.gov/data/2020/dec/ddhca",
    DECENNIAL_DDHCB: "http://api.census.gov/data/2020/dec/ddhcb",
    DECENNIAL_DHC: "http://api.census.gov/data/2020/dec/dhc",
    DECENNIAL_DHCAS: "http://api.census.gov/data/2020/dec/dhcas",
    DECENNIAL_DHCGU: "http://api.census.gov/data/2020/dec/dhcgu",
    DECENNIAL_DHCMP: "http://api.census.gov/data/2020/dec/dhcmp",
    DECENNIAL_DHCVI: "http://api.census.gov/data/2020/dec/dhcvi",
    DECENNIAL_DP: "http://api.census.gov/data/2020/dec/dp",
    DECENNIAL_DPAS: "http://api.census.gov/data/2020/dec/dpas",
    DECENNIAL_DPGU: "http://api.census.gov/data/2020/dec/dpgu",
    DECENNIAL_DPMP: "http://api.census.gov/data/2020/dec/dpmp",
    DECENNIAL_DPVI: "http://api.census.gov/data/2020/dec/dpvi",
    DECENNIAL_GU: "http://api.census.gov/data/2010/dec/gu",
    DECENNIAL_GUYOE: "http://api.census.gov/data/2010/dec/guyoe",
    DECENNIAL_MP: "http://api.census.gov/data/2010/dec/mp",
    DECENNIAL_MPYOE: "http://api.census.gov/data/2010/dec/mpyoe",
    DECENNIAL_PES: "http://api.census.gov/data/2020/dec/pes",
    DECENNIAL_PLNAT: "http://api.census.gov/data/2010/dec/plnat",
    DECENNIAL_PUBLIC_LAW_94_171: "http://api.census.gov/data/2020/dec/pl",
    DECENNIAL_RESPONSERATE: "http://api.census.gov/data/2020/dec/responserate",
    DECENNIAL_SDHC: "http://api.census.gov/data/2020/dec/sdhc",
    DECENNIAL_SELFRESPONSERATE: "http://api.census.gov/data/2020/dec/selfresponserate",
    DECENNIAL_SF1: "http://api.census.gov/data/2010/dec/sf1",
    DECENNIAL_SF2: "http://api.census.gov/data/2010/dec/sf2",
    DECENNIAL_SF2PROFILE: "http://api.census.gov/data/2000/dec/sf2profile",
    DECENNIAL_SF3: "http://api.census.gov/data/2000/dec/sf3",
    DECENNIAL_SF3PROFILE: "http://api.census.gov/data/2000/dec/sf3profile",
    DECENNIAL_SF4: "http://api.census.gov/data/2000/dec/sf4",
    DECENNIAL_SF4PROFILE: "http://api.census.gov/data/2000/dec/sf4profile",
    DECENNIAL_SLDH: "http://api.census.gov/data/2000/dec/sldh",
    DECENNIAL_SLDHPROFILE: "http://api.census.gov/data/2000/dec/sldhprofile",
    DECENNIAL_SLDS: "http://api.census.gov/data/2000/dec/slds",
    DECENNIAL_SLDSPROFILE: "http://api.census.gov/data/2000/dec/sldsprofile",
    DECENNIAL_SURNAME: "http://api.census.gov/data/2010/surname",
    DECENNIAL_VI: "http://api.census.gov/data/2010/dec/vi",
    ECN_ADBNPROP: "http://api.census.gov/data/2017/ecnadbnprop",
    ECN_ADMBEN: "http://api.census.gov/data/2017/ecnadmben",
    ECN_BASIC: "http://api.census.gov/data/2022/ecnbasic",
    ECN_BRANDDEAL: "http://api.census.gov/data/2017/ecnbranddeal",
    ECN_BRIDGE1: "http://api.census.gov/data/2022/ecnbridge1",
    ECN_BRIDGE2: "http://api.census.gov/data/2022/ecnbridge2",
    ECN_BRORDEAL: "http://api.census.gov/data/2017/ecnbrordeal",
    ECN_CASHADV: "http://api.census.gov/data/2012/ecncashadv",
    ECN_CCARD: "http://api.census.gov/data/2017/ecnccard",
    ECN_CLCUST: "http://api.census.gov/data/2017/ecnclcust",
    ECN_COMM: "http://api.census.gov/data/2022/ecncomm",
    ECN_COMP: "http://api.census.gov/data/2022/ecncomp",
    ECN_CONACT: "http://api.census.gov/data/2017/ecnconact",
    ECN_CONCESS: "http://api.census.gov/data/2012/ecnconcess",
    ECN_CRFIN: "http://api.census.gov/data/2017/ecncrfin",
    ECN_DIRPREM: "http://api.census.gov/data/2017/ecndirprem",
    ECN_DISSMED: "http://api.census.gov/data/2017/ecndissmed",
    ECN_ECOMM: "http://api.census.gov/data/2022/ecnecomm",
    ECN_ELMENU: "http://api.census.gov/data/2017/ecnelmenu",
    ECN_EMPFUNC: "http://api.census.gov/data/2022/ecnempfunc",
    ECN_ENTSUP: "http://api.census.gov/data/2017/ecnentsup",
    ECN_EOYINV: "http://api.census.gov/data/2017/ecneoyinv",
    ECN_EOYINVWH: "http://api.census.gov/data/2017/ecneoyinvwh",
    ECN_EQUIP: "http://api.census.gov/data/2012/ecnequip",
    ECN_EXPNRG: "http://api.census.gov/data/2017/ecnexpnrg",
    ECN_EXPSVC: "http://api.census.gov/data/2017/ecnexpsvc",
    ECN_FLSPACE: "http://api.census.gov/data/2017/ecnflspace",
    ECN_FOODSVC: "http://api.census.gov/data/2017/ecnfoodsvc",
    ECN_FRAN: "http://api.census.gov/data/2017/ecnfran",
    ECN_GRANT: "http://api.census.gov/data/2017/ecngrant",
    ECN_GUEST: "http://api.census.gov/data/2012/ecnguest",
    ECN_GUESTSIZE: "http://api.census.gov/data/2012/ecnguestsize",
    ECN_HOSP: "http://api.census.gov/data/2017/ecnhosp",
    ECN_HOTEL: "http://api.census.gov/data/2017/ecnhotel",
    ECN_INSTR: "http://api.census.gov/data/2017/ecninstr",
    ECN_INVVAL: "http://api.census.gov/data/2022/ecninvval",
    ECN_IPA: "http://api.census.gov/data/2012/ecnipa",
    ECN_ISLANDAREAS: "http://api.census.gov/data/2022/ecn/islandareas/napcs",
    ECN_KOB: "http://api.census.gov/data/2017/ecnkob",
    ECN_LABOR: "http://api.census.gov/data/2017/ecnlabor",
    ECN_LIFOMFG: "http://api.census.gov/data/2022/ecnlifomfg",
    ECN_LIFOMINE: "http://api.census.gov/data/2022/ecnlifomine",
    ECN_LIFOVAL: "http://api.census.gov/data/2012/ecnlifoval",
    ECN_LINES: "http://api.census.gov/data/2012/ecnlines",
    ECN_LOAN: "http://api.census.gov/data/2017/ecnloan",
    ECN_LOCCONS: "http://api.census.gov/data/2022/ecnloccons",
    ECN_LOCMFG: "http://api.census.gov/data/2022/ecnlocmfg",
    ECN_LOCMINE: "http://api.census.gov/data/2022/ecnlocmine",
    ECN_MARGIN: "http://api.census.gov/data/2017/ecnmargin",
    ECN_MATFUEL: "http://api.census.gov/data/2022/ecnmatfuel",
    ECN_MEALCOST: "http://api.census.gov/data/2012/ecnmealcost",
    ECN_MENUTYPE: "http://api.census.gov/data/2012/ecnmenutype",
    ECN_NAPCSIND: "http://api.census.gov/data/2022/ecnnapcsind",
    ECN_NAPCSPRD: "http://api.census.gov/data/2022/ecnnapcsprd",
    ECN_PATIENT: "http://api.census.gov/data/2017/ecnpatient",
    ECN_PETRFAC: "http://api.census.gov/data/2017/ecnpetrfac",
    ECN_PETRPROD: "http://api.census.gov/data/2017/ecnpetrprod",
    ECN_PETRREC: "http://api.census.gov/data/2017/ecnpetrrec",
    ECN_PETRSTAT: "http://api.census.gov/data/2017/ecnpetrstat",
    ECN_PROFIT: "http://api.census.gov/data/2017/ecnprofit",
    ECN_PURELEC: "http://api.census.gov/data/2017/ecnpurelec",
    ECN_PURGAS: "http://api.census.gov/data/2017/ecnpurgas",
    ECN_PURMODE: "http://api.census.gov/data/2017/ecnpurmode",
    ECN_RDACQ: "http://api.census.gov/data/2012/ecnrdacq",
    ECN_RDOFC: "http://api.census.gov/data/2017/ecnrdofc",
    ECN_SEAT: "http://api.census.gov/data/2012/ecnseat",
    ECN_SIZE: "http://api.census.gov/data/2022/ecnsize",
    ECN_SOCIAL: "http://api.census.gov/data/2017/ecnsocial",
    ECN_TYPE: "http://api.census.gov/data/2022/ecntype",
    ECN_TYPEPAYER: "http://api.census.gov/data/2017/ecntypepayer",
    ECN_TYPOP: "http://api.census.gov/data/2022/ecntypop",
    ECN_VALCON: "http://api.census.gov/data/2017/ecnvalcon",
    EWKS: "http://api.census.gov/data/2012/ewks",
    GEOINFO: "http://api.census.gov/data/2023/geoinfo",
    INTLTRADE_IMP_EXP: "http://api.census.gov/data/2018/intltrade/imp_exp",
    LANGUAGE: "http://api.census.gov/data/2013/language",
    NONEMP: "http://api.census.gov/data/2023/nonemp",
    PDB_BLOCKGROUP: "http://api.census.gov/data/2023/pdb/blockgroup",
    PDB_STATECOUNTY: "http://api.census.gov/data/2020/pdb/statecounty",
    PDB_TRACT: "http://api.census.gov/data/2023/pdb/tract",
    PEP_AGESEX: "http://api.census.gov/data/2014/pep/agesex",
    PEP_AGESPECIAL5: "http://api.census.gov/data/2014/pep/agespecial5",
    PEP_AGESPECIAL6: "http://api.census.gov/data/2014/pep/agespecial6",
    PEP_AGESPECIALPR: "http://api.census.gov/data/2014/pep/agespecialpr",
    PEP_CHARAGE: "http://api.census.gov/data/2019/pep/charage",
    PEP_CHARAGEGROUPS: "http://api.census.gov/data/2019/pep/charagegroups",
    PEP_CHARV: "http://api.census.gov/data/2023/pep/charv",
    PEP_COCHAR5: "http://api.census.gov/data/2014/pep/cochar5",
    PEP_COCHAR6: "http://api.census.gov/data/2014/pep/cochar6",
    PEP_COMPONENTS: "http://api.census.gov/data/2019/pep/components",
    PEP_CTY: "http://api.census.gov/data/2014/pep/cty",
    PEP_HOUSING: "http://api.census.gov/data/2019/pep/housing",
    PEP_INT_CHARAGE: "http://api.census.gov/data/2000/pep/int_charage",
    PEP_INT_CHARAGEGROUPS: "http://api.census.gov/data/2000/pep/int_charagegroups",
    PEP_INT_HOUSINGUNITS: "http://api.census.gov/data/2000/pep/int_housingunits",
    PEP_INT_NATCIVPOP: "http://api.census.gov/data/1990/pep/int_natcivpop",
    PEP_INT_NATMONTHLY: "http://api.census.gov/data/2000/pep/int_natmonthly",
    PEP_INT_NATRESAFO: "http://api.census.gov/data/1990/pep/int_natresafo",
    PEP_INT_NATRESPOP: "http://api.census.gov/data/1990/pep/int_natrespop",
    PEP_INT_POPULATION: "http://api.census.gov/data/2000/pep/int_population",
    PEP_MONTHLYNATCHAR5: "http://api.census.gov/data/2014/pep/monthlynatchar5",
    PEP_MONTHLYNATCHAR6: "http://api.census.gov/data/2014/pep/monthlynatchar6",
    PEP_NATMONTHLY: "http://api.census.gov/data/2021/pep/natmonthly",
    PEP_NATSTPRC: "http://api.census.gov/data/2014/pep/natstprc",
    PEP_NATSTPRC18: "http://api.census.gov/data/2014/pep/natstprc18",
    PEP_POPULATION: "http://api.census.gov/data/2021/pep/population",
    PEP_PRCAGESEX: "http://api.census.gov/data/2014/pep/prcagesex",
    PEP_PRM: "http://api.census.gov/data/2014/pep/prm",
    PEP_PRMAGESEX: "http://api.census.gov/data/2014/pep/prmagesex",
    PEP_PROJAGEGROUPS: "http://api.census.gov/data/2014/pep/projagegroups",
    PEP_PROJBIRTHS: "http://api.census.gov/data/2014/pep/projbirths",
    PEP_PROJDEATHS: "http://api.census.gov/data/2014/pep/projdeaths",
    PEP_PROJNAT: "http://api.census.gov/data/2014/pep/projnat",
    PEP_PROJNIM: "http://api.census.gov/data/2014/pep/projnim",
    PEP_PROJPOP: "http://api.census.gov/data/2014/pep/projpop",
    PEP_STCHAR5: "http://api.census.gov/data/2014/pep/stchar5",
    PEP_STCHAR6: "http://api.census.gov/data/2014/pep/stchar6",
    PEP_SUBCTY: "http://api.census.gov/data/2014/pep/subcty",
    POPPROJ: "http://api.census.gov/data/2017/popproj/pop",
    POPPROJ_AGEGROUPS: "http://api.census.gov/data/2017/popproj/agegroups",
    POPPROJ_BIRTHS: "http://api.census.gov/data/2017/popproj/births",
    POPPROJ_DEATHS: "http://api.census.gov/data/2017/popproj/deaths",
    POPPROJ_NAT: "http://api.census.gov/data/2017/popproj/nat",
    POPPROJ_NIM: "http://api.census.gov/data/2017/popproj/nim",
    PUBLIC_PK12_EDUCATION_FINANCE: "http://api.census.gov/data/2012/pubschlfin",
    RHFS: "http://api.census.gov/data/2021/rhfs",
    SBO_CS: "http://api.census.gov/data/2012/sbo/cs",
    SBO_CSCB: "http://api.census.gov/data/2012/sbo/cscb",
    SBO_CSCBO: "http://api.census.gov/data/2012/sbo/cscbo",
    SIPP: "http://api.census.gov/data/2023/sipp",
    SIPP_BENEFIT: "http://api.census.gov/data/1991/sipp/benefit/1991panel",
    SIPP_CORE: "http://api.census.gov/data/2008/sipp/core/2008panel/wave9",
    SIPP_TOPICAL: "http://api.census.gov/data/2008/sipp/topical/2008panel/wave9",
    SIPP_TOPICALED: "http://api.census.gov/data/1993/sipp/topicaled/1993panel/wave8",
    SIPP_TOPICALEDEX: "http://api.census.gov/data/1993/sipp/topicaledex/1993panel/wave8",
    SIPP_TOPICALEX: "http://api.census.gov/data/1993/sipp/topicalex/1993panel/wave3",
    SIPP_TOPICALRES: "http://api.census.gov/data/2001/sipp/topicalres/2001panel/wave8",
    TIMESERIES_ASM: "http://api.census.gov/data/timeseries/asm/value2017",
    TIMESERIES_BDS: "http://api.census.gov/data/timeseries/bds",
    TIMESERIES_EITS: "http://api.census.gov/data/timeseries/eits/vip",
    TIMESERIES_GOVS: "http://api.census.gov/data/timeseries/govs",
    TIMESERIES_HEALTHINS: "http://api.census.gov/data/timeseries/healthins/sahie",
    TIMESERIES_HHPULSE: "http://api.census.gov/data/timeseries/hhpulse",
    TIMESERIES_HPS: "http://api.census.gov/data/timeseries/hps",
    TIMESERIES_IDB: "http://api.census.gov/data/timeseries/idb/5year",
    TIMESERIES_INTLTRADE: "http://api.census.gov/data/timeseries/intltrade/imports/usdaimport",
    TIMESERIES_POVERTY: "http://api.census.gov/data/timeseries/poverty/saipe/schdist",
    TIMESERIES_PSEO: "http://api.census.gov/data/timeseries/pseo/flows",
    TIMESERIES_QWI: "http://api.census.gov/data/timeseries/qwi/se",
    TIMESERIES_SOMA: "http://api.census.gov/data/timeseries/soma",
    VIUSA: "http://api.census.gov/data/2021/viusa",
    VIUSB: "http://api.census.gov/data/2021/viusb",
    VIUSC: "http://api.census.gov/data/2021/viusc",
    VIUSD: "http://api.census.gov/data/2021/viusd",
    VIUSE: "http://api.census.gov/data/2021/viuse",
    VIUSF: "http://api.census.gov/data/2021/viusf",
    VIUSPUF: "http://api.census.gov/data/2021/viuspuf",
    ZBP: "http://api.census.gov/data/2018/zbp",
}

# LODES are special data sets with their own base URL.

LODES_OD_MAIN_JT00 = "lodes/od/main/jt00"

LODES_OD_MAIN_JT01 = "lodes/od/main/jt01"

LODES_OD_MAIN_JT02 = "lodes/od/main/jt02"

LODES_OD_MAIN_JT03 = "lodes/od/main/jt03"

LODES_OD_MAIN_JT04 = "lodes/od/main/jt04"

LODES_OD_MAIN_JT05 = "lodes/od/main/jt05"

LODES_OD_AUX_JT00 = "lodes/od/aux/jt00"

LODES_OD_AUX_JT01 = "lodes/od/aux/jt01"

LODES_OD_AUX_JT02 = "lodes/od/aux/jt02"

LODES_OD_AUX_JT03 = "lodes/od/aux/jt03"

LODES_OD_AUX_JT04 = "lodes/od/aux/jt04"

LODES_OD_AUX_JT05 = "lodes/od/aux/jt05"

LODES_RAC_S000_JT00 = "lodes/rac/s000/jt00"

LODES_RAC_S000_JT01 = "lodes/rac/s000/jt01"

LODES_RAC_S000_JT02 = "lodes/rac/s000/jt02"

LODES_RAC_S000_JT03 = "lodes/rac/s000/jt03"

LODES_RAC_S000_JT04 = "lodes/rac/s000/jt04"

LODES_RAC_S000_JT05 = "lodes/rac/s000/jt05"

LODES_RAC_SA01_JT00 = "lodes/rac/sa01/jt00"

LODES_RAC_SA01_JT01 = "lodes/rac/sa01/jt01"

LODES_RAC_SA01_JT02 = "lodes/rac/sa01/jt02"

LODES_RAC_SA01_JT03 = "lodes/rac/sa01/jt03"

LODES_RAC_SA01_JT04 = "lodes/rac/sa01/jt04"

LODES_RAC_SA01_JT05 = "lodes/rac/sa01/jt05"

LODES_RAC_SA02_JT00 = "lodes/rac/sa02/jt00"

LODES_RAC_SA02_JT01 = "lodes/rac/sa02/jt01"

LODES_RAC_SA02_JT02 = "lodes/rac/sa02/jt02"

LODES_RAC_SA02_JT03 = "lodes/rac/sa02/jt03"

LODES_RAC_SA02_JT04 = "lodes/rac/sa02/jt04"

LODES_RAC_SA02_JT05 = "lodes/rac/sa02/jt05"

LODES_RAC_SA03_JT00 = "lodes/rac/sa03/jt00"

LODES_RAC_SA03_JT01 = "lodes/rac/sa03/jt01"

LODES_RAC_SA03_JT02 = "lodes/rac/sa03/jt02"

LODES_RAC_SA03_JT03 = "lodes/rac/sa03/jt03"

LODES_RAC_SA03_JT04 = "lodes/rac/sa03/jt04"

LODES_RAC_SA03_JT05 = "lodes/rac/sa03/jt05"

LODES_RAC_SE01_JT00 = "lodes/rac/se01/jt00"

LODES_RAC_SE01_JT01 = "lodes/rac/se01/jt01"

LODES_RAC_SE01_JT02 = "lodes/rac/se01/jt02"

LODES_RAC_SE01_JT03 = "lodes/rac/se01/jt03"

LODES_RAC_SE01_JT04 = "lodes/rac/se01/jt04"

LODES_RAC_SE01_JT05 = "lodes/rac/se01/jt05"

LODES_RAC_SE02_JT00 = "lodes/rac/se02/jt00"

LODES_RAC_SE02_JT01 = "lodes/rac/se02/jt01"

LODES_RAC_SE02_JT02 = "lodes/rac/se02/jt02"

LODES_RAC_SE02_JT03 = "lodes/rac/se02/jt03"

LODES_RAC_SE02_JT04 = "lodes/rac/se02/jt04"

LODES_RAC_SE02_JT05 = "lodes/rac/se02/jt05"

LODES_RAC_SE03_JT00 = "lodes/rac/se03/jt00"

LODES_RAC_SE03_JT01 = "lodes/rac/se03/jt01"

LODES_RAC_SE03_JT02 = "lodes/rac/se03/jt02"

LODES_RAC_SE03_JT03 = "lodes/rac/se03/jt03"

LODES_RAC_SE03_JT04 = "lodes/rac/se03/jt04"

LODES_RAC_SE03_JT05 = "lodes/rac/se03/jt05"

LODES_RAC_SI01_JT00 = "lodes/rac/si01/jt00"

LODES_RAC_SI01_JT01 = "lodes/rac/si01/jt01"

LODES_RAC_SI01_JT02 = "lodes/rac/si01/jt02"

LODES_RAC_SI01_JT03 = "lodes/rac/si01/jt03"

LODES_RAC_SI01_JT04 = "lodes/rac/si01/jt04"

LODES_RAC_SI01_JT05 = "lodes/rac/si01/jt05"

LODES_RAC_SI02_JT00 = "lodes/rac/si02/jt00"

LODES_RAC_SI02_JT01 = "lodes/rac/si02/jt01"

LODES_RAC_SI02_JT02 = "lodes/rac/si02/jt02"

LODES_RAC_SI02_JT03 = "lodes/rac/si02/jt03"

LODES_RAC_SI02_JT04 = "lodes/rac/si02/jt04"

LODES_RAC_SI02_JT05 = "lodes/rac/si02/jt05"

LODES_RAC_SI03_JT00 = "lodes/rac/si03/jt00"

LODES_RAC_SI03_JT01 = "lodes/rac/si03/jt01"

LODES_RAC_SI03_JT02 = "lodes/rac/si03/jt02"

LODES_RAC_SI03_JT03 = "lodes/rac/si03/jt03"

LODES_RAC_SI03_JT04 = "lodes/rac/si03/jt04"

LODES_RAC_SI03_JT05 = "lodes/rac/si03/jt05"

LODES_WAC_S000_JT00 = "lodes/wac/s000/jt00"

LODES_WAC_S000_JT01 = "lodes/wac/s000/jt01"

LODES_WAC_S000_JT02 = "lodes/wac/s000/jt02"

LODES_WAC_S000_JT03 = "lodes/wac/s000/jt03"

LODES_WAC_S000_JT04 = "lodes/wac/s000/jt04"

LODES_WAC_S000_JT05 = "lodes/wac/s000/jt05"

LODES_WAC_SA01_JT00 = "lodes/wac/sa01/jt00"

LODES_WAC_SA01_JT01 = "lodes/wac/sa01/jt01"

LODES_WAC_SA01_JT02 = "lodes/wac/sa01/jt02"

LODES_WAC_SA01_JT03 = "lodes/wac/sa01/jt03"

LODES_WAC_SA01_JT04 = "lodes/wac/sa01/jt04"

LODES_WAC_SA01_JT05 = "lodes/wac/sa01/jt05"

LODES_WAC_SA02_JT00 = "lodes/wac/sa02/jt00"

LODES_WAC_SA02_JT01 = "lodes/wac/sa02/jt01"

LODES_WAC_SA02_JT02 = "lodes/wac/sa02/jt02"

LODES_WAC_SA02_JT03 = "lodes/wac/sa02/jt03"

LODES_WAC_SA02_JT04 = "lodes/wac/sa02/jt04"

LODES_WAC_SA02_JT05 = "lodes/wac/sa02/jt05"

LODES_WAC_SA03_JT00 = "lodes/wac/sa03/jt00"

LODES_WAC_SA03_JT01 = "lodes/wac/sa03/jt01"

LODES_WAC_SA03_JT02 = "lodes/wac/sa03/jt02"

LODES_WAC_SA03_JT03 = "lodes/wac/sa03/jt03"

LODES_WAC_SA03_JT04 = "lodes/wac/sa03/jt04"

LODES_WAC_SA03_JT05 = "lodes/wac/sa03/jt05"

LODES_WAC_SE01_JT00 = "lodes/wac/se01/jt00"

LODES_WAC_SE01_JT01 = "lodes/wac/se01/jt01"

LODES_WAC_SE01_JT02 = "lodes/wac/se01/jt02"

LODES_WAC_SE01_JT03 = "lodes/wac/se01/jt03"

LODES_WAC_SE01_JT04 = "lodes/wac/se01/jt04"

LODES_WAC_SE01_JT05 = "lodes/wac/se01/jt05"

LODES_WAC_SE02_JT00 = "lodes/wac/se02/jt00"

LODES_WAC_SE02_JT01 = "lodes/wac/se02/jt01"

LODES_WAC_SE02_JT02 = "lodes/wac/se02/jt02"

LODES_WAC_SE02_JT03 = "lodes/wac/se02/jt03"

LODES_WAC_SE02_JT04 = "lodes/wac/se02/jt04"

LODES_WAC_SE02_JT05 = "lodes/wac/se02/jt05"

LODES_WAC_SE03_JT00 = "lodes/wac/se03/jt00"

LODES_WAC_SE03_JT01 = "lodes/wac/se03/jt01"

LODES_WAC_SE03_JT02 = "lodes/wac/se03/jt02"

LODES_WAC_SE03_JT03 = "lodes/wac/se03/jt03"

LODES_WAC_SE03_JT04 = "lodes/wac/se03/jt04"

LODES_WAC_SE03_JT05 = "lodes/wac/se03/jt05"

LODES_WAC_SI01_JT00 = "lodes/wac/si01/jt00"

LODES_WAC_SI01_JT01 = "lodes/wac/si01/jt01"

LODES_WAC_SI01_JT02 = "lodes/wac/si01/jt02"

LODES_WAC_SI01_JT03 = "lodes/wac/si01/jt03"

LODES_WAC_SI01_JT04 = "lodes/wac/si01/jt04"

LODES_WAC_SI01_JT05 = "lodes/wac/si01/jt05"

LODES_WAC_SI02_JT00 = "lodes/wac/si02/jt00"

LODES_WAC_SI02_JT01 = "lodes/wac/si02/jt01"

LODES_WAC_SI02_JT02 = "lodes/wac/si02/jt02"

LODES_WAC_SI02_JT03 = "lodes/wac/si02/jt03"

LODES_WAC_SI02_JT04 = "lodes/wac/si02/jt04"

LODES_WAC_SI02_JT05 = "lodes/wac/si02/jt05"

LODES_WAC_SI03_JT00 = "lodes/wac/si03/jt00"

LODES_WAC_SI03_JT01 = "lodes/wac/si03/jt01"

LODES_WAC_SI03_JT02 = "lodes/wac/si03/jt02"

LODES_WAC_SI03_JT03 = "lodes/wac/si03/jt03"

LODES_WAC_SI03_JT04 = "lodes/wac/si03/jt04"

LODES_WAC_SI03_JT05 = "lodes/wac/si03/jt05"


ALL_LODES_DATA_SETS = [
    LODES_OD_MAIN_JT00,
    LODES_OD_MAIN_JT01,
    LODES_OD_MAIN_JT02,
    LODES_OD_MAIN_JT03,
    LODES_OD_MAIN_JT04,
    LODES_OD_MAIN_JT05,
    LODES_OD_AUX_JT00,
    LODES_OD_AUX_JT01,
    LODES_OD_AUX_JT02,
    LODES_OD_AUX_JT03,
    LODES_OD_AUX_JT04,
    LODES_OD_AUX_JT05,
    LODES_RAC_S000_JT00,
    LODES_RAC_S000_JT01,
    LODES_RAC_S000_JT02,
    LODES_RAC_S000_JT03,
    LODES_RAC_S000_JT04,
    LODES_RAC_S000_JT05,
    LODES_RAC_SA01_JT00,
    LODES_RAC_SA01_JT01,
    LODES_RAC_SA01_JT02,
    LODES_RAC_SA01_JT03,
    LODES_RAC_SA01_JT04,
    LODES_RAC_SA01_JT05,
    LODES_RAC_SA02_JT00,
    LODES_RAC_SA02_JT01,
    LODES_RAC_SA02_JT02,
    LODES_RAC_SA02_JT03,
    LODES_RAC_SA02_JT04,
    LODES_RAC_SA02_JT05,
    LODES_RAC_SA03_JT00,
    LODES_RAC_SA03_JT01,
    LODES_RAC_SA03_JT02,
    LODES_RAC_SA03_JT03,
    LODES_RAC_SA03_JT04,
    LODES_RAC_SA03_JT05,
    LODES_RAC_SE01_JT00,
    LODES_RAC_SE01_JT01,
    LODES_RAC_SE01_JT02,
    LODES_RAC_SE01_JT03,
    LODES_RAC_SE01_JT04,
    LODES_RAC_SE01_JT05,
    LODES_RAC_SE02_JT00,
    LODES_RAC_SE02_JT01,
    LODES_RAC_SE02_JT02,
    LODES_RAC_SE02_JT03,
    LODES_RAC_SE02_JT04,
    LODES_RAC_SE02_JT05,
    LODES_RAC_SE03_JT00,
    LODES_RAC_SE03_JT01,
    LODES_RAC_SE03_JT02,
    LODES_RAC_SE03_JT03,
    LODES_RAC_SE03_JT04,
    LODES_RAC_SE03_JT05,
    LODES_RAC_SI01_JT00,
    LODES_RAC_SI01_JT01,
    LODES_RAC_SI01_JT02,
    LODES_RAC_SI01_JT03,
    LODES_RAC_SI01_JT04,
    LODES_RAC_SI01_JT05,
    LODES_RAC_SI02_JT00,
    LODES_RAC_SI02_JT01,
    LODES_RAC_SI02_JT02,
    LODES_RAC_SI02_JT03,
    LODES_RAC_SI02_JT04,
    LODES_RAC_SI02_JT05,
    LODES_RAC_SI03_JT00,
    LODES_RAC_SI03_JT01,
    LODES_RAC_SI03_JT02,
    LODES_RAC_SI03_JT03,
    LODES_RAC_SI03_JT04,
    LODES_RAC_SI03_JT05,
    LODES_WAC_S000_JT00,
    LODES_WAC_S000_JT01,
    LODES_WAC_S000_JT02,
    LODES_WAC_S000_JT03,
    LODES_WAC_S000_JT04,
    LODES_WAC_S000_JT05,
    LODES_WAC_SA01_JT00,
    LODES_WAC_SA01_JT01,
    LODES_WAC_SA01_JT02,
    LODES_WAC_SA01_JT03,
    LODES_WAC_SA01_JT04,
    LODES_WAC_SA01_JT05,
    LODES_WAC_SA02_JT00,
    LODES_WAC_SA02_JT01,
    LODES_WAC_SA02_JT02,
    LODES_WAC_SA02_JT03,
    LODES_WAC_SA02_JT04,
    LODES_WAC_SA02_JT05,
    LODES_WAC_SA03_JT00,
    LODES_WAC_SA03_JT01,
    LODES_WAC_SA03_JT02,
    LODES_WAC_SA03_JT03,
    LODES_WAC_SA03_JT04,
    LODES_WAC_SA03_JT05,
    LODES_WAC_SE01_JT00,
    LODES_WAC_SE01_JT01,
    LODES_WAC_SE01_JT02,
    LODES_WAC_SE01_JT03,
    LODES_WAC_SE01_JT04,
    LODES_WAC_SE01_JT05,
    LODES_WAC_SE02_JT00,
    LODES_WAC_SE02_JT01,
    LODES_WAC_SE02_JT02,
    LODES_WAC_SE02_JT03,
    LODES_WAC_SE02_JT04,
    LODES_WAC_SE02_JT05,
    LODES_WAC_SE03_JT00,
    LODES_WAC_SE03_JT01,
    LODES_WAC_SE03_JT02,
    LODES_WAC_SE03_JT03,
    LODES_WAC_SE03_JT04,
    LODES_WAC_SE03_JT05,
    LODES_WAC_SI01_JT00,
    LODES_WAC_SI01_JT01,
    LODES_WAC_SI01_JT02,
    LODES_WAC_SI01_JT03,
    LODES_WAC_SI01_JT04,
    LODES_WAC_SI01_JT05,
    LODES_WAC_SI02_JT00,
    LODES_WAC_SI02_JT01,
    LODES_WAC_SI02_JT02,
    LODES_WAC_SI02_JT03,
    LODES_WAC_SI02_JT04,
    LODES_WAC_SI02_JT05,
    LODES_WAC_SI03_JT00,
    LODES_WAC_SI03_JT01,
    LODES_WAC_SI03_JT02,
    LODES_WAC_SI03_JT03,
    LODES_WAC_SI03_JT04,
    LODES_WAC_SI03_JT05,
]
