// This file is auto-generated by scripts/mysetting_bindings.py

use pyo3::prelude::*;
use pyo3::types::PyType;
use rbox::settings::*;

use super::errors::SettingError;

#[pyclass(unsendable)]
pub struct PySetting {
    setting: Setting,
}

#[pymethods]
impl PySetting {
    #[new]
    pub fn new(path: &str) -> PyResult<Self> {
        let setting =
            Setting::load(path).map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(PySetting { setting })
    }

    #[classmethod]
    pub fn new_mysetting(_cls: &Bound<'_, PyType>, path: &str) -> PyResult<Self> {
        let setting = Setting::new_mysetting(path)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(PySetting { setting })
    }

    #[classmethod]
    pub fn new_mysetting2(_cls: &Bound<'_, PyType>, path: &str) -> PyResult<Self> {
        let setting = Setting::new_mysetting2(path)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(PySetting { setting })
    }

    #[classmethod]
    pub fn new_djmmysetting(_cls: &Bound<'_, PyType>, path: &str) -> PyResult<Self> {
        let setting = Setting::new_djmmysetting(path)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(PySetting { setting })
    }

    #[classmethod]
    pub fn new_devsetting(_cls: &Bound<'_, PyType>, path: &str) -> PyResult<Self> {
        let setting = Setting::new_devsetting(path)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(PySetting { setting })
    }

    #[classmethod]
    pub fn load(_cls: &Bound<'_, PyType>, path: &str) -> PyResult<Self> {
        let setting =
            Setting::load(path).map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(PySetting { setting })
    }

    pub fn dump_copy(&mut self, path: &str) -> PyResult<()> {
        self.setting
            .dump_copy(path)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn dump(&mut self) -> PyResult<()> {
        self.setting
            .dump()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_on_air_display(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_on_air_display()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_on_air_display(&mut self, on_air_display: &str) -> PyResult<()> {
        let value = OnAirDisplay::try_from(on_air_display.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_on_air_display(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_lcd_brightness(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_lcd_brightness()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_lcd_brightness(&mut self, lcd_brightness: &str) -> PyResult<()> {
        let value = LCDBrightness::try_from(lcd_brightness.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_lcd_brightness(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_quantize(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_quantize()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_quantize(&mut self, quantize: &str) -> PyResult<()> {
        let value = Quantize::try_from(quantize.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_quantize(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_auto_cue_level(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_auto_cue_level()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_auto_cue_level(&mut self, auto_cue_level: &str) -> PyResult<()> {
        let value = AutoCueLevel::try_from(auto_cue_level.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_auto_cue_level(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_language(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_language()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_language(&mut self, language: &str) -> PyResult<()> {
        let value = Language::try_from(language.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_language(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_jog_ring_brightness(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_jog_ring_brightness()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_jog_ring_brightness(&mut self, jog_ring_brightness: &str) -> PyResult<()> {
        let value = JogRingBrightness::try_from(jog_ring_brightness.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_jog_ring_brightness(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_jog_ring_indicator(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_jog_ring_indicator()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_jog_ring_indicator(&mut self, jog_ring_indicator: &str) -> PyResult<()> {
        let value = JogRingIndicator::try_from(jog_ring_indicator.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_jog_ring_indicator(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_slip_flashing(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_slip_flashing()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_slip_flashing(&mut self, slip_flashing: &str) -> PyResult<()> {
        let value = SlipFlashing::try_from(slip_flashing.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_slip_flashing(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_disc_slot_illumination(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_disc_slot_illumination()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_disc_slot_illumination(&mut self, disc_slot_illumination: &str) -> PyResult<()> {
        let value = DiscSlotIllumination::try_from(disc_slot_illumination.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_disc_slot_illumination(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_eject_lock(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_eject_lock()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_eject_lock(&mut self, eject_lock: &str) -> PyResult<()> {
        let value = EjectLock::try_from(eject_lock.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_eject_lock(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_sync(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_sync()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_sync(&mut self, sync: &str) -> PyResult<()> {
        let value = Sync::try_from(sync.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_sync(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_play_mode(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_play_mode()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_play_mode(&mut self, play_mode: &str) -> PyResult<()> {
        let value = PlayMode::try_from(play_mode.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_play_mode(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_quantize_beat_value(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_quantize_beat_value()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_quantize_beat_value(&mut self, quantize_beat_value: &str) -> PyResult<()> {
        let value = QuantizeBeatValue::try_from(quantize_beat_value.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_quantize_beat_value(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_hotcue_autoload(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_hotcue_autoload()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_hotcue_autoload(&mut self, hotcue_autoload: &str) -> PyResult<()> {
        let value = HotCueAutoLoad::try_from(hotcue_autoload.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_hotcue_autoload(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_hotcue_color(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_hotcue_color()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_hotcue_color(&mut self, hotcue_color: &str) -> PyResult<()> {
        let value = HotCueColor::try_from(hotcue_color.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_hotcue_color(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_needle_lock(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_needle_lock()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_needle_lock(&mut self, needle_lock: &str) -> PyResult<()> {
        let value = NeedleLock::try_from(needle_lock.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_needle_lock(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_time_mode(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_time_mode()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_time_mode(&mut self, time_mode: &str) -> PyResult<()> {
        let value = TimeMode::try_from(time_mode.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_time_mode(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_jog_mode(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_jog_mode()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_jog_mode(&mut self, jog_mode: &str) -> PyResult<()> {
        let value = JogMode::try_from(jog_mode.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_jog_mode(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_auto_cue(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_auto_cue()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_auto_cue(&mut self, auto_cue: &str) -> PyResult<()> {
        let value = AutoCue::try_from(auto_cue.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_auto_cue(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_master_tempo(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_master_tempo()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_master_tempo(&mut self, master_tempo: &str) -> PyResult<()> {
        let value = MasterTempo::try_from(master_tempo.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_master_tempo(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_tempo_range(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_tempo_range()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_tempo_range(&mut self, tempo_range: &str) -> PyResult<()> {
        let value = TempoRange::try_from(tempo_range.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_tempo_range(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_phase_meter(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_phase_meter()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_phase_meter(&mut self, phase_meter: &str) -> PyResult<()> {
        let value = PhaseMeter::try_from(phase_meter.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_phase_meter(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_vinyl_speed_adjust(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_vinyl_speed_adjust()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_vinyl_speed_adjust(&mut self, vinyl_speed_adjust: &str) -> PyResult<()> {
        let value = VinylSpeedAdjust::try_from(vinyl_speed_adjust.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_vinyl_speed_adjust(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_jog_display_mode(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_jog_display_mode()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_jog_display_mode(&mut self, jog_display_mode: &str) -> PyResult<()> {
        let value = JogDisplayMode::try_from(jog_display_mode.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_jog_display_mode(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_pad_button_brightness(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_pad_button_brightness()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_pad_button_brightness(&mut self, pad_button_brightness: &str) -> PyResult<()> {
        let value = PadButtonBrightness::try_from(pad_button_brightness.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_pad_button_brightness(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_jog_lcd_brightness(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_jog_lcd_brightness()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_jog_lcd_brightness(&mut self, jog_lcd_brightness: &str) -> PyResult<()> {
        let value = JogLCDBrightness::try_from(jog_lcd_brightness.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_jog_lcd_brightness(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_waveform_divisions(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_waveform_divisions()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_waveform_divisions(&mut self, waveform_divisions: &str) -> PyResult<()> {
        let value = WaveformDivisions::try_from(waveform_divisions.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_waveform_divisions(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_waveform(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_waveform()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_waveform(&mut self, waveform: &str) -> PyResult<()> {
        let value = Waveform::try_from(waveform.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_waveform(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_beat_jump_beat_value(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_beat_jump_beat_value()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_beat_jump_beat_value(&mut self, beat_jump_beat_value: &str) -> PyResult<()> {
        let value = BeatJumpBeatValue::try_from(beat_jump_beat_value.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_beat_jump_beat_value(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_channel_fader_curve(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_channel_fader_curve()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_channel_fader_curve(&mut self, channel_fader_curve: &str) -> PyResult<()> {
        let value = ChannelFaderCurve::try_from(channel_fader_curve.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_channel_fader_curve(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_crossfader_curve(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_crossfader_curve()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_crossfader_curve(&mut self, crossfader_curve: &str) -> PyResult<()> {
        let value = CrossfaderCurve::try_from(crossfader_curve.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_crossfader_curve(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_headphones_pre_eq(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_headphones_pre_eq()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_headphones_pre_eq(&mut self, headphones_pre_eq: &str) -> PyResult<()> {
        let value = HeadphonesPreEQ::try_from(headphones_pre_eq.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_headphones_pre_eq(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_headphones_mono_split(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_headphones_mono_split()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_headphones_mono_split(&mut self, headphones_mono_split: &str) -> PyResult<()> {
        let value = HeadphonesMonoSplit::try_from(headphones_mono_split.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_headphones_mono_split(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_beat_fx_quantize(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_beat_fx_quantize()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_beat_fx_quantize(&mut self, beat_fx_quantize: &str) -> PyResult<()> {
        let value = BeatFXQuantize::try_from(beat_fx_quantize.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_beat_fx_quantize(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_mic_low_cut(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_mic_low_cut()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_mic_low_cut(&mut self, mic_low_cut: &str) -> PyResult<()> {
        let value = MicLowCut::try_from(mic_low_cut.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_mic_low_cut(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_talk_over_mode(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_talk_over_mode()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_talk_over_mode(&mut self, talk_over_mode: &str) -> PyResult<()> {
        let value = TalkOverMode::try_from(talk_over_mode.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_talk_over_mode(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_talk_over_level(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_talk_over_level()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_talk_over_level(&mut self, talk_over_level: &str) -> PyResult<()> {
        let value = TalkOverLevel::try_from(talk_over_level.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_talk_over_level(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_midi_channel(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_midi_channel()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_midi_channel(&mut self, midi_channel: &str) -> PyResult<()> {
        let value = MidiChannel::try_from(midi_channel.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_midi_channel(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_midi_button_type(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_midi_button_type()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_midi_button_type(&mut self, midi_button_type: &str) -> PyResult<()> {
        let value = MidiButtonType::try_from(midi_button_type.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_midi_button_type(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_mixer_display_brightness(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_mixer_display_brightness()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_mixer_display_brightness(&mut self, mixer_display_brightness: &str) -> PyResult<()> {
        let value = MixerDisplayBrightness::try_from(mixer_display_brightness.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_mixer_display_brightness(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_mixer_indicator_brightness(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_mixer_indicator_brightness()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_mixer_indicator_brightness(
        &mut self,
        mixer_indicator_brightness: &str,
    ) -> PyResult<()> {
        let value = MixerIndicatorBrightness::try_from(mixer_indicator_brightness.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_mixer_indicator_brightness(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_channel_fader_curve_long_fader(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_channel_fader_curve_long_fader()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_channel_fader_curve_long_fader(
        &mut self,
        channel_fader_curve_long_fader: &str,
    ) -> PyResult<()> {
        let value =
            ChannelFaderCurveLongFader::try_from(channel_fader_curve_long_fader.to_string())
                .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_channel_fader_curve_long_fader(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_overview_waveform_type(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_overview_waveform_type()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_overview_waveform_type(&mut self, overview_waveform_type: &str) -> PyResult<()> {
        let value = OverviewWaveformType::try_from(overview_waveform_type.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_overview_waveform_type(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_waveform_color(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_waveform_color()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_waveform_color(&mut self, waveform_color: &str) -> PyResult<()> {
        let value = WaveformColor::try_from(waveform_color.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_waveform_color(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_key_display_format(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_key_display_format()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_key_display_format(&mut self, key_display_format: &str) -> PyResult<()> {
        let value = KeyDisplayFormat::try_from(key_display_format.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_key_display_format(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }

    pub fn get_waveform_current_position(&self) -> PyResult<String> {
        let value = self
            .setting
            .get_waveform_current_position()
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(value.to_string())
    }

    pub fn set_waveform_current_position(
        &mut self,
        waveform_current_position: &str,
    ) -> PyResult<()> {
        let value = WaveformCurrentPosition::try_from(waveform_current_position.to_string())
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        self.setting
            .set_waveform_current_position(value)
            .map_err(|e| PyErr::new::<SettingError, _>(e.to_string()))?;
        Ok(())
    }
}
