# This file is auto-generated by scripts/mysetting_bindings.py

from enum import Enum
from typing import Union

from ._rbox import PySetting as _PySetting


class OnAirDisplay(str, Enum):
    Off = "Off"
    On = "On"


class LCDBrightness(str, Enum):
    One = "One"
    Two = "Two"
    Three = "Three"
    Four = "Four"
    Five = "Five"


class Quantize(str, Enum):
    Off = "Off"
    On = "On"


class AutoCueLevel(str, Enum):
    Minus78dB = "Minus78dB"
    Minus72dB = "Minus72dB"
    Minus66dB = "Minus66dB"
    Minus60dB = "Minus60dB"
    Minus54dB = "Minus54dB"
    Minus48dB = "Minus48dB"
    Minus42dB = "Minus42dB"
    Minus36dB = "Minus36dB"
    Memory = "Memory"


class Language(str, Enum):
    English = "English"
    French = "French"
    German = "German"
    Italian = "Italian"
    Dutch = "Dutch"
    Spanish = "Spanish"
    Russian = "Russian"
    Korean = "Korean"
    ChineseSimplified = "ChineseSimplified"
    ChineseTraditional = "ChineseTraditional"
    Japanese = "Japanese"
    Portuguese = "Portuguese"
    Swedish = "Swedish"
    Czech = "Czech"
    Hungarian = "Hungarian"
    Danish = "Danish"
    Greek = "Greek"
    Turkish = "Turkish"


class JogRingBrightness(str, Enum):
    Off = "Off"
    Dark = "Dark"
    Bright = "Bright"


class JogRingIndicator(str, Enum):
    Off = "Off"
    On = "On"


class SlipFlashing(str, Enum):
    Off = "Off"
    On = "On"


class DiscSlotIllumination(str, Enum):
    Off = "Off"
    Dark = "Dark"
    Bright = "Bright"


class EjectLock(str, Enum):
    Unlock = "Unlock"
    Lock = "Lock"


class Sync(str, Enum):
    Off = "Off"
    On = "On"


class PlayMode(str, Enum):
    Continue = "Continue"
    Single = "Single"


class QuantizeBeatValue(str, Enum):
    EighthBeat = "EighthBeat"
    QuarterBeat = "QuarterBeat"
    HalfBeat = "HalfBeat"
    FullBeat = "FullBeat"


class HotCueAutoLoad(str, Enum):
    Off = "Off"
    RekordboxSetting = "RekordboxSetting"
    On = "On"


class HotCueColor(str, Enum):
    Off = "Off"
    On = "On"


class NeedleLock(str, Enum):
    Unlock = "Unlock"
    Lock = "Lock"


class TimeMode(str, Enum):
    Elapsed = "Elapsed"
    Remain = "Remain"


class JogMode(str, Enum):
    Vinyl = "Vinyl"
    CDJ = "CDJ"


class AutoCue(str, Enum):
    Off = "Off"
    On = "On"


class MasterTempo(str, Enum):
    Off = "Off"
    On = "On"


class TempoRange(str, Enum):
    SixPercent = "SixPercent"
    TenPercent = "TenPercent"
    SixteenPercent = "SixteenPercent"
    Wide = "Wide"


class PhaseMeter(str, Enum):
    Type1 = "Type1"
    Type2 = "Type2"


class VinylSpeedAdjust(str, Enum):
    TouchRelease = "TouchRelease"
    Touch = "Touch"
    Release = "Release"


class JogDisplayMode(str, Enum):
    Auto = "Auto"
    Info = "Info"
    Simple = "Simple"
    Artwork = "Artwork"


class PadButtonBrightness(str, Enum):
    One = "One"
    Two = "Two"
    Three = "Three"
    Four = "Four"


class JogLCDBrightness(str, Enum):
    One = "One"
    Two = "Two"
    Three = "Three"
    Four = "Four"
    Five = "Five"


class WaveformDivisions(str, Enum):
    TimeScale = "TimeScale"
    Phrase = "Phrase"


class Waveform(str, Enum):
    Waveform = "Waveform"
    PhaseMeter = "PhaseMeter"


class BeatJumpBeatValue(str, Enum):
    HalfBeat = "HalfBeat"
    OneBeat = "OneBeat"
    TwoBeat = "TwoBeat"
    FourBeat = "FourBeat"
    EightBeat = "EightBeat"
    SixteenBeat = "SixteenBeat"
    ThirtytwoBeat = "ThirtytwoBeat"
    SixtyfourBeat = "SixtyfourBeat"


class ChannelFaderCurve(str, Enum):
    SteepTop = "SteepTop"
    Linear = "Linear"
    SteepBottom = "SteepBottom"


class CrossfaderCurve(str, Enum):
    ConstantPower = "ConstantPower"
    SlowCut = "SlowCut"
    FastCut = "FastCut"


class HeadphonesPreEQ(str, Enum):
    PostEQ = "PostEQ"
    PreEQ = "PreEQ"


class HeadphonesMonoSplit(str, Enum):
    MonoSplit = "MonoSplit"
    Stereo = "Stereo"


class BeatFXQuantize(str, Enum):
    Off = "Off"
    On = "On"


class MicLowCut(str, Enum):
    Off = "Off"
    On = "On"


class TalkOverMode(str, Enum):
    Advanced = "Advanced"
    Normal = "Normal"


class TalkOverLevel(str, Enum):
    Minus24dB = "Minus24dB"
    Minus18dB = "Minus18dB"
    Minus12dB = "Minus12dB"
    Minus6dB = "Minus6dB"


class MidiChannel(str, Enum):
    One = "One"
    Two = "Two"
    Three = "Three"
    Four = "Four"
    Five = "Five"
    Six = "Six"
    Seven = "Seven"
    Eight = "Eight"
    Nine = "Nine"
    Ten = "Ten"
    Eleven = "Eleven"
    Twelve = "Twelve"
    Thirteen = "Thirteen"
    Fourteen = "Fourteen"
    Fifteen = "Fifteen"
    Sixteen = "Sixteen"


class MidiButtonType(str, Enum):
    Toggle = "Toggle"
    Trigger = "Trigger"


class MixerDisplayBrightness(str, Enum):
    White = "White"
    One = "One"
    Two = "Two"
    Three = "Three"
    Four = "Four"
    Five = "Five"


class MixerIndicatorBrightness(str, Enum):
    One = "One"
    Two = "Two"
    Three = "Three"


class ChannelFaderCurveLongFader(str, Enum):
    Exponential = "Exponential"
    Smooth = "Smooth"
    Linear = "Linear"


class OverviewWaveformType(str, Enum):
    HalfWaveform = "HalfWaveform"
    FullWaveform = "FullWaveform"


class WaveformColor(str, Enum):
    Blue = "Blue"
    Rgb = "Rgb"
    TriBand = "TriBand"


class KeyDisplayFormat(str, Enum):
    Classic = "Classic"
    Alphanumeric = "Alphanumeric"


class WaveformCurrentPosition(str, Enum):
    Left = "Left"
    Center = "Center"


class Setting:
    def __init__(self, path: str = None):
        if path is None:
            self._setting = None
        else:
            self._setting = _PySetting(path)

    @classmethod
    def new_mysetting(cls, path: str) -> "Setting":
        """Create a new MySetting instance."""
        self = cls()
        self._setting = _PySetting.new_mysetting(path)
        return self

    @classmethod
    def new_mysetting2(cls, path: str) -> "Setting":
        self = cls()
        self._setting = _PySetting.new_mysetting2(path)
        return self

    @classmethod
    def new_djmmysetting(cls, path: str) -> "Setting":
        self = cls()
        self._setting = _PySetting.new_djmmysetting(path)
        return self

    @classmethod
    def new_devsetting(cls, path: str) -> "Setting":
        self = cls()
        self._setting = _PySetting.new_devsetting(path)
        return self

    @classmethod
    def load(cls, path: str) -> "Setting":
        self = cls()
        self._setting = _PySetting.load(path)
        return self

    def dump_copy(self, path: str) -> None:
        return self._setting.dump_copy(path)

    def dump(self) -> None:
        return self._setting.dump()

    def get_on_air_display(self) -> OnAirDisplay:
        return OnAirDisplay(self._setting.get_on_air_display())

    def set_on_air_display(self, value: Union[str, OnAirDisplay]) -> None:
        if isinstance(value, str):
            value = OnAirDisplay(value)
        self._setting.set_on_air_display(value.value)

    def get_lcd_brightness(self) -> LCDBrightness:
        return LCDBrightness(self._setting.get_lcd_brightness())

    def set_lcd_brightness(self, value: Union[str, LCDBrightness]) -> None:
        if isinstance(value, str):
            value = LCDBrightness(value)
        self._setting.set_lcd_brightness(value.value)

    def get_quantize(self) -> Quantize:
        return Quantize(self._setting.get_quantize())

    def set_quantize(self, value: Union[str, Quantize]) -> None:
        if isinstance(value, str):
            value = Quantize(value)
        self._setting.set_quantize(value.value)

    def get_auto_cue_level(self) -> AutoCueLevel:
        return AutoCueLevel(self._setting.get_auto_cue_level())

    def set_auto_cue_level(self, value: Union[str, AutoCueLevel]) -> None:
        if isinstance(value, str):
            value = AutoCueLevel(value)
        self._setting.set_auto_cue_level(value.value)

    def get_language(self) -> Language:
        return Language(self._setting.get_language())

    def set_language(self, value: Union[str, Language]) -> None:
        if isinstance(value, str):
            value = Language(value)
        self._setting.set_language(value.value)

    def get_jog_ring_brightness(self) -> JogRingBrightness:
        return JogRingBrightness(self._setting.get_jog_ring_brightness())

    def set_jog_ring_brightness(self, value: Union[str, JogRingBrightness]) -> None:
        if isinstance(value, str):
            value = JogRingBrightness(value)
        self._setting.set_jog_ring_brightness(value.value)

    def get_jog_ring_indicator(self) -> JogRingIndicator:
        return JogRingIndicator(self._setting.get_jog_ring_indicator())

    def set_jog_ring_indicator(self, value: Union[str, JogRingIndicator]) -> None:
        if isinstance(value, str):
            value = JogRingIndicator(value)
        self._setting.set_jog_ring_indicator(value.value)

    def get_slip_flashing(self) -> SlipFlashing:
        return SlipFlashing(self._setting.get_slip_flashing())

    def set_slip_flashing(self, value: Union[str, SlipFlashing]) -> None:
        if isinstance(value, str):
            value = SlipFlashing(value)
        self._setting.set_slip_flashing(value.value)

    def get_disc_slot_illumination(self) -> DiscSlotIllumination:
        return DiscSlotIllumination(self._setting.get_disc_slot_illumination())

    def set_disc_slot_illumination(self, value: Union[str, DiscSlotIllumination]) -> None:
        if isinstance(value, str):
            value = DiscSlotIllumination(value)
        self._setting.set_disc_slot_illumination(value.value)

    def get_eject_lock(self) -> EjectLock:
        return EjectLock(self._setting.get_eject_lock())

    def set_eject_lock(self, value: Union[str, EjectLock]) -> None:
        if isinstance(value, str):
            value = EjectLock(value)
        self._setting.set_eject_lock(value.value)

    def get_sync(self) -> Sync:
        return Sync(self._setting.get_sync())

    def set_sync(self, value: Union[str, Sync]) -> None:
        if isinstance(value, str):
            value = Sync(value)
        self._setting.set_sync(value.value)

    def get_play_mode(self) -> PlayMode:
        return PlayMode(self._setting.get_play_mode())

    def set_play_mode(self, value: Union[str, PlayMode]) -> None:
        if isinstance(value, str):
            value = PlayMode(value)
        self._setting.set_play_mode(value.value)

    def get_quantize_beat_value(self) -> QuantizeBeatValue:
        return QuantizeBeatValue(self._setting.get_quantize_beat_value())

    def set_quantize_beat_value(self, value: Union[str, QuantizeBeatValue]) -> None:
        if isinstance(value, str):
            value = QuantizeBeatValue(value)
        self._setting.set_quantize_beat_value(value.value)

    def get_hotcue_autoload(self) -> HotCueAutoLoad:
        return HotCueAutoLoad(self._setting.get_hotcue_autoload())

    def set_hotcue_autoload(self, value: Union[str, HotCueAutoLoad]) -> None:
        if isinstance(value, str):
            value = HotCueAutoLoad(value)
        self._setting.set_hotcue_autoload(value.value)

    def get_hotcue_color(self) -> HotCueColor:
        return HotCueColor(self._setting.get_hotcue_color())

    def set_hotcue_color(self, value: Union[str, HotCueColor]) -> None:
        if isinstance(value, str):
            value = HotCueColor(value)
        self._setting.set_hotcue_color(value.value)

    def get_needle_lock(self) -> NeedleLock:
        return NeedleLock(self._setting.get_needle_lock())

    def set_needle_lock(self, value: Union[str, NeedleLock]) -> None:
        if isinstance(value, str):
            value = NeedleLock(value)
        self._setting.set_needle_lock(value.value)

    def get_time_mode(self) -> TimeMode:
        return TimeMode(self._setting.get_time_mode())

    def set_time_mode(self, value: Union[str, TimeMode]) -> None:
        if isinstance(value, str):
            value = TimeMode(value)
        self._setting.set_time_mode(value.value)

    def get_jog_mode(self) -> JogMode:
        return JogMode(self._setting.get_jog_mode())

    def set_jog_mode(self, value: Union[str, JogMode]) -> None:
        if isinstance(value, str):
            value = JogMode(value)
        self._setting.set_jog_mode(value.value)

    def get_auto_cue(self) -> AutoCue:
        return AutoCue(self._setting.get_auto_cue())

    def set_auto_cue(self, value: Union[str, AutoCue]) -> None:
        if isinstance(value, str):
            value = AutoCue(value)
        self._setting.set_auto_cue(value.value)

    def get_master_tempo(self) -> MasterTempo:
        return MasterTempo(self._setting.get_master_tempo())

    def set_master_tempo(self, value: Union[str, MasterTempo]) -> None:
        if isinstance(value, str):
            value = MasterTempo(value)
        self._setting.set_master_tempo(value.value)

    def get_tempo_range(self) -> TempoRange:
        return TempoRange(self._setting.get_tempo_range())

    def set_tempo_range(self, value: Union[str, TempoRange]) -> None:
        if isinstance(value, str):
            value = TempoRange(value)
        self._setting.set_tempo_range(value.value)

    def get_phase_meter(self) -> PhaseMeter:
        return PhaseMeter(self._setting.get_phase_meter())

    def set_phase_meter(self, value: Union[str, PhaseMeter]) -> None:
        if isinstance(value, str):
            value = PhaseMeter(value)
        self._setting.set_phase_meter(value.value)

    def get_vinyl_speed_adjust(self) -> VinylSpeedAdjust:
        return VinylSpeedAdjust(self._setting.get_vinyl_speed_adjust())

    def set_vinyl_speed_adjust(self, value: Union[str, VinylSpeedAdjust]) -> None:
        if isinstance(value, str):
            value = VinylSpeedAdjust(value)
        self._setting.set_vinyl_speed_adjust(value.value)

    def get_jog_display_mode(self) -> JogDisplayMode:
        return JogDisplayMode(self._setting.get_jog_display_mode())

    def set_jog_display_mode(self, value: Union[str, JogDisplayMode]) -> None:
        if isinstance(value, str):
            value = JogDisplayMode(value)
        self._setting.set_jog_display_mode(value.value)

    def get_pad_button_brightness(self) -> PadButtonBrightness:
        return PadButtonBrightness(self._setting.get_pad_button_brightness())

    def set_pad_button_brightness(self, value: Union[str, PadButtonBrightness]) -> None:
        if isinstance(value, str):
            value = PadButtonBrightness(value)
        self._setting.set_pad_button_brightness(value.value)

    def get_jog_lcd_brightness(self) -> JogLCDBrightness:
        return JogLCDBrightness(self._setting.get_jog_lcd_brightness())

    def set_jog_lcd_brightness(self, value: Union[str, JogLCDBrightness]) -> None:
        if isinstance(value, str):
            value = JogLCDBrightness(value)
        self._setting.set_jog_lcd_brightness(value.value)

    def get_waveform_divisions(self) -> WaveformDivisions:
        return WaveformDivisions(self._setting.get_waveform_divisions())

    def set_waveform_divisions(self, value: Union[str, WaveformDivisions]) -> None:
        if isinstance(value, str):
            value = WaveformDivisions(value)
        self._setting.set_waveform_divisions(value.value)

    def get_waveform(self) -> Waveform:
        return Waveform(self._setting.get_waveform())

    def set_waveform(self, value: Union[str, Waveform]) -> None:
        if isinstance(value, str):
            value = Waveform(value)
        self._setting.set_waveform(value.value)

    def get_beat_jump_beat_value(self) -> BeatJumpBeatValue:
        return BeatJumpBeatValue(self._setting.get_beat_jump_beat_value())

    def set_beat_jump_beat_value(self, value: Union[str, BeatJumpBeatValue]) -> None:
        if isinstance(value, str):
            value = BeatJumpBeatValue(value)
        self._setting.set_beat_jump_beat_value(value.value)

    def get_channel_fader_curve(self) -> ChannelFaderCurve:
        return ChannelFaderCurve(self._setting.get_channel_fader_curve())

    def set_channel_fader_curve(self, value: Union[str, ChannelFaderCurve]) -> None:
        if isinstance(value, str):
            value = ChannelFaderCurve(value)
        self._setting.set_channel_fader_curve(value.value)

    def get_crossfader_curve(self) -> CrossfaderCurve:
        return CrossfaderCurve(self._setting.get_crossfader_curve())

    def set_crossfader_curve(self, value: Union[str, CrossfaderCurve]) -> None:
        if isinstance(value, str):
            value = CrossfaderCurve(value)
        self._setting.set_crossfader_curve(value.value)

    def get_headphones_pre_eq(self) -> HeadphonesPreEQ:
        return HeadphonesPreEQ(self._setting.get_headphones_pre_eq())

    def set_headphones_pre_eq(self, value: Union[str, HeadphonesPreEQ]) -> None:
        if isinstance(value, str):
            value = HeadphonesPreEQ(value)
        self._setting.set_headphones_pre_eq(value.value)

    def get_headphones_mono_split(self) -> HeadphonesMonoSplit:
        return HeadphonesMonoSplit(self._setting.get_headphones_mono_split())

    def set_headphones_mono_split(self, value: Union[str, HeadphonesMonoSplit]) -> None:
        if isinstance(value, str):
            value = HeadphonesMonoSplit(value)
        self._setting.set_headphones_mono_split(value.value)

    def get_beat_fx_quantize(self) -> BeatFXQuantize:
        return BeatFXQuantize(self._setting.get_beat_fx_quantize())

    def set_beat_fx_quantize(self, value: Union[str, BeatFXQuantize]) -> None:
        if isinstance(value, str):
            value = BeatFXQuantize(value)
        self._setting.set_beat_fx_quantize(value.value)

    def get_mic_low_cut(self) -> MicLowCut:
        return MicLowCut(self._setting.get_mic_low_cut())

    def set_mic_low_cut(self, value: Union[str, MicLowCut]) -> None:
        if isinstance(value, str):
            value = MicLowCut(value)
        self._setting.set_mic_low_cut(value.value)

    def get_talk_over_mode(self) -> TalkOverMode:
        return TalkOverMode(self._setting.get_talk_over_mode())

    def set_talk_over_mode(self, value: Union[str, TalkOverMode]) -> None:
        if isinstance(value, str):
            value = TalkOverMode(value)
        self._setting.set_talk_over_mode(value.value)

    def get_talk_over_level(self) -> TalkOverLevel:
        return TalkOverLevel(self._setting.get_talk_over_level())

    def set_talk_over_level(self, value: Union[str, TalkOverLevel]) -> None:
        if isinstance(value, str):
            value = TalkOverLevel(value)
        self._setting.set_talk_over_level(value.value)

    def get_midi_channel(self) -> MidiChannel:
        return MidiChannel(self._setting.get_midi_channel())

    def set_midi_channel(self, value: Union[str, MidiChannel]) -> None:
        if isinstance(value, str):
            value = MidiChannel(value)
        self._setting.set_midi_channel(value.value)

    def get_midi_button_type(self) -> MidiButtonType:
        return MidiButtonType(self._setting.get_midi_button_type())

    def set_midi_button_type(self, value: Union[str, MidiButtonType]) -> None:
        if isinstance(value, str):
            value = MidiButtonType(value)
        self._setting.set_midi_button_type(value.value)

    def get_mixer_display_brightness(self) -> MixerDisplayBrightness:
        return MixerDisplayBrightness(self._setting.get_mixer_display_brightness())

    def set_mixer_display_brightness(self, value: Union[str, MixerDisplayBrightness]) -> None:
        if isinstance(value, str):
            value = MixerDisplayBrightness(value)
        self._setting.set_mixer_display_brightness(value.value)

    def get_mixer_indicator_brightness(self) -> MixerIndicatorBrightness:
        return MixerIndicatorBrightness(self._setting.get_mixer_indicator_brightness())

    def set_mixer_indicator_brightness(self, value: Union[str, MixerIndicatorBrightness]) -> None:
        if isinstance(value, str):
            value = MixerIndicatorBrightness(value)
        self._setting.set_mixer_indicator_brightness(value.value)

    def get_channel_fader_curve_long_fader(self) -> ChannelFaderCurveLongFader:
        return ChannelFaderCurveLongFader(self._setting.get_channel_fader_curve_long_fader())

    def set_channel_fader_curve_long_fader(
        self, value: Union[str, ChannelFaderCurveLongFader]
    ) -> None:
        if isinstance(value, str):
            value = ChannelFaderCurveLongFader(value)
        self._setting.set_channel_fader_curve_long_fader(value.value)

    def get_overview_waveform_type(self) -> OverviewWaveformType:
        return OverviewWaveformType(self._setting.get_overview_waveform_type())

    def set_overview_waveform_type(self, value: Union[str, OverviewWaveformType]) -> None:
        if isinstance(value, str):
            value = OverviewWaveformType(value)
        self._setting.set_overview_waveform_type(value.value)

    def get_waveform_color(self) -> WaveformColor:
        return WaveformColor(self._setting.get_waveform_color())

    def set_waveform_color(self, value: Union[str, WaveformColor]) -> None:
        if isinstance(value, str):
            value = WaveformColor(value)
        self._setting.set_waveform_color(value.value)

    def get_key_display_format(self) -> KeyDisplayFormat:
        return KeyDisplayFormat(self._setting.get_key_display_format())

    def set_key_display_format(self, value: Union[str, KeyDisplayFormat]) -> None:
        if isinstance(value, str):
            value = KeyDisplayFormat(value)
        self._setting.set_key_display_format(value.value)

    def get_waveform_current_position(self) -> WaveformCurrentPosition:
        return WaveformCurrentPosition(self._setting.get_waveform_current_position())

    def set_waveform_current_position(self, value: Union[str, WaveformCurrentPosition]) -> None:
        if isinstance(value, str):
            value = WaveformCurrentPosition(value)
        self._setting.set_waveform_current_position(value.value)
