# Introduction

Welcome to the {{ config.API_TITLE }} documentation. This RESTful API is designed with simplicity and ease of
integration in mind. Our goal is to provide a clear and straightforward way for developers to work with, access and
understand the data contained in the API, ensuring you can get up and running with minimal fuss.

# Output Format

The API communicates using JSON format, ensuring responses are both structured and easily decipherable. Standard
response structure is as follows:

[//]: # (This automatically will output an example response based on the config values)

```json
{{api_output_example | safe }}
```

To maintain clarity and conciseness in this documentation, only the value field will be detailed in specific examples.
Nonetheless, actual API responses will include these fields comprehensively. Depending on the endpoint requested, the
value field may contain a single object or an array of objects.

{% if has_rate_limiting %}

# Rate Limiting

To ensure the stability and reliability of our API, we have implemented rate limiting on some/all endpoints. This
means that you can only make a certain number of requests within a given time frame. If you exceed this limit, you
will receive a 429 Too Many Requests status code.

Each endpoint documented below will specify whether it is rate limited and, if so, the maximum number of requests you
can make within a given time frame.

Request headers for endpoints with rate limiting will include the following fields:

- X-RateLimit-Limit: The maximum number of requests you can make within the time frame.
- X-RateLimit-Remaining: The number of requests you have remaining within the time frame.
- X-RateLimit-Reset: The time at which the rate limit will reset, in UTC epoch seconds.
- Retry-After: The number of seconds until you can make another request.

{% endif %}
{% if config.API_AUTHENTICATE %}

{% endif %}

# Error Handling

Error handling within the API is designed to be as informative as possible. Should an error occur, the response will
feature an errors field, providing detailed insights into the nature of the error.
Common error status codes include:

Common Error Codes:

- 400 Bad Request: The server could not understand the request due to invalid syntax.
  {% if config.API_AUTHENTICATE %}
- 401 Unauthorized: Authentication is required and has failed or has not yet been provided.
- 403 Forbidden: The request was valid, but the server is refusing action due to lack of permissions.
  {% endif %}
- 404 Not Found: The requested resource could not be found but may be available in the future.
- 405 Method Not Allowed: A request method is not supported for the requested resource.
  {% if has_rate_limiting %}
- 429 Too Many Requests: The user has sent too many requests in a given amount of time.
  {% endif %}
- 500 Internal Server Error: An unexpected condition was encountered on the server.

{% if config.API_AUTHENTICATE %}

# Authentication

{% if config.API_AUTHENTICATE_METHOD == "api_key" %}

## API Key Authentication

To secure access and ensure only authorized users can make requests, our API implements API Key Authentication. When
making requests to protected endpoints, include your API key in the request header:

- Authorization: ApiKey {your_api_key_here}

Your API key is a unique identifier that must be kept confidential. Do not share it in publicly accessible areas such
GitHub, client-side code, and so forth.

## JSON Web Tokens (JWT)

{% elif config.API_AUTHENTICATE_METHOD == "jwt" %}

Our API leverages JSON Web Tokens (JWT) for secure authentication. To use our API, include the JWT in the Authorization
header of each request like so:

- Authorization: Bearer {your_jwt_token}

JWTs are generated by the {{ config.API_TITLE }} and are valid for {{config.API_JWT_EXPIRY_TIME}} minutes. Should your
token expire,
it will become invalid, necessitating a refresh. To refresh your JWT, issue a POST request to /auth/refresh. Our JWTs
are created using the HS256 algorithm, ensuring robust security.

Please note, refresh tokens remain valid for approximately {{ (config.API_JWT_REFRESH_EXPIRY_TIME / 60 / 24) | int }}
hours.
Upon expiration, you'll need to authenticate again to obtain a new JWT.

## Basic Authentication

{% elif config.API_AUTHENTICATE_METHOD == "basic" %}

Our API supports Basic Authentication. This method requires the submission of a username and password with each request.
These credentials should be base64-encoded and included in the Authorization header:

- Authorization: Basic {base64-encoded-credentials}

While easy to implement, it's crucial to use Basic Authentication over HTTPS to prevent the potential interception of
your credentials. Always ensure your connection is secure when transmitting sensitive information.

{% endif %}
{% endif %}
