# mypy-boto3-elasticbeanstalk

[![PyPI - mypy-boto3-elasticbeanstalk](https://img.shields.io/pypi/v/mypy-boto3-elasticbeanstalk.svg?color=blue)](https://pypi.org/project/mypy-boto3-elasticbeanstalk)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-elasticbeanstalk.svg?color=blue)](https://pypi.org/project/mypy-boto3-elasticbeanstalk)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.ElasticBeanstalk 1.16.22](https://boto3.amazonaws.com/v1/documentation/api/1.16.22/reference/services/elasticbeanstalk.html#ElasticBeanstalk) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.2.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-elasticbeanstalk](#mypy-boto3-elasticbeanstalk)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `ElasticBeanstalk` service.

```bash
python -m pip install boto3-stubs[elasticbeanstalk]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[elasticbeanstalk]` in your environment: `python -m pip install 'boto3-stubs[elasticbeanstalk]'`

Both type checking and auto-complete should work for `ElasticBeanstalk` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[elasticbeanstalk]` in your environment: `python -m pip install 'boto3-stubs[elasticbeanstalk]'`

Both type checking and auto-complete should work for `ElasticBeanstalk` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[elasticbeanstalk]` in your environment: `python -m pip install 'boto3-stubs[elasticbeanstalk]'`
- Run `mypy` as usual

Type checking should work for `ElasticBeanstalk` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[elasticbeanstalk]` in your environment: `python -m pip install 'boto3-stubs[elasticbeanstalk]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `ElasticBeanstalk` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`ElasticBeanstalkClient` provides annotations for `boto3.client("elasticbeanstalk")`.

```python
import boto3

from mypy_boto3_elasticbeanstalk import ElasticBeanstalkClient

client: ElasticBeanstalkClient = boto3.client("elasticbeanstalk")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ElasticBeanstalkClient = session.client("elasticbeanstalk")
```

### Paginators annotations

`mypy_boto3_elasticbeanstalk.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_elasticbeanstalk import ElasticBeanstalkClient
from mypy_boto3_elasticbeanstalk.paginator import (
    DescribeApplicationVersionsPaginator,
    DescribeEnvironmentManagedActionHistoryPaginator,
    DescribeEnvironmentsPaginator,
    DescribeEventsPaginator,
    ListPlatformVersionsPaginator,
)

client: ElasticBeanstalkClient = boto3.client("elasticbeanstalk")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_application_versions_paginator: DescribeApplicationVersionsPaginator = client.get_paginator("describe_application_versions")
describe_environment_managed_action_history_paginator: DescribeEnvironmentManagedActionHistoryPaginator = client.get_paginator("describe_environment_managed_action_history")
describe_environments_paginator: DescribeEnvironmentsPaginator = client.get_paginator("describe_environments")
describe_events_paginator: DescribeEventsPaginator = client.get_paginator("describe_events")
list_platform_versions_paginator: ListPlatformVersionsPaginator = client.get_paginator("list_platform_versions")
```


### Waiters annotations

`mypy_boto3_elasticbeanstalk.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_elasticbeanstalk import ElasticBeanstalkClient
from mypy_boto3_elasticbeanstalk.waiter import (
    EnvironmentExistsWaiter,
    EnvironmentTerminatedWaiter,
    EnvironmentUpdatedWaiter,
)

client: ElasticBeanstalkClient = boto3.client("elasticbeanstalk")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
environment_exists_waiter: EnvironmentExistsWaiter = client.get_waiter("environment_exists")
environment_terminated_waiter: EnvironmentTerminatedWaiter = client.get_waiter("environment_terminated")
environment_updated_waiter: EnvironmentUpdatedWaiter = client.get_waiter("environment_updated")
```





### Typed dictionations

`mypy_boto3_elasticbeanstalk.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_elasticbeanstalk.type_defs import (
    ApplicationDescriptionMessageTypeDef,
    ApplicationDescriptionsMessageTypeDef,
    ApplicationDescriptionTypeDef,
    ApplicationMetricsTypeDef,
    ApplicationResourceLifecycleConfigTypeDef,
    ApplicationResourceLifecycleDescriptionMessageTypeDef,
    ApplicationVersionDescriptionMessageTypeDef,
    ApplicationVersionDescriptionsMessageTypeDef,
    ApplicationVersionDescriptionTypeDef,
    ApplicationVersionLifecycleConfigTypeDef,
    ApplyEnvironmentManagedActionResultTypeDef,
    AutoScalingGroupTypeDef,
    BuildConfigurationTypeDef,
    BuilderTypeDef,
    CheckDNSAvailabilityResultMessageTypeDef,
    ConfigurationOptionDescriptionTypeDef,
    ConfigurationOptionsDescriptionTypeDef,
    ConfigurationOptionSettingTypeDef,
    ConfigurationSettingsDescriptionsTypeDef,
    ConfigurationSettingsDescriptionTypeDef,
    ConfigurationSettingsValidationMessagesTypeDef,
    CPUUtilizationTypeDef,
    CreatePlatformVersionResultTypeDef,
    CreateStorageLocationResultMessageTypeDef,
    CustomAmiTypeDef,
    DeletePlatformVersionResultTypeDef,
    DeploymentTypeDef,
    DescribeAccountAttributesResultTypeDef,
    DescribeEnvironmentHealthResultTypeDef,
    DescribeEnvironmentManagedActionHistoryResultTypeDef,
    DescribeEnvironmentManagedActionsResultTypeDef,
    DescribeInstancesHealthResultTypeDef,
    DescribePlatformVersionResultTypeDef,
    EnvironmentDescriptionsMessageTypeDef,
    EnvironmentDescriptionTypeDef,
    EnvironmentInfoDescriptionTypeDef,
    EnvironmentLinkTypeDef,
    EnvironmentResourceDescriptionsMessageTypeDef,
    EnvironmentResourceDescriptionTypeDef,
    EnvironmentResourcesDescriptionTypeDef,
    EnvironmentTierTypeDef,
    EventDescriptionsMessageTypeDef,
    EventDescriptionTypeDef,
    InstanceHealthSummaryTypeDef,
    InstanceTypeDef,
    LatencyTypeDef,
    LaunchConfigurationTypeDef,
    LaunchTemplateTypeDef,
    ListAvailableSolutionStacksResultMessageTypeDef,
    ListenerTypeDef,
    ListPlatformBranchesResultTypeDef,
    ListPlatformVersionsResultTypeDef,
    LoadBalancerDescriptionTypeDef,
    LoadBalancerTypeDef,
    ManagedActionHistoryItemTypeDef,
    ManagedActionTypeDef,
    MaxAgeRuleTypeDef,
    MaxCountRuleTypeDef,
    OptionRestrictionRegexTypeDef,
    OptionSpecificationTypeDef,
    PaginatorConfigTypeDef,
    PlatformBranchSummaryTypeDef,
    PlatformDescriptionTypeDef,
    PlatformFilterTypeDef,
    PlatformFrameworkTypeDef,
    PlatformProgrammingLanguageTypeDef,
    PlatformSummaryTypeDef,
    QueueTypeDef,
    ResourceQuotasTypeDef,
    ResourceQuotaTypeDef,
    ResourceTagsDescriptionMessageTypeDef,
    RetrieveEnvironmentInfoResultMessageTypeDef,
    S3LocationTypeDef,
    SearchFilterTypeDef,
    SingleInstanceHealthTypeDef,
    SolutionStackDescriptionTypeDef,
    SourceBuildInformationTypeDef,
    SourceConfigurationTypeDef,
    StatusCodesTypeDef,
    SystemStatusTypeDef,
    TagTypeDef,
    TriggerTypeDef,
    ValidationMessageTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> ApplicationDescriptionTypeDef:
    return {
      ...
    }
```
