from typing import Any, Mapping, MutableMapping

from requests.adapters import HTTPAdapter

class Response:
    status_code: int
    content: bytes
    _content: bytes
    text: str
    def json(self) -> Any: ...
    def raise_for_status(self) -> None: ...

def put(url: str, headers: Mapping[str, str] | None = ..., data: Any = ..., timeout: int | None = ...) -> Response: ...

class Session:
    headers: MutableMapping[str, str]
    def get(self, url: str, params: Mapping[str, Any] | None = ..., timeout: int | None = ...) -> Response: ...
    def post(self, url: str, params: Mapping[str, Any] | None = ..., json: Any = ..., timeout: int | None = ...) -> Response: ...
    def delete(self, url: str, timeout: int | None = ...) -> Response: ...
    def mount(self, prefix: str, adapter: HTTPAdapter) -> None: ...
    def close(self) -> None: ...
