#ifndef COSMOSIS_CONSTANTS_H
#define COSMOSIS_CONSTANTS_H
static const double constant_G           =  6.673840e-11  // m3 / (kg s2)  // Gravitational constant
static const double constant_L_sun       =  3.846000e+26  // W             // Solar luminosity
static const double constant_M_earth     =  5.974200e+24  // kg            // Earth mass
static const double constant_M_jup       =  1.898700e+27  // kg            // Jupiter mass
static const double constant_M_sun       =  1.989100e+30  // kg            // Solar mass
static const double constant_N_A         =  6.022141e+23  // 1 / mol       // Avogadro's number
static const double constant_R           =  8.314462e+00  // J / (K mol)   // Gas constant
static const double constant_R_earth     =  6.378136e+06  // m             // Earth equatorial radius
static const double constant_R_jup       =  7.149200e+07  // m             // Jupiter equatorial radius
static const double constant_R_sun       =  6.955080e+08  // m             // Solar radius
static const double constant_Ryd         =  1.097373e+07  // 1 / m         // Rydberg constant
static const double constant_a0          =  5.291772e-11  // m             // Bohr radius
static const double constant_alpha       =  7.297353e-03  //               // Fine-structure constant
static const double constant_atmosphere  =  1.013250e+05  // Pa            // Atmosphere
static const double constant_au          =  1.495979e+11  // m             // Astronomical Unit
static const double constant_b_wien      =  2.897772e-03  // K m           // Wien wavelength displacement law constant
static const double constant_c           =  2.997925e+08  // m / s         // Speed of light in vacuum
static const double constant_e           =  1.602177e-19  // C             // Electron charge
static const double constant_eps0        =  8.854188e-12  // F / m         // Electric constant
static const double constant_g0          =  9.806650e+00  // m / s2        // Standard acceleration of gravity
static const double constant_h           =  6.626070e-34  // J s           // Planck constant
static const double constant_hbar        =  1.054572e-34  // J s           // Reduced Planck constant
static const double constant_k_B         =  1.380649e-23  // J / K         // Boltzmann constant
static const double constant_kpc         =  3.085678e+19  // m             // Kiloparsec
static const double constant_m_e         =  9.109383e-31  // kg            // Electron mass
static const double constant_m_n         =  1.674927e-27  // kg            // Neutron mass
static const double constant_m_p         =  1.672622e-27  // kg            // Proton mass
static const double constant_mu0         =  1.256637e-06  // N / A2        // Magnetic constant
static const double constant_muB         =  9.274010e-24  // J / T         // Bohr magneton
static const double constant_pc          =  3.085678e+16  // m             // Parsec
static const double constant_sigma_sb    =  5.670373e-08  // W / (K4 m2)   // Stefan-Boltzmann constant
static const double constant_u           =  1.660539e-27  // kg            // Atomic mass
#endif /* COSMOSIS_CONSTANTS_H */
