# Generated by Django 4.2.25 on 2025-10-28 02:50

# Django
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("eveuniverse", "0011_extend_industry_activites"),
        ("aapayout", "0001_initial"),
    ]

    operations = [
        migrations.AddField(
            model_name="fleetparticipant",
            name="excluded_from_payout",
            field=models.BooleanField(
                default=False,
                help_text="If checked, this participant will not receive a payout",
            ),
        ),
        migrations.AddField(
            model_name="fleetparticipant",
            name="is_scout",
            field=models.BooleanField(
                default=False,
                help_text="If checked, this participant receives +10% scout bonus",
            ),
        ),
        migrations.AddField(
            model_name="fleetparticipant",
            name="main_character",
            field=models.ForeignKey(
                blank=True,
                help_text="Main character for this participant (from Alliance Auth)",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="alt_participants",
                to="eveuniverse.eveentity",
            ),
        ),
        migrations.AddField(
            model_name="payout",
            name="is_scout_payout",
            field=models.BooleanField(default=False, help_text="Whether this payout includes scout bonus"),
        ),
        migrations.AddField(
            model_name="payout",
            name="verified",
            field=models.BooleanField(
                default=False,
                help_text="Whether this payout was verified via ESI wallet journal",
            ),
        ),
        migrations.AddField(
            model_name="payout",
            name="verified_at",
            field=models.DateTimeField(blank=True, help_text="When this payout was verified", null=True),
        ),
        migrations.AddIndex(
            model_name="fleetparticipant",
            index=models.Index(fields=["is_scout"], name="aapayout_fl_is_scou_3df9c4_idx"),
        ),
        migrations.AddIndex(
            model_name="fleetparticipant",
            index=models.Index(fields=["excluded_from_payout"], name="aapayout_fl_exclude_cc8cf3_idx"),
        ),
        migrations.AddIndex(
            model_name="fleetparticipant",
            index=models.Index(fields=["main_character"], name="aapayout_fl_main_ch_6fb747_idx"),
        ),
        migrations.AddIndex(
            model_name="payout",
            index=models.Index(fields=["is_scout_payout"], name="aapayout_pa_is_scou_4d0178_idx"),
        ),
        migrations.AddIndex(
            model_name="payout",
            index=models.Index(fields=["verified"], name="aapayout_pa_verifie_df8471_idx"),
        ),
    ]
