# This file was auto-generated by Fern from our API Definition.

import typing

import httpx
from .agents.client import AgentsClient, AsyncAgentsClient
from .contacts.client import AsyncContactsClient, ContactsClient
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .customers.client import AsyncCustomersClient, CustomersClient
from .environment import PaidEnvironment
from .orders.client import AsyncOrdersClient, OrdersClient
from .tracing import (
    _generate_and_set_tracing_token,
    _initialize_tracing,
    _set_tracing_token,
    _signal,
    _trace_async,
    _trace_sync,
    _unset_tracing_token,
)
from .usage.client import AsyncUsageClient, UsageClient

T = typing.TypeVar("T")


class Paid:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : PaidEnvironment
        The environment to use for requests from the client. from .environment import PaidEnvironment



        Defaults to PaidEnvironment.PRODUCTION



    token : typing.Union[str, typing.Callable[[], str]]
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from paid import Paid

    client = Paid(
        token="YOUR_TOKEN",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: PaidEnvironment = PaidEnvironment.PRODUCTION,
        token: typing.Union[str, typing.Callable[[], str]],
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.customers = CustomersClient(client_wrapper=self._client_wrapper)
        self.agents = AgentsClient(client_wrapper=self._client_wrapper)
        self.contacts = ContactsClient(client_wrapper=self._client_wrapper)
        self.orders = OrdersClient(client_wrapper=self._client_wrapper)
        self.usage = UsageClient(client_wrapper=self._client_wrapper)

    def initialize_tracing(self, collector_endpoint: str = "https://collector.agentpaid.io:4318/v1/traces") -> None:
        """
        Initializes tracing for the Paid client.
        Call this method before using tracing features to ensure proper setup.

        Returns
        -------
        None
        """
        token = self._client_wrapper._get_token()
        _initialize_tracing(token, collector_endpoint=collector_endpoint)

    def generate_and_set_tracing_token(self) -> int:
        """
        *Advanced feature*
        In cases when you can't share the same Paid.trace() context with
        code that you want to track together (complex concurrency logic,
        or disjoint workflows, or work is separated between processes),
        then you can manually generate a tracing token with generate_and_set_traceing_token()
        and share it with the other parts of your application or service using set_tracing_token().

        This function generates tracing token and attaches it to all consequent
        Paid.trace() tracing contexts. So all the costs and signals that share this
        tracing context are associated with each other.

        To stop associating the traces one can either call
        generate_and_set_tracing_token() once again or call unset_tracing_token().
        The former is suitable if you still want to trace but in a fresh
        context, and the latter will go back to unique traces per Paid.trace().
        """
        return _generate_and_set_tracing_token()

    def set_tracing_token(self, token: int):
        """
        *Advanced feature*
        In cases when you can't share the same Paid.trace() context with
        code that you want to track together (complex concurrency logic,
        or disjoint workflows, or work is separated between processes),
        then you can manually generate a tracing token with generate_and_set_traceing_token()
        and share it with the other parts of your application or service using set_tracing_token().

        Sets tracing token. Provided token should come from generate_and_set_tracing_token().
        Once set, the consequent traces will be related to each other.
        """

        _set_tracing_token(token)

    def unset_tracing_token(self):
        """
        Unsets the token previously set by generate_and_set_tracing_token()
        or by set_tracing_token(token). Does nothing if the token was never set.
        When tracing token is unset, traces are unique for a single Paid.trace() context.
        """
        _unset_tracing_token()

    def capture(
        self,
        external_customer_id: str,
        fn: typing.Callable[[], T],
        args: typing.Optional[typing.Tuple] = None,
        kwargs: typing.Optional[typing.Dict] = None,
    ) -> T:
        print("capture() is deprecated. Please rename it to trace() to remove this message.")
        return _trace_sync(
            external_customer_id=external_customer_id, fn=fn, external_agent_id=None, args=args, kwargs=kwargs
        )

    def trace(
        self,
        external_customer_id: str,
        fn: typing.Callable[[], T],
        external_agent_id: typing.Optional[str] = None,
        args: typing.Optional[typing.Tuple] = None,
        kwargs: typing.Optional[typing.Dict] = None,
    ) -> T:
        """
        Traces the execution of the provided function.

        Parameters
        ----------
        external_customer_id : str
            The external customer ID to associate with the trace.
        fn : typing.Callable[[], T]
            The function to be traced.
        external_agent_id : typing.Optional[str], optional
            The external agent ID to associate with the trace, by default None.
        args : typing.Optional[typing.Tuple], optional
            Positional arguments to pass to the function, by default None.
        kwargs : typing.Optional[typing.Dict], optional
            Keyword arguments to pass to the function, by default None.

        Returns
        -------
        T
            The result of the traced function.
        """
        return _trace_sync(
            external_customer_id=external_customer_id,
            fn=fn,
            external_agent_id=external_agent_id,
            args=args,
            kwargs=kwargs,
        )

    def signal(
        self,
        event_name: str,
        *,
        data: typing.Optional[typing.Dict[str, typing.Any]] = None,
        enable_cost_tracing: bool = False,
    ) -> None:
        """
        Sends Paid signal. Needs to be called as part of callback to Paid.trace().
        When enable_cost_tracing flag is on, signal is associated
        with cost traces from the same Paid.trace() context.

        Parameters
        ----------
        event_name : str
            The name of the signal.
        data : typing.Optional[typing.Dict[str, typing.Any]], optional
            Additional data to include with the signal event.
        enable_cost_tracing : bool, optional
            Whether to associate this signal with cost traces from the current Paid.trace() context.
            Defaults to False.

        Usage
        -----
        signal("event_name")
        signal("event_name", data={"key": "value"})
        signal("event_name", enable_cost_tracing=True)
        signal("event_name", enable_cost_tracing=True, data={"key": "value"})

        Notes
        -----
        When enable_cost_tracing is on, the signal will be associated with cost
        traces within the same Paid.trace() context.
        It is advised to only make one call to this function
        with enable_cost_tracing per Paid.trace() context.
        Otherwise, there will be multiple signals that refer to the same costs.
        """
        _signal(event_name=event_name, enable_cost_tracing=enable_cost_tracing, data=data)


class AsyncPaid:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : PaidEnvironment
        The environment to use for requests from the client. from .environment import PaidEnvironment



        Defaults to PaidEnvironment.PRODUCTION



    token : typing.Union[str, typing.Callable[[], str]]
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from paid import AsyncPaid

    client = AsyncPaid(
        token="YOUR_TOKEN",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: PaidEnvironment = PaidEnvironment.PRODUCTION,
        token: typing.Union[str, typing.Callable[[], str]],
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.customers = AsyncCustomersClient(client_wrapper=self._client_wrapper)
        self.agents = AsyncAgentsClient(client_wrapper=self._client_wrapper)
        self.contacts = AsyncContactsClient(client_wrapper=self._client_wrapper)
        self.orders = AsyncOrdersClient(client_wrapper=self._client_wrapper)
        self.usage = AsyncUsageClient(client_wrapper=self._client_wrapper)

    def initialize_tracing(self, collector_endpoint: str = "https://collector.agentpaid.io:4318/v1/traces") -> None:
        """
        Initializes tracing for the AsyncPaid client.
        Call this method before using tracing features to ensure proper setup.

        Returns
        -------
        None
        """
        token = self._client_wrapper._get_token()
        _initialize_tracing(token, collector_endpoint=collector_endpoint)

    def generate_and_set_tracing_token(self) -> int:
        """
        *Advanced feature*
        In cases when you can't share the same Paid.trace() context with
        code that you want to track together (complex concurrency logic,
        or disjoint workflows, or work is separated between processes),
        then you can manually generate a tracing token with generate_and_set_traceing_token()
        and share it with the other parts of your application or service using set_tracing_token().

        This function generates tracing token and attaches it to all consequent
        Paid.trace() tracing contexts. So all the costs and signals that share this
        tracing context are associated with each other.

        To stop associating the traces one can either call
        generate_and_set_tracing_token() once again or call unset_tracing_token().
        The former is suitable if you still want to trace but in a fresh
        context, and the latter will go back to unique traces per Paid.trace().
        """
        return _generate_and_set_tracing_token()

    def set_tracing_token(self, token: int):
        """
        *Advanced feature*
        In cases when you can't share the same Paid.trace() context with
        code that you want to track together (complex concurrency logic,
        or disjoint workflows, or work is separated between processes),
        then you can manually generate a tracing token with generate_and_set_traceing_token()
        and share it with the other parts of your application or service using set_tracing_token().

        Sets tracing token. Provided token should come from generate_and_set_tracing_token().
        Once set, the consequent traces will be related to each other.
        """

        _set_tracing_token(token)

    def unset_tracing_token(self):
        """
        Unsets the token previously set by generate_and_set_tracing_token()
        or by set_tracing_token(token). Does nothing if the token was never set.
        When tracing token is unset, traces are unique for a single Paid.trace() context.
        """
        _unset_tracing_token()

    async def capture(
        self,
        external_customer_id: str,
        fn: typing.Callable[[], typing.Awaitable[T]],
        args: typing.Optional[typing.Tuple] = None,
        kwargs: typing.Optional[typing.Dict] = None,
    ) -> typing.Union[T, typing.Awaitable[T]]:
        print("capture() is deprecated. Please rename it to trace() to remove this message.")
        return await _trace_async(
            external_customer_id=external_customer_id, fn=fn, external_agent_id=None, args=args, kwargs=kwargs
        )

    async def trace(
        self,
        external_customer_id: str,
        fn: typing.Callable[[], typing.Awaitable[T]],
        external_agent_id: typing.Optional[str] = None,
        args: typing.Optional[typing.Tuple] = None,
        kwargs: typing.Optional[typing.Dict] = None,
    ) -> typing.Union[T, typing.Awaitable[T]]:
        """
        Traces the execution of the provided function asynchronously.

        Parameters
        ----------
        external_customer_id : str
            The external customer ID to associate with the trace.
        fn : typing.Callable[[], typing.Awaitable[T]]
            The async function to be traced.
        external_agent_id : typing.Optional[str], optional
            The external agent ID to associate with the trace, by default None.
        args : typing.Optional[typing.Tuple], optional
            Positional arguments to pass to the function, by default None.
        kwargs : typing.Optional[typing.Dict], optional
            Keyword arguments to pass to the function, by default None.

        Returns
        -------
        T
            The result of the traced function.
        """
        return await _trace_async(
            external_customer_id=external_customer_id,
            fn=fn,
            external_agent_id=external_agent_id,
            args=args,
            kwargs=kwargs,
        )

    def signal(
        self,
        event_name: str,
        *,
        data: typing.Optional[typing.Dict[str, typing.Any]] = None,
        enable_cost_tracing: bool = False,
    ) -> None:
        """
        Sends Paid signal. Needs to be called as part of callback to Paid.trace().
        When enable_cost_tracing flag is on, signal is associated
        with cost traces from the same Paid.trace() context.

        Parameters
        ----------
        event_name : str
            The name of the signal.
        data : typing.Optional[typing.Dict[str, typing.Any]], optional
            Additional data to include with the signal event.
        enable_cost_tracing : bool, optional
            Whether to associate this signal with cost traces from the current Paid.trace() context.
            Defaults to False.

        Usage
        -----
        signal("event_name")
        signal("event_name", data={"key": "value"})
        signal("event_name", enable_cost_tracing=True)
        signal("event_name", enable_cost_tracing=True, data={"key": "value"})

        Notes
        -----
        When enable_cost_tracing is on, the signal will be associated with cost
        traces within the same Paid.trace() context.
        It is advised to only make one call to this function
        with enable_cost_tracing per Paid.trace() context.
        Otherwise, there will be multiple signals that refer to the same costs.
        """
        _signal(event_name=event_name, enable_cost_tracing=enable_cost_tracing, data=data)


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: PaidEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
