# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.address import Address
from ..types.creation_source import CreationSource
from ..types.customer import Customer
from ..types.tax_exempt_status import TaxExemptStatus
from .raw_client import AsyncRawCustomersClient, RawCustomersClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CustomersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCustomersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCustomersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCustomersClient
        """
        return self._raw_client

    def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.List[Customer]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Customer]
            Success response

        Examples
        --------
        from paid import Paid

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.customers.list()
        """
        _response = self._raw_client.list(request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        name: str,
        external_id: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        employee_count: typing.Optional[float] = OMIT,
        annual_revenue: typing.Optional[float] = OMIT,
        tax_exempt_status: typing.Optional[TaxExemptStatus] = OMIT,
        creation_source: typing.Optional[CreationSource] = OMIT,
        website: typing.Optional[str] = OMIT,
        billing_address: typing.Optional[Address] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Customer:
        """
        Parameters
        ----------
        name : str

        external_id : typing.Optional[str]

        phone : typing.Optional[str]

        employee_count : typing.Optional[float]

        annual_revenue : typing.Optional[float]

        tax_exempt_status : typing.Optional[TaxExemptStatus]

        creation_source : typing.Optional[CreationSource]

        website : typing.Optional[str]

        billing_address : typing.Optional[Address]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Customer
            Success response

        Examples
        --------
        from paid import Paid

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.customers.create(
            name="name",
        )
        """
        _response = self._raw_client.create(
            name=name,
            external_id=external_id,
            phone=phone,
            employee_count=employee_count,
            annual_revenue=annual_revenue,
            tax_exempt_status=tax_exempt_status,
            creation_source=creation_source,
            website=website,
            billing_address=billing_address,
            request_options=request_options,
        )
        return _response.data

    def get(self, customer_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Customer:
        """
        Parameters
        ----------
        customer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Customer
            Success response

        Examples
        --------
        from paid import Paid

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.customers.get(
            customer_id="customerId",
        )
        """
        _response = self._raw_client.get(customer_id, request_options=request_options)
        return _response.data

    def update(
        self,
        customer_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        employee_count: typing.Optional[float] = OMIT,
        annual_revenue: typing.Optional[float] = OMIT,
        tax_exempt_status: typing.Optional[TaxExemptStatus] = OMIT,
        creation_source: typing.Optional[CreationSource] = OMIT,
        website: typing.Optional[str] = OMIT,
        billing_address: typing.Optional[Address] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Customer:
        """
        Parameters
        ----------
        customer_id : str

        name : typing.Optional[str]

        external_id : typing.Optional[str]

        phone : typing.Optional[str]

        employee_count : typing.Optional[float]

        annual_revenue : typing.Optional[float]

        tax_exempt_status : typing.Optional[TaxExemptStatus]

        creation_source : typing.Optional[CreationSource]

        website : typing.Optional[str]

        billing_address : typing.Optional[Address]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Customer
            Customer updated successfully

        Examples
        --------
        from paid import Paid

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.customers.update(
            customer_id="customerId",
        )
        """
        _response = self._raw_client.update(
            customer_id,
            name=name,
            external_id=external_id,
            phone=phone,
            employee_count=employee_count,
            annual_revenue=annual_revenue,
            tax_exempt_status=tax_exempt_status,
            creation_source=creation_source,
            website=website,
            billing_address=billing_address,
            request_options=request_options,
        )
        return _response.data

    def delete(self, customer_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        customer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from paid import Paid

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.customers.delete(
            customer_id="customerId",
        )
        """
        _response = self._raw_client.delete(customer_id, request_options=request_options)
        return _response.data

    def get_by_external_id(
        self, external_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Customer:
        """
        Parameters
        ----------
        external_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Customer
            Success response

        Examples
        --------
        from paid import Paid

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.customers.get_by_external_id(
            external_id="externalId",
        )
        """
        _response = self._raw_client.get_by_external_id(external_id, request_options=request_options)
        return _response.data

    def update_by_external_id(
        self,
        external_id_: str,
        *,
        name: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        employee_count: typing.Optional[float] = OMIT,
        annual_revenue: typing.Optional[float] = OMIT,
        tax_exempt_status: typing.Optional[TaxExemptStatus] = OMIT,
        creation_source: typing.Optional[CreationSource] = OMIT,
        website: typing.Optional[str] = OMIT,
        billing_address: typing.Optional[Address] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Customer:
        """
        Parameters
        ----------
        external_id_ : str

        name : typing.Optional[str]

        external_id : typing.Optional[str]

        phone : typing.Optional[str]

        employee_count : typing.Optional[float]

        annual_revenue : typing.Optional[float]

        tax_exempt_status : typing.Optional[TaxExemptStatus]

        creation_source : typing.Optional[CreationSource]

        website : typing.Optional[str]

        billing_address : typing.Optional[Address]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Customer
            Success response

        Examples
        --------
        from paid import Paid

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.customers.update_by_external_id(
            external_id_="externalId",
        )
        """
        _response = self._raw_client.update_by_external_id(
            external_id_,
            name=name,
            external_id=external_id,
            phone=phone,
            employee_count=employee_count,
            annual_revenue=annual_revenue,
            tax_exempt_status=tax_exempt_status,
            creation_source=creation_source,
            website=website,
            billing_address=billing_address,
            request_options=request_options,
        )
        return _response.data

    def delete_by_external_id(
        self, external_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        external_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from paid import Paid

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.customers.delete_by_external_id(
            external_id="externalId",
        )
        """
        _response = self._raw_client.delete_by_external_id(external_id, request_options=request_options)
        return _response.data


class AsyncCustomersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCustomersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCustomersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCustomersClient
        """
        return self._raw_client

    async def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.List[Customer]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Customer]
            Success response

        Examples
        --------
        import asyncio

        from paid import AsyncPaid

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.customers.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        name: str,
        external_id: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        employee_count: typing.Optional[float] = OMIT,
        annual_revenue: typing.Optional[float] = OMIT,
        tax_exempt_status: typing.Optional[TaxExemptStatus] = OMIT,
        creation_source: typing.Optional[CreationSource] = OMIT,
        website: typing.Optional[str] = OMIT,
        billing_address: typing.Optional[Address] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Customer:
        """
        Parameters
        ----------
        name : str

        external_id : typing.Optional[str]

        phone : typing.Optional[str]

        employee_count : typing.Optional[float]

        annual_revenue : typing.Optional[float]

        tax_exempt_status : typing.Optional[TaxExemptStatus]

        creation_source : typing.Optional[CreationSource]

        website : typing.Optional[str]

        billing_address : typing.Optional[Address]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Customer
            Success response

        Examples
        --------
        import asyncio

        from paid import AsyncPaid

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.customers.create(
                name="name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name,
            external_id=external_id,
            phone=phone,
            employee_count=employee_count,
            annual_revenue=annual_revenue,
            tax_exempt_status=tax_exempt_status,
            creation_source=creation_source,
            website=website,
            billing_address=billing_address,
            request_options=request_options,
        )
        return _response.data

    async def get(self, customer_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Customer:
        """
        Parameters
        ----------
        customer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Customer
            Success response

        Examples
        --------
        import asyncio

        from paid import AsyncPaid

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.customers.get(
                customer_id="customerId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(customer_id, request_options=request_options)
        return _response.data

    async def update(
        self,
        customer_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        employee_count: typing.Optional[float] = OMIT,
        annual_revenue: typing.Optional[float] = OMIT,
        tax_exempt_status: typing.Optional[TaxExemptStatus] = OMIT,
        creation_source: typing.Optional[CreationSource] = OMIT,
        website: typing.Optional[str] = OMIT,
        billing_address: typing.Optional[Address] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Customer:
        """
        Parameters
        ----------
        customer_id : str

        name : typing.Optional[str]

        external_id : typing.Optional[str]

        phone : typing.Optional[str]

        employee_count : typing.Optional[float]

        annual_revenue : typing.Optional[float]

        tax_exempt_status : typing.Optional[TaxExemptStatus]

        creation_source : typing.Optional[CreationSource]

        website : typing.Optional[str]

        billing_address : typing.Optional[Address]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Customer
            Customer updated successfully

        Examples
        --------
        import asyncio

        from paid import AsyncPaid

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.customers.update(
                customer_id="customerId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            customer_id,
            name=name,
            external_id=external_id,
            phone=phone,
            employee_count=employee_count,
            annual_revenue=annual_revenue,
            tax_exempt_status=tax_exempt_status,
            creation_source=creation_source,
            website=website,
            billing_address=billing_address,
            request_options=request_options,
        )
        return _response.data

    async def delete(self, customer_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        customer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from paid import AsyncPaid

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.customers.delete(
                customer_id="customerId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(customer_id, request_options=request_options)
        return _response.data

    async def get_by_external_id(
        self, external_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Customer:
        """
        Parameters
        ----------
        external_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Customer
            Success response

        Examples
        --------
        import asyncio

        from paid import AsyncPaid

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.customers.get_by_external_id(
                external_id="externalId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_external_id(external_id, request_options=request_options)
        return _response.data

    async def update_by_external_id(
        self,
        external_id_: str,
        *,
        name: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        employee_count: typing.Optional[float] = OMIT,
        annual_revenue: typing.Optional[float] = OMIT,
        tax_exempt_status: typing.Optional[TaxExemptStatus] = OMIT,
        creation_source: typing.Optional[CreationSource] = OMIT,
        website: typing.Optional[str] = OMIT,
        billing_address: typing.Optional[Address] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Customer:
        """
        Parameters
        ----------
        external_id_ : str

        name : typing.Optional[str]

        external_id : typing.Optional[str]

        phone : typing.Optional[str]

        employee_count : typing.Optional[float]

        annual_revenue : typing.Optional[float]

        tax_exempt_status : typing.Optional[TaxExemptStatus]

        creation_source : typing.Optional[CreationSource]

        website : typing.Optional[str]

        billing_address : typing.Optional[Address]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Customer
            Success response

        Examples
        --------
        import asyncio

        from paid import AsyncPaid

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.customers.update_by_external_id(
                external_id_="externalId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_by_external_id(
            external_id_,
            name=name,
            external_id=external_id,
            phone=phone,
            employee_count=employee_count,
            annual_revenue=annual_revenue,
            tax_exempt_status=tax_exempt_status,
            creation_source=creation_source,
            website=website,
            billing_address=billing_address,
            request_options=request_options,
        )
        return _response.data

    async def delete_by_external_id(
        self, external_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        external_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from paid import AsyncPaid

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.customers.delete_by_external_id(
                external_id="externalId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_external_id(external_id, request_options=request_options)
        return _response.data
