# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..types.address import Address
from ..types.creation_source import CreationSource
from ..types.customer import Customer
from ..types.tax_exempt_status import TaxExemptStatus

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawCustomersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[typing.List[Customer]]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[Customer]]
            Success response
        """
        _response = self._client_wrapper.httpx_client.request(
            "customers",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[Customer],
                    parse_obj_as(
                        type_=typing.List[Customer],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        *,
        name: str,
        external_id: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        employee_count: typing.Optional[float] = OMIT,
        annual_revenue: typing.Optional[float] = OMIT,
        tax_exempt_status: typing.Optional[TaxExemptStatus] = OMIT,
        creation_source: typing.Optional[CreationSource] = OMIT,
        website: typing.Optional[str] = OMIT,
        billing_address: typing.Optional[Address] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Customer]:
        """
        Parameters
        ----------
        name : str

        external_id : typing.Optional[str]

        phone : typing.Optional[str]

        employee_count : typing.Optional[float]

        annual_revenue : typing.Optional[float]

        tax_exempt_status : typing.Optional[TaxExemptStatus]

        creation_source : typing.Optional[CreationSource]

        website : typing.Optional[str]

        billing_address : typing.Optional[Address]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Customer]
            Success response
        """
        _response = self._client_wrapper.httpx_client.request(
            "customers",
            method="POST",
            json={
                "name": name,
                "externalId": external_id,
                "phone": phone,
                "employeeCount": employee_count,
                "annualRevenue": annual_revenue,
                "taxExemptStatus": tax_exempt_status,
                "creationSource": creation_source,
                "website": website,
                "billingAddress": convert_and_respect_annotation_metadata(
                    object_=billing_address, annotation=Address, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Customer,
                    parse_obj_as(
                        type_=Customer,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self, customer_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[Customer]:
        """
        Parameters
        ----------
        customer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Customer]
            Success response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"customers/{jsonable_encoder(customer_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Customer,
                    parse_obj_as(
                        type_=Customer,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        customer_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        employee_count: typing.Optional[float] = OMIT,
        annual_revenue: typing.Optional[float] = OMIT,
        tax_exempt_status: typing.Optional[TaxExemptStatus] = OMIT,
        creation_source: typing.Optional[CreationSource] = OMIT,
        website: typing.Optional[str] = OMIT,
        billing_address: typing.Optional[Address] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Customer]:
        """
        Parameters
        ----------
        customer_id : str

        name : typing.Optional[str]

        external_id : typing.Optional[str]

        phone : typing.Optional[str]

        employee_count : typing.Optional[float]

        annual_revenue : typing.Optional[float]

        tax_exempt_status : typing.Optional[TaxExemptStatus]

        creation_source : typing.Optional[CreationSource]

        website : typing.Optional[str]

        billing_address : typing.Optional[Address]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Customer]
            Customer updated successfully
        """
        _response = self._client_wrapper.httpx_client.request(
            f"customers/{jsonable_encoder(customer_id)}",
            method="PUT",
            json={
                "name": name,
                "externalId": external_id,
                "phone": phone,
                "employeeCount": employee_count,
                "annualRevenue": annual_revenue,
                "taxExemptStatus": tax_exempt_status,
                "creationSource": creation_source,
                "website": website,
                "billingAddress": convert_and_respect_annotation_metadata(
                    object_=billing_address, annotation=Address, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Customer,
                    parse_obj_as(
                        type_=Customer,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(
        self, customer_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Parameters
        ----------
        customer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"customers/{jsonable_encoder(customer_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_by_external_id(
        self, external_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[Customer]:
        """
        Parameters
        ----------
        external_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Customer]
            Success response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"customers/external/{jsonable_encoder(external_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Customer,
                    parse_obj_as(
                        type_=Customer,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_by_external_id(
        self,
        external_id_: str,
        *,
        name: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        employee_count: typing.Optional[float] = OMIT,
        annual_revenue: typing.Optional[float] = OMIT,
        tax_exempt_status: typing.Optional[TaxExemptStatus] = OMIT,
        creation_source: typing.Optional[CreationSource] = OMIT,
        website: typing.Optional[str] = OMIT,
        billing_address: typing.Optional[Address] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Customer]:
        """
        Parameters
        ----------
        external_id_ : str

        name : typing.Optional[str]

        external_id : typing.Optional[str]

        phone : typing.Optional[str]

        employee_count : typing.Optional[float]

        annual_revenue : typing.Optional[float]

        tax_exempt_status : typing.Optional[TaxExemptStatus]

        creation_source : typing.Optional[CreationSource]

        website : typing.Optional[str]

        billing_address : typing.Optional[Address]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Customer]
            Success response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"customers/external/{jsonable_encoder(external_id_)}",
            method="PUT",
            json={
                "name": name,
                "externalId": external_id,
                "phone": phone,
                "employeeCount": employee_count,
                "annualRevenue": annual_revenue,
                "taxExemptStatus": tax_exempt_status,
                "creationSource": creation_source,
                "website": website,
                "billingAddress": convert_and_respect_annotation_metadata(
                    object_=billing_address, annotation=Address, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Customer,
                    parse_obj_as(
                        type_=Customer,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_by_external_id(
        self, external_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Parameters
        ----------
        external_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"customers/external/{jsonable_encoder(external_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawCustomersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.List[Customer]]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[Customer]]
            Success response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "customers",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[Customer],
                    parse_obj_as(
                        type_=typing.List[Customer],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        *,
        name: str,
        external_id: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        employee_count: typing.Optional[float] = OMIT,
        annual_revenue: typing.Optional[float] = OMIT,
        tax_exempt_status: typing.Optional[TaxExemptStatus] = OMIT,
        creation_source: typing.Optional[CreationSource] = OMIT,
        website: typing.Optional[str] = OMIT,
        billing_address: typing.Optional[Address] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Customer]:
        """
        Parameters
        ----------
        name : str

        external_id : typing.Optional[str]

        phone : typing.Optional[str]

        employee_count : typing.Optional[float]

        annual_revenue : typing.Optional[float]

        tax_exempt_status : typing.Optional[TaxExemptStatus]

        creation_source : typing.Optional[CreationSource]

        website : typing.Optional[str]

        billing_address : typing.Optional[Address]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Customer]
            Success response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "customers",
            method="POST",
            json={
                "name": name,
                "externalId": external_id,
                "phone": phone,
                "employeeCount": employee_count,
                "annualRevenue": annual_revenue,
                "taxExemptStatus": tax_exempt_status,
                "creationSource": creation_source,
                "website": website,
                "billingAddress": convert_and_respect_annotation_metadata(
                    object_=billing_address, annotation=Address, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Customer,
                    parse_obj_as(
                        type_=Customer,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self, customer_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Customer]:
        """
        Parameters
        ----------
        customer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Customer]
            Success response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"customers/{jsonable_encoder(customer_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Customer,
                    parse_obj_as(
                        type_=Customer,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        customer_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        employee_count: typing.Optional[float] = OMIT,
        annual_revenue: typing.Optional[float] = OMIT,
        tax_exempt_status: typing.Optional[TaxExemptStatus] = OMIT,
        creation_source: typing.Optional[CreationSource] = OMIT,
        website: typing.Optional[str] = OMIT,
        billing_address: typing.Optional[Address] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Customer]:
        """
        Parameters
        ----------
        customer_id : str

        name : typing.Optional[str]

        external_id : typing.Optional[str]

        phone : typing.Optional[str]

        employee_count : typing.Optional[float]

        annual_revenue : typing.Optional[float]

        tax_exempt_status : typing.Optional[TaxExemptStatus]

        creation_source : typing.Optional[CreationSource]

        website : typing.Optional[str]

        billing_address : typing.Optional[Address]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Customer]
            Customer updated successfully
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"customers/{jsonable_encoder(customer_id)}",
            method="PUT",
            json={
                "name": name,
                "externalId": external_id,
                "phone": phone,
                "employeeCount": employee_count,
                "annualRevenue": annual_revenue,
                "taxExemptStatus": tax_exempt_status,
                "creationSource": creation_source,
                "website": website,
                "billingAddress": convert_and_respect_annotation_metadata(
                    object_=billing_address, annotation=Address, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Customer,
                    parse_obj_as(
                        type_=Customer,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self, customer_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Parameters
        ----------
        customer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"customers/{jsonable_encoder(customer_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_by_external_id(
        self, external_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Customer]:
        """
        Parameters
        ----------
        external_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Customer]
            Success response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"customers/external/{jsonable_encoder(external_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Customer,
                    parse_obj_as(
                        type_=Customer,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_by_external_id(
        self,
        external_id_: str,
        *,
        name: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        employee_count: typing.Optional[float] = OMIT,
        annual_revenue: typing.Optional[float] = OMIT,
        tax_exempt_status: typing.Optional[TaxExemptStatus] = OMIT,
        creation_source: typing.Optional[CreationSource] = OMIT,
        website: typing.Optional[str] = OMIT,
        billing_address: typing.Optional[Address] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Customer]:
        """
        Parameters
        ----------
        external_id_ : str

        name : typing.Optional[str]

        external_id : typing.Optional[str]

        phone : typing.Optional[str]

        employee_count : typing.Optional[float]

        annual_revenue : typing.Optional[float]

        tax_exempt_status : typing.Optional[TaxExemptStatus]

        creation_source : typing.Optional[CreationSource]

        website : typing.Optional[str]

        billing_address : typing.Optional[Address]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Customer]
            Success response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"customers/external/{jsonable_encoder(external_id_)}",
            method="PUT",
            json={
                "name": name,
                "externalId": external_id,
                "phone": phone,
                "employeeCount": employee_count,
                "annualRevenue": annual_revenue,
                "taxExemptStatus": tax_exempt_status,
                "creationSource": creation_source,
                "website": website,
                "billingAddress": convert_and_respect_annotation_metadata(
                    object_=billing_address, annotation=Address, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Customer,
                    parse_obj_as(
                        type_=Customer,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_by_external_id(
        self, external_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Parameters
        ----------
        external_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"customers/external/{jsonable_encoder(external_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
