# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.order import Order
from ...types.order_line_create import OrderLineCreate
from .raw_client import AsyncRawLinesClient, RawLinesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class LinesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawLinesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawLinesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawLinesClient
        """
        return self._raw_client

    def update(
        self,
        order_id: str,
        *,
        lines: typing.Optional[typing.Sequence[OrderLineCreate]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Order:
        """
        Parameters
        ----------
        order_id : str

        lines : typing.Optional[typing.Sequence[OrderLineCreate]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Order
            Success response

        Examples
        --------
        from paid import Paid

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.orders.lines.update(
            order_id="orderId",
        )
        """
        _response = self._raw_client.update(order_id, lines=lines, request_options=request_options)
        return _response.data


class AsyncLinesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawLinesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawLinesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawLinesClient
        """
        return self._raw_client

    async def update(
        self,
        order_id: str,
        *,
        lines: typing.Optional[typing.Sequence[OrderLineCreate]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Order:
        """
        Parameters
        ----------
        order_id : str

        lines : typing.Optional[typing.Sequence[OrderLineCreate]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Order
            Success response

        Examples
        --------
        import asyncio

        from paid import AsyncPaid

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.orders.lines.update(
                order_id="orderId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(order_id, lines=lines, request_options=request_options)
        return _response.data
