# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .agent_price_point import AgentPricePoint
from .billing_frequency import BillingFrequency
from .charge_type import ChargeType
from .pricing_model_type import PricingModelType


class Pricing(UniversalBaseModel):
    event_name: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="eventName")] = None
    taxable: bool
    charge_type: typing_extensions.Annotated[ChargeType, FieldMetadata(alias="chargeType")]
    pricing_model: typing_extensions.Annotated[PricingModelType, FieldMetadata(alias="pricingModel")]
    billing_frequency: typing_extensions.Annotated[BillingFrequency, FieldMetadata(alias="billingFrequency")]
    price_points: typing_extensions.Annotated[typing.Dict[str, AgentPricePoint], FieldMetadata(alias="pricePoints")]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
