# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..types.signal import Signal

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawUsageClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def record_bulk(
        self,
        *,
        signals: typing.Optional[typing.Sequence[Signal]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[typing.Optional[typing.Any]]]:
        """
        Parameters
        ----------
        signals : typing.Optional[typing.Sequence[Signal]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[typing.Optional[typing.Any]]]
            Success response
        """
        _response = self._client_wrapper.httpx_client.request(
            "usage/signals/bulk",
            method="POST",
            json={
                "signals": convert_and_respect_annotation_metadata(
                    object_=signals, annotation=typing.Sequence[Signal], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[typing.Optional[typing.Any]],
                    parse_obj_as(
                        type_=typing.List[typing.Optional[typing.Any]],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawUsageClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def record_bulk(
        self,
        *,
        signals: typing.Optional[typing.Sequence[Signal]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[typing.Optional[typing.Any]]]:
        """
        Parameters
        ----------
        signals : typing.Optional[typing.Sequence[Signal]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[typing.Optional[typing.Any]]]
            Success response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "usage/signals/bulk",
            method="POST",
            json={
                "signals": convert_and_respect_annotation_metadata(
                    object_=signals, annotation=typing.Sequence[Signal], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[typing.Optional[typing.Any]],
                    parse_obj_as(
                        type_=typing.List[typing.Optional[typing.Any]],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
