# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

import os
from typing import Any, cast

import pytest

from tests.utils import assert_matches_type
from ours_privacy import OursPrivacy, AsyncOursPrivacy
from ours_privacy.types import VisitorUpsertResponse

base_url = os.environ.get("TEST_API_BASE_URL", "http://127.0.0.1:4010")


class TestVisitor:
    parametrize = pytest.mark.parametrize("client", [False, True], indirect=True, ids=["loose", "strict"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_upsert(self, client: OursPrivacy) -> None:
        visitor = client.visitor.upsert(
            token="x",
            user_properties={},
        )
        assert_matches_type(VisitorUpsertResponse, visitor, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_upsert_with_all_params(self, client: OursPrivacy) -> None:
        visitor = client.visitor.upsert(
            token="x",
            user_properties={
                "ad_id": "ad_id",
                "adset_id": "adset_id",
                "campaign_id": "campaign_id",
                "city": "city",
                "clickid": "clickid",
                "clid": "clid",
                "company_name": "company_name",
                "consent": {"foo": "bar"},
                "country": "country",
                "custom_properties": {"foo": "bar"},
                "date_of_birth": "date_of_birth",
                "dclid": "dclid",
                "email": "email",
                "epik": "epik",
                "external_id": "external_id",
                "fbc": "fbc",
                "fbclid": "fbclid",
                "fbp": "fbp",
                "first_name": "first_name",
                "gad_source": "gad_source",
                "gbraid": "gbraid",
                "gclid": "gclid",
                "gender": "gender",
                "ip": "ip",
                "is_bot": {},
                "job_title": "job_title",
                "last_name": "last_name",
                "li_fat_id": "li_fat_id",
                "msclkid": "msclkid",
                "ndclid": "ndclid",
                "phone_number": {},
                "qclid": "qclid",
                "rdt_cid": "rdt_cid",
                "referrer": "referrer",
                "sacid": "sacid",
                "sccid": "sccid",
                "sid": "sid",
                "state": "state",
                "ttclid": "ttclid",
                "twclid": "twclid",
                "user_agent": "user_agent",
                "user_agent_full_list": "user_agent_full_list",
                "utm_campaign": "utm_campaign",
                "utm_content": "utm_content",
                "utm_medium": "utm_medium",
                "utm_name": "utm_name",
                "utm_source": "utm_source",
                "utm_term": "utm_term",
                "wbraid": "wbraid",
                "zip": {},
            },
            default_properties={
                "active_duration": 0,
                "ad_id": "ad_id",
                "adset_id": "adset_id",
                "browser_language": "browser_language",
                "browser_name": "browser_name",
                "browser_version": "browser_version",
                "campaign_id": "campaign_id",
                "clickid": "clickid",
                "clid": "clid",
                "cpu_architecture": "cpu_architecture",
                "current_url": "current_url",
                "dclid": "dclid",
                "device_model": "device_model",
                "device_type": "device_type",
                "device_vendor": "device_vendor",
                "duration": 0,
                "encoding": "encoding",
                "engine_name": "engine_name",
                "engine_version": "engine_version",
                "epik": "epik",
                "fbc": "fbc",
                "fbclid": "fbclid",
                "fbp": "fbp",
                "fv": True,
                "gad_source": "gad_source",
                "gbraid": "gbraid",
                "gclid": "gclid",
                "host": "host",
                "iframe": True,
                "ip": "ip",
                "is_bot": {},
                "li_fat_id": "li_fat_id",
                "msclkid": "msclkid",
                "ndclid": "ndclid",
                "new_s": True,
                "os_name": "os_name",
                "os_version": "os_version",
                "page_hash": 0,
                "pathname": "pathname",
                "qclid": "qclid",
                "rdt_cid": "rdt_cid",
                "received_at": "received_at",
                "referrer": "referrer",
                "sacid": "sacid",
                "sccid": "sccid",
                "screen_height": 0,
                "screen_width": 0,
                "session_count": 0,
                "sid": "sid",
                "sr": "sr",
                "title": "title",
                "ttclid": "ttclid",
                "twclid": "twclid",
                "uafvl": "uafvl",
                "user_agent": "user_agent",
                "utm_campaign": "utm_campaign",
                "utm_content": "utm_content",
                "utm_medium": "utm_medium",
                "utm_name": "utm_name",
                "utm_source": "utm_source",
                "utm_term": "utm_term",
                "version": "version",
                "wbraid": "wbraid",
                "webview": True,
            },
            email="x",
            external_id="x",
            user_id="x",
        )
        assert_matches_type(VisitorUpsertResponse, visitor, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_raw_response_upsert(self, client: OursPrivacy) -> None:
        response = client.visitor.with_raw_response.upsert(
            token="x",
            user_properties={},
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        visitor = response.parse()
        assert_matches_type(VisitorUpsertResponse, visitor, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_streaming_response_upsert(self, client: OursPrivacy) -> None:
        with client.visitor.with_streaming_response.upsert(
            token="x",
            user_properties={},
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            visitor = response.parse()
            assert_matches_type(VisitorUpsertResponse, visitor, path=["response"])

        assert cast(Any, response.is_closed) is True


class TestAsyncVisitor:
    parametrize = pytest.mark.parametrize(
        "async_client", [False, True, {"http_client": "aiohttp"}], indirect=True, ids=["loose", "strict", "aiohttp"]
    )

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_upsert(self, async_client: AsyncOursPrivacy) -> None:
        visitor = await async_client.visitor.upsert(
            token="x",
            user_properties={},
        )
        assert_matches_type(VisitorUpsertResponse, visitor, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_upsert_with_all_params(self, async_client: AsyncOursPrivacy) -> None:
        visitor = await async_client.visitor.upsert(
            token="x",
            user_properties={
                "ad_id": "ad_id",
                "adset_id": "adset_id",
                "campaign_id": "campaign_id",
                "city": "city",
                "clickid": "clickid",
                "clid": "clid",
                "company_name": "company_name",
                "consent": {"foo": "bar"},
                "country": "country",
                "custom_properties": {"foo": "bar"},
                "date_of_birth": "date_of_birth",
                "dclid": "dclid",
                "email": "email",
                "epik": "epik",
                "external_id": "external_id",
                "fbc": "fbc",
                "fbclid": "fbclid",
                "fbp": "fbp",
                "first_name": "first_name",
                "gad_source": "gad_source",
                "gbraid": "gbraid",
                "gclid": "gclid",
                "gender": "gender",
                "ip": "ip",
                "is_bot": {},
                "job_title": "job_title",
                "last_name": "last_name",
                "li_fat_id": "li_fat_id",
                "msclkid": "msclkid",
                "ndclid": "ndclid",
                "phone_number": {},
                "qclid": "qclid",
                "rdt_cid": "rdt_cid",
                "referrer": "referrer",
                "sacid": "sacid",
                "sccid": "sccid",
                "sid": "sid",
                "state": "state",
                "ttclid": "ttclid",
                "twclid": "twclid",
                "user_agent": "user_agent",
                "user_agent_full_list": "user_agent_full_list",
                "utm_campaign": "utm_campaign",
                "utm_content": "utm_content",
                "utm_medium": "utm_medium",
                "utm_name": "utm_name",
                "utm_source": "utm_source",
                "utm_term": "utm_term",
                "wbraid": "wbraid",
                "zip": {},
            },
            default_properties={
                "active_duration": 0,
                "ad_id": "ad_id",
                "adset_id": "adset_id",
                "browser_language": "browser_language",
                "browser_name": "browser_name",
                "browser_version": "browser_version",
                "campaign_id": "campaign_id",
                "clickid": "clickid",
                "clid": "clid",
                "cpu_architecture": "cpu_architecture",
                "current_url": "current_url",
                "dclid": "dclid",
                "device_model": "device_model",
                "device_type": "device_type",
                "device_vendor": "device_vendor",
                "duration": 0,
                "encoding": "encoding",
                "engine_name": "engine_name",
                "engine_version": "engine_version",
                "epik": "epik",
                "fbc": "fbc",
                "fbclid": "fbclid",
                "fbp": "fbp",
                "fv": True,
                "gad_source": "gad_source",
                "gbraid": "gbraid",
                "gclid": "gclid",
                "host": "host",
                "iframe": True,
                "ip": "ip",
                "is_bot": {},
                "li_fat_id": "li_fat_id",
                "msclkid": "msclkid",
                "ndclid": "ndclid",
                "new_s": True,
                "os_name": "os_name",
                "os_version": "os_version",
                "page_hash": 0,
                "pathname": "pathname",
                "qclid": "qclid",
                "rdt_cid": "rdt_cid",
                "received_at": "received_at",
                "referrer": "referrer",
                "sacid": "sacid",
                "sccid": "sccid",
                "screen_height": 0,
                "screen_width": 0,
                "session_count": 0,
                "sid": "sid",
                "sr": "sr",
                "title": "title",
                "ttclid": "ttclid",
                "twclid": "twclid",
                "uafvl": "uafvl",
                "user_agent": "user_agent",
                "utm_campaign": "utm_campaign",
                "utm_content": "utm_content",
                "utm_medium": "utm_medium",
                "utm_name": "utm_name",
                "utm_source": "utm_source",
                "utm_term": "utm_term",
                "version": "version",
                "wbraid": "wbraid",
                "webview": True,
            },
            email="x",
            external_id="x",
            user_id="x",
        )
        assert_matches_type(VisitorUpsertResponse, visitor, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_raw_response_upsert(self, async_client: AsyncOursPrivacy) -> None:
        response = await async_client.visitor.with_raw_response.upsert(
            token="x",
            user_properties={},
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        visitor = await response.parse()
        assert_matches_type(VisitorUpsertResponse, visitor, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_streaming_response_upsert(self, async_client: AsyncOursPrivacy) -> None:
        async with async_client.visitor.with_streaming_response.upsert(
            token="x",
            user_properties={},
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            visitor = await response.parse()
            assert_matches_type(VisitorUpsertResponse, visitor, path=["response"])

        assert cast(Any, response.is_closed) is True
