#!/usr/bin/env python
#

"""hvl_ccb documentation build configuration file, created by
sphinx-quickstart on Fri Jun  9 13:47:02 2017.

This file is execfile()d with the current directory set to its
containing dir.

Note that not all possible configuration values are present in this
autogenerated file.

All configuration values have a default; values that are commented out
serve to show the default.

If extensions (or modules to document with autodoc) are in another
directory, add these directories to sys.path here. If the directory is
relative to the documentation root, use os.path.abspath to make it
absolute, like shown here."""

import os
import sys
from pathlib import Path

sys.path.insert(0, str(Path("..").resolve()))

with (Path("..") / "VERSION").open() as version_file:
    hvl_ccb_version = version_file.read().strip()

# -- General configuration ---------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions = [
    "myst_parser",
    "sphinx.ext.autodoc",
    "sphinx.ext.viewcode",
    "sphinx.ext.graphviz",
    "sphinx.ext.inheritance_diagram",
]

autodoc_mock_imports = []
if (
    os.environ.get("DOCS_RELAXED_IMPORTS") == "1"
    or os.environ.get("READTHEDOCS") == "True"
):
    autodoc_mock_imports = [
        "libtiepie",  # the Python wrapper
        "libtiepie.api",  # submodule seen in the traceback
        "usb",  # if your code imports pyusb
        "libusb1",  # some wrappers use this
        "picosdk",
    ]

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
# source_suffix = ".rst"
source_suffix = {
    ".rst": "restructuredtext",
    ".md": "markdown",
}

# The master toctree document.
master_doc = "index"

# General information about the project.
project = "HVL Common Code Base"
copyright = "2019-2025 ETH Zurich, SIS ID and HVL D-ITET"  # noqa: A001
author = "Henning Janssen, Chi-Ching Hsu"

# The version info for the project you're documenting, acts as replacement
# for |version| and |release|, also used in various other places throughout
# the built documents.
#
# The short X.Y version.
version = hvl_ccb_version
# The full version, including alpha/beta/rc tags.
release = hvl_ccb_version

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = ["_build", "Thumbs.db", ".DS_Store", "*i2c*"]

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = "sphinx"

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = False

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
add_module_names = False

# The output format for Graphviz when building HTML files. This must be either 'png'
# or 'svg'; the default is 'png'. If 'svg' is used, in order to make the URL links
# work properly, an appropriate target attribute must be set, such as "_top" and
# "_blank".
graphviz_output_format = "svg"

# A dictionary of graphviz graph attributes for inheritance diagrams.
inheritance_graph_attrs = {
    "rankdir": "TB",  # top to bottom
    "size": '""',
}

# -- Options for HTML output -------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "sphinx_rtd_theme"

# Theme options are theme-specific and customize the look and feel of a
# theme further.  For a list of options available for each theme, see the
# documentation.
#
html_theme_options = {
    "navigation_depth": 8,
}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["_static"]


# -- Options for HTMLHelp output ---------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = "hvl_ccbdoc"


# -- Options for LaTeX output ------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',
    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',
    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',
    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, documentclass
# [howto, manual, or own class]).
latex_documents = [
    (master_doc, "hvl_ccb.tex", "HVL Common Code Base Documentation", author, "manual"),
]


# -- Options for manual page output ------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [(master_doc, "hvl_ccb", "HVL Common Code Base Documentation", [author], 1)]


# -- Options for Texinfo output ----------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        master_doc,
        "hvl_ccb",
        "HVL Common Code Base Documentation",
        author,
        "hvl_ccb",
        "One line description of project.",
        "Miscellaneous",
    ),
]

# Add tags based on the environment to have customized documentation
if os.environ.get("READTHEDOCS") == "True":
    tags.add("rtd")  # pyright: ignore[reportUndefinedVariable] # noqa: F821
else:
    tags.add("gitlab")  # pyright: ignore[reportUndefinedVariable]  # noqa: F821
