# RoboSystems Python Client

[![PyPI version](https://badge.fury.io/py/robosystems-client.svg)](https://pypi.org/project/robosystems-client/)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)

Official Python Client for the RoboSystems Financial Knowledge Graph API. Access comprehensive financial data including accounting transactions, financial reports, and advanced graph analytics through a type-safe, async-ready Python interface.

## Features

- **Type-safe API client** with full type hints and Pydantic models
- **Async/await support** for high-performance applications  
- **Streaming support** for memory-efficient processing of large result sets
- **Financial AI Agent** integration for natural language queries
- **Comprehensive error handling** with custom exceptions

## Installation

```bash
pip install robosystems-client
```

## API Reference

- API reference: [https://api.robosystems.ai](https://api.robosystems.ai)
- API documentation: [https://api.robosystems.ai/docs](https://api.robosystems.ai/docs)
- OpenAPI specification: [https://api.robosystems.ai/openapi.json](https://api.robosystems.ai/openapi.json)

## Support

- Issues: [Issues](https://github.com/RoboFinSystems/robosystems-python-client/issues)
- Discussions: [Discussions](https://github.com/RoboFinSystems/robosystems-python-client/discussions)
- Projects: [Projects](https://github.com/RoboFinSystems/robosystems-python-client/projects)
- Wiki: [Wiki](https://github.com/RoboFinSystems/robosystems-python-client/wiki)

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

MIT © 2025 RFS LLC
