from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

if TYPE_CHECKING:
  from ..models.password_policy_response_policy import PasswordPolicyResponsePolicy


T = TypeVar("T", bound="PasswordPolicyResponse")


@_attrs_define
class PasswordPolicyResponse:
  """Password policy response model.

  Attributes:
      policy (PasswordPolicyResponsePolicy): Current password policy requirements
  """

  policy: "PasswordPolicyResponsePolicy"
  additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

  def to_dict(self) -> dict[str, Any]:
    policy = self.policy.to_dict()

    field_dict: dict[str, Any] = {}
    field_dict.update(self.additional_properties)
    field_dict.update(
      {
        "policy": policy,
      }
    )

    return field_dict

  @classmethod
  def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
    from ..models.password_policy_response_policy import PasswordPolicyResponsePolicy

    d = dict(src_dict)
    policy = PasswordPolicyResponsePolicy.from_dict(d.pop("policy"))

    password_policy_response = cls(
      policy=policy,
    )

    password_policy_response.additional_properties = d
    return password_policy_response

  @property
  def additional_keys(self) -> list[str]:
    return list(self.additional_properties.keys())

  def __getitem__(self, key: str) -> Any:
    return self.additional_properties[key]

  def __setitem__(self, key: str, value: Any) -> None:
    self.additional_properties[key] = value

  def __delitem__(self, key: str) -> None:
    del self.additional_properties[key]

  def __contains__(self, key: str) -> bool:
    return key in self.additional_properties
