from collections.abc import Mapping
from typing import Any, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="UpdateUserRequest")


@_attrs_define
class UpdateUserRequest:
  """Request model for updating user profile.

  Attributes:
      name (Union[None, Unset, str]): User's display name
      email (Union[None, Unset, str]): User's email address
  """

  name: Union[None, Unset, str] = UNSET
  email: Union[None, Unset, str] = UNSET
  additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

  def to_dict(self) -> dict[str, Any]:
    name: Union[None, Unset, str]
    if isinstance(self.name, Unset):
      name = UNSET
    else:
      name = self.name

    email: Union[None, Unset, str]
    if isinstance(self.email, Unset):
      email = UNSET
    else:
      email = self.email

    field_dict: dict[str, Any] = {}
    field_dict.update(self.additional_properties)
    field_dict.update({})
    if name is not UNSET:
      field_dict["name"] = name
    if email is not UNSET:
      field_dict["email"] = email

    return field_dict

  @classmethod
  def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
    d = dict(src_dict)

    def _parse_name(data: object) -> Union[None, Unset, str]:
      if data is None:
        return data
      if isinstance(data, Unset):
        return data
      return cast(Union[None, Unset, str], data)

    name = _parse_name(d.pop("name", UNSET))

    def _parse_email(data: object) -> Union[None, Unset, str]:
      if data is None:
        return data
      if isinstance(data, Unset):
        return data
      return cast(Union[None, Unset, str], data)

    email = _parse_email(d.pop("email", UNSET))

    update_user_request = cls(
      name=name,
      email=email,
    )

    update_user_request.additional_properties = d
    return update_user_request

  @property
  def additional_keys(self) -> list[str]:
    return list(self.additional_properties.keys())

  def __getitem__(self, key: str) -> Any:
    return self.additional_properties[key]

  def __setitem__(self, key: str, value: Any) -> None:
    self.additional_properties[key] = value

  def __delitem__(self, key: str) -> None:
    del self.additional_properties[key]

  def __contains__(self, key: str) -> bool:
    return key in self.additional_properties
