# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from typing import Dict
from Tea.core import TeaCore

from alibabacloud_tea_openapi.client import Client as OpenApiClient
from alibabacloud_tea_openapi import models as open_api_models
from alibabacloud_tea_util.client import Client as UtilClient
from alibabacloud_endpoint_util.client import Client as EndpointUtilClient
from alibabacloud_live20161101 import models as live_20161101_models
from alibabacloud_tea_util import models as util_models
from alibabacloud_openapi_util.client import Client as OpenApiUtilClient


class Client(OpenApiClient):
    """
    *\
    """
    def __init__(
        self, 
        config: open_api_models.Config,
    ):
        super().__init__(config)
        self._endpoint_rule = 'regional'
        self._endpoint_map = {
            'cn-qingdao': 'live.aliyuncs.com',
            'cn-beijing': 'live.aliyuncs.com',
            'cn-hangzhou': 'live.aliyuncs.com',
            'cn-shanghai': 'live.aliyuncs.com',
            'cn-shenzhen': 'live.aliyuncs.com',
            'ap-southeast-1': 'live.aliyuncs.com',
            'ap-southeast-5': 'live.aliyuncs.com',
            'ap-northeast-1': 'live.aliyuncs.com',
            'eu-central-1': 'live.aliyuncs.com',
            'ap-south-1': 'live.aliyuncs.com',
            'ap-northeast-2-pop': 'live.aliyuncs.com',
            'ap-southeast-2': 'live.aliyuncs.com',
            'ap-southeast-3': 'live.aliyuncs.com',
            'cn-beijing-finance-1': 'live.aliyuncs.com',
            'cn-beijing-finance-pop': 'live.aliyuncs.com',
            'cn-beijing-gov-1': 'live.aliyuncs.com',
            'cn-beijing-nu16-b01': 'live.aliyuncs.com',
            'cn-chengdu': 'live.aliyuncs.com',
            'cn-edge-1': 'live.aliyuncs.com',
            'cn-fujian': 'live.aliyuncs.com',
            'cn-haidian-cm12-c01': 'live.aliyuncs.com',
            'cn-hangzhou-bj-b01': 'live.aliyuncs.com',
            'cn-hangzhou-finance': 'live.aliyuncs.com',
            'cn-hangzhou-internal-prod-1': 'live.aliyuncs.com',
            'cn-hangzhou-internal-test-1': 'live.aliyuncs.com',
            'cn-hangzhou-internal-test-2': 'live.aliyuncs.com',
            'cn-hangzhou-internal-test-3': 'live.aliyuncs.com',
            'cn-hangzhou-test-306': 'live.aliyuncs.com',
            'cn-hongkong': 'live.aliyuncs.com',
            'cn-hongkong-finance-pop': 'live.aliyuncs.com',
            'cn-huhehaote': 'live.aliyuncs.com',
            'cn-huhehaote-nebula-1': 'live.aliyuncs.com',
            'cn-north-2-gov-1': 'live.aliyuncs.com',
            'cn-qingdao-nebula': 'live.aliyuncs.com',
            'cn-shanghai-et15-b01': 'live.aliyuncs.com',
            'cn-shanghai-et2-b01': 'live.aliyuncs.com',
            'cn-shanghai-finance-1': 'live.aliyuncs.com',
            'cn-shanghai-inner': 'live.aliyuncs.com',
            'cn-shanghai-internal-test-1': 'live.aliyuncs.com',
            'cn-shenzhen-finance-1': 'live.aliyuncs.com',
            'cn-shenzhen-inner': 'live.aliyuncs.com',
            'cn-shenzhen-st4-d01': 'live.aliyuncs.com',
            'cn-shenzhen-su18-b01': 'live.aliyuncs.com',
            'cn-wuhan': 'live.aliyuncs.com',
            'cn-wulanchabu': 'live.aliyuncs.com',
            'cn-yushanfang': 'live.aliyuncs.com',
            'cn-zhangbei': 'live.aliyuncs.com',
            'cn-zhangbei-na61-b01': 'live.aliyuncs.com',
            'cn-zhangjiakou': 'live.aliyuncs.com',
            'cn-zhangjiakou-na62-a01': 'live.aliyuncs.com',
            'cn-zhengzhou-nebula-1': 'live.aliyuncs.com',
            'eu-west-1': 'live.aliyuncs.com',
            'eu-west-1-oxs': 'live.aliyuncs.com',
            'me-east-1': 'live.aliyuncs.com',
            'rus-west-1-pop': 'live.aliyuncs.com',
            'us-east-1': 'live.aliyuncs.com',
            'us-west-1': 'live.aliyuncs.com'
        }
        self.check_config(config)
        self._endpoint = self.get_endpoint('live', self._region_id, self._endpoint_rule, self._network, self._suffix, self._endpoint_map, self._endpoint)

    def get_endpoint(
        self,
        product_id: str,
        region_id: str,
        endpoint_rule: str,
        network: str,
        suffix: str,
        endpoint_map: Dict[str, str],
        endpoint: str,
    ) -> str:
        if not UtilClient.empty(endpoint):
            return endpoint
        if not UtilClient.is_unset(endpoint_map) and not UtilClient.empty(endpoint_map.get(region_id)):
            return endpoint_map.get(region_id)
        return EndpointUtilClient.get_endpoint_rules(product_id, region_id, endpoint_rule, network, suffix)

    def add_caster_component_with_options(
        self,
        request: live_20161101_models.AddCasterComponentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddCasterComponentResponse:
        """
        @summary Adds a component to a production studio.
        
        @description Before you call this operation to add a component to a production studio, you must first create the production studio and learn about the production studio layouts. You can call this operation to add three types of components: image, text, and subtitle. For information about how to create a production studio, see [CreateCaster](https://help.aliyun.com/document_detail/2848009.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddCasterComponentRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCasterComponentResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caption_layer_content):
            query['CaptionLayerContent'] = request.caption_layer_content
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.component_layer):
            query['ComponentLayer'] = request.component_layer
        if not UtilClient.is_unset(request.component_name):
            query['ComponentName'] = request.component_name
        if not UtilClient.is_unset(request.component_type):
            query['ComponentType'] = request.component_type
        if not UtilClient.is_unset(request.effect):
            query['Effect'] = request.effect
        if not UtilClient.is_unset(request.html_layer_content):
            query['HtmlLayerContent'] = request.html_layer_content
        if not UtilClient.is_unset(request.image_layer_content):
            query['ImageLayerContent'] = request.image_layer_content
        if not UtilClient.is_unset(request.layer_order):
            query['LayerOrder'] = request.layer_order
        if not UtilClient.is_unset(request.location_id):
            query['LocationId'] = request.location_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.text_layer_content):
            query['TextLayerContent'] = request.text_layer_content
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCasterComponent',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddCasterComponentResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_caster_component_with_options_async(
        self,
        request: live_20161101_models.AddCasterComponentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddCasterComponentResponse:
        """
        @summary Adds a component to a production studio.
        
        @description Before you call this operation to add a component to a production studio, you must first create the production studio and learn about the production studio layouts. You can call this operation to add three types of components: image, text, and subtitle. For information about how to create a production studio, see [CreateCaster](https://help.aliyun.com/document_detail/2848009.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddCasterComponentRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCasterComponentResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caption_layer_content):
            query['CaptionLayerContent'] = request.caption_layer_content
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.component_layer):
            query['ComponentLayer'] = request.component_layer
        if not UtilClient.is_unset(request.component_name):
            query['ComponentName'] = request.component_name
        if not UtilClient.is_unset(request.component_type):
            query['ComponentType'] = request.component_type
        if not UtilClient.is_unset(request.effect):
            query['Effect'] = request.effect
        if not UtilClient.is_unset(request.html_layer_content):
            query['HtmlLayerContent'] = request.html_layer_content
        if not UtilClient.is_unset(request.image_layer_content):
            query['ImageLayerContent'] = request.image_layer_content
        if not UtilClient.is_unset(request.layer_order):
            query['LayerOrder'] = request.layer_order
        if not UtilClient.is_unset(request.location_id):
            query['LocationId'] = request.location_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.text_layer_content):
            query['TextLayerContent'] = request.text_layer_content
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCasterComponent',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddCasterComponentResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_caster_component(
        self,
        request: live_20161101_models.AddCasterComponentRequest,
    ) -> live_20161101_models.AddCasterComponentResponse:
        """
        @summary Adds a component to a production studio.
        
        @description Before you call this operation to add a component to a production studio, you must first create the production studio and learn about the production studio layouts. You can call this operation to add three types of components: image, text, and subtitle. For information about how to create a production studio, see [CreateCaster](https://help.aliyun.com/document_detail/2848009.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddCasterComponentRequest
        @return: AddCasterComponentResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_caster_component_with_options(request, runtime)

    async def add_caster_component_async(
        self,
        request: live_20161101_models.AddCasterComponentRequest,
    ) -> live_20161101_models.AddCasterComponentResponse:
        """
        @summary Adds a component to a production studio.
        
        @description Before you call this operation to add a component to a production studio, you must first create the production studio and learn about the production studio layouts. You can call this operation to add three types of components: image, text, and subtitle. For information about how to create a production studio, see [CreateCaster](https://help.aliyun.com/document_detail/2848009.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddCasterComponentRequest
        @return: AddCasterComponentResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_caster_component_with_options_async(request, runtime)

    def add_caster_episode_with_options(
        self,
        request: live_20161101_models.AddCasterEpisodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddCasterEpisodeResponse:
        """
        @summary Adds an episode to a production studio.
        
        @description To call this operation, you must obtain the production studio ID in advance. The production studio ID is generated after the production studio is created.
        If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation, check the value of the response parameter CasterId to obtain the ID.
        If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        >  You can find the ID of the production studio in the Instance ID/Name column.
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddCasterEpisodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCasterEpisodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.component_id):
            query['ComponentId'] = request.component_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.episode_name):
            query['EpisodeName'] = request.episode_name
        if not UtilClient.is_unset(request.episode_type):
            query['EpisodeType'] = request.episode_type
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.switch_type):
            query['SwitchType'] = request.switch_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCasterEpisode',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddCasterEpisodeResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_caster_episode_with_options_async(
        self,
        request: live_20161101_models.AddCasterEpisodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddCasterEpisodeResponse:
        """
        @summary Adds an episode to a production studio.
        
        @description To call this operation, you must obtain the production studio ID in advance. The production studio ID is generated after the production studio is created.
        If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation, check the value of the response parameter CasterId to obtain the ID.
        If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        >  You can find the ID of the production studio in the Instance ID/Name column.
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddCasterEpisodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCasterEpisodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.component_id):
            query['ComponentId'] = request.component_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.episode_name):
            query['EpisodeName'] = request.episode_name
        if not UtilClient.is_unset(request.episode_type):
            query['EpisodeType'] = request.episode_type
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.switch_type):
            query['SwitchType'] = request.switch_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCasterEpisode',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddCasterEpisodeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_caster_episode(
        self,
        request: live_20161101_models.AddCasterEpisodeRequest,
    ) -> live_20161101_models.AddCasterEpisodeResponse:
        """
        @summary Adds an episode to a production studio.
        
        @description To call this operation, you must obtain the production studio ID in advance. The production studio ID is generated after the production studio is created.
        If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation, check the value of the response parameter CasterId to obtain the ID.
        If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        >  You can find the ID of the production studio in the Instance ID/Name column.
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddCasterEpisodeRequest
        @return: AddCasterEpisodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_caster_episode_with_options(request, runtime)

    async def add_caster_episode_async(
        self,
        request: live_20161101_models.AddCasterEpisodeRequest,
    ) -> live_20161101_models.AddCasterEpisodeResponse:
        """
        @summary Adds an episode to a production studio.
        
        @description To call this operation, you must obtain the production studio ID in advance. The production studio ID is generated after the production studio is created.
        If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation, check the value of the response parameter CasterId to obtain the ID.
        If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        >  You can find the ID of the production studio in the Instance ID/Name column.
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddCasterEpisodeRequest
        @return: AddCasterEpisodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_caster_episode_with_options_async(request, runtime)

    def add_caster_episode_group_with_options(
        self,
        request: live_20161101_models.AddCasterEpisodeGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddCasterEpisodeGroupResponse:
        """
        @summary Adds an episode list to a production studio.
        
        @description You need to create a production studio and obtain the production studio configurations before you call this operation to create an episode list in the production studio. For information about how to create a production studio, see [CreateCaster](https://help.aliyun.com/document_detail/2848009.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddCasterEpisodeGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCasterEpisodeGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.callback_url):
            query['CallbackUrl'] = request.callback_url
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.item):
            query['Item'] = request.item
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.repeat_num):
            query['RepeatNum'] = request.repeat_num
        if not UtilClient.is_unset(request.side_output_url):
            query['SideOutputUrl'] = request.side_output_url
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCasterEpisodeGroup',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddCasterEpisodeGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_caster_episode_group_with_options_async(
        self,
        request: live_20161101_models.AddCasterEpisodeGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddCasterEpisodeGroupResponse:
        """
        @summary Adds an episode list to a production studio.
        
        @description You need to create a production studio and obtain the production studio configurations before you call this operation to create an episode list in the production studio. For information about how to create a production studio, see [CreateCaster](https://help.aliyun.com/document_detail/2848009.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddCasterEpisodeGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCasterEpisodeGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.callback_url):
            query['CallbackUrl'] = request.callback_url
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.item):
            query['Item'] = request.item
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.repeat_num):
            query['RepeatNum'] = request.repeat_num
        if not UtilClient.is_unset(request.side_output_url):
            query['SideOutputUrl'] = request.side_output_url
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCasterEpisodeGroup',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddCasterEpisodeGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_caster_episode_group(
        self,
        request: live_20161101_models.AddCasterEpisodeGroupRequest,
    ) -> live_20161101_models.AddCasterEpisodeGroupResponse:
        """
        @summary Adds an episode list to a production studio.
        
        @description You need to create a production studio and obtain the production studio configurations before you call this operation to create an episode list in the production studio. For information about how to create a production studio, see [CreateCaster](https://help.aliyun.com/document_detail/2848009.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddCasterEpisodeGroupRequest
        @return: AddCasterEpisodeGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_caster_episode_group_with_options(request, runtime)

    async def add_caster_episode_group_async(
        self,
        request: live_20161101_models.AddCasterEpisodeGroupRequest,
    ) -> live_20161101_models.AddCasterEpisodeGroupResponse:
        """
        @summary Adds an episode list to a production studio.
        
        @description You need to create a production studio and obtain the production studio configurations before you call this operation to create an episode list in the production studio. For information about how to create a production studio, see [CreateCaster](https://help.aliyun.com/document_detail/2848009.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddCasterEpisodeGroupRequest
        @return: AddCasterEpisodeGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_caster_episode_group_with_options_async(request, runtime)

    def add_caster_episode_group_content_with_options(
        self,
        request: live_20161101_models.AddCasterEpisodeGroupContentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddCasterEpisodeGroupContentResponse:
        """
        @summary Adds information about an episode list in a production studio.
        
        @description You need to create a production studio and add an episode list to the production studio before you call this operation to add information about the episode list in the production studio. For information about how to create a production studio, see [CreateCaster](https://help.aliyun.com/document_detail/2848009.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddCasterEpisodeGroupContentRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCasterEpisodeGroupContentResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.content):
            query['Content'] = request.content
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCasterEpisodeGroupContent',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddCasterEpisodeGroupContentResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_caster_episode_group_content_with_options_async(
        self,
        request: live_20161101_models.AddCasterEpisodeGroupContentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddCasterEpisodeGroupContentResponse:
        """
        @summary Adds information about an episode list in a production studio.
        
        @description You need to create a production studio and add an episode list to the production studio before you call this operation to add information about the episode list in the production studio. For information about how to create a production studio, see [CreateCaster](https://help.aliyun.com/document_detail/2848009.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddCasterEpisodeGroupContentRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCasterEpisodeGroupContentResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.content):
            query['Content'] = request.content
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCasterEpisodeGroupContent',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddCasterEpisodeGroupContentResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_caster_episode_group_content(
        self,
        request: live_20161101_models.AddCasterEpisodeGroupContentRequest,
    ) -> live_20161101_models.AddCasterEpisodeGroupContentResponse:
        """
        @summary Adds information about an episode list in a production studio.
        
        @description You need to create a production studio and add an episode list to the production studio before you call this operation to add information about the episode list in the production studio. For information about how to create a production studio, see [CreateCaster](https://help.aliyun.com/document_detail/2848009.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddCasterEpisodeGroupContentRequest
        @return: AddCasterEpisodeGroupContentResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_caster_episode_group_content_with_options(request, runtime)

    async def add_caster_episode_group_content_async(
        self,
        request: live_20161101_models.AddCasterEpisodeGroupContentRequest,
    ) -> live_20161101_models.AddCasterEpisodeGroupContentResponse:
        """
        @summary Adds information about an episode list in a production studio.
        
        @description You need to create a production studio and add an episode list to the production studio before you call this operation to add information about the episode list in the production studio. For information about how to create a production studio, see [CreateCaster](https://help.aliyun.com/document_detail/2848009.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddCasterEpisodeGroupContentRequest
        @return: AddCasterEpisodeGroupContentResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_caster_episode_group_content_with_options_async(request, runtime)

    def add_caster_layout_with_options(
        self,
        request: live_20161101_models.AddCasterLayoutRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddCasterLayoutResponse:
        """
        @summary Adds a layout for a production studio.
        
        @description First, create a director desk and add video resources to the director desk, then call this interface to add the director desk layout. To create a director desk using the API, refer to [Create Director Desk](https://help.aliyun.com/document_detail/69338.html).
        ## QPS Limitation
        The per-user QPS limit for this interface is 10 times/second. Exceeding this limit will result in API calls being throttled, which may impact your business operations. Please use the API reasonably. For more information, see [QPS Limitation](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddCasterLayoutRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCasterLayoutResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.audio_layer):
            query['AudioLayer'] = request.audio_layer
        if not UtilClient.is_unset(request.blend_list):
            query['BlendList'] = request.blend_list
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.mix_list):
            query['MixList'] = request.mix_list
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.video_layer):
            query['VideoLayer'] = request.video_layer
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCasterLayout',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddCasterLayoutResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_caster_layout_with_options_async(
        self,
        request: live_20161101_models.AddCasterLayoutRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddCasterLayoutResponse:
        """
        @summary Adds a layout for a production studio.
        
        @description First, create a director desk and add video resources to the director desk, then call this interface to add the director desk layout. To create a director desk using the API, refer to [Create Director Desk](https://help.aliyun.com/document_detail/69338.html).
        ## QPS Limitation
        The per-user QPS limit for this interface is 10 times/second. Exceeding this limit will result in API calls being throttled, which may impact your business operations. Please use the API reasonably. For more information, see [QPS Limitation](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddCasterLayoutRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCasterLayoutResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.audio_layer):
            query['AudioLayer'] = request.audio_layer
        if not UtilClient.is_unset(request.blend_list):
            query['BlendList'] = request.blend_list
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.mix_list):
            query['MixList'] = request.mix_list
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.video_layer):
            query['VideoLayer'] = request.video_layer
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCasterLayout',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddCasterLayoutResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_caster_layout(
        self,
        request: live_20161101_models.AddCasterLayoutRequest,
    ) -> live_20161101_models.AddCasterLayoutResponse:
        """
        @summary Adds a layout for a production studio.
        
        @description First, create a director desk and add video resources to the director desk, then call this interface to add the director desk layout. To create a director desk using the API, refer to [Create Director Desk](https://help.aliyun.com/document_detail/69338.html).
        ## QPS Limitation
        The per-user QPS limit for this interface is 10 times/second. Exceeding this limit will result in API calls being throttled, which may impact your business operations. Please use the API reasonably. For more information, see [QPS Limitation](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddCasterLayoutRequest
        @return: AddCasterLayoutResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_caster_layout_with_options(request, runtime)

    async def add_caster_layout_async(
        self,
        request: live_20161101_models.AddCasterLayoutRequest,
    ) -> live_20161101_models.AddCasterLayoutResponse:
        """
        @summary Adds a layout for a production studio.
        
        @description First, create a director desk and add video resources to the director desk, then call this interface to add the director desk layout. To create a director desk using the API, refer to [Create Director Desk](https://help.aliyun.com/document_detail/69338.html).
        ## QPS Limitation
        The per-user QPS limit for this interface is 10 times/second. Exceeding this limit will result in API calls being throttled, which may impact your business operations. Please use the API reasonably. For more information, see [QPS Limitation](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddCasterLayoutRequest
        @return: AddCasterLayoutResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_caster_layout_with_options_async(request, runtime)

    def add_caster_program_with_options(
        self,
        request: live_20161101_models.AddCasterProgramRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddCasterProgramResponse:
        """
        @summary Adds the episode list for carousel playback in a production studio.
        
        @description Create a production studio, add input sources to the production studio, and then call this operation to add the episode list for carousel playback in the production studio. This operation supports videos and components as episodes. For information about how to create a production studio, see [CreateCaster](https://help.aliyun.com/document_detail/2848009.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddCasterProgramRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCasterProgramResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.episode):
            query['Episode'] = request.episode
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCasterProgram',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddCasterProgramResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_caster_program_with_options_async(
        self,
        request: live_20161101_models.AddCasterProgramRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddCasterProgramResponse:
        """
        @summary Adds the episode list for carousel playback in a production studio.
        
        @description Create a production studio, add input sources to the production studio, and then call this operation to add the episode list for carousel playback in the production studio. This operation supports videos and components as episodes. For information about how to create a production studio, see [CreateCaster](https://help.aliyun.com/document_detail/2848009.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddCasterProgramRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCasterProgramResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.episode):
            query['Episode'] = request.episode
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCasterProgram',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddCasterProgramResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_caster_program(
        self,
        request: live_20161101_models.AddCasterProgramRequest,
    ) -> live_20161101_models.AddCasterProgramResponse:
        """
        @summary Adds the episode list for carousel playback in a production studio.
        
        @description Create a production studio, add input sources to the production studio, and then call this operation to add the episode list for carousel playback in the production studio. This operation supports videos and components as episodes. For information about how to create a production studio, see [CreateCaster](https://help.aliyun.com/document_detail/2848009.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddCasterProgramRequest
        @return: AddCasterProgramResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_caster_program_with_options(request, runtime)

    async def add_caster_program_async(
        self,
        request: live_20161101_models.AddCasterProgramRequest,
    ) -> live_20161101_models.AddCasterProgramResponse:
        """
        @summary Adds the episode list for carousel playback in a production studio.
        
        @description Create a production studio, add input sources to the production studio, and then call this operation to add the episode list for carousel playback in the production studio. This operation supports videos and components as episodes. For information about how to create a production studio, see [CreateCaster](https://help.aliyun.com/document_detail/2848009.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddCasterProgramRequest
        @return: AddCasterProgramResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_caster_program_with_options_async(request, runtime)

    def add_caster_video_resource_with_options(
        self,
        request: live_20161101_models.AddCasterVideoResourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddCasterVideoResourceResponse:
        """
        @summary Adds an input source to a production studio. The number of input sources is limited by the number of input channels of the production studio.
        
        @description ##
        Create a production studio, and then call this operation to add a video source to the production studio. The number of video sources is limited by the number of input channels of the production studio. For information about how to create a production studio by calling an API operation, see [CreateCaster](https://help.aliyun.com/document_detail/69338.html).
        ## QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddCasterVideoResourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCasterVideoResourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.begin_offset):
            query['BeginOffset'] = request.begin_offset
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.end_offset):
            query['EndOffset'] = request.end_offset
        if not UtilClient.is_unset(request.fixed_delay_duration):
            query['FixedDelayDuration'] = request.fixed_delay_duration
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.image_url):
            query['ImageUrl'] = request.image_url
        if not UtilClient.is_unset(request.live_stream_url):
            query['LiveStreamUrl'] = request.live_stream_url
        if not UtilClient.is_unset(request.location_id):
            query['LocationId'] = request.location_id
        if not UtilClient.is_unset(request.material_id):
            query['MaterialId'] = request.material_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pts_callback_interval):
            query['PtsCallbackInterval'] = request.pts_callback_interval
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.repeat_num):
            query['RepeatNum'] = request.repeat_num
        if not UtilClient.is_unset(request.resource_name):
            query['ResourceName'] = request.resource_name
        if not UtilClient.is_unset(request.vod_url):
            query['VodUrl'] = request.vod_url
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCasterVideoResource',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddCasterVideoResourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_caster_video_resource_with_options_async(
        self,
        request: live_20161101_models.AddCasterVideoResourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddCasterVideoResourceResponse:
        """
        @summary Adds an input source to a production studio. The number of input sources is limited by the number of input channels of the production studio.
        
        @description ##
        Create a production studio, and then call this operation to add a video source to the production studio. The number of video sources is limited by the number of input channels of the production studio. For information about how to create a production studio by calling an API operation, see [CreateCaster](https://help.aliyun.com/document_detail/69338.html).
        ## QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddCasterVideoResourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCasterVideoResourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.begin_offset):
            query['BeginOffset'] = request.begin_offset
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.end_offset):
            query['EndOffset'] = request.end_offset
        if not UtilClient.is_unset(request.fixed_delay_duration):
            query['FixedDelayDuration'] = request.fixed_delay_duration
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.image_url):
            query['ImageUrl'] = request.image_url
        if not UtilClient.is_unset(request.live_stream_url):
            query['LiveStreamUrl'] = request.live_stream_url
        if not UtilClient.is_unset(request.location_id):
            query['LocationId'] = request.location_id
        if not UtilClient.is_unset(request.material_id):
            query['MaterialId'] = request.material_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pts_callback_interval):
            query['PtsCallbackInterval'] = request.pts_callback_interval
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.repeat_num):
            query['RepeatNum'] = request.repeat_num
        if not UtilClient.is_unset(request.resource_name):
            query['ResourceName'] = request.resource_name
        if not UtilClient.is_unset(request.vod_url):
            query['VodUrl'] = request.vod_url
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCasterVideoResource',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddCasterVideoResourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_caster_video_resource(
        self,
        request: live_20161101_models.AddCasterVideoResourceRequest,
    ) -> live_20161101_models.AddCasterVideoResourceResponse:
        """
        @summary Adds an input source to a production studio. The number of input sources is limited by the number of input channels of the production studio.
        
        @description ##
        Create a production studio, and then call this operation to add a video source to the production studio. The number of video sources is limited by the number of input channels of the production studio. For information about how to create a production studio by calling an API operation, see [CreateCaster](https://help.aliyun.com/document_detail/69338.html).
        ## QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddCasterVideoResourceRequest
        @return: AddCasterVideoResourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_caster_video_resource_with_options(request, runtime)

    async def add_caster_video_resource_async(
        self,
        request: live_20161101_models.AddCasterVideoResourceRequest,
    ) -> live_20161101_models.AddCasterVideoResourceResponse:
        """
        @summary Adds an input source to a production studio. The number of input sources is limited by the number of input channels of the production studio.
        
        @description ##
        Create a production studio, and then call this operation to add a video source to the production studio. The number of video sources is limited by the number of input channels of the production studio. For information about how to create a production studio by calling an API operation, see [CreateCaster](https://help.aliyun.com/document_detail/69338.html).
        ## QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddCasterVideoResourceRequest
        @return: AddCasterVideoResourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_caster_video_resource_with_options_async(request, runtime)

    def add_custom_live_stream_transcode_with_options(
        self,
        request: live_20161101_models.AddCustomLiveStreamTranscodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddCustomLiveStreamTranscodeResponse:
        """
        @summary Adds a custom transcoding configuration for a streaming domain.
        
        @description This operation supports the following types of custom transcoding templates:
        h264: H.264
        h264-nbhd: H.264 Narrowband HD™
        h265: H.265
        h265-nbhd: H.265 Narrowband HD™
        audio: audio-only
        ## [](#qps-)QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddCustomLiveStreamTranscodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCustomLiveStreamTranscodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app):
            query['App'] = request.app
        if not UtilClient.is_unset(request.audio_bitrate):
            query['AudioBitrate'] = request.audio_bitrate
        if not UtilClient.is_unset(request.audio_channel_num):
            query['AudioChannelNum'] = request.audio_channel_num
        if not UtilClient.is_unset(request.audio_codec):
            query['AudioCodec'] = request.audio_codec
        if not UtilClient.is_unset(request.audio_profile):
            query['AudioProfile'] = request.audio_profile
        if not UtilClient.is_unset(request.audio_rate):
            query['AudioRate'] = request.audio_rate
        if not UtilClient.is_unset(request.bitrate_with_source):
            query['BitrateWithSource'] = request.bitrate_with_source
        if not UtilClient.is_unset(request.de_interlaced):
            query['DeInterlaced'] = request.de_interlaced
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.encrypt_parameters):
            query['EncryptParameters'] = request.encrypt_parameters
        if not UtilClient.is_unset(request.ext_with_source):
            query['ExtWithSource'] = request.ext_with_source
        if not UtilClient.is_unset(request.fps):
            query['FPS'] = request.fps
        if not UtilClient.is_unset(request.fps_with_source):
            query['FpsWithSource'] = request.fps_with_source
        if not UtilClient.is_unset(request.gop):
            query['Gop'] = request.gop
        if not UtilClient.is_unset(request.height):
            query['Height'] = request.height
        if not UtilClient.is_unset(request.kms_key_expire_interval):
            query['KmsKeyExpireInterval'] = request.kms_key_expire_interval
        if not UtilClient.is_unset(request.kms_key_id):
            query['KmsKeyID'] = request.kms_key_id
        if not UtilClient.is_unset(request.kms_uid):
            query['KmsUID'] = request.kms_uid
        if not UtilClient.is_unset(request.lazy):
            query['Lazy'] = request.lazy
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.profile):
            query['Profile'] = request.profile
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.res_with_source):
            query['ResWithSource'] = request.res_with_source
        if not UtilClient.is_unset(request.template):
            query['Template'] = request.template
        if not UtilClient.is_unset(request.template_type):
            query['TemplateType'] = request.template_type
        if not UtilClient.is_unset(request.video_bitrate):
            query['VideoBitrate'] = request.video_bitrate
        if not UtilClient.is_unset(request.width):
            query['Width'] = request.width
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCustomLiveStreamTranscode',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddCustomLiveStreamTranscodeResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_custom_live_stream_transcode_with_options_async(
        self,
        request: live_20161101_models.AddCustomLiveStreamTranscodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddCustomLiveStreamTranscodeResponse:
        """
        @summary Adds a custom transcoding configuration for a streaming domain.
        
        @description This operation supports the following types of custom transcoding templates:
        h264: H.264
        h264-nbhd: H.264 Narrowband HD™
        h265: H.265
        h265-nbhd: H.265 Narrowband HD™
        audio: audio-only
        ## [](#qps-)QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddCustomLiveStreamTranscodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCustomLiveStreamTranscodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app):
            query['App'] = request.app
        if not UtilClient.is_unset(request.audio_bitrate):
            query['AudioBitrate'] = request.audio_bitrate
        if not UtilClient.is_unset(request.audio_channel_num):
            query['AudioChannelNum'] = request.audio_channel_num
        if not UtilClient.is_unset(request.audio_codec):
            query['AudioCodec'] = request.audio_codec
        if not UtilClient.is_unset(request.audio_profile):
            query['AudioProfile'] = request.audio_profile
        if not UtilClient.is_unset(request.audio_rate):
            query['AudioRate'] = request.audio_rate
        if not UtilClient.is_unset(request.bitrate_with_source):
            query['BitrateWithSource'] = request.bitrate_with_source
        if not UtilClient.is_unset(request.de_interlaced):
            query['DeInterlaced'] = request.de_interlaced
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.encrypt_parameters):
            query['EncryptParameters'] = request.encrypt_parameters
        if not UtilClient.is_unset(request.ext_with_source):
            query['ExtWithSource'] = request.ext_with_source
        if not UtilClient.is_unset(request.fps):
            query['FPS'] = request.fps
        if not UtilClient.is_unset(request.fps_with_source):
            query['FpsWithSource'] = request.fps_with_source
        if not UtilClient.is_unset(request.gop):
            query['Gop'] = request.gop
        if not UtilClient.is_unset(request.height):
            query['Height'] = request.height
        if not UtilClient.is_unset(request.kms_key_expire_interval):
            query['KmsKeyExpireInterval'] = request.kms_key_expire_interval
        if not UtilClient.is_unset(request.kms_key_id):
            query['KmsKeyID'] = request.kms_key_id
        if not UtilClient.is_unset(request.kms_uid):
            query['KmsUID'] = request.kms_uid
        if not UtilClient.is_unset(request.lazy):
            query['Lazy'] = request.lazy
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.profile):
            query['Profile'] = request.profile
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.res_with_source):
            query['ResWithSource'] = request.res_with_source
        if not UtilClient.is_unset(request.template):
            query['Template'] = request.template
        if not UtilClient.is_unset(request.template_type):
            query['TemplateType'] = request.template_type
        if not UtilClient.is_unset(request.video_bitrate):
            query['VideoBitrate'] = request.video_bitrate
        if not UtilClient.is_unset(request.width):
            query['Width'] = request.width
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCustomLiveStreamTranscode',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddCustomLiveStreamTranscodeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_custom_live_stream_transcode(
        self,
        request: live_20161101_models.AddCustomLiveStreamTranscodeRequest,
    ) -> live_20161101_models.AddCustomLiveStreamTranscodeResponse:
        """
        @summary Adds a custom transcoding configuration for a streaming domain.
        
        @description This operation supports the following types of custom transcoding templates:
        h264: H.264
        h264-nbhd: H.264 Narrowband HD™
        h265: H.265
        h265-nbhd: H.265 Narrowband HD™
        audio: audio-only
        ## [](#qps-)QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddCustomLiveStreamTranscodeRequest
        @return: AddCustomLiveStreamTranscodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_custom_live_stream_transcode_with_options(request, runtime)

    async def add_custom_live_stream_transcode_async(
        self,
        request: live_20161101_models.AddCustomLiveStreamTranscodeRequest,
    ) -> live_20161101_models.AddCustomLiveStreamTranscodeResponse:
        """
        @summary Adds a custom transcoding configuration for a streaming domain.
        
        @description This operation supports the following types of custom transcoding templates:
        h264: H.264
        h264-nbhd: H.264 Narrowband HD™
        h265: H.265
        h265-nbhd: H.265 Narrowband HD™
        audio: audio-only
        ## [](#qps-)QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddCustomLiveStreamTranscodeRequest
        @return: AddCustomLiveStreamTranscodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_custom_live_stream_transcode_with_options_async(request, runtime)

    def add_live_aiproduce_rules_with_options(
        self,
        request: live_20161101_models.AddLiveAIProduceRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveAIProduceRulesResponse:
        """
        @summary Adds a subtitle rule.
        
        @description    After you call the [AddLiveAISubtitle](https://help.aliyun.com/document_detail/2848222.html) operation to add a subtitle template, you can call this operation to create a subtitle rule for the template.
        You must add "_Subtitle template name" after the stream name in the streaming URL to play the subtitle stream.
        RTMP: rtmp://example.aliyundoc.com/app/stream_{Subtitle template name}?auth_key={Access token}
        FLV: http://example.aliyundoc.com/app/stream_{Subtitle template name}.flv?auth_key={Access token}
        M3U8: http://example.aliyundoc.com/app/stream_{Subtitle template name}.m3u8?auth_key={Access token}
        >  The live subtitles feature is in invitational preview. You can add up to 300 subtitle templates.
        ## [](#qps-)QPS limit
        You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveAIProduceRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveAIProduceRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app):
            query['App'] = request.app
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.is_lazy):
            query['IsLazy'] = request.is_lazy
        if not UtilClient.is_unset(request.live_template):
            query['LiveTemplate'] = request.live_template
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.studio_name):
            query['StudioName'] = request.studio_name
        if not UtilClient.is_unset(request.subtitle_name):
            query['SubtitleName'] = request.subtitle_name
        if not UtilClient.is_unset(request.suffix):
            query['Suffix'] = request.suffix
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveAIProduceRules',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveAIProduceRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_live_aiproduce_rules_with_options_async(
        self,
        request: live_20161101_models.AddLiveAIProduceRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveAIProduceRulesResponse:
        """
        @summary Adds a subtitle rule.
        
        @description    After you call the [AddLiveAISubtitle](https://help.aliyun.com/document_detail/2848222.html) operation to add a subtitle template, you can call this operation to create a subtitle rule for the template.
        You must add "_Subtitle template name" after the stream name in the streaming URL to play the subtitle stream.
        RTMP: rtmp://example.aliyundoc.com/app/stream_{Subtitle template name}?auth_key={Access token}
        FLV: http://example.aliyundoc.com/app/stream_{Subtitle template name}.flv?auth_key={Access token}
        M3U8: http://example.aliyundoc.com/app/stream_{Subtitle template name}.m3u8?auth_key={Access token}
        >  The live subtitles feature is in invitational preview. You can add up to 300 subtitle templates.
        ## [](#qps-)QPS limit
        You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveAIProduceRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveAIProduceRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app):
            query['App'] = request.app
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.is_lazy):
            query['IsLazy'] = request.is_lazy
        if not UtilClient.is_unset(request.live_template):
            query['LiveTemplate'] = request.live_template
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.studio_name):
            query['StudioName'] = request.studio_name
        if not UtilClient.is_unset(request.subtitle_name):
            query['SubtitleName'] = request.subtitle_name
        if not UtilClient.is_unset(request.suffix):
            query['Suffix'] = request.suffix
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveAIProduceRules',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveAIProduceRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_live_aiproduce_rules(
        self,
        request: live_20161101_models.AddLiveAIProduceRulesRequest,
    ) -> live_20161101_models.AddLiveAIProduceRulesResponse:
        """
        @summary Adds a subtitle rule.
        
        @description    After you call the [AddLiveAISubtitle](https://help.aliyun.com/document_detail/2848222.html) operation to add a subtitle template, you can call this operation to create a subtitle rule for the template.
        You must add "_Subtitle template name" after the stream name in the streaming URL to play the subtitle stream.
        RTMP: rtmp://example.aliyundoc.com/app/stream_{Subtitle template name}?auth_key={Access token}
        FLV: http://example.aliyundoc.com/app/stream_{Subtitle template name}.flv?auth_key={Access token}
        M3U8: http://example.aliyundoc.com/app/stream_{Subtitle template name}.m3u8?auth_key={Access token}
        >  The live subtitles feature is in invitational preview. You can add up to 300 subtitle templates.
        ## [](#qps-)QPS limit
        You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveAIProduceRulesRequest
        @return: AddLiveAIProduceRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_live_aiproduce_rules_with_options(request, runtime)

    async def add_live_aiproduce_rules_async(
        self,
        request: live_20161101_models.AddLiveAIProduceRulesRequest,
    ) -> live_20161101_models.AddLiveAIProduceRulesResponse:
        """
        @summary Adds a subtitle rule.
        
        @description    After you call the [AddLiveAISubtitle](https://help.aliyun.com/document_detail/2848222.html) operation to add a subtitle template, you can call this operation to create a subtitle rule for the template.
        You must add "_Subtitle template name" after the stream name in the streaming URL to play the subtitle stream.
        RTMP: rtmp://example.aliyundoc.com/app/stream_{Subtitle template name}?auth_key={Access token}
        FLV: http://example.aliyundoc.com/app/stream_{Subtitle template name}.flv?auth_key={Access token}
        M3U8: http://example.aliyundoc.com/app/stream_{Subtitle template name}.m3u8?auth_key={Access token}
        >  The live subtitles feature is in invitational preview. You can add up to 300 subtitle templates.
        ## [](#qps-)QPS limit
        You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveAIProduceRulesRequest
        @return: AddLiveAIProduceRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_live_aiproduce_rules_with_options_async(request, runtime)

    def add_live_aisubtitle_with_options(
        self,
        tmp_req: live_20161101_models.AddLiveAISubtitleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveAISubtitleResponse:
        """
        @summary Adds a subtitle template.
        
        @description ## Instructions
        - This interface supports adding live caption template configurations, with templates configurable to describe caption content, layout, and more.
        - After adding caption templates, you also need to call the [AddLiveAIProduceRules](https://help.aliyun.com/document_detail/2799676.html) interface to add caption rules. Restarting the stream will then enable captions in the broadcast.
        - Real-time captions are currently supported in Beijing, Shanghai, Singapore, Indonesia, and Saudi regions.
        >Notice: The real-time caption feature is currently in beta testing. Each user can add up to 300 caption templates.
        ## QPS Limit
        The QPS limit for this interface per user is 60 requests/second. Exceeding this limit will result in API throttling, which may impact your services. Please use judiciously. For more information, refer to [QPS Limitations](https://help.aliyun.com/document_detail/343507.html).
        
        @param tmp_req: AddLiveAISubtitleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveAISubtitleResponse
        """
        UtilClient.validate_model(tmp_req)
        request = live_20161101_models.AddLiveAISubtitleShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.position_normalized):
            request.position_normalized_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.position_normalized, 'PositionNormalized', 'json')
        query = {}
        if not UtilClient.is_unset(request.bg_color):
            query['BgColor'] = request.bg_color
        if not UtilClient.is_unset(request.bg_width_normalized):
            query['BgWidthNormalized'] = request.bg_width_normalized
        if not UtilClient.is_unset(request.border_width_normalized):
            query['BorderWidthNormalized'] = request.border_width_normalized
        if not UtilClient.is_unset(request.copy_from):
            query['CopyFrom'] = request.copy_from
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dst_language):
            query['DstLanguage'] = request.dst_language
        if not UtilClient.is_unset(request.font_color):
            query['FontColor'] = request.font_color
        if not UtilClient.is_unset(request.font_name):
            query['FontName'] = request.font_name
        if not UtilClient.is_unset(request.font_size_normalized):
            query['FontSizeNormalized'] = request.font_size_normalized
        if not UtilClient.is_unset(request.height):
            query['Height'] = request.height
        if not UtilClient.is_unset(request.max_lines):
            query['MaxLines'] = request.max_lines
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.position_normalized_shrink):
            query['PositionNormalized'] = request.position_normalized_shrink
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.show_source_lan):
            query['ShowSourceLan'] = request.show_source_lan
        if not UtilClient.is_unset(request.src_language):
            query['SrcLanguage'] = request.src_language
        if not UtilClient.is_unset(request.subtitle_name):
            query['SubtitleName'] = request.subtitle_name
        if not UtilClient.is_unset(request.width):
            query['Width'] = request.width
        if not UtilClient.is_unset(request.word_per_line):
            query['WordPerLine'] = request.word_per_line
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveAISubtitle',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveAISubtitleResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_live_aisubtitle_with_options_async(
        self,
        tmp_req: live_20161101_models.AddLiveAISubtitleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveAISubtitleResponse:
        """
        @summary Adds a subtitle template.
        
        @description ## Instructions
        - This interface supports adding live caption template configurations, with templates configurable to describe caption content, layout, and more.
        - After adding caption templates, you also need to call the [AddLiveAIProduceRules](https://help.aliyun.com/document_detail/2799676.html) interface to add caption rules. Restarting the stream will then enable captions in the broadcast.
        - Real-time captions are currently supported in Beijing, Shanghai, Singapore, Indonesia, and Saudi regions.
        >Notice: The real-time caption feature is currently in beta testing. Each user can add up to 300 caption templates.
        ## QPS Limit
        The QPS limit for this interface per user is 60 requests/second. Exceeding this limit will result in API throttling, which may impact your services. Please use judiciously. For more information, refer to [QPS Limitations](https://help.aliyun.com/document_detail/343507.html).
        
        @param tmp_req: AddLiveAISubtitleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveAISubtitleResponse
        """
        UtilClient.validate_model(tmp_req)
        request = live_20161101_models.AddLiveAISubtitleShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.position_normalized):
            request.position_normalized_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.position_normalized, 'PositionNormalized', 'json')
        query = {}
        if not UtilClient.is_unset(request.bg_color):
            query['BgColor'] = request.bg_color
        if not UtilClient.is_unset(request.bg_width_normalized):
            query['BgWidthNormalized'] = request.bg_width_normalized
        if not UtilClient.is_unset(request.border_width_normalized):
            query['BorderWidthNormalized'] = request.border_width_normalized
        if not UtilClient.is_unset(request.copy_from):
            query['CopyFrom'] = request.copy_from
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dst_language):
            query['DstLanguage'] = request.dst_language
        if not UtilClient.is_unset(request.font_color):
            query['FontColor'] = request.font_color
        if not UtilClient.is_unset(request.font_name):
            query['FontName'] = request.font_name
        if not UtilClient.is_unset(request.font_size_normalized):
            query['FontSizeNormalized'] = request.font_size_normalized
        if not UtilClient.is_unset(request.height):
            query['Height'] = request.height
        if not UtilClient.is_unset(request.max_lines):
            query['MaxLines'] = request.max_lines
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.position_normalized_shrink):
            query['PositionNormalized'] = request.position_normalized_shrink
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.show_source_lan):
            query['ShowSourceLan'] = request.show_source_lan
        if not UtilClient.is_unset(request.src_language):
            query['SrcLanguage'] = request.src_language
        if not UtilClient.is_unset(request.subtitle_name):
            query['SubtitleName'] = request.subtitle_name
        if not UtilClient.is_unset(request.width):
            query['Width'] = request.width
        if not UtilClient.is_unset(request.word_per_line):
            query['WordPerLine'] = request.word_per_line
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveAISubtitle',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveAISubtitleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_live_aisubtitle(
        self,
        request: live_20161101_models.AddLiveAISubtitleRequest,
    ) -> live_20161101_models.AddLiveAISubtitleResponse:
        """
        @summary Adds a subtitle template.
        
        @description ## Instructions
        - This interface supports adding live caption template configurations, with templates configurable to describe caption content, layout, and more.
        - After adding caption templates, you also need to call the [AddLiveAIProduceRules](https://help.aliyun.com/document_detail/2799676.html) interface to add caption rules. Restarting the stream will then enable captions in the broadcast.
        - Real-time captions are currently supported in Beijing, Shanghai, Singapore, Indonesia, and Saudi regions.
        >Notice: The real-time caption feature is currently in beta testing. Each user can add up to 300 caption templates.
        ## QPS Limit
        The QPS limit for this interface per user is 60 requests/second. Exceeding this limit will result in API throttling, which may impact your services. Please use judiciously. For more information, refer to [QPS Limitations](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddLiveAISubtitleRequest
        @return: AddLiveAISubtitleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_live_aisubtitle_with_options(request, runtime)

    async def add_live_aisubtitle_async(
        self,
        request: live_20161101_models.AddLiveAISubtitleRequest,
    ) -> live_20161101_models.AddLiveAISubtitleResponse:
        """
        @summary Adds a subtitle template.
        
        @description ## Instructions
        - This interface supports adding live caption template configurations, with templates configurable to describe caption content, layout, and more.
        - After adding caption templates, you also need to call the [AddLiveAIProduceRules](https://help.aliyun.com/document_detail/2799676.html) interface to add caption rules. Restarting the stream will then enable captions in the broadcast.
        - Real-time captions are currently supported in Beijing, Shanghai, Singapore, Indonesia, and Saudi regions.
        >Notice: The real-time caption feature is currently in beta testing. Each user can add up to 300 caption templates.
        ## QPS Limit
        The QPS limit for this interface per user is 60 requests/second. Exceeding this limit will result in API throttling, which may impact your services. Please use judiciously. For more information, refer to [QPS Limitations](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddLiveAISubtitleRequest
        @return: AddLiveAISubtitleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_live_aisubtitle_with_options_async(request, runtime)

    def add_live_app_record_config_with_options(
        self,
        request: live_20161101_models.AddLiveAppRecordConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveAppRecordConfigResponse:
        """
        @summary Configure APP recording, with output saved to OSS.
        
        @description The live stream recording feature allows you to record a live stream and stores the recordings in a specified location. You can view the recordings whenever you want to. Recordings that are stored in OSS support multiple formats, such as Transport Stream (TS), MP4, Flash Video (FLV), and Common Media Application Format (CMAF). You can use different recording policies, including automatic recording, on-demand recording, and manual recording. By calling this operation, you can configure the recording template. For more information about live stream recording, see [Live stream recording](https://help.aliyun.com/document_detail/199357.html).
        A configuration is identified by the DomainName, AppName, and StreamName parameters all together. If you try to call this operation to add a configuration that has the same DomainName, AppName, and StreamName parameters as an existing configuration, an error indicating that the configuration already exists is returned.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveAppRecordConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveAppRecordConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.delay_time):
            query['DelayTime'] = request.delay_time
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.on_demand):
            query['OnDemand'] = request.on_demand
        if not UtilClient.is_unset(request.oss_bucket):
            query['OssBucket'] = request.oss_bucket
        if not UtilClient.is_unset(request.oss_endpoint):
            query['OssEndpoint'] = request.oss_endpoint
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.record_format):
            query['RecordFormat'] = request.record_format
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        if not UtilClient.is_unset(request.transcode_record_format):
            query['TranscodeRecordFormat'] = request.transcode_record_format
        if not UtilClient.is_unset(request.transcode_templates):
            query['TranscodeTemplates'] = request.transcode_templates
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveAppRecordConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveAppRecordConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_live_app_record_config_with_options_async(
        self,
        request: live_20161101_models.AddLiveAppRecordConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveAppRecordConfigResponse:
        """
        @summary Configure APP recording, with output saved to OSS.
        
        @description The live stream recording feature allows you to record a live stream and stores the recordings in a specified location. You can view the recordings whenever you want to. Recordings that are stored in OSS support multiple formats, such as Transport Stream (TS), MP4, Flash Video (FLV), and Common Media Application Format (CMAF). You can use different recording policies, including automatic recording, on-demand recording, and manual recording. By calling this operation, you can configure the recording template. For more information about live stream recording, see [Live stream recording](https://help.aliyun.com/document_detail/199357.html).
        A configuration is identified by the DomainName, AppName, and StreamName parameters all together. If you try to call this operation to add a configuration that has the same DomainName, AppName, and StreamName parameters as an existing configuration, an error indicating that the configuration already exists is returned.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveAppRecordConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveAppRecordConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.delay_time):
            query['DelayTime'] = request.delay_time
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.on_demand):
            query['OnDemand'] = request.on_demand
        if not UtilClient.is_unset(request.oss_bucket):
            query['OssBucket'] = request.oss_bucket
        if not UtilClient.is_unset(request.oss_endpoint):
            query['OssEndpoint'] = request.oss_endpoint
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.record_format):
            query['RecordFormat'] = request.record_format
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        if not UtilClient.is_unset(request.transcode_record_format):
            query['TranscodeRecordFormat'] = request.transcode_record_format
        if not UtilClient.is_unset(request.transcode_templates):
            query['TranscodeTemplates'] = request.transcode_templates
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveAppRecordConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveAppRecordConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_live_app_record_config(
        self,
        request: live_20161101_models.AddLiveAppRecordConfigRequest,
    ) -> live_20161101_models.AddLiveAppRecordConfigResponse:
        """
        @summary Configure APP recording, with output saved to OSS.
        
        @description The live stream recording feature allows you to record a live stream and stores the recordings in a specified location. You can view the recordings whenever you want to. Recordings that are stored in OSS support multiple formats, such as Transport Stream (TS), MP4, Flash Video (FLV), and Common Media Application Format (CMAF). You can use different recording policies, including automatic recording, on-demand recording, and manual recording. By calling this operation, you can configure the recording template. For more information about live stream recording, see [Live stream recording](https://help.aliyun.com/document_detail/199357.html).
        A configuration is identified by the DomainName, AppName, and StreamName parameters all together. If you try to call this operation to add a configuration that has the same DomainName, AppName, and StreamName parameters as an existing configuration, an error indicating that the configuration already exists is returned.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveAppRecordConfigRequest
        @return: AddLiveAppRecordConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_live_app_record_config_with_options(request, runtime)

    async def add_live_app_record_config_async(
        self,
        request: live_20161101_models.AddLiveAppRecordConfigRequest,
    ) -> live_20161101_models.AddLiveAppRecordConfigResponse:
        """
        @summary Configure APP recording, with output saved to OSS.
        
        @description The live stream recording feature allows you to record a live stream and stores the recordings in a specified location. You can view the recordings whenever you want to. Recordings that are stored in OSS support multiple formats, such as Transport Stream (TS), MP4, Flash Video (FLV), and Common Media Application Format (CMAF). You can use different recording policies, including automatic recording, on-demand recording, and manual recording. By calling this operation, you can configure the recording template. For more information about live stream recording, see [Live stream recording](https://help.aliyun.com/document_detail/199357.html).
        A configuration is identified by the DomainName, AppName, and StreamName parameters all together. If you try to call this operation to add a configuration that has the same DomainName, AppName, and StreamName parameters as an existing configuration, an error indicating that the configuration already exists is returned.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveAppRecordConfigRequest
        @return: AddLiveAppRecordConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_live_app_record_config_with_options_async(request, runtime)

    def add_live_app_snapshot_config_with_options(
        self,
        request: live_20161101_models.AddLiveAppSnapshotConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveAppSnapshotConfigResponse:
        """
        @summary Configures the snapshot feature for a streaming domain. The captured snapshots are stored in Object Storage Service (OSS). The configuration takes effect after you restart stream ingest.
        
        @description    Before you call this operation, make sure that you fully understand the billing method and pricing of live stream snapshots in ApsaraVideo Live. For more information, see [Billing of live stream snapshots](https://help.aliyun.com/document_detail/195286.html).
        Make sure that Object Storage Service (OSS) is activated and a specific bucket is created. This way, ApsaraVideo Live can store live stream snapshots in the bucket. For more information, see [Configure OSS](https://help.aliyun.com/document_detail/84932.html).
        If you store snapshots in OSS, storage fees are generated. For more information, see [Storage fees](https://help.aliyun.com/document_detail/173534.html).
        The OSS bucket must reside in the same region as the live center of the streaming domain. Cross-region snapshot capture is not supported.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveAppSnapshotConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveAppSnapshotConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.callback):
            query['Callback'] = request.callback
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.oss_bucket):
            query['OssBucket'] = request.oss_bucket
        if not UtilClient.is_unset(request.oss_endpoint):
            query['OssEndpoint'] = request.oss_endpoint
        if not UtilClient.is_unset(request.overwrite_oss_object):
            query['OverwriteOssObject'] = request.overwrite_oss_object
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.sequence_oss_object):
            query['SequenceOssObject'] = request.sequence_oss_object
        if not UtilClient.is_unset(request.time_interval):
            query['TimeInterval'] = request.time_interval
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveAppSnapshotConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveAppSnapshotConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_live_app_snapshot_config_with_options_async(
        self,
        request: live_20161101_models.AddLiveAppSnapshotConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveAppSnapshotConfigResponse:
        """
        @summary Configures the snapshot feature for a streaming domain. The captured snapshots are stored in Object Storage Service (OSS). The configuration takes effect after you restart stream ingest.
        
        @description    Before you call this operation, make sure that you fully understand the billing method and pricing of live stream snapshots in ApsaraVideo Live. For more information, see [Billing of live stream snapshots](https://help.aliyun.com/document_detail/195286.html).
        Make sure that Object Storage Service (OSS) is activated and a specific bucket is created. This way, ApsaraVideo Live can store live stream snapshots in the bucket. For more information, see [Configure OSS](https://help.aliyun.com/document_detail/84932.html).
        If you store snapshots in OSS, storage fees are generated. For more information, see [Storage fees](https://help.aliyun.com/document_detail/173534.html).
        The OSS bucket must reside in the same region as the live center of the streaming domain. Cross-region snapshot capture is not supported.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveAppSnapshotConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveAppSnapshotConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.callback):
            query['Callback'] = request.callback
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.oss_bucket):
            query['OssBucket'] = request.oss_bucket
        if not UtilClient.is_unset(request.oss_endpoint):
            query['OssEndpoint'] = request.oss_endpoint
        if not UtilClient.is_unset(request.overwrite_oss_object):
            query['OverwriteOssObject'] = request.overwrite_oss_object
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.sequence_oss_object):
            query['SequenceOssObject'] = request.sequence_oss_object
        if not UtilClient.is_unset(request.time_interval):
            query['TimeInterval'] = request.time_interval
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveAppSnapshotConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveAppSnapshotConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_live_app_snapshot_config(
        self,
        request: live_20161101_models.AddLiveAppSnapshotConfigRequest,
    ) -> live_20161101_models.AddLiveAppSnapshotConfigResponse:
        """
        @summary Configures the snapshot feature for a streaming domain. The captured snapshots are stored in Object Storage Service (OSS). The configuration takes effect after you restart stream ingest.
        
        @description    Before you call this operation, make sure that you fully understand the billing method and pricing of live stream snapshots in ApsaraVideo Live. For more information, see [Billing of live stream snapshots](https://help.aliyun.com/document_detail/195286.html).
        Make sure that Object Storage Service (OSS) is activated and a specific bucket is created. This way, ApsaraVideo Live can store live stream snapshots in the bucket. For more information, see [Configure OSS](https://help.aliyun.com/document_detail/84932.html).
        If you store snapshots in OSS, storage fees are generated. For more information, see [Storage fees](https://help.aliyun.com/document_detail/173534.html).
        The OSS bucket must reside in the same region as the live center of the streaming domain. Cross-region snapshot capture is not supported.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveAppSnapshotConfigRequest
        @return: AddLiveAppSnapshotConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_live_app_snapshot_config_with_options(request, runtime)

    async def add_live_app_snapshot_config_async(
        self,
        request: live_20161101_models.AddLiveAppSnapshotConfigRequest,
    ) -> live_20161101_models.AddLiveAppSnapshotConfigResponse:
        """
        @summary Configures the snapshot feature for a streaming domain. The captured snapshots are stored in Object Storage Service (OSS). The configuration takes effect after you restart stream ingest.
        
        @description    Before you call this operation, make sure that you fully understand the billing method and pricing of live stream snapshots in ApsaraVideo Live. For more information, see [Billing of live stream snapshots](https://help.aliyun.com/document_detail/195286.html).
        Make sure that Object Storage Service (OSS) is activated and a specific bucket is created. This way, ApsaraVideo Live can store live stream snapshots in the bucket. For more information, see [Configure OSS](https://help.aliyun.com/document_detail/84932.html).
        If you store snapshots in OSS, storage fees are generated. For more information, see [Storage fees](https://help.aliyun.com/document_detail/173534.html).
        The OSS bucket must reside in the same region as the live center of the streaming domain. Cross-region snapshot capture is not supported.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveAppSnapshotConfigRequest
        @return: AddLiveAppSnapshotConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_live_app_snapshot_config_with_options_async(request, runtime)

    def add_live_audio_audit_config_with_options(
        self,
        request: live_20161101_models.AddLiveAudioAuditConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveAudioAuditConfigResponse:
        """
        @summary Adds an audio moderation configuration.
        
        @description    The content moderation feature detects undesirable sensitive content in the audio from live streams and returns callbacks to notify you of the violations. Then, you can manually review the content and take actions accordingly.
        Only some live centers support the content moderation feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveAudioAuditConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveAudioAuditConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.biz_type):
            query['BizType'] = request.biz_type
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.oss_bucket):
            query['OssBucket'] = request.oss_bucket
        if not UtilClient.is_unset(request.oss_endpoint):
            query['OssEndpoint'] = request.oss_endpoint
        if not UtilClient.is_unset(request.oss_object):
            query['OssObject'] = request.oss_object
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveAudioAuditConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveAudioAuditConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_live_audio_audit_config_with_options_async(
        self,
        request: live_20161101_models.AddLiveAudioAuditConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveAudioAuditConfigResponse:
        """
        @summary Adds an audio moderation configuration.
        
        @description    The content moderation feature detects undesirable sensitive content in the audio from live streams and returns callbacks to notify you of the violations. Then, you can manually review the content and take actions accordingly.
        Only some live centers support the content moderation feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveAudioAuditConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveAudioAuditConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.biz_type):
            query['BizType'] = request.biz_type
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.oss_bucket):
            query['OssBucket'] = request.oss_bucket
        if not UtilClient.is_unset(request.oss_endpoint):
            query['OssEndpoint'] = request.oss_endpoint
        if not UtilClient.is_unset(request.oss_object):
            query['OssObject'] = request.oss_object
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveAudioAuditConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveAudioAuditConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_live_audio_audit_config(
        self,
        request: live_20161101_models.AddLiveAudioAuditConfigRequest,
    ) -> live_20161101_models.AddLiveAudioAuditConfigResponse:
        """
        @summary Adds an audio moderation configuration.
        
        @description    The content moderation feature detects undesirable sensitive content in the audio from live streams and returns callbacks to notify you of the violations. Then, you can manually review the content and take actions accordingly.
        Only some live centers support the content moderation feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveAudioAuditConfigRequest
        @return: AddLiveAudioAuditConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_live_audio_audit_config_with_options(request, runtime)

    async def add_live_audio_audit_config_async(
        self,
        request: live_20161101_models.AddLiveAudioAuditConfigRequest,
    ) -> live_20161101_models.AddLiveAudioAuditConfigResponse:
        """
        @summary Adds an audio moderation configuration.
        
        @description    The content moderation feature detects undesirable sensitive content in the audio from live streams and returns callbacks to notify you of the violations. Then, you can manually review the content and take actions accordingly.
        Only some live centers support the content moderation feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveAudioAuditConfigRequest
        @return: AddLiveAudioAuditConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_live_audio_audit_config_with_options_async(request, runtime)

    def add_live_audio_audit_notify_config_with_options(
        self,
        request: live_20161101_models.AddLiveAudioAuditNotifyConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveAudioAuditNotifyConfigResponse:
        """
        @summary Configures callbacks for audio moderation results.
        
        @description    The content moderation feature returns the audio moderation results based on the configured callback template.
        Only some live centers support the content moderation feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveAudioAuditNotifyConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveAudioAuditNotifyConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.callback):
            query['Callback'] = request.callback
        if not UtilClient.is_unset(request.callback_template):
            query['CallbackTemplate'] = request.callback_template
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveAudioAuditNotifyConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveAudioAuditNotifyConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_live_audio_audit_notify_config_with_options_async(
        self,
        request: live_20161101_models.AddLiveAudioAuditNotifyConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveAudioAuditNotifyConfigResponse:
        """
        @summary Configures callbacks for audio moderation results.
        
        @description    The content moderation feature returns the audio moderation results based on the configured callback template.
        Only some live centers support the content moderation feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveAudioAuditNotifyConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveAudioAuditNotifyConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.callback):
            query['Callback'] = request.callback
        if not UtilClient.is_unset(request.callback_template):
            query['CallbackTemplate'] = request.callback_template
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveAudioAuditNotifyConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveAudioAuditNotifyConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_live_audio_audit_notify_config(
        self,
        request: live_20161101_models.AddLiveAudioAuditNotifyConfigRequest,
    ) -> live_20161101_models.AddLiveAudioAuditNotifyConfigResponse:
        """
        @summary Configures callbacks for audio moderation results.
        
        @description    The content moderation feature returns the audio moderation results based on the configured callback template.
        Only some live centers support the content moderation feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveAudioAuditNotifyConfigRequest
        @return: AddLiveAudioAuditNotifyConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_live_audio_audit_notify_config_with_options(request, runtime)

    async def add_live_audio_audit_notify_config_async(
        self,
        request: live_20161101_models.AddLiveAudioAuditNotifyConfigRequest,
    ) -> live_20161101_models.AddLiveAudioAuditNotifyConfigResponse:
        """
        @summary Configures callbacks for audio moderation results.
        
        @description    The content moderation feature returns the audio moderation results based on the configured callback template.
        Only some live centers support the content moderation feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveAudioAuditNotifyConfigRequest
        @return: AddLiveAudioAuditNotifyConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_live_audio_audit_notify_config_with_options_async(request, runtime)

    def add_live_center_transfer_with_options(
        self,
        request: live_20161101_models.AddLiveCenterTransferRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveCenterTransferResponse:
        """
        @summary Adds a configuration of live center stream relay.
        
        @description You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveCenterTransferRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveCenterTransferResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.dst_url):
            query['DstUrl'] = request.dst_url
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        if not UtilClient.is_unset(request.transfer_args):
            query['TransferArgs'] = request.transfer_args
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveCenterTransfer',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveCenterTransferResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_live_center_transfer_with_options_async(
        self,
        request: live_20161101_models.AddLiveCenterTransferRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveCenterTransferResponse:
        """
        @summary Adds a configuration of live center stream relay.
        
        @description You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveCenterTransferRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveCenterTransferResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.dst_url):
            query['DstUrl'] = request.dst_url
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        if not UtilClient.is_unset(request.transfer_args):
            query['TransferArgs'] = request.transfer_args
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveCenterTransfer',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveCenterTransferResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_live_center_transfer(
        self,
        request: live_20161101_models.AddLiveCenterTransferRequest,
    ) -> live_20161101_models.AddLiveCenterTransferResponse:
        """
        @summary Adds a configuration of live center stream relay.
        
        @description You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveCenterTransferRequest
        @return: AddLiveCenterTransferResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_live_center_transfer_with_options(request, runtime)

    async def add_live_center_transfer_async(
        self,
        request: live_20161101_models.AddLiveCenterTransferRequest,
    ) -> live_20161101_models.AddLiveCenterTransferResponse:
        """
        @summary Adds a configuration of live center stream relay.
        
        @description You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveCenterTransferRequest
        @return: AddLiveCenterTransferResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_live_center_transfer_with_options_async(request, runtime)

    def add_live_detect_notify_config_with_options(
        self,
        request: live_20161101_models.AddLiveDetectNotifyConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveDetectNotifyConfigResponse:
        """
        @summary Configures callbacks for video moderation results. As a result, a callback URL that is used to receive the callback notifications is added.
        
        @description    The automated review feature sends notifications about violations to the callback URL in real time. Then, you can manually review the content and take actions accordingly.
        Only some live centers support the automated review feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://www.alibabacloud.com/help/en/apsaravideo-live/latest/qps-limit-on-an-api-operation-in-apsaravideo-live).
        
        @param request: AddLiveDetectNotifyConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveDetectNotifyConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.notify_url):
            query['NotifyUrl'] = request.notify_url
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveDetectNotifyConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveDetectNotifyConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_live_detect_notify_config_with_options_async(
        self,
        request: live_20161101_models.AddLiveDetectNotifyConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveDetectNotifyConfigResponse:
        """
        @summary Configures callbacks for video moderation results. As a result, a callback URL that is used to receive the callback notifications is added.
        
        @description    The automated review feature sends notifications about violations to the callback URL in real time. Then, you can manually review the content and take actions accordingly.
        Only some live centers support the automated review feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://www.alibabacloud.com/help/en/apsaravideo-live/latest/qps-limit-on-an-api-operation-in-apsaravideo-live).
        
        @param request: AddLiveDetectNotifyConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveDetectNotifyConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.notify_url):
            query['NotifyUrl'] = request.notify_url
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveDetectNotifyConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveDetectNotifyConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_live_detect_notify_config(
        self,
        request: live_20161101_models.AddLiveDetectNotifyConfigRequest,
    ) -> live_20161101_models.AddLiveDetectNotifyConfigResponse:
        """
        @summary Configures callbacks for video moderation results. As a result, a callback URL that is used to receive the callback notifications is added.
        
        @description    The automated review feature sends notifications about violations to the callback URL in real time. Then, you can manually review the content and take actions accordingly.
        Only some live centers support the automated review feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://www.alibabacloud.com/help/en/apsaravideo-live/latest/qps-limit-on-an-api-operation-in-apsaravideo-live).
        
        @param request: AddLiveDetectNotifyConfigRequest
        @return: AddLiveDetectNotifyConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_live_detect_notify_config_with_options(request, runtime)

    async def add_live_detect_notify_config_async(
        self,
        request: live_20161101_models.AddLiveDetectNotifyConfigRequest,
    ) -> live_20161101_models.AddLiveDetectNotifyConfigResponse:
        """
        @summary Configures callbacks for video moderation results. As a result, a callback URL that is used to receive the callback notifications is added.
        
        @description    The automated review feature sends notifications about violations to the callback URL in real time. Then, you can manually review the content and take actions accordingly.
        Only some live centers support the automated review feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://www.alibabacloud.com/help/en/apsaravideo-live/latest/qps-limit-on-an-api-operation-in-apsaravideo-live).
        
        @param request: AddLiveDetectNotifyConfigRequest
        @return: AddLiveDetectNotifyConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_live_detect_notify_config_with_options_async(request, runtime)

    def add_live_domain_with_options(
        self,
        request: live_20161101_models.AddLiveDomainRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveDomainResponse:
        """
        @summary Adds a domain name to ApsaraVideo Live. This operation allows you to add only one domain name at a time.
        
        @description    You must activate ApsaraVideo Live before you add a domain name. For more information, see [Activate ApsaraVideo Live](https://help.aliyun.com/document_detail/195292.html).
        ApsaraVideo Live verifies the ownership of a new domain name that you add. After the verification is passed, the domain name is added to ApsaraVideo Live. ApsaraVideo Live allows you to use a Domain Name System (DNS) record or a verification file to verify the ownership of a domain name. For more information, see [Verify the ownership of a domain name](https://help.aliyun.com/document_detail/184466.html).
        To use ApsaraVideo Live to ingest and play streams, you must add an ingest domain and a streaming domain. You can add only one domain name at a time.
        After you add a domain name, you must configure a CNAME record for the domain name. For more information, see [Add a CNAME record](https://help.aliyun.com/document_detail/84929.html).
        After you add an ingest domain and a streaming domain, you must associate the streaming domain with the ingest domain. For more information, see [Associate a streaming domain with an ingest domain](https://help.aliyun.com/document_detail/199338.html).
        >  From February 19, 2019, domain names that are added by calling the AddLiveDomain operation do not support live center ingest. Domain names that are added by using Alibaba Cloud CDN also do not support live center ingest. When you call the AddLiveDomain operation, you can set the LiveDomainType parameter to liveEdge to add an ingest domain that uses edge ingest or set the LiveDomainType parameter to liveVideo to add a streaming domain. You can associate a streaming domain with an ingest domain by calling the AddLiveDomainMapping operation. Domain names added before February 19, 2019, for which live center ingest was configured, are not affected.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveDomainRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveDomainResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_url):
            query['CheckUrl'] = request.check_url
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.live_domain_type):
            query['LiveDomainType'] = request.live_domain_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.scope):
            query['Scope'] = request.scope
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.top_level_domain):
            query['TopLevelDomain'] = request.top_level_domain
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveDomain',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveDomainResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_live_domain_with_options_async(
        self,
        request: live_20161101_models.AddLiveDomainRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveDomainResponse:
        """
        @summary Adds a domain name to ApsaraVideo Live. This operation allows you to add only one domain name at a time.
        
        @description    You must activate ApsaraVideo Live before you add a domain name. For more information, see [Activate ApsaraVideo Live](https://help.aliyun.com/document_detail/195292.html).
        ApsaraVideo Live verifies the ownership of a new domain name that you add. After the verification is passed, the domain name is added to ApsaraVideo Live. ApsaraVideo Live allows you to use a Domain Name System (DNS) record or a verification file to verify the ownership of a domain name. For more information, see [Verify the ownership of a domain name](https://help.aliyun.com/document_detail/184466.html).
        To use ApsaraVideo Live to ingest and play streams, you must add an ingest domain and a streaming domain. You can add only one domain name at a time.
        After you add a domain name, you must configure a CNAME record for the domain name. For more information, see [Add a CNAME record](https://help.aliyun.com/document_detail/84929.html).
        After you add an ingest domain and a streaming domain, you must associate the streaming domain with the ingest domain. For more information, see [Associate a streaming domain with an ingest domain](https://help.aliyun.com/document_detail/199338.html).
        >  From February 19, 2019, domain names that are added by calling the AddLiveDomain operation do not support live center ingest. Domain names that are added by using Alibaba Cloud CDN also do not support live center ingest. When you call the AddLiveDomain operation, you can set the LiveDomainType parameter to liveEdge to add an ingest domain that uses edge ingest or set the LiveDomainType parameter to liveVideo to add a streaming domain. You can associate a streaming domain with an ingest domain by calling the AddLiveDomainMapping operation. Domain names added before February 19, 2019, for which live center ingest was configured, are not affected.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveDomainRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveDomainResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_url):
            query['CheckUrl'] = request.check_url
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.live_domain_type):
            query['LiveDomainType'] = request.live_domain_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.scope):
            query['Scope'] = request.scope
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.top_level_domain):
            query['TopLevelDomain'] = request.top_level_domain
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveDomain',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveDomainResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_live_domain(
        self,
        request: live_20161101_models.AddLiveDomainRequest,
    ) -> live_20161101_models.AddLiveDomainResponse:
        """
        @summary Adds a domain name to ApsaraVideo Live. This operation allows you to add only one domain name at a time.
        
        @description    You must activate ApsaraVideo Live before you add a domain name. For more information, see [Activate ApsaraVideo Live](https://help.aliyun.com/document_detail/195292.html).
        ApsaraVideo Live verifies the ownership of a new domain name that you add. After the verification is passed, the domain name is added to ApsaraVideo Live. ApsaraVideo Live allows you to use a Domain Name System (DNS) record or a verification file to verify the ownership of a domain name. For more information, see [Verify the ownership of a domain name](https://help.aliyun.com/document_detail/184466.html).
        To use ApsaraVideo Live to ingest and play streams, you must add an ingest domain and a streaming domain. You can add only one domain name at a time.
        After you add a domain name, you must configure a CNAME record for the domain name. For more information, see [Add a CNAME record](https://help.aliyun.com/document_detail/84929.html).
        After you add an ingest domain and a streaming domain, you must associate the streaming domain with the ingest domain. For more information, see [Associate a streaming domain with an ingest domain](https://help.aliyun.com/document_detail/199338.html).
        >  From February 19, 2019, domain names that are added by calling the AddLiveDomain operation do not support live center ingest. Domain names that are added by using Alibaba Cloud CDN also do not support live center ingest. When you call the AddLiveDomain operation, you can set the LiveDomainType parameter to liveEdge to add an ingest domain that uses edge ingest or set the LiveDomainType parameter to liveVideo to add a streaming domain. You can associate a streaming domain with an ingest domain by calling the AddLiveDomainMapping operation. Domain names added before February 19, 2019, for which live center ingest was configured, are not affected.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveDomainRequest
        @return: AddLiveDomainResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_live_domain_with_options(request, runtime)

    async def add_live_domain_async(
        self,
        request: live_20161101_models.AddLiveDomainRequest,
    ) -> live_20161101_models.AddLiveDomainResponse:
        """
        @summary Adds a domain name to ApsaraVideo Live. This operation allows you to add only one domain name at a time.
        
        @description    You must activate ApsaraVideo Live before you add a domain name. For more information, see [Activate ApsaraVideo Live](https://help.aliyun.com/document_detail/195292.html).
        ApsaraVideo Live verifies the ownership of a new domain name that you add. After the verification is passed, the domain name is added to ApsaraVideo Live. ApsaraVideo Live allows you to use a Domain Name System (DNS) record or a verification file to verify the ownership of a domain name. For more information, see [Verify the ownership of a domain name](https://help.aliyun.com/document_detail/184466.html).
        To use ApsaraVideo Live to ingest and play streams, you must add an ingest domain and a streaming domain. You can add only one domain name at a time.
        After you add a domain name, you must configure a CNAME record for the domain name. For more information, see [Add a CNAME record](https://help.aliyun.com/document_detail/84929.html).
        After you add an ingest domain and a streaming domain, you must associate the streaming domain with the ingest domain. For more information, see [Associate a streaming domain with an ingest domain](https://help.aliyun.com/document_detail/199338.html).
        >  From February 19, 2019, domain names that are added by calling the AddLiveDomain operation do not support live center ingest. Domain names that are added by using Alibaba Cloud CDN also do not support live center ingest. When you call the AddLiveDomain operation, you can set the LiveDomainType parameter to liveEdge to add an ingest domain that uses edge ingest or set the LiveDomainType parameter to liveVideo to add a streaming domain. You can associate a streaming domain with an ingest domain by calling the AddLiveDomainMapping operation. Domain names added before February 19, 2019, for which live center ingest was configured, are not affected.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveDomainRequest
        @return: AddLiveDomainResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_live_domain_with_options_async(request, runtime)

    def add_live_domain_mapping_with_options(
        self,
        request: live_20161101_models.AddLiveDomainMappingRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveDomainMappingResponse:
        """
        @summary Creates the mapping between a streaming domain and an ingest domain.
        
        @description Call the [AddLiveDomain](https://help.aliyun.com/document_detail/88327.html) operation to add a streaming domain and an ingest domain, and then call this operation to create the mapping between the two domain names.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddLiveDomainMappingRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveDomainMappingResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pull_domain):
            query['PullDomain'] = request.pull_domain
        if not UtilClient.is_unset(request.push_domain):
            query['PushDomain'] = request.push_domain
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveDomainMapping',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveDomainMappingResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_live_domain_mapping_with_options_async(
        self,
        request: live_20161101_models.AddLiveDomainMappingRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveDomainMappingResponse:
        """
        @summary Creates the mapping between a streaming domain and an ingest domain.
        
        @description Call the [AddLiveDomain](https://help.aliyun.com/document_detail/88327.html) operation to add a streaming domain and an ingest domain, and then call this operation to create the mapping between the two domain names.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddLiveDomainMappingRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveDomainMappingResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pull_domain):
            query['PullDomain'] = request.pull_domain
        if not UtilClient.is_unset(request.push_domain):
            query['PushDomain'] = request.push_domain
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveDomainMapping',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveDomainMappingResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_live_domain_mapping(
        self,
        request: live_20161101_models.AddLiveDomainMappingRequest,
    ) -> live_20161101_models.AddLiveDomainMappingResponse:
        """
        @summary Creates the mapping between a streaming domain and an ingest domain.
        
        @description Call the [AddLiveDomain](https://help.aliyun.com/document_detail/88327.html) operation to add a streaming domain and an ingest domain, and then call this operation to create the mapping between the two domain names.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddLiveDomainMappingRequest
        @return: AddLiveDomainMappingResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_live_domain_mapping_with_options(request, runtime)

    async def add_live_domain_mapping_async(
        self,
        request: live_20161101_models.AddLiveDomainMappingRequest,
    ) -> live_20161101_models.AddLiveDomainMappingResponse:
        """
        @summary Creates the mapping between a streaming domain and an ingest domain.
        
        @description Call the [AddLiveDomain](https://help.aliyun.com/document_detail/88327.html) operation to add a streaming domain and an ingest domain, and then call this operation to create the mapping between the two domain names.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddLiveDomainMappingRequest
        @return: AddLiveDomainMappingResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_live_domain_mapping_with_options_async(request, runtime)

    def add_live_domain_play_mapping_with_options(
        self,
        request: live_20161101_models.AddLiveDomainPlayMappingRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveDomainPlayMappingResponse:
        """
        @summary Maps a sub-streaming domain to a main streaming domain.
        
        @description You can call the [AddLiveDomain](https://help.aliyun.com/document_detail/88327.html) operation to add a main streaming domain and a sub-streaming domain and then call this operation to map the sub-streaming domain to the main streaming domain.
        ## [](#qps-)QPS limit
        You can call this operation up to 1,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveDomainPlayMappingRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveDomainPlayMappingResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.play_domain):
            query['PlayDomain'] = request.play_domain
        if not UtilClient.is_unset(request.pull_domain):
            query['PullDomain'] = request.pull_domain
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveDomainPlayMapping',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveDomainPlayMappingResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_live_domain_play_mapping_with_options_async(
        self,
        request: live_20161101_models.AddLiveDomainPlayMappingRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveDomainPlayMappingResponse:
        """
        @summary Maps a sub-streaming domain to a main streaming domain.
        
        @description You can call the [AddLiveDomain](https://help.aliyun.com/document_detail/88327.html) operation to add a main streaming domain and a sub-streaming domain and then call this operation to map the sub-streaming domain to the main streaming domain.
        ## [](#qps-)QPS limit
        You can call this operation up to 1,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveDomainPlayMappingRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveDomainPlayMappingResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.play_domain):
            query['PlayDomain'] = request.play_domain
        if not UtilClient.is_unset(request.pull_domain):
            query['PullDomain'] = request.pull_domain
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveDomainPlayMapping',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveDomainPlayMappingResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_live_domain_play_mapping(
        self,
        request: live_20161101_models.AddLiveDomainPlayMappingRequest,
    ) -> live_20161101_models.AddLiveDomainPlayMappingResponse:
        """
        @summary Maps a sub-streaming domain to a main streaming domain.
        
        @description You can call the [AddLiveDomain](https://help.aliyun.com/document_detail/88327.html) operation to add a main streaming domain and a sub-streaming domain and then call this operation to map the sub-streaming domain to the main streaming domain.
        ## [](#qps-)QPS limit
        You can call this operation up to 1,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveDomainPlayMappingRequest
        @return: AddLiveDomainPlayMappingResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_live_domain_play_mapping_with_options(request, runtime)

    async def add_live_domain_play_mapping_async(
        self,
        request: live_20161101_models.AddLiveDomainPlayMappingRequest,
    ) -> live_20161101_models.AddLiveDomainPlayMappingResponse:
        """
        @summary Maps a sub-streaming domain to a main streaming domain.
        
        @description You can call the [AddLiveDomain](https://help.aliyun.com/document_detail/88327.html) operation to add a main streaming domain and a sub-streaming domain and then call this operation to map the sub-streaming domain to the main streaming domain.
        ## [](#qps-)QPS limit
        You can call this operation up to 1,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveDomainPlayMappingRequest
        @return: AddLiveDomainPlayMappingResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_live_domain_play_mapping_with_options_async(request, runtime)

    def add_live_message_group_band_with_options(
        self,
        tmp_req: live_20161101_models.AddLiveMessageGroupBandRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveMessageGroupBandResponse:
        """
        @summary Mutes one or more users.
        
        @description Before you call this operation, make sure that you have called the [CreateLiveMessageGroup](https://help.aliyun.com/document_detail/2848163.html) operation to create an interactive messaging group.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param tmp_req: AddLiveMessageGroupBandRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveMessageGroupBandResponse
        """
        UtilClient.validate_model(tmp_req)
        request = live_20161101_models.AddLiveMessageGroupBandShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.banned_users):
            request.banned_users_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.banned_users, 'BannedUsers', 'simple')
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.banned_users_shrink):
            query['BannedUsers'] = request.banned_users_shrink
        if not UtilClient.is_unset(request.data_center):
            query['DataCenter'] = request.data_center
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveMessageGroupBand',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveMessageGroupBandResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_live_message_group_band_with_options_async(
        self,
        tmp_req: live_20161101_models.AddLiveMessageGroupBandRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveMessageGroupBandResponse:
        """
        @summary Mutes one or more users.
        
        @description Before you call this operation, make sure that you have called the [CreateLiveMessageGroup](https://help.aliyun.com/document_detail/2848163.html) operation to create an interactive messaging group.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param tmp_req: AddLiveMessageGroupBandRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveMessageGroupBandResponse
        """
        UtilClient.validate_model(tmp_req)
        request = live_20161101_models.AddLiveMessageGroupBandShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.banned_users):
            request.banned_users_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.banned_users, 'BannedUsers', 'simple')
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.banned_users_shrink):
            query['BannedUsers'] = request.banned_users_shrink
        if not UtilClient.is_unset(request.data_center):
            query['DataCenter'] = request.data_center
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveMessageGroupBand',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveMessageGroupBandResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_live_message_group_band(
        self,
        request: live_20161101_models.AddLiveMessageGroupBandRequest,
    ) -> live_20161101_models.AddLiveMessageGroupBandResponse:
        """
        @summary Mutes one or more users.
        
        @description Before you call this operation, make sure that you have called the [CreateLiveMessageGroup](https://help.aliyun.com/document_detail/2848163.html) operation to create an interactive messaging group.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveMessageGroupBandRequest
        @return: AddLiveMessageGroupBandResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_live_message_group_band_with_options(request, runtime)

    async def add_live_message_group_band_async(
        self,
        request: live_20161101_models.AddLiveMessageGroupBandRequest,
    ) -> live_20161101_models.AddLiveMessageGroupBandResponse:
        """
        @summary Mutes one or more users.
        
        @description Before you call this operation, make sure that you have called the [CreateLiveMessageGroup](https://help.aliyun.com/document_detail/2848163.html) operation to create an interactive messaging group.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveMessageGroupBandRequest
        @return: AddLiveMessageGroupBandResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_live_message_group_band_with_options_async(request, runtime)

    def add_live_package_config_with_options(
        self,
        request: live_20161101_models.AddLivePackageConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLivePackageConfigResponse:
        """
        @summary Adds a live stream encapsulation configuration.
        
        @description    The first time you configure encapsulation for a domain name, domain acceleration is automatically configured and takes effect in 3 to 5 minutes.
        If the streaming domain resides in a region outside China, including Singapore, Germany (Frankfurt), Japan (Tokyo), and Indonesia (Jakarta), you may encounter high latency issues. We recommend that you test and verify whether the settings meet expectations.
        You can call this operation to add a live stream encapsulation configuration. The configuration takes effect only after you re-ingest the stream.
        ## [](#qps-)QPS limit
        You can call this operation up to 300 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLivePackageConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLivePackageConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.ignore_transcode):
            query['IgnoreTranscode'] = request.ignore_transcode
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.part_duration):
            query['PartDuration'] = request.part_duration
        if not UtilClient.is_unset(request.protocol):
            query['Protocol'] = request.protocol
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.segment_duration):
            query['SegmentDuration'] = request.segment_duration
        if not UtilClient.is_unset(request.segment_num):
            query['SegmentNum'] = request.segment_num
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLivePackageConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLivePackageConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_live_package_config_with_options_async(
        self,
        request: live_20161101_models.AddLivePackageConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLivePackageConfigResponse:
        """
        @summary Adds a live stream encapsulation configuration.
        
        @description    The first time you configure encapsulation for a domain name, domain acceleration is automatically configured and takes effect in 3 to 5 minutes.
        If the streaming domain resides in a region outside China, including Singapore, Germany (Frankfurt), Japan (Tokyo), and Indonesia (Jakarta), you may encounter high latency issues. We recommend that you test and verify whether the settings meet expectations.
        You can call this operation to add a live stream encapsulation configuration. The configuration takes effect only after you re-ingest the stream.
        ## [](#qps-)QPS limit
        You can call this operation up to 300 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLivePackageConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLivePackageConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.ignore_transcode):
            query['IgnoreTranscode'] = request.ignore_transcode
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.part_duration):
            query['PartDuration'] = request.part_duration
        if not UtilClient.is_unset(request.protocol):
            query['Protocol'] = request.protocol
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.segment_duration):
            query['SegmentDuration'] = request.segment_duration
        if not UtilClient.is_unset(request.segment_num):
            query['SegmentNum'] = request.segment_num
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLivePackageConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLivePackageConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_live_package_config(
        self,
        request: live_20161101_models.AddLivePackageConfigRequest,
    ) -> live_20161101_models.AddLivePackageConfigResponse:
        """
        @summary Adds a live stream encapsulation configuration.
        
        @description    The first time you configure encapsulation for a domain name, domain acceleration is automatically configured and takes effect in 3 to 5 minutes.
        If the streaming domain resides in a region outside China, including Singapore, Germany (Frankfurt), Japan (Tokyo), and Indonesia (Jakarta), you may encounter high latency issues. We recommend that you test and verify whether the settings meet expectations.
        You can call this operation to add a live stream encapsulation configuration. The configuration takes effect only after you re-ingest the stream.
        ## [](#qps-)QPS limit
        You can call this operation up to 300 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLivePackageConfigRequest
        @return: AddLivePackageConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_live_package_config_with_options(request, runtime)

    async def add_live_package_config_async(
        self,
        request: live_20161101_models.AddLivePackageConfigRequest,
    ) -> live_20161101_models.AddLivePackageConfigResponse:
        """
        @summary Adds a live stream encapsulation configuration.
        
        @description    The first time you configure encapsulation for a domain name, domain acceleration is automatically configured and takes effect in 3 to 5 minutes.
        If the streaming domain resides in a region outside China, including Singapore, Germany (Frankfurt), Japan (Tokyo), and Indonesia (Jakarta), you may encounter high latency issues. We recommend that you test and verify whether the settings meet expectations.
        You can call this operation to add a live stream encapsulation configuration. The configuration takes effect only after you re-ingest the stream.
        ## [](#qps-)QPS limit
        You can call this operation up to 300 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLivePackageConfigRequest
        @return: AddLivePackageConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_live_package_config_with_options_async(request, runtime)

    def add_live_pull_stream_info_config_with_options(
        self,
        request: live_20161101_models.AddLivePullStreamInfoConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLivePullStreamInfoConfigResponse:
        """
        @summary Creates a stream pulling configuration for a live stream, which includes parameters such as the origin URL, start time, and end time.
        
        @description    Before you call this operation, make sure that you fully understand the billing method and pricing of stream pulling in ApsaraVideo Live. For more information, see [Billing of standard streaming](https://help.aliyun.com/document_detail/195284.html).
        Stream pulling refers to the process of pulling live streams from third-party streaming URLs to a live center of ApsaraVideo Live for CDN acceleration.
        You can call this operation only for regular stream pulling. That is, you can specify the start time and end time to pull live streams.
        Regular stream pulling and triggered stream pulling are supported in the ApsaraVideo Live console. For more information, see [Configure stream pulling](https://help.aliyun.com/document_detail/199452.html).
        You can specify custom values for the AppName and StreamName parameters. Streaming URLs that are generated vary based on different values of the AppName and StreamName parameters. You can use the [URL generator](https://help.aliyun.com/document_detail/197400.html) to generate a streaming URL.
        A configuration is identified by the DomainName, AppName, and StreamName parameters all together. If you try to call this operation to add a configuration that has the same DomainName, AppName, and StreamName parameters as an existing configuration, an error indicating that the configuration already exists is returned.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLivePullStreamInfoConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLivePullStreamInfoConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.source_url):
            query['SourceUrl'] = request.source_url
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLivePullStreamInfoConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLivePullStreamInfoConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_live_pull_stream_info_config_with_options_async(
        self,
        request: live_20161101_models.AddLivePullStreamInfoConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLivePullStreamInfoConfigResponse:
        """
        @summary Creates a stream pulling configuration for a live stream, which includes parameters such as the origin URL, start time, and end time.
        
        @description    Before you call this operation, make sure that you fully understand the billing method and pricing of stream pulling in ApsaraVideo Live. For more information, see [Billing of standard streaming](https://help.aliyun.com/document_detail/195284.html).
        Stream pulling refers to the process of pulling live streams from third-party streaming URLs to a live center of ApsaraVideo Live for CDN acceleration.
        You can call this operation only for regular stream pulling. That is, you can specify the start time and end time to pull live streams.
        Regular stream pulling and triggered stream pulling are supported in the ApsaraVideo Live console. For more information, see [Configure stream pulling](https://help.aliyun.com/document_detail/199452.html).
        You can specify custom values for the AppName and StreamName parameters. Streaming URLs that are generated vary based on different values of the AppName and StreamName parameters. You can use the [URL generator](https://help.aliyun.com/document_detail/197400.html) to generate a streaming URL.
        A configuration is identified by the DomainName, AppName, and StreamName parameters all together. If you try to call this operation to add a configuration that has the same DomainName, AppName, and StreamName parameters as an existing configuration, an error indicating that the configuration already exists is returned.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLivePullStreamInfoConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLivePullStreamInfoConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.source_url):
            query['SourceUrl'] = request.source_url
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLivePullStreamInfoConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLivePullStreamInfoConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_live_pull_stream_info_config(
        self,
        request: live_20161101_models.AddLivePullStreamInfoConfigRequest,
    ) -> live_20161101_models.AddLivePullStreamInfoConfigResponse:
        """
        @summary Creates a stream pulling configuration for a live stream, which includes parameters such as the origin URL, start time, and end time.
        
        @description    Before you call this operation, make sure that you fully understand the billing method and pricing of stream pulling in ApsaraVideo Live. For more information, see [Billing of standard streaming](https://help.aliyun.com/document_detail/195284.html).
        Stream pulling refers to the process of pulling live streams from third-party streaming URLs to a live center of ApsaraVideo Live for CDN acceleration.
        You can call this operation only for regular stream pulling. That is, you can specify the start time and end time to pull live streams.
        Regular stream pulling and triggered stream pulling are supported in the ApsaraVideo Live console. For more information, see [Configure stream pulling](https://help.aliyun.com/document_detail/199452.html).
        You can specify custom values for the AppName and StreamName parameters. Streaming URLs that are generated vary based on different values of the AppName and StreamName parameters. You can use the [URL generator](https://help.aliyun.com/document_detail/197400.html) to generate a streaming URL.
        A configuration is identified by the DomainName, AppName, and StreamName parameters all together. If you try to call this operation to add a configuration that has the same DomainName, AppName, and StreamName parameters as an existing configuration, an error indicating that the configuration already exists is returned.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLivePullStreamInfoConfigRequest
        @return: AddLivePullStreamInfoConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_live_pull_stream_info_config_with_options(request, runtime)

    async def add_live_pull_stream_info_config_async(
        self,
        request: live_20161101_models.AddLivePullStreamInfoConfigRequest,
    ) -> live_20161101_models.AddLivePullStreamInfoConfigResponse:
        """
        @summary Creates a stream pulling configuration for a live stream, which includes parameters such as the origin URL, start time, and end time.
        
        @description    Before you call this operation, make sure that you fully understand the billing method and pricing of stream pulling in ApsaraVideo Live. For more information, see [Billing of standard streaming](https://help.aliyun.com/document_detail/195284.html).
        Stream pulling refers to the process of pulling live streams from third-party streaming URLs to a live center of ApsaraVideo Live for CDN acceleration.
        You can call this operation only for regular stream pulling. That is, you can specify the start time and end time to pull live streams.
        Regular stream pulling and triggered stream pulling are supported in the ApsaraVideo Live console. For more information, see [Configure stream pulling](https://help.aliyun.com/document_detail/199452.html).
        You can specify custom values for the AppName and StreamName parameters. Streaming URLs that are generated vary based on different values of the AppName and StreamName parameters. You can use the [URL generator](https://help.aliyun.com/document_detail/197400.html) to generate a streaming URL.
        A configuration is identified by the DomainName, AppName, and StreamName parameters all together. If you try to call this operation to add a configuration that has the same DomainName, AppName, and StreamName parameters as an existing configuration, an error indicating that the configuration already exists is returned.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLivePullStreamInfoConfigRequest
        @return: AddLivePullStreamInfoConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_live_pull_stream_info_config_with_options_async(request, runtime)

    def add_live_record_notify_config_with_options(
        self,
        request: live_20161101_models.AddLiveRecordNotifyConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveRecordNotifyConfigResponse:
        """
        @summary Configures recording callbacks for a domain name.
        
        @description Before you call this operation to configure recording callbacks for a domain name, you can query whether the domain name already has recording callbacks configured. For more information, see [DescribeLiveRecordNotifyConfig](https://help.aliyun.com/document_detail/2847893.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveRecordNotifyConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveRecordNotifyConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.need_status_notify):
            query['NeedStatusNotify'] = request.need_status_notify
        if not UtilClient.is_unset(request.notify_auth_key):
            query['NotifyAuthKey'] = request.notify_auth_key
        if not UtilClient.is_unset(request.notify_req_auth):
            query['NotifyReqAuth'] = request.notify_req_auth
        if not UtilClient.is_unset(request.notify_url):
            query['NotifyUrl'] = request.notify_url
        if not UtilClient.is_unset(request.on_demand_url):
            query['OnDemandUrl'] = request.on_demand_url
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveRecordNotifyConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveRecordNotifyConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_live_record_notify_config_with_options_async(
        self,
        request: live_20161101_models.AddLiveRecordNotifyConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveRecordNotifyConfigResponse:
        """
        @summary Configures recording callbacks for a domain name.
        
        @description Before you call this operation to configure recording callbacks for a domain name, you can query whether the domain name already has recording callbacks configured. For more information, see [DescribeLiveRecordNotifyConfig](https://help.aliyun.com/document_detail/2847893.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveRecordNotifyConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveRecordNotifyConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.need_status_notify):
            query['NeedStatusNotify'] = request.need_status_notify
        if not UtilClient.is_unset(request.notify_auth_key):
            query['NotifyAuthKey'] = request.notify_auth_key
        if not UtilClient.is_unset(request.notify_req_auth):
            query['NotifyReqAuth'] = request.notify_req_auth
        if not UtilClient.is_unset(request.notify_url):
            query['NotifyUrl'] = request.notify_url
        if not UtilClient.is_unset(request.on_demand_url):
            query['OnDemandUrl'] = request.on_demand_url
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveRecordNotifyConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveRecordNotifyConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_live_record_notify_config(
        self,
        request: live_20161101_models.AddLiveRecordNotifyConfigRequest,
    ) -> live_20161101_models.AddLiveRecordNotifyConfigResponse:
        """
        @summary Configures recording callbacks for a domain name.
        
        @description Before you call this operation to configure recording callbacks for a domain name, you can query whether the domain name already has recording callbacks configured. For more information, see [DescribeLiveRecordNotifyConfig](https://help.aliyun.com/document_detail/2847893.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveRecordNotifyConfigRequest
        @return: AddLiveRecordNotifyConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_live_record_notify_config_with_options(request, runtime)

    async def add_live_record_notify_config_async(
        self,
        request: live_20161101_models.AddLiveRecordNotifyConfigRequest,
    ) -> live_20161101_models.AddLiveRecordNotifyConfigResponse:
        """
        @summary Configures recording callbacks for a domain name.
        
        @description Before you call this operation to configure recording callbacks for a domain name, you can query whether the domain name already has recording callbacks configured. For more information, see [DescribeLiveRecordNotifyConfig](https://help.aliyun.com/document_detail/2847893.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveRecordNotifyConfigRequest
        @return: AddLiveRecordNotifyConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_live_record_notify_config_with_options_async(request, runtime)

    def add_live_record_vod_config_with_options(
        self,
        request: live_20161101_models.AddLiveRecordVodConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveRecordVodConfigResponse:
        """
        @summary Adds a Live-to-VOD configuration to store recordings in the media library of ApsaraVideo VOD.
        
        @description You can call this operation to configure the Live-to-VOD feature to store recordings in the media library of ApsaraVideo VOD.
        >  You cannot configure the Live-to-VOD feature by using a Finance Cloud account.
        ## [](#qps-)QPS limit
        You can call this operation up to 1,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveRecordVodConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveRecordVodConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.auto_compose):
            query['AutoCompose'] = request.auto_compose
        if not UtilClient.is_unset(request.compose_vod_transcode_group_id):
            query['ComposeVodTranscodeGroupId'] = request.compose_vod_transcode_group_id
        if not UtilClient.is_unset(request.cycle_duration):
            query['CycleDuration'] = request.cycle_duration
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.on_demand):
            query['OnDemand'] = request.on_demand
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.storage_location):
            query['StorageLocation'] = request.storage_location
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        if not UtilClient.is_unset(request.vod_transcode_group_id):
            query['VodTranscodeGroupId'] = request.vod_transcode_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveRecordVodConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveRecordVodConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_live_record_vod_config_with_options_async(
        self,
        request: live_20161101_models.AddLiveRecordVodConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveRecordVodConfigResponse:
        """
        @summary Adds a Live-to-VOD configuration to store recordings in the media library of ApsaraVideo VOD.
        
        @description You can call this operation to configure the Live-to-VOD feature to store recordings in the media library of ApsaraVideo VOD.
        >  You cannot configure the Live-to-VOD feature by using a Finance Cloud account.
        ## [](#qps-)QPS limit
        You can call this operation up to 1,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveRecordVodConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveRecordVodConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.auto_compose):
            query['AutoCompose'] = request.auto_compose
        if not UtilClient.is_unset(request.compose_vod_transcode_group_id):
            query['ComposeVodTranscodeGroupId'] = request.compose_vod_transcode_group_id
        if not UtilClient.is_unset(request.cycle_duration):
            query['CycleDuration'] = request.cycle_duration
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.on_demand):
            query['OnDemand'] = request.on_demand
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.storage_location):
            query['StorageLocation'] = request.storage_location
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        if not UtilClient.is_unset(request.vod_transcode_group_id):
            query['VodTranscodeGroupId'] = request.vod_transcode_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveRecordVodConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveRecordVodConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_live_record_vod_config(
        self,
        request: live_20161101_models.AddLiveRecordVodConfigRequest,
    ) -> live_20161101_models.AddLiveRecordVodConfigResponse:
        """
        @summary Adds a Live-to-VOD configuration to store recordings in the media library of ApsaraVideo VOD.
        
        @description You can call this operation to configure the Live-to-VOD feature to store recordings in the media library of ApsaraVideo VOD.
        >  You cannot configure the Live-to-VOD feature by using a Finance Cloud account.
        ## [](#qps-)QPS limit
        You can call this operation up to 1,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveRecordVodConfigRequest
        @return: AddLiveRecordVodConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_live_record_vod_config_with_options(request, runtime)

    async def add_live_record_vod_config_async(
        self,
        request: live_20161101_models.AddLiveRecordVodConfigRequest,
    ) -> live_20161101_models.AddLiveRecordVodConfigResponse:
        """
        @summary Adds a Live-to-VOD configuration to store recordings in the media library of ApsaraVideo VOD.
        
        @description You can call this operation to configure the Live-to-VOD feature to store recordings in the media library of ApsaraVideo VOD.
        >  You cannot configure the Live-to-VOD feature by using a Finance Cloud account.
        ## [](#qps-)QPS limit
        You can call this operation up to 1,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveRecordVodConfigRequest
        @return: AddLiveRecordVodConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_live_record_vod_config_with_options_async(request, runtime)

    def add_live_snapshot_detect_porn_config_with_options(
        self,
        request: live_20161101_models.AddLiveSnapshotDetectPornConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveSnapshotDetectPornConfigResponse:
        """
        @summary Adds a video moderation configuration for live streams in an application under a domain name.
        
        @description - The live streaming audit function identifies and reviews违规sensitive content at the domain and App level, and promptly notifies users of such violations via callbacks. Users can then review the content and take appropriate actions.
        - Currently, only some live streaming centers support intelligent auditing. For a list of live streaming centers that support this feature, please refer to [Service Regions](https://help.aliyun.com/document_detail/193730.html).
        ## QPS Limitation
        The QPS limit for this API per user is 30 requests/second. Exceeding this limit will result in API throttling, which may impact your services. Please use the API judiciously. For more information, see [QPS Limitations](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddLiveSnapshotDetectPornConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveSnapshotDetectPornConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.interval):
            query['Interval'] = request.interval
        if not UtilClient.is_unset(request.oss_bucket):
            query['OssBucket'] = request.oss_bucket
        if not UtilClient.is_unset(request.oss_endpoint):
            query['OssEndpoint'] = request.oss_endpoint
        if not UtilClient.is_unset(request.oss_object):
            query['OssObject'] = request.oss_object
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.scene):
            query['Scene'] = request.scene
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveSnapshotDetectPornConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveSnapshotDetectPornConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_live_snapshot_detect_porn_config_with_options_async(
        self,
        request: live_20161101_models.AddLiveSnapshotDetectPornConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveSnapshotDetectPornConfigResponse:
        """
        @summary Adds a video moderation configuration for live streams in an application under a domain name.
        
        @description - The live streaming audit function identifies and reviews违规sensitive content at the domain and App level, and promptly notifies users of such violations via callbacks. Users can then review the content and take appropriate actions.
        - Currently, only some live streaming centers support intelligent auditing. For a list of live streaming centers that support this feature, please refer to [Service Regions](https://help.aliyun.com/document_detail/193730.html).
        ## QPS Limitation
        The QPS limit for this API per user is 30 requests/second. Exceeding this limit will result in API throttling, which may impact your services. Please use the API judiciously. For more information, see [QPS Limitations](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddLiveSnapshotDetectPornConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveSnapshotDetectPornConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.interval):
            query['Interval'] = request.interval
        if not UtilClient.is_unset(request.oss_bucket):
            query['OssBucket'] = request.oss_bucket
        if not UtilClient.is_unset(request.oss_endpoint):
            query['OssEndpoint'] = request.oss_endpoint
        if not UtilClient.is_unset(request.oss_object):
            query['OssObject'] = request.oss_object
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.scene):
            query['Scene'] = request.scene
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveSnapshotDetectPornConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveSnapshotDetectPornConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_live_snapshot_detect_porn_config(
        self,
        request: live_20161101_models.AddLiveSnapshotDetectPornConfigRequest,
    ) -> live_20161101_models.AddLiveSnapshotDetectPornConfigResponse:
        """
        @summary Adds a video moderation configuration for live streams in an application under a domain name.
        
        @description - The live streaming audit function identifies and reviews违规sensitive content at the domain and App level, and promptly notifies users of such violations via callbacks. Users can then review the content and take appropriate actions.
        - Currently, only some live streaming centers support intelligent auditing. For a list of live streaming centers that support this feature, please refer to [Service Regions](https://help.aliyun.com/document_detail/193730.html).
        ## QPS Limitation
        The QPS limit for this API per user is 30 requests/second. Exceeding this limit will result in API throttling, which may impact your services. Please use the API judiciously. For more information, see [QPS Limitations](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddLiveSnapshotDetectPornConfigRequest
        @return: AddLiveSnapshotDetectPornConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_live_snapshot_detect_porn_config_with_options(request, runtime)

    async def add_live_snapshot_detect_porn_config_async(
        self,
        request: live_20161101_models.AddLiveSnapshotDetectPornConfigRequest,
    ) -> live_20161101_models.AddLiveSnapshotDetectPornConfigResponse:
        """
        @summary Adds a video moderation configuration for live streams in an application under a domain name.
        
        @description - The live streaming audit function identifies and reviews违规sensitive content at the domain and App level, and promptly notifies users of such violations via callbacks. Users can then review the content and take appropriate actions.
        - Currently, only some live streaming centers support intelligent auditing. For a list of live streaming centers that support this feature, please refer to [Service Regions](https://help.aliyun.com/document_detail/193730.html).
        ## QPS Limitation
        The QPS limit for this API per user is 30 requests/second. Exceeding this limit will result in API throttling, which may impact your services. Please use the API judiciously. For more information, see [QPS Limitations](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddLiveSnapshotDetectPornConfigRequest
        @return: AddLiveSnapshotDetectPornConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_live_snapshot_detect_porn_config_with_options_async(request, runtime)

    def add_live_snapshot_notify_config_with_options(
        self,
        request: live_20161101_models.AddLiveSnapshotNotifyConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveSnapshotNotifyConfigResponse:
        """
        @summary Configures snapshot callbacks.
        
        @description ### QPS Limit
        The QPS limit for this API per user is 30 times/second. Exceeding this limit will result in API calls being throttled, which may impact your business operations. Please use the API reasonably. For more information, please refer to [QPS Limitation](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddLiveSnapshotNotifyConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveSnapshotNotifyConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.notify_auth_key):
            query['NotifyAuthKey'] = request.notify_auth_key
        if not UtilClient.is_unset(request.notify_req_auth):
            query['NotifyReqAuth'] = request.notify_req_auth
        if not UtilClient.is_unset(request.notify_url):
            query['NotifyUrl'] = request.notify_url
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveSnapshotNotifyConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveSnapshotNotifyConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_live_snapshot_notify_config_with_options_async(
        self,
        request: live_20161101_models.AddLiveSnapshotNotifyConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveSnapshotNotifyConfigResponse:
        """
        @summary Configures snapshot callbacks.
        
        @description ### QPS Limit
        The QPS limit for this API per user is 30 times/second. Exceeding this limit will result in API calls being throttled, which may impact your business operations. Please use the API reasonably. For more information, please refer to [QPS Limitation](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddLiveSnapshotNotifyConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveSnapshotNotifyConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.notify_auth_key):
            query['NotifyAuthKey'] = request.notify_auth_key
        if not UtilClient.is_unset(request.notify_req_auth):
            query['NotifyReqAuth'] = request.notify_req_auth
        if not UtilClient.is_unset(request.notify_url):
            query['NotifyUrl'] = request.notify_url
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveSnapshotNotifyConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveSnapshotNotifyConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_live_snapshot_notify_config(
        self,
        request: live_20161101_models.AddLiveSnapshotNotifyConfigRequest,
    ) -> live_20161101_models.AddLiveSnapshotNotifyConfigResponse:
        """
        @summary Configures snapshot callbacks.
        
        @description ### QPS Limit
        The QPS limit for this API per user is 30 times/second. Exceeding this limit will result in API calls being throttled, which may impact your business operations. Please use the API reasonably. For more information, please refer to [QPS Limitation](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddLiveSnapshotNotifyConfigRequest
        @return: AddLiveSnapshotNotifyConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_live_snapshot_notify_config_with_options(request, runtime)

    async def add_live_snapshot_notify_config_async(
        self,
        request: live_20161101_models.AddLiveSnapshotNotifyConfigRequest,
    ) -> live_20161101_models.AddLiveSnapshotNotifyConfigResponse:
        """
        @summary Configures snapshot callbacks.
        
        @description ### QPS Limit
        The QPS limit for this API per user is 30 times/second. Exceeding this limit will result in API calls being throttled, which may impact your business operations. Please use the API reasonably. For more information, please refer to [QPS Limitation](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddLiveSnapshotNotifyConfigRequest
        @return: AddLiveSnapshotNotifyConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_live_snapshot_notify_config_with_options_async(request, runtime)

    def add_live_stream_merge_with_options(
        self,
        request: live_20161101_models.AddLiveStreamMergeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveStreamMergeResponse:
        """
        @summary Invoke AddLiveStreamMerge to add primary and backup stream merging configuration.
        
        @description You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveStreamMergeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveStreamMergeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.in_app_name_1):
            query['InAppName1'] = request.in_app_name_1
        if not UtilClient.is_unset(request.in_app_name_2):
            query['InAppName2'] = request.in_app_name_2
        if not UtilClient.is_unset(request.in_stream_name_1):
            query['InStreamName1'] = request.in_stream_name_1
        if not UtilClient.is_unset(request.in_stream_name_2):
            query['InStreamName2'] = request.in_stream_name_2
        if not UtilClient.is_unset(request.live_merger):
            query['LiveMerger'] = request.live_merger
        if not UtilClient.is_unset(request.merge_parameters):
            query['MergeParameters'] = request.merge_parameters
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.protocol):
            query['Protocol'] = request.protocol
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveStreamMerge',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveStreamMergeResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_live_stream_merge_with_options_async(
        self,
        request: live_20161101_models.AddLiveStreamMergeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveStreamMergeResponse:
        """
        @summary Invoke AddLiveStreamMerge to add primary and backup stream merging configuration.
        
        @description You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveStreamMergeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveStreamMergeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.in_app_name_1):
            query['InAppName1'] = request.in_app_name_1
        if not UtilClient.is_unset(request.in_app_name_2):
            query['InAppName2'] = request.in_app_name_2
        if not UtilClient.is_unset(request.in_stream_name_1):
            query['InStreamName1'] = request.in_stream_name_1
        if not UtilClient.is_unset(request.in_stream_name_2):
            query['InStreamName2'] = request.in_stream_name_2
        if not UtilClient.is_unset(request.live_merger):
            query['LiveMerger'] = request.live_merger
        if not UtilClient.is_unset(request.merge_parameters):
            query['MergeParameters'] = request.merge_parameters
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.protocol):
            query['Protocol'] = request.protocol
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveStreamMerge',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveStreamMergeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_live_stream_merge(
        self,
        request: live_20161101_models.AddLiveStreamMergeRequest,
    ) -> live_20161101_models.AddLiveStreamMergeResponse:
        """
        @summary Invoke AddLiveStreamMerge to add primary and backup stream merging configuration.
        
        @description You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveStreamMergeRequest
        @return: AddLiveStreamMergeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_live_stream_merge_with_options(request, runtime)

    async def add_live_stream_merge_async(
        self,
        request: live_20161101_models.AddLiveStreamMergeRequest,
    ) -> live_20161101_models.AddLiveStreamMergeResponse:
        """
        @summary Invoke AddLiveStreamMerge to add primary and backup stream merging configuration.
        
        @description You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveStreamMergeRequest
        @return: AddLiveStreamMergeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_live_stream_merge_with_options_async(request, runtime)

    def add_live_stream_transcode_with_options(
        self,
        request: live_20161101_models.AddLiveStreamTranscodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveStreamTranscodeResponse:
        """
        @summary Adds transcoding configurations for a streaming domain.
        
        @description You must obtain the customer master key (CMK) in Key Management Service (KMS) before you call this operation to add transcoding configurations. Only standard transcoding templates and Narrowband HD™ transcoding templates are supported for this operation.
        ## QPS limits
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://www.alibabacloud.com/help/en/apsaravideo-live/latest/qps-limit-on-an-api-operation-in-apsaravideo-live).
        
        @param request: AddLiveStreamTranscodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveStreamTranscodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app):
            query['App'] = request.app
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.encrypt_parameters):
            query['EncryptParameters'] = request.encrypt_parameters
        if not UtilClient.is_unset(request.lazy):
            query['Lazy'] = request.lazy
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.template):
            query['Template'] = request.template
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveStreamTranscode',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveStreamTranscodeResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_live_stream_transcode_with_options_async(
        self,
        request: live_20161101_models.AddLiveStreamTranscodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveStreamTranscodeResponse:
        """
        @summary Adds transcoding configurations for a streaming domain.
        
        @description You must obtain the customer master key (CMK) in Key Management Service (KMS) before you call this operation to add transcoding configurations. Only standard transcoding templates and Narrowband HD™ transcoding templates are supported for this operation.
        ## QPS limits
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://www.alibabacloud.com/help/en/apsaravideo-live/latest/qps-limit-on-an-api-operation-in-apsaravideo-live).
        
        @param request: AddLiveStreamTranscodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveStreamTranscodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app):
            query['App'] = request.app
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.encrypt_parameters):
            query['EncryptParameters'] = request.encrypt_parameters
        if not UtilClient.is_unset(request.lazy):
            query['Lazy'] = request.lazy
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.template):
            query['Template'] = request.template
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveStreamTranscode',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveStreamTranscodeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_live_stream_transcode(
        self,
        request: live_20161101_models.AddLiveStreamTranscodeRequest,
    ) -> live_20161101_models.AddLiveStreamTranscodeResponse:
        """
        @summary Adds transcoding configurations for a streaming domain.
        
        @description You must obtain the customer master key (CMK) in Key Management Service (KMS) before you call this operation to add transcoding configurations. Only standard transcoding templates and Narrowband HD™ transcoding templates are supported for this operation.
        ## QPS limits
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://www.alibabacloud.com/help/en/apsaravideo-live/latest/qps-limit-on-an-api-operation-in-apsaravideo-live).
        
        @param request: AddLiveStreamTranscodeRequest
        @return: AddLiveStreamTranscodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_live_stream_transcode_with_options(request, runtime)

    async def add_live_stream_transcode_async(
        self,
        request: live_20161101_models.AddLiveStreamTranscodeRequest,
    ) -> live_20161101_models.AddLiveStreamTranscodeResponse:
        """
        @summary Adds transcoding configurations for a streaming domain.
        
        @description You must obtain the customer master key (CMK) in Key Management Service (KMS) before you call this operation to add transcoding configurations. Only standard transcoding templates and Narrowband HD™ transcoding templates are supported for this operation.
        ## QPS limits
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://www.alibabacloud.com/help/en/apsaravideo-live/latest/qps-limit-on-an-api-operation-in-apsaravideo-live).
        
        @param request: AddLiveStreamTranscodeRequest
        @return: AddLiveStreamTranscodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_live_stream_transcode_with_options_async(request, runtime)

    def add_live_stream_watermark_with_options(
        self,
        request: live_20161101_models.AddLiveStreamWatermarkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveStreamWatermarkResponse:
        """
        @summary Creates a watermark template.
        
        @description    You can call this operation to create a watermark template and configure information such as the watermark content and layout in the template.
        After you create a watermark template, you must also call the [AddLiveStreamWatermarkRule](https://help.aliyun.com/document_detail/2848100.html) operation to add a watermark rule. A live stream in progress can contain the watermark only after the stream is re-ingested.
        ## [](#qps-)QPS limit
        You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveStreamWatermarkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveStreamWatermarkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.height):
            query['Height'] = request.height
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.offset_corner):
            query['OffsetCorner'] = request.offset_corner
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.picture_url):
            query['PictureUrl'] = request.picture_url
        if not UtilClient.is_unset(request.ref_height):
            query['RefHeight'] = request.ref_height
        if not UtilClient.is_unset(request.ref_width):
            query['RefWidth'] = request.ref_width
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.transparency):
            query['Transparency'] = request.transparency
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.xoffset):
            query['XOffset'] = request.xoffset
        if not UtilClient.is_unset(request.yoffset):
            query['YOffset'] = request.yoffset
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveStreamWatermark',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveStreamWatermarkResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_live_stream_watermark_with_options_async(
        self,
        request: live_20161101_models.AddLiveStreamWatermarkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveStreamWatermarkResponse:
        """
        @summary Creates a watermark template.
        
        @description    You can call this operation to create a watermark template and configure information such as the watermark content and layout in the template.
        After you create a watermark template, you must also call the [AddLiveStreamWatermarkRule](https://help.aliyun.com/document_detail/2848100.html) operation to add a watermark rule. A live stream in progress can contain the watermark only after the stream is re-ingested.
        ## [](#qps-)QPS limit
        You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveStreamWatermarkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveStreamWatermarkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.height):
            query['Height'] = request.height
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.offset_corner):
            query['OffsetCorner'] = request.offset_corner
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.picture_url):
            query['PictureUrl'] = request.picture_url
        if not UtilClient.is_unset(request.ref_height):
            query['RefHeight'] = request.ref_height
        if not UtilClient.is_unset(request.ref_width):
            query['RefWidth'] = request.ref_width
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.transparency):
            query['Transparency'] = request.transparency
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.xoffset):
            query['XOffset'] = request.xoffset
        if not UtilClient.is_unset(request.yoffset):
            query['YOffset'] = request.yoffset
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveStreamWatermark',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveStreamWatermarkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_live_stream_watermark(
        self,
        request: live_20161101_models.AddLiveStreamWatermarkRequest,
    ) -> live_20161101_models.AddLiveStreamWatermarkResponse:
        """
        @summary Creates a watermark template.
        
        @description    You can call this operation to create a watermark template and configure information such as the watermark content and layout in the template.
        After you create a watermark template, you must also call the [AddLiveStreamWatermarkRule](https://help.aliyun.com/document_detail/2848100.html) operation to add a watermark rule. A live stream in progress can contain the watermark only after the stream is re-ingested.
        ## [](#qps-)QPS limit
        You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveStreamWatermarkRequest
        @return: AddLiveStreamWatermarkResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_live_stream_watermark_with_options(request, runtime)

    async def add_live_stream_watermark_async(
        self,
        request: live_20161101_models.AddLiveStreamWatermarkRequest,
    ) -> live_20161101_models.AddLiveStreamWatermarkResponse:
        """
        @summary Creates a watermark template.
        
        @description    You can call this operation to create a watermark template and configure information such as the watermark content and layout in the template.
        After you create a watermark template, you must also call the [AddLiveStreamWatermarkRule](https://help.aliyun.com/document_detail/2848100.html) operation to add a watermark rule. A live stream in progress can contain the watermark only after the stream is re-ingested.
        ## [](#qps-)QPS limit
        You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddLiveStreamWatermarkRequest
        @return: AddLiveStreamWatermarkResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_live_stream_watermark_with_options_async(request, runtime)

    def add_live_stream_watermark_rule_with_options(
        self,
        request: live_20161101_models.AddLiveStreamWatermarkRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveStreamWatermarkRuleResponse:
        """
        @summary Adds a watermark rule.
        
        @description After calling the [AddLiveStreamWatermark](https://help.aliyun.com/document_detail/469416.html) API to add a watermark template, you can use this interface to add watermark rules.
        ## QPS Limit
        The QPS limit for this interface per user is 60 times/second. Exceeding the limit will result in API calls being throttled, which may impact your business. Please use it reasonably. For more information, see [QPS Limit](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddLiveStreamWatermarkRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveStreamWatermarkRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app):
            query['App'] = request.app
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream):
            query['Stream'] = request.stream
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveStreamWatermarkRule',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveStreamWatermarkRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_live_stream_watermark_rule_with_options_async(
        self,
        request: live_20161101_models.AddLiveStreamWatermarkRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddLiveStreamWatermarkRuleResponse:
        """
        @summary Adds a watermark rule.
        
        @description After calling the [AddLiveStreamWatermark](https://help.aliyun.com/document_detail/469416.html) API to add a watermark template, you can use this interface to add watermark rules.
        ## QPS Limit
        The QPS limit for this interface per user is 60 times/second. Exceeding the limit will result in API calls being throttled, which may impact your business. Please use it reasonably. For more information, see [QPS Limit](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddLiveStreamWatermarkRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddLiveStreamWatermarkRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app):
            query['App'] = request.app
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream):
            query['Stream'] = request.stream
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddLiveStreamWatermarkRule',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddLiveStreamWatermarkRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_live_stream_watermark_rule(
        self,
        request: live_20161101_models.AddLiveStreamWatermarkRuleRequest,
    ) -> live_20161101_models.AddLiveStreamWatermarkRuleResponse:
        """
        @summary Adds a watermark rule.
        
        @description After calling the [AddLiveStreamWatermark](https://help.aliyun.com/document_detail/469416.html) API to add a watermark template, you can use this interface to add watermark rules.
        ## QPS Limit
        The QPS limit for this interface per user is 60 times/second. Exceeding the limit will result in API calls being throttled, which may impact your business. Please use it reasonably. For more information, see [QPS Limit](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddLiveStreamWatermarkRuleRequest
        @return: AddLiveStreamWatermarkRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_live_stream_watermark_rule_with_options(request, runtime)

    async def add_live_stream_watermark_rule_async(
        self,
        request: live_20161101_models.AddLiveStreamWatermarkRuleRequest,
    ) -> live_20161101_models.AddLiveStreamWatermarkRuleResponse:
        """
        @summary Adds a watermark rule.
        
        @description After calling the [AddLiveStreamWatermark](https://help.aliyun.com/document_detail/469416.html) API to add a watermark template, you can use this interface to add watermark rules.
        ## QPS Limit
        The QPS limit for this interface per user is 60 times/second. Exceeding the limit will result in API calls being throttled, which may impact your business. Please use it reasonably. For more information, see [QPS Limit](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddLiveStreamWatermarkRuleRequest
        @return: AddLiveStreamWatermarkRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_live_stream_watermark_rule_with_options_async(request, runtime)

    def add_playlist_items_with_options(
        self,
        request: live_20161101_models.AddPlaylistItemsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddPlaylistItemsResponse:
        """
        @summary Adds episodes to an episode list.
        
        @description Create a production studio, add a layout and components to the production studio, and then call this operation to add episodes. If no episode list exists in the production studio, this operation creates an episode list for the production studio. For more information about how to create a production studio, see [CreateCaster](https://help.aliyun.com/document_detail/2848009.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddPlaylistItemsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddPlaylistItemsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.program_config):
            query['ProgramConfig'] = request.program_config
        if not UtilClient.is_unset(request.program_id):
            query['ProgramId'] = request.program_id
        if not UtilClient.is_unset(request.program_items):
            query['ProgramItems'] = request.program_items
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddPlaylistItems',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddPlaylistItemsResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_playlist_items_with_options_async(
        self,
        request: live_20161101_models.AddPlaylistItemsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddPlaylistItemsResponse:
        """
        @summary Adds episodes to an episode list.
        
        @description Create a production studio, add a layout and components to the production studio, and then call this operation to add episodes. If no episode list exists in the production studio, this operation creates an episode list for the production studio. For more information about how to create a production studio, see [CreateCaster](https://help.aliyun.com/document_detail/2848009.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddPlaylistItemsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddPlaylistItemsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.program_config):
            query['ProgramConfig'] = request.program_config
        if not UtilClient.is_unset(request.program_id):
            query['ProgramId'] = request.program_id
        if not UtilClient.is_unset(request.program_items):
            query['ProgramItems'] = request.program_items
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddPlaylistItems',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddPlaylistItemsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_playlist_items(
        self,
        request: live_20161101_models.AddPlaylistItemsRequest,
    ) -> live_20161101_models.AddPlaylistItemsResponse:
        """
        @summary Adds episodes to an episode list.
        
        @description Create a production studio, add a layout and components to the production studio, and then call this operation to add episodes. If no episode list exists in the production studio, this operation creates an episode list for the production studio. For more information about how to create a production studio, see [CreateCaster](https://help.aliyun.com/document_detail/2848009.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddPlaylistItemsRequest
        @return: AddPlaylistItemsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_playlist_items_with_options(request, runtime)

    async def add_playlist_items_async(
        self,
        request: live_20161101_models.AddPlaylistItemsRequest,
    ) -> live_20161101_models.AddPlaylistItemsResponse:
        """
        @summary Adds episodes to an episode list.
        
        @description Create a production studio, add a layout and components to the production studio, and then call this operation to add episodes. If no episode list exists in the production studio, this operation creates an episode list for the production studio. For more information about how to create a production studio, see [CreateCaster](https://help.aliyun.com/document_detail/2848009.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddPlaylistItemsRequest
        @return: AddPlaylistItemsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_playlist_items_with_options_async(request, runtime)

    def add_rts_live_stream_transcode_with_options(
        self,
        request: live_20161101_models.AddRtsLiveStreamTranscodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddRtsLiveStreamTranscodeResponse:
        """
        @summary Creates a Real-Time Streaming (RTS) transcoding configuration for a streaming domain.
        
        @description You can call this operation to add an RTS transcoding configuration. This operation supports four template types: h264, h264-nbhd, h264-origin, and audio.
        ## QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddRtsLiveStreamTranscodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddRtsLiveStreamTranscodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app):
            query['App'] = request.app
        if not UtilClient.is_unset(request.audio_bitrate):
            query['AudioBitrate'] = request.audio_bitrate
        if not UtilClient.is_unset(request.audio_channel_num):
            query['AudioChannelNum'] = request.audio_channel_num
        if not UtilClient.is_unset(request.audio_codec):
            query['AudioCodec'] = request.audio_codec
        if not UtilClient.is_unset(request.audio_profile):
            query['AudioProfile'] = request.audio_profile
        if not UtilClient.is_unset(request.audio_rate):
            query['AudioRate'] = request.audio_rate
        if not UtilClient.is_unset(request.delete_bframes):
            query['DeleteBframes'] = request.delete_bframes
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.fps):
            query['FPS'] = request.fps
        if not UtilClient.is_unset(request.gop):
            query['Gop'] = request.gop
        if not UtilClient.is_unset(request.height):
            query['Height'] = request.height
        if not UtilClient.is_unset(request.lazy):
            query['Lazy'] = request.lazy
        if not UtilClient.is_unset(request.opus):
            query['Opus'] = request.opus
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.profile):
            query['Profile'] = request.profile
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.template):
            query['Template'] = request.template
        if not UtilClient.is_unset(request.template_type):
            query['TemplateType'] = request.template_type
        if not UtilClient.is_unset(request.video_bitrate):
            query['VideoBitrate'] = request.video_bitrate
        if not UtilClient.is_unset(request.width):
            query['Width'] = request.width
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddRtsLiveStreamTranscode',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddRtsLiveStreamTranscodeResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_rts_live_stream_transcode_with_options_async(
        self,
        request: live_20161101_models.AddRtsLiveStreamTranscodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddRtsLiveStreamTranscodeResponse:
        """
        @summary Creates a Real-Time Streaming (RTS) transcoding configuration for a streaming domain.
        
        @description You can call this operation to add an RTS transcoding configuration. This operation supports four template types: h264, h264-nbhd, h264-origin, and audio.
        ## QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddRtsLiveStreamTranscodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddRtsLiveStreamTranscodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app):
            query['App'] = request.app
        if not UtilClient.is_unset(request.audio_bitrate):
            query['AudioBitrate'] = request.audio_bitrate
        if not UtilClient.is_unset(request.audio_channel_num):
            query['AudioChannelNum'] = request.audio_channel_num
        if not UtilClient.is_unset(request.audio_codec):
            query['AudioCodec'] = request.audio_codec
        if not UtilClient.is_unset(request.audio_profile):
            query['AudioProfile'] = request.audio_profile
        if not UtilClient.is_unset(request.audio_rate):
            query['AudioRate'] = request.audio_rate
        if not UtilClient.is_unset(request.delete_bframes):
            query['DeleteBframes'] = request.delete_bframes
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.fps):
            query['FPS'] = request.fps
        if not UtilClient.is_unset(request.gop):
            query['Gop'] = request.gop
        if not UtilClient.is_unset(request.height):
            query['Height'] = request.height
        if not UtilClient.is_unset(request.lazy):
            query['Lazy'] = request.lazy
        if not UtilClient.is_unset(request.opus):
            query['Opus'] = request.opus
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.profile):
            query['Profile'] = request.profile
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.template):
            query['Template'] = request.template
        if not UtilClient.is_unset(request.template_type):
            query['TemplateType'] = request.template_type
        if not UtilClient.is_unset(request.video_bitrate):
            query['VideoBitrate'] = request.video_bitrate
        if not UtilClient.is_unset(request.width):
            query['Width'] = request.width
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddRtsLiveStreamTranscode',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddRtsLiveStreamTranscodeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_rts_live_stream_transcode(
        self,
        request: live_20161101_models.AddRtsLiveStreamTranscodeRequest,
    ) -> live_20161101_models.AddRtsLiveStreamTranscodeResponse:
        """
        @summary Creates a Real-Time Streaming (RTS) transcoding configuration for a streaming domain.
        
        @description You can call this operation to add an RTS transcoding configuration. This operation supports four template types: h264, h264-nbhd, h264-origin, and audio.
        ## QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddRtsLiveStreamTranscodeRequest
        @return: AddRtsLiveStreamTranscodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_rts_live_stream_transcode_with_options(request, runtime)

    async def add_rts_live_stream_transcode_async(
        self,
        request: live_20161101_models.AddRtsLiveStreamTranscodeRequest,
    ) -> live_20161101_models.AddRtsLiveStreamTranscodeResponse:
        """
        @summary Creates a Real-Time Streaming (RTS) transcoding configuration for a streaming domain.
        
        @description You can call this operation to add an RTS transcoding configuration. This operation supports four template types: h264, h264-nbhd, h264-origin, and audio.
        ## QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: AddRtsLiveStreamTranscodeRequest
        @return: AddRtsLiveStreamTranscodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_rts_live_stream_transcode_with_options_async(request, runtime)

    def add_show_into_show_list_with_options(
        self,
        request: live_20161101_models.AddShowIntoShowListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddShowIntoShowListResponse:
        """
        @summary Adds an episode to an episode list.
        
        @description You must create a production studio in the new playlist mode and add media resources to the production studio before you can call this operation. For information about how to create a production studio, see [CreateCaster](https://help.aliyun.com/document_detail/2848009.html).
        You can add up to 1,000 episodes to an episode list.
        >
        When you select media resources from ApsaraVideo VOD, we recommend that you select resources that are stored in hosted OSS buckets. Resources stored in non-hosted OSS buckets have a validity period. Pay attention to the validity if you select resources that are stored in non-hosted OSS buckets.
        When you add media resources to a production studio, we recommend that you select resources from ApsaraVideo Live and ApsaraVideo VOD. If you add a third-party stream by specifying a streaming URL, there is a possibility that the stream fails to be played. You must pay attention to the quality and validity of the third-party stream.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddShowIntoShowListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddShowIntoShowListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.duration):
            query['Duration'] = request.duration
        if not UtilClient.is_unset(request.live_input_type):
            query['LiveInputType'] = request.live_input_type
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.repeat_times):
            query['RepeatTimes'] = request.repeat_times
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.resource_url):
            query['ResourceUrl'] = request.resource_url
        if not UtilClient.is_unset(request.show_name):
            query['ShowName'] = request.show_name
        if not UtilClient.is_unset(request.spot):
            query['Spot'] = request.spot
        if not UtilClient.is_unset(request.is_batch_mode):
            query['isBatchMode'] = request.is_batch_mode
        if not UtilClient.is_unset(request.show_list):
            query['showList'] = request.show_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddShowIntoShowList',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddShowIntoShowListResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_show_into_show_list_with_options_async(
        self,
        request: live_20161101_models.AddShowIntoShowListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddShowIntoShowListResponse:
        """
        @summary Adds an episode to an episode list.
        
        @description You must create a production studio in the new playlist mode and add media resources to the production studio before you can call this operation. For information about how to create a production studio, see [CreateCaster](https://help.aliyun.com/document_detail/2848009.html).
        You can add up to 1,000 episodes to an episode list.
        >
        When you select media resources from ApsaraVideo VOD, we recommend that you select resources that are stored in hosted OSS buckets. Resources stored in non-hosted OSS buckets have a validity period. Pay attention to the validity if you select resources that are stored in non-hosted OSS buckets.
        When you add media resources to a production studio, we recommend that you select resources from ApsaraVideo Live and ApsaraVideo VOD. If you add a third-party stream by specifying a streaming URL, there is a possibility that the stream fails to be played. You must pay attention to the quality and validity of the third-party stream.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddShowIntoShowListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddShowIntoShowListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.duration):
            query['Duration'] = request.duration
        if not UtilClient.is_unset(request.live_input_type):
            query['LiveInputType'] = request.live_input_type
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.repeat_times):
            query['RepeatTimes'] = request.repeat_times
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.resource_url):
            query['ResourceUrl'] = request.resource_url
        if not UtilClient.is_unset(request.show_name):
            query['ShowName'] = request.show_name
        if not UtilClient.is_unset(request.spot):
            query['Spot'] = request.spot
        if not UtilClient.is_unset(request.is_batch_mode):
            query['isBatchMode'] = request.is_batch_mode
        if not UtilClient.is_unset(request.show_list):
            query['showList'] = request.show_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddShowIntoShowList',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddShowIntoShowListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_show_into_show_list(
        self,
        request: live_20161101_models.AddShowIntoShowListRequest,
    ) -> live_20161101_models.AddShowIntoShowListResponse:
        """
        @summary Adds an episode to an episode list.
        
        @description You must create a production studio in the new playlist mode and add media resources to the production studio before you can call this operation. For information about how to create a production studio, see [CreateCaster](https://help.aliyun.com/document_detail/2848009.html).
        You can add up to 1,000 episodes to an episode list.
        >
        When you select media resources from ApsaraVideo VOD, we recommend that you select resources that are stored in hosted OSS buckets. Resources stored in non-hosted OSS buckets have a validity period. Pay attention to the validity if you select resources that are stored in non-hosted OSS buckets.
        When you add media resources to a production studio, we recommend that you select resources from ApsaraVideo Live and ApsaraVideo VOD. If you add a third-party stream by specifying a streaming URL, there is a possibility that the stream fails to be played. You must pay attention to the quality and validity of the third-party stream.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddShowIntoShowListRequest
        @return: AddShowIntoShowListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_show_into_show_list_with_options(request, runtime)

    async def add_show_into_show_list_async(
        self,
        request: live_20161101_models.AddShowIntoShowListRequest,
    ) -> live_20161101_models.AddShowIntoShowListResponse:
        """
        @summary Adds an episode to an episode list.
        
        @description You must create a production studio in the new playlist mode and add media resources to the production studio before you can call this operation. For information about how to create a production studio, see [CreateCaster](https://help.aliyun.com/document_detail/2848009.html).
        You can add up to 1,000 episodes to an episode list.
        >
        When you select media resources from ApsaraVideo VOD, we recommend that you select resources that are stored in hosted OSS buckets. Resources stored in non-hosted OSS buckets have a validity period. Pay attention to the validity if you select resources that are stored in non-hosted OSS buckets.
        When you add media resources to a production studio, we recommend that you select resources from ApsaraVideo Live and ApsaraVideo VOD. If you add a third-party stream by specifying a streaming URL, there is a possibility that the stream fails to be played. You must pay attention to the quality and validity of the third-party stream.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddShowIntoShowListRequest
        @return: AddShowIntoShowListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_show_into_show_list_with_options_async(request, runtime)

    def add_studio_layout_with_options(
        self,
        request: live_20161101_models.AddStudioLayoutRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddStudioLayoutResponse:
        """
        @summary Configures a layout for a virtual studio.
        
        @description You can call this operation to configure a common layout or a studio layout for a virtual studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddStudioLayoutRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddStudioLayoutResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bg_image_config):
            query['BgImageConfig'] = request.bg_image_config
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.common_config):
            query['CommonConfig'] = request.common_config
        if not UtilClient.is_unset(request.layer_order_config_list):
            query['LayerOrderConfigList'] = request.layer_order_config_list
        if not UtilClient.is_unset(request.layout_name):
            query['LayoutName'] = request.layout_name
        if not UtilClient.is_unset(request.layout_type):
            query['LayoutType'] = request.layout_type
        if not UtilClient.is_unset(request.media_input_config_list):
            query['MediaInputConfigList'] = request.media_input_config_list
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.screen_input_config_list):
            query['ScreenInputConfigList'] = request.screen_input_config_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddStudioLayout',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddStudioLayoutResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_studio_layout_with_options_async(
        self,
        request: live_20161101_models.AddStudioLayoutRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddStudioLayoutResponse:
        """
        @summary Configures a layout for a virtual studio.
        
        @description You can call this operation to configure a common layout or a studio layout for a virtual studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddStudioLayoutRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddStudioLayoutResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bg_image_config):
            query['BgImageConfig'] = request.bg_image_config
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.common_config):
            query['CommonConfig'] = request.common_config
        if not UtilClient.is_unset(request.layer_order_config_list):
            query['LayerOrderConfigList'] = request.layer_order_config_list
        if not UtilClient.is_unset(request.layout_name):
            query['LayoutName'] = request.layout_name
        if not UtilClient.is_unset(request.layout_type):
            query['LayoutType'] = request.layout_type
        if not UtilClient.is_unset(request.media_input_config_list):
            query['MediaInputConfigList'] = request.media_input_config_list
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.screen_input_config_list):
            query['ScreenInputConfigList'] = request.screen_input_config_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddStudioLayout',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddStudioLayoutResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_studio_layout(
        self,
        request: live_20161101_models.AddStudioLayoutRequest,
    ) -> live_20161101_models.AddStudioLayoutResponse:
        """
        @summary Configures a layout for a virtual studio.
        
        @description You can call this operation to configure a common layout or a studio layout for a virtual studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddStudioLayoutRequest
        @return: AddStudioLayoutResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_studio_layout_with_options(request, runtime)

    async def add_studio_layout_async(
        self,
        request: live_20161101_models.AddStudioLayoutRequest,
    ) -> live_20161101_models.AddStudioLayoutResponse:
        """
        @summary Configures a layout for a virtual studio.
        
        @description You can call this operation to configure a common layout or a studio layout for a virtual studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddStudioLayoutRequest
        @return: AddStudioLayoutResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_studio_layout_with_options_async(request, runtime)

    def add_trancode_seiwith_options(
        self,
        request: live_20161101_models.AddTrancodeSEIRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddTrancodeSEIResponse:
        """
        @summary Inserts supplemental enhancement information (SEI) to transcoded streams.
        
        @description Obtain the streaming domain, and then call this operation to insert SEI to the transcoded streams. Make sure that the stream name is the name of the source stream. This way, the SEI is inserted to all the transcoded streams.
        ## [](#qps-)QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddTrancodeSEIRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddTrancodeSEIResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.delay):
            query['Delay'] = request.delay
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pattern):
            query['Pattern'] = request.pattern
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.repeat):
            query['Repeat'] = request.repeat
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        if not UtilClient.is_unset(request.text):
            query['Text'] = request.text
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddTrancodeSEI',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddTrancodeSEIResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_trancode_seiwith_options_async(
        self,
        request: live_20161101_models.AddTrancodeSEIRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.AddTrancodeSEIResponse:
        """
        @summary Inserts supplemental enhancement information (SEI) to transcoded streams.
        
        @description Obtain the streaming domain, and then call this operation to insert SEI to the transcoded streams. Make sure that the stream name is the name of the source stream. This way, the SEI is inserted to all the transcoded streams.
        ## [](#qps-)QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddTrancodeSEIRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddTrancodeSEIResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.delay):
            query['Delay'] = request.delay
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pattern):
            query['Pattern'] = request.pattern
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.repeat):
            query['Repeat'] = request.repeat
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        if not UtilClient.is_unset(request.text):
            query['Text'] = request.text
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddTrancodeSEI',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.AddTrancodeSEIResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_trancode_sei(
        self,
        request: live_20161101_models.AddTrancodeSEIRequest,
    ) -> live_20161101_models.AddTrancodeSEIResponse:
        """
        @summary Inserts supplemental enhancement information (SEI) to transcoded streams.
        
        @description Obtain the streaming domain, and then call this operation to insert SEI to the transcoded streams. Make sure that the stream name is the name of the source stream. This way, the SEI is inserted to all the transcoded streams.
        ## [](#qps-)QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddTrancodeSEIRequest
        @return: AddTrancodeSEIResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_trancode_seiwith_options(request, runtime)

    async def add_trancode_sei_async(
        self,
        request: live_20161101_models.AddTrancodeSEIRequest,
    ) -> live_20161101_models.AddTrancodeSEIResponse:
        """
        @summary Inserts supplemental enhancement information (SEI) to transcoded streams.
        
        @description Obtain the streaming domain, and then call this operation to insert SEI to the transcoded streams. Make sure that the stream name is the name of the source stream. This way, the SEI is inserted to all the transcoded streams.
        ## [](#qps-)QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: AddTrancodeSEIRequest
        @return: AddTrancodeSEIResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_trancode_seiwith_options_async(request, runtime)

    def ban_live_message_group_with_options(
        self,
        tmp_req: live_20161101_models.BanLiveMessageGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.BanLiveMessageGroupResponse:
        """
        @summary Mutes a group.
        
        @description Before you call this operation, make sure that you have called the [CreateLiveMessageGroup](https://help.aliyun.com/document_detail/2848163.html) operation to create an interactive messaging group.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param tmp_req: BanLiveMessageGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BanLiveMessageGroupResponse
        """
        UtilClient.validate_model(tmp_req)
        request = live_20161101_models.BanLiveMessageGroupShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.except_users):
            request.except_users_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.except_users, 'ExceptUsers', 'simple')
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.data_center):
            query['DataCenter'] = request.data_center
        if not UtilClient.is_unset(request.except_users_shrink):
            query['ExceptUsers'] = request.except_users_shrink
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BanLiveMessageGroup',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.BanLiveMessageGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def ban_live_message_group_with_options_async(
        self,
        tmp_req: live_20161101_models.BanLiveMessageGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.BanLiveMessageGroupResponse:
        """
        @summary Mutes a group.
        
        @description Before you call this operation, make sure that you have called the [CreateLiveMessageGroup](https://help.aliyun.com/document_detail/2848163.html) operation to create an interactive messaging group.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param tmp_req: BanLiveMessageGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BanLiveMessageGroupResponse
        """
        UtilClient.validate_model(tmp_req)
        request = live_20161101_models.BanLiveMessageGroupShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.except_users):
            request.except_users_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.except_users, 'ExceptUsers', 'simple')
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.data_center):
            query['DataCenter'] = request.data_center
        if not UtilClient.is_unset(request.except_users_shrink):
            query['ExceptUsers'] = request.except_users_shrink
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BanLiveMessageGroup',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.BanLiveMessageGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def ban_live_message_group(
        self,
        request: live_20161101_models.BanLiveMessageGroupRequest,
    ) -> live_20161101_models.BanLiveMessageGroupResponse:
        """
        @summary Mutes a group.
        
        @description Before you call this operation, make sure that you have called the [CreateLiveMessageGroup](https://help.aliyun.com/document_detail/2848163.html) operation to create an interactive messaging group.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: BanLiveMessageGroupRequest
        @return: BanLiveMessageGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.ban_live_message_group_with_options(request, runtime)

    async def ban_live_message_group_async(
        self,
        request: live_20161101_models.BanLiveMessageGroupRequest,
    ) -> live_20161101_models.BanLiveMessageGroupResponse:
        """
        @summary Mutes a group.
        
        @description Before you call this operation, make sure that you have called the [CreateLiveMessageGroup](https://help.aliyun.com/document_detail/2848163.html) operation to create an interactive messaging group.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: BanLiveMessageGroupRequest
        @return: BanLiveMessageGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.ban_live_message_group_with_options_async(request, runtime)

    def batch_delete_live_domain_configs_with_options(
        self,
        request: live_20161101_models.BatchDeleteLiveDomainConfigsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.BatchDeleteLiveDomainConfigsResponse:
        """
        @summary Deletes the configurations of multiple domain names at a time.
        
        @description Obtain the domain names for which you want to delete the configurations, and then call this operation to delete the configurations of these domain domains at a time.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: BatchDeleteLiveDomainConfigsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BatchDeleteLiveDomainConfigsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_names):
            query['DomainNames'] = request.domain_names
        if not UtilClient.is_unset(request.function_names):
            query['FunctionNames'] = request.function_names
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BatchDeleteLiveDomainConfigs',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.BatchDeleteLiveDomainConfigsResponse(),
            self.call_api(params, req, runtime)
        )

    async def batch_delete_live_domain_configs_with_options_async(
        self,
        request: live_20161101_models.BatchDeleteLiveDomainConfigsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.BatchDeleteLiveDomainConfigsResponse:
        """
        @summary Deletes the configurations of multiple domain names at a time.
        
        @description Obtain the domain names for which you want to delete the configurations, and then call this operation to delete the configurations of these domain domains at a time.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: BatchDeleteLiveDomainConfigsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BatchDeleteLiveDomainConfigsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_names):
            query['DomainNames'] = request.domain_names
        if not UtilClient.is_unset(request.function_names):
            query['FunctionNames'] = request.function_names
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BatchDeleteLiveDomainConfigs',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.BatchDeleteLiveDomainConfigsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def batch_delete_live_domain_configs(
        self,
        request: live_20161101_models.BatchDeleteLiveDomainConfigsRequest,
    ) -> live_20161101_models.BatchDeleteLiveDomainConfigsResponse:
        """
        @summary Deletes the configurations of multiple domain names at a time.
        
        @description Obtain the domain names for which you want to delete the configurations, and then call this operation to delete the configurations of these domain domains at a time.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: BatchDeleteLiveDomainConfigsRequest
        @return: BatchDeleteLiveDomainConfigsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.batch_delete_live_domain_configs_with_options(request, runtime)

    async def batch_delete_live_domain_configs_async(
        self,
        request: live_20161101_models.BatchDeleteLiveDomainConfigsRequest,
    ) -> live_20161101_models.BatchDeleteLiveDomainConfigsResponse:
        """
        @summary Deletes the configurations of multiple domain names at a time.
        
        @description Obtain the domain names for which you want to delete the configurations, and then call this operation to delete the configurations of these domain domains at a time.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: BatchDeleteLiveDomainConfigsRequest
        @return: BatchDeleteLiveDomainConfigsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.batch_delete_live_domain_configs_with_options_async(request, runtime)

    def batch_get_online_users_with_options(
        self,
        request: live_20161101_models.BatchGetOnlineUsersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.BatchGetOnlineUsersResponse:
        """
        @summary 根据一个或多个用户uid查询用户是否在线
        
        @description ## Usage notes
        You can query whether up to 20 users are online at a time.
        ## QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: BatchGetOnlineUsersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BatchGetOnlineUsersResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.app_id):
            body['AppId'] = request.app_id
        if not UtilClient.is_unset(request.group_id):
            body['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.user_ids):
            body['UserIds'] = request.user_ids
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='BatchGetOnlineUsers',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.BatchGetOnlineUsersResponse(),
            self.call_api(params, req, runtime)
        )

    async def batch_get_online_users_with_options_async(
        self,
        request: live_20161101_models.BatchGetOnlineUsersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.BatchGetOnlineUsersResponse:
        """
        @summary 根据一个或多个用户uid查询用户是否在线
        
        @description ## Usage notes
        You can query whether up to 20 users are online at a time.
        ## QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: BatchGetOnlineUsersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BatchGetOnlineUsersResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.app_id):
            body['AppId'] = request.app_id
        if not UtilClient.is_unset(request.group_id):
            body['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.user_ids):
            body['UserIds'] = request.user_ids
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='BatchGetOnlineUsers',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.BatchGetOnlineUsersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def batch_get_online_users(
        self,
        request: live_20161101_models.BatchGetOnlineUsersRequest,
    ) -> live_20161101_models.BatchGetOnlineUsersResponse:
        """
        @summary 根据一个或多个用户uid查询用户是否在线
        
        @description ## Usage notes
        You can query whether up to 20 users are online at a time.
        ## QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: BatchGetOnlineUsersRequest
        @return: BatchGetOnlineUsersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.batch_get_online_users_with_options(request, runtime)

    async def batch_get_online_users_async(
        self,
        request: live_20161101_models.BatchGetOnlineUsersRequest,
    ) -> live_20161101_models.BatchGetOnlineUsersResponse:
        """
        @summary 根据一个或多个用户uid查询用户是否在线
        
        @description ## Usage notes
        You can query whether up to 20 users are online at a time.
        ## QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: BatchGetOnlineUsersRequest
        @return: BatchGetOnlineUsersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.batch_get_online_users_with_options_async(request, runtime)

    def batch_set_live_domain_configs_with_options(
        self,
        request: live_20161101_models.BatchSetLiveDomainConfigsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.BatchSetLiveDomainConfigsResponse:
        """
        @summary Configures multiple domain names at a time.
        
        @description Obtain the domain names that you want to configure, and then call this operation to configure the domain names in batches.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: BatchSetLiveDomainConfigsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BatchSetLiveDomainConfigsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_names):
            query['DomainNames'] = request.domain_names
        if not UtilClient.is_unset(request.functions):
            query['Functions'] = request.functions
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BatchSetLiveDomainConfigs',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.BatchSetLiveDomainConfigsResponse(),
            self.call_api(params, req, runtime)
        )

    async def batch_set_live_domain_configs_with_options_async(
        self,
        request: live_20161101_models.BatchSetLiveDomainConfigsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.BatchSetLiveDomainConfigsResponse:
        """
        @summary Configures multiple domain names at a time.
        
        @description Obtain the domain names that you want to configure, and then call this operation to configure the domain names in batches.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: BatchSetLiveDomainConfigsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BatchSetLiveDomainConfigsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_names):
            query['DomainNames'] = request.domain_names
        if not UtilClient.is_unset(request.functions):
            query['Functions'] = request.functions
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BatchSetLiveDomainConfigs',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.BatchSetLiveDomainConfigsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def batch_set_live_domain_configs(
        self,
        request: live_20161101_models.BatchSetLiveDomainConfigsRequest,
    ) -> live_20161101_models.BatchSetLiveDomainConfigsResponse:
        """
        @summary Configures multiple domain names at a time.
        
        @description Obtain the domain names that you want to configure, and then call this operation to configure the domain names in batches.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: BatchSetLiveDomainConfigsRequest
        @return: BatchSetLiveDomainConfigsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.batch_set_live_domain_configs_with_options(request, runtime)

    async def batch_set_live_domain_configs_async(
        self,
        request: live_20161101_models.BatchSetLiveDomainConfigsRequest,
    ) -> live_20161101_models.BatchSetLiveDomainConfigsResponse:
        """
        @summary Configures multiple domain names at a time.
        
        @description Obtain the domain names that you want to configure, and then call this operation to configure the domain names in batches.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: BatchSetLiveDomainConfigsRequest
        @return: BatchSetLiveDomainConfigsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.batch_set_live_domain_configs_with_options_async(request, runtime)

    def cancel_mute_all_group_user_with_options(
        self,
        request: live_20161101_models.CancelMuteAllGroupUserRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CancelMuteAllGroupUserResponse:
        """
        @summary Unmutes a message group.
        
        @description ## QPS限制
        本接口的单用户QPS限制为100次/秒。超过限制，API调用会被限流，这可能会影响您的业务，请合理调用。更多信息，请参见[QPS限制](https://help.aliyun.com/document_detail/343507.html)。
        
        @param request: CancelMuteAllGroupUserRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelMuteAllGroupUserResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.app_id):
            body['AppId'] = request.app_id
        if not UtilClient.is_unset(request.broad_cast_type):
            body['BroadCastType'] = request.broad_cast_type
        if not UtilClient.is_unset(request.group_id):
            body['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.operator_user_id):
            body['OperatorUserId'] = request.operator_user_id
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CancelMuteAllGroupUser',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CancelMuteAllGroupUserResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_mute_all_group_user_with_options_async(
        self,
        request: live_20161101_models.CancelMuteAllGroupUserRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CancelMuteAllGroupUserResponse:
        """
        @summary Unmutes a message group.
        
        @description ## QPS限制
        本接口的单用户QPS限制为100次/秒。超过限制，API调用会被限流，这可能会影响您的业务，请合理调用。更多信息，请参见[QPS限制](https://help.aliyun.com/document_detail/343507.html)。
        
        @param request: CancelMuteAllGroupUserRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelMuteAllGroupUserResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.app_id):
            body['AppId'] = request.app_id
        if not UtilClient.is_unset(request.broad_cast_type):
            body['BroadCastType'] = request.broad_cast_type
        if not UtilClient.is_unset(request.group_id):
            body['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.operator_user_id):
            body['OperatorUserId'] = request.operator_user_id
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CancelMuteAllGroupUser',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CancelMuteAllGroupUserResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_mute_all_group_user(
        self,
        request: live_20161101_models.CancelMuteAllGroupUserRequest,
    ) -> live_20161101_models.CancelMuteAllGroupUserResponse:
        """
        @summary Unmutes a message group.
        
        @description ## QPS限制
        本接口的单用户QPS限制为100次/秒。超过限制，API调用会被限流，这可能会影响您的业务，请合理调用。更多信息，请参见[QPS限制](https://help.aliyun.com/document_detail/343507.html)。
        
        @param request: CancelMuteAllGroupUserRequest
        @return: CancelMuteAllGroupUserResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_mute_all_group_user_with_options(request, runtime)

    async def cancel_mute_all_group_user_async(
        self,
        request: live_20161101_models.CancelMuteAllGroupUserRequest,
    ) -> live_20161101_models.CancelMuteAllGroupUserResponse:
        """
        @summary Unmutes a message group.
        
        @description ## QPS限制
        本接口的单用户QPS限制为100次/秒。超过限制，API调用会被限流，这可能会影响您的业务，请合理调用。更多信息，请参见[QPS限制](https://help.aliyun.com/document_detail/343507.html)。
        
        @param request: CancelMuteAllGroupUserRequest
        @return: CancelMuteAllGroupUserResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_mute_all_group_user_with_options_async(request, runtime)

    def cancel_mute_group_user_with_options(
        self,
        tmp_req: live_20161101_models.CancelMuteGroupUserRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CancelMuteGroupUserResponse:
        """
        @summary Unmutes members in a message group.
        
        @description ## QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param tmp_req: CancelMuteGroupUserRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelMuteGroupUserResponse
        """
        UtilClient.validate_model(tmp_req)
        request = live_20161101_models.CancelMuteGroupUserShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.cancel_mute_user_list):
            request.cancel_mute_user_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.cancel_mute_user_list, 'CancelMuteUserList', 'simple')
        body = {}
        if not UtilClient.is_unset(request.app_id):
            body['AppId'] = request.app_id
        if not UtilClient.is_unset(request.broad_cast_type):
            body['BroadCastType'] = request.broad_cast_type
        if not UtilClient.is_unset(request.cancel_mute_user_list_shrink):
            body['CancelMuteUserList'] = request.cancel_mute_user_list_shrink
        if not UtilClient.is_unset(request.group_id):
            body['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.operator_user_id):
            body['OperatorUserId'] = request.operator_user_id
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CancelMuteGroupUser',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CancelMuteGroupUserResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_mute_group_user_with_options_async(
        self,
        tmp_req: live_20161101_models.CancelMuteGroupUserRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CancelMuteGroupUserResponse:
        """
        @summary Unmutes members in a message group.
        
        @description ## QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param tmp_req: CancelMuteGroupUserRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelMuteGroupUserResponse
        """
        UtilClient.validate_model(tmp_req)
        request = live_20161101_models.CancelMuteGroupUserShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.cancel_mute_user_list):
            request.cancel_mute_user_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.cancel_mute_user_list, 'CancelMuteUserList', 'simple')
        body = {}
        if not UtilClient.is_unset(request.app_id):
            body['AppId'] = request.app_id
        if not UtilClient.is_unset(request.broad_cast_type):
            body['BroadCastType'] = request.broad_cast_type
        if not UtilClient.is_unset(request.cancel_mute_user_list_shrink):
            body['CancelMuteUserList'] = request.cancel_mute_user_list_shrink
        if not UtilClient.is_unset(request.group_id):
            body['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.operator_user_id):
            body['OperatorUserId'] = request.operator_user_id
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CancelMuteGroupUser',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CancelMuteGroupUserResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_mute_group_user(
        self,
        request: live_20161101_models.CancelMuteGroupUserRequest,
    ) -> live_20161101_models.CancelMuteGroupUserResponse:
        """
        @summary Unmutes members in a message group.
        
        @description ## QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: CancelMuteGroupUserRequest
        @return: CancelMuteGroupUserResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_mute_group_user_with_options(request, runtime)

    async def cancel_mute_group_user_async(
        self,
        request: live_20161101_models.CancelMuteGroupUserRequest,
    ) -> live_20161101_models.CancelMuteGroupUserResponse:
        """
        @summary Unmutes members in a message group.
        
        @description ## QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: CancelMuteGroupUserRequest
        @return: CancelMuteGroupUserResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_mute_group_user_with_options_async(request, runtime)

    def change_live_domain_resource_group_with_options(
        self,
        request: live_20161101_models.ChangeLiveDomainResourceGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.ChangeLiveDomainResourceGroupResponse:
        """
        @summary Changes the resource group to which a domain name belongs. In this case, you move the domain name from the original resource group to another resource group.
        
        @description You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: ChangeLiveDomainResourceGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ChangeLiveDomainResourceGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.new_resource_group_id):
            query['NewResourceGroupId'] = request.new_resource_group_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ChangeLiveDomainResourceGroup',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.ChangeLiveDomainResourceGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def change_live_domain_resource_group_with_options_async(
        self,
        request: live_20161101_models.ChangeLiveDomainResourceGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.ChangeLiveDomainResourceGroupResponse:
        """
        @summary Changes the resource group to which a domain name belongs. In this case, you move the domain name from the original resource group to another resource group.
        
        @description You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: ChangeLiveDomainResourceGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ChangeLiveDomainResourceGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.new_resource_group_id):
            query['NewResourceGroupId'] = request.new_resource_group_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ChangeLiveDomainResourceGroup',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.ChangeLiveDomainResourceGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def change_live_domain_resource_group(
        self,
        request: live_20161101_models.ChangeLiveDomainResourceGroupRequest,
    ) -> live_20161101_models.ChangeLiveDomainResourceGroupResponse:
        """
        @summary Changes the resource group to which a domain name belongs. In this case, you move the domain name from the original resource group to another resource group.
        
        @description You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: ChangeLiveDomainResourceGroupRequest
        @return: ChangeLiveDomainResourceGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.change_live_domain_resource_group_with_options(request, runtime)

    async def change_live_domain_resource_group_async(
        self,
        request: live_20161101_models.ChangeLiveDomainResourceGroupRequest,
    ) -> live_20161101_models.ChangeLiveDomainResourceGroupResponse:
        """
        @summary Changes the resource group to which a domain name belongs. In this case, you move the domain name from the original resource group to another resource group.
        
        @description You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: ChangeLiveDomainResourceGroupRequest
        @return: ChangeLiveDomainResourceGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.change_live_domain_resource_group_with_options_async(request, runtime)

    def check_live_message_users_in_group_with_options(
        self,
        tmp_req: live_20161101_models.CheckLiveMessageUsersInGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CheckLiveMessageUsersInGroupResponse:
        """
        @summary Queries whether a user is in an interactive messaging group.
        
        @description Before you call this operation, make sure that you have called the [CreateLiveMessageGroup](https://help.aliyun.com/document_detail/2848163.html) operation to create an interactive messaging group.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param tmp_req: CheckLiveMessageUsersInGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckLiveMessageUsersInGroupResponse
        """
        UtilClient.validate_model(tmp_req)
        request = live_20161101_models.CheckLiveMessageUsersInGroupShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.user_ids):
            request.user_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.user_ids, 'UserIds', 'simple')
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.data_center):
            query['DataCenter'] = request.data_center
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.user_ids_shrink):
            query['UserIds'] = request.user_ids_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckLiveMessageUsersInGroup',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CheckLiveMessageUsersInGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def check_live_message_users_in_group_with_options_async(
        self,
        tmp_req: live_20161101_models.CheckLiveMessageUsersInGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CheckLiveMessageUsersInGroupResponse:
        """
        @summary Queries whether a user is in an interactive messaging group.
        
        @description Before you call this operation, make sure that you have called the [CreateLiveMessageGroup](https://help.aliyun.com/document_detail/2848163.html) operation to create an interactive messaging group.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param tmp_req: CheckLiveMessageUsersInGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckLiveMessageUsersInGroupResponse
        """
        UtilClient.validate_model(tmp_req)
        request = live_20161101_models.CheckLiveMessageUsersInGroupShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.user_ids):
            request.user_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.user_ids, 'UserIds', 'simple')
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.data_center):
            query['DataCenter'] = request.data_center
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.user_ids_shrink):
            query['UserIds'] = request.user_ids_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckLiveMessageUsersInGroup',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CheckLiveMessageUsersInGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def check_live_message_users_in_group(
        self,
        request: live_20161101_models.CheckLiveMessageUsersInGroupRequest,
    ) -> live_20161101_models.CheckLiveMessageUsersInGroupResponse:
        """
        @summary Queries whether a user is in an interactive messaging group.
        
        @description Before you call this operation, make sure that you have called the [CreateLiveMessageGroup](https://help.aliyun.com/document_detail/2848163.html) operation to create an interactive messaging group.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CheckLiveMessageUsersInGroupRequest
        @return: CheckLiveMessageUsersInGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.check_live_message_users_in_group_with_options(request, runtime)

    async def check_live_message_users_in_group_async(
        self,
        request: live_20161101_models.CheckLiveMessageUsersInGroupRequest,
    ) -> live_20161101_models.CheckLiveMessageUsersInGroupResponse:
        """
        @summary Queries whether a user is in an interactive messaging group.
        
        @description Before you call this operation, make sure that you have called the [CreateLiveMessageGroup](https://help.aliyun.com/document_detail/2848163.html) operation to create an interactive messaging group.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CheckLiveMessageUsersInGroupRequest
        @return: CheckLiveMessageUsersInGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.check_live_message_users_in_group_with_options_async(request, runtime)

    def check_live_message_users_online_with_options(
        self,
        tmp_req: live_20161101_models.CheckLiveMessageUsersOnlineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CheckLiveMessageUsersOnlineResponse:
        """
        @summary Queries whether one or more specified users are online.
        
        @description You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param tmp_req: CheckLiveMessageUsersOnlineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckLiveMessageUsersOnlineResponse
        """
        UtilClient.validate_model(tmp_req)
        request = live_20161101_models.CheckLiveMessageUsersOnlineShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.user_ids):
            request.user_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.user_ids, 'UserIds', 'simple')
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.data_center):
            query['DataCenter'] = request.data_center
        if not UtilClient.is_unset(request.user_ids_shrink):
            query['UserIds'] = request.user_ids_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckLiveMessageUsersOnline',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CheckLiveMessageUsersOnlineResponse(),
            self.call_api(params, req, runtime)
        )

    async def check_live_message_users_online_with_options_async(
        self,
        tmp_req: live_20161101_models.CheckLiveMessageUsersOnlineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CheckLiveMessageUsersOnlineResponse:
        """
        @summary Queries whether one or more specified users are online.
        
        @description You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param tmp_req: CheckLiveMessageUsersOnlineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckLiveMessageUsersOnlineResponse
        """
        UtilClient.validate_model(tmp_req)
        request = live_20161101_models.CheckLiveMessageUsersOnlineShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.user_ids):
            request.user_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.user_ids, 'UserIds', 'simple')
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.data_center):
            query['DataCenter'] = request.data_center
        if not UtilClient.is_unset(request.user_ids_shrink):
            query['UserIds'] = request.user_ids_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckLiveMessageUsersOnline',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CheckLiveMessageUsersOnlineResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def check_live_message_users_online(
        self,
        request: live_20161101_models.CheckLiveMessageUsersOnlineRequest,
    ) -> live_20161101_models.CheckLiveMessageUsersOnlineResponse:
        """
        @summary Queries whether one or more specified users are online.
        
        @description You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CheckLiveMessageUsersOnlineRequest
        @return: CheckLiveMessageUsersOnlineResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.check_live_message_users_online_with_options(request, runtime)

    async def check_live_message_users_online_async(
        self,
        request: live_20161101_models.CheckLiveMessageUsersOnlineRequest,
    ) -> live_20161101_models.CheckLiveMessageUsersOnlineResponse:
        """
        @summary Queries whether one or more specified users are online.
        
        @description You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CheckLiveMessageUsersOnlineRequest
        @return: CheckLiveMessageUsersOnlineResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.check_live_message_users_online_with_options_async(request, runtime)

    def close_live_shift_with_options(
        self,
        request: live_20161101_models.CloseLiveShiftRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CloseLiveShiftResponse:
        """
        @summary Disables time shifting for a domain name, or an application or a live stream under the domain name.
        
        @description Obtain the streaming domain, and then call this operation to disable time shifting for the streaming domain or an application or a live stream under the streaming domain.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CloseLiveShiftRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CloseLiveShiftResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CloseLiveShift',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CloseLiveShiftResponse(),
            self.call_api(params, req, runtime)
        )

    async def close_live_shift_with_options_async(
        self,
        request: live_20161101_models.CloseLiveShiftRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CloseLiveShiftResponse:
        """
        @summary Disables time shifting for a domain name, or an application or a live stream under the domain name.
        
        @description Obtain the streaming domain, and then call this operation to disable time shifting for the streaming domain or an application or a live stream under the streaming domain.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CloseLiveShiftRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CloseLiveShiftResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CloseLiveShift',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CloseLiveShiftResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def close_live_shift(
        self,
        request: live_20161101_models.CloseLiveShiftRequest,
    ) -> live_20161101_models.CloseLiveShiftResponse:
        """
        @summary Disables time shifting for a domain name, or an application or a live stream under the domain name.
        
        @description Obtain the streaming domain, and then call this operation to disable time shifting for the streaming domain or an application or a live stream under the streaming domain.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CloseLiveShiftRequest
        @return: CloseLiveShiftResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.close_live_shift_with_options(request, runtime)

    async def close_live_shift_async(
        self,
        request: live_20161101_models.CloseLiveShiftRequest,
    ) -> live_20161101_models.CloseLiveShiftResponse:
        """
        @summary Disables time shifting for a domain name, or an application or a live stream under the domain name.
        
        @description Obtain the streaming domain, and then call this operation to disable time shifting for the streaming domain or an application or a live stream under the streaming domain.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CloseLiveShiftRequest
        @return: CloseLiveShiftResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.close_live_shift_with_options_async(request, runtime)

    def copy_caster_with_options(
        self,
        request: live_20161101_models.CopyCasterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CopyCasterResponse:
        """
        @summary Duplicates a production studio.
        
        @description You can call this operation to duplicate a production studio. This way, a new, identical production studio is created.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CopyCasterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CopyCasterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_name):
            query['CasterName'] = request.caster_name
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.src_caster_id):
            query['SrcCasterId'] = request.src_caster_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CopyCaster',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CopyCasterResponse(),
            self.call_api(params, req, runtime)
        )

    async def copy_caster_with_options_async(
        self,
        request: live_20161101_models.CopyCasterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CopyCasterResponse:
        """
        @summary Duplicates a production studio.
        
        @description You can call this operation to duplicate a production studio. This way, a new, identical production studio is created.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CopyCasterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CopyCasterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_name):
            query['CasterName'] = request.caster_name
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.src_caster_id):
            query['SrcCasterId'] = request.src_caster_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CopyCaster',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CopyCasterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def copy_caster(
        self,
        request: live_20161101_models.CopyCasterRequest,
    ) -> live_20161101_models.CopyCasterResponse:
        """
        @summary Duplicates a production studio.
        
        @description You can call this operation to duplicate a production studio. This way, a new, identical production studio is created.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CopyCasterRequest
        @return: CopyCasterResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.copy_caster_with_options(request, runtime)

    async def copy_caster_async(
        self,
        request: live_20161101_models.CopyCasterRequest,
    ) -> live_20161101_models.CopyCasterResponse:
        """
        @summary Duplicates a production studio.
        
        @description You can call this operation to duplicate a production studio. This way, a new, identical production studio is created.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CopyCasterRequest
        @return: CopyCasterResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.copy_caster_with_options_async(request, runtime)

    def copy_caster_scene_config_with_options(
        self,
        request: live_20161101_models.CopyCasterSceneConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CopyCasterSceneConfigResponse:
        """
        @summary Applies the configuration of a PVW scene to a PGM scene.
        
        @description    Streaming fees and transcoding fees are calculated based on the corresponding output resolutions and durations. For more information, see [Billing of production studios](https://help.aliyun.com/document_detail/64531.html).
        You can call this operation to apply the configuration of a source scene to a destination scene. This operation takes effect only if the source scene is a PVW scene and the destination scene is a PGM scene. A PVW scene is a preview scene, and a PGM scene is a program scene.
        The PVW scene and PGM scene must be in the same production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CopyCasterSceneConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CopyCasterSceneConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.from_scene_id):
            query['FromSceneId'] = request.from_scene_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.to_scene_id):
            query['ToSceneId'] = request.to_scene_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CopyCasterSceneConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CopyCasterSceneConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def copy_caster_scene_config_with_options_async(
        self,
        request: live_20161101_models.CopyCasterSceneConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CopyCasterSceneConfigResponse:
        """
        @summary Applies the configuration of a PVW scene to a PGM scene.
        
        @description    Streaming fees and transcoding fees are calculated based on the corresponding output resolutions and durations. For more information, see [Billing of production studios](https://help.aliyun.com/document_detail/64531.html).
        You can call this operation to apply the configuration of a source scene to a destination scene. This operation takes effect only if the source scene is a PVW scene and the destination scene is a PGM scene. A PVW scene is a preview scene, and a PGM scene is a program scene.
        The PVW scene and PGM scene must be in the same production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CopyCasterSceneConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CopyCasterSceneConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.from_scene_id):
            query['FromSceneId'] = request.from_scene_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.to_scene_id):
            query['ToSceneId'] = request.to_scene_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CopyCasterSceneConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CopyCasterSceneConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def copy_caster_scene_config(
        self,
        request: live_20161101_models.CopyCasterSceneConfigRequest,
    ) -> live_20161101_models.CopyCasterSceneConfigResponse:
        """
        @summary Applies the configuration of a PVW scene to a PGM scene.
        
        @description    Streaming fees and transcoding fees are calculated based on the corresponding output resolutions and durations. For more information, see [Billing of production studios](https://help.aliyun.com/document_detail/64531.html).
        You can call this operation to apply the configuration of a source scene to a destination scene. This operation takes effect only if the source scene is a PVW scene and the destination scene is a PGM scene. A PVW scene is a preview scene, and a PGM scene is a program scene.
        The PVW scene and PGM scene must be in the same production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CopyCasterSceneConfigRequest
        @return: CopyCasterSceneConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.copy_caster_scene_config_with_options(request, runtime)

    async def copy_caster_scene_config_async(
        self,
        request: live_20161101_models.CopyCasterSceneConfigRequest,
    ) -> live_20161101_models.CopyCasterSceneConfigResponse:
        """
        @summary Applies the configuration of a PVW scene to a PGM scene.
        
        @description    Streaming fees and transcoding fees are calculated based on the corresponding output resolutions and durations. For more information, see [Billing of production studios](https://help.aliyun.com/document_detail/64531.html).
        You can call this operation to apply the configuration of a source scene to a destination scene. This operation takes effect only if the source scene is a PVW scene and the destination scene is a PGM scene. A PVW scene is a preview scene, and a PGM scene is a program scene.
        The PVW scene and PGM scene must be in the same production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CopyCasterSceneConfigRequest
        @return: CopyCasterSceneConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.copy_caster_scene_config_with_options_async(request, runtime)

    def create_caster_with_options(
        self,
        request: live_20161101_models.CreateCasterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateCasterResponse:
        """
        @summary Creates a production studio.
        
        @description You must enable the production studio feature before you can call this operation to create a production studio. For more information, see [Enable the production studio feature](https://help.aliyun.com/document_detail/60361.html).
        You can call this operation to create production studios in general mode or playlist mode. Production studios in playlist mode can be used for carousel playback.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateCasterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCasterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_name):
            query['CasterName'] = request.caster_name
        if not UtilClient.is_unset(request.caster_template):
            query['CasterTemplate'] = request.caster_template
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.expire_time):
            query['ExpireTime'] = request.expire_time
        if not UtilClient.is_unset(request.norm_type):
            query['NormType'] = request.norm_type
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.purchase_time):
            query['PurchaseTime'] = request.purchase_time
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCaster',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateCasterResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_caster_with_options_async(
        self,
        request: live_20161101_models.CreateCasterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateCasterResponse:
        """
        @summary Creates a production studio.
        
        @description You must enable the production studio feature before you can call this operation to create a production studio. For more information, see [Enable the production studio feature](https://help.aliyun.com/document_detail/60361.html).
        You can call this operation to create production studios in general mode or playlist mode. Production studios in playlist mode can be used for carousel playback.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateCasterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCasterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_name):
            query['CasterName'] = request.caster_name
        if not UtilClient.is_unset(request.caster_template):
            query['CasterTemplate'] = request.caster_template
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.expire_time):
            query['ExpireTime'] = request.expire_time
        if not UtilClient.is_unset(request.norm_type):
            query['NormType'] = request.norm_type
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.purchase_time):
            query['PurchaseTime'] = request.purchase_time
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCaster',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateCasterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_caster(
        self,
        request: live_20161101_models.CreateCasterRequest,
    ) -> live_20161101_models.CreateCasterResponse:
        """
        @summary Creates a production studio.
        
        @description You must enable the production studio feature before you can call this operation to create a production studio. For more information, see [Enable the production studio feature](https://help.aliyun.com/document_detail/60361.html).
        You can call this operation to create production studios in general mode or playlist mode. Production studios in playlist mode can be used for carousel playback.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateCasterRequest
        @return: CreateCasterResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_caster_with_options(request, runtime)

    async def create_caster_async(
        self,
        request: live_20161101_models.CreateCasterRequest,
    ) -> live_20161101_models.CreateCasterResponse:
        """
        @summary Creates a production studio.
        
        @description You must enable the production studio feature before you can call this operation to create a production studio. For more information, see [Enable the production studio feature](https://help.aliyun.com/document_detail/60361.html).
        You can call this operation to create production studios in general mode or playlist mode. Production studios in playlist mode can be used for carousel playback.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateCasterRequest
        @return: CreateCasterResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_caster_with_options_async(request, runtime)

    def create_custom_template_with_options(
        self,
        request: live_20161101_models.CreateCustomTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateCustomTemplateResponse:
        """
        @summary Creates a custom stream mixing template.
        
        @description After you call this operation to create a custom template, record the template name. When you call the [CreateMixStream](https://help.aliyun.com/document_detail/2848087.html) operation to create a stream mixing task, you can set the MixStreamTemplate parameter to the name of the custom template. This way, you can use the custom template for stream mixing.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateCustomTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCustomTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.custom_template):
            query['CustomTemplate'] = request.custom_template
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.template):
            query['Template'] = request.template
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCustomTemplate',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateCustomTemplateResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_custom_template_with_options_async(
        self,
        request: live_20161101_models.CreateCustomTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateCustomTemplateResponse:
        """
        @summary Creates a custom stream mixing template.
        
        @description After you call this operation to create a custom template, record the template name. When you call the [CreateMixStream](https://help.aliyun.com/document_detail/2848087.html) operation to create a stream mixing task, you can set the MixStreamTemplate parameter to the name of the custom template. This way, you can use the custom template for stream mixing.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateCustomTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCustomTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.custom_template):
            query['CustomTemplate'] = request.custom_template
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.template):
            query['Template'] = request.template
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCustomTemplate',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateCustomTemplateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_custom_template(
        self,
        request: live_20161101_models.CreateCustomTemplateRequest,
    ) -> live_20161101_models.CreateCustomTemplateResponse:
        """
        @summary Creates a custom stream mixing template.
        
        @description After you call this operation to create a custom template, record the template name. When you call the [CreateMixStream](https://help.aliyun.com/document_detail/2848087.html) operation to create a stream mixing task, you can set the MixStreamTemplate parameter to the name of the custom template. This way, you can use the custom template for stream mixing.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateCustomTemplateRequest
        @return: CreateCustomTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_custom_template_with_options(request, runtime)

    async def create_custom_template_async(
        self,
        request: live_20161101_models.CreateCustomTemplateRequest,
    ) -> live_20161101_models.CreateCustomTemplateResponse:
        """
        @summary Creates a custom stream mixing template.
        
        @description After you call this operation to create a custom template, record the template name. When you call the [CreateMixStream](https://help.aliyun.com/document_detail/2848087.html) operation to create a stream mixing task, you can set the MixStreamTemplate parameter to the name of the custom template. This way, you can use the custom template for stream mixing.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateCustomTemplateRequest
        @return: CreateCustomTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_custom_template_with_options_async(request, runtime)

    def create_edge_transcode_job_with_options(
        self,
        request: live_20161101_models.CreateEdgeTranscodeJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateEdgeTranscodeJobResponse:
        """
        @summary Creates an edge transcoding task.
        
        @description    You can call this operation to create an edge transcoding task.
        To call this operation, make sure that you have the permissions to access the edge transcoding feature.
        ## [](#qps-)QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateEdgeTranscodeJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateEdgeTranscodeJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream_input):
            query['StreamInput'] = request.stream_input
        if not UtilClient.is_unset(request.stream_output):
            query['StreamOutput'] = request.stream_output
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateEdgeTranscodeJob',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateEdgeTranscodeJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_edge_transcode_job_with_options_async(
        self,
        request: live_20161101_models.CreateEdgeTranscodeJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateEdgeTranscodeJobResponse:
        """
        @summary Creates an edge transcoding task.
        
        @description    You can call this operation to create an edge transcoding task.
        To call this operation, make sure that you have the permissions to access the edge transcoding feature.
        ## [](#qps-)QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateEdgeTranscodeJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateEdgeTranscodeJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream_input):
            query['StreamInput'] = request.stream_input
        if not UtilClient.is_unset(request.stream_output):
            query['StreamOutput'] = request.stream_output
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateEdgeTranscodeJob',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateEdgeTranscodeJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_edge_transcode_job(
        self,
        request: live_20161101_models.CreateEdgeTranscodeJobRequest,
    ) -> live_20161101_models.CreateEdgeTranscodeJobResponse:
        """
        @summary Creates an edge transcoding task.
        
        @description    You can call this operation to create an edge transcoding task.
        To call this operation, make sure that you have the permissions to access the edge transcoding feature.
        ## [](#qps-)QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateEdgeTranscodeJobRequest
        @return: CreateEdgeTranscodeJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_edge_transcode_job_with_options(request, runtime)

    async def create_edge_transcode_job_async(
        self,
        request: live_20161101_models.CreateEdgeTranscodeJobRequest,
    ) -> live_20161101_models.CreateEdgeTranscodeJobResponse:
        """
        @summary Creates an edge transcoding task.
        
        @description    You can call this operation to create an edge transcoding task.
        To call this operation, make sure that you have the permissions to access the edge transcoding feature.
        ## [](#qps-)QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateEdgeTranscodeJobRequest
        @return: CreateEdgeTranscodeJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_edge_transcode_job_with_options_async(request, runtime)

    def create_event_sub_with_options(
        self,
        request: live_20161101_models.CreateEventSubRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateEventSubResponse:
        """
        @summary Creates a callback to subscribe to channel or user events.
        
        @description You can call this operation to create a callback to subscribe to channel or user events. When you create a callback, you can configure parameters such as the callback URL and event type.
        ## [](#qps-)QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateEventSubRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateEventSubResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.callback_url):
            query['CallbackUrl'] = request.callback_url
        if not UtilClient.is_unset(request.channel_id):
            query['ChannelId'] = request.channel_id
        if not UtilClient.is_unset(request.events):
            query['Events'] = request.events
        if not UtilClient.is_unset(request.users):
            query['Users'] = request.users
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateEventSub',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateEventSubResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_event_sub_with_options_async(
        self,
        request: live_20161101_models.CreateEventSubRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateEventSubResponse:
        """
        @summary Creates a callback to subscribe to channel or user events.
        
        @description You can call this operation to create a callback to subscribe to channel or user events. When you create a callback, you can configure parameters such as the callback URL and event type.
        ## [](#qps-)QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateEventSubRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateEventSubResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.callback_url):
            query['CallbackUrl'] = request.callback_url
        if not UtilClient.is_unset(request.channel_id):
            query['ChannelId'] = request.channel_id
        if not UtilClient.is_unset(request.events):
            query['Events'] = request.events
        if not UtilClient.is_unset(request.users):
            query['Users'] = request.users
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateEventSub',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateEventSubResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_event_sub(
        self,
        request: live_20161101_models.CreateEventSubRequest,
    ) -> live_20161101_models.CreateEventSubResponse:
        """
        @summary Creates a callback to subscribe to channel or user events.
        
        @description You can call this operation to create a callback to subscribe to channel or user events. When you create a callback, you can configure parameters such as the callback URL and event type.
        ## [](#qps-)QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateEventSubRequest
        @return: CreateEventSubResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_event_sub_with_options(request, runtime)

    async def create_event_sub_async(
        self,
        request: live_20161101_models.CreateEventSubRequest,
    ) -> live_20161101_models.CreateEventSubResponse:
        """
        @summary Creates a callback to subscribe to channel or user events.
        
        @description You can call this operation to create a callback to subscribe to channel or user events. When you create a callback, you can configure parameters such as the callback URL and event type.
        ## [](#qps-)QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateEventSubRequest
        @return: CreateEventSubResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_event_sub_with_options_async(request, runtime)

    def create_live_aistudio_with_options(
        self,
        tmp_req: live_20161101_models.CreateLiveAIStudioRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateLiveAIStudioResponse:
        """
        @summary Creates a lightweight virtual studio template.
        
        @description >  The lightweight virtual studio feature is in invitational preview. You can add up to 300 virtual studio templates.
        
        @param tmp_req: CreateLiveAIStudioRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLiveAIStudioResponse
        """
        UtilClient.validate_model(tmp_req)
        request = live_20161101_models.CreateLiveAIStudioShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.matting_layout):
            request.matting_layout_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.matting_layout, 'MattingLayout', 'json')
        if not UtilClient.is_unset(tmp_req.media_layout):
            request.media_layout_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.media_layout, 'MediaLayout', 'json')
        query = {}
        if not UtilClient.is_unset(request.background_resource_id):
            query['BackgroundResourceId'] = request.background_resource_id
        if not UtilClient.is_unset(request.background_resource_url):
            query['BackgroundResourceUrl'] = request.background_resource_url
        if not UtilClient.is_unset(request.background_type):
            query['BackgroundType'] = request.background_type
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.height):
            query['Height'] = request.height
        if not UtilClient.is_unset(request.matting_layout_shrink):
            query['MattingLayout'] = request.matting_layout_shrink
        if not UtilClient.is_unset(request.matting_type):
            query['MattingType'] = request.matting_type
        if not UtilClient.is_unset(request.media_layout_shrink):
            query['MediaLayout'] = request.media_layout_shrink
        if not UtilClient.is_unset(request.media_resource_id):
            query['MediaResourceId'] = request.media_resource_id
        if not UtilClient.is_unset(request.media_resource_url):
            query['MediaResourceUrl'] = request.media_resource_url
        if not UtilClient.is_unset(request.media_type):
            query['MediaType'] = request.media_type
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.studio_name):
            query['StudioName'] = request.studio_name
        if not UtilClient.is_unset(request.width):
            query['Width'] = request.width
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLiveAIStudio',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateLiveAIStudioResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_live_aistudio_with_options_async(
        self,
        tmp_req: live_20161101_models.CreateLiveAIStudioRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateLiveAIStudioResponse:
        """
        @summary Creates a lightweight virtual studio template.
        
        @description >  The lightweight virtual studio feature is in invitational preview. You can add up to 300 virtual studio templates.
        
        @param tmp_req: CreateLiveAIStudioRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLiveAIStudioResponse
        """
        UtilClient.validate_model(tmp_req)
        request = live_20161101_models.CreateLiveAIStudioShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.matting_layout):
            request.matting_layout_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.matting_layout, 'MattingLayout', 'json')
        if not UtilClient.is_unset(tmp_req.media_layout):
            request.media_layout_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.media_layout, 'MediaLayout', 'json')
        query = {}
        if not UtilClient.is_unset(request.background_resource_id):
            query['BackgroundResourceId'] = request.background_resource_id
        if not UtilClient.is_unset(request.background_resource_url):
            query['BackgroundResourceUrl'] = request.background_resource_url
        if not UtilClient.is_unset(request.background_type):
            query['BackgroundType'] = request.background_type
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.height):
            query['Height'] = request.height
        if not UtilClient.is_unset(request.matting_layout_shrink):
            query['MattingLayout'] = request.matting_layout_shrink
        if not UtilClient.is_unset(request.matting_type):
            query['MattingType'] = request.matting_type
        if not UtilClient.is_unset(request.media_layout_shrink):
            query['MediaLayout'] = request.media_layout_shrink
        if not UtilClient.is_unset(request.media_resource_id):
            query['MediaResourceId'] = request.media_resource_id
        if not UtilClient.is_unset(request.media_resource_url):
            query['MediaResourceUrl'] = request.media_resource_url
        if not UtilClient.is_unset(request.media_type):
            query['MediaType'] = request.media_type
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.studio_name):
            query['StudioName'] = request.studio_name
        if not UtilClient.is_unset(request.width):
            query['Width'] = request.width
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLiveAIStudio',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateLiveAIStudioResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_live_aistudio(
        self,
        request: live_20161101_models.CreateLiveAIStudioRequest,
    ) -> live_20161101_models.CreateLiveAIStudioResponse:
        """
        @summary Creates a lightweight virtual studio template.
        
        @description >  The lightweight virtual studio feature is in invitational preview. You can add up to 300 virtual studio templates.
        
        @param request: CreateLiveAIStudioRequest
        @return: CreateLiveAIStudioResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_live_aistudio_with_options(request, runtime)

    async def create_live_aistudio_async(
        self,
        request: live_20161101_models.CreateLiveAIStudioRequest,
    ) -> live_20161101_models.CreateLiveAIStudioResponse:
        """
        @summary Creates a lightweight virtual studio template.
        
        @description >  The lightweight virtual studio feature is in invitational preview. You can add up to 300 virtual studio templates.
        
        @param request: CreateLiveAIStudioRequest
        @return: CreateLiveAIStudioResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_live_aistudio_with_options_async(request, runtime)

    def create_live_delay_config_with_options(
        self,
        request: live_20161101_models.CreateLiveDelayConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateLiveDelayConfigResponse:
        """
        @summary Adds a stream delay configuration.
        
        @description Stream delay is different from latency caused by streaming protocols. Stream delay is a feature that allows you to delay the playback of a live stream that is processed in the cloud.
        ## [](#qps-)QPS limit
        You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateLiveDelayConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLiveDelayConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app):
            query['App'] = request.app
        if not UtilClient.is_unset(request.delay_time):
            query['DelayTime'] = request.delay_time
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream):
            query['Stream'] = request.stream
        if not UtilClient.is_unset(request.task_trigger_mode):
            query['TaskTriggerMode'] = request.task_trigger_mode
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLiveDelayConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateLiveDelayConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_live_delay_config_with_options_async(
        self,
        request: live_20161101_models.CreateLiveDelayConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateLiveDelayConfigResponse:
        """
        @summary Adds a stream delay configuration.
        
        @description Stream delay is different from latency caused by streaming protocols. Stream delay is a feature that allows you to delay the playback of a live stream that is processed in the cloud.
        ## [](#qps-)QPS limit
        You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateLiveDelayConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLiveDelayConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app):
            query['App'] = request.app
        if not UtilClient.is_unset(request.delay_time):
            query['DelayTime'] = request.delay_time
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream):
            query['Stream'] = request.stream
        if not UtilClient.is_unset(request.task_trigger_mode):
            query['TaskTriggerMode'] = request.task_trigger_mode
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLiveDelayConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateLiveDelayConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_live_delay_config(
        self,
        request: live_20161101_models.CreateLiveDelayConfigRequest,
    ) -> live_20161101_models.CreateLiveDelayConfigResponse:
        """
        @summary Adds a stream delay configuration.
        
        @description Stream delay is different from latency caused by streaming protocols. Stream delay is a feature that allows you to delay the playback of a live stream that is processed in the cloud.
        ## [](#qps-)QPS limit
        You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateLiveDelayConfigRequest
        @return: CreateLiveDelayConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_live_delay_config_with_options(request, runtime)

    async def create_live_delay_config_async(
        self,
        request: live_20161101_models.CreateLiveDelayConfigRequest,
    ) -> live_20161101_models.CreateLiveDelayConfigResponse:
        """
        @summary Adds a stream delay configuration.
        
        @description Stream delay is different from latency caused by streaming protocols. Stream delay is a feature that allows you to delay the playback of a live stream that is processed in the cloud.
        ## [](#qps-)QPS limit
        You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateLiveDelayConfigRequest
        @return: CreateLiveDelayConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_live_delay_config_with_options_async(request, runtime)

    def create_live_message_app_with_options(
        self,
        request: live_20161101_models.CreateLiveMessageAppRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateLiveMessageAppResponse:
        """
        @summary Creates an interactive messaging application.
        
        @description    When you call other operations to manage the interactive messaging application, you must specify the same data center in which the application is created.
        You can create up to 300 interactive messaging applications in an Alibaba Cloud account.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateLiveMessageAppRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLiveMessageAppResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.audit_type):
            query['AuditType'] = request.audit_type
        if not UtilClient.is_unset(request.audit_url):
            query['AuditUrl'] = request.audit_url
        if not UtilClient.is_unset(request.data_center):
            query['DataCenter'] = request.data_center
        if not UtilClient.is_unset(request.event_callback_url):
            query['EventCallbackUrl'] = request.event_callback_url
        if not UtilClient.is_unset(request.msg_life_cycle):
            query['MsgLifeCycle'] = request.msg_life_cycle
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLiveMessageApp',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateLiveMessageAppResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_live_message_app_with_options_async(
        self,
        request: live_20161101_models.CreateLiveMessageAppRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateLiveMessageAppResponse:
        """
        @summary Creates an interactive messaging application.
        
        @description    When you call other operations to manage the interactive messaging application, you must specify the same data center in which the application is created.
        You can create up to 300 interactive messaging applications in an Alibaba Cloud account.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateLiveMessageAppRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLiveMessageAppResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.audit_type):
            query['AuditType'] = request.audit_type
        if not UtilClient.is_unset(request.audit_url):
            query['AuditUrl'] = request.audit_url
        if not UtilClient.is_unset(request.data_center):
            query['DataCenter'] = request.data_center
        if not UtilClient.is_unset(request.event_callback_url):
            query['EventCallbackUrl'] = request.event_callback_url
        if not UtilClient.is_unset(request.msg_life_cycle):
            query['MsgLifeCycle'] = request.msg_life_cycle
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLiveMessageApp',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateLiveMessageAppResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_live_message_app(
        self,
        request: live_20161101_models.CreateLiveMessageAppRequest,
    ) -> live_20161101_models.CreateLiveMessageAppResponse:
        """
        @summary Creates an interactive messaging application.
        
        @description    When you call other operations to manage the interactive messaging application, you must specify the same data center in which the application is created.
        You can create up to 300 interactive messaging applications in an Alibaba Cloud account.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateLiveMessageAppRequest
        @return: CreateLiveMessageAppResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_live_message_app_with_options(request, runtime)

    async def create_live_message_app_async(
        self,
        request: live_20161101_models.CreateLiveMessageAppRequest,
    ) -> live_20161101_models.CreateLiveMessageAppResponse:
        """
        @summary Creates an interactive messaging application.
        
        @description    When you call other operations to manage the interactive messaging application, you must specify the same data center in which the application is created.
        You can create up to 300 interactive messaging applications in an Alibaba Cloud account.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateLiveMessageAppRequest
        @return: CreateLiveMessageAppResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_live_message_app_with_options_async(request, runtime)

    def create_live_message_group_with_options(
        self,
        tmp_req: live_20161101_models.CreateLiveMessageGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateLiveMessageGroupResponse:
        """
        @summary Creates an interactive messaging group.
        
        @description    Before you call this operation, make sure that you have called the [CreateLiveMessageApp](https://help.aliyun.com/document_detail/2848162.html) operation to create an interactive messaging application.
        You can create up to 5,000 interactive messaging groups in an interactive messaging application.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param tmp_req: CreateLiveMessageGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLiveMessageGroupResponse
        """
        UtilClient.validate_model(tmp_req)
        request = live_20161101_models.CreateLiveMessageGroupShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.administrators):
            request.administrators_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.administrators, 'Administrators', 'simple')
        query = {}
        if not UtilClient.is_unset(request.administrators_shrink):
            query['Administrators'] = request.administrators_shrink
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.creator_id):
            query['CreatorId'] = request.creator_id
        if not UtilClient.is_unset(request.data_center):
            query['DataCenter'] = request.data_center
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.group_info):
            query['GroupInfo'] = request.group_info
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLiveMessageGroup',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateLiveMessageGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_live_message_group_with_options_async(
        self,
        tmp_req: live_20161101_models.CreateLiveMessageGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateLiveMessageGroupResponse:
        """
        @summary Creates an interactive messaging group.
        
        @description    Before you call this operation, make sure that you have called the [CreateLiveMessageApp](https://help.aliyun.com/document_detail/2848162.html) operation to create an interactive messaging application.
        You can create up to 5,000 interactive messaging groups in an interactive messaging application.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param tmp_req: CreateLiveMessageGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLiveMessageGroupResponse
        """
        UtilClient.validate_model(tmp_req)
        request = live_20161101_models.CreateLiveMessageGroupShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.administrators):
            request.administrators_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.administrators, 'Administrators', 'simple')
        query = {}
        if not UtilClient.is_unset(request.administrators_shrink):
            query['Administrators'] = request.administrators_shrink
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.creator_id):
            query['CreatorId'] = request.creator_id
        if not UtilClient.is_unset(request.data_center):
            query['DataCenter'] = request.data_center
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.group_info):
            query['GroupInfo'] = request.group_info
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLiveMessageGroup',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateLiveMessageGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_live_message_group(
        self,
        request: live_20161101_models.CreateLiveMessageGroupRequest,
    ) -> live_20161101_models.CreateLiveMessageGroupResponse:
        """
        @summary Creates an interactive messaging group.
        
        @description    Before you call this operation, make sure that you have called the [CreateLiveMessageApp](https://help.aliyun.com/document_detail/2848162.html) operation to create an interactive messaging application.
        You can create up to 5,000 interactive messaging groups in an interactive messaging application.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateLiveMessageGroupRequest
        @return: CreateLiveMessageGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_live_message_group_with_options(request, runtime)

    async def create_live_message_group_async(
        self,
        request: live_20161101_models.CreateLiveMessageGroupRequest,
    ) -> live_20161101_models.CreateLiveMessageGroupResponse:
        """
        @summary Creates an interactive messaging group.
        
        @description    Before you call this operation, make sure that you have called the [CreateLiveMessageApp](https://help.aliyun.com/document_detail/2848162.html) operation to create an interactive messaging application.
        You can create up to 5,000 interactive messaging groups in an interactive messaging application.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateLiveMessageGroupRequest
        @return: CreateLiveMessageGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_live_message_group_with_options_async(request, runtime)

    def create_live_private_line_with_options(
        self,
        request: live_20161101_models.CreateLivePrivateLineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateLivePrivateLineResponse:
        """
        @summary Creates a Global Accelerator (GA) instance and binds it to an acceleration circuit.
        
        @description    You can call this operation to create a GA instance and bind it to an acceleration circuit. The granularity is at the stream level. You need to specify the access points where the acceleration circuit starts and ends.
        The settings take effect only if the value of AppName and the value of StreamName are the same as the application name and stream name that are specified in the streaming URL.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateLivePrivateLineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLivePrivateLineResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acceleration_area):
            query['AccelerationArea'] = request.acceleration_area
        if not UtilClient.is_unset(request.acceleration_type):
            query['AccelerationType'] = request.acceleration_type
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.max_bandwidth):
            query['MaxBandwidth'] = request.max_bandwidth
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.reuse):
            query['Reuse'] = request.reuse
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        if not UtilClient.is_unset(request.video_center):
            query['VideoCenter'] = request.video_center
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLivePrivateLine',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateLivePrivateLineResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_live_private_line_with_options_async(
        self,
        request: live_20161101_models.CreateLivePrivateLineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateLivePrivateLineResponse:
        """
        @summary Creates a Global Accelerator (GA) instance and binds it to an acceleration circuit.
        
        @description    You can call this operation to create a GA instance and bind it to an acceleration circuit. The granularity is at the stream level. You need to specify the access points where the acceleration circuit starts and ends.
        The settings take effect only if the value of AppName and the value of StreamName are the same as the application name and stream name that are specified in the streaming URL.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateLivePrivateLineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLivePrivateLineResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acceleration_area):
            query['AccelerationArea'] = request.acceleration_area
        if not UtilClient.is_unset(request.acceleration_type):
            query['AccelerationType'] = request.acceleration_type
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.max_bandwidth):
            query['MaxBandwidth'] = request.max_bandwidth
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.reuse):
            query['Reuse'] = request.reuse
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        if not UtilClient.is_unset(request.video_center):
            query['VideoCenter'] = request.video_center
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLivePrivateLine',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateLivePrivateLineResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_live_private_line(
        self,
        request: live_20161101_models.CreateLivePrivateLineRequest,
    ) -> live_20161101_models.CreateLivePrivateLineResponse:
        """
        @summary Creates a Global Accelerator (GA) instance and binds it to an acceleration circuit.
        
        @description    You can call this operation to create a GA instance and bind it to an acceleration circuit. The granularity is at the stream level. You need to specify the access points where the acceleration circuit starts and ends.
        The settings take effect only if the value of AppName and the value of StreamName are the same as the application name and stream name that are specified in the streaming URL.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateLivePrivateLineRequest
        @return: CreateLivePrivateLineResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_live_private_line_with_options(request, runtime)

    async def create_live_private_line_async(
        self,
        request: live_20161101_models.CreateLivePrivateLineRequest,
    ) -> live_20161101_models.CreateLivePrivateLineResponse:
        """
        @summary Creates a Global Accelerator (GA) instance and binds it to an acceleration circuit.
        
        @description    You can call this operation to create a GA instance and bind it to an acceleration circuit. The granularity is at the stream level. You need to specify the access points where the acceleration circuit starts and ends.
        The settings take effect only if the value of AppName and the value of StreamName are the same as the application name and stream name that are specified in the streaming URL.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateLivePrivateLineRequest
        @return: CreateLivePrivateLineResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_live_private_line_with_options_async(request, runtime)

    def create_live_pull_to_push_with_options(
        self,
        tmp_req: live_20161101_models.CreateLivePullToPushRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateLivePullToPushResponse:
        """
        @summary Creates a pulled-stream relay task.
        
        @description >  The pulled-stream relay feature is in public preview. You can use it free of charge. After the public preview ends, fees will be charged. The specific end time will be announced.
        You can call this operation to create a pulled-stream relay task.
        The pulled source can be a live stream or video-on-demand (VOD) resources.
        After a task is created, it starts at the specified start time and ends at the specified end time. A task that ends is automatically deleted.
        Make sure that the destination URL specified in the task is not used by another task. Otherwise, conflicts occur and stream ingest fails.
        The events for pulled-stream relay callbacks include state changes of a pulled-stream relay task and exit of a pulled-stream relay task. For more information, see [Pulled-stream relay callbacks](https://help.aliyun.com/document_detail/2846768.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param tmp_req: CreateLivePullToPushRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLivePullToPushResponse
        """
        UtilClient.validate_model(tmp_req)
        request = live_20161101_models.CreateLivePullToPushShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.source_urls):
            request.source_urls_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.source_urls, 'SourceUrls', 'json')
        query = {}
        if not UtilClient.is_unset(request.callback_url):
            query['CallbackUrl'] = request.callback_url
        if not UtilClient.is_unset(request.dst_url):
            query['DstUrl'] = request.dst_url
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.file_index):
            query['FileIndex'] = request.file_index
        if not UtilClient.is_unset(request.offset):
            query['Offset'] = request.offset
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.repeat_number):
            query['RepeatNumber'] = request.repeat_number
        if not UtilClient.is_unset(request.retry_count):
            query['RetryCount'] = request.retry_count
        if not UtilClient.is_unset(request.retry_interval):
            query['RetryInterval'] = request.retry_interval
        if not UtilClient.is_unset(request.source_protocol):
            query['SourceProtocol'] = request.source_protocol
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        if not UtilClient.is_unset(request.source_urls_shrink):
            query['SourceUrls'] = request.source_urls_shrink
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.task_name):
            query['TaskName'] = request.task_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLivePullToPush',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateLivePullToPushResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_live_pull_to_push_with_options_async(
        self,
        tmp_req: live_20161101_models.CreateLivePullToPushRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateLivePullToPushResponse:
        """
        @summary Creates a pulled-stream relay task.
        
        @description >  The pulled-stream relay feature is in public preview. You can use it free of charge. After the public preview ends, fees will be charged. The specific end time will be announced.
        You can call this operation to create a pulled-stream relay task.
        The pulled source can be a live stream or video-on-demand (VOD) resources.
        After a task is created, it starts at the specified start time and ends at the specified end time. A task that ends is automatically deleted.
        Make sure that the destination URL specified in the task is not used by another task. Otherwise, conflicts occur and stream ingest fails.
        The events for pulled-stream relay callbacks include state changes of a pulled-stream relay task and exit of a pulled-stream relay task. For more information, see [Pulled-stream relay callbacks](https://help.aliyun.com/document_detail/2846768.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param tmp_req: CreateLivePullToPushRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLivePullToPushResponse
        """
        UtilClient.validate_model(tmp_req)
        request = live_20161101_models.CreateLivePullToPushShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.source_urls):
            request.source_urls_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.source_urls, 'SourceUrls', 'json')
        query = {}
        if not UtilClient.is_unset(request.callback_url):
            query['CallbackUrl'] = request.callback_url
        if not UtilClient.is_unset(request.dst_url):
            query['DstUrl'] = request.dst_url
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.file_index):
            query['FileIndex'] = request.file_index
        if not UtilClient.is_unset(request.offset):
            query['Offset'] = request.offset
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.repeat_number):
            query['RepeatNumber'] = request.repeat_number
        if not UtilClient.is_unset(request.retry_count):
            query['RetryCount'] = request.retry_count
        if not UtilClient.is_unset(request.retry_interval):
            query['RetryInterval'] = request.retry_interval
        if not UtilClient.is_unset(request.source_protocol):
            query['SourceProtocol'] = request.source_protocol
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        if not UtilClient.is_unset(request.source_urls_shrink):
            query['SourceUrls'] = request.source_urls_shrink
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.task_name):
            query['TaskName'] = request.task_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLivePullToPush',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateLivePullToPushResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_live_pull_to_push(
        self,
        request: live_20161101_models.CreateLivePullToPushRequest,
    ) -> live_20161101_models.CreateLivePullToPushResponse:
        """
        @summary Creates a pulled-stream relay task.
        
        @description >  The pulled-stream relay feature is in public preview. You can use it free of charge. After the public preview ends, fees will be charged. The specific end time will be announced.
        You can call this operation to create a pulled-stream relay task.
        The pulled source can be a live stream or video-on-demand (VOD) resources.
        After a task is created, it starts at the specified start time and ends at the specified end time. A task that ends is automatically deleted.
        Make sure that the destination URL specified in the task is not used by another task. Otherwise, conflicts occur and stream ingest fails.
        The events for pulled-stream relay callbacks include state changes of a pulled-stream relay task and exit of a pulled-stream relay task. For more information, see [Pulled-stream relay callbacks](https://help.aliyun.com/document_detail/2846768.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateLivePullToPushRequest
        @return: CreateLivePullToPushResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_live_pull_to_push_with_options(request, runtime)

    async def create_live_pull_to_push_async(
        self,
        request: live_20161101_models.CreateLivePullToPushRequest,
    ) -> live_20161101_models.CreateLivePullToPushResponse:
        """
        @summary Creates a pulled-stream relay task.
        
        @description >  The pulled-stream relay feature is in public preview. You can use it free of charge. After the public preview ends, fees will be charged. The specific end time will be announced.
        You can call this operation to create a pulled-stream relay task.
        The pulled source can be a live stream or video-on-demand (VOD) resources.
        After a task is created, it starts at the specified start time and ends at the specified end time. A task that ends is automatically deleted.
        Make sure that the destination URL specified in the task is not used by another task. Otherwise, conflicts occur and stream ingest fails.
        The events for pulled-stream relay callbacks include state changes of a pulled-stream relay task and exit of a pulled-stream relay task. For more information, see [Pulled-stream relay callbacks](https://help.aliyun.com/document_detail/2846768.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateLivePullToPushRequest
        @return: CreateLivePullToPushResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_live_pull_to_push_with_options_async(request, runtime)

    def create_live_real_time_log_delivery_with_options(
        self,
        request: live_20161101_models.CreateLiveRealTimeLogDeliveryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateLiveRealTimeLogDeliveryResponse:
        """
        @summary Configures real-time log delivery for a domain name.
        
        @description ##
        Obtain the streaming domain, and then call this operation to configure real-time log delivery for the streaming domain.
        This operation is applicable to only streaming domains. If you want to configure real-time log delivery for an ingest domain, [submit a ticket](https://workorder-intl.console.aliyun.com/?spm=5176.12818093.nav-right.dticket.6cb216d07otFWR#/ticket/createIndex).
        ## QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: CreateLiveRealTimeLogDeliveryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLiveRealTimeLogDeliveryResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLiveRealTimeLogDelivery',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateLiveRealTimeLogDeliveryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_live_real_time_log_delivery_with_options_async(
        self,
        request: live_20161101_models.CreateLiveRealTimeLogDeliveryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateLiveRealTimeLogDeliveryResponse:
        """
        @summary Configures real-time log delivery for a domain name.
        
        @description ##
        Obtain the streaming domain, and then call this operation to configure real-time log delivery for the streaming domain.
        This operation is applicable to only streaming domains. If you want to configure real-time log delivery for an ingest domain, [submit a ticket](https://workorder-intl.console.aliyun.com/?spm=5176.12818093.nav-right.dticket.6cb216d07otFWR#/ticket/createIndex).
        ## QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: CreateLiveRealTimeLogDeliveryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLiveRealTimeLogDeliveryResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLiveRealTimeLogDelivery',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateLiveRealTimeLogDeliveryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_live_real_time_log_delivery(
        self,
        request: live_20161101_models.CreateLiveRealTimeLogDeliveryRequest,
    ) -> live_20161101_models.CreateLiveRealTimeLogDeliveryResponse:
        """
        @summary Configures real-time log delivery for a domain name.
        
        @description ##
        Obtain the streaming domain, and then call this operation to configure real-time log delivery for the streaming domain.
        This operation is applicable to only streaming domains. If you want to configure real-time log delivery for an ingest domain, [submit a ticket](https://workorder-intl.console.aliyun.com/?spm=5176.12818093.nav-right.dticket.6cb216d07otFWR#/ticket/createIndex).
        ## QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: CreateLiveRealTimeLogDeliveryRequest
        @return: CreateLiveRealTimeLogDeliveryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_live_real_time_log_delivery_with_options(request, runtime)

    async def create_live_real_time_log_delivery_async(
        self,
        request: live_20161101_models.CreateLiveRealTimeLogDeliveryRequest,
    ) -> live_20161101_models.CreateLiveRealTimeLogDeliveryResponse:
        """
        @summary Configures real-time log delivery for a domain name.
        
        @description ##
        Obtain the streaming domain, and then call this operation to configure real-time log delivery for the streaming domain.
        This operation is applicable to only streaming domains. If you want to configure real-time log delivery for an ingest domain, [submit a ticket](https://workorder-intl.console.aliyun.com/?spm=5176.12818093.nav-right.dticket.6cb216d07otFWR#/ticket/createIndex).
        ## QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: CreateLiveRealTimeLogDeliveryRequest
        @return: CreateLiveRealTimeLogDeliveryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_live_real_time_log_delivery_with_options_async(request, runtime)

    def create_live_stream_monitor_with_options(
        self,
        request: live_20161101_models.CreateLiveStreamMonitorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateLiveStreamMonitorResponse:
        """
        @summary Creates a monitoring session.
        
        @description You can call this operation to create a monitoring session. Make sure that the parameter settings meet the requirements.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateLiveStreamMonitorRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLiveStreamMonitorResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app):
            query['App'] = request.app
        if not UtilClient.is_unset(request.callback_url):
            query['CallbackUrl'] = request.callback_url
        if not UtilClient.is_unset(request.ding_talk_web_hook_url):
            query['DingTalkWebHookUrl'] = request.ding_talk_web_hook_url
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.input_list):
            query['InputList'] = request.input_list
        if not UtilClient.is_unset(request.monitor_config):
            query['MonitorConfig'] = request.monitor_config
        if not UtilClient.is_unset(request.monitor_name):
            query['MonitorName'] = request.monitor_name
        if not UtilClient.is_unset(request.output_template):
            query['OutputTemplate'] = request.output_template
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream):
            query['Stream'] = request.stream
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLiveStreamMonitor',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateLiveStreamMonitorResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_live_stream_monitor_with_options_async(
        self,
        request: live_20161101_models.CreateLiveStreamMonitorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateLiveStreamMonitorResponse:
        """
        @summary Creates a monitoring session.
        
        @description You can call this operation to create a monitoring session. Make sure that the parameter settings meet the requirements.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateLiveStreamMonitorRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLiveStreamMonitorResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app):
            query['App'] = request.app
        if not UtilClient.is_unset(request.callback_url):
            query['CallbackUrl'] = request.callback_url
        if not UtilClient.is_unset(request.ding_talk_web_hook_url):
            query['DingTalkWebHookUrl'] = request.ding_talk_web_hook_url
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.input_list):
            query['InputList'] = request.input_list
        if not UtilClient.is_unset(request.monitor_config):
            query['MonitorConfig'] = request.monitor_config
        if not UtilClient.is_unset(request.monitor_name):
            query['MonitorName'] = request.monitor_name
        if not UtilClient.is_unset(request.output_template):
            query['OutputTemplate'] = request.output_template
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream):
            query['Stream'] = request.stream
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLiveStreamMonitor',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateLiveStreamMonitorResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_live_stream_monitor(
        self,
        request: live_20161101_models.CreateLiveStreamMonitorRequest,
    ) -> live_20161101_models.CreateLiveStreamMonitorResponse:
        """
        @summary Creates a monitoring session.
        
        @description You can call this operation to create a monitoring session. Make sure that the parameter settings meet the requirements.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateLiveStreamMonitorRequest
        @return: CreateLiveStreamMonitorResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_live_stream_monitor_with_options(request, runtime)

    async def create_live_stream_monitor_async(
        self,
        request: live_20161101_models.CreateLiveStreamMonitorRequest,
    ) -> live_20161101_models.CreateLiveStreamMonitorResponse:
        """
        @summary Creates a monitoring session.
        
        @description You can call this operation to create a monitoring session. Make sure that the parameter settings meet the requirements.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateLiveStreamMonitorRequest
        @return: CreateLiveStreamMonitorResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_live_stream_monitor_with_options_async(request, runtime)

    def create_live_stream_record_index_files_with_options(
        self,
        request: live_20161101_models.CreateLiveStreamRecordIndexFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateLiveStreamRecordIndexFilesResponse:
        """
        @summary Creates an M3U8 index file for a recording in a specified time period.
        
        @description You must have configured Object Storage Service (OSS) before you call this operation. For more information, see [Configure OSS](https://help.aliyun.com/document_detail/84932.html). ApsaraVideo Live allows you to record a live stream in the M3U8 format and store the M3U8 file in OSS. You can edit the TS segments that are included in the stored M3U8 file in real time.
        >
        You can create an index file only after a live stream is ingested. If no live stream is available within the specified time range or the name of the specified live stream is invalid, the index file fails to be created.
        The time range that is specified by the StartTime and EndTime parameters must be the duration of at least one TS segment. The default duration of a TS segment is 30 seconds.
        ApsaraVideo Live stores the information about TS segments for only three months. You can create M3U8 index files only for the recordings of the last three months.
        OSS stores TS segments for a time period that is specified by the storage configuration in OSS. For more information, see [Configure lifecycle rules](https://help.aliyun.com/document_detail/31904.html).
        ApsaraVideo Live stores the information about M3U8 index files for six months. You can query the information about only the M3U8 index files that were created in the last six months.
        OSS stores M3U8 index files for a time period that is specified by the storage configuration in OSS.
        ## [](#qps-)QPS limit
        You can call this operation up to 45 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateLiveStreamRecordIndexFilesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLiveStreamRecordIndexFilesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.end_time_included):
            query['EndTimeIncluded'] = request.end_time_included
        if not UtilClient.is_unset(request.oss_bucket):
            query['OssBucket'] = request.oss_bucket
        if not UtilClient.is_unset(request.oss_endpoint):
            query['OssEndpoint'] = request.oss_endpoint
        if not UtilClient.is_unset(request.oss_object):
            query['OssObject'] = request.oss_object
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLiveStreamRecordIndexFiles',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateLiveStreamRecordIndexFilesResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_live_stream_record_index_files_with_options_async(
        self,
        request: live_20161101_models.CreateLiveStreamRecordIndexFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateLiveStreamRecordIndexFilesResponse:
        """
        @summary Creates an M3U8 index file for a recording in a specified time period.
        
        @description You must have configured Object Storage Service (OSS) before you call this operation. For more information, see [Configure OSS](https://help.aliyun.com/document_detail/84932.html). ApsaraVideo Live allows you to record a live stream in the M3U8 format and store the M3U8 file in OSS. You can edit the TS segments that are included in the stored M3U8 file in real time.
        >
        You can create an index file only after a live stream is ingested. If no live stream is available within the specified time range or the name of the specified live stream is invalid, the index file fails to be created.
        The time range that is specified by the StartTime and EndTime parameters must be the duration of at least one TS segment. The default duration of a TS segment is 30 seconds.
        ApsaraVideo Live stores the information about TS segments for only three months. You can create M3U8 index files only for the recordings of the last three months.
        OSS stores TS segments for a time period that is specified by the storage configuration in OSS. For more information, see [Configure lifecycle rules](https://help.aliyun.com/document_detail/31904.html).
        ApsaraVideo Live stores the information about M3U8 index files for six months. You can query the information about only the M3U8 index files that were created in the last six months.
        OSS stores M3U8 index files for a time period that is specified by the storage configuration in OSS.
        ## [](#qps-)QPS limit
        You can call this operation up to 45 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateLiveStreamRecordIndexFilesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLiveStreamRecordIndexFilesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.end_time_included):
            query['EndTimeIncluded'] = request.end_time_included
        if not UtilClient.is_unset(request.oss_bucket):
            query['OssBucket'] = request.oss_bucket
        if not UtilClient.is_unset(request.oss_endpoint):
            query['OssEndpoint'] = request.oss_endpoint
        if not UtilClient.is_unset(request.oss_object):
            query['OssObject'] = request.oss_object
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLiveStreamRecordIndexFiles',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateLiveStreamRecordIndexFilesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_live_stream_record_index_files(
        self,
        request: live_20161101_models.CreateLiveStreamRecordIndexFilesRequest,
    ) -> live_20161101_models.CreateLiveStreamRecordIndexFilesResponse:
        """
        @summary Creates an M3U8 index file for a recording in a specified time period.
        
        @description You must have configured Object Storage Service (OSS) before you call this operation. For more information, see [Configure OSS](https://help.aliyun.com/document_detail/84932.html). ApsaraVideo Live allows you to record a live stream in the M3U8 format and store the M3U8 file in OSS. You can edit the TS segments that are included in the stored M3U8 file in real time.
        >
        You can create an index file only after a live stream is ingested. If no live stream is available within the specified time range or the name of the specified live stream is invalid, the index file fails to be created.
        The time range that is specified by the StartTime and EndTime parameters must be the duration of at least one TS segment. The default duration of a TS segment is 30 seconds.
        ApsaraVideo Live stores the information about TS segments for only three months. You can create M3U8 index files only for the recordings of the last three months.
        OSS stores TS segments for a time period that is specified by the storage configuration in OSS. For more information, see [Configure lifecycle rules](https://help.aliyun.com/document_detail/31904.html).
        ApsaraVideo Live stores the information about M3U8 index files for six months. You can query the information about only the M3U8 index files that were created in the last six months.
        OSS stores M3U8 index files for a time period that is specified by the storage configuration in OSS.
        ## [](#qps-)QPS limit
        You can call this operation up to 45 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateLiveStreamRecordIndexFilesRequest
        @return: CreateLiveStreamRecordIndexFilesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_live_stream_record_index_files_with_options(request, runtime)

    async def create_live_stream_record_index_files_async(
        self,
        request: live_20161101_models.CreateLiveStreamRecordIndexFilesRequest,
    ) -> live_20161101_models.CreateLiveStreamRecordIndexFilesResponse:
        """
        @summary Creates an M3U8 index file for a recording in a specified time period.
        
        @description You must have configured Object Storage Service (OSS) before you call this operation. For more information, see [Configure OSS](https://help.aliyun.com/document_detail/84932.html). ApsaraVideo Live allows you to record a live stream in the M3U8 format and store the M3U8 file in OSS. You can edit the TS segments that are included in the stored M3U8 file in real time.
        >
        You can create an index file only after a live stream is ingested. If no live stream is available within the specified time range or the name of the specified live stream is invalid, the index file fails to be created.
        The time range that is specified by the StartTime and EndTime parameters must be the duration of at least one TS segment. The default duration of a TS segment is 30 seconds.
        ApsaraVideo Live stores the information about TS segments for only three months. You can create M3U8 index files only for the recordings of the last three months.
        OSS stores TS segments for a time period that is specified by the storage configuration in OSS. For more information, see [Configure lifecycle rules](https://help.aliyun.com/document_detail/31904.html).
        ApsaraVideo Live stores the information about M3U8 index files for six months. You can query the information about only the M3U8 index files that were created in the last six months.
        OSS stores M3U8 index files for a time period that is specified by the storage configuration in OSS.
        ## [](#qps-)QPS limit
        You can call this operation up to 45 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateLiveStreamRecordIndexFilesRequest
        @return: CreateLiveStreamRecordIndexFilesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_live_stream_record_index_files_with_options_async(request, runtime)

    def create_message_app_with_options(
        self,
        tmp_req: live_20161101_models.CreateMessageAppRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateMessageAppResponse:
        """
        @summary Creates an interactive messaging application.
        
        @description ## QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param tmp_req: CreateMessageAppRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateMessageAppResponse
        """
        UtilClient.validate_model(tmp_req)
        request = live_20161101_models.CreateMessageAppShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.app_config):
            request.app_config_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.app_config, 'AppConfig', 'json')
        if not UtilClient.is_unset(tmp_req.extension):
            request.extension_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.extension, 'Extension', 'json')
        body = {}
        if not UtilClient.is_unset(request.app_config_shrink):
            body['AppConfig'] = request.app_config_shrink
        if not UtilClient.is_unset(request.app_name):
            body['AppName'] = request.app_name
        if not UtilClient.is_unset(request.extension_shrink):
            body['Extension'] = request.extension_shrink
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateMessageApp',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateMessageAppResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_message_app_with_options_async(
        self,
        tmp_req: live_20161101_models.CreateMessageAppRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateMessageAppResponse:
        """
        @summary Creates an interactive messaging application.
        
        @description ## QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param tmp_req: CreateMessageAppRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateMessageAppResponse
        """
        UtilClient.validate_model(tmp_req)
        request = live_20161101_models.CreateMessageAppShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.app_config):
            request.app_config_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.app_config, 'AppConfig', 'json')
        if not UtilClient.is_unset(tmp_req.extension):
            request.extension_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.extension, 'Extension', 'json')
        body = {}
        if not UtilClient.is_unset(request.app_config_shrink):
            body['AppConfig'] = request.app_config_shrink
        if not UtilClient.is_unset(request.app_name):
            body['AppName'] = request.app_name
        if not UtilClient.is_unset(request.extension_shrink):
            body['Extension'] = request.extension_shrink
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateMessageApp',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateMessageAppResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_message_app(
        self,
        request: live_20161101_models.CreateMessageAppRequest,
    ) -> live_20161101_models.CreateMessageAppResponse:
        """
        @summary Creates an interactive messaging application.
        
        @description ## QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: CreateMessageAppRequest
        @return: CreateMessageAppResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_message_app_with_options(request, runtime)

    async def create_message_app_async(
        self,
        request: live_20161101_models.CreateMessageAppRequest,
    ) -> live_20161101_models.CreateMessageAppResponse:
        """
        @summary Creates an interactive messaging application.
        
        @description ## QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: CreateMessageAppRequest
        @return: CreateMessageAppResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_message_app_with_options_async(request, runtime)

    def create_message_group_with_options(
        self,
        tmp_req: live_20161101_models.CreateMessageGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateMessageGroupResponse:
        """
        @summary Creates a message group.
        
        @description ## QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param tmp_req: CreateMessageGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateMessageGroupResponse
        """
        UtilClient.validate_model(tmp_req)
        request = live_20161101_models.CreateMessageGroupShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.extension):
            request.extension_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.extension, 'Extension', 'json')
        body = {}
        if not UtilClient.is_unset(request.app_id):
            body['AppId'] = request.app_id
        if not UtilClient.is_unset(request.creator_id):
            body['CreatorId'] = request.creator_id
        if not UtilClient.is_unset(request.extension_shrink):
            body['Extension'] = request.extension_shrink
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateMessageGroup',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateMessageGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_message_group_with_options_async(
        self,
        tmp_req: live_20161101_models.CreateMessageGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateMessageGroupResponse:
        """
        @summary Creates a message group.
        
        @description ## QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param tmp_req: CreateMessageGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateMessageGroupResponse
        """
        UtilClient.validate_model(tmp_req)
        request = live_20161101_models.CreateMessageGroupShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.extension):
            request.extension_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.extension, 'Extension', 'json')
        body = {}
        if not UtilClient.is_unset(request.app_id):
            body['AppId'] = request.app_id
        if not UtilClient.is_unset(request.creator_id):
            body['CreatorId'] = request.creator_id
        if not UtilClient.is_unset(request.extension_shrink):
            body['Extension'] = request.extension_shrink
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateMessageGroup',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateMessageGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_message_group(
        self,
        request: live_20161101_models.CreateMessageGroupRequest,
    ) -> live_20161101_models.CreateMessageGroupResponse:
        """
        @summary Creates a message group.
        
        @description ## QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: CreateMessageGroupRequest
        @return: CreateMessageGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_message_group_with_options(request, runtime)

    async def create_message_group_async(
        self,
        request: live_20161101_models.CreateMessageGroupRequest,
    ) -> live_20161101_models.CreateMessageGroupResponse:
        """
        @summary Creates a message group.
        
        @description ## QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: CreateMessageGroupRequest
        @return: CreateMessageGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_message_group_with_options_async(request, runtime)

    def create_mix_stream_with_options(
        self,
        request: live_20161101_models.CreateMixStreamRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateMixStreamResponse:
        """
        @summary Creates a stream mixing task.
        
        @description You can call this operation to create a stream mixing task. This operation supports preset layouts and custom layouts.
        If you have any questions or suggestions about the use of the stream mixing feature, you are welcome to search the group ID 34935990 in DingTalk to join the developer group.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateMixStreamRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateMixStreamResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.callback_config):
            query['CallbackConfig'] = request.callback_config
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.input_stream_list):
            query['InputStreamList'] = request.input_stream_list
        if not UtilClient.is_unset(request.layout_id):
            query['LayoutId'] = request.layout_id
        if not UtilClient.is_unset(request.output_config):
            query['OutputConfig'] = request.output_config
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateMixStream',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateMixStreamResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_mix_stream_with_options_async(
        self,
        request: live_20161101_models.CreateMixStreamRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateMixStreamResponse:
        """
        @summary Creates a stream mixing task.
        
        @description You can call this operation to create a stream mixing task. This operation supports preset layouts and custom layouts.
        If you have any questions or suggestions about the use of the stream mixing feature, you are welcome to search the group ID 34935990 in DingTalk to join the developer group.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateMixStreamRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateMixStreamResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.callback_config):
            query['CallbackConfig'] = request.callback_config
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.input_stream_list):
            query['InputStreamList'] = request.input_stream_list
        if not UtilClient.is_unset(request.layout_id):
            query['LayoutId'] = request.layout_id
        if not UtilClient.is_unset(request.output_config):
            query['OutputConfig'] = request.output_config
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateMixStream',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateMixStreamResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_mix_stream(
        self,
        request: live_20161101_models.CreateMixStreamRequest,
    ) -> live_20161101_models.CreateMixStreamResponse:
        """
        @summary Creates a stream mixing task.
        
        @description You can call this operation to create a stream mixing task. This operation supports preset layouts and custom layouts.
        If you have any questions or suggestions about the use of the stream mixing feature, you are welcome to search the group ID 34935990 in DingTalk to join the developer group.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateMixStreamRequest
        @return: CreateMixStreamResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_mix_stream_with_options(request, runtime)

    async def create_mix_stream_async(
        self,
        request: live_20161101_models.CreateMixStreamRequest,
    ) -> live_20161101_models.CreateMixStreamResponse:
        """
        @summary Creates a stream mixing task.
        
        @description You can call this operation to create a stream mixing task. This operation supports preset layouts and custom layouts.
        If you have any questions or suggestions about the use of the stream mixing feature, you are welcome to search the group ID 34935990 in DingTalk to join the developer group.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateMixStreamRequest
        @return: CreateMixStreamResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_mix_stream_with_options_async(request, runtime)

    def create_rtcwhip_stream_address_with_options(
        self,
        request: live_20161101_models.CreateRTCWhipStreamAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateRTCWhipStreamAddressResponse:
        """
        @summary 创建房间whip协议推流地址
        
        @param request: CreateRTCWhipStreamAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRTCWhipStreamAddressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.channel_id):
            query['ChannelId'] = request.channel_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.display_name):
            query['DisplayName'] = request.display_name
        if not UtilClient.is_unset(request.expire_time):
            query['ExpireTime'] = request.expire_time
        if not UtilClient.is_unset(request.user_id):
            query['UserId'] = request.user_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRTCWhipStreamAddress',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateRTCWhipStreamAddressResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_rtcwhip_stream_address_with_options_async(
        self,
        request: live_20161101_models.CreateRTCWhipStreamAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateRTCWhipStreamAddressResponse:
        """
        @summary 创建房间whip协议推流地址
        
        @param request: CreateRTCWhipStreamAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRTCWhipStreamAddressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.channel_id):
            query['ChannelId'] = request.channel_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.display_name):
            query['DisplayName'] = request.display_name
        if not UtilClient.is_unset(request.expire_time):
            query['ExpireTime'] = request.expire_time
        if not UtilClient.is_unset(request.user_id):
            query['UserId'] = request.user_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRTCWhipStreamAddress',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateRTCWhipStreamAddressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_rtcwhip_stream_address(
        self,
        request: live_20161101_models.CreateRTCWhipStreamAddressRequest,
    ) -> live_20161101_models.CreateRTCWhipStreamAddressResponse:
        """
        @summary 创建房间whip协议推流地址
        
        @param request: CreateRTCWhipStreamAddressRequest
        @return: CreateRTCWhipStreamAddressResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_rtcwhip_stream_address_with_options(request, runtime)

    async def create_rtcwhip_stream_address_async(
        self,
        request: live_20161101_models.CreateRTCWhipStreamAddressRequest,
    ) -> live_20161101_models.CreateRTCWhipStreamAddressResponse:
        """
        @summary 创建房间whip协议推流地址
        
        @param request: CreateRTCWhipStreamAddressRequest
        @return: CreateRTCWhipStreamAddressResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_rtcwhip_stream_address_with_options_async(request, runtime)

    def create_room_real_time_stream_address_with_options(
        self,
        request: live_20161101_models.CreateRoomRealTimeStreamAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateRoomRealTimeStreamAddressResponse:
        """
        @summary Creates a Real-Time Messaging Protocol (RTMP) ingest URL for a channel.
        
        @description ### [](#)Usage notes
        To use the interactive streaming feature, you must use ApsaraVideo Real-time Communication (ARTC) SDK to join a channel and ingest streams over Real-Time Communication (RTC). In specific scenarios, you can ingest streams over Real-Time Messaging Protocol (RTMP) by using tools such as Open Broadcaster Software (OBS). Then, ApsaraVideo Live automatically converts the RTMP streams to RTC streams and distributes the RTC streams to viewers. You can call this operation to generate an ingest URL in the RTMP format. After you ingest RTMP streams, ApsaraVideo Live automatically converts the streams to RTC streams. Do not call this operation if you require only regular live streaming. To quickly ingest RTMP streams and start live streaming, see [Get started with ApsaraVideo Live](https://help.aliyun.com/document_detail/198676.html).
        ## [](#)Procedure
        1.  Call this operation to generate an ingest URL in the RTMP format.
        2.  Ingest a stream by using the ingest URL. Other users in the channel can watch the stream.
        3.  Stop ingesting the stream. Other users in the channel see that the user who ingested the stream leaves the channel.
        >
        You can repeat Steps 2 and 3 within the validity period of the ingest URL.
        We recommend that you call the [DescribeChannelParticipants](https://help.aliyun.com/document_detail/610801.html) operation to query online users in the channel at regular intervals. This way, you can check whether the user who ingests the stream is still in the channel. If the user who ingests the stream is not in the channel, the stream may be interrupted. In this case, we recommend that you stop ingesting the stream and perform Step 2.
        ## [](#qps-)QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: CreateRoomRealTimeStreamAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRoomRealTimeStreamAddressResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRoomRealTimeStreamAddress',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateRoomRealTimeStreamAddressResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_room_real_time_stream_address_with_options_async(
        self,
        request: live_20161101_models.CreateRoomRealTimeStreamAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateRoomRealTimeStreamAddressResponse:
        """
        @summary Creates a Real-Time Messaging Protocol (RTMP) ingest URL for a channel.
        
        @description ### [](#)Usage notes
        To use the interactive streaming feature, you must use ApsaraVideo Real-time Communication (ARTC) SDK to join a channel and ingest streams over Real-Time Communication (RTC). In specific scenarios, you can ingest streams over Real-Time Messaging Protocol (RTMP) by using tools such as Open Broadcaster Software (OBS). Then, ApsaraVideo Live automatically converts the RTMP streams to RTC streams and distributes the RTC streams to viewers. You can call this operation to generate an ingest URL in the RTMP format. After you ingest RTMP streams, ApsaraVideo Live automatically converts the streams to RTC streams. Do not call this operation if you require only regular live streaming. To quickly ingest RTMP streams and start live streaming, see [Get started with ApsaraVideo Live](https://help.aliyun.com/document_detail/198676.html).
        ## [](#)Procedure
        1.  Call this operation to generate an ingest URL in the RTMP format.
        2.  Ingest a stream by using the ingest URL. Other users in the channel can watch the stream.
        3.  Stop ingesting the stream. Other users in the channel see that the user who ingested the stream leaves the channel.
        >
        You can repeat Steps 2 and 3 within the validity period of the ingest URL.
        We recommend that you call the [DescribeChannelParticipants](https://help.aliyun.com/document_detail/610801.html) operation to query online users in the channel at regular intervals. This way, you can check whether the user who ingests the stream is still in the channel. If the user who ingests the stream is not in the channel, the stream may be interrupted. In this case, we recommend that you stop ingesting the stream and perform Step 2.
        ## [](#qps-)QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: CreateRoomRealTimeStreamAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRoomRealTimeStreamAddressResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRoomRealTimeStreamAddress',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateRoomRealTimeStreamAddressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_room_real_time_stream_address(
        self,
        request: live_20161101_models.CreateRoomRealTimeStreamAddressRequest,
    ) -> live_20161101_models.CreateRoomRealTimeStreamAddressResponse:
        """
        @summary Creates a Real-Time Messaging Protocol (RTMP) ingest URL for a channel.
        
        @description ### [](#)Usage notes
        To use the interactive streaming feature, you must use ApsaraVideo Real-time Communication (ARTC) SDK to join a channel and ingest streams over Real-Time Communication (RTC). In specific scenarios, you can ingest streams over Real-Time Messaging Protocol (RTMP) by using tools such as Open Broadcaster Software (OBS). Then, ApsaraVideo Live automatically converts the RTMP streams to RTC streams and distributes the RTC streams to viewers. You can call this operation to generate an ingest URL in the RTMP format. After you ingest RTMP streams, ApsaraVideo Live automatically converts the streams to RTC streams. Do not call this operation if you require only regular live streaming. To quickly ingest RTMP streams and start live streaming, see [Get started with ApsaraVideo Live](https://help.aliyun.com/document_detail/198676.html).
        ## [](#)Procedure
        1.  Call this operation to generate an ingest URL in the RTMP format.
        2.  Ingest a stream by using the ingest URL. Other users in the channel can watch the stream.
        3.  Stop ingesting the stream. Other users in the channel see that the user who ingested the stream leaves the channel.
        >
        You can repeat Steps 2 and 3 within the validity period of the ingest URL.
        We recommend that you call the [DescribeChannelParticipants](https://help.aliyun.com/document_detail/610801.html) operation to query online users in the channel at regular intervals. This way, you can check whether the user who ingests the stream is still in the channel. If the user who ingests the stream is not in the channel, the stream may be interrupted. In this case, we recommend that you stop ingesting the stream and perform Step 2.
        ## [](#qps-)QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: CreateRoomRealTimeStreamAddressRequest
        @return: CreateRoomRealTimeStreamAddressResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_room_real_time_stream_address_with_options(request, runtime)

    async def create_room_real_time_stream_address_async(
        self,
        request: live_20161101_models.CreateRoomRealTimeStreamAddressRequest,
    ) -> live_20161101_models.CreateRoomRealTimeStreamAddressResponse:
        """
        @summary Creates a Real-Time Messaging Protocol (RTMP) ingest URL for a channel.
        
        @description ### [](#)Usage notes
        To use the interactive streaming feature, you must use ApsaraVideo Real-time Communication (ARTC) SDK to join a channel and ingest streams over Real-Time Communication (RTC). In specific scenarios, you can ingest streams over Real-Time Messaging Protocol (RTMP) by using tools such as Open Broadcaster Software (OBS). Then, ApsaraVideo Live automatically converts the RTMP streams to RTC streams and distributes the RTC streams to viewers. You can call this operation to generate an ingest URL in the RTMP format. After you ingest RTMP streams, ApsaraVideo Live automatically converts the streams to RTC streams. Do not call this operation if you require only regular live streaming. To quickly ingest RTMP streams and start live streaming, see [Get started with ApsaraVideo Live](https://help.aliyun.com/document_detail/198676.html).
        ## [](#)Procedure
        1.  Call this operation to generate an ingest URL in the RTMP format.
        2.  Ingest a stream by using the ingest URL. Other users in the channel can watch the stream.
        3.  Stop ingesting the stream. Other users in the channel see that the user who ingested the stream leaves the channel.
        >
        You can repeat Steps 2 and 3 within the validity period of the ingest URL.
        We recommend that you call the [DescribeChannelParticipants](https://help.aliyun.com/document_detail/610801.html) operation to query online users in the channel at regular intervals. This way, you can check whether the user who ingests the stream is still in the channel. If the user who ingests the stream is not in the channel, the stream may be interrupted. In this case, we recommend that you stop ingesting the stream and perform Step 2.
        ## [](#qps-)QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: CreateRoomRealTimeStreamAddressRequest
        @return: CreateRoomRealTimeStreamAddressResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_room_real_time_stream_address_with_options_async(request, runtime)

    def create_rtc_asr_task_with_options(
        self,
        request: live_20161101_models.CreateRtcAsrTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateRtcAsrTaskResponse:
        """
        @summary Creates a live subtitle task to transcribe an audio stream to text in real time.
        
        @description You can call this operation to create a live subtitle task that transcribes audio in a live stream to text in real time.
        ## [](#qps-)QPS limit
        You can call this operation up to 20 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateRtcAsrTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRtcAsrTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auth_key):
            query['AuthKey'] = request.auth_key
        if not UtilClient.is_unset(request.auto_terminate_delay):
            query['AutoTerminateDelay'] = request.auto_terminate_delay
        if not UtilClient.is_unset(request.auto_terminate_enabled):
            query['AutoTerminateEnabled'] = request.auto_terminate_enabled
        if not UtilClient.is_unset(request.callback_url):
            query['CallbackURL'] = request.callback_url
        if not UtilClient.is_unset(request.channel_id):
            query['ChannelID'] = request.channel_id
        if not UtilClient.is_unset(request.language):
            query['Language'] = request.language
        if not UtilClient.is_unset(request.mode):
            query['Mode'] = request.mode
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.report_interval):
            query['ReportInterval'] = request.report_interval
        if not UtilClient.is_unset(request.rtc_user_id):
            query['RtcUserId'] = request.rtc_user_id
        if not UtilClient.is_unset(request.sdkapp_id):
            query['SDKAppID'] = request.sdkapp_id
        if not UtilClient.is_unset(request.stream_url):
            query['StreamURL'] = request.stream_url
        if not UtilClient.is_unset(request.target_languages):
            query['TargetLanguages'] = request.target_languages
        if not UtilClient.is_unset(request.translate_enabled):
            query['TranslateEnabled'] = request.translate_enabled
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRtcAsrTask',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateRtcAsrTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_rtc_asr_task_with_options_async(
        self,
        request: live_20161101_models.CreateRtcAsrTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateRtcAsrTaskResponse:
        """
        @summary Creates a live subtitle task to transcribe an audio stream to text in real time.
        
        @description You can call this operation to create a live subtitle task that transcribes audio in a live stream to text in real time.
        ## [](#qps-)QPS limit
        You can call this operation up to 20 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateRtcAsrTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRtcAsrTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auth_key):
            query['AuthKey'] = request.auth_key
        if not UtilClient.is_unset(request.auto_terminate_delay):
            query['AutoTerminateDelay'] = request.auto_terminate_delay
        if not UtilClient.is_unset(request.auto_terminate_enabled):
            query['AutoTerminateEnabled'] = request.auto_terminate_enabled
        if not UtilClient.is_unset(request.callback_url):
            query['CallbackURL'] = request.callback_url
        if not UtilClient.is_unset(request.channel_id):
            query['ChannelID'] = request.channel_id
        if not UtilClient.is_unset(request.language):
            query['Language'] = request.language
        if not UtilClient.is_unset(request.mode):
            query['Mode'] = request.mode
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.report_interval):
            query['ReportInterval'] = request.report_interval
        if not UtilClient.is_unset(request.rtc_user_id):
            query['RtcUserId'] = request.rtc_user_id
        if not UtilClient.is_unset(request.sdkapp_id):
            query['SDKAppID'] = request.sdkapp_id
        if not UtilClient.is_unset(request.stream_url):
            query['StreamURL'] = request.stream_url
        if not UtilClient.is_unset(request.target_languages):
            query['TargetLanguages'] = request.target_languages
        if not UtilClient.is_unset(request.translate_enabled):
            query['TranslateEnabled'] = request.translate_enabled
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRtcAsrTask',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateRtcAsrTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_rtc_asr_task(
        self,
        request: live_20161101_models.CreateRtcAsrTaskRequest,
    ) -> live_20161101_models.CreateRtcAsrTaskResponse:
        """
        @summary Creates a live subtitle task to transcribe an audio stream to text in real time.
        
        @description You can call this operation to create a live subtitle task that transcribes audio in a live stream to text in real time.
        ## [](#qps-)QPS limit
        You can call this operation up to 20 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateRtcAsrTaskRequest
        @return: CreateRtcAsrTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_rtc_asr_task_with_options(request, runtime)

    async def create_rtc_asr_task_async(
        self,
        request: live_20161101_models.CreateRtcAsrTaskRequest,
    ) -> live_20161101_models.CreateRtcAsrTaskResponse:
        """
        @summary Creates a live subtitle task to transcribe an audio stream to text in real time.
        
        @description You can call this operation to create a live subtitle task that transcribes audio in a live stream to text in real time.
        ## [](#qps-)QPS limit
        You can call this operation up to 20 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateRtcAsrTaskRequest
        @return: CreateRtcAsrTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_rtc_asr_task_with_options_async(request, runtime)

    def create_rtc_mpuevent_sub_with_options(
        self,
        request: live_20161101_models.CreateRtcMPUEventSubRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateRtcMPUEventSubResponse:
        """
        @summary Creates a subscription to mixed-stream relay events.
        
        @description You can call this operation to create a subscription to mixed-stream relay events. You can configure parameters such as the callback URL, application to which you want to subscribe, and channel information when you create a subscription.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateRtcMPUEventSubRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRtcMPUEventSubResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.callback_url):
            query['CallbackUrl'] = request.callback_url
        if not UtilClient.is_unset(request.channel_ids):
            query['ChannelIds'] = request.channel_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRtcMPUEventSub',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateRtcMPUEventSubResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_rtc_mpuevent_sub_with_options_async(
        self,
        request: live_20161101_models.CreateRtcMPUEventSubRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.CreateRtcMPUEventSubResponse:
        """
        @summary Creates a subscription to mixed-stream relay events.
        
        @description You can call this operation to create a subscription to mixed-stream relay events. You can configure parameters such as the callback URL, application to which you want to subscribe, and channel information when you create a subscription.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateRtcMPUEventSubRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRtcMPUEventSubResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.callback_url):
            query['CallbackUrl'] = request.callback_url
        if not UtilClient.is_unset(request.channel_ids):
            query['ChannelIds'] = request.channel_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRtcMPUEventSub',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.CreateRtcMPUEventSubResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_rtc_mpuevent_sub(
        self,
        request: live_20161101_models.CreateRtcMPUEventSubRequest,
    ) -> live_20161101_models.CreateRtcMPUEventSubResponse:
        """
        @summary Creates a subscription to mixed-stream relay events.
        
        @description You can call this operation to create a subscription to mixed-stream relay events. You can configure parameters such as the callback URL, application to which you want to subscribe, and channel information when you create a subscription.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateRtcMPUEventSubRequest
        @return: CreateRtcMPUEventSubResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_rtc_mpuevent_sub_with_options(request, runtime)

    async def create_rtc_mpuevent_sub_async(
        self,
        request: live_20161101_models.CreateRtcMPUEventSubRequest,
    ) -> live_20161101_models.CreateRtcMPUEventSubResponse:
        """
        @summary Creates a subscription to mixed-stream relay events.
        
        @description You can call this operation to create a subscription to mixed-stream relay events. You can configure parameters such as the callback URL, application to which you want to subscribe, and channel information when you create a subscription.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateRtcMPUEventSubRequest
        @return: CreateRtcMPUEventSubResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_rtc_mpuevent_sub_with_options_async(request, runtime)

    def delete_caster_with_options(
        self,
        request: live_20161101_models.DeleteCasterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteCasterResponse:
        """
        @summary Deletes a production studio.
        
        @description    You can delete only production studios that are closed.
        When a production studio is deleted, the scenes, components, and layouts of the production studio are also deleted.
        You cannot recover a deleted production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteCasterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCasterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCaster',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteCasterResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_caster_with_options_async(
        self,
        request: live_20161101_models.DeleteCasterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteCasterResponse:
        """
        @summary Deletes a production studio.
        
        @description    You can delete only production studios that are closed.
        When a production studio is deleted, the scenes, components, and layouts of the production studio are also deleted.
        You cannot recover a deleted production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteCasterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCasterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCaster',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteCasterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_caster(
        self,
        request: live_20161101_models.DeleteCasterRequest,
    ) -> live_20161101_models.DeleteCasterResponse:
        """
        @summary Deletes a production studio.
        
        @description    You can delete only production studios that are closed.
        When a production studio is deleted, the scenes, components, and layouts of the production studio are also deleted.
        You cannot recover a deleted production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteCasterRequest
        @return: DeleteCasterResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_caster_with_options(request, runtime)

    async def delete_caster_async(
        self,
        request: live_20161101_models.DeleteCasterRequest,
    ) -> live_20161101_models.DeleteCasterResponse:
        """
        @summary Deletes a production studio.
        
        @description    You can delete only production studios that are closed.
        When a production studio is deleted, the scenes, components, and layouts of the production studio are also deleted.
        You cannot recover a deleted production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteCasterRequest
        @return: DeleteCasterResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_caster_with_options_async(request, runtime)

    def delete_caster_component_with_options(
        self,
        request: live_20161101_models.DeleteCasterComponentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteCasterComponentResponse:
        """
        @summary Deletes a component in a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation to create a production studio and then call this operation to delete a component in the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteCasterComponentRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCasterComponentResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.component_id):
            query['ComponentId'] = request.component_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCasterComponent',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteCasterComponentResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_caster_component_with_options_async(
        self,
        request: live_20161101_models.DeleteCasterComponentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteCasterComponentResponse:
        """
        @summary Deletes a component in a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation to create a production studio and then call this operation to delete a component in the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteCasterComponentRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCasterComponentResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.component_id):
            query['ComponentId'] = request.component_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCasterComponent',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteCasterComponentResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_caster_component(
        self,
        request: live_20161101_models.DeleteCasterComponentRequest,
    ) -> live_20161101_models.DeleteCasterComponentResponse:
        """
        @summary Deletes a component in a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation to create a production studio and then call this operation to delete a component in the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteCasterComponentRequest
        @return: DeleteCasterComponentResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_caster_component_with_options(request, runtime)

    async def delete_caster_component_async(
        self,
        request: live_20161101_models.DeleteCasterComponentRequest,
    ) -> live_20161101_models.DeleteCasterComponentResponse:
        """
        @summary Deletes a component in a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation to create a production studio and then call this operation to delete a component in the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteCasterComponentRequest
        @return: DeleteCasterComponentResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_caster_component_with_options_async(request, runtime)

    def delete_caster_episode_with_options(
        self,
        request: live_20161101_models.DeleteCasterEpisodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteCasterEpisodeResponse:
        """
        @summary Deletes an episode in a production studio.
        
        @description Before you call this operation to delete an episode in a production studio, you must obtain the ID of the production studio and the ID of the episode.
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteCasterEpisodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCasterEpisodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.episode_id):
            query['EpisodeId'] = request.episode_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCasterEpisode',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteCasterEpisodeResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_caster_episode_with_options_async(
        self,
        request: live_20161101_models.DeleteCasterEpisodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteCasterEpisodeResponse:
        """
        @summary Deletes an episode in a production studio.
        
        @description Before you call this operation to delete an episode in a production studio, you must obtain the ID of the production studio and the ID of the episode.
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteCasterEpisodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCasterEpisodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.episode_id):
            query['EpisodeId'] = request.episode_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCasterEpisode',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteCasterEpisodeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_caster_episode(
        self,
        request: live_20161101_models.DeleteCasterEpisodeRequest,
    ) -> live_20161101_models.DeleteCasterEpisodeResponse:
        """
        @summary Deletes an episode in a production studio.
        
        @description Before you call this operation to delete an episode in a production studio, you must obtain the ID of the production studio and the ID of the episode.
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteCasterEpisodeRequest
        @return: DeleteCasterEpisodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_caster_episode_with_options(request, runtime)

    async def delete_caster_episode_async(
        self,
        request: live_20161101_models.DeleteCasterEpisodeRequest,
    ) -> live_20161101_models.DeleteCasterEpisodeResponse:
        """
        @summary Deletes an episode in a production studio.
        
        @description Before you call this operation to delete an episode in a production studio, you must obtain the ID of the production studio and the ID of the episode.
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteCasterEpisodeRequest
        @return: DeleteCasterEpisodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_caster_episode_with_options_async(request, runtime)

    def delete_caster_episode_group_with_options(
        self,
        request: live_20161101_models.DeleteCasterEpisodeGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteCasterEpisodeGroupResponse:
        """
        @summary Deletes an episode list in a production studio.
        
        @description Before you call this operation to delete an episode list in a production studio, make sure that you have called the [AddCasterEpisodeGroup](https://help.aliyun.com/document_detail/2848071.html) operation to add the episode list in the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteCasterEpisodeGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCasterEpisodeGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.program_id):
            query['ProgramId'] = request.program_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCasterEpisodeGroup',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteCasterEpisodeGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_caster_episode_group_with_options_async(
        self,
        request: live_20161101_models.DeleteCasterEpisodeGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteCasterEpisodeGroupResponse:
        """
        @summary Deletes an episode list in a production studio.
        
        @description Before you call this operation to delete an episode list in a production studio, make sure that you have called the [AddCasterEpisodeGroup](https://help.aliyun.com/document_detail/2848071.html) operation to add the episode list in the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteCasterEpisodeGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCasterEpisodeGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.program_id):
            query['ProgramId'] = request.program_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCasterEpisodeGroup',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteCasterEpisodeGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_caster_episode_group(
        self,
        request: live_20161101_models.DeleteCasterEpisodeGroupRequest,
    ) -> live_20161101_models.DeleteCasterEpisodeGroupResponse:
        """
        @summary Deletes an episode list in a production studio.
        
        @description Before you call this operation to delete an episode list in a production studio, make sure that you have called the [AddCasterEpisodeGroup](https://help.aliyun.com/document_detail/2848071.html) operation to add the episode list in the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteCasterEpisodeGroupRequest
        @return: DeleteCasterEpisodeGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_caster_episode_group_with_options(request, runtime)

    async def delete_caster_episode_group_async(
        self,
        request: live_20161101_models.DeleteCasterEpisodeGroupRequest,
    ) -> live_20161101_models.DeleteCasterEpisodeGroupResponse:
        """
        @summary Deletes an episode list in a production studio.
        
        @description Before you call this operation to delete an episode list in a production studio, make sure that you have called the [AddCasterEpisodeGroup](https://help.aliyun.com/document_detail/2848071.html) operation to add the episode list in the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteCasterEpisodeGroupRequest
        @return: DeleteCasterEpisodeGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_caster_episode_group_with_options_async(request, runtime)

    def delete_caster_layout_with_options(
        self,
        request: live_20161101_models.DeleteCasterLayoutRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteCasterLayoutResponse:
        """
        @summary Deletes a layout in a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/69338.html) operation to create a production studio and then call this operation to delete a layout in the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteCasterLayoutRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCasterLayoutResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.layout_id):
            query['LayoutId'] = request.layout_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCasterLayout',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteCasterLayoutResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_caster_layout_with_options_async(
        self,
        request: live_20161101_models.DeleteCasterLayoutRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteCasterLayoutResponse:
        """
        @summary Deletes a layout in a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/69338.html) operation to create a production studio and then call this operation to delete a layout in the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteCasterLayoutRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCasterLayoutResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.layout_id):
            query['LayoutId'] = request.layout_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCasterLayout',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteCasterLayoutResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_caster_layout(
        self,
        request: live_20161101_models.DeleteCasterLayoutRequest,
    ) -> live_20161101_models.DeleteCasterLayoutResponse:
        """
        @summary Deletes a layout in a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/69338.html) operation to create a production studio and then call this operation to delete a layout in the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteCasterLayoutRequest
        @return: DeleteCasterLayoutResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_caster_layout_with_options(request, runtime)

    async def delete_caster_layout_async(
        self,
        request: live_20161101_models.DeleteCasterLayoutRequest,
    ) -> live_20161101_models.DeleteCasterLayoutResponse:
        """
        @summary Deletes a layout in a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/69338.html) operation to create a production studio and then call this operation to delete a layout in the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteCasterLayoutRequest
        @return: DeleteCasterLayoutResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_caster_layout_with_options_async(request, runtime)

    def delete_caster_program_with_options(
        self,
        request: live_20161101_models.DeleteCasterProgramRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteCasterProgramResponse:
        """
        @summary Deletes the episode list for carousel playback in a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation to create a production studio and then call this operation to delete the episode list for carousel playback in the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteCasterProgramRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCasterProgramResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCasterProgram',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteCasterProgramResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_caster_program_with_options_async(
        self,
        request: live_20161101_models.DeleteCasterProgramRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteCasterProgramResponse:
        """
        @summary Deletes the episode list for carousel playback in a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation to create a production studio and then call this operation to delete the episode list for carousel playback in the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteCasterProgramRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCasterProgramResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCasterProgram',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteCasterProgramResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_caster_program(
        self,
        request: live_20161101_models.DeleteCasterProgramRequest,
    ) -> live_20161101_models.DeleteCasterProgramResponse:
        """
        @summary Deletes the episode list for carousel playback in a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation to create a production studio and then call this operation to delete the episode list for carousel playback in the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteCasterProgramRequest
        @return: DeleteCasterProgramResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_caster_program_with_options(request, runtime)

    async def delete_caster_program_async(
        self,
        request: live_20161101_models.DeleteCasterProgramRequest,
    ) -> live_20161101_models.DeleteCasterProgramResponse:
        """
        @summary Deletes the episode list for carousel playback in a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation to create a production studio and then call this operation to delete the episode list for carousel playback in the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteCasterProgramRequest
        @return: DeleteCasterProgramResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_caster_program_with_options_async(request, runtime)

    def delete_caster_scene_config_with_options(
        self,
        request: live_20161101_models.DeleteCasterSceneConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteCasterSceneConfigResponse:
        """
        @summary Deletes the settings of a scene.
        
        @description You can call this operation to delete the settings of a scene, such as the component setting, layout setting, or both of them.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteCasterSceneConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCasterSceneConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.scene_id):
            query['SceneId'] = request.scene_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCasterSceneConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteCasterSceneConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_caster_scene_config_with_options_async(
        self,
        request: live_20161101_models.DeleteCasterSceneConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteCasterSceneConfigResponse:
        """
        @summary Deletes the settings of a scene.
        
        @description You can call this operation to delete the settings of a scene, such as the component setting, layout setting, or both of them.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteCasterSceneConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCasterSceneConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.scene_id):
            query['SceneId'] = request.scene_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCasterSceneConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteCasterSceneConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_caster_scene_config(
        self,
        request: live_20161101_models.DeleteCasterSceneConfigRequest,
    ) -> live_20161101_models.DeleteCasterSceneConfigResponse:
        """
        @summary Deletes the settings of a scene.
        
        @description You can call this operation to delete the settings of a scene, such as the component setting, layout setting, or both of them.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteCasterSceneConfigRequest
        @return: DeleteCasterSceneConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_caster_scene_config_with_options(request, runtime)

    async def delete_caster_scene_config_async(
        self,
        request: live_20161101_models.DeleteCasterSceneConfigRequest,
    ) -> live_20161101_models.DeleteCasterSceneConfigResponse:
        """
        @summary Deletes the settings of a scene.
        
        @description You can call this operation to delete the settings of a scene, such as the component setting, layout setting, or both of them.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteCasterSceneConfigRequest
        @return: DeleteCasterSceneConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_caster_scene_config_with_options_async(request, runtime)

    def delete_caster_video_resource_with_options(
        self,
        request: live_20161101_models.DeleteCasterVideoResourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteCasterVideoResourceResponse:
        """
        @summary Removes an input source from a production studio.
        
        @description Before you call this operation to remove an input source from a production studio, make sure that you have called the [CreateCaster](https://help.aliyun.com/document_detail/69338.html) operation to create the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteCasterVideoResourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCasterVideoResourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCasterVideoResource',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteCasterVideoResourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_caster_video_resource_with_options_async(
        self,
        request: live_20161101_models.DeleteCasterVideoResourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteCasterVideoResourceResponse:
        """
        @summary Removes an input source from a production studio.
        
        @description Before you call this operation to remove an input source from a production studio, make sure that you have called the [CreateCaster](https://help.aliyun.com/document_detail/69338.html) operation to create the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteCasterVideoResourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCasterVideoResourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCasterVideoResource',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteCasterVideoResourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_caster_video_resource(
        self,
        request: live_20161101_models.DeleteCasterVideoResourceRequest,
    ) -> live_20161101_models.DeleteCasterVideoResourceResponse:
        """
        @summary Removes an input source from a production studio.
        
        @description Before you call this operation to remove an input source from a production studio, make sure that you have called the [CreateCaster](https://help.aliyun.com/document_detail/69338.html) operation to create the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteCasterVideoResourceRequest
        @return: DeleteCasterVideoResourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_caster_video_resource_with_options(request, runtime)

    async def delete_caster_video_resource_async(
        self,
        request: live_20161101_models.DeleteCasterVideoResourceRequest,
    ) -> live_20161101_models.DeleteCasterVideoResourceResponse:
        """
        @summary Removes an input source from a production studio.
        
        @description Before you call this operation to remove an input source from a production studio, make sure that you have called the [CreateCaster](https://help.aliyun.com/document_detail/69338.html) operation to create the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteCasterVideoResourceRequest
        @return: DeleteCasterVideoResourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_caster_video_resource_with_options_async(request, runtime)

    def delete_channel_with_options(
        self,
        request: live_20161101_models.DeleteChannelRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteChannelResponse:
        """
        @summary Deletes a channel.
        
        @description ## [](#qps-)QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteChannelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteChannelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.channel_id):
            query['ChannelId'] = request.channel_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteChannel',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteChannelResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_channel_with_options_async(
        self,
        request: live_20161101_models.DeleteChannelRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteChannelResponse:
        """
        @summary Deletes a channel.
        
        @description ## [](#qps-)QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteChannelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteChannelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.channel_id):
            query['ChannelId'] = request.channel_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteChannel',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteChannelResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_channel(
        self,
        request: live_20161101_models.DeleteChannelRequest,
    ) -> live_20161101_models.DeleteChannelResponse:
        """
        @summary Deletes a channel.
        
        @description ## [](#qps-)QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteChannelRequest
        @return: DeleteChannelResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_channel_with_options(request, runtime)

    async def delete_channel_async(
        self,
        request: live_20161101_models.DeleteChannelRequest,
    ) -> live_20161101_models.DeleteChannelResponse:
        """
        @summary Deletes a channel.
        
        @description ## [](#qps-)QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteChannelRequest
        @return: DeleteChannelResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_channel_with_options_async(request, runtime)

    def delete_custom_template_with_options(
        self,
        request: live_20161101_models.DeleteCustomTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteCustomTemplateResponse:
        """
        @summary Deletes a custom stream mixing template.
        
        @description Obtain the name of the custom stream mixing template that you want to delete, and then call this operation to delete the template.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteCustomTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCustomTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.template):
            query['Template'] = request.template
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCustomTemplate',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteCustomTemplateResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_custom_template_with_options_async(
        self,
        request: live_20161101_models.DeleteCustomTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteCustomTemplateResponse:
        """
        @summary Deletes a custom stream mixing template.
        
        @description Obtain the name of the custom stream mixing template that you want to delete, and then call this operation to delete the template.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteCustomTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCustomTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.template):
            query['Template'] = request.template
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCustomTemplate',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteCustomTemplateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_custom_template(
        self,
        request: live_20161101_models.DeleteCustomTemplateRequest,
    ) -> live_20161101_models.DeleteCustomTemplateResponse:
        """
        @summary Deletes a custom stream mixing template.
        
        @description Obtain the name of the custom stream mixing template that you want to delete, and then call this operation to delete the template.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteCustomTemplateRequest
        @return: DeleteCustomTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_custom_template_with_options(request, runtime)

    async def delete_custom_template_async(
        self,
        request: live_20161101_models.DeleteCustomTemplateRequest,
    ) -> live_20161101_models.DeleteCustomTemplateResponse:
        """
        @summary Deletes a custom stream mixing template.
        
        @description Obtain the name of the custom stream mixing template that you want to delete, and then call this operation to delete the template.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteCustomTemplateRequest
        @return: DeleteCustomTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_custom_template_with_options_async(request, runtime)

    def delete_edge_transcode_job_with_options(
        self,
        request: live_20161101_models.DeleteEdgeTranscodeJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteEdgeTranscodeJobResponse:
        """
        @summary Deletes an edge transcoding task.
        
        @description    You can call this operation to delete an edge transcoding task.
        To call this operation, make sure that you have the permissions to access the edge transcoding feature.
        ## [](#qps-)QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteEdgeTranscodeJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteEdgeTranscodeJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteEdgeTranscodeJob',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteEdgeTranscodeJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_edge_transcode_job_with_options_async(
        self,
        request: live_20161101_models.DeleteEdgeTranscodeJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteEdgeTranscodeJobResponse:
        """
        @summary Deletes an edge transcoding task.
        
        @description    You can call this operation to delete an edge transcoding task.
        To call this operation, make sure that you have the permissions to access the edge transcoding feature.
        ## [](#qps-)QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteEdgeTranscodeJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteEdgeTranscodeJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteEdgeTranscodeJob',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteEdgeTranscodeJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_edge_transcode_job(
        self,
        request: live_20161101_models.DeleteEdgeTranscodeJobRequest,
    ) -> live_20161101_models.DeleteEdgeTranscodeJobResponse:
        """
        @summary Deletes an edge transcoding task.
        
        @description    You can call this operation to delete an edge transcoding task.
        To call this operation, make sure that you have the permissions to access the edge transcoding feature.
        ## [](#qps-)QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteEdgeTranscodeJobRequest
        @return: DeleteEdgeTranscodeJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_edge_transcode_job_with_options(request, runtime)

    async def delete_edge_transcode_job_async(
        self,
        request: live_20161101_models.DeleteEdgeTranscodeJobRequest,
    ) -> live_20161101_models.DeleteEdgeTranscodeJobResponse:
        """
        @summary Deletes an edge transcoding task.
        
        @description    You can call this operation to delete an edge transcoding task.
        To call this operation, make sure that you have the permissions to access the edge transcoding feature.
        ## [](#qps-)QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteEdgeTranscodeJobRequest
        @return: DeleteEdgeTranscodeJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_edge_transcode_job_with_options_async(request, runtime)

    def delete_event_sub_with_options(
        self,
        request: live_20161101_models.DeleteEventSubRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteEventSubResponse:
        """
        @summary Deletes a callback that is used to subscribe to channel or user events.
        
        @description Before you call this operation, make sure that you have called the [CreateEventSubscribe](https://help.aliyun.com/document_detail/2848209.html) operation to create a callback that is used to subscribe to channel or user events.
        ## [](#qps-)QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteEventSubRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteEventSubResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.subscribe_id):
            query['SubscribeId'] = request.subscribe_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteEventSub',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteEventSubResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_event_sub_with_options_async(
        self,
        request: live_20161101_models.DeleteEventSubRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteEventSubResponse:
        """
        @summary Deletes a callback that is used to subscribe to channel or user events.
        
        @description Before you call this operation, make sure that you have called the [CreateEventSubscribe](https://help.aliyun.com/document_detail/2848209.html) operation to create a callback that is used to subscribe to channel or user events.
        ## [](#qps-)QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteEventSubRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteEventSubResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.subscribe_id):
            query['SubscribeId'] = request.subscribe_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteEventSub',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteEventSubResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_event_sub(
        self,
        request: live_20161101_models.DeleteEventSubRequest,
    ) -> live_20161101_models.DeleteEventSubResponse:
        """
        @summary Deletes a callback that is used to subscribe to channel or user events.
        
        @description Before you call this operation, make sure that you have called the [CreateEventSubscribe](https://help.aliyun.com/document_detail/2848209.html) operation to create a callback that is used to subscribe to channel or user events.
        ## [](#qps-)QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteEventSubRequest
        @return: DeleteEventSubResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_event_sub_with_options(request, runtime)

    async def delete_event_sub_async(
        self,
        request: live_20161101_models.DeleteEventSubRequest,
    ) -> live_20161101_models.DeleteEventSubResponse:
        """
        @summary Deletes a callback that is used to subscribe to channel or user events.
        
        @description Before you call this operation, make sure that you have called the [CreateEventSubscribe](https://help.aliyun.com/document_detail/2848209.html) operation to create a callback that is used to subscribe to channel or user events.
        ## [](#qps-)QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteEventSubRequest
        @return: DeleteEventSubResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_event_sub_with_options_async(request, runtime)

    def delete_live_aiproduce_rules_with_options(
        self,
        request: live_20161101_models.DeleteLiveAIProduceRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveAIProduceRulesResponse:
        """
        @summary Deletes a subtitle rule.
        
        @description You can call this operation to delete a specified subtitle rule.
        >  The live subtitles feature is in invitational preview. You can add up to 300 subtitle templates.
        ## [](#qps-)QPS limit
        You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveAIProduceRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveAIProduceRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app):
            query['App'] = request.app
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.rules_id):
            query['RulesId'] = request.rules_id
        if not UtilClient.is_unset(request.suffix_name):
            query['SuffixName'] = request.suffix_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveAIProduceRules',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveAIProduceRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_aiproduce_rules_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveAIProduceRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveAIProduceRulesResponse:
        """
        @summary Deletes a subtitle rule.
        
        @description You can call this operation to delete a specified subtitle rule.
        >  The live subtitles feature is in invitational preview. You can add up to 300 subtitle templates.
        ## [](#qps-)QPS limit
        You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveAIProduceRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveAIProduceRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app):
            query['App'] = request.app
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.rules_id):
            query['RulesId'] = request.rules_id
        if not UtilClient.is_unset(request.suffix_name):
            query['SuffixName'] = request.suffix_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveAIProduceRules',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveAIProduceRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_aiproduce_rules(
        self,
        request: live_20161101_models.DeleteLiveAIProduceRulesRequest,
    ) -> live_20161101_models.DeleteLiveAIProduceRulesResponse:
        """
        @summary Deletes a subtitle rule.
        
        @description You can call this operation to delete a specified subtitle rule.
        >  The live subtitles feature is in invitational preview. You can add up to 300 subtitle templates.
        ## [](#qps-)QPS limit
        You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveAIProduceRulesRequest
        @return: DeleteLiveAIProduceRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_aiproduce_rules_with_options(request, runtime)

    async def delete_live_aiproduce_rules_async(
        self,
        request: live_20161101_models.DeleteLiveAIProduceRulesRequest,
    ) -> live_20161101_models.DeleteLiveAIProduceRulesResponse:
        """
        @summary Deletes a subtitle rule.
        
        @description You can call this operation to delete a specified subtitle rule.
        >  The live subtitles feature is in invitational preview. You can add up to 300 subtitle templates.
        ## [](#qps-)QPS limit
        You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveAIProduceRulesRequest
        @return: DeleteLiveAIProduceRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_aiproduce_rules_with_options_async(request, runtime)

    def delete_live_aistudio_with_options(
        self,
        request: live_20161101_models.DeleteLiveAIStudioRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveAIStudioResponse:
        """
        @summary Deletes a virtual studio template.
        
        @description To delete a virtual studio template, you must first unbind the rules. Otherwise, an error occurs.
        >  The lightweight virtual studio feature is in invitational preview. You can add up to 300 virtual studio templates.
        
        @param request: DeleteLiveAIStudioRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveAIStudioResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.studio_id):
            query['StudioId'] = request.studio_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveAIStudio',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveAIStudioResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_aistudio_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveAIStudioRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveAIStudioResponse:
        """
        @summary Deletes a virtual studio template.
        
        @description To delete a virtual studio template, you must first unbind the rules. Otherwise, an error occurs.
        >  The lightweight virtual studio feature is in invitational preview. You can add up to 300 virtual studio templates.
        
        @param request: DeleteLiveAIStudioRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveAIStudioResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.studio_id):
            query['StudioId'] = request.studio_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveAIStudio',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveAIStudioResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_aistudio(
        self,
        request: live_20161101_models.DeleteLiveAIStudioRequest,
    ) -> live_20161101_models.DeleteLiveAIStudioResponse:
        """
        @summary Deletes a virtual studio template.
        
        @description To delete a virtual studio template, you must first unbind the rules. Otherwise, an error occurs.
        >  The lightweight virtual studio feature is in invitational preview. You can add up to 300 virtual studio templates.
        
        @param request: DeleteLiveAIStudioRequest
        @return: DeleteLiveAIStudioResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_aistudio_with_options(request, runtime)

    async def delete_live_aistudio_async(
        self,
        request: live_20161101_models.DeleteLiveAIStudioRequest,
    ) -> live_20161101_models.DeleteLiveAIStudioResponse:
        """
        @summary Deletes a virtual studio template.
        
        @description To delete a virtual studio template, you must first unbind the rules. Otherwise, an error occurs.
        >  The lightweight virtual studio feature is in invitational preview. You can add up to 300 virtual studio templates.
        
        @param request: DeleteLiveAIStudioRequest
        @return: DeleteLiveAIStudioResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_aistudio_with_options_async(request, runtime)

    def delete_live_aisubtitle_with_options(
        self,
        request: live_20161101_models.DeleteLiveAISubtitleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveAISubtitleResponse:
        """
        @summary Deletes a specified subtitle template.
        
        @description You can call this operation to delete a specified subtitle template for live streaming.
        >  The live subtitles feature is in invitational preview. You can add up to 300 subtitle templates.
        ## [](#qps-)QPS limit
        You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveAISubtitleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveAISubtitleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.subtitle_id):
            query['SubtitleId'] = request.subtitle_id
        if not UtilClient.is_unset(request.subtitle_name):
            query['SubtitleName'] = request.subtitle_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveAISubtitle',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveAISubtitleResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_aisubtitle_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveAISubtitleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveAISubtitleResponse:
        """
        @summary Deletes a specified subtitle template.
        
        @description You can call this operation to delete a specified subtitle template for live streaming.
        >  The live subtitles feature is in invitational preview. You can add up to 300 subtitle templates.
        ## [](#qps-)QPS limit
        You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveAISubtitleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveAISubtitleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.subtitle_id):
            query['SubtitleId'] = request.subtitle_id
        if not UtilClient.is_unset(request.subtitle_name):
            query['SubtitleName'] = request.subtitle_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveAISubtitle',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveAISubtitleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_aisubtitle(
        self,
        request: live_20161101_models.DeleteLiveAISubtitleRequest,
    ) -> live_20161101_models.DeleteLiveAISubtitleResponse:
        """
        @summary Deletes a specified subtitle template.
        
        @description You can call this operation to delete a specified subtitle template for live streaming.
        >  The live subtitles feature is in invitational preview. You can add up to 300 subtitle templates.
        ## [](#qps-)QPS limit
        You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveAISubtitleRequest
        @return: DeleteLiveAISubtitleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_aisubtitle_with_options(request, runtime)

    async def delete_live_aisubtitle_async(
        self,
        request: live_20161101_models.DeleteLiveAISubtitleRequest,
    ) -> live_20161101_models.DeleteLiveAISubtitleResponse:
        """
        @summary Deletes a specified subtitle template.
        
        @description You can call this operation to delete a specified subtitle template for live streaming.
        >  The live subtitles feature is in invitational preview. You can add up to 300 subtitle templates.
        ## [](#qps-)QPS limit
        You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveAISubtitleRequest
        @return: DeleteLiveAISubtitleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_aisubtitle_with_options_async(request, runtime)

    def delete_live_app_record_config_with_options(
        self,
        request: live_20161101_models.DeleteLiveAppRecordConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveAppRecordConfigResponse:
        """
        @summary Deletes a recording configuration at the application level.
        
        @description Obtain the main streaming domain, and then call this operation to delete a recording configuration at the application level.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveAppRecordConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveAppRecordConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveAppRecordConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveAppRecordConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_app_record_config_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveAppRecordConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveAppRecordConfigResponse:
        """
        @summary Deletes a recording configuration at the application level.
        
        @description Obtain the main streaming domain, and then call this operation to delete a recording configuration at the application level.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveAppRecordConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveAppRecordConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveAppRecordConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveAppRecordConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_app_record_config(
        self,
        request: live_20161101_models.DeleteLiveAppRecordConfigRequest,
    ) -> live_20161101_models.DeleteLiveAppRecordConfigResponse:
        """
        @summary Deletes a recording configuration at the application level.
        
        @description Obtain the main streaming domain, and then call this operation to delete a recording configuration at the application level.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveAppRecordConfigRequest
        @return: DeleteLiveAppRecordConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_app_record_config_with_options(request, runtime)

    async def delete_live_app_record_config_async(
        self,
        request: live_20161101_models.DeleteLiveAppRecordConfigRequest,
    ) -> live_20161101_models.DeleteLiveAppRecordConfigResponse:
        """
        @summary Deletes a recording configuration at the application level.
        
        @description Obtain the main streaming domain, and then call this operation to delete a recording configuration at the application level.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveAppRecordConfigRequest
        @return: DeleteLiveAppRecordConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_app_record_config_with_options_async(request, runtime)

    def delete_live_app_snapshot_config_with_options(
        self,
        request: live_20161101_models.DeleteLiveAppSnapshotConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveAppSnapshotConfigResponse:
        """
        @summary Deletes the snapshot configuration for live streams in an application. The deletion takes effect after you restart stream ingest.
        
        @description You can call this operation to delete the snapshot configuration for live streams in an application. The deletion takes effect after you restart stream ingest.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveAppSnapshotConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveAppSnapshotConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveAppSnapshotConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveAppSnapshotConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_app_snapshot_config_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveAppSnapshotConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveAppSnapshotConfigResponse:
        """
        @summary Deletes the snapshot configuration for live streams in an application. The deletion takes effect after you restart stream ingest.
        
        @description You can call this operation to delete the snapshot configuration for live streams in an application. The deletion takes effect after you restart stream ingest.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveAppSnapshotConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveAppSnapshotConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveAppSnapshotConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveAppSnapshotConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_app_snapshot_config(
        self,
        request: live_20161101_models.DeleteLiveAppSnapshotConfigRequest,
    ) -> live_20161101_models.DeleteLiveAppSnapshotConfigResponse:
        """
        @summary Deletes the snapshot configuration for live streams in an application. The deletion takes effect after you restart stream ingest.
        
        @description You can call this operation to delete the snapshot configuration for live streams in an application. The deletion takes effect after you restart stream ingest.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveAppSnapshotConfigRequest
        @return: DeleteLiveAppSnapshotConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_app_snapshot_config_with_options(request, runtime)

    async def delete_live_app_snapshot_config_async(
        self,
        request: live_20161101_models.DeleteLiveAppSnapshotConfigRequest,
    ) -> live_20161101_models.DeleteLiveAppSnapshotConfigResponse:
        """
        @summary Deletes the snapshot configuration for live streams in an application. The deletion takes effect after you restart stream ingest.
        
        @description You can call this operation to delete the snapshot configuration for live streams in an application. The deletion takes effect after you restart stream ingest.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveAppSnapshotConfigRequest
        @return: DeleteLiveAppSnapshotConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_app_snapshot_config_with_options_async(request, runtime)

    def delete_live_audio_audit_config_with_options(
        self,
        request: live_20161101_models.DeleteLiveAudioAuditConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveAudioAuditConfigResponse:
        """
        @summary Deletes an audio moderation configuration.
        
        @description    Obtain the main streaming domain, and then call this operation to delete an audio moderation configuration.
        Only some live centers support the content moderation feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveAudioAuditConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveAudioAuditConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveAudioAuditConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveAudioAuditConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_audio_audit_config_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveAudioAuditConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveAudioAuditConfigResponse:
        """
        @summary Deletes an audio moderation configuration.
        
        @description    Obtain the main streaming domain, and then call this operation to delete an audio moderation configuration.
        Only some live centers support the content moderation feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveAudioAuditConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveAudioAuditConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveAudioAuditConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveAudioAuditConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_audio_audit_config(
        self,
        request: live_20161101_models.DeleteLiveAudioAuditConfigRequest,
    ) -> live_20161101_models.DeleteLiveAudioAuditConfigResponse:
        """
        @summary Deletes an audio moderation configuration.
        
        @description    Obtain the main streaming domain, and then call this operation to delete an audio moderation configuration.
        Only some live centers support the content moderation feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveAudioAuditConfigRequest
        @return: DeleteLiveAudioAuditConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_audio_audit_config_with_options(request, runtime)

    async def delete_live_audio_audit_config_async(
        self,
        request: live_20161101_models.DeleteLiveAudioAuditConfigRequest,
    ) -> live_20161101_models.DeleteLiveAudioAuditConfigResponse:
        """
        @summary Deletes an audio moderation configuration.
        
        @description    Obtain the main streaming domain, and then call this operation to delete an audio moderation configuration.
        Only some live centers support the content moderation feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveAudioAuditConfigRequest
        @return: DeleteLiveAudioAuditConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_audio_audit_config_with_options_async(request, runtime)

    def delete_live_audio_audit_notify_config_with_options(
        self,
        request: live_20161101_models.DeleteLiveAudioAuditNotifyConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveAudioAuditNotifyConfigResponse:
        """
        @summary Deletes the configuration of callbacks for audio moderation results.
        
        @description    Obtain the main streaming domain, and then call this operation to delete the configuration of callbacks for audio moderation results.
        Only some live centers support the content moderation feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveAudioAuditNotifyConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveAudioAuditNotifyConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveAudioAuditNotifyConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveAudioAuditNotifyConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_audio_audit_notify_config_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveAudioAuditNotifyConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveAudioAuditNotifyConfigResponse:
        """
        @summary Deletes the configuration of callbacks for audio moderation results.
        
        @description    Obtain the main streaming domain, and then call this operation to delete the configuration of callbacks for audio moderation results.
        Only some live centers support the content moderation feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveAudioAuditNotifyConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveAudioAuditNotifyConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveAudioAuditNotifyConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveAudioAuditNotifyConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_audio_audit_notify_config(
        self,
        request: live_20161101_models.DeleteLiveAudioAuditNotifyConfigRequest,
    ) -> live_20161101_models.DeleteLiveAudioAuditNotifyConfigResponse:
        """
        @summary Deletes the configuration of callbacks for audio moderation results.
        
        @description    Obtain the main streaming domain, and then call this operation to delete the configuration of callbacks for audio moderation results.
        Only some live centers support the content moderation feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveAudioAuditNotifyConfigRequest
        @return: DeleteLiveAudioAuditNotifyConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_audio_audit_notify_config_with_options(request, runtime)

    async def delete_live_audio_audit_notify_config_async(
        self,
        request: live_20161101_models.DeleteLiveAudioAuditNotifyConfigRequest,
    ) -> live_20161101_models.DeleteLiveAudioAuditNotifyConfigResponse:
        """
        @summary Deletes the configuration of callbacks for audio moderation results.
        
        @description    Obtain the main streaming domain, and then call this operation to delete the configuration of callbacks for audio moderation results.
        Only some live centers support the content moderation feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveAudioAuditNotifyConfigRequest
        @return: DeleteLiveAudioAuditNotifyConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_audio_audit_notify_config_with_options_async(request, runtime)

    def delete_live_center_transfer_with_options(
        self,
        request: live_20161101_models.DeleteLiveCenterTransferRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveCenterTransferResponse:
        """
        @summary Deletes a configuration of live center stream relay.
        
        @description You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveCenterTransferRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveCenterTransferResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.dst_url):
            query['DstUrl'] = request.dst_url
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveCenterTransfer',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveCenterTransferResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_center_transfer_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveCenterTransferRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveCenterTransferResponse:
        """
        @summary Deletes a configuration of live center stream relay.
        
        @description You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveCenterTransferRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveCenterTransferResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.dst_url):
            query['DstUrl'] = request.dst_url
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveCenterTransfer',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveCenterTransferResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_center_transfer(
        self,
        request: live_20161101_models.DeleteLiveCenterTransferRequest,
    ) -> live_20161101_models.DeleteLiveCenterTransferResponse:
        """
        @summary Deletes a configuration of live center stream relay.
        
        @description You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveCenterTransferRequest
        @return: DeleteLiveCenterTransferResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_center_transfer_with_options(request, runtime)

    async def delete_live_center_transfer_async(
        self,
        request: live_20161101_models.DeleteLiveCenterTransferRequest,
    ) -> live_20161101_models.DeleteLiveCenterTransferResponse:
        """
        @summary Deletes a configuration of live center stream relay.
        
        @description You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveCenterTransferRequest
        @return: DeleteLiveCenterTransferResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_center_transfer_with_options_async(request, runtime)

    def delete_live_delay_config_with_options(
        self,
        request: live_20161101_models.DeleteLiveDelayConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveDelayConfigResponse:
        """
        @summary Deletes a stream delay configuration.
        
        @description You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveDelayConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveDelayConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app):
            query['App'] = request.app
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream):
            query['Stream'] = request.stream
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveDelayConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveDelayConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_delay_config_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveDelayConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveDelayConfigResponse:
        """
        @summary Deletes a stream delay configuration.
        
        @description You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveDelayConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveDelayConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app):
            query['App'] = request.app
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream):
            query['Stream'] = request.stream
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveDelayConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveDelayConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_delay_config(
        self,
        request: live_20161101_models.DeleteLiveDelayConfigRequest,
    ) -> live_20161101_models.DeleteLiveDelayConfigResponse:
        """
        @summary Deletes a stream delay configuration.
        
        @description You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveDelayConfigRequest
        @return: DeleteLiveDelayConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_delay_config_with_options(request, runtime)

    async def delete_live_delay_config_async(
        self,
        request: live_20161101_models.DeleteLiveDelayConfigRequest,
    ) -> live_20161101_models.DeleteLiveDelayConfigResponse:
        """
        @summary Deletes a stream delay configuration.
        
        @description You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveDelayConfigRequest
        @return: DeleteLiveDelayConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_delay_config_with_options_async(request, runtime)

    def delete_live_detect_notify_config_with_options(
        self,
        request: live_20161101_models.DeleteLiveDetectNotifyConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveDetectNotifyConfigResponse:
        """
        @summary Deletes the configuration of callbacks for video moderation results.
        
        @description ## [](#)Usage notes
        Obtain the main streaming domain, and then call this operation to delete the configuration of callbacks for video moderation results.
        Only some live centers support the content moderation feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveDetectNotifyConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveDetectNotifyConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveDetectNotifyConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveDetectNotifyConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_detect_notify_config_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveDetectNotifyConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveDetectNotifyConfigResponse:
        """
        @summary Deletes the configuration of callbacks for video moderation results.
        
        @description ## [](#)Usage notes
        Obtain the main streaming domain, and then call this operation to delete the configuration of callbacks for video moderation results.
        Only some live centers support the content moderation feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveDetectNotifyConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveDetectNotifyConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveDetectNotifyConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveDetectNotifyConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_detect_notify_config(
        self,
        request: live_20161101_models.DeleteLiveDetectNotifyConfigRequest,
    ) -> live_20161101_models.DeleteLiveDetectNotifyConfigResponse:
        """
        @summary Deletes the configuration of callbacks for video moderation results.
        
        @description ## [](#)Usage notes
        Obtain the main streaming domain, and then call this operation to delete the configuration of callbacks for video moderation results.
        Only some live centers support the content moderation feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveDetectNotifyConfigRequest
        @return: DeleteLiveDetectNotifyConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_detect_notify_config_with_options(request, runtime)

    async def delete_live_detect_notify_config_async(
        self,
        request: live_20161101_models.DeleteLiveDetectNotifyConfigRequest,
    ) -> live_20161101_models.DeleteLiveDetectNotifyConfigResponse:
        """
        @summary Deletes the configuration of callbacks for video moderation results.
        
        @description ## [](#)Usage notes
        Obtain the main streaming domain, and then call this operation to delete the configuration of callbacks for video moderation results.
        Only some live centers support the content moderation feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveDetectNotifyConfigRequest
        @return: DeleteLiveDetectNotifyConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_detect_notify_config_with_options_async(request, runtime)

    def delete_live_domain_with_options(
        self,
        request: live_20161101_models.DeleteLiveDomainRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveDomainResponse:
        """
        @summary Removes a domain name from ApsaraVideo Live.
        
        @description    After you successfully call the DeleteLiveDomain operation, all records of the specified domain name are deleted. Exercise caution when you perform this operation.
        We recommend that you restore to an A record for the domain name at the DNS provider before you remove the domain name. Otherwise, the domain name may become inaccessible. If your domain name is registered with Alibaba Cloud, log on to the [Alibaba Cloud DNS console](https://account.aliyun.com/login/login.htm?oauth_callback=https%3A%2F%2Fdns.console.aliyun.com%2F%3Fspm%3Da2c4g.11186623.0.0.3cda841fcvk7Qs\\&lang=zh) and navigate to the **Domain Name Resolution** page. Find the domain name and then click **DNS Settings** in the Actions column. On the page that appears, change the CNAME record to an A record. If your domain name is registered with another DNS provider, configure similar settings on the platform of that DNS provider.
        If you want to only suspend the use of the domain name, we recommend that you call the [StopLiveDomain](https://help.aliyun.com/document_detail/88329.html) operation.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveDomainRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveDomainResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveDomain',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveDomainResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_domain_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveDomainRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveDomainResponse:
        """
        @summary Removes a domain name from ApsaraVideo Live.
        
        @description    After you successfully call the DeleteLiveDomain operation, all records of the specified domain name are deleted. Exercise caution when you perform this operation.
        We recommend that you restore to an A record for the domain name at the DNS provider before you remove the domain name. Otherwise, the domain name may become inaccessible. If your domain name is registered with Alibaba Cloud, log on to the [Alibaba Cloud DNS console](https://account.aliyun.com/login/login.htm?oauth_callback=https%3A%2F%2Fdns.console.aliyun.com%2F%3Fspm%3Da2c4g.11186623.0.0.3cda841fcvk7Qs\\&lang=zh) and navigate to the **Domain Name Resolution** page. Find the domain name and then click **DNS Settings** in the Actions column. On the page that appears, change the CNAME record to an A record. If your domain name is registered with another DNS provider, configure similar settings on the platform of that DNS provider.
        If you want to only suspend the use of the domain name, we recommend that you call the [StopLiveDomain](https://help.aliyun.com/document_detail/88329.html) operation.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveDomainRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveDomainResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveDomain',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveDomainResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_domain(
        self,
        request: live_20161101_models.DeleteLiveDomainRequest,
    ) -> live_20161101_models.DeleteLiveDomainResponse:
        """
        @summary Removes a domain name from ApsaraVideo Live.
        
        @description    After you successfully call the DeleteLiveDomain operation, all records of the specified domain name are deleted. Exercise caution when you perform this operation.
        We recommend that you restore to an A record for the domain name at the DNS provider before you remove the domain name. Otherwise, the domain name may become inaccessible. If your domain name is registered with Alibaba Cloud, log on to the [Alibaba Cloud DNS console](https://account.aliyun.com/login/login.htm?oauth_callback=https%3A%2F%2Fdns.console.aliyun.com%2F%3Fspm%3Da2c4g.11186623.0.0.3cda841fcvk7Qs\\&lang=zh) and navigate to the **Domain Name Resolution** page. Find the domain name and then click **DNS Settings** in the Actions column. On the page that appears, change the CNAME record to an A record. If your domain name is registered with another DNS provider, configure similar settings on the platform of that DNS provider.
        If you want to only suspend the use of the domain name, we recommend that you call the [StopLiveDomain](https://help.aliyun.com/document_detail/88329.html) operation.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveDomainRequest
        @return: DeleteLiveDomainResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_domain_with_options(request, runtime)

    async def delete_live_domain_async(
        self,
        request: live_20161101_models.DeleteLiveDomainRequest,
    ) -> live_20161101_models.DeleteLiveDomainResponse:
        """
        @summary Removes a domain name from ApsaraVideo Live.
        
        @description    After you successfully call the DeleteLiveDomain operation, all records of the specified domain name are deleted. Exercise caution when you perform this operation.
        We recommend that you restore to an A record for the domain name at the DNS provider before you remove the domain name. Otherwise, the domain name may become inaccessible. If your domain name is registered with Alibaba Cloud, log on to the [Alibaba Cloud DNS console](https://account.aliyun.com/login/login.htm?oauth_callback=https%3A%2F%2Fdns.console.aliyun.com%2F%3Fspm%3Da2c4g.11186623.0.0.3cda841fcvk7Qs\\&lang=zh) and navigate to the **Domain Name Resolution** page. Find the domain name and then click **DNS Settings** in the Actions column. On the page that appears, change the CNAME record to an A record. If your domain name is registered with another DNS provider, configure similar settings on the platform of that DNS provider.
        If you want to only suspend the use of the domain name, we recommend that you call the [StopLiveDomain](https://help.aliyun.com/document_detail/88329.html) operation.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveDomainRequest
        @return: DeleteLiveDomainResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_domain_with_options_async(request, runtime)

    def delete_live_domain_mapping_with_options(
        self,
        request: live_20161101_models.DeleteLiveDomainMappingRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveDomainMappingResponse:
        """
        @summary Deletes the mapping between a streaming domain and an ingest domain.
        
        @description Make sure that the streaming domain has been mapped to the ingest domain before you call this operation to delete the mapping. For more information about how to map a streaming domain to an ingest domain, see [AddLiveDomainMapping](https://help.aliyun.com/document_detail/88782.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveDomainMappingRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveDomainMappingResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pull_domain):
            query['PullDomain'] = request.pull_domain
        if not UtilClient.is_unset(request.push_domain):
            query['PushDomain'] = request.push_domain
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveDomainMapping',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveDomainMappingResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_domain_mapping_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveDomainMappingRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveDomainMappingResponse:
        """
        @summary Deletes the mapping between a streaming domain and an ingest domain.
        
        @description Make sure that the streaming domain has been mapped to the ingest domain before you call this operation to delete the mapping. For more information about how to map a streaming domain to an ingest domain, see [AddLiveDomainMapping](https://help.aliyun.com/document_detail/88782.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveDomainMappingRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveDomainMappingResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pull_domain):
            query['PullDomain'] = request.pull_domain
        if not UtilClient.is_unset(request.push_domain):
            query['PushDomain'] = request.push_domain
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveDomainMapping',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveDomainMappingResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_domain_mapping(
        self,
        request: live_20161101_models.DeleteLiveDomainMappingRequest,
    ) -> live_20161101_models.DeleteLiveDomainMappingResponse:
        """
        @summary Deletes the mapping between a streaming domain and an ingest domain.
        
        @description Make sure that the streaming domain has been mapped to the ingest domain before you call this operation to delete the mapping. For more information about how to map a streaming domain to an ingest domain, see [AddLiveDomainMapping](https://help.aliyun.com/document_detail/88782.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveDomainMappingRequest
        @return: DeleteLiveDomainMappingResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_domain_mapping_with_options(request, runtime)

    async def delete_live_domain_mapping_async(
        self,
        request: live_20161101_models.DeleteLiveDomainMappingRequest,
    ) -> live_20161101_models.DeleteLiveDomainMappingResponse:
        """
        @summary Deletes the mapping between a streaming domain and an ingest domain.
        
        @description Make sure that the streaming domain has been mapped to the ingest domain before you call this operation to delete the mapping. For more information about how to map a streaming domain to an ingest domain, see [AddLiveDomainMapping](https://help.aliyun.com/document_detail/88782.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveDomainMappingRequest
        @return: DeleteLiveDomainMappingResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_domain_mapping_with_options_async(request, runtime)

    def delete_live_domain_play_mapping_with_options(
        self,
        request: live_20161101_models.DeleteLiveDomainPlayMappingRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveDomainPlayMappingResponse:
        """
        @summary Deletes the mapping between a main streaming domain and a sub-streaming domain.
        
        @description Before you call this operation, make sure that the mapping between the main streaming domain and the sub-streaming domain is created. For more information about how to call an operation to create the mapping between a main streaming domain and a sub-streaming domain, see [AddLiveDomainPlayMapping](https://help.aliyun.com/document_detail/173091.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 1,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveDomainPlayMappingRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveDomainPlayMappingResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.play_domain):
            query['PlayDomain'] = request.play_domain
        if not UtilClient.is_unset(request.pull_domain):
            query['PullDomain'] = request.pull_domain
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveDomainPlayMapping',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveDomainPlayMappingResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_domain_play_mapping_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveDomainPlayMappingRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveDomainPlayMappingResponse:
        """
        @summary Deletes the mapping between a main streaming domain and a sub-streaming domain.
        
        @description Before you call this operation, make sure that the mapping between the main streaming domain and the sub-streaming domain is created. For more information about how to call an operation to create the mapping between a main streaming domain and a sub-streaming domain, see [AddLiveDomainPlayMapping](https://help.aliyun.com/document_detail/173091.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 1,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveDomainPlayMappingRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveDomainPlayMappingResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.play_domain):
            query['PlayDomain'] = request.play_domain
        if not UtilClient.is_unset(request.pull_domain):
            query['PullDomain'] = request.pull_domain
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveDomainPlayMapping',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveDomainPlayMappingResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_domain_play_mapping(
        self,
        request: live_20161101_models.DeleteLiveDomainPlayMappingRequest,
    ) -> live_20161101_models.DeleteLiveDomainPlayMappingResponse:
        """
        @summary Deletes the mapping between a main streaming domain and a sub-streaming domain.
        
        @description Before you call this operation, make sure that the mapping between the main streaming domain and the sub-streaming domain is created. For more information about how to call an operation to create the mapping between a main streaming domain and a sub-streaming domain, see [AddLiveDomainPlayMapping](https://help.aliyun.com/document_detail/173091.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 1,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveDomainPlayMappingRequest
        @return: DeleteLiveDomainPlayMappingResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_domain_play_mapping_with_options(request, runtime)

    async def delete_live_domain_play_mapping_async(
        self,
        request: live_20161101_models.DeleteLiveDomainPlayMappingRequest,
    ) -> live_20161101_models.DeleteLiveDomainPlayMappingResponse:
        """
        @summary Deletes the mapping between a main streaming domain and a sub-streaming domain.
        
        @description Before you call this operation, make sure that the mapping between the main streaming domain and the sub-streaming domain is created. For more information about how to call an operation to create the mapping between a main streaming domain and a sub-streaming domain, see [AddLiveDomainPlayMapping](https://help.aliyun.com/document_detail/173091.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 1,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveDomainPlayMappingRequest
        @return: DeleteLiveDomainPlayMappingResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_domain_play_mapping_with_options_async(request, runtime)

    def delete_live_edge_transfer_with_options(
        self,
        request: live_20161101_models.DeleteLiveEdgeTransferRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveEdgeTransferResponse:
        """
        @summary Deletes the configuration of edge stream relay.
        
        @description You can call the DeleteLiveEdgeTransfer operation to delete the configuration of edge stream relay for a specific domain name. Ingested streams that are already relayed based on the configuration are not affected. The following table describes the scenarios in which edge stream relay takes effect or not.
        |Scenario|Analysis|Result|
        |---|---|---|
        |1\\. You ingest a stream after you call the SetLiveEdgeTransfer operation to configure edge stream relay. Then, you call the DeleteLiveEdgeTransfer operation to delete the configuration.|The configuration of edge stream relay is available when you ingest the stream.|The ingested stream is not affected, and stream relay is not interrupted.|
        |2\\. You call the DeleteLiveEdgeTransfer operation to delete the configuration of edge stream relay after you ingest a stream. Then, you disconnect and resume the ingested stream.|The configuration of edge stream relay is not available after you resume the ingested stream.|Edge stream relay does not take effect.|
        |3\\. You call the DeleteLiveEdgeTransfer operation before you ingest a stream.|The configuration of edge stream relay is not available.|Edge stream relay does not take effect.|
        ## QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveEdgeTransferRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveEdgeTransferResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveEdgeTransfer',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveEdgeTransferResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_edge_transfer_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveEdgeTransferRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveEdgeTransferResponse:
        """
        @summary Deletes the configuration of edge stream relay.
        
        @description You can call the DeleteLiveEdgeTransfer operation to delete the configuration of edge stream relay for a specific domain name. Ingested streams that are already relayed based on the configuration are not affected. The following table describes the scenarios in which edge stream relay takes effect or not.
        |Scenario|Analysis|Result|
        |---|---|---|
        |1\\. You ingest a stream after you call the SetLiveEdgeTransfer operation to configure edge stream relay. Then, you call the DeleteLiveEdgeTransfer operation to delete the configuration.|The configuration of edge stream relay is available when you ingest the stream.|The ingested stream is not affected, and stream relay is not interrupted.|
        |2\\. You call the DeleteLiveEdgeTransfer operation to delete the configuration of edge stream relay after you ingest a stream. Then, you disconnect and resume the ingested stream.|The configuration of edge stream relay is not available after you resume the ingested stream.|Edge stream relay does not take effect.|
        |3\\. You call the DeleteLiveEdgeTransfer operation before you ingest a stream.|The configuration of edge stream relay is not available.|Edge stream relay does not take effect.|
        ## QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveEdgeTransferRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveEdgeTransferResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveEdgeTransfer',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveEdgeTransferResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_edge_transfer(
        self,
        request: live_20161101_models.DeleteLiveEdgeTransferRequest,
    ) -> live_20161101_models.DeleteLiveEdgeTransferResponse:
        """
        @summary Deletes the configuration of edge stream relay.
        
        @description You can call the DeleteLiveEdgeTransfer operation to delete the configuration of edge stream relay for a specific domain name. Ingested streams that are already relayed based on the configuration are not affected. The following table describes the scenarios in which edge stream relay takes effect or not.
        |Scenario|Analysis|Result|
        |---|---|---|
        |1\\. You ingest a stream after you call the SetLiveEdgeTransfer operation to configure edge stream relay. Then, you call the DeleteLiveEdgeTransfer operation to delete the configuration.|The configuration of edge stream relay is available when you ingest the stream.|The ingested stream is not affected, and stream relay is not interrupted.|
        |2\\. You call the DeleteLiveEdgeTransfer operation to delete the configuration of edge stream relay after you ingest a stream. Then, you disconnect and resume the ingested stream.|The configuration of edge stream relay is not available after you resume the ingested stream.|Edge stream relay does not take effect.|
        |3\\. You call the DeleteLiveEdgeTransfer operation before you ingest a stream.|The configuration of edge stream relay is not available.|Edge stream relay does not take effect.|
        ## QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveEdgeTransferRequest
        @return: DeleteLiveEdgeTransferResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_edge_transfer_with_options(request, runtime)

    async def delete_live_edge_transfer_async(
        self,
        request: live_20161101_models.DeleteLiveEdgeTransferRequest,
    ) -> live_20161101_models.DeleteLiveEdgeTransferResponse:
        """
        @summary Deletes the configuration of edge stream relay.
        
        @description You can call the DeleteLiveEdgeTransfer operation to delete the configuration of edge stream relay for a specific domain name. Ingested streams that are already relayed based on the configuration are not affected. The following table describes the scenarios in which edge stream relay takes effect or not.
        |Scenario|Analysis|Result|
        |---|---|---|
        |1\\. You ingest a stream after you call the SetLiveEdgeTransfer operation to configure edge stream relay. Then, you call the DeleteLiveEdgeTransfer operation to delete the configuration.|The configuration of edge stream relay is available when you ingest the stream.|The ingested stream is not affected, and stream relay is not interrupted.|
        |2\\. You call the DeleteLiveEdgeTransfer operation to delete the configuration of edge stream relay after you ingest a stream. Then, you disconnect and resume the ingested stream.|The configuration of edge stream relay is not available after you resume the ingested stream.|Edge stream relay does not take effect.|
        |3\\. You call the DeleteLiveEdgeTransfer operation before you ingest a stream.|The configuration of edge stream relay is not available.|Edge stream relay does not take effect.|
        ## QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveEdgeTransferRequest
        @return: DeleteLiveEdgeTransferResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_edge_transfer_with_options_async(request, runtime)

    def delete_live_lazy_pull_stream_info_config_with_options(
        self,
        request: live_20161101_models.DeleteLiveLazyPullStreamInfoConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveLazyPullStreamInfoConfigResponse:
        """
        @summary Deletes a configuration of triggered stream pulling.
        
        @description This operation is application to triggered stream pulling. You can call this operation to delete a configuration of triggered stream pulling. If you set the AppName parameter to ali_all_app, configurations of triggered stream pulling for all applications under the domain name are deleted.
        ## [](#qps-)QPS limit
        You can call this operation up to 1,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveLazyPullStreamInfoConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveLazyPullStreamInfoConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveLazyPullStreamInfoConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveLazyPullStreamInfoConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_lazy_pull_stream_info_config_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveLazyPullStreamInfoConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveLazyPullStreamInfoConfigResponse:
        """
        @summary Deletes a configuration of triggered stream pulling.
        
        @description This operation is application to triggered stream pulling. You can call this operation to delete a configuration of triggered stream pulling. If you set the AppName parameter to ali_all_app, configurations of triggered stream pulling for all applications under the domain name are deleted.
        ## [](#qps-)QPS limit
        You can call this operation up to 1,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveLazyPullStreamInfoConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveLazyPullStreamInfoConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveLazyPullStreamInfoConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveLazyPullStreamInfoConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_lazy_pull_stream_info_config(
        self,
        request: live_20161101_models.DeleteLiveLazyPullStreamInfoConfigRequest,
    ) -> live_20161101_models.DeleteLiveLazyPullStreamInfoConfigResponse:
        """
        @summary Deletes a configuration of triggered stream pulling.
        
        @description This operation is application to triggered stream pulling. You can call this operation to delete a configuration of triggered stream pulling. If you set the AppName parameter to ali_all_app, configurations of triggered stream pulling for all applications under the domain name are deleted.
        ## [](#qps-)QPS limit
        You can call this operation up to 1,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveLazyPullStreamInfoConfigRequest
        @return: DeleteLiveLazyPullStreamInfoConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_lazy_pull_stream_info_config_with_options(request, runtime)

    async def delete_live_lazy_pull_stream_info_config_async(
        self,
        request: live_20161101_models.DeleteLiveLazyPullStreamInfoConfigRequest,
    ) -> live_20161101_models.DeleteLiveLazyPullStreamInfoConfigResponse:
        """
        @summary Deletes a configuration of triggered stream pulling.
        
        @description This operation is application to triggered stream pulling. You can call this operation to delete a configuration of triggered stream pulling. If you set the AppName parameter to ali_all_app, configurations of triggered stream pulling for all applications under the domain name are deleted.
        ## [](#qps-)QPS limit
        You can call this operation up to 1,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveLazyPullStreamInfoConfigRequest
        @return: DeleteLiveLazyPullStreamInfoConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_lazy_pull_stream_info_config_with_options_async(request, runtime)

    def delete_live_message_group_with_options(
        self,
        request: live_20161101_models.DeleteLiveMessageGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveMessageGroupResponse:
        """
        @summary Deletes an interactive messaging group.
        
        @description    Before you call this operation, make sure that you have called the [CreateLiveMessageGroup](https://help.aliyun.com/document_detail/2848163.html) operation to create an interactive messaging group.
        After you delete an interactive messaging group, it is no longer available. Every user in the group is notified that the group is closed.
        After you delete an interactive messaging group, messages in the group are retained for 30 days.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveMessageGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveMessageGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.data_center):
            query['DataCenter'] = request.data_center
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.operator_id):
            query['OperatorId'] = request.operator_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveMessageGroup',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveMessageGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_message_group_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveMessageGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveMessageGroupResponse:
        """
        @summary Deletes an interactive messaging group.
        
        @description    Before you call this operation, make sure that you have called the [CreateLiveMessageGroup](https://help.aliyun.com/document_detail/2848163.html) operation to create an interactive messaging group.
        After you delete an interactive messaging group, it is no longer available. Every user in the group is notified that the group is closed.
        After you delete an interactive messaging group, messages in the group are retained for 30 days.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveMessageGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveMessageGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.data_center):
            query['DataCenter'] = request.data_center
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.operator_id):
            query['OperatorId'] = request.operator_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveMessageGroup',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveMessageGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_message_group(
        self,
        request: live_20161101_models.DeleteLiveMessageGroupRequest,
    ) -> live_20161101_models.DeleteLiveMessageGroupResponse:
        """
        @summary Deletes an interactive messaging group.
        
        @description    Before you call this operation, make sure that you have called the [CreateLiveMessageGroup](https://help.aliyun.com/document_detail/2848163.html) operation to create an interactive messaging group.
        After you delete an interactive messaging group, it is no longer available. Every user in the group is notified that the group is closed.
        After you delete an interactive messaging group, messages in the group are retained for 30 days.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveMessageGroupRequest
        @return: DeleteLiveMessageGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_message_group_with_options(request, runtime)

    async def delete_live_message_group_async(
        self,
        request: live_20161101_models.DeleteLiveMessageGroupRequest,
    ) -> live_20161101_models.DeleteLiveMessageGroupResponse:
        """
        @summary Deletes an interactive messaging group.
        
        @description    Before you call this operation, make sure that you have called the [CreateLiveMessageGroup](https://help.aliyun.com/document_detail/2848163.html) operation to create an interactive messaging group.
        After you delete an interactive messaging group, it is no longer available. Every user in the group is notified that the group is closed.
        After you delete an interactive messaging group, messages in the group are retained for 30 days.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveMessageGroupRequest
        @return: DeleteLiveMessageGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_message_group_with_options_async(request, runtime)

    def delete_live_message_group_message_with_options(
        self,
        request: live_20161101_models.DeleteLiveMessageGroupMessageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveMessageGroupMessageResponse:
        """
        @summary Deletes a message that was sent to an interactive messaging group.
        
        @description You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveMessageGroupMessageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveMessageGroupMessageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.data_center):
            query['DataCenter'] = request.data_center
        if not UtilClient.is_unset(request.deleter_id):
            query['DeleterId'] = request.deleter_id
        if not UtilClient.is_unset(request.deleter_info):
            query['DeleterInfo'] = request.deleter_info
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.message_id):
            query['MessageId'] = request.message_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveMessageGroupMessage',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveMessageGroupMessageResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_message_group_message_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveMessageGroupMessageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveMessageGroupMessageResponse:
        """
        @summary Deletes a message that was sent to an interactive messaging group.
        
        @description You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveMessageGroupMessageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveMessageGroupMessageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.data_center):
            query['DataCenter'] = request.data_center
        if not UtilClient.is_unset(request.deleter_id):
            query['DeleterId'] = request.deleter_id
        if not UtilClient.is_unset(request.deleter_info):
            query['DeleterInfo'] = request.deleter_info
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.message_id):
            query['MessageId'] = request.message_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveMessageGroupMessage',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveMessageGroupMessageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_message_group_message(
        self,
        request: live_20161101_models.DeleteLiveMessageGroupMessageRequest,
    ) -> live_20161101_models.DeleteLiveMessageGroupMessageResponse:
        """
        @summary Deletes a message that was sent to an interactive messaging group.
        
        @description You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveMessageGroupMessageRequest
        @return: DeleteLiveMessageGroupMessageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_message_group_message_with_options(request, runtime)

    async def delete_live_message_group_message_async(
        self,
        request: live_20161101_models.DeleteLiveMessageGroupMessageRequest,
    ) -> live_20161101_models.DeleteLiveMessageGroupMessageResponse:
        """
        @summary Deletes a message that was sent to an interactive messaging group.
        
        @description You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveMessageGroupMessageRequest
        @return: DeleteLiveMessageGroupMessageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_message_group_message_with_options_async(request, runtime)

    def delete_live_message_user_message_with_options(
        self,
        request: live_20161101_models.DeleteLiveMessageUserMessageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveMessageUserMessageResponse:
        """
        @summary Deletes a message that is sent to a user.
        
        @description ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveMessageUserMessageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveMessageUserMessageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.data_center):
            query['DataCenter'] = request.data_center
        if not UtilClient.is_unset(request.deleter_id):
            query['DeleterId'] = request.deleter_id
        if not UtilClient.is_unset(request.deleter_info):
            query['DeleterInfo'] = request.deleter_info
        if not UtilClient.is_unset(request.message_id):
            query['MessageId'] = request.message_id
        if not UtilClient.is_unset(request.receiver_id):
            query['ReceiverId'] = request.receiver_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveMessageUserMessage',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveMessageUserMessageResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_message_user_message_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveMessageUserMessageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveMessageUserMessageResponse:
        """
        @summary Deletes a message that is sent to a user.
        
        @description ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveMessageUserMessageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveMessageUserMessageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.data_center):
            query['DataCenter'] = request.data_center
        if not UtilClient.is_unset(request.deleter_id):
            query['DeleterId'] = request.deleter_id
        if not UtilClient.is_unset(request.deleter_info):
            query['DeleterInfo'] = request.deleter_info
        if not UtilClient.is_unset(request.message_id):
            query['MessageId'] = request.message_id
        if not UtilClient.is_unset(request.receiver_id):
            query['ReceiverId'] = request.receiver_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveMessageUserMessage',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveMessageUserMessageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_message_user_message(
        self,
        request: live_20161101_models.DeleteLiveMessageUserMessageRequest,
    ) -> live_20161101_models.DeleteLiveMessageUserMessageResponse:
        """
        @summary Deletes a message that is sent to a user.
        
        @description ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveMessageUserMessageRequest
        @return: DeleteLiveMessageUserMessageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_message_user_message_with_options(request, runtime)

    async def delete_live_message_user_message_async(
        self,
        request: live_20161101_models.DeleteLiveMessageUserMessageRequest,
    ) -> live_20161101_models.DeleteLiveMessageUserMessageResponse:
        """
        @summary Deletes a message that is sent to a user.
        
        @description ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveMessageUserMessageRequest
        @return: DeleteLiveMessageUserMessageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_message_user_message_with_options_async(request, runtime)

    def delete_live_package_config_with_options(
        self,
        request: live_20161101_models.DeleteLivePackageConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLivePackageConfigResponse:
        """
        @description You can call this operation to delete a live stream encapsulation configuration. The deletion takes effect after you re-ingest the stream.
        ## [](#qps-)QPS limit
        You can call this operation up to 300 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLivePackageConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLivePackageConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLivePackageConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLivePackageConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_package_config_with_options_async(
        self,
        request: live_20161101_models.DeleteLivePackageConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLivePackageConfigResponse:
        """
        @description You can call this operation to delete a live stream encapsulation configuration. The deletion takes effect after you re-ingest the stream.
        ## [](#qps-)QPS limit
        You can call this operation up to 300 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLivePackageConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLivePackageConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLivePackageConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLivePackageConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_package_config(
        self,
        request: live_20161101_models.DeleteLivePackageConfigRequest,
    ) -> live_20161101_models.DeleteLivePackageConfigResponse:
        """
        @description You can call this operation to delete a live stream encapsulation configuration. The deletion takes effect after you re-ingest the stream.
        ## [](#qps-)QPS limit
        You can call this operation up to 300 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLivePackageConfigRequest
        @return: DeleteLivePackageConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_package_config_with_options(request, runtime)

    async def delete_live_package_config_async(
        self,
        request: live_20161101_models.DeleteLivePackageConfigRequest,
    ) -> live_20161101_models.DeleteLivePackageConfigResponse:
        """
        @description You can call this operation to delete a live stream encapsulation configuration. The deletion takes effect after you re-ingest the stream.
        ## [](#qps-)QPS limit
        You can call this operation up to 300 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLivePackageConfigRequest
        @return: DeleteLivePackageConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_package_config_with_options_async(request, runtime)

    def delete_live_private_line_with_options(
        self,
        request: live_20161101_models.DeleteLivePrivateLineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLivePrivateLineResponse:
        """
        @summary Unbinds a Global Accelerator (GA) instance from an acceleration circuit.
        
        @description After you unbind a GA instance from an acceleration circuit, your stream ingest and streaming are no longer accelerated by the GA instance. The GA instance still exists. If you want to release the GA instance, delete it in the GA console.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLivePrivateLineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLivePrivateLineResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acceleration_type):
            query['AccelerationType'] = request.acceleration_type
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLivePrivateLine',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLivePrivateLineResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_private_line_with_options_async(
        self,
        request: live_20161101_models.DeleteLivePrivateLineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLivePrivateLineResponse:
        """
        @summary Unbinds a Global Accelerator (GA) instance from an acceleration circuit.
        
        @description After you unbind a GA instance from an acceleration circuit, your stream ingest and streaming are no longer accelerated by the GA instance. The GA instance still exists. If you want to release the GA instance, delete it in the GA console.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLivePrivateLineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLivePrivateLineResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acceleration_type):
            query['AccelerationType'] = request.acceleration_type
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLivePrivateLine',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLivePrivateLineResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_private_line(
        self,
        request: live_20161101_models.DeleteLivePrivateLineRequest,
    ) -> live_20161101_models.DeleteLivePrivateLineResponse:
        """
        @summary Unbinds a Global Accelerator (GA) instance from an acceleration circuit.
        
        @description After you unbind a GA instance from an acceleration circuit, your stream ingest and streaming are no longer accelerated by the GA instance. The GA instance still exists. If you want to release the GA instance, delete it in the GA console.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLivePrivateLineRequest
        @return: DeleteLivePrivateLineResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_private_line_with_options(request, runtime)

    async def delete_live_private_line_async(
        self,
        request: live_20161101_models.DeleteLivePrivateLineRequest,
    ) -> live_20161101_models.DeleteLivePrivateLineResponse:
        """
        @summary Unbinds a Global Accelerator (GA) instance from an acceleration circuit.
        
        @description After you unbind a GA instance from an acceleration circuit, your stream ingest and streaming are no longer accelerated by the GA instance. The GA instance still exists. If you want to release the GA instance, delete it in the GA console.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLivePrivateLineRequest
        @return: DeleteLivePrivateLineResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_private_line_with_options_async(request, runtime)

    def delete_live_pull_stream_info_config_with_options(
        self,
        request: live_20161101_models.DeleteLivePullStreamInfoConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLivePullStreamInfoConfigResponse:
        """
        @summary Deletes a stream pulling configuration.
        
        @description This operation is applicable to regular stream pulling. You can call this operation to delete a configuration of regular stream pulling.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLivePullStreamInfoConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLivePullStreamInfoConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLivePullStreamInfoConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLivePullStreamInfoConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_pull_stream_info_config_with_options_async(
        self,
        request: live_20161101_models.DeleteLivePullStreamInfoConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLivePullStreamInfoConfigResponse:
        """
        @summary Deletes a stream pulling configuration.
        
        @description This operation is applicable to regular stream pulling. You can call this operation to delete a configuration of regular stream pulling.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLivePullStreamInfoConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLivePullStreamInfoConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLivePullStreamInfoConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLivePullStreamInfoConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_pull_stream_info_config(
        self,
        request: live_20161101_models.DeleteLivePullStreamInfoConfigRequest,
    ) -> live_20161101_models.DeleteLivePullStreamInfoConfigResponse:
        """
        @summary Deletes a stream pulling configuration.
        
        @description This operation is applicable to regular stream pulling. You can call this operation to delete a configuration of regular stream pulling.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLivePullStreamInfoConfigRequest
        @return: DeleteLivePullStreamInfoConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_pull_stream_info_config_with_options(request, runtime)

    async def delete_live_pull_stream_info_config_async(
        self,
        request: live_20161101_models.DeleteLivePullStreamInfoConfigRequest,
    ) -> live_20161101_models.DeleteLivePullStreamInfoConfigResponse:
        """
        @summary Deletes a stream pulling configuration.
        
        @description This operation is applicable to regular stream pulling. You can call this operation to delete a configuration of regular stream pulling.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLivePullStreamInfoConfigRequest
        @return: DeleteLivePullStreamInfoConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_pull_stream_info_config_with_options_async(request, runtime)

    def delete_live_pull_to_push_with_options(
        self,
        request: live_20161101_models.DeleteLivePullToPushRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLivePullToPushResponse:
        """
        @summary Deletes a pulled-stream relay task.
        
        @description    You can call this operation to delete a pulled-stream relay task.
        If you delete a running task, the task is immediately stopped and cannot be restarted.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLivePullToPushRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLivePullToPushResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLivePullToPush',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLivePullToPushResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_pull_to_push_with_options_async(
        self,
        request: live_20161101_models.DeleteLivePullToPushRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLivePullToPushResponse:
        """
        @summary Deletes a pulled-stream relay task.
        
        @description    You can call this operation to delete a pulled-stream relay task.
        If you delete a running task, the task is immediately stopped and cannot be restarted.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLivePullToPushRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLivePullToPushResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLivePullToPush',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLivePullToPushResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_pull_to_push(
        self,
        request: live_20161101_models.DeleteLivePullToPushRequest,
    ) -> live_20161101_models.DeleteLivePullToPushResponse:
        """
        @summary Deletes a pulled-stream relay task.
        
        @description    You can call this operation to delete a pulled-stream relay task.
        If you delete a running task, the task is immediately stopped and cannot be restarted.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLivePullToPushRequest
        @return: DeleteLivePullToPushResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_pull_to_push_with_options(request, runtime)

    async def delete_live_pull_to_push_async(
        self,
        request: live_20161101_models.DeleteLivePullToPushRequest,
    ) -> live_20161101_models.DeleteLivePullToPushResponse:
        """
        @summary Deletes a pulled-stream relay task.
        
        @description    You can call this operation to delete a pulled-stream relay task.
        If you delete a running task, the task is immediately stopped and cannot be restarted.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLivePullToPushRequest
        @return: DeleteLivePullToPushResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_pull_to_push_with_options_async(request, runtime)

    def delete_live_real_time_log_logstore_with_options(
        self,
        request: live_20161101_models.DeleteLiveRealTimeLogLogstoreRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveRealTimeLogLogstoreResponse:
        """
        @summary Deletes the Logstore that is specified by a configuration of real-time log delivery.
        
        @description    You can call this operation to delete the Logstore that is specified by a configuration of real-time log delivery. Make sure that all parameters meet the requirements when you call this operation.
        You can call the [DescribeLiveDomainRealtimeLogDelivery](https://help.aliyun.com/document_detail/2848121.html) operation to query the Project, Logstore, and Region parameters.
        ## [](#qps-)QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveRealTimeLogLogstoreRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveRealTimeLogLogstoreResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveRealTimeLogLogstore',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveRealTimeLogLogstoreResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_real_time_log_logstore_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveRealTimeLogLogstoreRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveRealTimeLogLogstoreResponse:
        """
        @summary Deletes the Logstore that is specified by a configuration of real-time log delivery.
        
        @description    You can call this operation to delete the Logstore that is specified by a configuration of real-time log delivery. Make sure that all parameters meet the requirements when you call this operation.
        You can call the [DescribeLiveDomainRealtimeLogDelivery](https://help.aliyun.com/document_detail/2848121.html) operation to query the Project, Logstore, and Region parameters.
        ## [](#qps-)QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveRealTimeLogLogstoreRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveRealTimeLogLogstoreResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveRealTimeLogLogstore',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveRealTimeLogLogstoreResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_real_time_log_logstore(
        self,
        request: live_20161101_models.DeleteLiveRealTimeLogLogstoreRequest,
    ) -> live_20161101_models.DeleteLiveRealTimeLogLogstoreResponse:
        """
        @summary Deletes the Logstore that is specified by a configuration of real-time log delivery.
        
        @description    You can call this operation to delete the Logstore that is specified by a configuration of real-time log delivery. Make sure that all parameters meet the requirements when you call this operation.
        You can call the [DescribeLiveDomainRealtimeLogDelivery](https://help.aliyun.com/document_detail/2848121.html) operation to query the Project, Logstore, and Region parameters.
        ## [](#qps-)QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveRealTimeLogLogstoreRequest
        @return: DeleteLiveRealTimeLogLogstoreResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_real_time_log_logstore_with_options(request, runtime)

    async def delete_live_real_time_log_logstore_async(
        self,
        request: live_20161101_models.DeleteLiveRealTimeLogLogstoreRequest,
    ) -> live_20161101_models.DeleteLiveRealTimeLogLogstoreResponse:
        """
        @summary Deletes the Logstore that is specified by a configuration of real-time log delivery.
        
        @description    You can call this operation to delete the Logstore that is specified by a configuration of real-time log delivery. Make sure that all parameters meet the requirements when you call this operation.
        You can call the [DescribeLiveDomainRealtimeLogDelivery](https://help.aliyun.com/document_detail/2848121.html) operation to query the Project, Logstore, and Region parameters.
        ## [](#qps-)QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveRealTimeLogLogstoreRequest
        @return: DeleteLiveRealTimeLogLogstoreResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_real_time_log_logstore_with_options_async(request, runtime)

    def delete_live_realtime_log_delivery_with_options(
        self,
        request: live_20161101_models.DeleteLiveRealtimeLogDeliveryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveRealtimeLogDeliveryResponse:
        """
        @summary Deletes the configurations of real-time log delivery for one or more domain names.
        
        @description
        This operation is applicable to only streaming domains. If you want to configure real-tome log delivery for an ingest domain, [submit a ticket](https://workorder-intl.console.aliyun.com/?spm=5176.12818093.nav-right.dticket.6cb216d07otFWR#/ticket/createIndex).
        You can call the [DescribeLiveDomainRealtimeLogDelivery](https://help.aliyun.com/document_detail/2848121.html) to query the Project, Logstore, and Region parameters.
        ## [](#qps-)QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveRealtimeLogDeliveryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveRealtimeLogDeliveryResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveRealtimeLogDelivery',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveRealtimeLogDeliveryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_realtime_log_delivery_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveRealtimeLogDeliveryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveRealtimeLogDeliveryResponse:
        """
        @summary Deletes the configurations of real-time log delivery for one or more domain names.
        
        @description
        This operation is applicable to only streaming domains. If you want to configure real-tome log delivery for an ingest domain, [submit a ticket](https://workorder-intl.console.aliyun.com/?spm=5176.12818093.nav-right.dticket.6cb216d07otFWR#/ticket/createIndex).
        You can call the [DescribeLiveDomainRealtimeLogDelivery](https://help.aliyun.com/document_detail/2848121.html) to query the Project, Logstore, and Region parameters.
        ## [](#qps-)QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveRealtimeLogDeliveryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveRealtimeLogDeliveryResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveRealtimeLogDelivery',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveRealtimeLogDeliveryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_realtime_log_delivery(
        self,
        request: live_20161101_models.DeleteLiveRealtimeLogDeliveryRequest,
    ) -> live_20161101_models.DeleteLiveRealtimeLogDeliveryResponse:
        """
        @summary Deletes the configurations of real-time log delivery for one or more domain names.
        
        @description
        This operation is applicable to only streaming domains. If you want to configure real-tome log delivery for an ingest domain, [submit a ticket](https://workorder-intl.console.aliyun.com/?spm=5176.12818093.nav-right.dticket.6cb216d07otFWR#/ticket/createIndex).
        You can call the [DescribeLiveDomainRealtimeLogDelivery](https://help.aliyun.com/document_detail/2848121.html) to query the Project, Logstore, and Region parameters.
        ## [](#qps-)QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveRealtimeLogDeliveryRequest
        @return: DeleteLiveRealtimeLogDeliveryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_realtime_log_delivery_with_options(request, runtime)

    async def delete_live_realtime_log_delivery_async(
        self,
        request: live_20161101_models.DeleteLiveRealtimeLogDeliveryRequest,
    ) -> live_20161101_models.DeleteLiveRealtimeLogDeliveryResponse:
        """
        @summary Deletes the configurations of real-time log delivery for one or more domain names.
        
        @description
        This operation is applicable to only streaming domains. If you want to configure real-tome log delivery for an ingest domain, [submit a ticket](https://workorder-intl.console.aliyun.com/?spm=5176.12818093.nav-right.dticket.6cb216d07otFWR#/ticket/createIndex).
        You can call the [DescribeLiveDomainRealtimeLogDelivery](https://help.aliyun.com/document_detail/2848121.html) to query the Project, Logstore, and Region parameters.
        ## [](#qps-)QPS limit
        You can call this operation up to 6,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveRealtimeLogDeliveryRequest
        @return: DeleteLiveRealtimeLogDeliveryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_realtime_log_delivery_with_options_async(request, runtime)

    def delete_live_record_notify_config_with_options(
        self,
        request: live_20161101_models.DeleteLiveRecordNotifyConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveRecordNotifyConfigResponse:
        """
        @summary Deletes the configuration of callbacks for live stream recording under a domain name.
        
        @description Obtain the main streaming domain, and then call this operation to delete the configuration of callbacks for live stream recording under the main streaming domain.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveRecordNotifyConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveRecordNotifyConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveRecordNotifyConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveRecordNotifyConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_record_notify_config_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveRecordNotifyConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveRecordNotifyConfigResponse:
        """
        @summary Deletes the configuration of callbacks for live stream recording under a domain name.
        
        @description Obtain the main streaming domain, and then call this operation to delete the configuration of callbacks for live stream recording under the main streaming domain.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveRecordNotifyConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveRecordNotifyConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveRecordNotifyConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveRecordNotifyConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_record_notify_config(
        self,
        request: live_20161101_models.DeleteLiveRecordNotifyConfigRequest,
    ) -> live_20161101_models.DeleteLiveRecordNotifyConfigResponse:
        """
        @summary Deletes the configuration of callbacks for live stream recording under a domain name.
        
        @description Obtain the main streaming domain, and then call this operation to delete the configuration of callbacks for live stream recording under the main streaming domain.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveRecordNotifyConfigRequest
        @return: DeleteLiveRecordNotifyConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_record_notify_config_with_options(request, runtime)

    async def delete_live_record_notify_config_async(
        self,
        request: live_20161101_models.DeleteLiveRecordNotifyConfigRequest,
    ) -> live_20161101_models.DeleteLiveRecordNotifyConfigResponse:
        """
        @summary Deletes the configuration of callbacks for live stream recording under a domain name.
        
        @description Obtain the main streaming domain, and then call this operation to delete the configuration of callbacks for live stream recording under the main streaming domain.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveRecordNotifyConfigRequest
        @return: DeleteLiveRecordNotifyConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_record_notify_config_with_options_async(request, runtime)

    def delete_live_record_vod_config_with_options(
        self,
        request: live_20161101_models.DeleteLiveRecordVodConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveRecordVodConfigResponse:
        """
        @summary Deletes a Live-to-VOD configuration.
        
        @description Obtain the main streaming domain, and then call this operation to delete a Live-to-VOD configuration.
        ## [](#qps-)QPS limit
        You can call this operation up to 1,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveRecordVodConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveRecordVodConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveRecordVodConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveRecordVodConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_record_vod_config_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveRecordVodConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveRecordVodConfigResponse:
        """
        @summary Deletes a Live-to-VOD configuration.
        
        @description Obtain the main streaming domain, and then call this operation to delete a Live-to-VOD configuration.
        ## [](#qps-)QPS limit
        You can call this operation up to 1,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveRecordVodConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveRecordVodConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveRecordVodConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveRecordVodConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_record_vod_config(
        self,
        request: live_20161101_models.DeleteLiveRecordVodConfigRequest,
    ) -> live_20161101_models.DeleteLiveRecordVodConfigResponse:
        """
        @summary Deletes a Live-to-VOD configuration.
        
        @description Obtain the main streaming domain, and then call this operation to delete a Live-to-VOD configuration.
        ## [](#qps-)QPS limit
        You can call this operation up to 1,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveRecordVodConfigRequest
        @return: DeleteLiveRecordVodConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_record_vod_config_with_options(request, runtime)

    async def delete_live_record_vod_config_async(
        self,
        request: live_20161101_models.DeleteLiveRecordVodConfigRequest,
    ) -> live_20161101_models.DeleteLiveRecordVodConfigResponse:
        """
        @summary Deletes a Live-to-VOD configuration.
        
        @description Obtain the main streaming domain, and then call this operation to delete a Live-to-VOD configuration.
        ## [](#qps-)QPS limit
        You can call this operation up to 1,000 times per minute per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveRecordVodConfigRequest
        @return: DeleteLiveRecordVodConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_record_vod_config_with_options_async(request, runtime)

    def delete_live_snapshot_detect_porn_config_with_options(
        self,
        request: live_20161101_models.DeleteLiveSnapshotDetectPornConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveSnapshotDetectPornConfigResponse:
        """
        @summary Deletes a video moderation configuration.
        
        @description    Obtain the main streaming domain, and then call this operation to delete a video moderation configuration.
        Only some live centers support the content moderation feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveSnapshotDetectPornConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveSnapshotDetectPornConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveSnapshotDetectPornConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveSnapshotDetectPornConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_snapshot_detect_porn_config_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveSnapshotDetectPornConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveSnapshotDetectPornConfigResponse:
        """
        @summary Deletes a video moderation configuration.
        
        @description    Obtain the main streaming domain, and then call this operation to delete a video moderation configuration.
        Only some live centers support the content moderation feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveSnapshotDetectPornConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveSnapshotDetectPornConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveSnapshotDetectPornConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveSnapshotDetectPornConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_snapshot_detect_porn_config(
        self,
        request: live_20161101_models.DeleteLiveSnapshotDetectPornConfigRequest,
    ) -> live_20161101_models.DeleteLiveSnapshotDetectPornConfigResponse:
        """
        @summary Deletes a video moderation configuration.
        
        @description    Obtain the main streaming domain, and then call this operation to delete a video moderation configuration.
        Only some live centers support the content moderation feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveSnapshotDetectPornConfigRequest
        @return: DeleteLiveSnapshotDetectPornConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_snapshot_detect_porn_config_with_options(request, runtime)

    async def delete_live_snapshot_detect_porn_config_async(
        self,
        request: live_20161101_models.DeleteLiveSnapshotDetectPornConfigRequest,
    ) -> live_20161101_models.DeleteLiveSnapshotDetectPornConfigResponse:
        """
        @summary Deletes a video moderation configuration.
        
        @description    Obtain the main streaming domain, and then call this operation to delete a video moderation configuration.
        Only some live centers support the content moderation feature. For more information, see [Supported regions](https://help.aliyun.com/document_detail/193730.html).
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveSnapshotDetectPornConfigRequest
        @return: DeleteLiveSnapshotDetectPornConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_snapshot_detect_porn_config_with_options_async(request, runtime)

    def delete_live_snapshot_notify_config_with_options(
        self,
        request: live_20161101_models.DeleteLiveSnapshotNotifyConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveSnapshotNotifyConfigResponse:
        """
        @summary Deletes the configuration of snapshot callbacks.
        
        @description You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveSnapshotNotifyConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveSnapshotNotifyConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveSnapshotNotifyConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveSnapshotNotifyConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_snapshot_notify_config_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveSnapshotNotifyConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveSnapshotNotifyConfigResponse:
        """
        @summary Deletes the configuration of snapshot callbacks.
        
        @description You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveSnapshotNotifyConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveSnapshotNotifyConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveSnapshotNotifyConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveSnapshotNotifyConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_snapshot_notify_config(
        self,
        request: live_20161101_models.DeleteLiveSnapshotNotifyConfigRequest,
    ) -> live_20161101_models.DeleteLiveSnapshotNotifyConfigResponse:
        """
        @summary Deletes the configuration of snapshot callbacks.
        
        @description You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveSnapshotNotifyConfigRequest
        @return: DeleteLiveSnapshotNotifyConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_snapshot_notify_config_with_options(request, runtime)

    async def delete_live_snapshot_notify_config_async(
        self,
        request: live_20161101_models.DeleteLiveSnapshotNotifyConfigRequest,
    ) -> live_20161101_models.DeleteLiveSnapshotNotifyConfigResponse:
        """
        @summary Deletes the configuration of snapshot callbacks.
        
        @description You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveSnapshotNotifyConfigRequest
        @return: DeleteLiveSnapshotNotifyConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_snapshot_notify_config_with_options_async(request, runtime)

    def delete_live_specific_staging_config_with_options(
        self,
        request: live_20161101_models.DeleteLiveSpecificStagingConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveSpecificStagingConfigResponse:
        """
        @summary Deletes domain configurations in the canary release environment.
        
        @description ## [](#)Usage notes
        Before you call this operation to delete a domain configuration in the canary release environment, you can call the [DescribeLiveDomainStagingConfig](https://help.aliyun.com/document_detail/297374.html) operation to obtain the configuration ID.
        ## [](#qps-)QPS limit
        You can call this operation up to 20 times per second per account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveSpecificStagingConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveSpecificStagingConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config_id):
            query['ConfigId'] = request.config_id
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveSpecificStagingConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveSpecificStagingConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_specific_staging_config_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveSpecificStagingConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveSpecificStagingConfigResponse:
        """
        @summary Deletes domain configurations in the canary release environment.
        
        @description ## [](#)Usage notes
        Before you call this operation to delete a domain configuration in the canary release environment, you can call the [DescribeLiveDomainStagingConfig](https://help.aliyun.com/document_detail/297374.html) operation to obtain the configuration ID.
        ## [](#qps-)QPS limit
        You can call this operation up to 20 times per second per account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveSpecificStagingConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveSpecificStagingConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config_id):
            query['ConfigId'] = request.config_id
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveSpecificStagingConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveSpecificStagingConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_specific_staging_config(
        self,
        request: live_20161101_models.DeleteLiveSpecificStagingConfigRequest,
    ) -> live_20161101_models.DeleteLiveSpecificStagingConfigResponse:
        """
        @summary Deletes domain configurations in the canary release environment.
        
        @description ## [](#)Usage notes
        Before you call this operation to delete a domain configuration in the canary release environment, you can call the [DescribeLiveDomainStagingConfig](https://help.aliyun.com/document_detail/297374.html) operation to obtain the configuration ID.
        ## [](#qps-)QPS limit
        You can call this operation up to 20 times per second per account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveSpecificStagingConfigRequest
        @return: DeleteLiveSpecificStagingConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_specific_staging_config_with_options(request, runtime)

    async def delete_live_specific_staging_config_async(
        self,
        request: live_20161101_models.DeleteLiveSpecificStagingConfigRequest,
    ) -> live_20161101_models.DeleteLiveSpecificStagingConfigResponse:
        """
        @summary Deletes domain configurations in the canary release environment.
        
        @description ## [](#)Usage notes
        Before you call this operation to delete a domain configuration in the canary release environment, you can call the [DescribeLiveDomainStagingConfig](https://help.aliyun.com/document_detail/297374.html) operation to obtain the configuration ID.
        ## [](#qps-)QPS limit
        You can call this operation up to 20 times per second per account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveSpecificStagingConfigRequest
        @return: DeleteLiveSpecificStagingConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_specific_staging_config_with_options_async(request, runtime)

    def delete_live_stream_block_with_options(
        self,
        request: live_20161101_models.DeleteLiveStreamBlockRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveStreamBlockResponse:
        """
        @summary Deletes a configuration of stream-level region blocking.
        
        @description You can call this operation to delete a configuration of stream-level region blocking.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamBlockRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveStreamBlockResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveStreamBlock',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveStreamBlockResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_stream_block_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveStreamBlockRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveStreamBlockResponse:
        """
        @summary Deletes a configuration of stream-level region blocking.
        
        @description You can call this operation to delete a configuration of stream-level region blocking.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamBlockRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveStreamBlockResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveStreamBlock',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveStreamBlockResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_stream_block(
        self,
        request: live_20161101_models.DeleteLiveStreamBlockRequest,
    ) -> live_20161101_models.DeleteLiveStreamBlockResponse:
        """
        @summary Deletes a configuration of stream-level region blocking.
        
        @description You can call this operation to delete a configuration of stream-level region blocking.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamBlockRequest
        @return: DeleteLiveStreamBlockResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_stream_block_with_options(request, runtime)

    async def delete_live_stream_block_async(
        self,
        request: live_20161101_models.DeleteLiveStreamBlockRequest,
    ) -> live_20161101_models.DeleteLiveStreamBlockResponse:
        """
        @summary Deletes a configuration of stream-level region blocking.
        
        @description You can call this operation to delete a configuration of stream-level region blocking.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamBlockRequest
        @return: DeleteLiveStreamBlockResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_stream_block_with_options_async(request, runtime)

    def delete_live_stream_merge_with_options(
        self,
        request: live_20161101_models.DeleteLiveStreamMergeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveStreamMergeResponse:
        """
        @summary Deletes an active mixed stream.
        
        @description You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamMergeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveStreamMergeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveStreamMerge',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveStreamMergeResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_stream_merge_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveStreamMergeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveStreamMergeResponse:
        """
        @summary Deletes an active mixed stream.
        
        @description You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamMergeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveStreamMergeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveStreamMerge',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveStreamMergeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_stream_merge(
        self,
        request: live_20161101_models.DeleteLiveStreamMergeRequest,
    ) -> live_20161101_models.DeleteLiveStreamMergeResponse:
        """
        @summary Deletes an active mixed stream.
        
        @description You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamMergeRequest
        @return: DeleteLiveStreamMergeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_stream_merge_with_options(request, runtime)

    async def delete_live_stream_merge_async(
        self,
        request: live_20161101_models.DeleteLiveStreamMergeRequest,
    ) -> live_20161101_models.DeleteLiveStreamMergeResponse:
        """
        @summary Deletes an active mixed stream.
        
        @description You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamMergeRequest
        @return: DeleteLiveStreamMergeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_stream_merge_with_options_async(request, runtime)

    def delete_live_stream_monitor_with_options(
        self,
        request: live_20161101_models.DeleteLiveStreamMonitorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveStreamMonitorResponse:
        """
        @summary Deletes a monitoring session.
        
        @description Before you call this operation, obtain the monitoring session ID from the response parameter *MonitorId** of the [CreateLiveStreamMonitor](https://help.aliyun.com/document_detail/2848129.html) operation.
        >  You cannot delete a monitoring session that is in the started state. If you try to delete it, a 400 error is reported.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamMonitorRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveStreamMonitorResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.monitor_id):
            query['MonitorId'] = request.monitor_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveStreamMonitor',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveStreamMonitorResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_stream_monitor_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveStreamMonitorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveStreamMonitorResponse:
        """
        @summary Deletes a monitoring session.
        
        @description Before you call this operation, obtain the monitoring session ID from the response parameter *MonitorId** of the [CreateLiveStreamMonitor](https://help.aliyun.com/document_detail/2848129.html) operation.
        >  You cannot delete a monitoring session that is in the started state. If you try to delete it, a 400 error is reported.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamMonitorRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveStreamMonitorResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.monitor_id):
            query['MonitorId'] = request.monitor_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveStreamMonitor',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveStreamMonitorResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_stream_monitor(
        self,
        request: live_20161101_models.DeleteLiveStreamMonitorRequest,
    ) -> live_20161101_models.DeleteLiveStreamMonitorResponse:
        """
        @summary Deletes a monitoring session.
        
        @description Before you call this operation, obtain the monitoring session ID from the response parameter *MonitorId** of the [CreateLiveStreamMonitor](https://help.aliyun.com/document_detail/2848129.html) operation.
        >  You cannot delete a monitoring session that is in the started state. If you try to delete it, a 400 error is reported.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamMonitorRequest
        @return: DeleteLiveStreamMonitorResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_stream_monitor_with_options(request, runtime)

    async def delete_live_stream_monitor_async(
        self,
        request: live_20161101_models.DeleteLiveStreamMonitorRequest,
    ) -> live_20161101_models.DeleteLiveStreamMonitorResponse:
        """
        @summary Deletes a monitoring session.
        
        @description Before you call this operation, obtain the monitoring session ID from the response parameter *MonitorId** of the [CreateLiveStreamMonitor](https://help.aliyun.com/document_detail/2848129.html) operation.
        >  You cannot delete a monitoring session that is in the started state. If you try to delete it, a 400 error is reported.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamMonitorRequest
        @return: DeleteLiveStreamMonitorResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_stream_monitor_with_options_async(request, runtime)

    def delete_live_stream_record_index_files_with_options(
        self,
        request: live_20161101_models.DeleteLiveStreamRecordIndexFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveStreamRecordIndexFilesResponse:
        """
        @summary Deletes live stream recordings.
        
        @description You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamRecordIndexFilesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveStreamRecordIndexFilesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.record_id):
            query['RecordId'] = request.record_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.remove_file):
            query['RemoveFile'] = request.remove_file
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveStreamRecordIndexFiles',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveStreamRecordIndexFilesResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_stream_record_index_files_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveStreamRecordIndexFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveStreamRecordIndexFilesResponse:
        """
        @summary Deletes live stream recordings.
        
        @description You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamRecordIndexFilesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveStreamRecordIndexFilesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.record_id):
            query['RecordId'] = request.record_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.remove_file):
            query['RemoveFile'] = request.remove_file
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveStreamRecordIndexFiles',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveStreamRecordIndexFilesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_stream_record_index_files(
        self,
        request: live_20161101_models.DeleteLiveStreamRecordIndexFilesRequest,
    ) -> live_20161101_models.DeleteLiveStreamRecordIndexFilesResponse:
        """
        @summary Deletes live stream recordings.
        
        @description You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamRecordIndexFilesRequest
        @return: DeleteLiveStreamRecordIndexFilesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_stream_record_index_files_with_options(request, runtime)

    async def delete_live_stream_record_index_files_async(
        self,
        request: live_20161101_models.DeleteLiveStreamRecordIndexFilesRequest,
    ) -> live_20161101_models.DeleteLiveStreamRecordIndexFilesResponse:
        """
        @summary Deletes live stream recordings.
        
        @description You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamRecordIndexFilesRequest
        @return: DeleteLiveStreamRecordIndexFilesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_stream_record_index_files_with_options_async(request, runtime)

    def delete_live_stream_transcode_with_options(
        self,
        request: live_20161101_models.DeleteLiveStreamTranscodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveStreamTranscodeResponse:
        """
        @summary Deletes a transcoding configuration.
        
        @description Standard transcoding templates, Narrowband HD™ transcoding templates, and custom transcoding templates are supported for this operation.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamTranscodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveStreamTranscodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app):
            query['App'] = request.app
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.template):
            query['Template'] = request.template
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveStreamTranscode',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveStreamTranscodeResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_stream_transcode_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveStreamTranscodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveStreamTranscodeResponse:
        """
        @summary Deletes a transcoding configuration.
        
        @description Standard transcoding templates, Narrowband HD™ transcoding templates, and custom transcoding templates are supported for this operation.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamTranscodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveStreamTranscodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app):
            query['App'] = request.app
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.template):
            query['Template'] = request.template
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveStreamTranscode',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveStreamTranscodeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_stream_transcode(
        self,
        request: live_20161101_models.DeleteLiveStreamTranscodeRequest,
    ) -> live_20161101_models.DeleteLiveStreamTranscodeResponse:
        """
        @summary Deletes a transcoding configuration.
        
        @description Standard transcoding templates, Narrowband HD™ transcoding templates, and custom transcoding templates are supported for this operation.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamTranscodeRequest
        @return: DeleteLiveStreamTranscodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_stream_transcode_with_options(request, runtime)

    async def delete_live_stream_transcode_async(
        self,
        request: live_20161101_models.DeleteLiveStreamTranscodeRequest,
    ) -> live_20161101_models.DeleteLiveStreamTranscodeResponse:
        """
        @summary Deletes a transcoding configuration.
        
        @description Standard transcoding templates, Narrowband HD™ transcoding templates, and custom transcoding templates are supported for this operation.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamTranscodeRequest
        @return: DeleteLiveStreamTranscodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_stream_transcode_with_options_async(request, runtime)

    def delete_live_stream_watermark_with_options(
        self,
        request: live_20161101_models.DeleteLiveStreamWatermarkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveStreamWatermarkResponse:
        """
        @summary Deletes a specified watermark template.
        
        @description This interface supports deleting the watermark template with the specified TemplateId for live streaming.
        ## QPS Limitation
        The per-user QPS limit for this interface is 60 times/second. Exceeding this limit will result in API throttling, which may impact your business operations. Please use it reasonably. For more information, please refer to [QPS Limitation](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveStreamWatermarkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveStreamWatermarkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveStreamWatermark',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveStreamWatermarkResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_stream_watermark_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveStreamWatermarkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveStreamWatermarkResponse:
        """
        @summary Deletes a specified watermark template.
        
        @description This interface supports deleting the watermark template with the specified TemplateId for live streaming.
        ## QPS Limitation
        The per-user QPS limit for this interface is 60 times/second. Exceeding this limit will result in API throttling, which may impact your business operations. Please use it reasonably. For more information, please refer to [QPS Limitation](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveStreamWatermarkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveStreamWatermarkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveStreamWatermark',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveStreamWatermarkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_stream_watermark(
        self,
        request: live_20161101_models.DeleteLiveStreamWatermarkRequest,
    ) -> live_20161101_models.DeleteLiveStreamWatermarkResponse:
        """
        @summary Deletes a specified watermark template.
        
        @description This interface supports deleting the watermark template with the specified TemplateId for live streaming.
        ## QPS Limitation
        The per-user QPS limit for this interface is 60 times/second. Exceeding this limit will result in API throttling, which may impact your business operations. Please use it reasonably. For more information, please refer to [QPS Limitation](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveStreamWatermarkRequest
        @return: DeleteLiveStreamWatermarkResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_stream_watermark_with_options(request, runtime)

    async def delete_live_stream_watermark_async(
        self,
        request: live_20161101_models.DeleteLiveStreamWatermarkRequest,
    ) -> live_20161101_models.DeleteLiveStreamWatermarkResponse:
        """
        @summary Deletes a specified watermark template.
        
        @description This interface supports deleting the watermark template with the specified TemplateId for live streaming.
        ## QPS Limitation
        The per-user QPS limit for this interface is 60 times/second. Exceeding this limit will result in API throttling, which may impact your business operations. Please use it reasonably. For more information, please refer to [QPS Limitation](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteLiveStreamWatermarkRequest
        @return: DeleteLiveStreamWatermarkResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_stream_watermark_with_options_async(request, runtime)

    def delete_live_stream_watermark_rule_with_options(
        self,
        request: live_20161101_models.DeleteLiveStreamWatermarkRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveStreamWatermarkRuleResponse:
        """
        @summary Deletes a watermark rule.
        
        @description You can call this operation to delete a watermark rule with a specified ID.
        ## [](#qps-)QPS limit
        You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamWatermarkRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveStreamWatermarkRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app):
            query['App'] = request.app
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        if not UtilClient.is_unset(request.stream):
            query['Stream'] = request.stream
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveStreamWatermarkRule',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveStreamWatermarkRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_stream_watermark_rule_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveStreamWatermarkRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveStreamWatermarkRuleResponse:
        """
        @summary Deletes a watermark rule.
        
        @description You can call this operation to delete a watermark rule with a specified ID.
        ## [](#qps-)QPS limit
        You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamWatermarkRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveStreamWatermarkRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app):
            query['App'] = request.app
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        if not UtilClient.is_unset(request.stream):
            query['Stream'] = request.stream
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveStreamWatermarkRule',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveStreamWatermarkRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_stream_watermark_rule(
        self,
        request: live_20161101_models.DeleteLiveStreamWatermarkRuleRequest,
    ) -> live_20161101_models.DeleteLiveStreamWatermarkRuleResponse:
        """
        @summary Deletes a watermark rule.
        
        @description You can call this operation to delete a watermark rule with a specified ID.
        ## [](#qps-)QPS limit
        You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamWatermarkRuleRequest
        @return: DeleteLiveStreamWatermarkRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_stream_watermark_rule_with_options(request, runtime)

    async def delete_live_stream_watermark_rule_async(
        self,
        request: live_20161101_models.DeleteLiveStreamWatermarkRuleRequest,
    ) -> live_20161101_models.DeleteLiveStreamWatermarkRuleResponse:
        """
        @summary Deletes a watermark rule.
        
        @description You can call this operation to delete a watermark rule with a specified ID.
        ## [](#qps-)QPS limit
        You can call this operation up to 60 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamWatermarkRuleRequest
        @return: DeleteLiveStreamWatermarkRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_stream_watermark_rule_with_options_async(request, runtime)

    def delete_live_streams_notify_url_config_with_options(
        self,
        request: live_20161101_models.DeleteLiveStreamsNotifyUrlConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveStreamsNotifyUrlConfigResponse:
        """
        @summary Deletes the callback configuration for stream ingest under an ingest domain.
        
        @description Obtain the ingest domain, and then call this operation to delete the callback configuration for stream ingest under the ingest domain.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamsNotifyUrlConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveStreamsNotifyUrlConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveStreamsNotifyUrlConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveStreamsNotifyUrlConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_streams_notify_url_config_with_options_async(
        self,
        request: live_20161101_models.DeleteLiveStreamsNotifyUrlConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteLiveStreamsNotifyUrlConfigResponse:
        """
        @summary Deletes the callback configuration for stream ingest under an ingest domain.
        
        @description Obtain the ingest domain, and then call this operation to delete the callback configuration for stream ingest under the ingest domain.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamsNotifyUrlConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveStreamsNotifyUrlConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveStreamsNotifyUrlConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteLiveStreamsNotifyUrlConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_streams_notify_url_config(
        self,
        request: live_20161101_models.DeleteLiveStreamsNotifyUrlConfigRequest,
    ) -> live_20161101_models.DeleteLiveStreamsNotifyUrlConfigResponse:
        """
        @summary Deletes the callback configuration for stream ingest under an ingest domain.
        
        @description Obtain the ingest domain, and then call this operation to delete the callback configuration for stream ingest under the ingest domain.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamsNotifyUrlConfigRequest
        @return: DeleteLiveStreamsNotifyUrlConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_streams_notify_url_config_with_options(request, runtime)

    async def delete_live_streams_notify_url_config_async(
        self,
        request: live_20161101_models.DeleteLiveStreamsNotifyUrlConfigRequest,
    ) -> live_20161101_models.DeleteLiveStreamsNotifyUrlConfigResponse:
        """
        @summary Deletes the callback configuration for stream ingest under an ingest domain.
        
        @description Obtain the ingest domain, and then call this operation to delete the callback configuration for stream ingest under the ingest domain.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteLiveStreamsNotifyUrlConfigRequest
        @return: DeleteLiveStreamsNotifyUrlConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_streams_notify_url_config_with_options_async(request, runtime)

    def delete_message_app_with_options(
        self,
        request: live_20161101_models.DeleteMessageAppRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteMessageAppResponse:
        """
        @summary Deletes an interactive messaging application.
        
        @description ## QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteMessageAppRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMessageAppResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.app_id):
            body['AppId'] = request.app_id
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='DeleteMessageApp',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteMessageAppResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_message_app_with_options_async(
        self,
        request: live_20161101_models.DeleteMessageAppRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteMessageAppResponse:
        """
        @summary Deletes an interactive messaging application.
        
        @description ## QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteMessageAppRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMessageAppResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.app_id):
            body['AppId'] = request.app_id
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='DeleteMessageApp',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteMessageAppResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_message_app(
        self,
        request: live_20161101_models.DeleteMessageAppRequest,
    ) -> live_20161101_models.DeleteMessageAppResponse:
        """
        @summary Deletes an interactive messaging application.
        
        @description ## QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteMessageAppRequest
        @return: DeleteMessageAppResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_message_app_with_options(request, runtime)

    async def delete_message_app_async(
        self,
        request: live_20161101_models.DeleteMessageAppRequest,
    ) -> live_20161101_models.DeleteMessageAppResponse:
        """
        @summary Deletes an interactive messaging application.
        
        @description ## QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limit on an API operation in ApsaraVideo Live](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteMessageAppRequest
        @return: DeleteMessageAppResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_message_app_with_options_async(request, runtime)

    def delete_mix_stream_with_options(
        self,
        request: live_20161101_models.DeleteMixStreamRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteMixStreamResponse:
        """
        @summary Deletes a stream mixing task.
        
        @description You can call the [CreateMixStream](https://help.aliyun.com/document_detail/2848087.html) operation to create a stream mixing task and then call this operation to delete the stream mixing task. If you no longer need a mixed stream, be sure to delete it. Mixed streams that are not deleted are continuously ingested.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteMixStreamRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMixStreamResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.mix_stream_id):
            query['MixStreamId'] = request.mix_stream_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteMixStream',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteMixStreamResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_mix_stream_with_options_async(
        self,
        request: live_20161101_models.DeleteMixStreamRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteMixStreamResponse:
        """
        @summary Deletes a stream mixing task.
        
        @description You can call the [CreateMixStream](https://help.aliyun.com/document_detail/2848087.html) operation to create a stream mixing task and then call this operation to delete the stream mixing task. If you no longer need a mixed stream, be sure to delete it. Mixed streams that are not deleted are continuously ingested.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteMixStreamRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMixStreamResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.mix_stream_id):
            query['MixStreamId'] = request.mix_stream_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteMixStream',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteMixStreamResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_mix_stream(
        self,
        request: live_20161101_models.DeleteMixStreamRequest,
    ) -> live_20161101_models.DeleteMixStreamResponse:
        """
        @summary Deletes a stream mixing task.
        
        @description You can call the [CreateMixStream](https://help.aliyun.com/document_detail/2848087.html) operation to create a stream mixing task and then call this operation to delete the stream mixing task. If you no longer need a mixed stream, be sure to delete it. Mixed streams that are not deleted are continuously ingested.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteMixStreamRequest
        @return: DeleteMixStreamResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_mix_stream_with_options(request, runtime)

    async def delete_mix_stream_async(
        self,
        request: live_20161101_models.DeleteMixStreamRequest,
    ) -> live_20161101_models.DeleteMixStreamResponse:
        """
        @summary Deletes a stream mixing task.
        
        @description You can call the [CreateMixStream](https://help.aliyun.com/document_detail/2848087.html) operation to create a stream mixing task and then call this operation to delete the stream mixing task. If you no longer need a mixed stream, be sure to delete it. Mixed streams that are not deleted are continuously ingested.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteMixStreamRequest
        @return: DeleteMixStreamResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_mix_stream_with_options_async(request, runtime)

    def delete_playlist_with_options(
        self,
        request: live_20161101_models.DeletePlaylistRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeletePlaylistResponse:
        """
        @summary Deletes an episode list.
        
        @description Before you call this operation to delete an episode list, make sure that you have called the [AddPlaylistItems](https://help.aliyun.com/document_detail/2848078.html) operation to create the episode list.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeletePlaylistRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePlaylistResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.program_id):
            query['ProgramId'] = request.program_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePlaylist',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeletePlaylistResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_playlist_with_options_async(
        self,
        request: live_20161101_models.DeletePlaylistRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeletePlaylistResponse:
        """
        @summary Deletes an episode list.
        
        @description Before you call this operation to delete an episode list, make sure that you have called the [AddPlaylistItems](https://help.aliyun.com/document_detail/2848078.html) operation to create the episode list.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeletePlaylistRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePlaylistResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.program_id):
            query['ProgramId'] = request.program_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePlaylist',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeletePlaylistResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_playlist(
        self,
        request: live_20161101_models.DeletePlaylistRequest,
    ) -> live_20161101_models.DeletePlaylistResponse:
        """
        @summary Deletes an episode list.
        
        @description Before you call this operation to delete an episode list, make sure that you have called the [AddPlaylistItems](https://help.aliyun.com/document_detail/2848078.html) operation to create the episode list.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeletePlaylistRequest
        @return: DeletePlaylistResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_playlist_with_options(request, runtime)

    async def delete_playlist_async(
        self,
        request: live_20161101_models.DeletePlaylistRequest,
    ) -> live_20161101_models.DeletePlaylistResponse:
        """
        @summary Deletes an episode list.
        
        @description Before you call this operation to delete an episode list, make sure that you have called the [AddPlaylistItems](https://help.aliyun.com/document_detail/2848078.html) operation to create the episode list.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeletePlaylistRequest
        @return: DeletePlaylistResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_playlist_with_options_async(request, runtime)

    def delete_playlist_items_with_options(
        self,
        request: live_20161101_models.DeletePlaylistItemsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeletePlaylistItemsResponse:
        """
        @summary Removes episodes from an episode list.
        
        @description Before you call this operation to remove an episode, make sure that you have called the [AddPlaylistItems](https://help.aliyun.com/document_detail/2848078.html) operation to add the episode.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeletePlaylistItemsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePlaylistItemsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.program_id):
            query['ProgramId'] = request.program_id
        if not UtilClient.is_unset(request.program_item_ids):
            query['ProgramItemIds'] = request.program_item_ids
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePlaylistItems',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeletePlaylistItemsResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_playlist_items_with_options_async(
        self,
        request: live_20161101_models.DeletePlaylistItemsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeletePlaylistItemsResponse:
        """
        @summary Removes episodes from an episode list.
        
        @description Before you call this operation to remove an episode, make sure that you have called the [AddPlaylistItems](https://help.aliyun.com/document_detail/2848078.html) operation to add the episode.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeletePlaylistItemsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePlaylistItemsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.program_id):
            query['ProgramId'] = request.program_id
        if not UtilClient.is_unset(request.program_item_ids):
            query['ProgramItemIds'] = request.program_item_ids
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePlaylistItems',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeletePlaylistItemsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_playlist_items(
        self,
        request: live_20161101_models.DeletePlaylistItemsRequest,
    ) -> live_20161101_models.DeletePlaylistItemsResponse:
        """
        @summary Removes episodes from an episode list.
        
        @description Before you call this operation to remove an episode, make sure that you have called the [AddPlaylistItems](https://help.aliyun.com/document_detail/2848078.html) operation to add the episode.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeletePlaylistItemsRequest
        @return: DeletePlaylistItemsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_playlist_items_with_options(request, runtime)

    async def delete_playlist_items_async(
        self,
        request: live_20161101_models.DeletePlaylistItemsRequest,
    ) -> live_20161101_models.DeletePlaylistItemsResponse:
        """
        @summary Removes episodes from an episode list.
        
        @description Before you call this operation to remove an episode, make sure that you have called the [AddPlaylistItems](https://help.aliyun.com/document_detail/2848078.html) operation to add the episode.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeletePlaylistItemsRequest
        @return: DeletePlaylistItemsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_playlist_items_with_options_async(request, runtime)

    def delete_rtc_asr_task_with_options(
        self,
        request: live_20161101_models.DeleteRtcAsrTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteRtcAsrTaskResponse:
        """
        @summary Deletes a live subtitle task.
        
        @description You can call this operation up to 20 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteRtcAsrTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRtcAsrTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRtcAsrTask',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteRtcAsrTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_rtc_asr_task_with_options_async(
        self,
        request: live_20161101_models.DeleteRtcAsrTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteRtcAsrTaskResponse:
        """
        @summary Deletes a live subtitle task.
        
        @description You can call this operation up to 20 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteRtcAsrTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRtcAsrTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRtcAsrTask',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteRtcAsrTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_rtc_asr_task(
        self,
        request: live_20161101_models.DeleteRtcAsrTaskRequest,
    ) -> live_20161101_models.DeleteRtcAsrTaskResponse:
        """
        @summary Deletes a live subtitle task.
        
        @description You can call this operation up to 20 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteRtcAsrTaskRequest
        @return: DeleteRtcAsrTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_rtc_asr_task_with_options(request, runtime)

    async def delete_rtc_asr_task_async(
        self,
        request: live_20161101_models.DeleteRtcAsrTaskRequest,
    ) -> live_20161101_models.DeleteRtcAsrTaskResponse:
        """
        @summary Deletes a live subtitle task.
        
        @description You can call this operation up to 20 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteRtcAsrTaskRequest
        @return: DeleteRtcAsrTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_rtc_asr_task_with_options_async(request, runtime)

    def delete_rtc_mpuevent_sub_with_options(
        self,
        request: live_20161101_models.DeleteRtcMPUEventSubRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteRtcMPUEventSubResponse:
        """
        @summary Deletes a subscription to mixed-stream relay events.
        
        @description    You can call this operation to delete a subscription to mixed-stream relay events.
        Before you call this operation, make sure that you have called the CreateRtcMPUEventSub operation to create the subscription.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteRtcMPUEventSubRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRtcMPUEventSubResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRtcMPUEventSub',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteRtcMPUEventSubResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_rtc_mpuevent_sub_with_options_async(
        self,
        request: live_20161101_models.DeleteRtcMPUEventSubRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteRtcMPUEventSubResponse:
        """
        @summary Deletes a subscription to mixed-stream relay events.
        
        @description    You can call this operation to delete a subscription to mixed-stream relay events.
        Before you call this operation, make sure that you have called the CreateRtcMPUEventSub operation to create the subscription.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteRtcMPUEventSubRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRtcMPUEventSubResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRtcMPUEventSub',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteRtcMPUEventSubResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_rtc_mpuevent_sub(
        self,
        request: live_20161101_models.DeleteRtcMPUEventSubRequest,
    ) -> live_20161101_models.DeleteRtcMPUEventSubResponse:
        """
        @summary Deletes a subscription to mixed-stream relay events.
        
        @description    You can call this operation to delete a subscription to mixed-stream relay events.
        Before you call this operation, make sure that you have called the CreateRtcMPUEventSub operation to create the subscription.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteRtcMPUEventSubRequest
        @return: DeleteRtcMPUEventSubResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_rtc_mpuevent_sub_with_options(request, runtime)

    async def delete_rtc_mpuevent_sub_async(
        self,
        request: live_20161101_models.DeleteRtcMPUEventSubRequest,
    ) -> live_20161101_models.DeleteRtcMPUEventSubResponse:
        """
        @summary Deletes a subscription to mixed-stream relay events.
        
        @description    You can call this operation to delete a subscription to mixed-stream relay events.
        Before you call this operation, make sure that you have called the CreateRtcMPUEventSub operation to create the subscription.
        ## [](#qps-)QPS limit
        You can call this operation up to 50 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DeleteRtcMPUEventSubRequest
        @return: DeleteRtcMPUEventSubResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_rtc_mpuevent_sub_with_options_async(request, runtime)

    def delete_snapshot_callback_auth_with_options(
        self,
        request: live_20161101_models.DeleteSnapshotCallbackAuthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteSnapshotCallbackAuthResponse:
        """
        @summary Deletes the configuration of authentication for snapshot callbacks.
        
        @description You can call this operation to delete the configuration of authentication for snapshot callbacks for a main streaming domain. For an ongoing live stream, the deletion takes effect after you re-ingest the stream. Snapshot callbacks for the stream are no longer authenticated.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteSnapshotCallbackAuthRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSnapshotCallbackAuthResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSnapshotCallbackAuth',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteSnapshotCallbackAuthResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_snapshot_callback_auth_with_options_async(
        self,
        request: live_20161101_models.DeleteSnapshotCallbackAuthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteSnapshotCallbackAuthResponse:
        """
        @summary Deletes the configuration of authentication for snapshot callbacks.
        
        @description You can call this operation to delete the configuration of authentication for snapshot callbacks for a main streaming domain. For an ongoing live stream, the deletion takes effect after you re-ingest the stream. Snapshot callbacks for the stream are no longer authenticated.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteSnapshotCallbackAuthRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSnapshotCallbackAuthResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSnapshotCallbackAuth',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteSnapshotCallbackAuthResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_snapshot_callback_auth(
        self,
        request: live_20161101_models.DeleteSnapshotCallbackAuthRequest,
    ) -> live_20161101_models.DeleteSnapshotCallbackAuthResponse:
        """
        @summary Deletes the configuration of authentication for snapshot callbacks.
        
        @description You can call this operation to delete the configuration of authentication for snapshot callbacks for a main streaming domain. For an ongoing live stream, the deletion takes effect after you re-ingest the stream. Snapshot callbacks for the stream are no longer authenticated.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteSnapshotCallbackAuthRequest
        @return: DeleteSnapshotCallbackAuthResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_snapshot_callback_auth_with_options(request, runtime)

    async def delete_snapshot_callback_auth_async(
        self,
        request: live_20161101_models.DeleteSnapshotCallbackAuthRequest,
    ) -> live_20161101_models.DeleteSnapshotCallbackAuthResponse:
        """
        @summary Deletes the configuration of authentication for snapshot callbacks.
        
        @description You can call this operation to delete the configuration of authentication for snapshot callbacks for a main streaming domain. For an ongoing live stream, the deletion takes effect after you re-ingest the stream. Snapshot callbacks for the stream are no longer authenticated.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteSnapshotCallbackAuthRequest
        @return: DeleteSnapshotCallbackAuthResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_snapshot_callback_auth_with_options_async(request, runtime)

    def delete_snapshot_files_with_options(
        self,
        request: live_20161101_models.DeleteSnapshotFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteSnapshotFilesResponse:
        """
        @summary Deletes snapshots.
        
        @description You can delete only snapshots that were captured in the last year.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteSnapshotFilesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSnapshotFilesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.create_timestamp_list):
            query['CreateTimestampList'] = request.create_timestamp_list
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.remove_file):
            query['RemoveFile'] = request.remove_file
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSnapshotFiles',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteSnapshotFilesResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_snapshot_files_with_options_async(
        self,
        request: live_20161101_models.DeleteSnapshotFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteSnapshotFilesResponse:
        """
        @summary Deletes snapshots.
        
        @description You can delete only snapshots that were captured in the last year.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteSnapshotFilesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSnapshotFilesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.create_timestamp_list):
            query['CreateTimestampList'] = request.create_timestamp_list
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.remove_file):
            query['RemoveFile'] = request.remove_file
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSnapshotFiles',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteSnapshotFilesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_snapshot_files(
        self,
        request: live_20161101_models.DeleteSnapshotFilesRequest,
    ) -> live_20161101_models.DeleteSnapshotFilesResponse:
        """
        @summary Deletes snapshots.
        
        @description You can delete only snapshots that were captured in the last year.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteSnapshotFilesRequest
        @return: DeleteSnapshotFilesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_snapshot_files_with_options(request, runtime)

    async def delete_snapshot_files_async(
        self,
        request: live_20161101_models.DeleteSnapshotFilesRequest,
    ) -> live_20161101_models.DeleteSnapshotFilesResponse:
        """
        @summary Deletes snapshots.
        
        @description You can delete only snapshots that were captured in the last year.
        ## [](#qps-)QPS limit
        You can call this operation up to 30 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteSnapshotFilesRequest
        @return: DeleteSnapshotFilesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_snapshot_files_with_options_async(request, runtime)

    def delete_studio_layout_with_options(
        self,
        request: live_20161101_models.DeleteStudioLayoutRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteStudioLayoutResponse:
        """
        @summary Deletes a layout in a virtual studio.
        
        @description You can call this operation to delete a layout in a virtual studio. You can delete only one layout in a call.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteStudioLayoutRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteStudioLayoutResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.layout_id):
            query['LayoutId'] = request.layout_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteStudioLayout',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteStudioLayoutResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_studio_layout_with_options_async(
        self,
        request: live_20161101_models.DeleteStudioLayoutRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DeleteStudioLayoutResponse:
        """
        @summary Deletes a layout in a virtual studio.
        
        @description You can call this operation to delete a layout in a virtual studio. You can delete only one layout in a call.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteStudioLayoutRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteStudioLayoutResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.layout_id):
            query['LayoutId'] = request.layout_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteStudioLayout',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DeleteStudioLayoutResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_studio_layout(
        self,
        request: live_20161101_models.DeleteStudioLayoutRequest,
    ) -> live_20161101_models.DeleteStudioLayoutResponse:
        """
        @summary Deletes a layout in a virtual studio.
        
        @description You can call this operation to delete a layout in a virtual studio. You can delete only one layout in a call.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteStudioLayoutRequest
        @return: DeleteStudioLayoutResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_studio_layout_with_options(request, runtime)

    async def delete_studio_layout_async(
        self,
        request: live_20161101_models.DeleteStudioLayoutRequest,
    ) -> live_20161101_models.DeleteStudioLayoutResponse:
        """
        @summary Deletes a layout in a virtual studio.
        
        @description You can call this operation to delete a layout in a virtual studio. You can delete only one layout in a call.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteStudioLayoutRequest
        @return: DeleteStudioLayoutResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_studio_layout_with_options_async(request, runtime)

    def describe_auto_show_list_tasks_with_options(
        self,
        request: live_20161101_models.DescribeAutoShowListTasksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DescribeAutoShowListTasksResponse:
        """
        @summary Queries scheduled tasks that are used to start and stop playing an episode list at specified points in time.
        
        @description You can call this operation to query scheduled tasks that are used to start and stop playing an episode list at specified points in time. Make sure that the parameter settings meet the requirements.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeAutoShowListTasksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAutoShowListTasksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAutoShowListTasks',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DescribeAutoShowListTasksResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_auto_show_list_tasks_with_options_async(
        self,
        request: live_20161101_models.DescribeAutoShowListTasksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DescribeAutoShowListTasksResponse:
        """
        @summary Queries scheduled tasks that are used to start and stop playing an episode list at specified points in time.
        
        @description You can call this operation to query scheduled tasks that are used to start and stop playing an episode list at specified points in time. Make sure that the parameter settings meet the requirements.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeAutoShowListTasksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAutoShowListTasksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAutoShowListTasks',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DescribeAutoShowListTasksResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_auto_show_list_tasks(
        self,
        request: live_20161101_models.DescribeAutoShowListTasksRequest,
    ) -> live_20161101_models.DescribeAutoShowListTasksResponse:
        """
        @summary Queries scheduled tasks that are used to start and stop playing an episode list at specified points in time.
        
        @description You can call this operation to query scheduled tasks that are used to start and stop playing an episode list at specified points in time. Make sure that the parameter settings meet the requirements.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeAutoShowListTasksRequest
        @return: DescribeAutoShowListTasksResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_auto_show_list_tasks_with_options(request, runtime)

    async def describe_auto_show_list_tasks_async(
        self,
        request: live_20161101_models.DescribeAutoShowListTasksRequest,
    ) -> live_20161101_models.DescribeAutoShowListTasksResponse:
        """
        @summary Queries scheduled tasks that are used to start and stop playing an episode list at specified points in time.
        
        @description You can call this operation to query scheduled tasks that are used to start and stop playing an episode list at specified points in time. Make sure that the parameter settings meet the requirements.
        ## [](#qps-)QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeAutoShowListTasksRequest
        @return: DescribeAutoShowListTasksResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_auto_show_list_tasks_with_options_async(request, runtime)

    def describe_caster_channels_with_options(
        self,
        request: live_20161101_models.DescribeCasterChannelsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DescribeCasterChannelsResponse:
        """
        @summary Queries the channels of a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation to create a production studio and then call this operation to query the channels of the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCasterChannelsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCasterChannelsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCasterChannels',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DescribeCasterChannelsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_caster_channels_with_options_async(
        self,
        request: live_20161101_models.DescribeCasterChannelsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DescribeCasterChannelsResponse:
        """
        @summary Queries the channels of a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation to create a production studio and then call this operation to query the channels of the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCasterChannelsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCasterChannelsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCasterChannels',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DescribeCasterChannelsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_caster_channels(
        self,
        request: live_20161101_models.DescribeCasterChannelsRequest,
    ) -> live_20161101_models.DescribeCasterChannelsResponse:
        """
        @summary Queries the channels of a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation to create a production studio and then call this operation to query the channels of the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCasterChannelsRequest
        @return: DescribeCasterChannelsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_caster_channels_with_options(request, runtime)

    async def describe_caster_channels_async(
        self,
        request: live_20161101_models.DescribeCasterChannelsRequest,
    ) -> live_20161101_models.DescribeCasterChannelsResponse:
        """
        @summary Queries the channels of a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation to create a production studio and then call this operation to query the channels of the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCasterChannelsRequest
        @return: DescribeCasterChannelsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_caster_channels_with_options_async(request, runtime)

    def describe_caster_components_with_options(
        self,
        request: live_20161101_models.DescribeCasterComponentsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DescribeCasterComponentsResponse:
        """
        @summary Queries the components of a production studio.
        
        @description You can call the [AddCasterComponent](https://help.aliyun.com/document_detail/2848030.html) operation to add components to a production studio and then call this operation to query the components of the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCasterComponentsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCasterComponentsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.component_id):
            query['ComponentId'] = request.component_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCasterComponents',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DescribeCasterComponentsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_caster_components_with_options_async(
        self,
        request: live_20161101_models.DescribeCasterComponentsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DescribeCasterComponentsResponse:
        """
        @summary Queries the components of a production studio.
        
        @description You can call the [AddCasterComponent](https://help.aliyun.com/document_detail/2848030.html) operation to add components to a production studio and then call this operation to query the components of the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCasterComponentsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCasterComponentsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.component_id):
            query['ComponentId'] = request.component_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCasterComponents',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DescribeCasterComponentsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_caster_components(
        self,
        request: live_20161101_models.DescribeCasterComponentsRequest,
    ) -> live_20161101_models.DescribeCasterComponentsResponse:
        """
        @summary Queries the components of a production studio.
        
        @description You can call the [AddCasterComponent](https://help.aliyun.com/document_detail/2848030.html) operation to add components to a production studio and then call this operation to query the components of the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCasterComponentsRequest
        @return: DescribeCasterComponentsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_caster_components_with_options(request, runtime)

    async def describe_caster_components_async(
        self,
        request: live_20161101_models.DescribeCasterComponentsRequest,
    ) -> live_20161101_models.DescribeCasterComponentsResponse:
        """
        @summary Queries the components of a production studio.
        
        @description You can call the [AddCasterComponent](https://help.aliyun.com/document_detail/2848030.html) operation to add components to a production studio and then call this operation to query the components of the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCasterComponentsRequest
        @return: DescribeCasterComponentsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_caster_components_with_options_async(request, runtime)

    def describe_caster_config_with_options(
        self,
        request: live_20161101_models.DescribeCasterConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DescribeCasterConfigResponse:
        """
        @summary Queries the configurations of a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation to create a production studio and then call this operation to query the configurations of the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCasterConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCasterConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCasterConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DescribeCasterConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_caster_config_with_options_async(
        self,
        request: live_20161101_models.DescribeCasterConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DescribeCasterConfigResponse:
        """
        @summary Queries the configurations of a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation to create a production studio and then call this operation to query the configurations of the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCasterConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCasterConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCasterConfig',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DescribeCasterConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_caster_config(
        self,
        request: live_20161101_models.DescribeCasterConfigRequest,
    ) -> live_20161101_models.DescribeCasterConfigResponse:
        """
        @summary Queries the configurations of a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation to create a production studio and then call this operation to query the configurations of the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCasterConfigRequest
        @return: DescribeCasterConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_caster_config_with_options(request, runtime)

    async def describe_caster_config_async(
        self,
        request: live_20161101_models.DescribeCasterConfigRequest,
    ) -> live_20161101_models.DescribeCasterConfigResponse:
        """
        @summary Queries the configurations of a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation to create a production studio and then call this operation to query the configurations of the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCasterConfigRequest
        @return: DescribeCasterConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_caster_config_with_options_async(request, runtime)

    def describe_caster_layouts_with_options(
        self,
        request: live_20161101_models.DescribeCasterLayoutsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DescribeCasterLayoutsResponse:
        """
        @summary Queries a specified layout or all layouts of a production studio.
        
        @description You can call this operation to query layouts of a production studio. If no layout ID is specified, the operation returns all layouts of the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCasterLayoutsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCasterLayoutsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.layout_id):
            query['LayoutId'] = request.layout_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCasterLayouts',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DescribeCasterLayoutsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_caster_layouts_with_options_async(
        self,
        request: live_20161101_models.DescribeCasterLayoutsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DescribeCasterLayoutsResponse:
        """
        @summary Queries a specified layout or all layouts of a production studio.
        
        @description You can call this operation to query layouts of a production studio. If no layout ID is specified, the operation returns all layouts of the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCasterLayoutsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCasterLayoutsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.layout_id):
            query['LayoutId'] = request.layout_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCasterLayouts',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DescribeCasterLayoutsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_caster_layouts(
        self,
        request: live_20161101_models.DescribeCasterLayoutsRequest,
    ) -> live_20161101_models.DescribeCasterLayoutsResponse:
        """
        @summary Queries a specified layout or all layouts of a production studio.
        
        @description You can call this operation to query layouts of a production studio. If no layout ID is specified, the operation returns all layouts of the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCasterLayoutsRequest
        @return: DescribeCasterLayoutsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_caster_layouts_with_options(request, runtime)

    async def describe_caster_layouts_async(
        self,
        request: live_20161101_models.DescribeCasterLayoutsRequest,
    ) -> live_20161101_models.DescribeCasterLayoutsResponse:
        """
        @summary Queries a specified layout or all layouts of a production studio.
        
        @description You can call this operation to query layouts of a production studio. If no layout ID is specified, the operation returns all layouts of the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCasterLayoutsRequest
        @return: DescribeCasterLayoutsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_caster_layouts_with_options_async(request, runtime)

    def describe_caster_program_with_options(
        self,
        request: live_20161101_models.DescribeCasterProgramRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DescribeCasterProgramResponse:
        """
        @summary Queries the information about the episode list for carousel playback in a production studio.
        
        @description You can call this operation to query episodes in the episode list for carousel playback. The supported types of episodes include video resource and component.
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCasterProgramRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCasterProgramResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.episode_id):
            query['EpisodeId'] = request.episode_id
        if not UtilClient.is_unset(request.episode_type):
            query['EpisodeType'] = request.episode_type
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCasterProgram',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DescribeCasterProgramResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_caster_program_with_options_async(
        self,
        request: live_20161101_models.DescribeCasterProgramRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DescribeCasterProgramResponse:
        """
        @summary Queries the information about the episode list for carousel playback in a production studio.
        
        @description You can call this operation to query episodes in the episode list for carousel playback. The supported types of episodes include video resource and component.
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCasterProgramRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCasterProgramResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.episode_id):
            query['EpisodeId'] = request.episode_id
        if not UtilClient.is_unset(request.episode_type):
            query['EpisodeType'] = request.episode_type
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCasterProgram',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DescribeCasterProgramResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_caster_program(
        self,
        request: live_20161101_models.DescribeCasterProgramRequest,
    ) -> live_20161101_models.DescribeCasterProgramResponse:
        """
        @summary Queries the information about the episode list for carousel playback in a production studio.
        
        @description You can call this operation to query episodes in the episode list for carousel playback. The supported types of episodes include video resource and component.
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCasterProgramRequest
        @return: DescribeCasterProgramResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_caster_program_with_options(request, runtime)

    async def describe_caster_program_async(
        self,
        request: live_20161101_models.DescribeCasterProgramRequest,
    ) -> live_20161101_models.DescribeCasterProgramResponse:
        """
        @summary Queries the information about the episode list for carousel playback in a production studio.
        
        @description You can call this operation to query episodes in the episode list for carousel playback. The supported types of episodes include video resource and component.
        ## [](#qps-)QPS limit
        You can call this operation up to 4 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCasterProgramRequest
        @return: DescribeCasterProgramResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_caster_program_with_options_async(request, runtime)

    def describe_caster_scene_audio_with_options(
        self,
        request: live_20161101_models.DescribeCasterSceneAudioRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DescribeCasterSceneAudioResponse:
        """
        @summary Queries the audio configurations of a scene.
        
        @description ## [](#)Usage notes
        You can call the [CreateCaster](https://help.aliyun.com/document_detail/69338.html) operation to create a production studio and then call this operation to query the audio configurations of a scene in the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DescribeCasterSceneAudioRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCasterSceneAudioResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.scene_id):
            query['SceneId'] = request.scene_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCasterSceneAudio',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DescribeCasterSceneAudioResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_caster_scene_audio_with_options_async(
        self,
        request: live_20161101_models.DescribeCasterSceneAudioRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DescribeCasterSceneAudioResponse:
        """
        @summary Queries the audio configurations of a scene.
        
        @description ## [](#)Usage notes
        You can call the [CreateCaster](https://help.aliyun.com/document_detail/69338.html) operation to create a production studio and then call this operation to query the audio configurations of a scene in the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DescribeCasterSceneAudioRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCasterSceneAudioResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.scene_id):
            query['SceneId'] = request.scene_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCasterSceneAudio',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DescribeCasterSceneAudioResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_caster_scene_audio(
        self,
        request: live_20161101_models.DescribeCasterSceneAudioRequest,
    ) -> live_20161101_models.DescribeCasterSceneAudioResponse:
        """
        @summary Queries the audio configurations of a scene.
        
        @description ## [](#)Usage notes
        You can call the [CreateCaster](https://help.aliyun.com/document_detail/69338.html) operation to create a production studio and then call this operation to query the audio configurations of a scene in the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DescribeCasterSceneAudioRequest
        @return: DescribeCasterSceneAudioResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_caster_scene_audio_with_options(request, runtime)

    async def describe_caster_scene_audio_async(
        self,
        request: live_20161101_models.DescribeCasterSceneAudioRequest,
    ) -> live_20161101_models.DescribeCasterSceneAudioResponse:
        """
        @summary Queries the audio configurations of a scene.
        
        @description ## [](#)Usage notes
        You can call the [CreateCaster](https://help.aliyun.com/document_detail/69338.html) operation to create a production studio and then call this operation to query the audio configurations of a scene in the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DescribeCasterSceneAudioRequest
        @return: DescribeCasterSceneAudioResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_caster_scene_audio_with_options_async(request, runtime)

    def describe_caster_scenes_with_options(
        self,
        request: live_20161101_models.DescribeCasterScenesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DescribeCasterScenesResponse:
        """
        @summary Queries the scenes of a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/69338.html) operation to create a production studio and then call this operation to query the scenes of the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DescribeCasterScenesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCasterScenesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.scene_id):
            query['SceneId'] = request.scene_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCasterScenes',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DescribeCasterScenesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_caster_scenes_with_options_async(
        self,
        request: live_20161101_models.DescribeCasterScenesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DescribeCasterScenesResponse:
        """
        @summary Queries the scenes of a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/69338.html) operation to create a production studio and then call this operation to query the scenes of the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DescribeCasterScenesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCasterScenesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.scene_id):
            query['SceneId'] = request.scene_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCasterScenes',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DescribeCasterScenesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_caster_scenes(
        self,
        request: live_20161101_models.DescribeCasterScenesRequest,
    ) -> live_20161101_models.DescribeCasterScenesResponse:
        """
        @summary Queries the scenes of a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/69338.html) operation to create a production studio and then call this operation to query the scenes of the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DescribeCasterScenesRequest
        @return: DescribeCasterScenesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_caster_scenes_with_options(request, runtime)

    async def describe_caster_scenes_async(
        self,
        request: live_20161101_models.DescribeCasterScenesRequest,
    ) -> live_20161101_models.DescribeCasterScenesResponse:
        """
        @summary Queries the scenes of a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/69338.html) operation to create a production studio and then call this operation to query the scenes of the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation. For more information, see [QPS limits](https://help.aliyun.com/document_detail/343507.html).
        
        @param request: DescribeCasterScenesRequest
        @return: DescribeCasterScenesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_caster_scenes_with_options_async(request, runtime)

    def describe_caster_stream_url_with_options(
        self,
        request: live_20161101_models.DescribeCasterStreamUrlRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DescribeCasterStreamUrlResponse:
        """
        @summary Queries the streaming URLs of a production studio.
        
        @description You must create a production studio before calling this operation to query the information.
        ## QPS limit
        A single user can perform a maximum of 15 queries per second (QPS). Throttling is triggered when the number of calls per second exceeds the QPS limit. The throttling may affect your business. Thus, we recommend that you observe the QPS limit on this operation. For more information about what a single user means and the QPS details, see [QPS limit on an API operation in ApsaraVideo Live](https://www.alibabacloud.com/help/en/apsaravideo-live/latest/qps-limit-on-an-api-operation-in-apsaravideo-live#topic-2136805).
        
        @param request: DescribeCasterStreamUrlRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCasterStreamUrlResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCasterStreamUrl',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DescribeCasterStreamUrlResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_caster_stream_url_with_options_async(
        self,
        request: live_20161101_models.DescribeCasterStreamUrlRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DescribeCasterStreamUrlResponse:
        """
        @summary Queries the streaming URLs of a production studio.
        
        @description You must create a production studio before calling this operation to query the information.
        ## QPS limit
        A single user can perform a maximum of 15 queries per second (QPS). Throttling is triggered when the number of calls per second exceeds the QPS limit. The throttling may affect your business. Thus, we recommend that you observe the QPS limit on this operation. For more information about what a single user means and the QPS details, see [QPS limit on an API operation in ApsaraVideo Live](https://www.alibabacloud.com/help/en/apsaravideo-live/latest/qps-limit-on-an-api-operation-in-apsaravideo-live#topic-2136805).
        
        @param request: DescribeCasterStreamUrlRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCasterStreamUrlResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCasterStreamUrl',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DescribeCasterStreamUrlResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_caster_stream_url(
        self,
        request: live_20161101_models.DescribeCasterStreamUrlRequest,
    ) -> live_20161101_models.DescribeCasterStreamUrlResponse:
        """
        @summary Queries the streaming URLs of a production studio.
        
        @description You must create a production studio before calling this operation to query the information.
        ## QPS limit
        A single user can perform a maximum of 15 queries per second (QPS). Throttling is triggered when the number of calls per second exceeds the QPS limit. The throttling may affect your business. Thus, we recommend that you observe the QPS limit on this operation. For more information about what a single user means and the QPS details, see [QPS limit on an API operation in ApsaraVideo Live](https://www.alibabacloud.com/help/en/apsaravideo-live/latest/qps-limit-on-an-api-operation-in-apsaravideo-live#topic-2136805).
        
        @param request: DescribeCasterStreamUrlRequest
        @return: DescribeCasterStreamUrlResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_caster_stream_url_with_options(request, runtime)

    async def describe_caster_stream_url_async(
        self,
        request: live_20161101_models.DescribeCasterStreamUrlRequest,
    ) -> live_20161101_models.DescribeCasterStreamUrlResponse:
        """
        @summary Queries the streaming URLs of a production studio.
        
        @description You must create a production studio before calling this operation to query the information.
        ## QPS limit
        A single user can perform a maximum of 15 queries per second (QPS). Throttling is triggered when the number of calls per second exceeds the QPS limit. The throttling may affect your business. Thus, we recommend that you observe the QPS limit on this operation. For more information about what a single user means and the QPS details, see [QPS limit on an API operation in ApsaraVideo Live](https://www.alibabacloud.com/help/en/apsaravideo-live/latest/qps-limit-on-an-api-operation-in-apsaravideo-live#topic-2136805).
        
        @param request: DescribeCasterStreamUrlRequest
        @return: DescribeCasterStreamUrlResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_caster_stream_url_with_options_async(request, runtime)

    def describe_caster_video_resources_with_options(
        self,
        request: live_20161101_models.DescribeCasterVideoResourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DescribeCasterVideoResourcesResponse:
        """
        @summary Queries the input sources of a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation to create a production studio and then call this operation to query the input sources of the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCasterVideoResourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCasterVideoResourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCasterVideoResources',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DescribeCasterVideoResourcesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_caster_video_resources_with_options_async(
        self,
        request: live_20161101_models.DescribeCasterVideoResourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DescribeCasterVideoResourcesResponse:
        """
        @summary Queries the input sources of a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation to create a production studio and then call this operation to query the input sources of the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCasterVideoResourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCasterVideoResourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCasterVideoResources',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DescribeCasterVideoResourcesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_caster_video_resources(
        self,
        request: live_20161101_models.DescribeCasterVideoResourcesRequest,
    ) -> live_20161101_models.DescribeCasterVideoResourcesResponse:
        """
        @summary Queries the input sources of a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation to create a production studio and then call this operation to query the input sources of the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCasterVideoResourcesRequest
        @return: DescribeCasterVideoResourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_caster_video_resources_with_options(request, runtime)

    async def describe_caster_video_resources_async(
        self,
        request: live_20161101_models.DescribeCasterVideoResourcesRequest,
    ) -> live_20161101_models.DescribeCasterVideoResourcesResponse:
        """
        @summary Queries the input sources of a production studio.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation to create a production studio and then call this operation to query the input sources of the production studio.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCasterVideoResourcesRequest
        @return: DescribeCasterVideoResourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_caster_video_resources_with_options_async(request, runtime)

    def describe_casters_with_options(
        self,
        request: live_20161101_models.DescribeCastersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DescribeCastersResponse:
        """
        @summary Queries the list of production studios.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/2848012.html) operation to create a production studio and then call this operation to query the production studio list. The status of a production studio can be idle or streaming.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCastersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCastersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.caster_name):
            query['CasterName'] = request.caster_name
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.norm_type):
            query['NormType'] = request.norm_type
        if not UtilClient.is_unset(request.order_by_modify_asc):
            query['OrderByModifyAsc'] = request.order_by_modify_asc
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCasters',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DescribeCastersResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_casters_with_options_async(
        self,
        request: live_20161101_models.DescribeCastersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DescribeCastersResponse:
        """
        @summary Queries the list of production studios.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/2848012.html) operation to create a production studio and then call this operation to query the production studio list. The status of a production studio can be idle or streaming.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCastersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCastersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.caster_id):
            query['CasterId'] = request.caster_id
        if not UtilClient.is_unset(request.caster_name):
            query['CasterName'] = request.caster_name
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.norm_type):
            query['NormType'] = request.norm_type
        if not UtilClient.is_unset(request.order_by_modify_asc):
            query['OrderByModifyAsc'] = request.order_by_modify_asc
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCasters',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DescribeCastersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_casters(
        self,
        request: live_20161101_models.DescribeCastersRequest,
    ) -> live_20161101_models.DescribeCastersResponse:
        """
        @summary Queries the list of production studios.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/2848012.html) operation to create a production studio and then call this operation to query the production studio list. The status of a production studio can be idle or streaming.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCastersRequest
        @return: DescribeCastersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_casters_with_options(request, runtime)

    async def describe_casters_async(
        self,
        request: live_20161101_models.DescribeCastersRequest,
    ) -> live_20161101_models.DescribeCastersResponse:
        """
        @summary Queries the list of production studios.
        
        @description You can call the [CreateCaster](https://help.aliyun.com/document_detail/2848012.html) operation to create a production studio and then call this operation to query the production studio list. The status of a production studio can be idle or streaming.
        ## [](#qps-)QPS limit
        You can call this operation up to 15 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeCastersRequest
        @return: DescribeCastersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_casters_with_options_async(request, runtime)

    def describe_channel_participants_with_options(
        self,
        request: live_20161101_models.DescribeChannelParticipantsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DescribeChannelParticipantsResponse:
        """
        @summary Queries online users in a channel.
        
        @description You can call this operation to query online users in a channel. The returned result does not include details about the users.
        ## [](#qps-)QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeChannelParticipantsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeChannelParticipantsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.channel_id):
            query['ChannelId'] = request.channel_id
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeChannelParticipants',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DescribeChannelParticipantsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_channel_participants_with_options_async(
        self,
        request: live_20161101_models.DescribeChannelParticipantsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DescribeChannelParticipantsResponse:
        """
        @summary Queries online users in a channel.
        
        @description You can call this operation to query online users in a channel. The returned result does not include details about the users.
        ## [](#qps-)QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeChannelParticipantsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeChannelParticipantsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.channel_id):
            query['ChannelId'] = request.channel_id
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeChannelParticipants',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DescribeChannelParticipantsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_channel_participants(
        self,
        request: live_20161101_models.DescribeChannelParticipantsRequest,
    ) -> live_20161101_models.DescribeChannelParticipantsResponse:
        """
        @summary Queries online users in a channel.
        
        @description You can call this operation to query online users in a channel. The returned result does not include details about the users.
        ## [](#qps-)QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeChannelParticipantsRequest
        @return: DescribeChannelParticipantsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_channel_participants_with_options(request, runtime)

    async def describe_channel_participants_async(
        self,
        request: live_20161101_models.DescribeChannelParticipantsRequest,
    ) -> live_20161101_models.DescribeChannelParticipantsResponse:
        """
        @summary Queries online users in a channel.
        
        @description You can call this operation to query online users in a channel. The returned result does not include details about the users.
        ## [](#qps-)QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeChannelParticipantsRequest
        @return: DescribeChannelParticipantsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_channel_participants_with_options_async(request, runtime)

    def describe_channel_users_with_options(
        self,
        request: live_20161101_models.DescribeChannelUsersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DescribeChannelUsersResponse:
        """
        @summary Queries the details of online users in a channel.
        
        @description You can call this operation to query information about online users in a channel, such as the total number of users during live streaming.
        ## [](#qps-)QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeChannelUsersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeChannelUsersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.channel_id):
            query['ChannelId'] = request.channel_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeChannelUsers',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DescribeChannelUsersResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_channel_users_with_options_async(
        self,
        request: live_20161101_models.DescribeChannelUsersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DescribeChannelUsersResponse:
        """
        @summary Queries the details of online users in a channel.
        
        @description You can call this operation to query information about online users in a channel, such as the total number of users during live streaming.
        ## [](#qps-)QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeChannelUsersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeChannelUsersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.channel_id):
            query['ChannelId'] = request.channel_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeChannelUsers',
            version='2016-11-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            live_20161101_models.DescribeChannelUsersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_channel_users(
        self,
        request: live_20161101_models.DescribeChannelUsersRequest,
    ) -> live_20161101_models.DescribeChannelUsersResponse:
        """
        @summary Queries the details of online users in a channel.
        
        @description You can call this operation to query information about online users in a channel, such as the total number of users during live streaming.
        ## [](#qps-)QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeChannelUsersRequest
        @return: DescribeChannelUsersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_channel_users_with_options(request, runtime)

    async def describe_channel_users_async(
        self,
        request: live_20161101_models.DescribeChannelUsersRequest,
    ) -> live_20161101_models.DescribeChannelUsersResponse:
        """
        @summary Queries the details of online users in a channel.
        
        @description You can call this operation to query information about online users in a channel, such as the total number of users during live streaming.
        ## [](#qps-)QPS limit
        You can call this operation up to 100 times per second per account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeChannelUsersRequest
        @return: DescribeChannelUsersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_channel_users_with_options_async(request, runtime)

    def describe_domain_usage_data_with_options(
        self,
        request: live_20161101_models.DescribeDomainUsageDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> live_20161101_models.DescribeDomainUsageDataResponse:
        """
        @summary Queries the resource usage data of specific domain names in a specified billable region.
        
        @description  You can query the resource usage data of up to 100 domain names at a time. Separate multiple domain names with commas (,). If you do not specify the DomainName parameter, the resource usage data of all domain names within your Alibaba Cloud account is returned.
        The resource usage data includes network traffic that is measured in bytes, bandwidth that is measured in bit/s, and the number of requests.
        If you do not specify the Interval parameter, you can query the resource usage data in the last 12 months that spans a period of up to 31 days per call. If you specify a time range of 1 to 3 days in a call, the time interval between the entries that are returned is 1 hour. If you specify a time range of more than 3 days in a call, the time interval between the entries that are returned is 1 day.
        The following table describes the maximum time range per query, the time period within which historical data is available, and the data delay if you specify the Interval parameter.
        |Time granularity|Maximum time range per query|Historical data available|Data delay|
        |---|---|---|---|
        |5 minutes|3 days|93 days|15 minutes|
        |1 hour|31 days|186 days|4 hours|
        |1 day|90 days|366 days|04:00 on the next day|
        ## QPS limit
        You can call this operation up to 10 times per second per account. Requests that exceed this limit are dropped and you will experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DescribeDomainUsageDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDomainUsageDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.area):
            query['Area'] = request.area
        if not UtilClient.is_unset(request.data_protocol):
            query['DataProtocol'] = request.data_protocol
        if not UtilClient.is_unset(request.domain_name):
            query['Do