# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Dict, Any


class AppInfoDTOPlatforms(TeaModel):
    def __init__(
        self,
        item_id: str = None,
        license_item_ids: List[str] = None,
        pkg_name: str = None,
        pkg_signature: str = None,
        platform_type: int = None,
        type: int = None,
    ):
        self.item_id = item_id
        self.license_item_ids = license_item_ids
        self.pkg_name = pkg_name
        self.pkg_signature = pkg_signature
        self.platform_type = platform_type
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.license_item_ids is not None:
            result['LicenseItemIds'] = self.license_item_ids
        if self.pkg_name is not None:
            result['PkgName'] = self.pkg_name
        if self.pkg_signature is not None:
            result['PkgSignature'] = self.pkg_signature
        if self.platform_type is not None:
            result['PlatformType'] = self.platform_type
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('LicenseItemIds') is not None:
            self.license_item_ids = m.get('LicenseItemIds')
        if m.get('PkgName') is not None:
            self.pkg_name = m.get('PkgName')
        if m.get('PkgSignature') is not None:
            self.pkg_signature = m.get('PkgSignature')
        if m.get('PlatformType') is not None:
            self.platform_type = m.get('PlatformType')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AppInfoDTO(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        app_type: int = None,
        creation_time: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        item_id: str = None,
        modification_time: str = None,
        platforms: List[AppInfoDTOPlatforms] = None,
        user_id: int = None,
    ):
        self.app_name = app_name
        self.app_type = app_type
        self.creation_time = creation_time
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.item_id = item_id
        self.modification_time = modification_time
        self.platforms = platforms
        self.user_id = user_id

    def validate(self):
        if self.platforms:
            for k in self.platforms:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.app_type is not None:
            result['AppType'] = self.app_type
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.modification_time is not None:
            result['ModificationTime'] = self.modification_time
        result['Platforms'] = []
        if self.platforms is not None:
            for k in self.platforms:
                result['Platforms'].append(k.to_map() if k else None)
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('AppType') is not None:
            self.app_type = m.get('AppType')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('ModificationTime') is not None:
            self.modification_time = m.get('ModificationTime')
        self.platforms = []
        if m.get('Platforms') is not None:
            for k in m.get('Platforms'):
                temp_model = AppInfoDTOPlatforms()
                self.platforms.append(temp_model.from_map(k))
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class LicenseInstanceAppDTOLicenseConfigs(TeaModel):
    def __init__(
        self,
        business_type: str = None,
        feature_ids: str = None,
        is_trial: bool = None,
        sdk_id: int = None,
        sdk_name: str = None,
        subscription: str = None,
        subscription_imp: str = None,
        subscription_pkg: str = None,
    ):
        self.business_type = business_type
        self.feature_ids = feature_ids
        self.is_trial = is_trial
        self.sdk_id = sdk_id
        self.sdk_name = sdk_name
        self.subscription = subscription
        self.subscription_imp = subscription_imp
        self.subscription_pkg = subscription_pkg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.feature_ids is not None:
            result['FeatureIds'] = self.feature_ids
        if self.is_trial is not None:
            result['IsTrial'] = self.is_trial
        if self.sdk_id is not None:
            result['SdkId'] = self.sdk_id
        if self.sdk_name is not None:
            result['SdkName'] = self.sdk_name
        if self.subscription is not None:
            result['Subscription'] = self.subscription
        if self.subscription_imp is not None:
            result['SubscriptionImp'] = self.subscription_imp
        if self.subscription_pkg is not None:
            result['SubscriptionPkg'] = self.subscription_pkg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('FeatureIds') is not None:
            self.feature_ids = m.get('FeatureIds')
        if m.get('IsTrial') is not None:
            self.is_trial = m.get('IsTrial')
        if m.get('SdkId') is not None:
            self.sdk_id = m.get('SdkId')
        if m.get('SdkName') is not None:
            self.sdk_name = m.get('SdkName')
        if m.get('Subscription') is not None:
            self.subscription = m.get('Subscription')
        if m.get('SubscriptionImp') is not None:
            self.subscription_imp = m.get('SubscriptionImp')
        if m.get('SubscriptionPkg') is not None:
            self.subscription_pkg = m.get('SubscriptionPkg')
        return self


class LicenseInstanceAppDTO(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        begin_on: str = None,
        contract_no: str = None,
        creation_time: str = None,
        expired_on: str = None,
        instance_id: str = None,
        item_id: str = None,
        license_configs: List[LicenseInstanceAppDTOLicenseConfigs] = None,
        modification_time: str = None,
        status: str = None,
        user_id: int = None,
    ):
        self.app_id = app_id
        self.begin_on = begin_on
        self.contract_no = contract_no
        self.creation_time = creation_time
        self.expired_on = expired_on
        self.instance_id = instance_id
        self.item_id = item_id
        self.license_configs = license_configs
        self.modification_time = modification_time
        self.status = status
        self.user_id = user_id

    def validate(self):
        if self.license_configs:
            for k in self.license_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.begin_on is not None:
            result['BeginOn'] = self.begin_on
        if self.contract_no is not None:
            result['ContractNo'] = self.contract_no
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.expired_on is not None:
            result['ExpiredOn'] = self.expired_on
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        result['LicenseConfigs'] = []
        if self.license_configs is not None:
            for k in self.license_configs:
                result['LicenseConfigs'].append(k.to_map() if k else None)
        if self.modification_time is not None:
            result['ModificationTime'] = self.modification_time
        if self.status is not None:
            result['Status'] = self.status
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('BeginOn') is not None:
            self.begin_on = m.get('BeginOn')
        if m.get('ContractNo') is not None:
            self.contract_no = m.get('ContractNo')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('ExpiredOn') is not None:
            self.expired_on = m.get('ExpiredOn')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        self.license_configs = []
        if m.get('LicenseConfigs') is not None:
            for k in m.get('LicenseConfigs'):
                temp_model = LicenseInstanceAppDTOLicenseConfigs()
                self.license_configs.append(temp_model.from_map(k))
        if m.get('ModificationTime') is not None:
            self.modification_time = m.get('ModificationTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class AddCasterComponentRequest(TeaModel):
    def __init__(
        self,
        caption_layer_content: str = None,
        caster_id: str = None,
        component_layer: str = None,
        component_name: str = None,
        component_type: str = None,
        effect: str = None,
        html_layer_content: str = None,
        image_layer_content: str = None,
        layer_order: str = None,
        location_id: str = None,
        owner_id: int = None,
        region_id: str = None,
        text_layer_content: str = None,
    ):
        # The information about the caption layer. This parameter contains the following fields:
        # 
        # >  This parameter is required when the ComponentType parameter is set to caption.
        # 
        # *   **SizeNormalized**: the normalized font size. The font size is set to font_size/output_height. The value range is `[0,1]` and accurate to two decimal places. If the font size calculated by the system based on the normalization method is greater than **1024**, **1024** is used.
        # *   **BorderWidthNormalized**: the normalized value of the text border width, which is calculated based on the size of the text, namely "BorderWidth/FontSize". The value range is `[0,1]` and accurate to two decimal places. If the value calculated according to the normalization method exceeds **16**, **16** is used. The default value is **0**.
        # *   **FontName**: the font name. For more information about the value, see **Font description**. The default font name is KaiTi.
        # *   **BorderColor**: the color of the text border. Valid values: 0x000000 to 0xffffff. By default, this parameter is not set. In this case, the color of the text border is transparent.
        # *   **LocationId**: the channel ID of the source subtitle.
        # *   **SourceLan**: the source language of the audio in the source video. Valid values: en, cn, es, and ru, which indicate English, Chinese, Spanish, and Russian respectively. Default value: cn.
        # *   **TargetLan**: the target audio language in the source video. If you do not specify this field, speech recognition is used. If you specify this field, translation is used. Valid values: en, cn, es, and ru, which indicate English, Chinese, Spanish, and Russian respectively. Default value: cn.
        # *   **ShowSourceLan**: specifies whether to display the source language. Valid values: true: displays the source language. false: hides the source language. Default value: false.
        # *   **Truncation**: specifies whether to allow caption truncation. Valid values: true: specifies that the caption can be truncated. false: specifies that the caption cannot be truncated. Default value: false.
        # *   **SourceLanPerLineWordCount**: the number of words displayed in each line when the subtitle is in the source language. Default value: 20.
        # *   **TargetLanPerLineWordCount**: the number of words displayed in each line when the subtitle is in the destination language. Default value: 20.
        # *   **SourceLanReservePages**: the number of lines reserved when the subtitle is in the source language. This field takes effect only when the Truncation field is set to true. Default value: 2.
        # *   **TargetLanReservePages**: the number of lines reserved when the subtitle is in the destination language. This field takes effect only when the Truncation field is set to true. Default value: 2.
        # 
        # The value is a JSON string. Use upper camel case for field names.
        self.caption_layer_content = caption_layer_content
        # The ID of the production studio.
        # 
        # *   If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation, check the value of the response parameter CasterId to obtain the ID.
        # *   If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        # 
        # >  You can find the ID of the production studio in the Instance ID/Name column.
        # 
        # This parameter is required.
        self.caster_id = caster_id
        # The information about the component layer, such as the size and layout. This parameter contains the following fields:
        # 
        # *   **HeightNormalized**: the normalized value of heights for the elements in the component layer
        # *   **WidthNormalized**: the normalized value of widths for the elements in the component layer
        # *   **PositionNormalized**: the normalized value of the coordinates of the component layer
        # *   **PositionRefer**: the reference coordinates of the component layer.
        # 
        # The value is a JSON string. Use upper camel case for field names.
        # 
        # This parameter is required.
        self.component_layer = component_layer
        # The component name. By default, the component name is the component ID.
        self.component_name = component_name
        # The component type. Valid values:
        # 
        # *   **text**: a text component. If you set ComponentType to text, you must also specify TextLayerContent.
        # *   **image**: an image component. If you set ComponentType to image, you must also specify ImageLayerContent.
        # *   **caption**: a caption component. If you set ComponentType to caption, you must also specify CaptionLayerContent.
        # 
        # This parameter is required.
        self.component_type = component_type
        # The effect of the component. Valid values:
        # 
        # *   **none (default)**\
        # *   **animateH**: horizontal scrolling
        # *   **animateV**: vertical scrolling
        self.effect = effect
        # The information about the HTML5 layer.
        self.html_layer_content = html_layer_content
        # The information about the image layer. This parameter contains the following fields:
        # 
        # >  This parameter is required when the ComponentType parameter is set to image.
        # 
        # MaterialId: the ID of the asset from the media asset library. The name that you set when you upload an asset is the ID of the asset.
        # 
        # The value is a JSON string. Use upper camel case for field names.
        self.image_layer_content = image_layer_content
        # The layer stacking order of the component. Valid values:
        # 
        # *   cover
        # *   background
        self.layer_order = layer_order
        # The location ID of the component. Each location ID can be assigned to only one component and must be in the RC[Number] format. The values specified by this parameter must be in ascending order, such as RC01 to RC99.
        # 
        # >  If the ComponentType parameter is set to caption, the LocationId parameter specifies the location ID of the video source referenced by the component.
        # 
        # This parameter is required.
        self.location_id = location_id
        self.owner_id = owner_id
        self.region_id = region_id
        # The information about the text layer. This parameter contains the following fields:
        # 
        # >  This parameter is available and required only when the ComponentType parameter is set to text.
        # 
        # *   **SizeNormalized**: the normalized font size. The font size is set to font_size/output_height. The value range is `[0,1]`. If the font size calculated by the system based on the normalization method is greater than 1024, 1024 is used.
        # *   **BorderWidthNormalized**: the normalized value of the text border width. The normalized value is calculated based on the size of the text, that is, "BorderWidth/FontSize". The value range is `[0,1]`. If the value calculated based on the normalization method exceeds 16, 16 is used. The default value is 0.
        # *   **FontName**: the font name. For more information about the value, see **Font description**. The default value is KaiTi.
        # *   **BorderColor**: the color of the text border. Valid values: 0x000000 to 0xffffff. By default, this parameter is not set. In this case, the color of the text border is transparent.
        # *   **Text**: the content of the text. By default, this parameter is not set. In this case, the text contains no content.
        # *   **Color**: the color of the text. The default value is 0xff0000, which indicates that the text is in red.
        # 
        # The value is a JSON string. Use upper camel case for field names.
        self.text_layer_content = text_layer_content

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caption_layer_content is not None:
            result['CaptionLayerContent'] = self.caption_layer_content
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.component_layer is not None:
            result['ComponentLayer'] = self.component_layer
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.component_type is not None:
            result['ComponentType'] = self.component_type
        if self.effect is not None:
            result['Effect'] = self.effect
        if self.html_layer_content is not None:
            result['HtmlLayerContent'] = self.html_layer_content
        if self.image_layer_content is not None:
            result['ImageLayerContent'] = self.image_layer_content
        if self.layer_order is not None:
            result['LayerOrder'] = self.layer_order
        if self.location_id is not None:
            result['LocationId'] = self.location_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.text_layer_content is not None:
            result['TextLayerContent'] = self.text_layer_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CaptionLayerContent') is not None:
            self.caption_layer_content = m.get('CaptionLayerContent')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('ComponentLayer') is not None:
            self.component_layer = m.get('ComponentLayer')
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('ComponentType') is not None:
            self.component_type = m.get('ComponentType')
        if m.get('Effect') is not None:
            self.effect = m.get('Effect')
        if m.get('HtmlLayerContent') is not None:
            self.html_layer_content = m.get('HtmlLayerContent')
        if m.get('ImageLayerContent') is not None:
            self.image_layer_content = m.get('ImageLayerContent')
        if m.get('LayerOrder') is not None:
            self.layer_order = m.get('LayerOrder')
        if m.get('LocationId') is not None:
            self.location_id = m.get('LocationId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TextLayerContent') is not None:
            self.text_layer_content = m.get('TextLayerContent')
        return self


class AddCasterComponentResponseBody(TeaModel):
    def __init__(
        self,
        component_id: str = None,
        request_id: str = None,
    ):
        # The component ID. The value can be used as the value of a request parameter to query, modify, or delete a production studio.
        self.component_id = component_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCasterComponentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddCasterComponentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCasterComponentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCasterEpisodeRequest(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        component_id: List[str] = None,
        end_time: str = None,
        episode_name: str = None,
        episode_type: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_id: str = None,
        start_time: str = None,
        switch_type: str = None,
    ):
        # The ID of the production studio.
        # 
        # *   If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation, check the value of the response parameter CasterId to obtain the ID.
        # *   If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        # 
        # >  You can find the ID of the production studio in the Instance ID/Name column.
        # 
        # This parameter is required.
        self.caster_id = caster_id
        # The components. Components in the production studio are listed from the bottom to the top in an array.
        # 
        # If a component was added by calling the [AddCasterComponent](https://help.aliyun.com/document_detail/2848030.html) operation, check the value of the response parameter ComponentId to obtain the component ID.
        # 
        # *   This parameter takes effect and is required when the EpisodeType parameter is set to **Component**.
        # *   This parameter is optional when the EpisodeType parameter is set to **Resource**. In this case, if this parameter is specified, the components are bound to and switched together with video resources.
        # 
        # >  The variable N specifies the sequence number of the component. For example, **ComponentId.1** specifies the ID of the first component and **ComponentId.2** specifies the ID of the second component.
        self.component_id = component_id
        # The time when the episode ends. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The name of the episode.
        self.episode_name = episode_name
        # The type of the episode. Valid values:
        # 
        # *   **Resource**: a video resource.
        # *   **Component**: a component.
        # 
        # This parameter is required.
        self.episode_type = episode_type
        self.owner_id = owner_id
        self.region_id = region_id
        # The ID of the video resource.
        # 
        # >  This parameter takes effect and is required when the EpisodeType parameter is set to Resource.
        # 
        # \\
        # If the video resource was added by calling the [AddCasterVideoResource](https://help.aliyun.com/document_detail/2848020.html) operation, check the value of the response parameter ResourceId to obtain the ID.
        self.resource_id = resource_id
        # The time when the episode starts. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        # 
        # This parameter is required.
        self.start_time = start_time
        # The policy for switching episodes. Valid values:
        # 
        # *   **TimeFirst**: The episode starts when the preceding episode ends and ends when the next episode starts. If no next episode exists, the episode keeps repeating until a new episode is added or the production studio stops.
        # *   **ContentFirst**: The episode starts and ends as scheduled.
        # 
        # This parameter takes effect only when the EpisodeType parameter is set to Resource.
        # 
        # >  This parameter must be set to TimeFirst when the video resource is a live stream.
        # 
        # This parameter is required.
        self.switch_type = switch_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.episode_name is not None:
            result['EpisodeName'] = self.episode_name
        if self.episode_type is not None:
            result['EpisodeType'] = self.episode_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.switch_type is not None:
            result['SwitchType'] = self.switch_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EpisodeName') is not None:
            self.episode_name = m.get('EpisodeName')
        if m.get('EpisodeType') is not None:
            self.episode_type = m.get('EpisodeType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('SwitchType') is not None:
            self.switch_type = m.get('SwitchType')
        return self


class AddCasterEpisodeResponseBody(TeaModel):
    def __init__(
        self,
        episode_id: str = None,
        request_id: str = None,
    ):
        # The ID of the episode. You can use the ID as a request parameter in the API operation that is used to query the information about the episode list, modify the configurations of the episode, and delete the episode.
        self.episode_id = episode_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.episode_id is not None:
            result['EpisodeId'] = self.episode_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EpisodeId') is not None:
            self.episode_id = m.get('EpisodeId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCasterEpisodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddCasterEpisodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCasterEpisodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCasterEpisodeGroupRequestItem(TeaModel):
    def __init__(
        self,
        item_name: str = None,
        vod_url: str = None,
    ):
        # The name of the episode.
        self.item_name = item_name
        # The URL of the VOD file.
        # 
        # If you query the input sources of the production studio by calling the [DescribeCasterVideoResources](https://help.aliyun.com/document_detail/2848023.html) operation, check the value of the response parameter VodUrl to obtain the URL.
        # 
        # >  This parameter takes effect only when the input source is a video file that is not from the media library.\\
        # The video file can be in the MP4, FLV, or TS format.
        self.vod_url = vod_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        if self.vod_url is not None:
            result['VodUrl'] = self.vod_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        if m.get('VodUrl') is not None:
            self.vod_url = m.get('VodUrl')
        return self


class AddCasterEpisodeGroupRequest(TeaModel):
    def __init__(
        self,
        callback_url: str = None,
        client_token: str = None,
        domain_name: str = None,
        item: List[AddCasterEpisodeGroupRequestItem] = None,
        owner_id: int = None,
        region_id: str = None,
        repeat_num: int = None,
        side_output_url: str = None,
        start_time: str = None,
    ):
        # The callback URL.
        # 
        # If you query the configurations of the production studio by calling the [DescribeCasterConfig](https://help.aliyun.com/document_detail/2848011.html) operation, check the value of the response parameter CallbackUrl to obtain the URL.
        # 
        # This parameter is required.
        self.callback_url = callback_url
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate a token, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
        # 
        # This parameter is required.
        self.client_token = client_token
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        # The list of episodes.
        # 
        # This parameter is required.
        self.item = item
        self.owner_id = owner_id
        self.region_id = region_id
        # The number of times the episode list repeats after the first playback is complete. Valid values:
        # 
        # *   **0**: indicates that the episode list is played only once.
        # *   **-1**: indicates that the episode list is played in loop mode.
        # 
        # This parameter is required.
        self.repeat_num = repeat_num
        # The custom standby URL.
        # 
        # If this parameter is empty, the ingest address corresponding to the output address automatically generated by Alibaba Cloud will be used by default.
        # 
        # This parameter is required.
        self.side_output_url = side_output_url
        # The time when the episode list starts to play. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        # 
        # This parameter is required.
        self.start_time = start_time

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.callback_url is not None:
            result['CallbackUrl'] = self.callback_url
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.repeat_num is not None:
            result['RepeatNum'] = self.repeat_num
        if self.side_output_url is not None:
            result['SideOutputUrl'] = self.side_output_url
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CallbackUrl') is not None:
            self.callback_url = m.get('CallbackUrl')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = AddCasterEpisodeGroupRequestItem()
                self.item.append(temp_model.from_map(k))
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RepeatNum') is not None:
            self.repeat_num = m.get('RepeatNum')
        if m.get('SideOutputUrl') is not None:
            self.side_output_url = m.get('SideOutputUrl')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class AddCasterEpisodeGroupResponseBodyItemIds(TeaModel):
    def __init__(
        self,
        item_id: List[str] = None,
    ):
        self.item_id = item_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        return self


class AddCasterEpisodeGroupResponseBody(TeaModel):
    def __init__(
        self,
        item_ids: AddCasterEpisodeGroupResponseBodyItemIds = None,
        program_id: str = None,
        request_id: str = None,
    ):
        # The IDs of the episodes.
        self.item_ids = item_ids
        # The ID of the episode list that was added. Record the ID as it can be used to manage the program being added.
        self.program_id = program_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.item_ids:
            self.item_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_ids is not None:
            result['ItemIds'] = self.item_ids.to_map()
        if self.program_id is not None:
            result['ProgramId'] = self.program_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ItemIds') is not None:
            temp_model = AddCasterEpisodeGroupResponseBodyItemIds()
            self.item_ids = temp_model.from_map(m['ItemIds'])
        if m.get('ProgramId') is not None:
            self.program_id = m.get('ProgramId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCasterEpisodeGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddCasterEpisodeGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCasterEpisodeGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCasterEpisodeGroupContentRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        content: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate a token, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
        # 
        # This parameter is required.
        self.client_token = client_token
        # The information about the episode list. The value is a JSON string. Use upper camel case for fields of the string. This parameter contains the following fields:
        # 
        # *   **CallbackUrl**: the callback URL.
        # 
        # *   **SideOutputUrl**: the custom standby URL.
        # 
        # *   **RepeatNum**: the number of times the episode list repeats after the first playback is complete. A value of 0 indicates that the episode list is played only once. A value of -1 indicates that the episode list is played in loop mode.
        # 
        # *   **DomainName**: the domain name.
        # 
        # *   **StartTime**: the time when the episode list starts to play. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        # 
        # *   **Items**: the information about the episode list. It is an array of ItemName and VodUrl.
        # 
        #     *   **ItemName**: the name of the episode.
        #     *   **VodUrl**: the URL of the VOD file. This field takes effect only when the video resource is a video file that is not from the media library. The video file must be in the MP4, FLV, or TS format.
        # 
        # This parameter is required.
        self.content = content
        self.owner_id = owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.content is not None:
            result['Content'] = self.content
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class AddCasterEpisodeGroupContentResponseBodyItemIds(TeaModel):
    def __init__(
        self,
        item_id: List[str] = None,
    ):
        self.item_id = item_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        return self


class AddCasterEpisodeGroupContentResponseBody(TeaModel):
    def __init__(
        self,
        item_ids: AddCasterEpisodeGroupContentResponseBodyItemIds = None,
        program_id: str = None,
        request_id: str = None,
    ):
        # The IDs of the episodes.
        self.item_ids = item_ids
        # The ID of the episode list. You can use the ID as a request parameter in the API operation that is used to create or add episodes, remove episodes, query episodes, edit an episode list, delete an episode list, query the information about an episode list, start playing an episode list, or stop playing an episode list.
        self.program_id = program_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.item_ids:
            self.item_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_ids is not None:
            result['ItemIds'] = self.item_ids.to_map()
        if self.program_id is not None:
            result['ProgramId'] = self.program_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ItemIds') is not None:
            temp_model = AddCasterEpisodeGroupContentResponseBodyItemIds()
            self.item_ids = temp_model.from_map(m['ItemIds'])
        if m.get('ProgramId') is not None:
            self.program_id = m.get('ProgramId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCasterEpisodeGroupContentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddCasterEpisodeGroupContentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCasterEpisodeGroupContentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCasterLayoutRequestAudioLayer(TeaModel):
    def __init__(
        self,
        fixed_delay_duration: int = None,
        valid_channel: str = None,
        volume_rate: float = None,
    ):
        # The fixed delay of audio layer N. You can use this parameter to synchronize the audio with subtitles. Unit: milliseconds. Valid values: **0 to 5000**. Default value: **0**.
        self.fixed_delay_duration = fixed_delay_duration
        # The valid voice channels of audio layer N. Valid values:
        # 
        # *   **leftChannel**: the left channel.
        # *   **rightChannel**: the right channel.
        # *   **all**: both the left and right channels. This is the default value.
        self.valid_channel = valid_channel
        # The multiples of the original volume at which audio layer N plays audio streams. Valid values: **0 to 10.0**.
        # 
        # *   The default value **1.0** indicates that audio layer N plays audio streams at the original volume.
        # *   A value smaller than **1.0** indicates that audio layer N plays audio streams at a lower volume than the original one.
        # *   A value greater than **1.0** indicates that audio layer N plays audio streams at a higher volume than the original one.
        self.volume_rate = volume_rate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fixed_delay_duration is not None:
            result['FixedDelayDuration'] = self.fixed_delay_duration
        if self.valid_channel is not None:
            result['ValidChannel'] = self.valid_channel
        if self.volume_rate is not None:
            result['VolumeRate'] = self.volume_rate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FixedDelayDuration') is not None:
            self.fixed_delay_duration = m.get('FixedDelayDuration')
        if m.get('ValidChannel') is not None:
            self.valid_channel = m.get('ValidChannel')
        if m.get('VolumeRate') is not None:
            self.volume_rate = m.get('VolumeRate')
        return self


class AddCasterLayoutRequestVideoLayer(TeaModel):
    def __init__(
        self,
        fill_mode: str = None,
        fixed_delay_duration: int = None,
        height_normalized: float = None,
        position_normalized: List[float] = None,
        position_refer: str = None,
        width_normalized: float = None,
    ):
        # The scaling mode of video layer N. Valid values:
        # 
        # *   **none**: The image is not scaled to fill in the specified layout section. Set video layer N based on the image size of the video resource. This is the default value.
        # *   **fit**: The image is scaled with the original aspect ratio to fill in the specified layout section. Set video layer N based on the section size. The image is centered in the layout section with the long side of the image equaling that of the section. If the aspect ratio of the image is inconsistent with that of the section, the short side of the image may be shorter than that of the section. The area outside the image displays the next video layer or the background if no next video layer exists. By default, the background color is black.
        self.fill_mode = fill_mode
        # The fixed delay of video layer N. You can use this parameter to synchronize the video with subtitles. Unit: milliseconds. Valid values: **0 to 5000**. Default value: **0**.
        self.fixed_delay_duration = fixed_delay_duration
        # The normalized value of the height of the image of video layer N.
        # 
        # *   If the FillMode parameter of video layer N is set to none, the width of the video image is scaled based on this parameter. The default value is **0**, which indicates that the video image is displayed in the original size.
        # *   If the FillMode parameter of video layer N is set to fit, you must set this parameter to a value greater than **0**. In this case, the video image is scaled with the original aspect ratio to fill in the specified layout section based on this parameter.
        self.height_normalized = height_normalized
        # The normalized value of the `[x,y]` coordinates of video layer N in the production studio. The default coordinates are `[0,0]`.
        # 
        # >  The coordinates indicate the location of video layer N in the production studio. Set this parameter to the normalized value of the coordinates.
        self.position_normalized = position_normalized
        # The reference coordinates of video layer N in the production studio. Valid values:
        # 
        # *   **topLeft**: the upper-left corner. This is the default value.
        # *   **topRight**: the upper-right corner.
        # *   **bottomLeft**: the lower-left corner.
        # *   **bottomRight**: the lower-right corner.
        # *   **center**: the center position.
        # *   **topCenter**: the upper center position.
        # *   **bottomCenter**: the lower center position.
        # *   **leftCenter**: the left center position.
        # *   **rightCenter**: the right center position.
        self.position_refer = position_refer
        # The normalized value of the width of the image of video layer N.
        # 
        # *   If the FillMode parameter of video layer N is set to none, the height of the video image is scaled based on this parameter. The default value is **0**, which indicates that the video image is displayed in the original size.
        # *   If the FillMode parameter of video layer N is set to fit, you must set this parameter to a value greater than **0**. In this case, the video image is scaled with the original aspect ratio to fill in the specified layout section based on this parameter.
        self.width_normalized = width_normalized

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fill_mode is not None:
            result['FillMode'] = self.fill_mode
        if self.fixed_delay_duration is not None:
            result['FixedDelayDuration'] = self.fixed_delay_duration
        if self.height_normalized is not None:
            result['HeightNormalized'] = self.height_normalized
        if self.position_normalized is not None:
            result['PositionNormalized'] = self.position_normalized
        if self.position_refer is not None:
            result['PositionRefer'] = self.position_refer
        if self.width_normalized is not None:
            result['WidthNormalized'] = self.width_normalized
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FillMode') is not None:
            self.fill_mode = m.get('FillMode')
        if m.get('FixedDelayDuration') is not None:
            self.fixed_delay_duration = m.get('FixedDelayDuration')
        if m.get('HeightNormalized') is not None:
            self.height_normalized = m.get('HeightNormalized')
        if m.get('PositionNormalized') is not None:
            self.position_normalized = m.get('PositionNormalized')
        if m.get('PositionRefer') is not None:
            self.position_refer = m.get('PositionRefer')
        if m.get('WidthNormalized') is not None:
            self.width_normalized = m.get('WidthNormalized')
        return self


class AddCasterLayoutRequest(TeaModel):
    def __init__(
        self,
        audio_layer: List[AddCasterLayoutRequestAudioLayer] = None,
        blend_list: List[str] = None,
        caster_id: str = None,
        mix_list: List[str] = None,
        owner_id: int = None,
        region_id: str = None,
        video_layer: List[AddCasterLayoutRequestVideoLayer] = None,
    ):
        # Audio layout.
        # 
        # This parameter is required.
        self.audio_layer = audio_layer
        # The element represents the location ID of the video resource, i.e., LocationId. Refer to [Adding Video Source](https://help.aliyun.com/document_detail/60250.html) for LocationId, which corresponds in order with the VideoLayers elements.
        # 
        # This parameter is required.
        self.blend_list = blend_list
        # The ID of the production studio.
        # 
        # If you create a production studio through the [CreateCaster](~~69338#doc-api-live-CreateCaster~~ "Creates a production studio.") interface, check the value of the CasterId parameter in the response.
        # 
        # If you create a production studio through the ApsaraVideo Live Console, log in to the console, then check the ID of the production studio through the following path:
        # 
        # Production Studios > Production Studio Management
        # 
        # >  The CasterId is reflected in the Name column on the Production Studio Management page.
        # 
        # This parameter is required.
        self.caster_id = caster_id
        # The element represents the location ID of the audio resource, i.e., LocationId.
        # LocationId is referred to in [Adding Video Source](https://help.aliyun.com/document_detail/60250.html), and corresponds in order with the AudioLayers elements.
        # 
        # This parameter is required.
        self.mix_list = mix_list
        self.owner_id = owner_id
        self.region_id = region_id
        # Video layout.
        # 
        # This parameter is required.
        self.video_layer = video_layer

    def validate(self):
        if self.audio_layer:
            for k in self.audio_layer:
                if k:
                    k.validate()
        if self.video_layer:
            for k in self.video_layer:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioLayer'] = []
        if self.audio_layer is not None:
            for k in self.audio_layer:
                result['AudioLayer'].append(k.to_map() if k else None)
        if self.blend_list is not None:
            result['BlendList'] = self.blend_list
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.mix_list is not None:
            result['MixList'] = self.mix_list
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['VideoLayer'] = []
        if self.video_layer is not None:
            for k in self.video_layer:
                result['VideoLayer'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.audio_layer = []
        if m.get('AudioLayer') is not None:
            for k in m.get('AudioLayer'):
                temp_model = AddCasterLayoutRequestAudioLayer()
                self.audio_layer.append(temp_model.from_map(k))
        if m.get('BlendList') is not None:
            self.blend_list = m.get('BlendList')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('MixList') is not None:
            self.mix_list = m.get('MixList')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.video_layer = []
        if m.get('VideoLayer') is not None:
            for k in m.get('VideoLayer'):
                temp_model = AddCasterLayoutRequestVideoLayer()
                self.video_layer.append(temp_model.from_map(k))
        return self


class AddCasterLayoutResponseBody(TeaModel):
    def __init__(
        self,
        layout_id: str = None,
        request_id: str = None,
    ):
        # The ID of the layout.
        # 
        # Record the ID as it can be used to manage the layout being created.
        self.layout_id = layout_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCasterLayoutResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddCasterLayoutResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCasterLayoutResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCasterProgramRequestEpisode(TeaModel):
    def __init__(
        self,
        component_id: List[str] = None,
        end_time: str = None,
        episode_name: str = None,
        episode_type: str = None,
        resource_id: str = None,
        start_time: str = None,
        switch_type: str = None,
    ):
        # The components. Components in the production studio are listed from the bottom to the top in an array.
        # 
        # >  This parameter is required and takes effect when the Episode.N.EpisodeType parameter is set to Component.
        # 
        # This parameter is optional when the Episode.N.EpisodeType parameter is set to **Resource**. In this case, if this parameter is specified, the components are bound to and switched together with video resources.
        self.component_id = component_id
        # The end time of the episode. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.end_time = end_time
        # The name of the episode.
        self.episode_name = episode_name
        # The type of the episode.
        # 
        # *   **Resource**: a video resource If you set this parameter to Resource, you must specify the Episode.N.ResourceId and Episode.N.SwitchType parameters.
        # *   **Component**: a component If you set this parameter to Component, you must specify the Episode.N.ComponentId.N parameter.
        self.episode_type = episode_type
        # The ID of the video resource.
        # 
        # >  This parameter takes effect and is required when the Episode.N.EpisodeType parameter is set to Resource.
        # 
        # \\
        # This parameter is invalid if you set the Episode.N.EpisodeType parameter to **Component**.
        # 
        # If the video resource was added by calling the [AddCasterVideoResource](https://help.aliyun.com/document_detail/60250.html) operation, check the value of the response parameter ResourceId to obtain the ID.
        self.resource_id = resource_id
        # The start time of the episode. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.start_time = start_time
        # The policy for switching episodes. Valid values:
        # 
        # >  This parameter takes effect only when the Episode.N.EpisodeType parameter is set to Resource.
        # 
        # *   **TimeFirst**: The episode starts when the previous episode ends and ends when the next episode starts. If no next episode exists, the episode keeps repeating until a new episode is added or the production studio stops. This value is required for live video resources.
        # *   **ContentFirst**: The episode starts and ends as scheduled.
        self.switch_type = switch_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.episode_name is not None:
            result['EpisodeName'] = self.episode_name
        if self.episode_type is not None:
            result['EpisodeType'] = self.episode_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.switch_type is not None:
            result['SwitchType'] = self.switch_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EpisodeName') is not None:
            self.episode_name = m.get('EpisodeName')
        if m.get('EpisodeType') is not None:
            self.episode_type = m.get('EpisodeType')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('SwitchType') is not None:
            self.switch_type = m.get('SwitchType')
        return self


class AddCasterProgramRequest(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        episode: List[AddCasterProgramRequestEpisode] = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The ID of the production studio.
        # 
        # *   If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation, check the value of the response parameter CasterId to obtain the ID.
        # *   If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        # 
        # >  You can find the ID of the production studio in the Instance ID/Name column.
        # 
        # This parameter is required.
        self.caster_id = caster_id
        # The information about episodes in the episode list.
        # 
        # This parameter is required.
        self.episode = episode
        self.owner_id = owner_id
        self.region_id = region_id

    def validate(self):
        if self.episode:
            for k in self.episode:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        result['Episode'] = []
        if self.episode is not None:
            for k in self.episode:
                result['Episode'].append(k.to_map() if k else None)
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        self.episode = []
        if m.get('Episode') is not None:
            for k in m.get('Episode'):
                temp_model = AddCasterProgramRequestEpisode()
                self.episode.append(temp_model.from_map(k))
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class AddCasterProgramResponseBodyEpisodeIdsEpisodeId(TeaModel):
    def __init__(
        self,
        episode_id: str = None,
    ):
        # The ID of the episode. You can use the ID as a request parameter in the API operation that is used to modify the episode list, query the information about the episode list, delete the episode, or modify the configurations of the episode.
        self.episode_id = episode_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.episode_id is not None:
            result['EpisodeId'] = self.episode_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EpisodeId') is not None:
            self.episode_id = m.get('EpisodeId')
        return self


class AddCasterProgramResponseBodyEpisodeIds(TeaModel):
    def __init__(
        self,
        episode_id: List[AddCasterProgramResponseBodyEpisodeIdsEpisodeId] = None,
    ):
        self.episode_id = episode_id

    def validate(self):
        if self.episode_id:
            for k in self.episode_id:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EpisodeId'] = []
        if self.episode_id is not None:
            for k in self.episode_id:
                result['EpisodeId'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.episode_id = []
        if m.get('EpisodeId') is not None:
            for k in m.get('EpisodeId'):
                temp_model = AddCasterProgramResponseBodyEpisodeIdsEpisodeId()
                self.episode_id.append(temp_model.from_map(k))
        return self


class AddCasterProgramResponseBody(TeaModel):
    def __init__(
        self,
        episode_ids: AddCasterProgramResponseBodyEpisodeIds = None,
        request_id: str = None,
    ):
        # The IDs of the episodes. The episode IDs are listed in the same order as specified by the variable N.
        self.episode_ids = episode_ids
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.episode_ids:
            self.episode_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.episode_ids is not None:
            result['EpisodeIds'] = self.episode_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EpisodeIds') is not None:
            temp_model = AddCasterProgramResponseBodyEpisodeIds()
            self.episode_ids = temp_model.from_map(m['EpisodeIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCasterProgramResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddCasterProgramResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCasterProgramResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCasterVideoResourceRequest(TeaModel):
    def __init__(
        self,
        begin_offset: int = None,
        caster_id: str = None,
        end_offset: int = None,
        fixed_delay_duration: int = None,
        image_id: str = None,
        image_url: str = None,
        live_stream_url: str = None,
        location_id: str = None,
        material_id: str = None,
        owner_id: int = None,
        pts_callback_interval: int = None,
        region_id: str = None,
        repeat_num: int = None,
        resource_name: str = None,
        vod_url: str = None,
    ):
        # The offset of the position where the system starts to read the video source. Unit: milliseconds.
        # 
        # **\
        # 
        # **Important** This parameter takes effect only if the video source is a file.
        # 
        # > A value greater than **0** specifies an offset from the first frame.
        self.begin_offset = begin_offset
        # The ID of the production studio.
        # 
        # *   If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/69338.html) operation, check the value of the response parameter CasterId to obtain the ID.
        # *   If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        # 
        # > You can find the ID of the production studio in the Instance Name column.
        # 
        # This parameter is required.
        self.caster_id = caster_id
        # The offset of the position where the system stops reading the video source. Unit: milliseconds.
        # 
        # **\
        # 
        # **Important** This parameter takes effect only if the video source is a file.
        # 
        # *   A value greater than **0** specifies an offset from the first frame.
        # *   A value less than **0** specifies an offset from the last frame.
        self.end_offset = end_offset
        # The fixed delay of the video layer. This parameter is used to synchronize the video with subtitles. Unit: milliseconds. Default value: 0. Valid values: `0 to 5000`.
        self.fixed_delay_duration = fixed_delay_duration
        # ID of the media library image material. 
        # >This parameter is only available and must be provided when the video source type is an image.
        self.image_id = image_id
        # Image material URL. 
        # >This parameter is available only when the video source type is an image and the image file has not been imported into the material library. Supports uploading images in jpg, png formats, with a maximum file size of 10MB.
        self.image_url = image_url
        # The streaming URL.
        # 
        # **\
        # 
        # **Important** This parameter is required if the video source is a live stream.
        # 
        # > Do not specify this parameter in the request if the video source is not a live stream.
        self.live_stream_url = live_stream_url
        # The ID that is used to identify the position of the video source.
        # 
        # Define the reference numbers in the layout. Each reference number is associated with only one resource. The value of this parameter must be in the RV[Number] format, where Number is `01 to 99`.
        self.location_id = location_id
        # The ID of the material from the media library.
        # 
        # **\
        # 
        # **Important** This parameter takes effect and is required only if the video source is a material.
        # 
        # If you query the configurations of the production studio by calling the [DescribeCasterConfig](https://help.aliyun.com/document_detail/60259.html) operation, obtain the value of the response parameter UrgentMaterialId.
        # 
        # > The value of the UrgentMaterialId parameter is the ID of the material from the media library.
        self.material_id = material_id
        self.owner_id = owner_id
        # The interval between presentation timestamp (PTS) callbacks. Unit: milliseconds.
        self.pts_callback_interval = pts_callback_interval
        self.region_id = region_id
        # The number of playbacks after the first playback is complete. Valid values:
        # 
        # **\
        # 
        # **Important** This parameter takes effect only if the video source is a file.
        # 
        # *   **0**: specifies that the video source is played only once. This is the default value.
        # *   **-1**: specifies that the video source is played in loop mode.
        self.repeat_num = repeat_num
        # The name of the video source.
        # 
        # This parameter is required.
        self.resource_name = resource_name
        # The URL of the VOD file.
        # 
        # **\
        # 
        # **Important** This parameter takes effect only if the video source is a file that is not from the media library.
        # 
        # > The VOD file must be in the MP4, FLV, or TS format.
        self.vod_url = vod_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin_offset is not None:
            result['BeginOffset'] = self.begin_offset
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.end_offset is not None:
            result['EndOffset'] = self.end_offset
        if self.fixed_delay_duration is not None:
            result['FixedDelayDuration'] = self.fixed_delay_duration
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_url is not None:
            result['ImageUrl'] = self.image_url
        if self.live_stream_url is not None:
            result['LiveStreamUrl'] = self.live_stream_url
        if self.location_id is not None:
            result['LocationId'] = self.location_id
        if self.material_id is not None:
            result['MaterialId'] = self.material_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pts_callback_interval is not None:
            result['PtsCallbackInterval'] = self.pts_callback_interval
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.repeat_num is not None:
            result['RepeatNum'] = self.repeat_num
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        if self.vod_url is not None:
            result['VodUrl'] = self.vod_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BeginOffset') is not None:
            self.begin_offset = m.get('BeginOffset')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('EndOffset') is not None:
            self.end_offset = m.get('EndOffset')
        if m.get('FixedDelayDuration') is not None:
            self.fixed_delay_duration = m.get('FixedDelayDuration')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageUrl') is not None:
            self.image_url = m.get('ImageUrl')
        if m.get('LiveStreamUrl') is not None:
            self.live_stream_url = m.get('LiveStreamUrl')
        if m.get('LocationId') is not None:
            self.location_id = m.get('LocationId')
        if m.get('MaterialId') is not None:
            self.material_id = m.get('MaterialId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PtsCallbackInterval') is not None:
            self.pts_callback_interval = m.get('PtsCallbackInterval')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RepeatNum') is not None:
            self.repeat_num = m.get('RepeatNum')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        if m.get('VodUrl') is not None:
            self.vod_url = m.get('VodUrl')
        return self


class AddCasterVideoResourceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        resource_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The ID of the resource. This parameter can be used as a request parameter in the API operation that you can call to delete the video source in the production studio or modify the video source in the production studio.
        self.resource_id = resource_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class AddCasterVideoResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddCasterVideoResourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCasterVideoResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCustomLiveStreamTranscodeRequest(TeaModel):
    def __init__(
        self,
        app: str = None,
        audio_bitrate: int = None,
        audio_channel_num: int = None,
        audio_codec: str = None,
        audio_profile: str = None,
        audio_rate: int = None,
        bitrate_with_source: str = None,
        de_interlaced: bool = None,
        domain: str = None,
        encrypt_parameters: str = None,
        ext_with_source: str = None,
        fps: int = None,
        fps_with_source: str = None,
        gop: str = None,
        height: int = None,
        kms_key_expire_interval: str = None,
        kms_key_id: str = None,
        kms_uid: str = None,
        lazy: str = None,
        owner_id: int = None,
        profile: int = None,
        region_id: str = None,
        res_with_source: str = None,
        template: str = None,
        template_type: str = None,
        video_bitrate: int = None,
        width: int = None,
    ):
        # The name of the application to which the live stream belongs.
        # 
        # This parameter is required.
        self.app = app
        # The bitrate of the output audio. Unit: Kbit/s. Valid values: **1 to 1000**.
        self.audio_bitrate = audio_bitrate
        # The number of sound channels. Valid values:
        # 
        # *   **1**: mono.
        # *   **2**: binaural.
        self.audio_channel_num = audio_channel_num
        # The audio encoding format. Valid values:
        # 
        # *   **AAC**\
        # *   **MP3**\
        self.audio_codec = audio_codec
        # The audio encoding profile. Valid values:
        # 
        # *   **aac_low**\
        # *   **aac_he**\
        # *   **aac_he_v2**\
        # *   **aac_ld**\
        self.audio_profile = audio_profile
        # The audio sampling rate. Valid values: **22050 to 96000**.
        # 
        # 
        # >Notice: If you set AudioProfile to **aac_ld**, the audio sampling rate cannot exceed 44100.
        self.audio_rate = audio_rate
        # The source-based bitrate settings. This parameter takes precedence over other bitrate settings. The following fields must be included:
        # 
        # *   **UpLimit**: the maximum bitrate limit. Valid values: an integer from 128 to 10000. The value must be greater than the minimum bitrate.
        # *   **LowerLimit int** : the minimum bitrate rate. Valid values: an integer from 128 to 10000. The value must be smaller than the maximum bitrate.
        # *   **Factor**: The ratio of the output bitrate to the source bitrate. Valid values: 0.1 to 1. The value is accurate to one decimal place. A value of 1 indicates that the output video has the same bitrate as the source video.
        self.bitrate_with_source = bitrate_with_source
        self.de_interlaced = de_interlaced
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain = domain
        # Encryption configuration. In JSON format, the fields are explained as follows:
        # - **EncryptType**: Encryption type. Fixed value is aliyun.
        # - **KmsKeyID**: User KMS master key ID.
        # - **KmsKeyExpireInterval**: Key rotation period. Range: 60~3600, unit: seconds.
        # > If the EncryptParameters is configured, the KmsKeyID, KmsUID, and KmsKeyExpireInterval parameters cannot be empty
        self.encrypt_parameters = encrypt_parameters
        # Other source-based settings, including the following fields:
        # 
        # *   **KeyFrameOpen**: specifies whether to use the key frames of the source video. Valid values: yes or no.
        # *   **Copyts**: specifies whether to use the presentation time stamp (PTS) of the source video. Valid values: yes or no.
        # *   **SeiMode**: specifies whether to pass through supplemental enhancement information (SEI) messages. Valid values: 0, 1, and 2, where 0 specifies that no SEI messages are passed through, 1 specifies that part of SEI messages are passed through, and 2 specifies that all SEI messages are passed through.
        self.ext_with_source = ext_with_source
        # The frame rate of the output video. Unit: frames per second (FPS). Valid values: **1 to 60**.
        self.fps = fps
        # The source-based frame rate settings. This parameter takes precedence over other frame rate settings. The following fields must be included:
        # 
        # *   **UpLimit**: the maximum frame rate. Valid values: an integer from 1 to 60. The value must be greater than the minimum frame rate.
        # *   **LowerLimit**: the minimum frame rate. Valid values: an integer from 1 to 60. The value must be smaller than the maximum frame rate.
        self.fps_with_source = fps_with_source
        # The Group of Picture (GOP) size of the video. Unit: frames or seconds.
        # 
        # *   Unit: frames. Valid values: **1 to 3000**.
        # *   Unit: seconds. Valid value: **1 to 20**.
        self.gop = gop
        # The height of the output video. Unit: pixel. Valid values:
        # 
        # The value must comply with all the following rules:
        # 
        # *   **Height ≥ 100**: The height of the video is greater than or equal to 100 pixels.
        # *   **max(Height,Width) ≤ 2560**: The width or height of the video, whichever is greater, cannot exceed 2,560 pixels.
        # *   **min(Height,Width) ≤ 1440**: The width or height of the video, whichever is smaller, cannot exceed 1,440 pixels.
        # 
        # > The resolution of the output video that is transcoded by using the H.265 Narrowband HD™ transcoding template cannot exceed 1280 × 720 pixels.
        self.height = height
        # The rotation period of the CMK. Valid values: 60 to 3600. Unit: seconds.
        self.kms_key_expire_interval = kms_key_expire_interval
        # The ID of the customer master key (CMK) that you created in Key Management Service (KMS).
        self.kms_key_id = kms_key_id
        # The ID of your KMS account.
        self.kms_uid = kms_uid
        # Specifies whether to use the load-on-demand mechanism for transcoding. Valid values: yes and no. Default value: **yes**.
        self.lazy = lazy
        self.owner_id = owner_id
        # The video encoding profile. The profile defines a set of parameters that are used to encode a video. In most cases, a greater value indicates better image quality and higher resource consumption. Valid values:
        # 
        # *   **1**: baseline. This value is suitable for mobile devices.
        # *   **2**: main. This value is suitable for standard-definition devices.
        # *   **3**: high. This value is suitable for high-definition devices.
        self.profile = profile
        self.region_id = region_id
        # The source-based resolution settings. This parameter takes precedence over other resolution settings. The following fields must be included:
        # 
        # *   **Type**: You can set this field to short, long, or screen. short specifies that the resolution of the output video is adapted to the shorter side, long specifies that the resolution of the output video is adapted to the longer side, and screen specifies that the output video has an adaptive resolution.
        # 
        # *   **Value**:
        # 
        #     *   Set this field to 360, 480, 540, 720, or 1080 if the Type field is set to short.
        #     *   Set this field to 640, 848, 960, 1280, or 1920 if the Type field is set to long.
        #     *   Set this field to 640\\*360, 848\\*480, 960\\*540, 1280\\*720, or 1920\\*1080 if the Type field is set to screen.
        self.res_with_source = res_with_source
        # The name of the custom transcoding template.
        # 
        # > The name can contain digits, letters, and hyphens (-), and must start with a letter or digit. The name must be different from the names of any default transcoding templates.
        # 
        # This parameter is required.
        self.template = template
        # The type of the custom transcoding template. Valid values:
        # 
        # *   **h264**: custom H.264 standard transcoding.
        # *   **h264-nbhd**: custom H.264 Narrowband HD™ transcoding.
        # *   **h265**: custom H.265 standard transcoding.
        # *   **h265-nbhd**: custom H.265 Narrowband HD™ transcoding.
        # *   **audio**: audio-only transcoding.
        # 
        # > If you set **TemplateType** to **h264**, **h264-nbhd**, **h265**, or **h265-nbhd**, the **Height**, **Width**, **FPS**, and **VideoBitrate** parameters are required.
        # 
        # This parameter is required.
        self.template_type = template_type
        # The bitrate of the output video. Unit: Kbit/s. Valid values: **1 to 6000**.
        # 
        # > The bitrate of the output video may not be the same as the value that you specify, but is as close to the value as possible, especially when the value is excessively large or small.
        self.video_bitrate = video_bitrate
        # The width of the output video. Unit: pixel. Valid values:
        # 
        # The value must comply with all the following rules:
        # 
        # *   **Width ≥ 100**: The width of the video is greater than or equal to 100 pixels.
        # *   **max(Height,Width) ≤ 2560**: The width or height of the video, whichever is greater, cannot exceed 2,560 pixels.
        # *   **min(Height,Width) ≤ 1440**: The width or height of the video, whichever is smaller, cannot exceed 1,440 pixels.
        # 
        # > The resolution of the output video that is transcoded by using the H.265 Narrowband HD™ transcoding template cannot exceed 1280 × 720 pixels.
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app is not None:
            result['App'] = self.app
        if self.audio_bitrate is not None:
            result['AudioBitrate'] = self.audio_bitrate
        if self.audio_channel_num is not None:
            result['AudioChannelNum'] = self.audio_channel_num
        if self.audio_codec is not None:
            result['AudioCodec'] = self.audio_codec
        if self.audio_profile is not None:
            result['AudioProfile'] = self.audio_profile
        if self.audio_rate is not None:
            result['AudioRate'] = self.audio_rate
        if self.bitrate_with_source is not None:
            result['BitrateWithSource'] = self.bitrate_with_source
        if self.de_interlaced is not None:
            result['DeInterlaced'] = self.de_interlaced
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.encrypt_parameters is not None:
            result['EncryptParameters'] = self.encrypt_parameters
        if self.ext_with_source is not None:
            result['ExtWithSource'] = self.ext_with_source
        if self.fps is not None:
            result['FPS'] = self.fps
        if self.fps_with_source is not None:
            result['FpsWithSource'] = self.fps_with_source
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.height is not None:
            result['Height'] = self.height
        if self.kms_key_expire_interval is not None:
            result['KmsKeyExpireInterval'] = self.kms_key_expire_interval
        if self.kms_key_id is not None:
            result['KmsKeyID'] = self.kms_key_id
        if self.kms_uid is not None:
            result['KmsUID'] = self.kms_uid
        if self.lazy is not None:
            result['Lazy'] = self.lazy
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.res_with_source is not None:
            result['ResWithSource'] = self.res_with_source
        if self.template is not None:
            result['Template'] = self.template
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        if self.video_bitrate is not None:
            result['VideoBitrate'] = self.video_bitrate
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('AudioBitrate') is not None:
            self.audio_bitrate = m.get('AudioBitrate')
        if m.get('AudioChannelNum') is not None:
            self.audio_channel_num = m.get('AudioChannelNum')
        if m.get('AudioCodec') is not None:
            self.audio_codec = m.get('AudioCodec')
        if m.get('AudioProfile') is not None:
            self.audio_profile = m.get('AudioProfile')
        if m.get('AudioRate') is not None:
            self.audio_rate = m.get('AudioRate')
        if m.get('BitrateWithSource') is not None:
            self.bitrate_with_source = m.get('BitrateWithSource')
        if m.get('DeInterlaced') is not None:
            self.de_interlaced = m.get('DeInterlaced')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('EncryptParameters') is not None:
            self.encrypt_parameters = m.get('EncryptParameters')
        if m.get('ExtWithSource') is not None:
            self.ext_with_source = m.get('ExtWithSource')
        if m.get('FPS') is not None:
            self.fps = m.get('FPS')
        if m.get('FpsWithSource') is not None:
            self.fps_with_source = m.get('FpsWithSource')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('KmsKeyExpireInterval') is not None:
            self.kms_key_expire_interval = m.get('KmsKeyExpireInterval')
        if m.get('KmsKeyID') is not None:
            self.kms_key_id = m.get('KmsKeyID')
        if m.get('KmsUID') is not None:
            self.kms_uid = m.get('KmsUID')
        if m.get('Lazy') is not None:
            self.lazy = m.get('Lazy')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResWithSource') is not None:
            self.res_with_source = m.get('ResWithSource')
        if m.get('Template') is not None:
            self.template = m.get('Template')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        if m.get('VideoBitrate') is not None:
            self.video_bitrate = m.get('VideoBitrate')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class AddCustomLiveStreamTranscodeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCustomLiveStreamTranscodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddCustomLiveStreamTranscodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCustomLiveStreamTranscodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveAIProduceRulesRequest(TeaModel):
    def __init__(
        self,
        app: str = None,
        description: str = None,
        domain: str = None,
        is_lazy: bool = None,
        live_template: str = None,
        owner_id: int = None,
        region_id: str = None,
        studio_name: str = None,
        subtitle_name: str = None,
        suffix: str = None,
    ):
        # The name of the application to which the live stream belongs. The name can be up to 256 characters in length and can contain digits, letters, hyphens (-), and underscores (_). The name must be the same as the application name in the ingest URL. Otherwise, the rule does not take effect.
        # 
        # This parameter is required.
        self.app = app
        # The description of the subtitle rule. The description can be up to 128 characters in length and can contain letters, digits, and special characters.
        self.description = description
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain = domain
        # Specifies whether to trigger the subtitle rule when stream pulling starts. Valid values:
        # 
        # *   true: generates live subtitles when stream pulling starts and stops generating live subtitles when no stream is pulled for 5 minutes. When stream pulling restarts, live subtitles are generated again.
        # *   false: generates live subtitles when stream ingest starts, regardless of whether stream pulling starts.
        self.is_lazy = is_lazy
        # The specification of the output subtitles. Valid values:
        # 
        # *   `lp_ld`: landscape low definition 360p (640×360)
        # *   `lp_ld_v`: portrait low definition 360p (360×640)
        # *   `lp_sd`: landscape standard definition 480p (854×480)
        # *   `lp_sd_v`: portrait standard definition 480p (480×854)
        # *   `lp_hd`: landscape high definition 720p (1280×720)
        # *   `lp_hd_v`: portrait high definition 720p (720×1280)
        # *   `lp_ud`: landscape ultra-high definition 1080p (1920×1080)
        # *   `lp_ud_v`: portrait ultra-high definition 1080p (1080×1920)
        # 
        # This parameter is required.
        self.live_template = live_template
        self.owner_id = owner_id
        self.region_id = region_id
        # The name of the virtual background template.
        self.studio_name = studio_name
        # The name of the subtitle template.
        self.subtitle_name = subtitle_name
        # The suffix to match.
        self.suffix = suffix

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app is not None:
            result['App'] = self.app
        if self.description is not None:
            result['Description'] = self.description
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.is_lazy is not None:
            result['IsLazy'] = self.is_lazy
        if self.live_template is not None:
            result['LiveTemplate'] = self.live_template
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.studio_name is not None:
            result['StudioName'] = self.studio_name
        if self.subtitle_name is not None:
            result['SubtitleName'] = self.subtitle_name
        if self.suffix is not None:
            result['Suffix'] = self.suffix
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('IsLazy') is not None:
            self.is_lazy = m.get('IsLazy')
        if m.get('LiveTemplate') is not None:
            self.live_template = m.get('LiveTemplate')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StudioName') is not None:
            self.studio_name = m.get('StudioName')
        if m.get('SubtitleName') is not None:
            self.subtitle_name = m.get('SubtitleName')
        if m.get('Suffix') is not None:
            self.suffix = m.get('Suffix')
        return self


class AddLiveAIProduceRulesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        rules_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The ID of the subtitle rule.
        self.rules_id = rules_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rules_id is not None:
            result['RulesId'] = self.rules_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RulesId') is not None:
            self.rules_id = m.get('RulesId')
        return self


class AddLiveAIProduceRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddLiveAIProduceRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveAIProduceRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveAISubtitleRequest(TeaModel):
    def __init__(
        self,
        bg_color: str = None,
        bg_width_normalized: float = None,
        border_width_normalized: float = None,
        copy_from: str = None,
        description: str = None,
        dst_language: str = None,
        font_color: str = None,
        font_name: str = None,
        font_size_normalized: float = None,
        height: str = None,
        max_lines: int = None,
        owner_id: int = None,
        position_normalized: List[float] = None,
        region_id: str = None,
        show_source_lan: bool = None,
        src_language: str = None,
        subtitle_name: str = None,
        width: str = None,
        word_per_line: int = None,
    ):
        # The background color of the subtitles, which is an RGBA value.
        self.bg_color = bg_color
        # The background size of the subtitles. Valid values: [0,1].
        self.bg_width_normalized = bg_width_normalized
        # The font weight. Valid values: [0,1].
        self.border_width_normalized = border_width_normalized
        # The subtitle template that you copy. Set the value to the name of the subtitle template.
        self.copy_from = copy_from
        # The custom description of the subtitle template. The description can be up to 128 characters in length and can contain letters, digits, and special characters.
        self.description = description
        # The target language. Valid values:
        #  - en-US: English 
        # - zh-CN: Chinese 
        # - es-ES: Spanish 
        # - ru-RU: Russian
        self.dst_language = dst_language
        # The font color, which is an RGBA value.
        self.font_color = font_color
        # The font. Valid values:
        # - KaiTi (default)
        # - AlibabaPuHuiTi-Regular
        # - AlibabaPuHuiTi-Bold
        # - AlibabaPuHuiTi-Light
        # - NotoSansHans-Regular
        # - NotoSansHans-Bold
        # - NotoSansHans-Light
        self.font_name = font_name
        # The font size. Valid values: [0,1].
        # 
        # This parameter is required.
        self.font_size_normalized = font_size_normalized
        # The preview height. Unit: pixels.
        # The following specifications of preview width × preview height are supported: 
        # - Landscape low definition 360p (640×360) 
        # - Portrait low definition 360p (360×640)
        # - Landscape standard definition 480p (854×480)
        # - Portrait standard definition 480p (480×854)
        # - Landscape high definition 720p (1280×720)
        # - Portrait high definition 720p (720×1280)
        # - Landscape ultra-high definition 1080p (1920×1080)
        # - Portrait ultra-high definition 1080p (1080×1920)
        self.height = height
        # The number of displayed lines.
        self.max_lines = max_lines
        self.owner_id = owner_id
        # The position of the subtitles. The value is a pair of coordinates for which the origin of the x and y axes is the lower-left corner of the screen.
        # 
        # This parameter is required.
        self.position_normalized = position_normalized
        self.region_id = region_id
        # Specifies whether to display the source language. Default value: false.
        self.show_source_lan = show_source_lan
        # The source language. Valid values:
        #  - en-US: English 
        # - zh-CN: Chinese 
        # - ru-RU: Russian
        # 
        # This parameter is required.
        self.src_language = src_language
        # The name of the subtitle template. The name can contain only digits, letters, and hyphens (-). The name cannot start with a hyphen.
        # 
        # This parameter is required.
        self.subtitle_name = subtitle_name
        # The preview width. Unit: pixels.
        self.width = width
        # The number of words displayed per line. Valid values: integers from 1 to 500.
        # 
        # This parameter is required.
        self.word_per_line = word_per_line

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bg_color is not None:
            result['BgColor'] = self.bg_color
        if self.bg_width_normalized is not None:
            result['BgWidthNormalized'] = self.bg_width_normalized
        if self.border_width_normalized is not None:
            result['BorderWidthNormalized'] = self.border_width_normalized
        if self.copy_from is not None:
            result['CopyFrom'] = self.copy_from
        if self.description is not None:
            result['Description'] = self.description
        if self.dst_language is not None:
            result['DstLanguage'] = self.dst_language
        if self.font_color is not None:
            result['FontColor'] = self.font_color
        if self.font_name is not None:
            result['FontName'] = self.font_name
        if self.font_size_normalized is not None:
            result['FontSizeNormalized'] = self.font_size_normalized
        if self.height is not None:
            result['Height'] = self.height
        if self.max_lines is not None:
            result['MaxLines'] = self.max_lines
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.position_normalized is not None:
            result['PositionNormalized'] = self.position_normalized
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.show_source_lan is not None:
            result['ShowSourceLan'] = self.show_source_lan
        if self.src_language is not None:
            result['SrcLanguage'] = self.src_language
        if self.subtitle_name is not None:
            result['SubtitleName'] = self.subtitle_name
        if self.width is not None:
            result['Width'] = self.width
        if self.word_per_line is not None:
            result['WordPerLine'] = self.word_per_line
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BgColor') is not None:
            self.bg_color = m.get('BgColor')
        if m.get('BgWidthNormalized') is not None:
            self.bg_width_normalized = m.get('BgWidthNormalized')
        if m.get('BorderWidthNormalized') is not None:
            self.border_width_normalized = m.get('BorderWidthNormalized')
        if m.get('CopyFrom') is not None:
            self.copy_from = m.get('CopyFrom')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DstLanguage') is not None:
            self.dst_language = m.get('DstLanguage')
        if m.get('FontColor') is not None:
            self.font_color = m.get('FontColor')
        if m.get('FontName') is not None:
            self.font_name = m.get('FontName')
        if m.get('FontSizeNormalized') is not None:
            self.font_size_normalized = m.get('FontSizeNormalized')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MaxLines') is not None:
            self.max_lines = m.get('MaxLines')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PositionNormalized') is not None:
            self.position_normalized = m.get('PositionNormalized')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ShowSourceLan') is not None:
            self.show_source_lan = m.get('ShowSourceLan')
        if m.get('SrcLanguage') is not None:
            self.src_language = m.get('SrcLanguage')
        if m.get('SubtitleName') is not None:
            self.subtitle_name = m.get('SubtitleName')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('WordPerLine') is not None:
            self.word_per_line = m.get('WordPerLine')
        return self


class AddLiveAISubtitleShrinkRequest(TeaModel):
    def __init__(
        self,
        bg_color: str = None,
        bg_width_normalized: float = None,
        border_width_normalized: float = None,
        copy_from: str = None,
        description: str = None,
        dst_language: str = None,
        font_color: str = None,
        font_name: str = None,
        font_size_normalized: float = None,
        height: str = None,
        max_lines: int = None,
        owner_id: int = None,
        position_normalized_shrink: str = None,
        region_id: str = None,
        show_source_lan: bool = None,
        src_language: str = None,
        subtitle_name: str = None,
        width: str = None,
        word_per_line: int = None,
    ):
        # The background color of the subtitles, which is an RGBA value.
        self.bg_color = bg_color
        # The background size of the subtitles. Valid values: [0,1].
        self.bg_width_normalized = bg_width_normalized
        # The font weight. Valid values: [0,1].
        self.border_width_normalized = border_width_normalized
        # The subtitle template that you copy. Set the value to the name of the subtitle template.
        self.copy_from = copy_from
        # The custom description of the subtitle template. The description can be up to 128 characters in length and can contain letters, digits, and special characters.
        self.description = description
        # The target language. Valid values:
        #  - en-US: English 
        # - zh-CN: Chinese 
        # - es-ES: Spanish 
        # - ru-RU: Russian
        self.dst_language = dst_language
        # The font color, which is an RGBA value.
        self.font_color = font_color
        # The font. Valid values:
        # - KaiTi (default)
        # - AlibabaPuHuiTi-Regular
        # - AlibabaPuHuiTi-Bold
        # - AlibabaPuHuiTi-Light
        # - NotoSansHans-Regular
        # - NotoSansHans-Bold
        # - NotoSansHans-Light
        self.font_name = font_name
        # The font size. Valid values: [0,1].
        # 
        # This parameter is required.
        self.font_size_normalized = font_size_normalized
        # The preview height. Unit: pixels.
        # The following specifications of preview width × preview height are supported: 
        # - Landscape low definition 360p (640×360) 
        # - Portrait low definition 360p (360×640)
        # - Landscape standard definition 480p (854×480)
        # - Portrait standard definition 480p (480×854)
        # - Landscape high definition 720p (1280×720)
        # - Portrait high definition 720p (720×1280)
        # - Landscape ultra-high definition 1080p (1920×1080)
        # - Portrait ultra-high definition 1080p (1080×1920)
        self.height = height
        # The number of displayed lines.
        self.max_lines = max_lines
        self.owner_id = owner_id
        # The position of the subtitles. The value is a pair of coordinates for which the origin of the x and y axes is the lower-left corner of the screen.
        # 
        # This parameter is required.
        self.position_normalized_shrink = position_normalized_shrink
        self.region_id = region_id
        # Specifies whether to display the source language. Default value: false.
        self.show_source_lan = show_source_lan
        # The source language. Valid values:
        #  - en-US: English 
        # - zh-CN: Chinese 
        # - ru-RU: Russian
        # 
        # This parameter is required.
        self.src_language = src_language
        # The name of the subtitle template. The name can contain only digits, letters, and hyphens (-). The name cannot start with a hyphen.
        # 
        # This parameter is required.
        self.subtitle_name = subtitle_name
        # The preview width. Unit: pixels.
        self.width = width
        # The number of words displayed per line. Valid values: integers from 1 to 500.
        # 
        # This parameter is required.
        self.word_per_line = word_per_line

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bg_color is not None:
            result['BgColor'] = self.bg_color
        if self.bg_width_normalized is not None:
            result['BgWidthNormalized'] = self.bg_width_normalized
        if self.border_width_normalized is not None:
            result['BorderWidthNormalized'] = self.border_width_normalized
        if self.copy_from is not None:
            result['CopyFrom'] = self.copy_from
        if self.description is not None:
            result['Description'] = self.description
        if self.dst_language is not None:
            result['DstLanguage'] = self.dst_language
        if self.font_color is not None:
            result['FontColor'] = self.font_color
        if self.font_name is not None:
            result['FontName'] = self.font_name
        if self.font_size_normalized is not None:
            result['FontSizeNormalized'] = self.font_size_normalized
        if self.height is not None:
            result['Height'] = self.height
        if self.max_lines is not None:
            result['MaxLines'] = self.max_lines
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.position_normalized_shrink is not None:
            result['PositionNormalized'] = self.position_normalized_shrink
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.show_source_lan is not None:
            result['ShowSourceLan'] = self.show_source_lan
        if self.src_language is not None:
            result['SrcLanguage'] = self.src_language
        if self.subtitle_name is not None:
            result['SubtitleName'] = self.subtitle_name
        if self.width is not None:
            result['Width'] = self.width
        if self.word_per_line is not None:
            result['WordPerLine'] = self.word_per_line
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BgColor') is not None:
            self.bg_color = m.get('BgColor')
        if m.get('BgWidthNormalized') is not None:
            self.bg_width_normalized = m.get('BgWidthNormalized')
        if m.get('BorderWidthNormalized') is not None:
            self.border_width_normalized = m.get('BorderWidthNormalized')
        if m.get('CopyFrom') is not None:
            self.copy_from = m.get('CopyFrom')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DstLanguage') is not None:
            self.dst_language = m.get('DstLanguage')
        if m.get('FontColor') is not None:
            self.font_color = m.get('FontColor')
        if m.get('FontName') is not None:
            self.font_name = m.get('FontName')
        if m.get('FontSizeNormalized') is not None:
            self.font_size_normalized = m.get('FontSizeNormalized')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MaxLines') is not None:
            self.max_lines = m.get('MaxLines')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PositionNormalized') is not None:
            self.position_normalized_shrink = m.get('PositionNormalized')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ShowSourceLan') is not None:
            self.show_source_lan = m.get('ShowSourceLan')
        if m.get('SrcLanguage') is not None:
            self.src_language = m.get('SrcLanguage')
        if m.get('SubtitleName') is not None:
            self.subtitle_name = m.get('SubtitleName')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('WordPerLine') is not None:
            self.word_per_line = m.get('WordPerLine')
        return self


class AddLiveAISubtitleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        subtitle_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The ID of the subtitle template.
        self.subtitle_id = subtitle_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.subtitle_id is not None:
            result['SubtitleId'] = self.subtitle_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SubtitleId') is not None:
            self.subtitle_id = m.get('SubtitleId')
        return self


class AddLiveAISubtitleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddLiveAISubtitleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveAISubtitleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveAppRecordConfigRequestRecordFormat(TeaModel):
    def __init__(
        self,
        cycle_duration: int = None,
        format: str = None,
        oss_object_prefix: str = None,
        slice_duration: int = None,
        slice_oss_object_prefix: str = None,
    ):
        # The recording cycle. Unit: seconds. If you do not specify this parameter, the default value 6 hours is used.
        # 
        # > 
        # 
        # *   If a live stream is interrupted during a recording cycle but is resumed within the interruption duration threshold, the stream is recorded in the same recording before and after the interruption.
        # 
        # *   If a live stream is interrupted for longer than the interruption duration threshold, a new recording is generated.
        self.cycle_duration = cycle_duration
        # The recording format. Supported formats include M3U8, FLV, MP4, and CMAF. Valid values:
        # 
        # >  You need to specify at lease one of the RecordFormat and TranscodeRecordFormat parameters. If you set this parameter to m3u8 or cmaf, you must also specify the RecordFormat.N.SliceOssObjectPrefix and RecordFormat.N.SliceDuration parameters.
        # 
        # *   m3u8
        # *   flv
        # *   mp4
        # *   cmaf
        self.format = format
        # The naming format of a recording to store in OSS.
        # 
        # *   The name must be less than 256 bytes in length and can contain the {AppName}, {StreamName}, {Sequence}, {StartTime}, {EndTime}, {EscapedStartTime}, and {EscapedEndTime} variables.
        # *   The name must contain the {StartTime} and {EndTime} variables or the {EscapedStartTime} and {EscapedEndTime} variables.
        self.oss_object_prefix = oss_object_prefix
        # The duration of a single segment. Unit: seconds.
        # 
        # >  This parameter takes effect only if you set the RecordFormat.N.Format parameter to m3u8 or cmaf.
        # 
        # If you do not specify this parameter, the default value 30 seconds is used. Valid values: 5 to 30.
        self.slice_duration = slice_duration
        # The naming format of a segment.
        # 
        # >  This parameter is required only if you set the RecordFormat.N.Format parameter to m3u8 or cmaf.
        # 
        # *   By default, the duration of a segment is 30 seconds. The segment name must be less than 256 bytes in length and can contain the {AppName}, {StreamName}, {UnixTimestamp}, and {Sequence} variables.
        # *   The segment name must contain the {UnixTimestamp} and {Sequence} variables.
        self.slice_oss_object_prefix = slice_oss_object_prefix

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cycle_duration is not None:
            result['CycleDuration'] = self.cycle_duration
        if self.format is not None:
            result['Format'] = self.format
        if self.oss_object_prefix is not None:
            result['OssObjectPrefix'] = self.oss_object_prefix
        if self.slice_duration is not None:
            result['SliceDuration'] = self.slice_duration
        if self.slice_oss_object_prefix is not None:
            result['SliceOssObjectPrefix'] = self.slice_oss_object_prefix
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CycleDuration') is not None:
            self.cycle_duration = m.get('CycleDuration')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('OssObjectPrefix') is not None:
            self.oss_object_prefix = m.get('OssObjectPrefix')
        if m.get('SliceDuration') is not None:
            self.slice_duration = m.get('SliceDuration')
        if m.get('SliceOssObjectPrefix') is not None:
            self.slice_oss_object_prefix = m.get('SliceOssObjectPrefix')
        return self


class AddLiveAppRecordConfigRequestTranscodeRecordFormat(TeaModel):
    def __init__(
        self,
        cycle_duration: int = None,
        format: str = None,
        oss_object_prefix: str = None,
        slice_duration: int = None,
        slice_oss_object_prefix: str = None,
    ):
        # The transcoded stream recording cycle. Unit: seconds. If you do not specify this parameter, the default value 6 hours is used.
        self.cycle_duration = cycle_duration
        # The transcoded stream recording format. Supported formats include M3U8, FLV, MP4, and CMAF. Valid values:
        # 
        # >  If you set this parameter to m3u8 or cmaf, you must also specify the TranscodeRecordFormat.N.SliceOssObjectPrefix and TranscodeRecordFormat.N.SliceDuration parameters.
        # 
        # *   m3u8
        # *   flv
        # *   mp4
        # *   cmaf
        self.format = format
        # The naming format of a transcoded stream recording to store in OSS.
        # 
        # *   The name must be less than 256 bytes in length and can contain the {AppName}, {StreamName}, {Sequence}, {StartTime}, {EndTime}, {EscapedStartTime}, and {EscapedEndTime} variables.
        # *   The name must contain the {StartTime} and {EndTime} variables or the {EscapedStartTime} and {EscapedEndTime} variables.
        self.oss_object_prefix = oss_object_prefix
        # The duration of a single segment in a transcoded stream recording. Unit: seconds.
        # 
        # >  This parameter takes effect only if you set the TranscodeRecordFormat.N.Format parameter to m3u8 or cmaf.
        # 
        # If you do not specify this parameter, the default value 30 seconds is used. Valid values: 5 to 30.
        self.slice_duration = slice_duration
        # The naming format of a segment in a transcoded stream recording.
        # 
        # >  This parameter is required only if you set the TranscodeRecordFormat.N.Format parameter to m3u8 or cmaf.
        # 
        # *   By default, the duration of a segment is 30 seconds. The segment name must be less than 256 bytes in length and can contain the {AppName}, {StreamName}, {UnixTimestamp}, and {Sequence} variables.
        # *   The segment name must contain the {UnixTimestamp} and {Sequence} variables.
        self.slice_oss_object_prefix = slice_oss_object_prefix

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cycle_duration is not None:
            result['CycleDuration'] = self.cycle_duration
        if self.format is not None:
            result['Format'] = self.format
        if self.oss_object_prefix is not None:
            result['OssObjectPrefix'] = self.oss_object_prefix
        if self.slice_duration is not None:
            result['SliceDuration'] = self.slice_duration
        if self.slice_oss_object_prefix is not None:
            result['SliceOssObjectPrefix'] = self.slice_oss_object_prefix
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CycleDuration') is not None:
            self.cycle_duration = m.get('CycleDuration')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('OssObjectPrefix') is not None:
            self.oss_object_prefix = m.get('OssObjectPrefix')
        if m.get('SliceDuration') is not None:
            self.slice_duration = m.get('SliceDuration')
        if m.get('SliceOssObjectPrefix') is not None:
            self.slice_oss_object_prefix = m.get('SliceOssObjectPrefix')
        return self


class AddLiveAppRecordConfigRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        delay_time: int = None,
        domain_name: str = None,
        end_time: str = None,
        on_demand: int = None,
        oss_bucket: str = None,
        oss_endpoint: str = None,
        owner_id: int = None,
        record_format: List[AddLiveAppRecordConfigRequestRecordFormat] = None,
        security_token: str = None,
        start_time: str = None,
        stream_name: str = None,
        transcode_record_format: List[AddLiveAppRecordConfigRequestTranscodeRecordFormat] = None,
        transcode_templates: List[str] = None,
    ):
        # The name of the application to which the live stream belongs. The value of this parameter must be the same as the application name in the ingest URL. Otherwise, the configuration does not take effect. If you want to match all applications, specify an asterisk (\\*) as the value.
        # 
        # This parameter is required.
        self.app_name = app_name
        # Duration for stream concatenation. If the live streaming interruption exceeds the set concatenation duration, a new file will be generated. The concatenation duration can be set between 15 to 21600 seconds.
        self.delay_time = delay_time
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        # Recording end time. Format: <i>yyyy-MM-dd</i>T<i>HH:mm:ss</i>Z (UTC time).
        # > The difference between EndTime and StartTime should not exceed 7 days; if it does, it will be calculated as 7 days. This is only valid for stream-level recording (when StreamName is not empty).
        self.end_time = end_time
        # Specifies whether to enable on-demand recording. Valid values:
        # 
        # *   **0**: disables on-demand recording.
        # *   **1**: enables on-demand recording by using the HTTP callback method.
        # *   **2**: enables on-demand recording by parsing the stream ingest parameters.
        # *   **7**: By default, ApsaraVideo Live does not automatically record live streams. You can call the [RealTimeRecordCommand](https://help.aliyun.com/document_detail/2847882.html) operation to manually start or stop recording.
        # 
        # >  If you set the OnDemand parameter to **1**, you need to call the [AddLiveRecordNotifyConfig](https://help.aliyun.com/document_detail/2847891.html) operation to configure the OnDemandUrl parameter. Otherwise, ApsaraVideo Live does not perform on-demand recording.
        self.on_demand = on_demand
        # The name of the OSS bucket where live streaming recording files are stored. To store recorded files in OSS, you need to create an OSS bucket in advance. For creation method, please refer to [Configure OSS](https://help.aliyun.com/document_detail/84932.html).
        # 
        # This parameter is required.
        self.oss_bucket = oss_bucket
        # The endpoint of the OSS bucket. 
        # To store live stream recordings in OSS, you need to create an OSS bucket in advance. For more information, see Configure OSS.
        # 
        # This parameter is required.
        self.oss_endpoint = oss_endpoint
        self.owner_id = owner_id
        # The recording details.
        self.record_format = record_format
        self.security_token = security_token
        # Start time of the recording. Format: <i>yyyy-MM-dd</i>T<i>HH:mm:ss</i>Z (UTC time).
        # > The set time must be within 7 days of the actual streaming start time, and is only valid for stream-level recording (when StreamName is not empty).
        self.start_time = start_time
        # Stream broadcast name.
        self.stream_name = stream_name
        # The transcoded stream recording details.
        self.transcode_record_format = transcode_record_format
        # Transcoding stream recording template group.
        self.transcode_templates = transcode_templates

    def validate(self):
        if self.record_format:
            for k in self.record_format:
                if k:
                    k.validate()
        if self.transcode_record_format:
            for k in self.transcode_record_format:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.delay_time is not None:
            result['DelayTime'] = self.delay_time
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.on_demand is not None:
            result['OnDemand'] = self.on_demand
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        result['RecordFormat'] = []
        if self.record_format is not None:
            for k in self.record_format:
                result['RecordFormat'].append(k.to_map() if k else None)
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        result['TranscodeRecordFormat'] = []
        if self.transcode_record_format is not None:
            for k in self.transcode_record_format:
                result['TranscodeRecordFormat'].append(k.to_map() if k else None)
        if self.transcode_templates is not None:
            result['TranscodeTemplates'] = self.transcode_templates
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DelayTime') is not None:
            self.delay_time = m.get('DelayTime')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OnDemand') is not None:
            self.on_demand = m.get('OnDemand')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        self.record_format = []
        if m.get('RecordFormat') is not None:
            for k in m.get('RecordFormat'):
                temp_model = AddLiveAppRecordConfigRequestRecordFormat()
                self.record_format.append(temp_model.from_map(k))
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        self.transcode_record_format = []
        if m.get('TranscodeRecordFormat') is not None:
            for k in m.get('TranscodeRecordFormat'):
                temp_model = AddLiveAppRecordConfigRequestTranscodeRecordFormat()
                self.transcode_record_format.append(temp_model.from_map(k))
        if m.get('TranscodeTemplates') is not None:
            self.transcode_templates = m.get('TranscodeTemplates')
        return self


class AddLiveAppRecordConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveAppRecordConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddLiveAppRecordConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveAppRecordConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveAppSnapshotConfigRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        callback: str = None,
        domain_name: str = None,
        oss_bucket: str = None,
        oss_endpoint: str = None,
        overwrite_oss_object: str = None,
        owner_id: int = None,
        security_token: str = None,
        sequence_oss_object: str = None,
        time_interval: int = None,
    ):
        # The name of the application to which the live stream belongs. The value of this parameter must be the same as the application name in the ingest URL. Otherwise, the configuration does not take effect. The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). The name cannot start with a hyphen (-) or underscore (_). You can also specify an asterisk (\\*) as the value to match all applications.
        # 
        # This parameter is required.
        self.app_name = app_name
        # The callback URL that is used to receive notifications about snapshot capture.
        self.callback = callback
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        # The name of the OSS bucket.
        # 
        # After the configuration is complete, you can search for specific snapshots in the OSS console based on the callback information. You must create the OSS bucket in advance. For more information, see [Configure OSS](https://help.aliyun.com/document_detail/84932.html).
        # 
        # This parameter is required.
        self.oss_bucket = oss_bucket
        # The endpoint of the OSS bucket.
        # 
        # After the configuration is complete, you can search for specific snapshots in the OSS console based on the callback information. You must configure the OSS endpoint in advance. For more information, see [Configure OSS](https://help.aliyun.com/document_detail/84932.html).
        # 
        # This parameter is required.
        self.oss_endpoint = oss_endpoint
        # The naming format of snapshots that are stored in the overwrite mode, which means that a new snapshot overwrites the previous snapshot.
        # 
        # *   The name must be less than 256 bytes in length.
        # *   Only JPG images are supported.
        # *   The name can contain variables such as {AppName} and {StreamName}.
        self.overwrite_oss_object = overwrite_oss_object
        self.owner_id = owner_id
        self.security_token = security_token
        # The naming format of snapshots that are stored in sequence,
        # 
        # which means that a new snapshot does not overwrite the previous snapshot. You can call the [DescribeLiveStreamSnapshotInfo](https://help.aliyun.com/document_detail/2847902.html) operation to query the snapshots that were captured within a specific time period.
        # 
        # *   The name must be less than 256 bytes in length.
        # *   Only JPG images are supported.
        # *   The name can contain variables such as {AppName}, {StreamName}, {UnixTimestamp}, and {Sequence}. The name must contain at least one of the {UnixTimestamp} and {Sequence} variables.
        self.sequence_oss_object = sequence_oss_object
        # The interval at which snapshots are captured. Unit: seconds. Valid values: **5 to 3600**.
        # 
        # This parameter is required.
        self.time_interval = time_interval

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.callback is not None:
            result['Callback'] = self.callback
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        if self.overwrite_oss_object is not None:
            result['OverwriteOssObject'] = self.overwrite_oss_object
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.sequence_oss_object is not None:
            result['SequenceOssObject'] = self.sequence_oss_object
        if self.time_interval is not None:
            result['TimeInterval'] = self.time_interval
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('Callback') is not None:
            self.callback = m.get('Callback')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        if m.get('OverwriteOssObject') is not None:
            self.overwrite_oss_object = m.get('OverwriteOssObject')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('SequenceOssObject') is not None:
            self.sequence_oss_object = m.get('SequenceOssObject')
        if m.get('TimeInterval') is not None:
            self.time_interval = m.get('TimeInterval')
        return self


class AddLiveAppSnapshotConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveAppSnapshotConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddLiveAppSnapshotConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveAppSnapshotConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveAudioAuditConfigRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        biz_type: str = None,
        domain_name: str = None,
        oss_bucket: str = None,
        oss_endpoint: str = None,
        oss_object: str = None,
        owner_id: int = None,
        region_id: str = None,
        stream_name: str = None,
    ):
        # The name of the application to which the live stream belongs. The value of this parameter must be the same as the application name in the ingest URL. Otherwise, the configuration does not take effect. The application name is case-sensitive.
        # 
        # This parameter is required.
        self.app_name = app_name
        # The business type. You can specify a model. The default value is the domain name.
        self.biz_type = biz_type
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        # The name of the OSS bucket in which the recording is stored.
        self.oss_bucket = oss_bucket
        # The endpoint of OSS.
        self.oss_endpoint = oss_endpoint
        # The name of the recording stored in OSS.
        self.oss_object = oss_object
        self.owner_id = owner_id
        self.region_id = region_id
        # The name of the live stream. The value of this parameter must be the same as the stream name in the ingest URL. Otherwise, the configuration does not take effect. The stream name is case-sensitive.
        # 
        # This parameter is required.
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        if self.oss_object is not None:
            result['OssObject'] = self.oss_object
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        if m.get('OssObject') is not None:
            self.oss_object = m.get('OssObject')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class AddLiveAudioAuditConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveAudioAuditConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddLiveAudioAuditConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveAudioAuditConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveAudioAuditNotifyConfigRequest(TeaModel):
    def __init__(
        self,
        callback: str = None,
        callback_template: str = None,
        domain_name: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The callback URL. This URL is used to receive callback notifications about violations in audio.
        self.callback = callback
        # The callback template. Valid values:
        # 
        # *   **{DomainName}**: the streaming domain.
        # *   **{AppName}**: the name of the application to which the live stream belongs.
        # *   **{StreamName}**: the name of the live stream.
        # *   **{Timestamp}**: the time when the callback is returned. The value of this field is a UNIX timestamp. Unit: seconds.
        # *   **{Result}**: the moderation results.
        self.callback_template = callback_template
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        self.owner_id = owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.callback is not None:
            result['Callback'] = self.callback
        if self.callback_template is not None:
            result['CallbackTemplate'] = self.callback_template
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Callback') is not None:
            self.callback = m.get('Callback')
        if m.get('CallbackTemplate') is not None:
            self.callback_template = m.get('CallbackTemplate')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class AddLiveAudioAuditNotifyConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveAudioAuditNotifyConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddLiveAudioAuditNotifyConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveAudioAuditNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveCenterTransferRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        dst_url: str = None,
        end_time: str = None,
        owner_id: int = None,
        region_id: str = None,
        start_time: str = None,
        stream_name: str = None,
        transfer_args: str = None,
    ):
        # The name of the application to which the live stream belongs. The value of this parameter must be the same as the application name for the live stream that you want to relay. Otherwise, the configuration does not take effect. You can view the application name on the [Stream Management](https://help.aliyun.com/document_detail/197397.html) page of the ApsaraVideo Live console.
        # 
        # This parameter is required.
        self.app_name = app_name
        # The streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        # The third-party URL to which the live stream is relayed. You can add only one URL.
        # 
        # >  The protocol that the URL uses must be the same as the protocol of the live stream. Only URLs over RTMP and SRT are supported.
        # 
        # This parameter is required.
        self.dst_url = dst_url
        # The end time of stream relay. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # >  The end time must be later than the start time.
        self.end_time = end_time
        self.owner_id = owner_id
        self.region_id = region_id
        # The start time of stream relay. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time
        # The name of the live stream. You can view the stream name on the [Stream Management](https://help.aliyun.com/document_detail/197397.html) page of the ApsaraVideo Live console.
        # 
        # This parameter is required.
        self.stream_name = stream_name
        # The validity period of stream relay. Valid values:
        # 
        # *   **always**: The stream can always be relayed.
        # *   **time**: The stream can be relayed in a specified time period.
        # 
        # >  If you set this parameter to **time**, **StartTime** and **EndTime** are required.
        # 
        # This parameter is required.
        self.transfer_args = transfer_args

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.dst_url is not None:
            result['DstUrl'] = self.dst_url
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.transfer_args is not None:
            result['TransferArgs'] = self.transfer_args
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DstUrl') is not None:
            self.dst_url = m.get('DstUrl')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('TransferArgs') is not None:
            self.transfer_args = m.get('TransferArgs')
        return self


class AddLiveCenterTransferResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveCenterTransferResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddLiveCenterTransferResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveCenterTransferResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveDetectNotifyConfigRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        notify_url: str = None,
        owner_id: int = None,
        security_token: str = None,
    ):
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        # The callback URL that is used to receive callback notifications about violations, such as pornographic content and politically sensitive content, detected in live streams.
        # 
        # This parameter is required.
        self.notify_url = notify_url
        self.owner_id = owner_id
        self.security_token = security_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.notify_url is not None:
            result['NotifyUrl'] = self.notify_url
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('NotifyUrl') is not None:
            self.notify_url = m.get('NotifyUrl')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class AddLiveDetectNotifyConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveDetectNotifyConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddLiveDetectNotifyConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveDetectNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveDomainRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The key of the tag.
        self.key = key
        # The value of the tag.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class AddLiveDomainRequest(TeaModel):
    def __init__(
        self,
        check_url: str = None,
        domain_name: str = None,
        live_domain_type: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region: str = None,
        resource_group_id: str = None,
        scope: str = None,
        security_token: str = None,
        tag: List[AddLiveDomainRequestTag] = None,
        top_level_domain: str = None,
    ):
        # The URL that is used for health checks.
        self.check_url = check_url
        # The ingest domain or streaming domain that you want to add. Wildcard domain names that start with a period (.) are supported.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        # The type of the domain name. Valid values:
        # 
        # *   **liveVideo**: streaming domain. This value is required if you set the DomainName parameter to a streaming domain.
        # *   **liveEdge**: ingest domain. This value is required if you set the DomainName parameter to an ingest domain.
        # 
        # This parameter is required.
        self.live_domain_type = live_domain_type
        self.owner_account = owner_account
        self.owner_id = owner_id
        # The region in which the domain name resides. Valid values:
        # 
        # *   **cn-beijing**: China (Beijing)
        # *   **cn-shanghai**: China (Shanghai)
        # *   **cn-shenzhen**: China (Shenzhen)
        # *   **cn-qingdao**: China (Qingdao)
        # *   **ap-southeast-1**: Singapore
        # *   **eu-central-1**: Germany (Frankfurt)
        # *   **ap-northeast-1**: Japan (Tokyo)
        # *   **ap-southeast-5**: Indonesia (Jakarta)
        # 
        # >  Make sure that the settings of the Region and Scope parameters do not conflict with each other.
        # 
        # This parameter is required.
        self.region = region
        # The ID of the resource group. For more information about resource groups, see [Resource groups](https://help.aliyun.com/document_detail/2381067.html).
        self.resource_group_id = resource_group_id
        # The edge group. This parameter is applicable to users of level 3 or higher in mainland China and users outside mainland China. Valid values:
        # 
        # *   **domestic**: mainland China. This is the default value.
        # *   **overseas**: outside mainland China.
        # *   **global**: regions in and outside mainland China.
        self.scope = scope
        self.security_token = security_token
        # The tags.
        self.tag = tag
        # The top-level domain name.
        self.top_level_domain = top_level_domain

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_url is not None:
            result['CheckUrl'] = self.check_url
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.live_domain_type is not None:
            result['LiveDomainType'] = self.live_domain_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region is not None:
            result['Region'] = self.region
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.top_level_domain is not None:
            result['TopLevelDomain'] = self.top_level_domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckUrl') is not None:
            self.check_url = m.get('CheckUrl')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('LiveDomainType') is not None:
            self.live_domain_type = m.get('LiveDomainType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = AddLiveDomainRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TopLevelDomain') is not None:
            self.top_level_domain = m.get('TopLevelDomain')
        return self


class AddLiveDomainResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveDomainResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddLiveDomainResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveDomainMappingRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        pull_domain: str = None,
        push_domain: str = None,
        security_token: str = None,
    ):
        self.owner_id = owner_id
        # The streaming domain. The type of the domain name is **liveVideo**.
        # 
        # This parameter is required.
        self.pull_domain = pull_domain
        # The ingest domain. The type of the domain name is **liveEdge**.
        # 
        # This parameter is required.
        self.push_domain = push_domain
        self.security_token = security_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pull_domain is not None:
            result['PullDomain'] = self.pull_domain
        if self.push_domain is not None:
            result['PushDomain'] = self.push_domain
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PullDomain') is not None:
            self.pull_domain = m.get('PullDomain')
        if m.get('PushDomain') is not None:
            self.push_domain = m.get('PushDomain')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class AddLiveDomainMappingResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveDomainMappingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddLiveDomainMappingResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveDomainMappingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveDomainPlayMappingRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        play_domain: str = None,
        pull_domain: str = None,
        region_id: str = None,
    ):
        self.owner_id = owner_id
        # The sub-streaming domain.
        # 
        # This parameter is required.
        self.play_domain = play_domain
        # The main streaming domain.
        # 
        # This parameter is required.
        self.pull_domain = pull_domain
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.play_domain is not None:
            result['PlayDomain'] = self.play_domain
        if self.pull_domain is not None:
            result['PullDomain'] = self.pull_domain
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PlayDomain') is not None:
            self.play_domain = m.get('PlayDomain')
        if m.get('PullDomain') is not None:
            self.pull_domain = m.get('PullDomain')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class AddLiveDomainPlayMappingResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveDomainPlayMappingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddLiveDomainPlayMappingResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveDomainPlayMappingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveMessageGroupBandRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        banned_users: List[str] = None,
        data_center: str = None,
        group_id: str = None,
    ):
        # The application ID.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The users whom you want to mute.
        # 
        # This parameter is required.
        self.banned_users = banned_users
        # The data center. It must be the same as the data center that was specified when you called the [CreateLiveMessageApp](https://help.aliyun.com/document_detail/2848162.html) operation to create the interactive messaging application.
        # 
        # >  Valid values: cn-shanghai and ap-southeast-1 (Singapore).
        self.data_center = data_center
        # The group ID.
        # 
        # This parameter is required.
        self.group_id = group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.banned_users is not None:
            result['BannedUsers'] = self.banned_users
        if self.data_center is not None:
            result['DataCenter'] = self.data_center
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('BannedUsers') is not None:
            self.banned_users = m.get('BannedUsers')
        if m.get('DataCenter') is not None:
            self.data_center = m.get('DataCenter')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class AddLiveMessageGroupBandShrinkRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        banned_users_shrink: str = None,
        data_center: str = None,
        group_id: str = None,
    ):
        # The application ID.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The users whom you want to mute.
        # 
        # This parameter is required.
        self.banned_users_shrink = banned_users_shrink
        # The data center. It must be the same as the data center that was specified when you called the [CreateLiveMessageApp](https://help.aliyun.com/document_detail/2848162.html) operation to create the interactive messaging application.
        # 
        # >  Valid values: cn-shanghai and ap-southeast-1 (Singapore).
        self.data_center = data_center
        # The group ID.
        # 
        # This parameter is required.
        self.group_id = group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.banned_users_shrink is not None:
            result['BannedUsers'] = self.banned_users_shrink
        if self.data_center is not None:
            result['DataCenter'] = self.data_center
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('BannedUsers') is not None:
            self.banned_users_shrink = m.get('BannedUsers')
        if m.get('DataCenter') is not None:
            self.data_center = m.get('DataCenter')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class AddLiveMessageGroupBandResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveMessageGroupBandResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddLiveMessageGroupBandResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveMessageGroupBandResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLivePackageConfigRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        ignore_transcode: bool = None,
        owner_id: int = None,
        part_duration: int = None,
        protocol: str = None,
        region_id: str = None,
        segment_duration: int = None,
        segment_num: int = None,
        stream_name: str = None,
    ):
        # The application name. The value of this parameter must be the same as the application name that is specified in the ingest URL. Otherwise, the configuration does not take effect. The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). The name cannot start with a hyphen (-) or underscore (_). You can also specify an asterisk (\\*) as the value to match all applications.
        # 
        # This parameter is required.
        self.app_name = app_name
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        # Specifies whether to ignore the transcoded stream. Valid values:
        # 
        # *   **true** (default)
        # *   **false**\
        self.ignore_transcode = ignore_transcode
        self.owner_id = owner_id
        # The part length. Unit: milliseconds.
        # 
        # *   If the value of SegmentDuration is 1, the valid values of this parameter are 100 to 500 and the default value of this parameter is 350.
        # *   If the value of SegmentDuration is 2, the valid values of this parameter are 100 to 1000 and the default value of this parameter is 700.
        # *   This parameter takes effect only if Protocol is set to LLHLS_TS or LLHLS_CMAF.
        self.part_duration = part_duration
        # The streaming protocol and encapsulation format. Valid values:
        # 
        # *   **HLS_CMAF**\
        # *   **LLHLS_TS** (low latency)
        # *   **LLHLS_CMAF** (low latency)
        # *   **DASH_CMAF**\
        # *   **HLSDASH_CMAF**\
        # 
        # This parameter is required.
        self.protocol = protocol
        self.region_id = region_id
        # The segment length. Unit: seconds.
        # 
        # *   If Protocol is set to HLS_CMAF: Valid values: 1 to 10. Default value: 5.
        # *   If Protocol is set to LLHLS_TS or LLHLS_CMAF: Valid values: 1 to 2. Default value: 1.
        self.segment_duration = segment_duration
        # The number of segments.
        # 
        # *   Valid values: 3 to 10.
        # *   Default value: 3.
        self.segment_num = segment_num
        # The stream name. The value of this parameter must be the same as the stream name that is specified in the ingest URL. Otherwise, the configuration does not take effect. The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). The name cannot start with a hyphen (-) or underscore (_). You can also specify an asterisk (\\*) as the value to match all streams.
        # 
        # This parameter is required.
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.ignore_transcode is not None:
            result['IgnoreTranscode'] = self.ignore_transcode
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.part_duration is not None:
            result['PartDuration'] = self.part_duration
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.segment_duration is not None:
            result['SegmentDuration'] = self.segment_duration
        if self.segment_num is not None:
            result['SegmentNum'] = self.segment_num
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('IgnoreTranscode') is not None:
            self.ignore_transcode = m.get('IgnoreTranscode')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PartDuration') is not None:
            self.part_duration = m.get('PartDuration')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SegmentDuration') is not None:
            self.segment_duration = m.get('SegmentDuration')
        if m.get('SegmentNum') is not None:
            self.segment_num = m.get('SegmentNum')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class AddLivePackageConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLivePackageConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddLivePackageConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLivePackageConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLivePullStreamInfoConfigRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        end_time: str = None,
        owner_id: int = None,
        region_id: str = None,
        source_url: str = None,
        start_time: str = None,
        stream_name: str = None,
    ):
        # The name of the application to which the live stream belongs. This parameter is determined by you.
        # 
        # This parameter is required.
        self.app_name = app_name
        # The domain name used for stream pulling. It is the main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        # The time when stream pulling ends.
        # 
        # The time range specified by the StartTime and EndTime parameters cannot exceed seven days. The time specified by the EndTime parameter must be later than the current time. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        # 
        # This parameter is required.
        self.end_time = end_time
        self.owner_id = owner_id
        self.region_id = region_id
        # The origin URL of the live stream. You can specify multiple URLs. Separate them with semicolons (;).
        # 
        # >  You can pull only live streams in the Real-Time Messaging Protocol (RTMP), Flash Video (FLV), HTTP Live Streaming (HLS), and Secure Reliable Transport (SRT) formats.
        # 
        # This parameter is required.
        self.source_url = source_url
        # The time when stream pulling starts.
        # 
        # The time range specified by the StartTime and EndTime parameters cannot exceed seven days. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        # 
        # This parameter is required.
        self.start_time = start_time
        # The name of the live stream. This parameter is determined by you.
        # 
        # This parameter is required.
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.source_url is not None:
            result['SourceUrl'] = self.source_url
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SourceUrl') is not None:
            self.source_url = m.get('SourceUrl')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class AddLivePullStreamInfoConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLivePullStreamInfoConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddLivePullStreamInfoConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLivePullStreamInfoConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveRecordNotifyConfigRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        need_status_notify: bool = None,
        notify_auth_key: str = None,
        notify_req_auth: bool = None,
        notify_url: str = None,
        on_demand_url: str = None,
        owner_id: int = None,
        security_token: str = None,
    ):
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        # Specifies whether to enable callbacks for recording status. Valid values:
        # 
        # *   true: enables callbacks for recording status. If you set this parameter to **true**, an example of recording status callback is returned.
        # *   false (default): disables callbacks for recording status.
        self.need_status_notify = need_status_notify
        self.notify_auth_key = notify_auth_key
        self.notify_req_auth = notify_req_auth
        # The callback URL that is used to receive notifications about recording events and status.
        # 
        # >  The URL must start with `http://` or `https://`. For more information, see [Callbacks for live stream recording](https://help.aliyun.com/document_detail/55016.html).
        # 
        # This parameter is required.
        self.notify_url = notify_url
        # The callback URL for on-demand recordings.
        # 
        # >  The URL must start with `http://` or `https://`. For more information, see [On-demand recording](https://help.aliyun.com/document_detail/85910.html).
        self.on_demand_url = on_demand_url
        self.owner_id = owner_id
        self.security_token = security_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.need_status_notify is not None:
            result['NeedStatusNotify'] = self.need_status_notify
        if self.notify_auth_key is not None:
            result['NotifyAuthKey'] = self.notify_auth_key
        if self.notify_req_auth is not None:
            result['NotifyReqAuth'] = self.notify_req_auth
        if self.notify_url is not None:
            result['NotifyUrl'] = self.notify_url
        if self.on_demand_url is not None:
            result['OnDemandUrl'] = self.on_demand_url
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('NeedStatusNotify') is not None:
            self.need_status_notify = m.get('NeedStatusNotify')
        if m.get('NotifyAuthKey') is not None:
            self.notify_auth_key = m.get('NotifyAuthKey')
        if m.get('NotifyReqAuth') is not None:
            self.notify_req_auth = m.get('NotifyReqAuth')
        if m.get('NotifyUrl') is not None:
            self.notify_url = m.get('NotifyUrl')
        if m.get('OnDemandUrl') is not None:
            self.on_demand_url = m.get('OnDemandUrl')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class AddLiveRecordNotifyConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveRecordNotifyConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddLiveRecordNotifyConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveRecordNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveRecordVodConfigRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        auto_compose: str = None,
        compose_vod_transcode_group_id: str = None,
        cycle_duration: int = None,
        domain_name: str = None,
        on_demand: int = None,
        owner_id: int = None,
        region_id: str = None,
        storage_location: str = None,
        stream_name: str = None,
        vod_transcode_group_id: str = None,
    ):
        # The name of the application to which the live stream belongs. You can view the application name on the [Stream Management](https://help.aliyun.com/document_detail/197397.html) page of the ApsaraVideo Live console.
        # 
        # This parameter is required.
        self.app_name = app_name
        # Specifies whether to enable automatic merging. If you set the value to **ON**, automatic merging is enabled and the ComposeVodTranscodeGroupId parameter is required. If you do not specify this parameter, automatic merging is disabled.
        # 
        # >  If you enable automatic merging, the VOD files that are created from live streams are automatically merged by using the editing and production feature of ApsaraVideo VOD. For information about the billing of the feature, see [Billing of value-added services](https://help.aliyun.com/document_detail/188310.html).
        self.auto_compose = auto_compose
        # The ID of the transcoding template group in ApsaraVideo VOD that is used to transcode the video file. The video file is generated by merging the VOD files created from live streams.
        # 
        # > 
        # 
        # *   This parameter is required if you set the AutoCompose parameter to ON.
        # 
        # *   For more information about automatic merging and transcoding, see [FAQ about Live-to-VOD](https://help.aliyun.com/document_detail/99726.html).
        # 
        # *   For information about the billing of transcoding in ApsaraVideo VOD, see [Billing of basic services](https://help.aliyun.com/document_detail/188308.html).
        self.compose_vod_transcode_group_id = compose_vod_transcode_group_id
        # The recording cycle. Unit: seconds. Valid values: **300 to 21600**. Default value: **3600**.
        self.cycle_duration = cycle_duration
        # The main streaming domain.
        # 
        # >  Make sure that ApsaraVideo VOD is activated in the same region as the live center of the streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        # Specifies whether to enable on-demand recording. Valid values:
        # 
        # *   **0** (default): disables on-demand recording.
        # *   **1**: enables on-demand recording.
        self.on_demand = on_demand
        self.owner_id = owner_id
        self.region_id = region_id
        # The storage location.
        self.storage_location = storage_location
        # The name of the live stream. You can view the stream name on the [Stream Management](https://help.aliyun.com/document_detail/197397.html) page of the ApsaraVideo Live console.
        self.stream_name = stream_name
        # The ID of the transcoding template group in ApsaraVideo VOD.
        # 
        # This parameter is required.
        self.vod_transcode_group_id = vod_transcode_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.auto_compose is not None:
            result['AutoCompose'] = self.auto_compose
        if self.compose_vod_transcode_group_id is not None:
            result['ComposeVodTranscodeGroupId'] = self.compose_vod_transcode_group_id
        if self.cycle_duration is not None:
            result['CycleDuration'] = self.cycle_duration
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.on_demand is not None:
            result['OnDemand'] = self.on_demand
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.storage_location is not None:
            result['StorageLocation'] = self.storage_location
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.vod_transcode_group_id is not None:
            result['VodTranscodeGroupId'] = self.vod_transcode_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('AutoCompose') is not None:
            self.auto_compose = m.get('AutoCompose')
        if m.get('ComposeVodTranscodeGroupId') is not None:
            self.compose_vod_transcode_group_id = m.get('ComposeVodTranscodeGroupId')
        if m.get('CycleDuration') is not None:
            self.cycle_duration = m.get('CycleDuration')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OnDemand') is not None:
            self.on_demand = m.get('OnDemand')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StorageLocation') is not None:
            self.storage_location = m.get('StorageLocation')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('VodTranscodeGroupId') is not None:
            self.vod_transcode_group_id = m.get('VodTranscodeGroupId')
        return self


class AddLiveRecordVodConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveRecordVodConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddLiveRecordVodConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveRecordVodConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveSnapshotDetectPornConfigRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        interval: int = None,
        oss_bucket: str = None,
        oss_endpoint: str = None,
        oss_object: str = None,
        owner_id: int = None,
        scene: List[str] = None,
        security_token: str = None,
    ):
        # The name of the application to which the live stream belongs.
        # 
        # This parameter is required.
        self.app_name = app_name
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        # The interval at which snapshots are captured from the live stream. Valid values: **5 to 3600**. Unit: seconds.
        self.interval = interval
        # The name of the OSS bucket.
        # 
        # After the review is complete, you can search for specific violations in the OSS console based on the callback information. You must create the OSS bucket in advance. For more information, see [Configure content moderation](https://help.aliyun.com/document_detail/199449.html).
        # 
        # This parameter is required.
        self.oss_bucket = oss_bucket
        # The endpoint of the Object Storage Service (OSS) bucket.
        # 
        # After the review is complete, you can search for specific violations in the OSS console based on the callback information. You must configure the OSS endpoint in advance. For more information, see [Configure content moderation](https://help.aliyun.com/document_detail/199449.html).
        # 
        # This parameter is required.
        self.oss_endpoint = oss_endpoint
        # The name of the snapshot that stores violations such as pornographic content and politically sensitive content.
        self.oss_object = oss_object
        self.owner_id = owner_id
        # Scene list detection.
        self.scene = scene
        self.security_token = security_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        if self.oss_object is not None:
            result['OssObject'] = self.oss_object
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        if m.get('OssObject') is not None:
            self.oss_object = m.get('OssObject')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class AddLiveSnapshotDetectPornConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveSnapshotDetectPornConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddLiveSnapshotDetectPornConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveSnapshotDetectPornConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveSnapshotNotifyConfigRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        notify_auth_key: str = None,
        notify_req_auth: str = None,
        notify_url: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        # The callback authentication key. The key must be 16 to 32 characters in length and can contain only letters and digits.
        # 
        # > This parameter is required if you set the NotifyReqAuth parameter to **yes**.
        self.notify_auth_key = notify_auth_key
        # Specifies whether to enable callback authentication. Valid values:
        # 
        # *   **yes**\
        # *   **no** (default)
        # 
        # > This parameter is required if you set the NotifyAuthKey parameter to yes.
        self.notify_req_auth = notify_req_auth
        # The callback URL. Specify a valid URL that is up to 500 characters in length.
        # 
        # This parameter is required.
        self.notify_url = notify_url
        self.owner_id = owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.notify_auth_key is not None:
            result['NotifyAuthKey'] = self.notify_auth_key
        if self.notify_req_auth is not None:
            result['NotifyReqAuth'] = self.notify_req_auth
        if self.notify_url is not None:
            result['NotifyUrl'] = self.notify_url
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('NotifyAuthKey') is not None:
            self.notify_auth_key = m.get('NotifyAuthKey')
        if m.get('NotifyReqAuth') is not None:
            self.notify_req_auth = m.get('NotifyReqAuth')
        if m.get('NotifyUrl') is not None:
            self.notify_url = m.get('NotifyUrl')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class AddLiveSnapshotNotifyConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveSnapshotNotifyConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddLiveSnapshotNotifyConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveSnapshotNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveStreamMergeRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        end_time: str = None,
        in_app_name_1: str = None,
        in_app_name_2: str = None,
        in_stream_name_1: str = None,
        in_stream_name_2: str = None,
        live_merger: str = None,
        merge_parameters: str = None,
        owner_id: int = None,
        protocol: str = None,
        region_id: str = None,
        start_time: str = None,
        stream_name: str = None,
    ):
        # The name of the application that generates the output stream. The value must be the same as the application name in the ingest URL of the output stream. Otherwise, the configuration does not take effect. You cannot set the value to an asterisk (\\*).
        # 
        # This parameter is required.
        self.app_name = app_name
        # The streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        # The end time of the stream mixing.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # >  The interval between the start time and the end time must be within 7 days.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The name of the application that generates the input primary stream. The value must be the same as the application name that is specified in the ingest URL of the primary stream. Otherwise, the configuration does not take effect.
        # 
        # This parameter is required.
        self.in_app_name_1 = in_app_name_1
        # The name of the application that generates the input secondary stream. The value must be the same as the application name that is specified in the ingest URL of the secondary stream. Otherwise, the configuration does not take effect.
        # 
        # This parameter is required.
        self.in_app_name_2 = in_app_name_2
        # The name of the input primary stream. The value must be the same as the stream name that is specified in the ingest URL of the primary stream. Otherwise, the configuration does not take effect.
        # 
        # This parameter is required.
        self.in_stream_name_1 = in_stream_name_1
        # The name of the input secondary stream. The value must be the same as the stream name that is specified in the ingest URL of the secondary stream. Otherwise, the configuration does not take effect.
        # 
        # This parameter is required.
        self.in_stream_name_2 = in_stream_name_2
        self.live_merger = live_merger
        self.merge_parameters = merge_parameters
        self.owner_id = owner_id
        # The streaming protocol. Valid values:
        # 
        # *   **rtmp**: This is the default value.
        # *   **rtc**\
        self.protocol = protocol
        self.region_id = region_id
        # The start time of the stream mixing.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # This parameter is required.
        self.start_time = start_time
        # The name of the output stream. The value must be the same as the stream name in the ingest URL of the output stream. Otherwise, the configuration does not take effect. You cannot set the value to an asterisk (\\*).
        # 
        # This parameter is required.
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.in_app_name_1 is not None:
            result['InAppName1'] = self.in_app_name_1
        if self.in_app_name_2 is not None:
            result['InAppName2'] = self.in_app_name_2
        if self.in_stream_name_1 is not None:
            result['InStreamName1'] = self.in_stream_name_1
        if self.in_stream_name_2 is not None:
            result['InStreamName2'] = self.in_stream_name_2
        if self.live_merger is not None:
            result['LiveMerger'] = self.live_merger
        if self.merge_parameters is not None:
            result['MergeParameters'] = self.merge_parameters
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InAppName1') is not None:
            self.in_app_name_1 = m.get('InAppName1')
        if m.get('InAppName2') is not None:
            self.in_app_name_2 = m.get('InAppName2')
        if m.get('InStreamName1') is not None:
            self.in_stream_name_1 = m.get('InStreamName1')
        if m.get('InStreamName2') is not None:
            self.in_stream_name_2 = m.get('InStreamName2')
        if m.get('LiveMerger') is not None:
            self.live_merger = m.get('LiveMerger')
        if m.get('MergeParameters') is not None:
            self.merge_parameters = m.get('MergeParameters')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class AddLiveStreamMergeResponseBody(TeaModel):
    def __init__(
        self,
        message: str = None,
        request_id: str = None,
    ):
        self.message = message
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveStreamMergeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddLiveStreamMergeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveStreamMergeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveStreamTranscodeRequest(TeaModel):
    def __init__(
        self,
        app: str = None,
        domain: str = None,
        encrypt_parameters: str = None,
        lazy: str = None,
        owner_id: int = None,
        region_id: str = None,
        template: str = None,
    ):
        # The name of the application to which the live stream belongs.
        # 
        # *   The transcoding template takes effect only if the value of this parameter is the same as the application name that is specified in the ingest URL. The name can be up to 256 characters in length and can contain digits, letters, hyphens (-), and underscores (_).
        # *   You can also set this parameter to an asterisk (\\*). Asterisks (\\*) can match any string, including an empty string.
        # 
        # >  If you configure a transcoding template for which App is set to an asterisk (\\*), the transcoding template is used only if no transcoding template for which App is set to the same value as AppName in the ingest URL exists.
        # 
        # This parameter is required.
        self.app = app
        # The name of the main streaming domain.
        # 
        # This parameter is required.
        self.domain = domain
        # The encryption configuration. The value is a JSON string. The following fields are included in the syntax:
        # 
        # *   EncryptType: the type of the encryption. Set the value to **aliyun**.
        # *   KmsKeyID: the ID of the CMK in KMS.
        # *   KmsKeyExpireInterval: the validity period of the CMK. Valid values: **60 to 3600**. Unit: seconds.
        self.encrypt_parameters = encrypt_parameters
        # Specifies whether to use the load-on-demand mechanism for transcoding. Default value: **yes**.
        self.lazy = lazy
        self.owner_id = owner_id
        self.region_id = region_id
        # The transcoding template. Valid values:
        # 
        # *   Standard transcoding template:
        # 
        #     *   **lld**: low definition
        #     *   **lsd**: standard definition
        #     *   **lhd**: high definition
        #     *   **lud**: ultra-high definition
        # 
        # *   Narrowband HD™ transcoding template:
        # 
        #     *   **ld**: low definition
        #     *   **sd**: standard definition
        #     *   **hd**: high definition
        #     *   **ud**: ultra-high definition
        # 
        # This parameter is required.
        self.template = template

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app is not None:
            result['App'] = self.app
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.encrypt_parameters is not None:
            result['EncryptParameters'] = self.encrypt_parameters
        if self.lazy is not None:
            result['Lazy'] = self.lazy
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.template is not None:
            result['Template'] = self.template
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('EncryptParameters') is not None:
            self.encrypt_parameters = m.get('EncryptParameters')
        if m.get('Lazy') is not None:
            self.lazy = m.get('Lazy')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Template') is not None:
            self.template = m.get('Template')
        return self


class AddLiveStreamTranscodeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveStreamTranscodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddLiveStreamTranscodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveStreamTranscodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveStreamWatermarkRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        domain: str = None,
        height: int = None,
        name: str = None,
        offset_corner: str = None,
        owner_id: int = None,
        picture_url: str = None,
        ref_height: int = None,
        ref_width: int = None,
        region_id: str = None,
        transparency: int = None,
        type: int = None,
        xoffset: float = None,
        yoffset: float = None,
    ):
        # The description of the watermark.
        self.description = description
        # The streaming domain.
        self.domain = domain
        # The height of the watermark. Unit: pixels. The height of the watermark is scaled in proportion to the height of the background video.
        # 
        # This parameter is required.
        self.height = height
        # The name of the watermark.
        # 
        # This parameter is required.
        self.name = name
        # The location of the watermark. Valid values:
        # 
        # *   TopLeft: the upper-left corner.
        # *   TopRight: the upper-right corner.
        # *   BottomLeft: the lower-left corner.
        # *   BottomRight: the lower-right corner.
        # 
        # This parameter is required.
        self.offset_corner = offset_corner
        self.owner_id = owner_id
        # The URL of the watermark image.
        # 
        # This parameter is required.
        self.picture_url = picture_url
        # The height of the background video. Unit: pixels.
        # 
        # This parameter is required.
        self.ref_height = ref_height
        # The width of the background video. Unit: pixels.
        # 
        # This parameter is required.
        self.ref_width = ref_width
        self.region_id = region_id
        # The transparency of the watermark. A smaller value indicates a more transparent watermark. Valid values: 0 to 255.
        # 
        # This parameter is required.
        self.transparency = transparency
        # The type of the watermark. Valid values:
        # 
        # *   **0**: image.
        # *   **1**: text. Only image watermarks are supported.
        # 
        # This parameter is required.
        self.type = type
        # The offset of the watermark along the x-axis. Unit: pixels.
        # 
        # >  In this case, the value of the RefWidth parameter is used as the reference. If the OffsetCorner parameter is set to TopLeft, the value of the XOffset parameter indicates the x-axis offset of the upper-left corner of the watermark relative to that of the background video. The directions from the coordinate axes to the center of the background video are positive. In other words, the x-axis is positive toward the right.
        # 
        # This parameter is required.
        self.xoffset = xoffset
        # The offset of the watermark along the y-axis. Unit: pixels.
        # 
        # >  In this case, the value of the RefHeight parameter is used as the reference. If the OffsetCorner parameter is set to TopLeft, the value of the YOffset parameter indicates the y-axis offset of the upper-left corner of the watermark relative to that of the background video. The directions from the coordinate axes to the center of the background video are positive. In other words, the y-axis is positive downward.
        # 
        # This parameter is required.
        self.yoffset = yoffset

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.height is not None:
            result['Height'] = self.height
        if self.name is not None:
            result['Name'] = self.name
        if self.offset_corner is not None:
            result['OffsetCorner'] = self.offset_corner
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.picture_url is not None:
            result['PictureUrl'] = self.picture_url
        if self.ref_height is not None:
            result['RefHeight'] = self.ref_height
        if self.ref_width is not None:
            result['RefWidth'] = self.ref_width
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.transparency is not None:
            result['Transparency'] = self.transparency
        if self.type is not None:
            result['Type'] = self.type
        if self.xoffset is not None:
            result['XOffset'] = self.xoffset
        if self.yoffset is not None:
            result['YOffset'] = self.yoffset
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OffsetCorner') is not None:
            self.offset_corner = m.get('OffsetCorner')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PictureUrl') is not None:
            self.picture_url = m.get('PictureUrl')
        if m.get('RefHeight') is not None:
            self.ref_height = m.get('RefHeight')
        if m.get('RefWidth') is not None:
            self.ref_width = m.get('RefWidth')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Transparency') is not None:
            self.transparency = m.get('Transparency')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('XOffset') is not None:
            self.xoffset = m.get('XOffset')
        if m.get('YOffset') is not None:
            self.yoffset = m.get('YOffset')
        return self


class AddLiveStreamWatermarkResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        template_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The ID of the watermark template.
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class AddLiveStreamWatermarkResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddLiveStreamWatermarkResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveStreamWatermarkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveStreamWatermarkRuleRequest(TeaModel):
    def __init__(
        self,
        app: str = None,
        description: str = None,
        domain: str = None,
        name: str = None,
        owner_id: int = None,
        region_id: str = None,
        stream: str = None,
        template_id: str = None,
    ):
        # The name of the application to which the live stream belongs.
        # 
        # This parameter is required.
        self.app = app
        # The description of the custom rule.
        self.description = description
        # The streaming domain.
        # 
        # This parameter is required.
        self.domain = domain
        # The name of the custom rule.
        # 
        # This parameter is required.
        self.name = name
        self.owner_id = owner_id
        self.region_id = region_id
        # The name of the live stream. The following rules apply:
        # 
        # *   A stream name can be exactly matched. Example: liveStreamA.
        # *   Fuzzy match is also supported. The use of an asterisk (`*`) allows all approximate matches to be found.
        # *   You can place the asterisk before or after an approximate string.
        # 
        # 
        # 
        # >*   Fuzzy match: Only one asterisk (`*`) before or after an approximate string is allowed. The approximate string must be enclosed in `()`. Separate multiple strings with vertical bars (`|`).
        # >*   For example, `*(t1|t2)` matches all streams whose name has the `t1` or `t2` suffix, and `(abc|123)*` matches all streams whose name has the `abc` or `123` prefix.
        # 
        # This parameter is required.
        self.stream = stream
        # The ID of the watermark template.
        # 
        # >  You can obtain the template ID by checking the value of the TemplateId parameter that is returned by the [AddLiveStreamWatermark](https://help.aliyun.com/document_detail/410759.html) operation.
        # 
        # This parameter is required.
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app is not None:
            result['App'] = self.app
        if self.description is not None:
            result['Description'] = self.description
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.stream is not None:
            result['Stream'] = self.stream
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Stream') is not None:
            self.stream = m.get('Stream')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class AddLiveStreamWatermarkRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        rule_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The ID of the watermark rule.
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class AddLiveStreamWatermarkRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddLiveStreamWatermarkRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveStreamWatermarkRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddPlaylistItemsRequest(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        owner_id: int = None,
        program_config: str = None,
        program_id: str = None,
        program_items: str = None,
        region_id: str = None,
    ):
        # The ID of the production studio.
        # 
        # *   If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation, check the value of the response parameter CasterId to obtain the ID.
        # *   If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        # 
        # >  You can find the ID of the production studio in the Instance ID/Name column.
        # 
        # The production studio must use the following configurations:
        # 
        # *   **NormType**: 3****. You need to call the **CreateCaster** operation to create a production studio for lightweight carousel playback in advance.
        # *   **CasterTemplate**: lp_noTranscode.
        # *   **channelEnable**: 0.
        # *   **programEffect**: 1.
        # 
        # This parameter is required.
        self.caster_id = caster_id
        self.owner_id = owner_id
        # The configurations of the episode list. If the episode list is added to the production studio for the first time, specify this parameter to pass in the initial configurations. For more information, see the **ProgramConfig** section of this topic.
        self.program_config = program_config
        # The ID of the episode list. If you do not specify this parameter, an episode list is created by default.
        self.program_id = program_id
        # The episodes that you want to add to the production studio. The value is a JSON string. For more information, see the **InputProgramItem** section of this topic.
        # 
        # This parameter is required.
        self.program_items = program_items
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.program_config is not None:
            result['ProgramConfig'] = self.program_config
        if self.program_id is not None:
            result['ProgramId'] = self.program_id
        if self.program_items is not None:
            result['ProgramItems'] = self.program_items
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProgramConfig') is not None:
            self.program_config = m.get('ProgramConfig')
        if m.get('ProgramId') is not None:
            self.program_id = m.get('ProgramId')
        if m.get('ProgramItems') is not None:
            self.program_items = m.get('ProgramItems')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class AddPlaylistItemsResponseBodyItemsFailedItems(TeaModel):
    def __init__(
        self,
        item_id: str = None,
        item_name: str = None,
    ):
        # The ID of the episode.
        self.item_id = item_id
        # The name of the episode.
        self.item_name = item_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        return self


class AddPlaylistItemsResponseBodyItemsSuccessItems(TeaModel):
    def __init__(
        self,
        item_id: str = None,
        item_name: str = None,
    ):
        # The ID of the episode.
        self.item_id = item_id
        # The name of the episode.
        self.item_name = item_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        return self


class AddPlaylistItemsResponseBodyItems(TeaModel):
    def __init__(
        self,
        failed_items: List[AddPlaylistItemsResponseBodyItemsFailedItems] = None,
        success_items: List[AddPlaylistItemsResponseBodyItemsSuccessItems] = None,
    ):
        # The episodes that failed to be added.
        self.failed_items = failed_items
        # The episodes that were added.
        self.success_items = success_items

    def validate(self):
        if self.failed_items:
            for k in self.failed_items:
                if k:
                    k.validate()
        if self.success_items:
            for k in self.success_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FailedItems'] = []
        if self.failed_items is not None:
            for k in self.failed_items:
                result['FailedItems'].append(k.to_map() if k else None)
        result['SuccessItems'] = []
        if self.success_items is not None:
            for k in self.success_items:
                result['SuccessItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.failed_items = []
        if m.get('FailedItems') is not None:
            for k in m.get('FailedItems'):
                temp_model = AddPlaylistItemsResponseBodyItemsFailedItems()
                self.failed_items.append(temp_model.from_map(k))
        self.success_items = []
        if m.get('SuccessItems') is not None:
            for k in m.get('SuccessItems'):
                temp_model = AddPlaylistItemsResponseBodyItemsSuccessItems()
                self.success_items.append(temp_model.from_map(k))
        return self


class AddPlaylistItemsResponseBody(TeaModel):
    def __init__(
        self,
        items: AddPlaylistItemsResponseBodyItems = None,
        program_id: str = None,
        request_id: str = None,
    ):
        # The information about the episodes.
        self.items = items
        # The ID of the episode list. You can use the ID as a request parameter in the API operation that is used to remove episodes, query episodes, edit an episode list, delete an episode list, query the information about an episode list, start playing an episode list, or stop playing an episode list.
        self.program_id = program_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['Items'] = self.items.to_map()
        if self.program_id is not None:
            result['ProgramId'] = self.program_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Items') is not None:
            temp_model = AddPlaylistItemsResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        if m.get('ProgramId') is not None:
            self.program_id = m.get('ProgramId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddPlaylistItemsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddPlaylistItemsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddPlaylistItemsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddRtsLiveStreamTranscodeRequest(TeaModel):
    def __init__(
        self,
        app: str = None,
        audio_bitrate: int = None,
        audio_channel_num: int = None,
        audio_codec: str = None,
        audio_profile: str = None,
        audio_rate: int = None,
        delete_bframes: bool = None,
        domain: str = None,
        fps: int = None,
        gop: str = None,
        height: int = None,
        lazy: str = None,
        opus: bool = None,
        owner_id: int = None,
        profile: int = None,
        region_id: str = None,
        template: str = None,
        template_type: str = None,
        video_bitrate: int = None,
        width: int = None,
    ):
        # The name of the application to which the live stream belongs. Value requirements:
        # 
        # *   The name can contain letters, digits, underscores (_), and hyphens (-).
        # *   We recommend that you specify a name that is more than three characters in length. The name must start with a letter or digit.
        # 
        # This parameter is required.
        self.app = app
        # The bitrate of the output audio. Unit: Kbit/s. Valid values: **1** to **1000**.
        # 
        # >  This parameter is required if you set the TemplateType parameter to audio.
        self.audio_bitrate = audio_bitrate
        # The number of sound channels. Valid values:
        # 
        # *   **1**: mono
        # *   **2**: stereo
        self.audio_channel_num = audio_channel_num
        # The audio encoder. Valid values:
        # 
        # *   **aac**\
        # *   **mp3**\
        # 
        # > If you want to use the Opus encoding format, set the Opus parameter to true.
        self.audio_codec = audio_codec
        # The audio codec profile. Valid values:
        # 
        # *   **aac_low**\
        # *   **aac_he**\
        # *   **aac_he_v2**\
        # *   **aac_ld**\
        self.audio_profile = audio_profile
        # The audio sampling rate. Valid values: **22050 to 96000**. The value 44100 is commonly used. Unit: Hz.
        # 
        # > If you set the AudioProfile parameter to aac_ld, the audio sampling rate cannot exceed 44,100 Hz.
        self.audio_rate = audio_rate
        # Specifies whether to remove B-frames during transcoding. Valid values:
        # 
        # >  This parameter is required if you set the TemplateType parameter to h264, h264-nbhd, or h264-origin.
        # 
        # *   **true**: removes B-frames.
        # *   **false**: retains B-frames. This is the default value.
        # 
        # > If you do not specify this parameter, the default value **false** is used.
        self.delete_bframes = delete_bframes
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain = domain
        # The frame rate of the output video. Unit: FPS. Valid values: **1** to **60**.
        # 
        # >  This parameter is required if you set the TemplateType parameter to h264, h264-nbhd, or h264-origin.
        self.fps = fps
        # The group of pictures (GOP) size of the output video. This parameter is used to specify the keyframe interval. Unit: seconds. Valid values: **1** to **3**.
        self.gop = gop
        # The height of the output video. Unit: pixels.
        # 
        # >  This parameter is required if you set the TemplateType parameter to h264, h264-nbhd, or h264-origin.
        # 
        # The value must comply with the following rules:****\
        # 
        # *   **Height ≥ 100**: The height of the video is no less than 100 pixels.
        # *   **max(Height,Width) ≤ 2560**: The width or height of the video, whichever is greater, cannot exceed 2,560 pixels.
        # *   **min(Height,Width) ≤ 1440**: The width or height of the video, whichever is smaller, cannot exceed 1,440 pixels.
        # 
        # For example, a resolution of 1560 × 1560 pixels is invalid.
        # 
        # > An original quality template needs to retain the source information. Therefore, the video resolution cannot exceed 4K.
        self.height = height
        # Specifies whether to trigger transcoding only when a stream is pulled. Valid values:
        # 
        # *   **yes**: triggers transcoding only when a stream is pulled.
        # *   **no**: triggers transcoding whenever a stream is ingested, no matter whether the stream is pulled.
        self.lazy = lazy
        # Specifies whether to transcode audio to the Opus format to be compatible with native WebRTC. Valid values:
        # 
        # *   **true**: transcodes audio to the Opus format.
        # *   **false**: does not transcode audio to the Opus format.
        # 
        # > If you do not specify this parameter, the default value **false** is used.
        self.opus = opus
        self.owner_id = owner_id
        # The codec profile. The video codec profile determines how ApsaraVideo Live performs codec on the video. In normal cases, a greater value indicates a higher image quality and requires more codec resources. Valid values:
        # 
        # *   **1**: baseline, which is suitable for mobile devices.
        # *   **2**: main, which is suitable for standard-definition devices.
        # *   **3**: high, which is suitable for high-definition devices.
        self.profile = profile
        self.region_id = region_id
        # The name of the transcoding template. Value requirements:
        # 
        # *   The name can contain letters, digits, underscores (_), and hyphens (-).
        # *   We recommend that you specify a name that is more than three characters in length. The name must start with a letter or digit.
        # 
        # > The name cannot be the same as that of a default transcoding template.
        # 
        # This parameter is required.
        self.template = template
        # The type of the transcoding template.
        # 
        # If you set this parameter to h264, h264-nbhd, or h264-origin, you must also specify the Height, Width, FPS, VideoBitrate, and DeleteBframes parameters. Valid values:
        # 
        # *   **h264**: H.264 standard transcoding template.
        # *   **h264-nbhd**: H.264 Narrowband HD™ transcoding template.
        # *   **h264-origin**: H.264 original quality template. If you use this type of template, the same transcoding parameters of the video source are retained by default.
        # *   **audio**: audio-only transcoding template. If you use this type of template, images are removed from the video source and an audio-only stream is generated. In addition, you must also specify the AudioBitrate parameter.
        # 
        # This parameter is required.
        self.template_type = template_type
        # The bitrate of the output video. Unit: Kbit/s. Valid values: **1** to **6000**.
        # 
        # >  This parameter is required if you set the TemplateType parameter to h264, h264-nbhd, or h264-origin.
        # 
        # > The bitrate of the output video is as close to the value that you specify as possible, but not exactly the same as the value, especially when the value is excessively large or small.
        self.video_bitrate = video_bitrate
        # The width of the output video. Unit: pixels.
        # 
        # >  This parameter is required if you set the TemplateType parameter to h264, h264-nbhd, or h264-origin.
        # 
        # The value must comply with the following rules:
        # 
        # *   **Width ≥ 100**: The width of the video is no less than 100 pixels.
        # *   **max(Height,Width) ≤ 2560**: The width or height of the video, whichever is greater, cannot exceed 2,560 pixels.
        # *   **min(Height,Width) ≤ 1440**: The width or height of the video, whichever is smaller, cannot exceed 1,440 pixels.
        # 
        # For example, a resolution of 1560 × 1560 pixels is invalid.
        # 
        # > An original quality template needs to retain the source information. Therefore, the video resolution cannot exceed 4K.
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app is not None:
            result['App'] = self.app
        if self.audio_bitrate is not None:
            result['AudioBitrate'] = self.audio_bitrate
        if self.audio_channel_num is not None:
            result['AudioChannelNum'] = self.audio_channel_num
        if self.audio_codec is not None:
            result['AudioCodec'] = self.audio_codec
        if self.audio_profile is not None:
            result['AudioProfile'] = self.audio_profile
        if self.audio_rate is not None:
            result['AudioRate'] = self.audio_rate
        if self.delete_bframes is not None:
            result['DeleteBframes'] = self.delete_bframes
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.fps is not None:
            result['FPS'] = self.fps
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.height is not None:
            result['Height'] = self.height
        if self.lazy is not None:
            result['Lazy'] = self.lazy
        if self.opus is not None:
            result['Opus'] = self.opus
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.template is not None:
            result['Template'] = self.template
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        if self.video_bitrate is not None:
            result['VideoBitrate'] = self.video_bitrate
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('AudioBitrate') is not None:
            self.audio_bitrate = m.get('AudioBitrate')
        if m.get('AudioChannelNum') is not None:
            self.audio_channel_num = m.get('AudioChannelNum')
        if m.get('AudioCodec') is not None:
            self.audio_codec = m.get('AudioCodec')
        if m.get('AudioProfile') is not None:
            self.audio_profile = m.get('AudioProfile')
        if m.get('AudioRate') is not None:
            self.audio_rate = m.get('AudioRate')
        if m.get('DeleteBframes') is not None:
            self.delete_bframes = m.get('DeleteBframes')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('FPS') is not None:
            self.fps = m.get('FPS')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Lazy') is not None:
            self.lazy = m.get('Lazy')
        if m.get('Opus') is not None:
            self.opus = m.get('Opus')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Template') is not None:
            self.template = m.get('Template')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        if m.get('VideoBitrate') is not None:
            self.video_bitrate = m.get('VideoBitrate')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class AddRtsLiveStreamTranscodeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddRtsLiveStreamTranscodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddRtsLiveStreamTranscodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddRtsLiveStreamTranscodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddShowIntoShowListRequestShowList(TeaModel):
    def __init__(
        self,
        duration: int = None,
        live_input_type: int = None,
        repeat_times: int = None,
        resource_id: str = None,
        resource_type: str = None,
        resource_url: str = None,
        show_name: str = None,
    ):
        # The duration of the episode. Unit: seconds.
        # 
        # >  You can specify only one of the **RepeatTimes** and **Duration** parameters.
        self.duration = duration
        # The custom type label.
        self.live_input_type = live_input_type
        # The number of times the episode repeats after the first playback is complete. Default value: 0.
        # 
        # > 
        # 
        # *   You can specify only one of the **RepeatTimes** and **Duration** parameters.
        # 
        # *   The RepeatTimes parameter specifies the number of repetitions. For example, if you set the value to 0, the episode is to be played once. If you set the value to 1, the episode is to be played twice.
        self.repeat_times = repeat_times
        # The ID of the resource.
        self.resource_id = resource_id
        # The resource type. Valid values:
        # 
        # *   live: live stream
        # *   vod: on-demand video
        # *   pic: image
        # 
        # > 
        # 
        # *   When you select media resources from ApsaraVideo VOD, we recommend that you select resources that are stored in hosted OSS buckets. Resources stored in non-hosted OSS buckets have a validity period. Pay attention to the validity if you select resources that are stored in non-hosted OSS buckets.
        # 
        # *   You can add a live stream from ApsaraVideo Live or by using a third-party URL.
        # *   You can add an on-demand video from ApsaraVideo VOD or by using a third-party URL, or add an on-demand image.
        self.resource_type = resource_type
        # The URL of the resource.
        self.resource_url = resource_url
        # The name of the episode.
        self.show_name = show_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['duration'] = self.duration
        if self.live_input_type is not None:
            result['liveInputType'] = self.live_input_type
        if self.repeat_times is not None:
            result['repeatTimes'] = self.repeat_times
        if self.resource_id is not None:
            result['resourceId'] = self.resource_id
        if self.resource_type is not None:
            result['resourceType'] = self.resource_type
        if self.resource_url is not None:
            result['resourceUrl'] = self.resource_url
        if self.show_name is not None:
            result['showName'] = self.show_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('duration') is not None:
            self.duration = m.get('duration')
        if m.get('liveInputType') is not None:
            self.live_input_type = m.get('liveInputType')
        if m.get('repeatTimes') is not None:
            self.repeat_times = m.get('repeatTimes')
        if m.get('resourceId') is not None:
            self.resource_id = m.get('resourceId')
        if m.get('resourceType') is not None:
            self.resource_type = m.get('resourceType')
        if m.get('resourceUrl') is not None:
            self.resource_url = m.get('resourceUrl')
        if m.get('showName') is not None:
            self.show_name = m.get('showName')
        return self


class AddShowIntoShowListRequest(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        duration: int = None,
        live_input_type: int = None,
        owner_id: int = None,
        region_id: str = None,
        repeat_times: int = None,
        resource_id: str = None,
        resource_type: str = None,
        resource_url: str = None,
        show_name: str = None,
        spot: int = None,
        is_batch_mode: bool = None,
        show_list: List[AddShowIntoShowListRequestShowList] = None,
    ):
        # The ID of the production studio.
        # 
        # *   If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation, check the value of the response parameter CasterId to obtain the ID.
        # *   If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        # 
        # >  You can find the ID of the production studio in the Instance ID/Name column.
        # 
        # This parameter is required.
        self.caster_id = caster_id
        # The duration of the episode. Unit: seconds.
        # 
        # > You can specify only one of the **RepeatTimes** and **Duration** parameters.
        self.duration = duration
        # The custom type label.
        self.live_input_type = live_input_type
        self.owner_id = owner_id
        self.region_id = region_id
        # The number of times the episode repeats after the first playback is complete. The default value is 0.
        # 
        # > 
        # 
        # *   You can specify only one of the **RepeatTimes** and **Duration** parameters. - The RepeatTimes parameter specifies the number of repetitions. For example, if you set the value to -1, the episode is to be played for infinite times. If you set the value to 0, the episode is to be played once. If you set the value to 1, the episode is to be played twice.
        self.repeat_times = repeat_times
        # The ID of the resource.
        self.resource_id = resource_id
        # The resource type. Valid values:
        # 
        # *   live: live stream
        # *   vod: on-demand video
        # *   pic: image
        # 
        # > 
        # 
        # *   When you select media resources from ApsaraVideo VOD, we recommend that you select resources that are stored in hosted OSS buckets. Resources stored in non-hosted OSS buckets have a validity period. Pay attention to the validity if you select resources that are stored in non-hosted OSS buckets. - You can add a live stream from ApsaraVideo Live or by using a third-party URL. - You can add an on-demand video from ApsaraVideo VOD or by using a third-party URL, or add an on-demand image.
        self.resource_type = resource_type
        # The URL of the resource.
        self.resource_url = resource_url
        # The name of the episode.
        self.show_name = show_name
        # The position of the episode in the episode list. Position indexes start from 0. By default, the episode is added to the end of the episode list.
        self.spot = spot
        # Specifies whether to add multiple episodes to the episode list at a time. Valid values:
        # 
        # *   true: adds multiple episodes to the episode list at a time.
        # *   false: adds a single episode to the episode list.
        # 
        # > If you do not specify this parameter or this parameter is left empty, a single episode is to be added to the episode list.
        self.is_batch_mode = is_batch_mode
        # The episodes that you want to add to the episode list. Each episode has a unique name and resource URL.
        self.show_list = show_list

    def validate(self):
        if self.show_list:
            for k in self.show_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.live_input_type is not None:
            result['LiveInputType'] = self.live_input_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.repeat_times is not None:
            result['RepeatTimes'] = self.repeat_times
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_url is not None:
            result['ResourceUrl'] = self.resource_url
        if self.show_name is not None:
            result['ShowName'] = self.show_name
        if self.spot is not None:
            result['Spot'] = self.spot
        if self.is_batch_mode is not None:
            result['isBatchMode'] = self.is_batch_mode
        result['showList'] = []
        if self.show_list is not None:
            for k in self.show_list:
                result['showList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('LiveInputType') is not None:
            self.live_input_type = m.get('LiveInputType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RepeatTimes') is not None:
            self.repeat_times = m.get('RepeatTimes')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceUrl') is not None:
            self.resource_url = m.get('ResourceUrl')
        if m.get('ShowName') is not None:
            self.show_name = m.get('ShowName')
        if m.get('Spot') is not None:
            self.spot = m.get('Spot')
        if m.get('isBatchMode') is not None:
            self.is_batch_mode = m.get('isBatchMode')
        self.show_list = []
        if m.get('showList') is not None:
            for k in m.get('showList'):
                temp_model = AddShowIntoShowListRequestShowList()
                self.show_list.append(temp_model.from_map(k))
        return self


class AddShowIntoShowListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        show_id: str = None,
        failed_list: str = None,
        successful_show_ids: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The ID of the episode.
        self.show_id = show_id
        # The list of resources that failed to be added and the reason for failure.
        self.failed_list = failed_list
        # The IDs of the episodes that were added.
        self.successful_show_ids = successful_show_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.show_id is not None:
            result['ShowId'] = self.show_id
        if self.failed_list is not None:
            result['failedList'] = self.failed_list
        if self.successful_show_ids is not None:
            result['successfulShowIds'] = self.successful_show_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ShowId') is not None:
            self.show_id = m.get('ShowId')
        if m.get('failedList') is not None:
            self.failed_list = m.get('failedList')
        if m.get('successfulShowIds') is not None:
            self.successful_show_ids = m.get('successfulShowIds')
        return self


class AddShowIntoShowListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddShowIntoShowListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddShowIntoShowListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddStudioLayoutRequest(TeaModel):
    def __init__(
        self,
        bg_image_config: str = None,
        caster_id: str = None,
        common_config: str = None,
        layer_order_config_list: str = None,
        layout_name: str = None,
        layout_type: str = None,
        media_input_config_list: str = None,
        owner_id: int = None,
        region_id: str = None,
        screen_input_config_list: str = None,
    ):
        # The background material configurations. The value is a JSON string. For more information, see **BgImageConfig**.
        # 
        # >  This parameter is required only if you set LayoutType to studio.
        self.bg_image_config = bg_image_config
        # The ID of the production studio.
        # 
        # >  The production studio must be a virtual studio that you create in advance. You can use the ApsaraVideo Live console or call the CreateCaster operation to create a virtual studio.
        # 
        # *   If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation, check the value of the response parameter CasterId to obtain the ID.
        # *   If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        # 
        # >  You can find the ID of the production studio in the Instance ID/Name column.
        # 
        # This parameter is required.
        self.caster_id = caster_id
        # The common layout configurations. The value is a JSON string. For more information, see **CommonConfig**.
        # 
        # >  This parameter is required only if you set LayoutType to common.
        self.common_config = common_config
        # The layer sorting configurations. The value is a JSON string. For more information, see **layerOrderConfig**. You can sort layers of background and multimedia materials. The chroma key layer cannot be sorted. A layer that is in the front of the code is placed behind other layers in the layout.
        self.layer_order_config_list = layer_order_config_list
        # The name of the layout.
        # 
        # This parameter is required.
        self.layout_name = layout_name
        # The type of the layout. Valid values:
        # 
        # *   **common**: If you set this parameter to common, you must specify the CommonConfig parameter.
        # *   **studio**: If you set this parameter to studio, you must specify the BgImageConfig and ScreenInputConfigList parameters. The MediaInputConfigList parameter is optional.
        # 
        # This parameter is required.
        self.layout_type = layout_type
        # The multimedia input configurations. The value is a JSON string. For more information, see **MediaInputConfig**.
        # 
        # >  This parameter is optional and is valid only if you set LayoutType to studio.
        self.media_input_config_list = media_input_config_list
        self.owner_id = owner_id
        self.region_id = region_id
        # The input configurations for chroma key. The value is a JSON string. For more information, see **ScreenInputConfig**.
        # 
        # >  This parameter is required only if you set LayoutType to studio.
        self.screen_input_config_list = screen_input_config_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bg_image_config is not None:
            result['BgImageConfig'] = self.bg_image_config
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.common_config is not None:
            result['CommonConfig'] = self.common_config
        if self.layer_order_config_list is not None:
            result['LayerOrderConfigList'] = self.layer_order_config_list
        if self.layout_name is not None:
            result['LayoutName'] = self.layout_name
        if self.layout_type is not None:
            result['LayoutType'] = self.layout_type
        if self.media_input_config_list is not None:
            result['MediaInputConfigList'] = self.media_input_config_list
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.screen_input_config_list is not None:
            result['ScreenInputConfigList'] = self.screen_input_config_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BgImageConfig') is not None:
            self.bg_image_config = m.get('BgImageConfig')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('CommonConfig') is not None:
            self.common_config = m.get('CommonConfig')
        if m.get('LayerOrderConfigList') is not None:
            self.layer_order_config_list = m.get('LayerOrderConfigList')
        if m.get('LayoutName') is not None:
            self.layout_name = m.get('LayoutName')
        if m.get('LayoutType') is not None:
            self.layout_type = m.get('LayoutType')
        if m.get('MediaInputConfigList') is not None:
            self.media_input_config_list = m.get('MediaInputConfigList')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ScreenInputConfigList') is not None:
            self.screen_input_config_list = m.get('ScreenInputConfigList')
        return self


class AddStudioLayoutResponseBody(TeaModel):
    def __init__(
        self,
        layout_id: str = None,
        request_id: str = None,
    ):
        # The ID of the layout. You can use the ID as a request parameter in the following operations: DeleteStudioLayout, ModifyStudioLayout, and DescribeStudioLayouts.
        self.layout_id = layout_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddStudioLayoutResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddStudioLayoutResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddStudioLayoutResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddTrancodeSEIRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        delay: int = None,
        domain_name: str = None,
        owner_id: int = None,
        pattern: str = None,
        region_id: str = None,
        repeat: int = None,
        stream_name: str = None,
        text: str = None,
    ):
        # The name of the application to which the live stream belongs. You can view the application name on the [Stream Management](https://help.aliyun.com/document_detail/197397.html) page of the ApsaraVideo Live console.
        # 
        # This parameter is required.
        self.app_name = app_name
        # The time period after which the SEI is inserted after the request is received. Unit: milliseconds.
        # 
        # This parameter is required.
        self.delay = delay
        # The streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        self.owner_id = owner_id
        # Specifies whether to append the SEI to each keyframe or frame. Valid values:
        # 
        # *   **keyframe**\
        # *   **frame**\
        # 
        # This parameter is required.
        self.pattern = pattern
        self.region_id = region_id
        # The number of times that the SEI is repeatedly inserted. A value of -1 specifies infinite times.
        # 
        # This parameter is required.
        self.repeat = repeat
        # The name of the live stream.
        # 
        # >  The value of this parameter must be the name of the source stream. This way, the SEI is inserted to all the transcoded streams.
        # 
        # This parameter is required.
        self.stream_name = stream_name
        # The SEI text. It can be up to 4,000 bytes in length.
        # 
        # This parameter is required.
        self.text = text

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.delay is not None:
            result['Delay'] = self.delay
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pattern is not None:
            result['Pattern'] = self.pattern
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.repeat is not None:
            result['Repeat'] = self.repeat
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.text is not None:
            result['Text'] = self.text
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('Delay') is not None:
            self.delay = m.get('Delay')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Pattern') is not None:
            self.pattern = m.get('Pattern')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Repeat') is not None:
            self.repeat = m.get('Repeat')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('Text') is not None:
            self.text = m.get('Text')
        return self


class AddTrancodeSEIResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddTrancodeSEIResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddTrancodeSEIResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddTrancodeSEIResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BanLiveMessageGroupRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        data_center: str = None,
        except_users: List[str] = None,
        group_id: str = None,
    ):
        # The application ID.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The data center. It must be the same as the data center that was specified when you called the [CreateLiveMessageApp](https://help.aliyun.com/document_detail/2848162.html) operation to create the interactive messaging application.
        # 
        # >  Valid values: cn-shanghai and ap-southeast-1 (Singapore).
        self.data_center = data_center
        # The users whom you do not want to mute when the group is muted.
        self.except_users = except_users
        # The group ID.
        # 
        # This parameter is required.
        self.group_id = group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.data_center is not None:
            result['DataCenter'] = self.data_center
        if self.except_users is not None:
            result['ExceptUsers'] = self.except_users
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('DataCenter') is not None:
            self.data_center = m.get('DataCenter')
        if m.get('ExceptUsers') is not None:
            self.except_users = m.get('ExceptUsers')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class BanLiveMessageGroupShrinkRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        data_center: str = None,
        except_users_shrink: str = None,
        group_id: str = None,
    ):
        # The application ID.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The data center. It must be the same as the data center that was specified when you called the [CreateLiveMessageApp](https://help.aliyun.com/document_detail/2848162.html) operation to create the interactive messaging application.
        # 
        # >  Valid values: cn-shanghai and ap-southeast-1 (Singapore).
        self.data_center = data_center
        # The users whom you do not want to mute when the group is muted.
        self.except_users_shrink = except_users_shrink
        # The group ID.
        # 
        # This parameter is required.
        self.group_id = group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.data_center is not None:
            result['DataCenter'] = self.data_center
        if self.except_users_shrink is not None:
            result['ExceptUsers'] = self.except_users_shrink
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('DataCenter') is not None:
            self.data_center = m.get('DataCenter')
        if m.get('ExceptUsers') is not None:
            self.except_users_shrink = m.get('ExceptUsers')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class BanLiveMessageGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BanLiveMessageGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BanLiveMessageGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BanLiveMessageGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchDeleteLiveDomainConfigsRequest(TeaModel):
    def __init__(
        self,
        domain_names: str = None,
        function_names: str = None,
        owner_account: str = None,
        owner_id: int = None,
        security_token: str = None,
    ):
        # The ingest domain or streaming domain. Separate multiple domain names with commas (,).
        # 
        # This parameter is required.
        self.domain_names = domain_names
        # The names of the features. Separate multiple features with commas (,). For more information, see **Features specified by the Functions parameter**.
        # 
        # This parameter is required.
        self.function_names = function_names
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.security_token = security_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_names is not None:
            result['DomainNames'] = self.domain_names
        if self.function_names is not None:
            result['FunctionNames'] = self.function_names
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainNames') is not None:
            self.domain_names = m.get('DomainNames')
        if m.get('FunctionNames') is not None:
            self.function_names = m.get('FunctionNames')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class BatchDeleteLiveDomainConfigsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchDeleteLiveDomainConfigsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchDeleteLiveDomainConfigsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchDeleteLiveDomainConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetOnlineUsersRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        group_id: str = None,
        user_ids: str = None,
    ):
        # The ID of the interactive messaging application.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The ID of the message group.
        # 
        # This parameter is required.
        self.group_id = group_id
        # The list of user IDs. Separate multiple user IDs with commas (,). You can specify a maximum of 20 user IDs.
        # 
        # This parameter is required.
        self.user_ids = user_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.user_ids is not None:
            result['UserIds'] = self.user_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('UserIds') is not None:
            self.user_ids = m.get('UserIds')
        return self


class BatchGetOnlineUsersResponseBodyResultOnlineUsers(TeaModel):
    def __init__(
        self,
        join_time: int = None,
        online: bool = None,
        user_id: str = None,
    ):
        # The time when the user joined the group. The value is a UTC timestamp. Unit: milliseconds.
        self.join_time = join_time
        # Indicates whether the user is online. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.online = online
        # The ID of the user.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.join_time is not None:
            result['JoinTime'] = self.join_time
        if self.online is not None:
            result['Online'] = self.online
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JoinTime') is not None:
            self.join_time = m.get('JoinTime')
        if m.get('Online') is not None:
            self.online = m.get('Online')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class BatchGetOnlineUsersResponseBodyResult(TeaModel):
    def __init__(
        self,
        online_users: List[BatchGetOnlineUsersResponseBodyResultOnlineUsers] = None,
    ):
        # The information about users.
        self.online_users = online_users

    def validate(self):
        if self.online_users:
            for k in self.online_users:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OnlineUsers'] = []
        if self.online_users is not None:
            for k in self.online_users:
                result['OnlineUsers'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.online_users = []
        if m.get('OnlineUsers') is not None:
            for k in m.get('OnlineUsers'):
                temp_model = BatchGetOnlineUsersResponseBodyResultOnlineUsers()
                self.online_users.append(temp_model.from_map(k))
        return self


class BatchGetOnlineUsersResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        result: BatchGetOnlineUsersResponseBodyResult = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The returned results.
        self.result = result

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            temp_model = BatchGetOnlineUsersResponseBodyResult()
            self.result = temp_model.from_map(m['Result'])
        return self


class BatchGetOnlineUsersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchGetOnlineUsersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchGetOnlineUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchSetLiveDomainConfigsRequest(TeaModel):
    def __init__(
        self,
        domain_names: str = None,
        functions: str = None,
        owner_account: str = None,
        owner_id: int = None,
        security_token: str = None,
    ):
        # The domain names that you want to batch configure. Supported domain names include ingest domains, main streaming domains, and sub-streaming domains. Separate multiple domain names with commas (,).
        # 
        # This parameter is required.
        self.domain_names = domain_names
        # The list of features.
        # 
        # Some features, such as `filetype_based_ttl_set`, support multiple configuration records. To update one of the configuration records, use `configId` to identify the record. For more information, see **Format of the Functions parameter** and **Features specified by the Functions parameter**.
        # 
        # This parameter is required.
        self.functions = functions
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.security_token = security_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_names is not None:
            result['DomainNames'] = self.domain_names
        if self.functions is not None:
            result['Functions'] = self.functions
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainNames') is not None:
            self.domain_names = m.get('DomainNames')
        if m.get('Functions') is not None:
            self.functions = m.get('Functions')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class BatchSetLiveDomainConfigsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchSetLiveDomainConfigsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchSetLiveDomainConfigsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchSetLiveDomainConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelMuteAllGroupUserRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        broad_cast_type: int = None,
        group_id: str = None,
        operator_user_id: str = None,
    ):
        # Interactive message application ID.
        # 
        # This parameter is required.
        self.app_id = app_id
        # 系统消息扩散类型，取值：
        # 
        # - 0：不扩散。
        # 
        # - 1：扩散到指定人。
        # 
        # - 2：扩散到群组。
        self.broad_cast_type = broad_cast_type
        # Message group ID.
        # 
        # This parameter is required.
        self.group_id = group_id
        # Operator\\"s UserId. > This parameter is required and the user must be the creator of the group.
        self.operator_user_id = operator_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.broad_cast_type is not None:
            result['BroadCastType'] = self.broad_cast_type
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.operator_user_id is not None:
            result['OperatorUserId'] = self.operator_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('BroadCastType') is not None:
            self.broad_cast_type = m.get('BroadCastType')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('OperatorUserId') is not None:
            self.operator_user_id = m.get('OperatorUserId')
        return self


class CancelMuteAllGroupUserResponseBodyResult(TeaModel):
    def __init__(
        self,
        success: bool = None,
    ):
        # Indicates whether the cancellation was successful, with values:
        # - true: Success. 
        # - false: Not successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelMuteAllGroupUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        result: CancelMuteAllGroupUserResponseBodyResult = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The returned result.
        self.result = result

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            temp_model = CancelMuteAllGroupUserResponseBodyResult()
            self.result = temp_model.from_map(m['Result'])
        return self


class CancelMuteAllGroupUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelMuteAllGroupUserResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelMuteAllGroupUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelMuteGroupUserRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        broad_cast_type: int = None,
        cancel_mute_user_list: List[str] = None,
        group_id: str = None,
        operator_user_id: str = None,
    ):
        # The ID of the interactive messaging application.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The mode in which system messages are broadcasted. Valid values:
        # 
        # *   0: specifies that system messages are not broadcasted. This is the default value.
        # *   1: specifies that system messages are broadcasted to specified users.
        # *   2: specifies that system messages are broadcasted to the message group.
        self.broad_cast_type = broad_cast_type
        # The IDs of the users.
        # 
        # This parameter is required.
        self.cancel_mute_user_list = cancel_mute_user_list
        # The ID of the message group.
        # 
        # This parameter is required.
        self.group_id = group_id
        # The ID of the user who performs the operation.
        self.operator_user_id = operator_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.broad_cast_type is not None:
            result['BroadCastType'] = self.broad_cast_type
        if self.cancel_mute_user_list is not None:
            result['CancelMuteUserList'] = self.cancel_mute_user_list
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.operator_user_id is not None:
            result['OperatorUserId'] = self.operator_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('BroadCastType') is not None:
            self.broad_cast_type = m.get('BroadCastType')
        if m.get('CancelMuteUserList') is not None:
            self.cancel_mute_user_list = m.get('CancelMuteUserList')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('OperatorUserId') is not None:
            self.operator_user_id = m.get('OperatorUserId')
        return self


class CancelMuteGroupUserShrinkRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        broad_cast_type: int = None,
        cancel_mute_user_list_shrink: str = None,
        group_id: str = None,
        operator_user_id: str = None,
    ):
        # The ID of the interactive messaging application.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The mode in which system messages are broadcasted. Valid values:
        # 
        # *   0: specifies that system messages are not broadcasted. This is the default value.
        # *   1: specifies that system messages are broadcasted to specified users.
        # *   2: specifies that system messages are broadcasted to the message group.
        self.broad_cast_type = broad_cast_type
        # The IDs of the users.
        # 
        # This parameter is required.
        self.cancel_mute_user_list_shrink = cancel_mute_user_list_shrink
        # The ID of the message group.
        # 
        # This parameter is required.
        self.group_id = group_id
        # The ID of the user who performs the operation.
        self.operator_user_id = operator_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.broad_cast_type is not None:
            result['BroadCastType'] = self.broad_cast_type
        if self.cancel_mute_user_list_shrink is not None:
            result['CancelMuteUserList'] = self.cancel_mute_user_list_shrink
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.operator_user_id is not None:
            result['OperatorUserId'] = self.operator_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('BroadCastType') is not None:
            self.broad_cast_type = m.get('BroadCastType')
        if m.get('CancelMuteUserList') is not None:
            self.cancel_mute_user_list_shrink = m.get('CancelMuteUserList')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('OperatorUserId') is not None:
            self.operator_user_id = m.get('OperatorUserId')
        return self


class CancelMuteGroupUserResponseBodyResult(TeaModel):
    def __init__(
        self,
        success: bool = None,
    ):
        # Indicates whether the members are unmuted. Valid values:
        # 
        # *   true: The members are unmuted.
        # *   false: The members failed to be unmuted.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelMuteGroupUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        result: CancelMuteGroupUserResponseBodyResult = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The returned result.
        self.result = result

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            temp_model = CancelMuteGroupUserResponseBodyResult()
            self.result = temp_model.from_map(m['Result'])
        return self


class CancelMuteGroupUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelMuteGroupUserResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelMuteGroupUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ChangeLiveDomainResourceGroupRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        new_resource_group_id: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The ingest domain or streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        # The ID of the resource group to which the domain name is moved.
        # 
        # This parameter is required.
        self.new_resource_group_id = new_resource_group_id
        self.owner_id = owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.new_resource_group_id is not None:
            result['NewResourceGroupId'] = self.new_resource_group_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('NewResourceGroupId') is not None:
            self.new_resource_group_id = m.get('NewResourceGroupId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ChangeLiveDomainResourceGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ChangeLiveDomainResourceGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ChangeLiveDomainResourceGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ChangeLiveDomainResourceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckLiveMessageUsersInGroupRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        data_center: str = None,
        group_id: str = None,
        user_ids: List[str] = None,
    ):
        # The application ID.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The data center. It must be the same as the data center that was specified when you called the [CreateLiveMessageApp](https://help.aliyun.com/document_detail/2848162.html) operation to create the interactive messaging application. Valid values: cn-shanghai and ap-southeast-1 (Singapore).
        self.data_center = data_center
        # The group ID.
        # 
        # This parameter is required.
        self.group_id = group_id
        # The list of users that you want to query.
        # 
        # This parameter is required.
        self.user_ids = user_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.data_center is not None:
            result['DataCenter'] = self.data_center
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.user_ids is not None:
            result['UserIds'] = self.user_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('DataCenter') is not None:
            self.data_center = m.get('DataCenter')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('UserIds') is not None:
            self.user_ids = m.get('UserIds')
        return self


class CheckLiveMessageUsersInGroupShrinkRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        data_center: str = None,
        group_id: str = None,
        user_ids_shrink: str = None,
    ):
        # The application ID.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The data center. It must be the same as the data center that was specified when you called the [CreateLiveMessageApp](https://help.aliyun.com/document_detail/2848162.html) operation to create the interactive messaging application. Valid values: cn-shanghai and ap-southeast-1 (Singapore).
        self.data_center = data_center
        # The group ID.
        # 
        # This parameter is required.
        self.group_id = group_id
        # The list of users that you want to query.
        # 
        # This parameter is required.
        self.user_ids_shrink = user_ids_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.data_center is not None:
            result['DataCenter'] = self.data_center
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.user_ids_shrink is not None:
            result['UserIds'] = self.user_ids_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('DataCenter') is not None:
            self.data_center = m.get('DataCenter')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('UserIds') is not None:
            self.user_ids_shrink = m.get('UserIds')
        return self


class CheckLiveMessageUsersInGroupResponseBodyUsers(TeaModel):
    def __init__(
        self,
        online: bool = None,
        user_id: str = None,
    ):
        # Indicates whether the user is in the group.
        self.online = online
        # The ID of the user.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.online is not None:
            result['Online'] = self.online
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Online') is not None:
            self.online = m.get('Online')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class CheckLiveMessageUsersInGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        users: List[CheckLiveMessageUsersInGroupResponseBodyUsers] = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The list of users queried.
        self.users = users

    def validate(self):
        if self.users:
            for k in self.users:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Users'] = []
        if self.users is not None:
            for k in self.users:
                result['Users'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.users = []
        if m.get('Users') is not None:
            for k in m.get('Users'):
                temp_model = CheckLiveMessageUsersInGroupResponseBodyUsers()
                self.users.append(temp_model.from_map(k))
        return self


class CheckLiveMessageUsersInGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CheckLiveMessageUsersInGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckLiveMessageUsersInGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckLiveMessageUsersOnlineRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        data_center: str = None,
        user_ids: List[str] = None,
    ):
        # The application ID.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The data center. It must be the same as the data center that was specified when you called the [CreateLiveMessageApp](https://help.aliyun.com/document_detail/2848162.html) operation to create the interactive messaging application. Valid values: cn-shanghai and ap-southeast-1 (Singapore).
        self.data_center = data_center
        # The list of users that you want to query.
        # 
        # This parameter is required.
        self.user_ids = user_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.data_center is not None:
            result['DataCenter'] = self.data_center
        if self.user_ids is not None:
            result['UserIds'] = self.user_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('DataCenter') is not None:
            self.data_center = m.get('DataCenter')
        if m.get('UserIds') is not None:
            self.user_ids = m.get('UserIds')
        return self


class CheckLiveMessageUsersOnlineShrinkRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        data_center: str = None,
        user_ids_shrink: str = None,
    ):
        # The application ID.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The data center. It must be the same as the data center that was specified when you called the [CreateLiveMessageApp](https://help.aliyun.com/document_detail/2848162.html) operation to create the interactive messaging application. Valid values: cn-shanghai and ap-southeast-1 (Singapore).
        self.data_center = data_center
        # The list of users that you want to query.
        # 
        # This parameter is required.
        self.user_ids_shrink = user_ids_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.data_center is not None:
            result['DataCenter'] = self.data_center
        if self.user_ids_shrink is not None:
            result['UserIds'] = self.user_ids_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('DataCenter') is not None:
            self.data_center = m.get('DataCenter')
        if m.get('UserIds') is not None:
            self.user_ids_shrink = m.get('UserIds')
        return self


class CheckLiveMessageUsersOnlineResponseBodyUserList(TeaModel):
    def __init__(
        self,
        online: bool = None,
        user_id: str = None,
    ):
        # Indicates whether the user is online.
        self.online = online
        # The user ID.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.online is not None:
            result['Online'] = self.online
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Online') is not None:
            self.online = m.get('Online')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class CheckLiveMessageUsersOnlineResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        user_list: List[CheckLiveMessageUsersOnlineResponseBodyUserList] = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The list of users queried.
        self.user_list = user_list

    def validate(self):
        if self.user_list:
            for k in self.user_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['UserList'] = []
        if self.user_list is not None:
            for k in self.user_list:
                result['UserList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.user_list = []
        if m.get('UserList') is not None:
            for k in m.get('UserList'):
                temp_model = CheckLiveMessageUsersOnlineResponseBodyUserList()
                self.user_list.append(temp_model.from_map(k))
        return self


class CheckLiveMessageUsersOnlineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CheckLiveMessageUsersOnlineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckLiveMessageUsersOnlineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CloseLiveShiftRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        owner_id: int = None,
        region_id: str = None,
        stream_name: str = None,
    ):
        # The name of the application to which the live stream belongs. You can specify an asterisk (\\*) as the value to match all applications under the domain name. You can view the application name on the [Stream Management](https://help.aliyun.com/document_detail/197397.html) page of the ApsaraVideo Live console.
        self.app_name = app_name
        # The streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        self.owner_id = owner_id
        self.region_id = region_id
        # The name of the live stream. You can specify an asterisk (\\*) as the value to match all streams in the application. You can view the stream name on the [Stream Management](https://help.aliyun.com/document_detail/197397.html) page of the ApsaraVideo Live console.
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class CloseLiveShiftResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CloseLiveShiftResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CloseLiveShiftResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CloseLiveShiftResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopyCasterRequest(TeaModel):
    def __init__(
        self,
        caster_name: str = None,
        client_token: str = None,
        owner_id: int = None,
        region_id: str = None,
        src_caster_id: str = None,
    ):
        # The name of the new production studio.
        # 
        # This parameter is required.
        self.caster_name = caster_name
        # The user-generated request token. This token is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must ensure that it is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
        # 
        # This parameter is required.
        self.client_token = client_token
        self.owner_id = owner_id
        self.region_id = region_id
        # The ID of the original production studio.
        # 
        # *   If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation, check the value of the response parameter CasterId to obtain the ID.
        # *   If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        # 
        # >  You can find the ID of the production studio in the Instance ID/Name column.
        # 
        # This parameter is required.
        self.src_caster_id = src_caster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_name is not None:
            result['CasterName'] = self.caster_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.src_caster_id is not None:
            result['SrcCasterId'] = self.src_caster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterName') is not None:
            self.caster_name = m.get('CasterName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SrcCasterId') is not None:
            self.src_caster_id = m.get('SrcCasterId')
        return self


class CopyCasterResponseBody(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        request_id: str = None,
    ):
        # The ID of the new production studio.
        self.caster_id = caster_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CopyCasterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CopyCasterResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CopyCasterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopyCasterSceneConfigRequest(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        from_scene_id: str = None,
        owner_id: int = None,
        region_id: str = None,
        to_scene_id: str = None,
    ):
        # The ID of the production studio.
        # 
        # *   If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation, check the value of the response parameter CasterId to obtain the ID.
        # *   If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        # 
        # >  You can find the ID of the production studio in the Instance ID/Name column.
        # 
        # This parameter is required.
        self.caster_id = caster_id
        # The ID of the source scene, which must be a PVW scene.
        # 
        # This parameter is required.
        self.from_scene_id = from_scene_id
        self.owner_id = owner_id
        self.region_id = region_id
        # The ID of the destination scene, which must be a PGM scene.
        # 
        # This parameter is required.
        self.to_scene_id = to_scene_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.from_scene_id is not None:
            result['FromSceneId'] = self.from_scene_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.to_scene_id is not None:
            result['ToSceneId'] = self.to_scene_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('FromSceneId') is not None:
            self.from_scene_id = m.get('FromSceneId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ToSceneId') is not None:
            self.to_scene_id = m.get('ToSceneId')
        return self


class CopyCasterSceneConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CopyCasterSceneConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CopyCasterSceneConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CopyCasterSceneConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCasterRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The key of the tag.
        self.key = key
        # The value of the tag.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateCasterRequest(TeaModel):
    def __init__(
        self,
        caster_name: str = None,
        caster_template: str = None,
        charge_type: str = None,
        client_token: str = None,
        expire_time: str = None,
        norm_type: int = None,
        owner_id: int = None,
        purchase_time: str = None,
        region_id: str = None,
        resource_group_id: str = None,
        tag: List[CreateCasterRequestTag] = None,
    ):
        # The name of the production studio.
        self.caster_name = caster_name
        # The preset resolution of the production studio. If the subscription billing method is used, this parameter supports the following valid values:
        # 
        # *   **lp_ld**: low definition
        # *   **lp_sd**: standard definition
        # *   **lp_hd**: high definition
        # *   **lp_ud**: ultra high definition
        # *   **lp_ld_v**: low definition (portrait mode)
        # *   **lp_sd_v**: standard definition (portrait mode)
        # *   **lp_hd_v**: high definition (portrait mode)
        # *   **lp_ud_v**: ultra high definition (portrait mode)
        # 
        # >  If the pay-as-you-go billing method is used, you must call the [SetCasterConfig](https://help.aliyun.com/document_detail/60271.html) operation to specify the resolution.
        self.caster_template = caster_template
        # The billing method. Only the pay-as-you-go billing method is supported.**** Valid values:
        # 
        # *   **PrePaid**: subscription. This billing method is not yet supported.
        # *   **PostPaid**: pay-as-you-go
        # 
        # This parameter is required.
        self.charge_type = charge_type
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can specify a custom value for this parameter, but you must make sure that the value is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
        # 
        # This parameter is required.
        self.client_token = client_token
        # The expiration time of the production studio. Specify the time in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # >  This parameter is valid only if you set the **ChargeType** parameter to **PrePaid**.
        self.expire_time = expire_time
        # The type of the production studio. Valid values:
        # 
        # *   **1**: general mode
        # *   **6**: playlist mode (for carousel playback)
        # 
        # This parameter is required.
        self.norm_type = norm_type
        self.owner_id = owner_id
        # The time when the production studio was purchased. Specify the time in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # >  This parameter is valid only if you set the **ChargeType** parameter to **PrePaid**.
        self.purchase_time = purchase_time
        self.region_id = region_id
        # The ID of the resource group. For more information about resource groups, see [Resource groups](https://help.aliyun.com/document_detail/2381067.html).
        self.resource_group_id = resource_group_id
        # The tags.
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_name is not None:
            result['CasterName'] = self.caster_name
        if self.caster_template is not None:
            result['CasterTemplate'] = self.caster_template
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.norm_type is not None:
            result['NormType'] = self.norm_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.purchase_time is not None:
            result['PurchaseTime'] = self.purchase_time
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterName') is not None:
            self.caster_name = m.get('CasterName')
        if m.get('CasterTemplate') is not None:
            self.caster_template = m.get('CasterTemplate')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('NormType') is not None:
            self.norm_type = m.get('NormType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PurchaseTime') is not None:
            self.purchase_time = m.get('PurchaseTime')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateCasterRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateCasterResponseBody(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        request_id: str = None,
    ):
        # The ID of the production studio. You can specify the ID in a request to query the streaming URLs of the production studio, start the production studio, add a video resource, a layout, a component, or a playlist to the production studio, or query layouts of the production studio.
        self.caster_id = caster_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCasterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCasterResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCasterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCustomTemplateRequest(TeaModel):
    def __init__(
        self,
        custom_template: str = None,
        owner_id: int = None,
        region_id: str = None,
        template: str = None,
    ):
        # The configuration of the template. The value is in the following JSON format: {height:xxx,scale:xxx,gop:xxx,bframes:xxx,cdesc:xxx}. All fields are required. If any field is left empty, the call fails.
        # 
        # >  For more information, see **Fields of the CustomTemplate parameter**.
        # 
        # This parameter is required.
        self.custom_template = custom_template
        self.owner_id = owner_id
        self.region_id = region_id
        # The name of the template.
        # 
        # > Record the template name. The template name is required if you want to use, query, or delete the template.
        # 
        # This parameter is required.
        self.template = template

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_template is not None:
            result['CustomTemplate'] = self.custom_template
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.template is not None:
            result['Template'] = self.template
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CustomTemplate') is not None:
            self.custom_template = m.get('CustomTemplate')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Template') is not None:
            self.template = m.get('Template')
        return self


class CreateCustomTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCustomTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCustomTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCustomTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeTranscodeJobRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        name: str = None,
        owner_id: int = None,
        region_id: str = None,
        stream_input: str = None,
        stream_output: str = None,
        template_id: str = None,
    ):
        # The ID of the data center.
        # 
        # This parameter is required.
        self.cluster_id = cluster_id
        # The task name. The name can contain letters, digits, hyphens (-), and underscores (_). The name must be 255 characters in length.
        # 
        # This parameter is required.
        self.name = name
        self.owner_id = owner_id
        self.region_id = region_id
        # The URL of the input stream.
        # 
        # This parameter is required.
        self.stream_input = stream_input
        # The URL of the output stream.
        # 
        # This parameter is required.
        self.stream_output = stream_output
        # The template ID.
        # 
        # This parameter is required.
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.stream_input is not None:
            result['StreamInput'] = self.stream_input
        if self.stream_output is not None:
            result['StreamOutput'] = self.stream_output
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StreamInput') is not None:
            self.stream_input = m.get('StreamInput')
        if m.get('StreamOutput') is not None:
            self.stream_output = m.get('StreamOutput')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class CreateEdgeTranscodeJobResponseBody(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        request_id: str = None,
    ):
        # The ID of the edge transcoding task.
        self.job_id = job_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateEdgeTranscodeJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateEdgeTranscodeJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateEdgeTranscodeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEventSubRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        callback_url: str = None,
        channel_id: str = None,
        events: List[str] = None,
        users: List[str] = None,
    ):
        # The application ID.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The callback URL. For more information about the content of the messages that are sent to the callback URL, see the Callback section in this topic.
        # 
        # This parameter is required.
        self.callback_url = callback_url
        # The channel ID. You can call the [ListEventSub](https://help.aliyun.com/document_detail/2628135.html) operation to query the channel ID.
        # 
        # > 
        # 
        # *   This parameter is required if you specify the Users.N parameter.
        # 
        # *   If you set this parameter to \\* or do not specify this parameter, all channels are subscribed to.
        # 
        # *   Each application ID allows only one all-channel subscription.
        self.channel_id = channel_id
        # Subscribe to events.
        # 
        # This parameter is required.
        self.events = events
        # The user whose events you want to subscribe to. If you leave this parameter empty, the events of all users in the channel are subscribed to, including the events of the streamer and viewers. Specify this parameter in the following format:
        # 
        #     Users.1=****\
        #     Users.2=****\
        #     ......
        self.users = users

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.callback_url is not None:
            result['CallbackUrl'] = self.callback_url
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.events is not None:
            result['Events'] = self.events
        if self.users is not None:
            result['Users'] = self.users
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CallbackUrl') is not None:
            self.callback_url = m.get('CallbackUrl')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('Events') is not None:
            self.events = m.get('Events')
        if m.get('Users') is not None:
            self.users = m.get('Users')
        return self


class CreateEventSubResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        subscribe_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The subscription ID.
        self.subscribe_id = subscribe_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.subscribe_id is not None:
            result['SubscribeId'] = self.subscribe_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SubscribeId') is not None:
            self.subscribe_id = m.get('SubscribeId')
        return self


class CreateEventSubResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateEventSubResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateEventSubResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLiveAIStudioRequestMattingLayout(TeaModel):
    def __init__(
        self,
        height_normalized: float = None,
        position_x: float = None,
        position_y: float = None,
    ):
        # The normalized value of the material height. The value indicates the ratio of the material height to the height of the background. Valid values: **0 to 1**.
        self.height_normalized = height_normalized
        # The x-coordinate of the material. Valid values: **0 to 1**. The upper-left corner is used as the coordinate origin for the material.
        self.position_x = position_x
        # The y-coordinate of the material. Valid values: **0 to 1**. The upper-left corner is used as the coordinate origin for the material.
        self.position_y = position_y

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.height_normalized is not None:
            result['HeightNormalized'] = self.height_normalized
        if self.position_x is not None:
            result['PositionX'] = self.position_x
        if self.position_y is not None:
            result['PositionY'] = self.position_y
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HeightNormalized') is not None:
            self.height_normalized = m.get('HeightNormalized')
        if m.get('PositionX') is not None:
            self.position_x = m.get('PositionX')
        if m.get('PositionY') is not None:
            self.position_y = m.get('PositionY')
        return self


class CreateLiveAIStudioRequestMediaLayout(TeaModel):
    def __init__(
        self,
        height_normalized: float = None,
        position_x: float = None,
        position_y: float = None,
    ):
        # The normalized value of the material height. The value indicates the ratio of the material height to the height of the background. Valid values: **0 to 1**.
        self.height_normalized = height_normalized
        # The x-coordinate of the material. Valid values: **0 to 1**. The upper-left corner is used as the coordinate origin for the material.
        self.position_x = position_x
        # The y-coordinate of the material. Valid values: **0 to 1**. The upper-left corner is used as the coordinate origin for the material.
        self.position_y = position_y

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.height_normalized is not None:
            result['HeightNormalized'] = self.height_normalized
        if self.position_x is not None:
            result['PositionX'] = self.position_x
        if self.position_y is not None:
            result['PositionY'] = self.position_y
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HeightNormalized') is not None:
            self.height_normalized = m.get('HeightNormalized')
        if m.get('PositionX') is not None:
            self.position_x = m.get('PositionX')
        if m.get('PositionY') is not None:
            self.position_y = m.get('PositionY')
        return self


class CreateLiveAIStudioRequest(TeaModel):
    def __init__(
        self,
        background_resource_id: str = None,
        background_resource_url: str = None,
        background_type: str = None,
        description: str = None,
        height: int = None,
        matting_layout: CreateLiveAIStudioRequestMattingLayout = None,
        matting_type: str = None,
        media_layout: CreateLiveAIStudioRequestMediaLayout = None,
        media_resource_id: str = None,
        media_resource_url: str = None,
        media_type: str = None,
        owner_id: int = None,
        region_id: str = None,
        studio_name: str = None,
        width: int = None,
    ):
        # The ID of the background material in ApsaraVideo VOD. You can obtain the ID from the ApsaraVideo VOD console.
        self.background_resource_id = background_resource_id
        # The URL of the background material. Specify either this parameter or the BackgroundResourceId parameter.
        self.background_resource_url = background_resource_url
        # The type of the background material. Valid values:
        # 
        # *   VOD: a video in ApsaraVideo VOD
        # *   PIC: an image
        # *   LIVE: a live stream
        self.background_type = background_type
        # The custom description.
        self.description = description
        # The preview height. Unit: pixels.
        # 
        # The following preview specifications (width × height) are supported:
        # 
        # *   Landscape low definition 360p (640×360)
        # *   Portrait low definition 360p (360×640)
        # *   Landscape standard definition 480p (854×480)
        # *   Portrait standard definition 480p (480×854)
        # *   Landscape high definition 720p (1280×720)
        # *   Portrait high definition 720p (720×1280)
        # *   Landscape ultra-high definition 1080p (1920×1080)
        # *   Portrait ultra-high definition 1080p (1080×1920)
        self.height = height
        # The layout information of the chroma-keyed material.
        # 
        # This parameter is required.
        self.matting_layout = matting_layout
        # The type of chroma key. Valid values:
        # 
        # *   green: green-screen chroma key
        # *   blue: blue-screen chroma key
        # *   complex: background replacement
        # 
        # This parameter is required.
        self.matting_type = matting_type
        # The layout information of the multimedia material.
        self.media_layout = media_layout
        # The ID of the multimedia material in ApsaraVideo VOD. You can obtain the ID from the ApsaraVideo VOD console.
        self.media_resource_id = media_resource_id
        # The URL of the multimedia material. Specify either this parameter or the MediaResourceId parameter.
        self.media_resource_url = media_resource_url
        # The type of the multimedia material. Valid values:
        # 
        # *   VOD: a video in ApsaraVideo VOD
        # *   PIC: an image
        # *   LIVE: a live stream
        self.media_type = media_type
        self.owner_id = owner_id
        self.region_id = region_id
        # The name of the virtual studio template. The name must be unique.
        # 
        # This parameter is required.
        self.studio_name = studio_name
        # The preview width. Unit: pixels.
        self.width = width

    def validate(self):
        if self.matting_layout:
            self.matting_layout.validate()
        if self.media_layout:
            self.media_layout.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.background_resource_id is not None:
            result['BackgroundResourceId'] = self.background_resource_id
        if self.background_resource_url is not None:
            result['BackgroundResourceUrl'] = self.background_resource_url
        if self.background_type is not None:
            result['BackgroundType'] = self.background_type
        if self.description is not None:
            result['Description'] = self.description
        if self.height is not None:
            result['Height'] = self.height
        if self.matting_layout is not None:
            result['MattingLayout'] = self.matting_layout.to_map()
        if self.matting_type is not None:
            result['MattingType'] = self.matting_type
        if self.media_layout is not None:
            result['MediaLayout'] = self.media_layout.to_map()
        if self.media_resource_id is not None:
            result['MediaResourceId'] = self.media_resource_id
        if self.media_resource_url is not None:
            result['MediaResourceUrl'] = self.media_resource_url
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.studio_name is not None:
            result['StudioName'] = self.studio_name
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackgroundResourceId') is not None:
            self.background_resource_id = m.get('BackgroundResourceId')
        if m.get('BackgroundResourceUrl') is not None:
            self.background_resource_url = m.get('BackgroundResourceUrl')
        if m.get('BackgroundType') is not None:
            self.background_type = m.get('BackgroundType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MattingLayout') is not None:
            temp_model = CreateLiveAIStudioRequestMattingLayout()
            self.matting_layout = temp_model.from_map(m['MattingLayout'])
        if m.get('MattingType') is not None:
            self.matting_type = m.get('MattingType')
        if m.get('MediaLayout') is not None:
            temp_model = CreateLiveAIStudioRequestMediaLayout()
            self.media_layout = temp_model.from_map(m['MediaLayout'])
        if m.get('MediaResourceId') is not None:
            self.media_resource_id = m.get('MediaResourceId')
        if m.get('MediaResourceUrl') is not None:
            self.media_resource_url = m.get('MediaResourceUrl')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StudioName') is not None:
            self.studio_name = m.get('StudioName')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class CreateLiveAIStudioShrinkRequest(TeaModel):
    def __init__(
        self,
        background_resource_id: str = None,
        background_resource_url: str = None,
        background_type: str = None,
        description: str = None,
        height: int = None,
        matting_layout_shrink: str = None,
        matting_type: str = None,
        media_layout_shrink: str = None,
        media_resource_id: str = None,
        media_resource_url: str = None,
        media_type: str = None,
        owner_id: int = None,
        region_id: str = None,
        studio_name: str = None,
        width: int = None,
    ):
        # The ID of the background material in ApsaraVideo VOD. You can obtain the ID from the ApsaraVideo VOD console.
        self.background_resource_id = background_resource_id
        # The URL of the background material. Specify either this parameter or the BackgroundResourceId parameter.
        self.background_resource_url = background_resource_url
        # The type of the background material. Valid values:
        # 
        # *   VOD: a video in ApsaraVideo VOD
        # *   PIC: an image
        # *   LIVE: a live stream
        self.background_type = background_type
        # The custom description.
        self.description = description
        # The preview height. Unit: pixels.
        # 
        # The following preview specifications (width × height) are supported:
        # 
        # *   Landscape low definition 360p (640×360)
        # *   Portrait low definition 360p (360×640)
        # *   Landscape standard definition 480p (854×480)
        # *   Portrait standard definition 480p (480×854)
        # *   Landscape high definition 720p (1280×720)
        # *   Portrait high definition 720p (720×1280)
        # *   Landscape ultra-high definition 1080p (1920×1080)
        # *   Portrait ultra-high definition 1080p (1080×1920)
        self.height = height
        # The layout information of the chroma-keyed material.
        # 
        # This parameter is required.
        self.matting_layout_shrink = matting_layout_shrink
        # The type of chroma key. Valid values:
        # 
        # *   green: green-screen chroma key
        # *   blue: blue-screen chroma key
        # *   complex: background replacement
        # 
        # This parameter is required.
        self.matting_type = matting_type
        # The layout information of the multimedia material.
        self.media_layout_shrink = media_layout_shrink
        # The ID of the multimedia material in ApsaraVideo VOD. You can obtain the ID from the ApsaraVideo VOD console.
        self.media_resource_id = media_resource_id
        # The URL of the multimedia material. Specify either this parameter or the MediaResourceId parameter.
        self.media_resource_url = media_resource_url
        # The type of the multimedia material. Valid values:
        # 
        # *   VOD: a video in ApsaraVideo VOD
        # *   PIC: an image
        # *   LIVE: a live stream
        self.media_type = media_type
        self.owner_id = owner_id
        self.region_id = region_id
        # The name of the virtual studio template. The name must be unique.
        # 
        # This parameter is required.
        self.studio_name = studio_name
        # The preview width. Unit: pixels.
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.background_resource_id is not None:
            result['BackgroundResourceId'] = self.background_resource_id
        if self.background_resource_url is not None:
            result['BackgroundResourceUrl'] = self.background_resource_url
        if self.background_type is not None:
            result['BackgroundType'] = self.background_type
        if self.description is not None:
            result['Description'] = self.description
        if self.height is not None:
            result['Height'] = self.height
        if self.matting_layout_shrink is not None:
            result['MattingLayout'] = self.matting_layout_shrink
        if self.matting_type is not None:
            result['MattingType'] = self.matting_type
        if self.media_layout_shrink is not None:
            result['MediaLayout'] = self.media_layout_shrink
        if self.media_resource_id is not None:
            result['MediaResourceId'] = self.media_resource_id
        if self.media_resource_url is not None:
            result['MediaResourceUrl'] = self.media_resource_url
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.studio_name is not None:
            result['StudioName'] = self.studio_name
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackgroundResourceId') is not None:
            self.background_resource_id = m.get('BackgroundResourceId')
        if m.get('BackgroundResourceUrl') is not None:
            self.background_resource_url = m.get('BackgroundResourceUrl')
        if m.get('BackgroundType') is not None:
            self.background_type = m.get('BackgroundType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MattingLayout') is not None:
            self.matting_layout_shrink = m.get('MattingLayout')
        if m.get('MattingType') is not None:
            self.matting_type = m.get('MattingType')
        if m.get('MediaLayout') is not None:
            self.media_layout_shrink = m.get('MediaLayout')
        if m.get('MediaResourceId') is not None:
            self.media_resource_id = m.get('MediaResourceId')
        if m.get('MediaResourceUrl') is not None:
            self.media_resource_url = m.get('MediaResourceUrl')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StudioName') is not None:
            self.studio_name = m.get('StudioName')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class CreateLiveAIStudioResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        studio_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The ID of the virtual studio template.
        self.studio_id = studio_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.studio_id is not None:
            result['StudioId'] = self.studio_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StudioId') is not None:
            self.studio_id = m.get('StudioId')
        return self


class CreateLiveAIStudioResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateLiveAIStudioResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLiveAIStudioResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLiveDelayConfigRequest(TeaModel):
    def __init__(
        self,
        app: str = None,
        delay_time: int = None,
        domain: str = None,
        owner_id: int = None,
        region_id: str = None,
        stream: str = None,
        task_trigger_mode: str = None,
    ):
        # The name of the application to which the live stream belongs. You can specify an asterisk (\\*) as the value to match all applications that belong to the domain name.
        # 
        # This parameter is required.
        self.app = app
        # The duration for which the playback of the live stream is delayed. The value must be an integer. Valid values: 16 to 3600. Unit: seconds.
        # 
        # This parameter is required.
        self.delay_time = delay_time
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain = domain
        self.owner_id = owner_id
        self.region_id = region_id
        # The name of the live stream. You can use the wildcard (\\*) to specify all streams of the application.
        # 
        # This parameter is required.
        self.stream = stream
        # The trigger mode. Valid values:
        # 
        # *   **PUBLISH_ONLY**: Stream delay can be triggered only by specifying the stream delay parameter in the ingest URL.
        # *   **CONFIG_ONLY**: Stream delay can be triggered only by the stream delay configuration.
        # *   **PUBLISH_CONFIG**: Stream delay can be triggered by the stream delay parameter in the ingest URL or the stream delay configuration. The stream delay parameter takes precedence over the stream delay configuration.
        # 
        # This parameter is required.
        self.task_trigger_mode = task_trigger_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app is not None:
            result['App'] = self.app
        if self.delay_time is not None:
            result['DelayTime'] = self.delay_time
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.stream is not None:
            result['Stream'] = self.stream
        if self.task_trigger_mode is not None:
            result['TaskTriggerMode'] = self.task_trigger_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('DelayTime') is not None:
            self.delay_time = m.get('DelayTime')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Stream') is not None:
            self.stream = m.get('Stream')
        if m.get('TaskTriggerMode') is not None:
            self.task_trigger_mode = m.get('TaskTriggerMode')
        return self


class CreateLiveDelayConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateLiveDelayConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateLiveDelayConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLiveDelayConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLiveMessageAppRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        audit_type: int = None,
        audit_url: str = None,
        data_center: str = None,
        event_callback_url: str = None,
        msg_life_cycle: int = None,
    ):
        # The name of the application. The name must be 2 to 16 characters in length.
        self.app_name = app_name
        # The content moderation method. Valid values:
        # 
        # *   0 (default): disables content moderation.
        # *   1: uses built-in content moderation.
        # *   2: uses custom content moderation.
        self.audit_type = audit_type
        # The URL for content moderation. If you set AuditType to 2, you must specify this parameter. The URL must start with http:// or https:// and cannot contain a private IP address or a port number. For more information about custom content moderation, see the "Custom content moderation" section of this topic.
        self.audit_url = audit_url
        # The data center. Valid values:
        # 
        # *   cn-shanghai (default)
        # *   ap-southeast-1: Singapore
        # 
        # >  When you call other operations to manage the interactive messaging application, you must specify the same data center in which the application is created.
        self.data_center = data_center
        # The callback URL for events, such as logon, logoff, and joining and leaving a group. If you leave this parameter empty, event callbacks are disabled. [](~~2672836~~)The callback URL must start with http:// or https:// and cannot contain a private IP address or a port number. For information about the callback message format and authentication logic, see the "Event callbacks" and "Callback authentication" sections of this topic.
        self.event_callback_url = event_callback_url
        # The retention period of group messages in the application. Valid values:
        # 
        # *   0 (default): 30 days.
        # *   1: 90 days.
        # *   2: 180 days.
        self.msg_life_cycle = msg_life_cycle

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.audit_type is not None:
            result['AuditType'] = self.audit_type
        if self.audit_url is not None:
            result['AuditUrl'] = self.audit_url
        if self.data_center is not None:
            result['DataCenter'] = self.data_center
        if self.event_callback_url is not None:
            result['EventCallbackUrl'] = self.event_callback_url
        if self.msg_life_cycle is not None:
            result['MsgLifeCycle'] = self.msg_life_cycle
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('AuditType') is not None:
            self.audit_type = m.get('AuditType')
        if m.get('AuditUrl') is not None:
            self.audit_url = m.get('AuditUrl')
        if m.get('DataCenter') is not None:
            self.data_center = m.get('DataCenter')
        if m.get('EventCallbackUrl') is not None:
            self.event_callback_url = m.get('EventCallbackUrl')
        if m.get('MsgLifeCycle') is not None:
            self.msg_life_cycle = m.get('MsgLifeCycle')
        return self


class CreateLiveMessageAppResponseBody(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        app_key: str = None,
        app_sign: str = None,
        data_center: str = None,
        request_id: str = None,
    ):
        # The application ID. The ID is used in subsequent operations, such as joining a group.
        self.app_id = app_id
        # The AppKey for authentication of this application.
        self.app_key = app_key
        # The application signature. The signature is required when you use the interactive messaging SDK.
        self.app_sign = app_sign
        # The data center in which the interactive messaging application was created.
        self.data_center = data_center
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_key is not None:
            result['AppKey'] = self.app_key
        if self.app_sign is not None:
            result['AppSign'] = self.app_sign
        if self.data_center is not None:
            result['DataCenter'] = self.data_center
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppKey') is not None:
            self.app_key = m.get('AppKey')
        if m.get('AppSign') is not None:
            self.app_sign = m.get('AppSign')
        if m.get('DataCenter') is not None:
            self.data_center = m.get('DataCenter')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateLiveMessageAppResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateLiveMessageAppResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLiveMessageAppResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLiveMessageGroupRequest(TeaModel):
    def __init__(
        self,
        administrators: List[str] = None,
        app_id: str = None,
        creator_id: str = None,
        data_center: str = None,
        group_id: str = None,
        group_info: str = None,
        group_name: str = None,
    ):
        # The list of administrators.
        self.administrators = administrators
        # The application ID.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The ID of the group creator. The ID can be up to 64 bytes in length and can contain letters and digits.
        self.creator_id = creator_id
        # The data center. It must be the same as the data center that was specified when you called the [CreateLiveMessageApp](https://help.aliyun.com/document_detail/2593195.html) operation to create the interactive messaging application. Valid values: cn-shanghai and ap-southeast-1 (Singapore).
        self.data_center = data_center
        # The ID of the group that you want to create. The group ID must be unique within your business. The ID can be up to 64 bytes in length and can contain letters and digits.
        # 
        # This parameter is required.
        self.group_id = group_id
        # The additional information about the group. The value can be up to 32 KB in length.
        self.group_info = group_info
        # The name of the group. The name can be up to 128 bytes in length.
        self.group_name = group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.administrators is not None:
            result['Administrators'] = self.administrators
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.data_center is not None:
            result['DataCenter'] = self.data_center
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_info is not None:
            result['GroupInfo'] = self.group_info
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Administrators') is not None:
            self.administrators = m.get('Administrators')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('DataCenter') is not None:
            self.data_center = m.get('DataCenter')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupInfo') is not None:
            self.group_info = m.get('GroupInfo')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class CreateLiveMessageGroupShrinkRequest(TeaModel):
    def __init__(
        self,
        administrators_shrink: str = None,
        app_id: str = None,
        creator_id: str = None,
        data_center: str = None,
        group_id: str = None,
        group_info: str = None,
        group_name: str = None,
    ):
        # The list of administrators.
        self.administrators_shrink = administrators_shrink
        # The application ID.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The ID of the group creator. The ID can be up to 64 bytes in length and can contain letters and digits.
        self.creator_id = creator_id
        # The data center. It must be the same as the data center that was specified when you called the [CreateLiveMessageApp](https://help.aliyun.com/document_detail/2593195.html) operation to create the interactive messaging application. Valid values: cn-shanghai and ap-southeast-1 (Singapore).
        self.data_center = data_center
        # The ID of the group that you want to create. The group ID must be unique within your business. The ID can be up to 64 bytes in length and can contain letters and digits.
        # 
        # This parameter is required.
        self.group_id = group_id
        # The additional information about the group. The value can be up to 32 KB in length.
        self.group_info = group_info
        # The name of the group. The name can be up to 128 bytes in length.
        self.group_name = group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.administrators_shrink is not None:
            result['Administrators'] = self.administrators_shrink
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.data_center is not None:
            result['DataCenter'] = self.data_center
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_info is not None:
            result['GroupInfo'] = self.group_info
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Administrators') is not None:
            self.administrators_shrink = m.get('Administrators')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('DataCenter') is not None:
            self.data_center = m.get('DataCenter')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupInfo') is not None:
            self.group_info = m.get('GroupInfo')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class CreateLiveMessageGroupResponseBody(TeaModel):
    def __init__(
        self,
        already_delete: bool = None,
        already_exists: bool = None,
        group_id: str = None,
        request_id: str = None,
    ):
        # Indicates whether the group is deleted. If the group existed and is deleted, the group ID is unavailable. We recommend that you create a new group.
        self.already_delete = already_delete
        # Indicates whether the group already exists.
        self.already_exists = already_exists
        # The ID of the group created.
        self.group_id = group_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.already_delete is not None:
            result['AlreadyDelete'] = self.already_delete
        if self.already_exists is not None:
            result['AlreadyExists'] = self.already_exists
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlreadyDelete') is not None:
            self.already_delete = m.get('AlreadyDelete')
        if m.get('AlreadyExists') is not None:
            self.already_exists = m.get('AlreadyExists')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateLiveMessageGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateLiveMessageGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLiveMessageGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLivePrivateLineRequest(TeaModel):
    def __init__(
        self,
        acceleration_area: str = None,
        acceleration_type: str = None,
        app_name: str = None,
        domain_name: str = None,
        instance_id: str = None,
        max_bandwidth: str = None,
        owner_id: int = None,
        region_id: str = None,
        reuse: str = None,
        stream_name: str = None,
        video_center: str = None,
    ):
        # The acceleration channel.
        # 
        # This parameter is required.
        self.acceleration_area = acceleration_area
        # The acceleration type. Valid values:
        # 
        # *   play: streaming acceleration
        # *   publish: stream ingest acceleration
        # 
        # This parameter is required.
        self.acceleration_type = acceleration_type
        # The name of the application.
        # 
        # This parameter is required.
        self.app_name = app_name
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        # The acceleration channel that you want to reuse. This parameter is required if Reuse is set to yes.
        self.instance_id = instance_id
        # The accelerated bandwidth. Unit: Mbit/s. This parameter is required if Reuse is set to no.
        self.max_bandwidth = max_bandwidth
        self.owner_id = owner_id
        self.region_id = region_id
        # Specifies whether to reuse an existing acceleration channel. Valid values:
        # 
        # *   yes: reuses an existing acceleration channel.
        # *   no: creates a new acceleration channel.
        # 
        # This parameter is required.
        self.reuse = reuse
        # The name of the live stream.
        # 
        # This parameter is required.
        self.stream_name = stream_name
        # The live center. Valid values: cn-beijing, cn-shanghai, cn-shenzhen, cn-qingdao, ap-northeast-1, ap-southeast-5, eu-central-1, and ap-southeast-1, which indicate China (Beijing), China (Shanghai), China (Shenzhen), China (Qingdao), Japan (Tokyo), Indonesia (Jakarta), Germany (Frankfurt), and Singapore, respectively.
        # 
        # This parameter is required.
        self.video_center = video_center

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acceleration_area is not None:
            result['AccelerationArea'] = self.acceleration_area
        if self.acceleration_type is not None:
            result['AccelerationType'] = self.acceleration_type
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_bandwidth is not None:
            result['MaxBandwidth'] = self.max_bandwidth
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.reuse is not None:
            result['Reuse'] = self.reuse
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.video_center is not None:
            result['VideoCenter'] = self.video_center
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccelerationArea') is not None:
            self.acceleration_area = m.get('AccelerationArea')
        if m.get('AccelerationType') is not None:
            self.acceleration_type = m.get('AccelerationType')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxBandwidth') is not None:
            self.max_bandwidth = m.get('MaxBandwidth')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Reuse') is not None:
            self.reuse = m.get('Reuse')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('VideoCenter') is not None:
            self.video_center = m.get('VideoCenter')
        return self


class CreateLivePrivateLineResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateLivePrivateLineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateLivePrivateLineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLivePrivateLineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLivePullToPushRequest(TeaModel):
    def __init__(
        self,
        callback_url: str = None,
        dst_url: str = None,
        end_time: str = None,
        file_index: int = None,
        offset: int = None,
        owner_id: int = None,
        region: str = None,
        region_id: str = None,
        repeat_number: int = None,
        retry_count: int = None,
        retry_interval: int = None,
        source_protocol: str = None,
        source_type: str = None,
        source_urls: List[str] = None,
        start_time: str = None,
        task_name: str = None,
    ):
        # The HTTP callback URL. By default, this parameter is left empty.
        # 
        # > 
        # 
        # *   The URL is used to receive callbacks related to the task.
        # 
        # *   The URL can be up to 2,000 characters in length.
        # 
        # *   If you do not specify this parameter, no callbacks are returned for events related to the task.
        self.callback_url = callback_url
        # The destination URL to which the stream is relayed.
        # 
        # > 
        # 
        # *   The supported protocol for the URL is RTMP.
        # 
        # *   The URL can be up to 2,000 characters in length.
        # 
        # This parameter is required.
        self.dst_url = dst_url
        # The end time of the task.
        # 
        # > 
        # 
        # *   Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        # 
        # *   The time range specified by the StartTime and EndTime parameters cannot exceed seven days.
        # 
        # *   The end time must be later than the start time.
        # 
        # *   The end time must be later than the current time.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The file index, which specifies the sequence of the file where the playback starts.
        self.file_index = file_index
        # The offset of the position where the system starts to read the video resource. Unit: seconds. Valid values: positive numbers.
        # 
        # > 
        # 
        # *   This parameter indicates an offset from the first frame of the first video resource in the list.
        # 
        # *   This parameter is applicable to only video resources from ApsaraVideo VOD or a third party.
        self.offset = offset
        self.owner_id = owner_id
        # The region where the task is started. Valid values:
        # 
        # *   ap-southeast-1: Singapore
        # *   ap-southeast-5: Indonesia (Jakarta)
        # *   cn-beijing: China (Beijing)
        # *   cn-shanghai: China (Shanghai)
        # 
        # This parameter is required.
        self.region = region
        self.region_id = region_id
        # The number of playbacks after the first playback is complete. Valid values:
        # 
        # *   0 (default): specifies that the video list is played only once.
        # *   \\-1: specifies that the video list is played in loop mode.
        # *   Positive integer: specifies the number of times the video list repeats after the first playback is complete.
        # 
        # >  This parameter is applicable to only video resources from ApsaraVideo VOD or a third party.
        self.repeat_number = repeat_number
        # The number of retries allowed. Default value: 3.
        self.retry_count = retry_count
        # The retry interval. Unit: seconds. Valid values: [60,300]. Default value: 60.
        self.retry_interval = retry_interval
        # The protocol of the source stream.
        # 
        # Valid values:
        # 
        # *   rtmp
        # *   rtsp
        # *   srt
        # *   http-flv
        # *   flv
        # 
        # >  This parameter is required if you set the **SourceType** parameter to live, but does not take effect if you set the SourceType parameter to vod or url.
        self.source_protocol = source_protocol
        # The type of the source stream. Valid values:
        # 
        # *   live: a live stream
        # *   vod: a list of ApsaraVideo VOD resources
        # *   url: a list of video resources from a third party
        # 
        # This parameter is required.
        self.source_type = source_type
        # The source URLs.
        # 
        # > 
        # 
        # *   If SourceType is set to live, you can specify only one streaming URL.
        # 
        # *   If SourceType is set to vod or url, you can specify up to 30 IDs or URLs.
        # 
        # *   If SourceType is set to live, the supported protocols for URLs are Real-Time Messaging Protocol (RTMP), Real-Time Streaming Protocol (RTSP), Secure Reliable Transport Protocol (SRT), and HTTP-FLV.
        # 
        # *   If SourceType is set to vod, specify the IDs of media assets from ApsaraVideo VOD.
        # 
        # *   If SourceType is set to url, the supported protocols for URLs are MP4 and HTTP-FLV.
        # 
        # This parameter is required.
        self.source_urls = source_urls
        # The start time of the task.
        # 
        # > 
        # 
        # *   Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        # 
        # *   The time range specified by the StartTime and EndTime parameters cannot exceed seven days.
        # 
        # This parameter is required.
        self.start_time = start_time
        # The name of the task. Default value: "". Fuzzy search for task names is supported.
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.callback_url is not None:
            result['CallbackUrl'] = self.callback_url
        if self.dst_url is not None:
            result['DstUrl'] = self.dst_url
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.file_index is not None:
            result['FileIndex'] = self.file_index
        if self.offset is not None:
            result['Offset'] = self.offset
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region is not None:
            result['Region'] = self.region
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.repeat_number is not None:
            result['RepeatNumber'] = self.repeat_number
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.source_protocol is not None:
            result['SourceProtocol'] = self.source_protocol
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.source_urls is not None:
            result['SourceUrls'] = self.source_urls
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CallbackUrl') is not None:
            self.callback_url = m.get('CallbackUrl')
        if m.get('DstUrl') is not None:
            self.dst_url = m.get('DstUrl')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('FileIndex') is not None:
            self.file_index = m.get('FileIndex')
        if m.get('Offset') is not None:
            self.offset = m.get('Offset')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RepeatNumber') is not None:
            self.repeat_number = m.get('RepeatNumber')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('SourceProtocol') is not None:
            self.source_protocol = m.get('SourceProtocol')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('SourceUrls') is not None:
            self.source_urls = m.get('SourceUrls')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class CreateLivePullToPushShrinkRequest(TeaModel):
    def __init__(
        self,
        callback_url: str = None,
        dst_url: str = None,
        end_time: str = None,
        file_index: int = None,
        offset: int = None,
        owner_id: int = None,
        region: str = None,
        region_id: str = None,
        repeat_number: int = None,
        retry_count: int = None,
        retry_interval: int = None,
        source_protocol: str = None,
        source_type: str = None,
        source_urls_shrink: str = None,
        start_time: str = None,
        task_name: str = None,
    ):
        # The HTTP callback URL. By default, this parameter is left empty.
        # 
        # > 
        # 
        # *   The URL is used to receive callbacks related to the task.
        # 
        # *   The URL can be up to 2,000 characters in length.
        # 
        # *   If you do not specify this parameter, no callbacks are returned for events related to the task.
        self.callback_url = callback_url
        # The destination URL to which the stream is relayed.
        # 
        # > 
        # 
        # *   The supported protocol for the URL is RTMP.
        # 
        # *   The URL can be up to 2,000 characters in length.
        # 
        # This parameter is required.
        self.dst_url = dst_url
        # The end time of the task.
        # 
        # > 
        # 
        # *   Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        # 
        # *   The time range specified by the StartTime and EndTime parameters cannot exceed seven days.
        # 
        # *   The end time must be later than the start time.
        # 
        # *   The end time must be later than the current time.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The file index, which specifies the sequence of the file where the playback starts.
        self.file_index = file_index
        # The offset of the position where the system starts to read the video resource. Unit: seconds. Valid values: positive numbers.
        # 
        # > 
        # 
        # *   This parameter indicates an offset from the first frame of the first video resource in the list.
        # 
        # *   This parameter is applicable to only video resources from ApsaraVideo VOD or a third party.
        self.offset = offset
        self.owner_id = owner_id
        # The region where the task is started. Valid values:
        # 
        # *   ap-southeast-1: Singapore
        # *   ap-southeast-5: Indonesia (Jakarta)
        # *   cn-beijing: China (Beijing)
        # *   cn-shanghai: China (Shanghai)
        # 
        # This parameter is required.
        self.region = region
        self.region_id = region_id
        # The number of playbacks after the first playback is complete. Valid values:
        # 
        # *   0 (default): specifies that the video list is played only once.
        # *   \\-1: specifies that the video list is played in loop mode.
        # *   Positive integer: specifies the number of times the video list repeats after the first playback is complete.
        # 
        # >  This parameter is applicable to only video resources from ApsaraVideo VOD or a third party.
        self.repeat_number = repeat_number
        # The number of retries allowed. Default value: 3.
        self.retry_count = retry_count
        # The retry interval. Unit: seconds. Valid values: [60,300]. Default value: 60.
        self.retry_interval = retry_interval
        # The protocol of the source stream.
        # 
        # Valid values:
        # 
        # *   rtmp
        # *   rtsp
        # *   srt
        # *   http-flv
        # *   flv
        # 
        # >  This parameter is required if you set the **SourceType** parameter to live, but does not take effect if you set the SourceType parameter to vod or url.
        self.source_protocol = source_protocol
        # The type of the source stream. Valid values:
        # 
        # *   live: a live stream
        # *   vod: a list of ApsaraVideo VOD resources
        # *   url: a list of video resources from a third party
        # 
        # This parameter is required.
        self.source_type = source_type
        # The source URLs.
        # 
        # > 
        # 
        # *   If SourceType is set to live, you can specify only one streaming URL.
        # 
        # *   If SourceType is set to vod or url, you can specify up to 30 IDs or URLs.
        # 
        # *   If SourceType is set to live, the supported protocols for URLs are Real-Time Messaging Protocol (RTMP), Real-Time Streaming Protocol (RTSP), Secure Reliable Transport Protocol (SRT), and HTTP-FLV.
        # 
        # *   If SourceType is set to vod, specify the IDs of media assets from ApsaraVideo VOD.
        # 
        # *   If SourceType is set to url, the supported protocols for URLs are MP4 and HTTP-FLV.
        # 
        # This parameter is required.
        self.source_urls_shrink = source_urls_shrink
        # The start time of the task.
        # 
        # > 
        # 
        # *   Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        # 
        # *   The time range specified by the StartTime and EndTime parameters cannot exceed seven days.
        # 
        # This parameter is required.
        self.start_time = start_time
        # The name of the task. Default value: "". Fuzzy search for task names is supported.
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.callback_url is not None:
            result['CallbackUrl'] = self.callback_url
        if self.dst_url is not None:
            result['DstUrl'] = self.dst_url
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.file_index is not None:
            result['FileIndex'] = self.file_index
        if self.offset is not None:
            result['Offset'] = self.offset
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region is not None:
            result['Region'] = self.region
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.repeat_number is not None:
            result['RepeatNumber'] = self.repeat_number
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.source_protocol is not None:
            result['SourceProtocol'] = self.source_protocol
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.source_urls_shrink is not None:
            result['SourceUrls'] = self.source_urls_shrink
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CallbackUrl') is not None:
            self.callback_url = m.get('CallbackUrl')
        if m.get('DstUrl') is not None:
            self.dst_url = m.get('DstUrl')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('FileIndex') is not None:
            self.file_index = m.get('FileIndex')
        if m.get('Offset') is not None:
            self.offset = m.get('Offset')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RepeatNumber') is not None:
            self.repeat_number = m.get('RepeatNumber')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('SourceProtocol') is not None:
            self.source_protocol = m.get('SourceProtocol')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('SourceUrls') is not None:
            self.source_urls_shrink = m.get('SourceUrls')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class CreateLivePullToPushResponseBody(TeaModel):
    def __init__(
        self,
        description: str = None,
        request_id: str = None,
        ret_code: int = None,
        task_id: str = None,
    ):
        # The description of the custom rule.
        self.description = description
        # The ID of the request.
        self.request_id = request_id
        # The code that is returned for the request.
        # 
        # > 
        # 
        # *   0 is returned if the request is normal.
        # 
        # *   For information about codes that are returned when exceptions occur, see the following Error codes table.
        self.ret_code = ret_code
        # The task ID.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ret_code is not None:
            result['RetCode'] = self.ret_code
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RetCode') is not None:
            self.ret_code = m.get('RetCode')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateLivePullToPushResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateLivePullToPushResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLivePullToPushResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLiveRealTimeLogDeliveryRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        logstore: str = None,
        owner_id: int = None,
        project: str = None,
        region: str = None,
        region_id: str = None,
    ):
        # The streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        # The name of the Logstore to which log entries are delivered.
        # 
        # This parameter is required.
        self.logstore = logstore
        self.owner_id = owner_id
        # The name of the Log Service project that is used for real-time log delivery.
        # 
        # This parameter is required.
        self.project = project
        # The ID of the region where the Log Service project is deployed.
        # 
        # This parameter is required.
        self.region = region
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.logstore is not None:
            result['Logstore'] = self.logstore
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.project is not None:
            result['Project'] = self.project
        if self.region is not None:
            result['Region'] = self.region
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Logstore') is not None:
            self.logstore = m.get('Logstore')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Project') is not None:
            self.project = m.get('Project')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateLiveRealTimeLogDeliveryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateLiveRealTimeLogDeliveryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateLiveRealTimeLogDeliveryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLiveRealTimeLogDeliveryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLiveStreamMonitorRequest(TeaModel):
    def __init__(
        self,
        app: str = None,
        callback_url: str = None,
        ding_talk_web_hook_url: str = None,
        domain: str = None,
        input_list: str = None,
        monitor_config: str = None,
        monitor_name: str = None,
        output_template: str = None,
        owner_id: int = None,
        region_id: str = None,
        stream: str = None,
    ):
        # The name of the application that plays the output streams of the monitoring session.
        # 
        # You can specify a name. If you do not specify a name, the system uses **monitor** as the name of the application.
        self.app = app
        # Supports input of callback addresses in HTTP(S) format.
        self.callback_url = callback_url
        # DingTalk alert monitoring sends alert notifications through a DingTalk group robot. Please set up the DingTalk group robot first and enter the HTTP(S) address of the robot here. For more details, see [Custom Robot Access](https://open.dingtalk.com/document/robots/custom-robot-access).
        # > Configure the custom keyword for the DingTalk group robot as \\"alert\\", otherwise, messages will not be received.
        self.ding_talk_web_hook_url = ding_talk_web_hook_url
        # The endpoint of the monitoring session.
        # 
        # This parameter is required.
        self.domain = domain
        # The list of input streams to monitor. For more information, see the following **InputConfig** table.
        # 
        # This parameter is required.
        self.input_list = input_list
        # Alarm threshold setting for monitoring, in JSON format. For more details, please refer to the table below for MonitorConfig.
        self.monitor_config = monitor_config
        # The name of the monitoring session.
        # 
        # This parameter is required.
        self.monitor_name = monitor_name
        # The output template of the monitoring session. Valid values:
        # 
        # *   **lp_ld**: low definition.
        # *   **lp_sd**: standard definition.
        # *   **lp_hd**: high definition.
        # *   **lp_ud**: ultra high definition.
        # 
        # This parameter is required.
        self.output_template = output_template
        self.owner_id = owner_id
        self.region_id = region_id
        # The name of the output stream of the monitoring session. If you do not specify a name, the system generates a name at random.
        self.stream = stream

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app is not None:
            result['App'] = self.app
        if self.callback_url is not None:
            result['CallbackUrl'] = self.callback_url
        if self.ding_talk_web_hook_url is not None:
            result['DingTalkWebHookUrl'] = self.ding_talk_web_hook_url
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.input_list is not None:
            result['InputList'] = self.input_list
        if self.monitor_config is not None:
            result['MonitorConfig'] = self.monitor_config
        if self.monitor_name is not None:
            result['MonitorName'] = self.monitor_name
        if self.output_template is not None:
            result['OutputTemplate'] = self.output_template
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.stream is not None:
            result['Stream'] = self.stream
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('CallbackUrl') is not None:
            self.callback_url = m.get('CallbackUrl')
        if m.get('DingTalkWebHookUrl') is not None:
            self.ding_talk_web_hook_url = m.get('DingTalkWebHookUrl')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('InputList') is not None:
            self.input_list = m.get('InputList')
        if m.get('MonitorConfig') is not None:
            self.monitor_config = m.get('MonitorConfig')
        if m.get('MonitorName') is not None:
            self.monitor_name = m.get('MonitorName')
        if m.get('OutputTemplate') is not None:
            self.output_template = m.get('OutputTemplate')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Stream') is not None:
            self.stream = m.get('Stream')
        return self


class CreateLiveStreamMonitorResponseBody(TeaModel):
    def __init__(
        self,
        monitor_id: str = None,
        request_id: str = None,
    ):
        # The ID of the monitoring session.
        self.monitor_id = monitor_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.monitor_id is not None:
            result['MonitorId'] = self.monitor_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MonitorId') is not None:
            self.monitor_id = m.get('MonitorId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateLiveStreamMonitorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateLiveStreamMonitorResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLiveStreamMonitorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLiveStreamRecordIndexFilesRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        end_time: str = None,
        end_time_included: bool = None,
        oss_bucket: str = None,
        oss_endpoint: str = None,
        oss_object: str = None,
        owner_id: int = None,
        security_token: str = None,
        start_time: str = None,
        stream_name: str = None,
    ):
        # The name of the application to which the live stream belongs. The value of this parameter must be the same as the application name in the ingest URL. Otherwise, the configuration does not take effect. If you want to match all applications, specify an asterisk (\\*) as the value.
        # 
        # This parameter is required.
        self.app_name = app_name
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        # The end time of the index file. TS segments that are uploaded before the end time are included in the index file. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        # 
        # This parameter is required.
        self.end_time = end_time
        # Specifies whether to include the end time. If you set this parameter to true, the system attempts to include one more TS segment. The created index file covers the entire time range that is specified by the StartTime and EndTime parameters.
        self.end_time_included = end_time_included
        # The name of the OSS bucket.
        # 
        # This parameter is required.
        self.oss_bucket = oss_bucket
        # The endpoint of the OSS bucket.
        # 
        # This parameter is required.
        self.oss_endpoint = oss_endpoint
        # The name of the recording that is stored in OSS.
        # 
        # This parameter is required.
        self.oss_object = oss_object
        self.owner_id = owner_id
        self.security_token = security_token
        # The start time of the index file. TS segments that are uploaded after the start time are included in the index file. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        # 
        # This parameter is required.
        self.start_time = start_time
        # The name of the live stream. The value of this parameter must be the same as the stream name in the ingest URL. Otherwise, the configuration does not take effect. If you want to match all streams, specify an asterisk (\\*) as the value.
        # 
        # This parameter is required.
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.end_time_included is not None:
            result['EndTimeIncluded'] = self.end_time_included
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        if self.oss_object is not None:
            result['OssObject'] = self.oss_object
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EndTimeIncluded') is not None:
            self.end_time_included = m.get('EndTimeIncluded')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        if m.get('OssObject') is not None:
            self.oss_object = m.get('OssObject')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class CreateLiveStreamRecordIndexFilesResponseBodyRecordInfo(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        create_time: str = None,
        domain_name: str = None,
        duration: float = None,
        end_time: str = None,
        height: int = None,
        oss_bucket: str = None,
        oss_endpoint: str = None,
        oss_object: str = None,
        record_id: str = None,
        record_url: str = None,
        start_time: str = None,
        stream_name: str = None,
        width: int = None,
    ):
        # The name of the application to which the live stream belongs.
        self.app_name = app_name
        # The time when the index file was created. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*hh:mm:ss*Z format. The time is displayed in UTC.
        self.create_time = create_time
        # The main streaming domain.
        self.domain_name = domain_name
        # The recording length. Unit: seconds.
        self.duration = duration
        # The end time of the index file. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.end_time = end_time
        # The height of the video.
        self.height = height
        # The name of the OSS bucket.
        self.oss_bucket = oss_bucket
        # The endpoint of the OSS bucket.
        self.oss_endpoint = oss_endpoint
        # The name of the recording that is stored in OSS.
        self.oss_object = oss_object
        # The ID of the index file.
        self.record_id = record_id
        # The URL of the M3U8 index file.
        self.record_url = record_url
        # The start time of the index file. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*hh:mm:ss*Z format. The time is displayed in UTC.
        self.start_time = start_time
        # The name of the live stream.
        self.stream_name = stream_name
        # The width of the video.
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.height is not None:
            result['Height'] = self.height
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        if self.oss_object is not None:
            result['OssObject'] = self.oss_object
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.record_url is not None:
            result['RecordUrl'] = self.record_url
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        if m.get('OssObject') is not None:
            self.oss_object = m.get('OssObject')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('RecordUrl') is not None:
            self.record_url = m.get('RecordUrl')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class CreateLiveStreamRecordIndexFilesResponseBody(TeaModel):
    def __init__(
        self,
        record_info: CreateLiveStreamRecordIndexFilesResponseBodyRecordInfo = None,
        request_id: str = None,
    ):
        # The recording configuration.
        self.record_info = record_info
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.record_info:
            self.record_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.record_info is not None:
            result['RecordInfo'] = self.record_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RecordInfo') is not None:
            temp_model = CreateLiveStreamRecordIndexFilesResponseBodyRecordInfo()
            self.record_info = temp_model.from_map(m['RecordInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateLiveStreamRecordIndexFilesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateLiveStreamRecordIndexFilesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLiveStreamRecordIndexFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMessageAppRequest(TeaModel):
    def __init__(
        self,
        app_config: Dict[str, str] = None,
        app_name: str = None,
        extension: Dict[str, str] = None,
    ):
        # The configurations of the application.
        self.app_config = app_config
        # The name of the interactive message application. The name must be 2 to 16 characters in length.
        # 
        # This parameter is required.
        self.app_name = app_name
        # The extended fields.
        self.extension = extension

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_config is not None:
            result['AppConfig'] = self.app_config
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.extension is not None:
            result['Extension'] = self.extension
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppConfig') is not None:
            self.app_config = m.get('AppConfig')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        return self


class CreateMessageAppShrinkRequest(TeaModel):
    def __init__(
        self,
        app_config_shrink: str = None,
        app_name: str = None,
        extension_shrink: str = None,
    ):
        # The configurations of the application.
        self.app_config_shrink = app_config_shrink
        # The name of the interactive message application. The name must be 2 to 16 characters in length.
        # 
        # This parameter is required.
        self.app_name = app_name
        # The extended fields.
        self.extension_shrink = extension_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_config_shrink is not None:
            result['AppConfig'] = self.app_config_shrink
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.extension_shrink is not None:
            result['Extension'] = self.extension_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppConfig') is not None:
            self.app_config_shrink = m.get('AppConfig')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('Extension') is not None:
            self.extension_shrink = m.get('Extension')
        return self


class CreateMessageAppResponseBodyResult(TeaModel):
    def __init__(
        self,
        app_id: str = None,
    ):
        # The ID of the interactive messaging application.
        self.app_id = app_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        return self


class CreateMessageAppResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        result: CreateMessageAppResponseBodyResult = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The returned result.
        self.result = result

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            temp_model = CreateMessageAppResponseBodyResult()
            self.result = temp_model.from_map(m['Result'])
        return self


class CreateMessageAppResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMessageAppResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMessageAppResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMessageGroupRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        creator_id: str = None,
        extension: Dict[str, str] = None,
    ):
        # The ID of the interactive messaging application.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The ID of the creator. The ID can be up to 36 characters in length and can contain only letters and digits.
        # 
        # This parameter is required.
        self.creator_id = creator_id
        # The extended field.
        self.extension = extension

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.extension is not None:
            result['Extension'] = self.extension
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        return self


class CreateMessageGroupShrinkRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        creator_id: str = None,
        extension_shrink: str = None,
    ):
        # The ID of the interactive messaging application.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The ID of the creator. The ID can be up to 36 characters in length and can contain only letters and digits.
        # 
        # This parameter is required.
        self.creator_id = creator_id
        # The extended field.
        self.extension_shrink = extension_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.extension_shrink is not None:
            result['Extension'] = self.extension_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('Extension') is not None:
            self.extension_shrink = m.get('Extension')
        return self


class CreateMessageGroupResponseBodyResult(TeaModel):
    def __init__(
        self,
        extension: Dict[str, Any] = None,
        group_id: str = None,
    ):
        # The extended field.
        self.extension = extension
        # The ID of the message group.
        self.group_id = group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class CreateMessageGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        result: CreateMessageGroupResponseBodyResult = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The returned result.
        self.result = result

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            temp_model = CreateMessageGroupResponseBodyResult()
            self.result = temp_model.from_map(m['Result'])
        return self


class CreateMessageGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMessageGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMessageGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMixStreamRequest(TeaModel):
    def __init__(
        self,
        callback_config: str = None,
        domain_name: str = None,
        input_stream_list: str = None,
        layout_id: str = None,
        output_config: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The callback URL. The value is a JSON array. If a callback event is triggered, ApsaraVideo Live sends an HTTP POST request to the URL. The content is included in the HTTP request body.
        self.callback_config = callback_config
        # The main streaming domain.
        # 
        # >  Only domain names that reside in the China (Shanghai) and China (Beijing) regions are supported.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        # The input streams. The value is a JSON array.
        # 
        # For more information, see **InputStreamConfig**.
        # 
        # This parameter is required.
        self.input_stream_list = input_stream_list
        # The ID of the layout. Valid values:
        # 
        # *   **MixStreamLayout-1-1**\
        # *   **MixStreamLayout-2-1**\
        # *   **MixStreamLayout-2-2**\
        # *   **MixStreamLayout-2-3**\
        # *   **MixStreamLayout-3-1**\
        # *   **MixStreamLayout-3-2**\
        # *   **MixStreamLayout-4-1**\
        # *   **USERDEFINED**: If you do not use a preset layout, set this parameter to **USERDEFINED**.
        # 
        # >  For more information, see [Preset layouts for stream mixing](https://help.aliyun.com/document_detail/199361.html).
        # 
        # This parameter is required.
        self.layout_id = layout_id
        # The configuration of the output stream. The value is a JSON string.
        # 
        # For more information, see **OutputConfig**.
        # 
        # This parameter is required.
        self.output_config = output_config
        self.owner_id = owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.callback_config is not None:
            result['CallbackConfig'] = self.callback_config
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.input_stream_list is not None:
            result['InputStreamList'] = self.input_stream_list
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        if self.output_config is not None:
            result['OutputConfig'] = self.output_config
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CallbackConfig') is not None:
            self.callback_config = m.get('CallbackConfig')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('InputStreamList') is not None:
            self.input_stream_list = m.get('InputStreamList')
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        if m.get('OutputConfig') is not None:
            self.output_config = m.get('OutputConfig')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateMixStreamResponseBody(TeaModel):
    def __init__(
        self,
        mix_stream_id: str = None,
        request_id: str = None,
    ):
        # The ID of the stream mixing task. You can specify this parameter in a request to delete the stream mixing task or query stream mixing tasks.
        self.mix_stream_id = mix_stream_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mix_stream_id is not None:
            result['MixStreamId'] = self.mix_stream_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MixStreamId') is not None:
            self.mix_stream_id = m.get('MixStreamId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateMixStreamResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMixStreamResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMixStreamResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRTCWhipStreamAddressRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        channel_id: str = None,
        client_token: str = None,
        display_name: str = None,
        expire_time: int = None,
        user_id: str = None,
    ):
        # This parameter is required.
        self.app_id = app_id
        # This parameter is required.
        self.channel_id = channel_id
        self.client_token = client_token
        # This parameter is required.
        self.display_name = display_name
        self.expire_time = expire_time
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class CreateRTCWhipStreamAddressResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        whip_address: str = None,
    ):
        self.request_id = request_id
        self.whip_address = whip_address

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.whip_address is not None:
            result['WhipAddress'] = self.whip_address
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('WhipAddress') is not None:
            self.whip_address = m.get('WhipAddress')
        return self


class CreateRTCWhipStreamAddressResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateRTCWhipStreamAddressResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRTCWhipStreamAddressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRoomRealTimeStreamAddressRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        channel_id: str = None,
        display_name: str = None,
        expire_time: int = None,
        user_id: str = None,
    ):
        # The ID of the ARTC application. You can specify only one application ID. The ID can be up to 64 characters in length and can contain letters, digits, underscores (_), and hyphens (-).
        # 
        # This parameter is required.
        self.app_id = app_id
        # The ID of the channel. You can specify only one ID. The ID can be up to 64 characters in length and can contain letters, digits, underscores (_), and hyphens (-).
        # 
        # This parameter is required.
        self.channel_id = channel_id
        # The name of the RTMP stream. The name can be up to 40 characters in length.
        # 
        # This parameter is required.
        self.display_name = display_name
        # The validity period of the RTMP URL. Unit: seconds. The default value is 36,000 seconds, which is 10 hours.
        self.expire_time = expire_time
        # The ID of the user who ingests the stream over RTMP. The user ID must be different from IDs of other users in the channel. The ID can be up to 64 characters in length and can contain letters, digits, underscores (_), and hyphens (-).
        # 
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class CreateRoomRealTimeStreamAddressResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        rtmp_address: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The RTMP ingest URL.
        self.rtmp_address = rtmp_address

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rtmp_address is not None:
            result['RtmpAddress'] = self.rtmp_address
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RtmpAddress') is not None:
            self.rtmp_address = m.get('RtmpAddress')
        return self


class CreateRoomRealTimeStreamAddressResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateRoomRealTimeStreamAddressResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRoomRealTimeStreamAddressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRtcAsrTaskRequest(TeaModel):
    def __init__(
        self,
        auth_key: str = None,
        auto_terminate_delay: int = None,
        auto_terminate_enabled: bool = None,
        callback_url: str = None,
        channel_id: str = None,
        language: str = None,
        mode: str = None,
        owner_id: int = None,
        region_id: str = None,
        report_interval: int = None,
        rtc_user_id: str = None,
        sdkapp_id: str = None,
        stream_url: str = None,
        target_languages: str = None,
        translate_enabled: bool = None,
    ):
        # The AuthKey that is used to generate the MD5 signature in callbacks.
        self.auth_key = auth_key
        # The maximum latency at which the task is automatically stopped. Unit: seconds. Valid values: 1 to 10.
        self.auto_terminate_delay = auto_terminate_delay
        # Specifies whether to automatically stop the task when the latency exceeds the specified limit. Default value: false.
        self.auto_terminate_enabled = auto_terminate_enabled
        # The callback URL.
        # 
        # This parameter is required.
        self.callback_url = callback_url
        # The ID of the channel.
        # 
        # >  This parameter is required and takes effect only if you set the Mode parameter to rtc.
        self.channel_id = channel_id
        # The source language of the audio. Valid values:
        # 
        # *   ja: Japanese
        # *   yue: Cantonese
        # *   fspk: mixed Mandarin and English
        # *   en: English
        # *   cn: Mandarin
        # 
        # This parameter is required.
        self.language = language
        # The type of the stream. Valid values: live and rtc. The value live specifies a regular live stream, such as a Real-Time Messaging Protocol (RTMP) stream.
        # 
        # This parameter is required.
        self.mode = mode
        self.owner_id = owner_id
        self.region_id = region_id
        # The interval at which callbacks are returned. Unit: milliseconds. Valid values: -1 and 0 to 500.
        # 
        # *   \\-1: accepts callbacks only for whole sentences, but not for incomplete sentences.
        # *   0 or an empty value: returns callbacks in real time.
        # *   A value that is greater than 0 and less than or equal to 500: returns callbacks at the specified interval.
        self.report_interval = report_interval
        # The ID of the user who ingests the stream.
        # 
        # >  This parameter is required and takes effect only if you set the Mode parameter to rtc. You can specify only one user ID.
        self.rtc_user_id = rtc_user_id
        # The ID of the ApsaraVideo Real-time Communication (ARTC) application.
        # 
        # >  This parameter is required and takes effect only if you set the Mode parameter to rtc.
        self.sdkapp_id = sdkapp_id
        # The URL of the live stream.
        # 
        # >  This parameter is required and takes effect only if you set the Mode parameter to live.
        self.stream_url = stream_url
        # The language into which the subtitles are translated. Valid values:
        # 
        # *   cn: Chinese
        # *   en: English
        # *   ja: Japanese
        self.target_languages = target_languages
        # Specifies whether to enable the translation feature.
        self.translate_enabled = translate_enabled

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_key is not None:
            result['AuthKey'] = self.auth_key
        if self.auto_terminate_delay is not None:
            result['AutoTerminateDelay'] = self.auto_terminate_delay
        if self.auto_terminate_enabled is not None:
            result['AutoTerminateEnabled'] = self.auto_terminate_enabled
        if self.callback_url is not None:
            result['CallbackURL'] = self.callback_url
        if self.channel_id is not None:
            result['ChannelID'] = self.channel_id
        if self.language is not None:
            result['Language'] = self.language
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.report_interval is not None:
            result['ReportInterval'] = self.report_interval
        if self.rtc_user_id is not None:
            result['RtcUserId'] = self.rtc_user_id
        if self.sdkapp_id is not None:
            result['SDKAppID'] = self.sdkapp_id
        if self.stream_url is not None:
            result['StreamURL'] = self.stream_url
        if self.target_languages is not None:
            result['TargetLanguages'] = self.target_languages
        if self.translate_enabled is not None:
            result['TranslateEnabled'] = self.translate_enabled
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthKey') is not None:
            self.auth_key = m.get('AuthKey')
        if m.get('AutoTerminateDelay') is not None:
            self.auto_terminate_delay = m.get('AutoTerminateDelay')
        if m.get('AutoTerminateEnabled') is not None:
            self.auto_terminate_enabled = m.get('AutoTerminateEnabled')
        if m.get('CallbackURL') is not None:
            self.callback_url = m.get('CallbackURL')
        if m.get('ChannelID') is not None:
            self.channel_id = m.get('ChannelID')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ReportInterval') is not None:
            self.report_interval = m.get('ReportInterval')
        if m.get('RtcUserId') is not None:
            self.rtc_user_id = m.get('RtcUserId')
        if m.get('SDKAppID') is not None:
            self.sdkapp_id = m.get('SDKAppID')
        if m.get('StreamURL') is not None:
            self.stream_url = m.get('StreamURL')
        if m.get('TargetLanguages') is not None:
            self.target_languages = m.get('TargetLanguages')
        if m.get('TranslateEnabled') is not None:
            self.translate_enabled = m.get('TranslateEnabled')
        return self


class CreateRtcAsrTaskResponseBody(TeaModel):
    def __init__(
        self,
        description: str = None,
        request_id: str = None,
        ret_code: int = None,
        task_id: str = None,
    ):
        # The result of the request. If success is returned, the request is successful. If an error message is returned, the request failed.
        self.description = description
        # The ID of the request.
        self.request_id = request_id
        # The returned HTTP status code. HTTP status code 2000 indicates that the request is successful. If another HTTP status code is returned, the request failed.
        self.ret_code = ret_code
        # The ID of the task.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ret_code is not None:
            result['RetCode'] = self.ret_code
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RetCode') is not None:
            self.ret_code = m.get('RetCode')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateRtcAsrTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateRtcAsrTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRtcAsrTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRtcMPUEventSubRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        callback_url: str = None,
        channel_ids: str = None,
    ):
        # The ID of the application.
        # 
        # > The ID can be up to 64 characters in length and can contain letters, digits, underscores, and hyphens (-).
        # 
        # This parameter is required.
        self.app_id = app_id
        # The callback URL.
        # 
        # > The callback URL can be up to 2,083 characters in length. You can use headers such as HTTP and HTTPS in callback URLs. The URL can contain letters, digits, and the following special characters: - _ ? % = # . / +\
        # 
        # This parameter is required.
        self.callback_url = callback_url
        # The ID of the channel to which you want to send mixed-stream relay event callbacks. Separate multiple channel IDs with commas (,).
        # 
        # > 
        # 
        # *   If you leave this parameter empty, you are subscribed to mixed-stream relay events of all channels in the application.
        # 
        # *   You cannot specify duplicate channel IDs. You can specify up to 20 channel IDs in each call.
        # 
        # *   The ID can be up to 64 characters in length and contain letters, digits, underscores (_), and hyphens (-).
        self.channel_ids = channel_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.callback_url is not None:
            result['CallbackUrl'] = self.callback_url
        if self.channel_ids is not None:
            result['ChannelIds'] = self.channel_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CallbackUrl') is not None:
            self.callback_url = m.get('CallbackUrl')
        if m.get('ChannelIds') is not None:
            self.channel_ids = m.get('ChannelIds')
        return self


class CreateRtcMPUEventSubResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        sub_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The ID of the subscription.
        self.sub_id = sub_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sub_id is not None:
            result['SubId'] = self.sub_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SubId') is not None:
            self.sub_id = m.get('SubId')
        return self


class CreateRtcMPUEventSubResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateRtcMPUEventSubResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRtcMPUEventSubResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCasterRequest(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The ID of the production studio.
        # 
        # *   If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation, check the value of the response parameter CasterId to obtain the ID.
        # *   If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        # 
        # >  You can find the ID of the production studio in the Instance ID/Name column.
        # 
        # This parameter is required.
        self.caster_id = caster_id
        self.owner_id = owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteCasterResponseBody(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        request_id: str = None,
    ):
        # The ID of the production studio. You can use the ID as a request parameter in the API operation that is used to add input sources, layouts, components, or an episode list to the production studio or query the layouts of the production studio.
        self.caster_id = caster_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCasterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCasterResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCasterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCasterComponentRequest(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        component_id: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The ID of the production studio.
        # 
        # *   If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation, check the value of the response parameter CasterId to obtain the ID.
        # *   If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        # 
        # >  You can find the ID of the production studio in the Instance ID/Name column.
        # 
        # This parameter is required.
        self.caster_id = caster_id
        # The component ID. If the component was added by calling the [AddCasterComponent](https://help.aliyun.com/document_detail/2848030.html) operation, check the value of the response parameter ComponentId to obtain the ID.
        # 
        # This parameter is required.
        self.component_id = component_id
        self.owner_id = owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteCasterComponentResponseBody(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        component_id: str = None,
        request_id: str = None,
    ):
        # The ID of the production studio. You can use the ID as a request parameter in the API operation that is called to query the components in the production studio, add an episode list to the production studio, or modify a component in the production studio.
        self.caster_id = caster_id
        # The component ID. You can use the ID as a request parameter in the API operation that is called to query the component in the production studio or modify the component in the production studio.
        self.component_id = component_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCasterComponentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCasterComponentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCasterComponentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCasterEpisodeRequest(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        episode_id: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The ID of the production studio.
        # 
        # *   If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation, check the value of the response parameter CasterId to obtain the ID.
        # *   If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        # 
        # >  You can find the ID of the production studio in the Instance ID/Name column.
        # 
        # This parameter is required.
        self.caster_id = caster_id
        # The ID of the episode. If the episode was added by calling the [AddCasterEpisode](https://help.aliyun.com/document_detail/2848068.html) operation, check the value of the response parameter EpisodeId to obtain the ID.
        # 
        # This parameter is required.
        self.episode_id = episode_id
        self.owner_id = owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.episode_id is not None:
            result['EpisodeId'] = self.episode_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('EpisodeId') is not None:
            self.episode_id = m.get('EpisodeId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteCasterEpisodeResponseBody(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        episode_id: str = None,
        request_id: str = None,
    ):
        # The ID of the production studio. You can specify the ID as a parameter in the request to modify the episode in the production studio.
        self.caster_id = caster_id
        # The ID of the episode. You can specify the ID as a parameter in the request to modify the episode in the production studio.
        self.episode_id = episode_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.episode_id is not None:
            result['EpisodeId'] = self.episode_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('EpisodeId') is not None:
            self.episode_id = m.get('EpisodeId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCasterEpisodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCasterEpisodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCasterEpisodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCasterEpisodeGroupRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        program_id: str = None,
        region_id: str = None,
    ):
        self.owner_id = owner_id
        # The ID of the episode list. If the episode list was added by calling the [AddCasterEpisodeGroup](https://help.aliyun.com/document_detail/2848071.html) operation, check the value of the response parameter ProgramId to obtain the ID.
        # 
        # This parameter is required.
        self.program_id = program_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.program_id is not None:
            result['ProgramId'] = self.program_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProgramId') is not None:
            self.program_id = m.get('ProgramId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteCasterEpisodeGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCasterEpisodeGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCasterEpisodeGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCasterEpisodeGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCasterLayoutRequest(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        layout_id: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The ID of the production studio.
        # 
        # *   If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/69338.html) operation, check the value of the response parameter CasterId to obtain the ID.
        # *   If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        # 
        # >  You can find the ID of the production studio in the Instance ID/Name column.
        # 
        # This parameter is required.
        self.caster_id = caster_id
        # The ID of the layout. If the layout was added by calling the [AddCasterLayout](https://help.aliyun.com/document_detail/60249.html) operation, check the value of the response parameter LayoutId to obtain the ID.
        # 
        # This parameter is required.
        self.layout_id = layout_id
        self.owner_id = owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteCasterLayoutResponseBody(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        layout_id: str = None,
        request_id: str = None,
    ):
        # The ID of the production studio. You can use the ID as a request parameter in the API operation that is used to modify a layout in the production studio, query layouts in the production studio, add a component in the production studio, or query components in the production studio.
        self.caster_id = caster_id
        # The ID of the layout. You can use the ID as a request parameter in the API operation that is used to query layouts in the production studio.
        self.layout_id = layout_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCasterLayoutResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCasterLayoutResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCasterLayoutResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCasterProgramRequest(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The ID of the production studio.
        # 
        # *   If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation, check the value of the response parameter CasterId to obtain the ID.
        # *   If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        # 
        # >  You can find the ID of the production studio in the Instance ID/Name column.
        # 
        # This parameter is required.
        self.caster_id = caster_id
        self.owner_id = owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteCasterProgramResponseBody(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        request_id: str = None,
    ):
        # The ID of the production studio. You can specify the ID as a request parameter in the API operation that is used to add, delete, or modify episodes in the production studio.
        self.caster_id = caster_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCasterProgramResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCasterProgramResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCasterProgramResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCasterSceneConfigRequest(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        owner_id: int = None,
        region_id: str = None,
        scene_id: str = None,
        type: str = None,
    ):
        # The ID of the production studio.
        # 
        # *   If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/69338.html) operation, check the value of the response parameter CasterId to obtain the ID.
        # *   If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        # 
        # >  You can find the ID of the production studio in the Instance ID/Name column.
        # 
        # This parameter is required.
        self.caster_id = caster_id
        self.owner_id = owner_id
        self.region_id = region_id
        # The ID of the scene.
        # 
        # This parameter is required.
        self.scene_id = scene_id
        # The type of the setting that you want to delete. Valid values:
        # 
        # *   **Component**: component setting
        # *   **Layout**: layout setting
        # *   **All**: component and layout settings
        # 
        # This parameter is required.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.scene_id is not None:
            result['SceneId'] = self.scene_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SceneId') is not None:
            self.scene_id = m.get('SceneId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DeleteCasterSceneConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCasterSceneConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCasterSceneConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCasterSceneConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCasterVideoResourceRequest(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_id: str = None,
    ):
        # The ID of the production studio.
        # 
        # *   If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/69338.html) operation, check the value of the response parameter CasterId to obtain the ID.
        # *   If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        # 
        # >  You can find the ID of the production studio in the Instance ID/Name column.
        # 
        # This parameter is required.
        self.caster_id = caster_id
        self.owner_id = owner_id
        self.region_id = region_id
        # The resource ID. If the input source was added by calling the AddCasterVideoResource operation, check the value of the response parameter ResourceId to obtain the ID.
        # 
        # This parameter is required.
        self.resource_id = resource_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class DeleteCasterVideoResourceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCasterVideoResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCasterVideoResourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCasterVideoResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteChannelRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        channel_id: str = None,
    ):
        # The application ID. You can specify only one application ID.
        self.app_id = app_id
        # The channel ID. You can specify only one channel ID.
        self.channel_id = channel_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        return self


class DeleteChannelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteChannelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteChannelResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCustomTemplateRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        region_id: str = None,
        template: str = None,
    ):
        self.owner_id = owner_id
        self.region_id = region_id
        # The name of the template that you want to delete. The value is a string.
        # 
        # This parameter is required.
        self.template = template

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.template is not None:
            result['Template'] = self.template
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Template') is not None:
            self.template = m.get('Template')
        return self


class DeleteCustomTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCustomTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCustomTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCustomTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEdgeTranscodeJobRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        job_id: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The ID of the data center.
        # 
        # This parameter is required.
        self.cluster_id = cluster_id
        # The ID of the edge transcoding task.
        # 
        # This parameter is required.
        self.job_id = job_id
        self.owner_id = owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteEdgeTranscodeJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteEdgeTranscodeJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteEdgeTranscodeJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEdgeTranscodeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEventSubRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        subscribe_id: str = None,
    ):
        # The ID of the application.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The subscription ID. You can obtain the ID from the response to the [CreateEventSub](https://help.aliyun.com/document_detail/2848209.html) operation.
        # 
        # This parameter is required.
        self.subscribe_id = subscribe_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.subscribe_id is not None:
            result['SubscribeId'] = self.subscribe_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('SubscribeId') is not None:
            self.subscribe_id = m.get('SubscribeId')
        return self


class DeleteEventSubResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteEventSubResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteEventSubResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEventSubResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveAIProduceRulesRequest(TeaModel):
    def __init__(
        self,
        app: str = None,
        domain: str = None,
        owner_id: int = None,
        region_id: str = None,
        rules_id: str = None,
        suffix_name: str = None,
    ):
        # The name of the application to which the live stream belongs.
        # 
        # This parameter is required.
        self.app = app
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain = domain
        self.owner_id = owner_id
        self.region_id = region_id
        # The ID of the subtitle rule.
        self.rules_id = rules_id
        # The suffix of the subtitle rule.
        # 
        # >  Set the value to the name of the subtitle template.
        self.suffix_name = suffix_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app is not None:
            result['App'] = self.app
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rules_id is not None:
            result['RulesId'] = self.rules_id
        if self.suffix_name is not None:
            result['SuffixName'] = self.suffix_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RulesId') is not None:
            self.rules_id = m.get('RulesId')
        if m.get('SuffixName') is not None:
            self.suffix_name = m.get('SuffixName')
        return self


class DeleteLiveAIProduceRulesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveAIProduceRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveAIProduceRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveAIProduceRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveAIStudioRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        region_id: str = None,
        studio_id: str = None,
    ):
        self.owner_id = owner_id
        self.region_id = region_id
        # The ID of the template. You can obtain the ID from the response to the CreateLiveAIStudio operation.
        # 
        # This parameter is required.
        self.studio_id = studio_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.studio_id is not None:
            result['StudioId'] = self.studio_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StudioId') is not None:
            self.studio_id = m.get('StudioId')
        return self


class DeleteLiveAIStudioResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveAIStudioResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveAIStudioResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveAIStudioResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveAISubtitleRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        region_id: str = None,
        subtitle_id: str = None,
        subtitle_name: str = None,
    ):
        self.owner_id = owner_id
        self.region_id = region_id
        # The ID of the subtitle template.
        # 
        # This parameter is required.
        self.subtitle_id = subtitle_id
        # The name of the subtitle template. The name can contain only digits, letters, and hyphens (-). The name cannot start with a hyphen.
        self.subtitle_name = subtitle_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.subtitle_id is not None:
            result['SubtitleId'] = self.subtitle_id
        if self.subtitle_name is not None:
            result['SubtitleName'] = self.subtitle_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SubtitleId') is not None:
            self.subtitle_id = m.get('SubtitleId')
        if m.get('SubtitleName') is not None:
            self.subtitle_name = m.get('SubtitleName')
        return self


class DeleteLiveAISubtitleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveAISubtitleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveAISubtitleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveAISubtitleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveAppRecordConfigRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        owner_id: int = None,
        security_token: str = None,
        stream_name: str = None,
    ):
        # The name of the application to which the live stream belongs.
        # 
        # This parameter is required.
        self.app_name = app_name
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        self.owner_id = owner_id
        self.security_token = security_token
        # The name of the live stream.
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DeleteLiveAppRecordConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveAppRecordConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveAppRecordConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveAppRecordConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveAppSnapshotConfigRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        owner_id: int = None,
        security_token: str = None,
    ):
        # The name of the application to which the live stream belongs. The value of this parameter must be the same as the application name in the ingest URL. Otherwise, the configuration does not take effect. You can view the application name on the [Stream Management](https://help.aliyun.com/document_detail/197397.html) page of the ApsaraVideo Live console.
        # 
        # This parameter is required.
        self.app_name = app_name
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        self.owner_id = owner_id
        self.security_token = security_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DeleteLiveAppSnapshotConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveAppSnapshotConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveAppSnapshotConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveAppSnapshotConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveAudioAuditConfigRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        owner_id: int = None,
        region_id: str = None,
        stream_name: str = None,
    ):
        # The name of the application to which the live stream belongs.
        # 
        # >  A value of asterisk (\\*) specifies all applications under the domain name.
        # 
        # This parameter is required.
        self.app_name = app_name
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        self.owner_id = owner_id
        self.region_id = region_id
        # The name of the live stream.
        # 
        # >  A value of asterisk (\\*) specifies all live streams in the application.
        # 
        # This parameter is required.
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DeleteLiveAudioAuditConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveAudioAuditConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveAudioAuditConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveAudioAuditConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveAudioAuditNotifyConfigRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        self.owner_id = owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteLiveAudioAuditNotifyConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveAudioAuditNotifyConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveAudioAuditNotifyConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveAudioAuditNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveCenterTransferRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        dst_url: str = None,
        owner_id: int = None,
        region_id: str = None,
        stream_name: str = None,
    ):
        # The name of the application to which the live stream belongs. The value of this parameter must be the same as the application name for the live stream that you want to relay. Otherwise, the configuration does not take effect. You can view the application name on the [Stream Management](https://help.aliyun.com/document_detail/197397.html) page of the ApsaraVideo Live console.
        # 
        # This parameter is required.
        self.app_name = app_name
        # The streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        # The third-party URL to which the live stream is relayed.
        self.dst_url = dst_url
        self.owner_id = owner_id
        self.region_id = region_id
        # The name of the live stream. You can view the stream name on the [Stream Management](https://help.aliyun.com/document_detail/197397.html) page of the ApsaraVideo Live console.
        # 
        # This parameter is required.
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.dst_url is not None:
            result['DstUrl'] = self.dst_url
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DstUrl') is not None:
            self.dst_url = m.get('DstUrl')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DeleteLiveCenterTransferResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveCenterTransferResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveCenterTransferResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveCenterTransferResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveDelayConfigRequest(TeaModel):
    def __init__(
        self,
        app: str = None,
        domain: str = None,
        owner_id: int = None,
        region_id: str = None,
        stream: str = None,
    ):
        # The name of the application to which the live stream belongs. You can specify an asterisk (\\*) as the value to match all applications that belong to the domain name.
        # 
        # This parameter is required.
        self.app = app
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain = domain
        self.owner_id = owner_id
        self.region_id = region_id
        # The name of the live stream. You can use the wildcard (\\*) to specify all streams of the application.
        # 
        # This parameter is required.
        self.stream = stream

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app is not None:
            result['App'] = self.app
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.stream is not None:
            result['Stream'] = self.stream
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Stream') is not None:
            self.stream = m.get('Stream')
        return self


class DeleteLiveDelayConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveDelayConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveDelayConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveDelayConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveDetectNotifyConfigRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        owner_id: int = None,
        security_token: str = None,
    ):
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        self.owner_id = owner_id
        self.security_token = security_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DeleteLiveDetectNotifyConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveDetectNotifyConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveDetectNotifyConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveDetectNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveDomainRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        security_token: str = None,
    ):
        # The ingest domain or streaming domain that you want to delete.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.security_token = security_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DeleteLiveDomainResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveDomainResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveDomainResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveDomainMappingRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        pull_domain: str = None,
        push_domain: str = None,
        security_token: str = None,
    ):
        self.owner_id = owner_id
        # The streaming domain. The type of the domain name is **liveVideo**.
        # 
        # This parameter is required.
        self.pull_domain = pull_domain
        # The ingest domain. The type of the domain name is **liveEdge**.
        # 
        # This parameter is required.
        self.push_domain = push_domain
        self.security_token = security_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pull_domain is not None:
            result['PullDomain'] = self.pull_domain
        if self.push_domain is not None:
            result['PushDomain'] = self.push_domain
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PullDomain') is not None:
            self.pull_domain = m.get('PullDomain')
        if m.get('PushDomain') is not None:
            self.push_domain = m.get('PushDomain')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DeleteLiveDomainMappingResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveDomainMappingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveDomainMappingResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveDomainMappingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveDomainPlayMappingRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        play_domain: str = None,
        pull_domain: str = None,
        region_id: str = None,
    ):
        self.owner_id = owner_id
        # The sub-streaming domain.
        # 
        # This parameter is required.
        self.play_domain = play_domain
        # The main streaming domain.
        # 
        # This parameter is required.
        self.pull_domain = pull_domain
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.play_domain is not None:
            result['PlayDomain'] = self.play_domain
        if self.pull_domain is not None:
            result['PullDomain'] = self.pull_domain
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PlayDomain') is not None:
            self.play_domain = m.get('PlayDomain')
        if m.get('PullDomain') is not None:
            self.pull_domain = m.get('PullDomain')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteLiveDomainPlayMappingResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveDomainPlayMappingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveDomainPlayMappingResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveDomainPlayMappingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveEdgeTransferRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The ingest domain. You can set only one stream relay configuration for an ingest domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        self.owner_id = owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteLiveEdgeTransferResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveEdgeTransferResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveEdgeTransferResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveEdgeTransferResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveLazyPullStreamInfoConfigRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The name of the application to which the live stream belongs.
        # 
        # >  If you want to delete configurations of triggered stream pulling for all applications, set the value to **ali_all_app**.
        # 
        # This parameter is required.
        self.app_name = app_name
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        self.owner_id = owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteLiveLazyPullStreamInfoConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveLazyPullStreamInfoConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveLazyPullStreamInfoConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveLazyPullStreamInfoConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveMessageGroupRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        data_center: str = None,
        group_id: str = None,
        operator_id: str = None,
    ):
        # The application ID.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The data center. It must be the same as the data center that was specified when you called the [CreateLiveMessageApp](https://help.aliyun.com/document_detail/2848162.html) operation to create the interactive messaging application. Valid values: cn-shanghai and ap-southeast-1 (Singapore).
        self.data_center = data_center
        # The ID of the group that you want to delete.
        # 
        # This parameter is required.
        self.group_id = group_id
        # The ID of the user who performs the deletion operation. The ID can be up to 64 bytes in length and can contain only letters and digits.
        self.operator_id = operator_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.data_center is not None:
            result['DataCenter'] = self.data_center
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.operator_id is not None:
            result['OperatorId'] = self.operator_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('DataCenter') is not None:
            self.data_center = m.get('DataCenter')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('OperatorId') is not None:
            self.operator_id = m.get('OperatorId')
        return self


class DeleteLiveMessageGroupResponseBody(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        request_id: str = None,
    ):
        # The ID of the deleted or non-existent group.
        self.group_id = group_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveMessageGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveMessageGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveMessageGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveMessageGroupMessageRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        data_center: str = None,
        deleter_id: str = None,
        deleter_info: str = None,
        group_id: str = None,
        message_id: str = None,
    ):
        # The application ID.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The data center. It must be the same as the data center that was specified when you called the [CreateLiveMessageApp](https://help.aliyun.com/document_detail/2848162.html) operation to create the interactive messaging application. Valid values: cn-shanghai and ap-southeast-1 (Singapore).
        self.data_center = data_center
        # The ID of the user who deletes the message. The ID must be up to 64 bytes in length and can contain letters and digits.
        self.deleter_id = deleter_id
        # The additional information about the user who performs the deletion operation. The value can be up to 512 bytes in length.
        self.deleter_info = deleter_info
        # The group ID.
        # 
        # This parameter is required.
        self.group_id = group_id
        # The ID of the message that you want to delete. Set this parameter to the value of MsgTid that you specified when you called the SendLiveMessageGroup operation. The ID must be up to 64 bytes in length and can contain letters and digits.
        # 
        # This parameter is required.
        self.message_id = message_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.data_center is not None:
            result['DataCenter'] = self.data_center
        if self.deleter_id is not None:
            result['DeleterId'] = self.deleter_id
        if self.deleter_info is not None:
            result['DeleterInfo'] = self.deleter_info
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('DataCenter') is not None:
            self.data_center = m.get('DataCenter')
        if m.get('DeleterId') is not None:
            self.deleter_id = m.get('DeleterId')
        if m.get('DeleterInfo') is not None:
            self.deleter_info = m.get('DeleterInfo')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class DeleteLiveMessageGroupMessageResponseBody(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        message_id: str = None,
        request_id: str = None,
    ):
        # The group ID.
        self.group_id = group_id
        # The ID of the deleted or non-existent message.
        self.message_id = message_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveMessageGroupMessageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveMessageGroupMessageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveMessageGroupMessageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveMessageUserMessageRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        data_center: str = None,
        deleter_id: str = None,
        deleter_info: str = None,
        message_id: str = None,
        receiver_id: str = None,
    ):
        # The application ID.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The data center where the interactive messaging application is deployed. Set this parameter to the value of DataCenter that you specified when you called the [CreateLiveMessageApp](https://help.aliyun.com/document_detail/2593195.html) operation. Valid values: cn-shanghai (Shanghai) and ap-southeast-1 (Singapore).
        self.data_center = data_center
        # The ID of the user who performs the deletion operation. The ID can contain only letters and digits and can be up to 64 bytes in length.
        self.deleter_id = deleter_id
        # The additional information about the user who performs the deletion operation. The value can be up to 512 bytes in length.
        self.deleter_info = deleter_info
        # The ID of the message that you want to delete. Set this parameter to the value of MsgTid that you specified when you called the SendLiveMessageUser operation. The ID can contain only letters and digits and can be up to 64 bytes in length.
        # 
        # This parameter is required.
        self.message_id = message_id
        # The ID of the user who received the message to delete. The ID can contain only letters and digits and can be up to 64 bytes in length.
        # 
        # This parameter is required.
        self.receiver_id = receiver_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.data_center is not None:
            result['DataCenter'] = self.data_center
        if self.deleter_id is not None:
            result['DeleterId'] = self.deleter_id
        if self.deleter_info is not None:
            result['DeleterInfo'] = self.deleter_info
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        if self.receiver_id is not None:
            result['ReceiverId'] = self.receiver_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('DataCenter') is not None:
            self.data_center = m.get('DataCenter')
        if m.get('DeleterId') is not None:
            self.deleter_id = m.get('DeleterId')
        if m.get('DeleterInfo') is not None:
            self.deleter_info = m.get('DeleterInfo')
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        if m.get('ReceiverId') is not None:
            self.receiver_id = m.get('ReceiverId')
        return self


class DeleteLiveMessageUserMessageResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveMessageUserMessageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveMessageUserMessageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveMessageUserMessageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLivePackageConfigRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        owner_id: int = None,
        region_id: str = None,
        stream_name: str = None,
    ):
        # App name, `*` matches all names.
        # 
        # This parameter is required.
        self.app_name = app_name
        # Live streaming domain (primary playback domain).
        # 
        # This parameter is required.
        self.domain_name = domain_name
        self.owner_id = owner_id
        self.region_id = region_id
        # Live stream name, `*` matches all streams under AppName.
        # 
        # This parameter is required.
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DeleteLivePackageConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLivePackageConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLivePackageConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLivePackageConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLivePrivateLineRequest(TeaModel):
    def __init__(
        self,
        acceleration_type: str = None,
        app_name: str = None,
        domain_name: str = None,
        owner_id: int = None,
        region_id: str = None,
        stream_name: str = None,
    ):
        # The acceleration type. Valid values:
        # 
        # *   play: streaming acceleration
        # *   publish: stream ingest acceleration
        # 
        # This parameter is required.
        self.acceleration_type = acceleration_type
        # The name of the application.
        # 
        # This parameter is required.
        self.app_name = app_name
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        self.owner_id = owner_id
        self.region_id = region_id
        # The name of the live stream.
        # 
        # This parameter is required.
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acceleration_type is not None:
            result['AccelerationType'] = self.acceleration_type
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccelerationType') is not None:
            self.acceleration_type = m.get('AccelerationType')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DeleteLivePrivateLineResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLivePrivateLineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLivePrivateLineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLivePrivateLineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLivePullStreamInfoConfigRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        owner_id: int = None,
        region_id: str = None,
        stream_name: str = None,
    ):
        # The name of the application to which the live stream belongs. You can call [DescribeLivePullStreamConfig](https://help.aliyun.com/document_detail/2847818.htmll) operation to query the application name.
        # 
        # This parameter is required.
        self.app_name = app_name
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        self.owner_id = owner_id
        self.region_id = region_id
        # The name of the live stream. You can call [DescribeLivePullStreamConfig](https://help.aliyun.com/document_detail/2847818.htmll) operation to query the stream name.
        # 
        # This parameter is required.
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DeleteLivePullStreamInfoConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLivePullStreamInfoConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLivePullStreamInfoConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLivePullStreamInfoConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLivePullToPushRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        region: str = None,
        region_id: str = None,
        task_id: str = None,
    ):
        self.owner_id = owner_id
        # The region where the task is started. Valid values:
        # 
        # *   ap-southeast-1: Singapore
        # *   ap-southeast-5: Indonesia (Jakarta)
        # *   cn-beijing: China (Beijing)
        # *   cn-shanghai: China (Shanghai)
        # 
        # This parameter is required.
        self.region = region
        self.region_id = region_id
        # The task ID.
        # 
        # This parameter is required.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region is not None:
            result['Region'] = self.region
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DeleteLivePullToPushResponseBody(TeaModel):
    def __init__(
        self,
        description: str = None,
        request_id: str = None,
        ret_code: int = None,
    ):
        # The error description.
        self.description = description
        # The request ID.
        self.request_id = request_id
        # The code that is returned for the request.
        # 
        # > 
        # 
        # *   0 is returned if the request is normal.
        # 
        # *   For information about codes that are returned when exceptions occur, see the following Error codes table.
        self.ret_code = ret_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ret_code is not None:
            result['RetCode'] = self.ret_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RetCode') is not None:
            self.ret_code = m.get('RetCode')
        return self


class DeleteLivePullToPushResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLivePullToPushResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLivePullToPushResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveRealTimeLogLogstoreRequest(TeaModel):
    def __init__(
        self,
        logstore: str = None,
        owner_id: int = None,
        project: str = None,
        region: str = None,
        region_id: str = None,
    ):
        # The name of the Logstore to which log entries are delivered.
        # 
        # This parameter is required.
        self.logstore = logstore
        self.owner_id = owner_id
        # The name of the Log Service project that is used for real-time log delivery.
        # 
        # This parameter is required.
        self.project = project
        # The ID of the region where the Log Service project is deployed.
        # 
        # This parameter is required.
        self.region = region
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.logstore is not None:
            result['Logstore'] = self.logstore
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.project is not None:
            result['Project'] = self.project
        if self.region is not None:
            result['Region'] = self.region
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Logstore') is not None:
            self.logstore = m.get('Logstore')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Project') is not None:
            self.project = m.get('Project')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteLiveRealTimeLogLogstoreResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveRealTimeLogLogstoreResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveRealTimeLogLogstoreResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveRealTimeLogLogstoreResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveRealtimeLogDeliveryRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        logstore: str = None,
        owner_id: int = None,
        project: str = None,
        region: str = None,
        region_id: str = None,
    ):
        # The streaming domain.
        # 
        # Separate multiple streaming domains with commas (,).
        # 
        # This parameter is required.
        self.domain_name = domain_name
        # The name of the Logstore to which log entries are delivered.
        # 
        # This parameter is required.
        self.logstore = logstore
        self.owner_id = owner_id
        # The name of the Log Service project that is used for real-time log delivery.
        # 
        # This parameter is required.
        self.project = project
        # The ID of the region where the Log Service project is deployed.
        # 
        # This parameter is required.
        self.region = region
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.logstore is not None:
            result['Logstore'] = self.logstore
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.project is not None:
            result['Project'] = self.project
        if self.region is not None:
            result['Region'] = self.region
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Logstore') is not None:
            self.logstore = m.get('Logstore')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Project') is not None:
            self.project = m.get('Project')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteLiveRealtimeLogDeliveryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveRealtimeLogDeliveryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveRealtimeLogDeliveryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveRealtimeLogDeliveryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveRecordNotifyConfigRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        owner_id: int = None,
        security_token: str = None,
    ):
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        self.owner_id = owner_id
        self.security_token = security_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DeleteLiveRecordNotifyConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveRecordNotifyConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveRecordNotifyConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveRecordNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveRecordVodConfigRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        owner_id: int = None,
        region_id: str = None,
        stream_name: str = None,
    ):
        # The name of the application to which the live stream belongs. You can view the application name on the [Stream Management](https://help.aliyun.com/document_detail/197397.html) page of the ApsaraVideo Live console.
        # 
        # This parameter is required.
        self.app_name = app_name
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        self.owner_id = owner_id
        self.region_id = region_id
        # The name of the live stream. You can view the stream name on the [Stream Management](https://help.aliyun.com/document_detail/197397.html) page of the ApsaraVideo Live console.
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DeleteLiveRecordVodConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveRecordVodConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveRecordVodConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveRecordVodConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveSnapshotDetectPornConfigRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        owner_id: int = None,
        security_token: str = None,
    ):
        # The name of the application to which the live stream belongs. You can call the [DescribeLiveSnapshotDetectPornConfig](https://help.aliyun.com/document_detail/2847918.html) operation to query the application name.
        # 
        # This parameter is required.
        self.app_name = app_name
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        self.owner_id = owner_id
        self.security_token = security_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DeleteLiveSnapshotDetectPornConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveSnapshotDetectPornConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveSnapshotDetectPornConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveSnapshotDetectPornConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveSnapshotNotifyConfigRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        self.owner_id = owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteLiveSnapshotNotifyConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveSnapshotNotifyConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveSnapshotNotifyConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveSnapshotNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveSpecificStagingConfigRequest(TeaModel):
    def __init__(
        self,
        config_id: str = None,
        domain_name: str = None,
        owner_id: int = None,
        security_token: str = None,
    ):
        # The ID of the configuration that you want to delete. If you want to specify multiple IDs, separate them with commas (,). You can call the [DescribeLiveDomainStagingConfig](https://help.aliyun.com/document_detail/297374.html) operation to obtain the configuration ID.
        # 
        # This parameter is required.
        self.config_id = config_id
        # The accelerated domain name.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        self.owner_id = owner_id
        self.security_token = security_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DeleteLiveSpecificStagingConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveSpecificStagingConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveSpecificStagingConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveSpecificStagingConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveStreamBlockRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        owner_id: int = None,
        region_id: str = None,
        stream_name: str = None,
    ):
        # The name of the application to which the live stream belongs. You can view the application name on the [Stream Management](https://help.aliyun.com/document_detail/197397.html) page of the ApsaraVideo Live console.
        # 
        # This parameter is required.
        self.app_name = app_name
        # The streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        self.owner_id = owner_id
        self.region_id = region_id
        # The name of the live stream. You can view the stream name on the [Stream Management](https://help.aliyun.com/document_detail/197397.html) page of the ApsaraVideo Live console.
        # 
        # This parameter is required.
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DeleteLiveStreamBlockResponseBody(TeaModel):
    def __init__(
        self,
        description: str = None,
        request_id: str = None,
        status: str = None,
    ):
        # The result description. If the request was successful, ok is returned. If the request failed, the failure detail is returned.
        self.description = description
        # The request ID.
        self.request_id = request_id
        # The status. Valid values:
        # 
        # *   ok: The request was successful.
        # *   fail: The request failed.
        # 
        # >  If any parameter failed to be configured, the request failed.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DeleteLiveStreamBlockResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveStreamBlockResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveStreamBlockResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveStreamMergeRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        owner_id: int = None,
        region_id: str = None,
        stream_name: str = None,
    ):
        # The name of the application that generates the output stream. You can view the application name on the [Primary/Secondary Stream Mixing](https://help.aliyun.com/document_detail/606583.html) page of the ApsaraVideo Live console.
        # 
        # This parameter is required.
        self.app_name = app_name
        # The streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        self.owner_id = owner_id
        self.region_id = region_id
        # The name of the output stream. You can view the stream name on the [Primary/Secondary Stream Mixing](https://help.aliyun.com/document_detail/606583.html) page of the ApsaraVideo Live console.
        # 
        # This parameter is required.
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DeleteLiveStreamMergeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveStreamMergeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveStreamMergeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveStreamMergeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveStreamMonitorRequest(TeaModel):
    def __init__(
        self,
        monitor_id: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The ID of the monitoring session.
        # 
        # >  You can obtain the monitoring session ID from the response parameter **MonitorId** of the [CreateLiveStreamMonitor](https://help.aliyun.com/document_detail/2848129.html) operation.
        # 
        # This parameter is required.
        self.monitor_id = monitor_id
        self.owner_id = owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.monitor_id is not None:
            result['MonitorId'] = self.monitor_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MonitorId') is not None:
            self.monitor_id = m.get('MonitorId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteLiveStreamMonitorResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveStreamMonitorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveStreamMonitorResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveStreamMonitorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveStreamRecordIndexFilesRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        owner_id: int = None,
        record_id: List[str] = None,
        region_id: str = None,
        remove_file: str = None,
        stream_name: str = None,
    ):
        # The name of the application to which the live stream belongs.
        # 
        # This parameter is required.
        self.app_name = app_name
        # The name of the main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        self.owner_id = owner_id
        # The index file IDs.
        # 
        # This parameter is required.
        self.record_id = record_id
        self.region_id = region_id
        # Specifies whether to delete the corresponding file in Object Storage Service (OSS) synchronously. Valid values:
        # 
        # *   **true**: The corresponding file in OSS is deleted.
        # *   **false**: The corresponding file in OSS is not deleted.
        # 
        # This parameter is required.
        self.remove_file = remove_file
        # The name of the live stream.
        # 
        # This parameter is required.
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.remove_file is not None:
            result['RemoveFile'] = self.remove_file
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RemoveFile') is not None:
            self.remove_file = m.get('RemoveFile')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DeleteLiveStreamRecordIndexFilesResponseBodyRecordDeleteInfoListRecordDeleteInfo(TeaModel):
    def __init__(
        self,
        message: str = None,
        record_id: str = None,
    ):
        # The processing result of each file indicated by the file ID. Valid values:
        # 
        # *   **OK**: The file has been deleted.
        # *   **AccessDenied**: Access to the file has been denied.
        # *   **FileNotFound**: The file fails to be found.
        self.message = message
        # The ID of the index file that is used to locate the live stream recording files to be deleted.
        self.record_id = record_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        return self


class DeleteLiveStreamRecordIndexFilesResponseBodyRecordDeleteInfoList(TeaModel):
    def __init__(
        self,
        record_delete_info: List[DeleteLiveStreamRecordIndexFilesResponseBodyRecordDeleteInfoListRecordDeleteInfo] = None,
    ):
        self.record_delete_info = record_delete_info

    def validate(self):
        if self.record_delete_info:
            for k in self.record_delete_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RecordDeleteInfo'] = []
        if self.record_delete_info is not None:
            for k in self.record_delete_info:
                result['RecordDeleteInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.record_delete_info = []
        if m.get('RecordDeleteInfo') is not None:
            for k in m.get('RecordDeleteInfo'):
                temp_model = DeleteLiveStreamRecordIndexFilesResponseBodyRecordDeleteInfoListRecordDeleteInfo()
                self.record_delete_info.append(temp_model.from_map(k))
        return self


class DeleteLiveStreamRecordIndexFilesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        record_delete_info_list: DeleteLiveStreamRecordIndexFilesResponseBodyRecordDeleteInfoList = None,
        request_id: str = None,
    ):
        # The status code. A return value of 500 indicates an error. For details, see the Error codes section of this topic.
        self.code = code
        # The status description. A return value of 500 indicates an error. For details, see the Error codes section of this topic.
        self.message = message
        # The deletion information.
        self.record_delete_info_list = record_delete_info_list
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.record_delete_info_list:
            self.record_delete_info_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.record_delete_info_list is not None:
            result['RecordDeleteInfoList'] = self.record_delete_info_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RecordDeleteInfoList') is not None:
            temp_model = DeleteLiveStreamRecordIndexFilesResponseBodyRecordDeleteInfoList()
            self.record_delete_info_list = temp_model.from_map(m['RecordDeleteInfoList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveStreamRecordIndexFilesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveStreamRecordIndexFilesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveStreamRecordIndexFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveStreamTranscodeRequest(TeaModel):
    def __init__(
        self,
        app: str = None,
        domain: str = None,
        owner_id: int = None,
        security_token: str = None,
        template: str = None,
    ):
        # The name of the application to which the live stream belongs.
        # 
        # This parameter is required.
        self.app = app
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain = domain
        self.owner_id = owner_id
        self.security_token = security_token
        # The transcoding template ID. Valid values:
        # 
        # *   Standard transcoding:
        # 
        #     *   lld: low definition
        #     *   lsd: standard definition
        #     *   lhd: high definition
        #     *   lud : ultra-high definition
        # 
        # *   Narrowband HD™ transcoding:
        # 
        #     *   ld: low definition
        #     *   sd: standard definition
        #     *   hd: high definition
        #     *   ud: ultra-high definition
        # 
        # *   Custom transcoding: a custom ID
        # 
        # This parameter is required.
        self.template = template

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app is not None:
            result['App'] = self.app
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.template is not None:
            result['Template'] = self.template
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('Template') is not None:
            self.template = m.get('Template')
        return self


class DeleteLiveStreamTranscodeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveStreamTranscodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveStreamTranscodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveStreamTranscodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveStreamWatermarkRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        region_id: str = None,
        template_id: str = None,
    ):
        self.owner_id = owner_id
        self.region_id = region_id
        # The ID of the watermark template.
        # 
        # >  You can obtain the template ID by checking the value of the TemplateId parameter that is returned by the [AddLiveStreamWatermark](https://help.aliyun.com/document_detail/410759.html) operation.
        # 
        # This parameter is required.
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteLiveStreamWatermarkResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveStreamWatermarkResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveStreamWatermarkResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveStreamWatermarkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveStreamWatermarkRuleRequest(TeaModel):
    def __init__(
        self,
        app: str = None,
        domain: str = None,
        owner_id: int = None,
        region_id: str = None,
        rule_id: str = None,
        stream: str = None,
    ):
        # The name of the application to which the live stream belongs.
        self.app = app
        # The streaming domain.
        # 
        # This parameter is required.
        self.domain = domain
        self.owner_id = owner_id
        self.region_id = region_id
        # The ID of the watermark rule.
        # 
        # >  You can obtain the rule ID by checking the value of the RuleId parameter that is returned by the [AddLiveStreamWatermarkRule](https://help.aliyun.com/document_detail/2848100.html) operation.
        self.rule_id = rule_id
        # The name of the stream. The following matching rules apply:
        # 
        # *   A stream name can be exactly matched, Example: liveStreamA.
        # *   Fuzzy match is also supported. The use of an asterisk (`*`) allows all approximate matches to be found.
        # *   You can place the asterisk before or after an approximate string.
        # 
        # > 
        # 
        # *   Fuzzy match: Only one asterisk (`*`) before or after an approximate string is allowed. The approximate string must be enclosed in `()`. Separate multiple strings with vertical bars (`|`).
        # 
        # *   For example, `*(t1|t2)` matches all streams whose name has the `t1` or `t2` suffix, and `(abc|123)*` matches all streams whose name has the `abc` or `123` prefix.
        self.stream = stream

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app is not None:
            result['App'] = self.app
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.stream is not None:
            result['Stream'] = self.stream
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Stream') is not None:
            self.stream = m.get('Stream')
        return self


class DeleteLiveStreamWatermarkRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveStreamWatermarkRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveStreamWatermarkRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveStreamWatermarkRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveStreamsNotifyUrlConfigRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The ingest domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        self.owner_id = owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteLiveStreamsNotifyUrlConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveStreamsNotifyUrlConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveStreamsNotifyUrlConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveStreamsNotifyUrlConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMessageAppRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
    ):
        # The ID of the interactive messaging application that you want to delete. You can specify only one ID.
        # 
        # This parameter is required.
        self.app_id = app_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        return self


class DeleteMessageAppResponseBodyResult(TeaModel):
    def __init__(
        self,
        success: bool = None,
    ):
        # Indicates whether the application was deleted. Valid values:
        # 
        # *   true: The application was deleted.
        # *   false: The application failed to be deleted.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMessageAppResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        result: DeleteMessageAppResponseBodyResult = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The returned result.
        self.result = result

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            temp_model = DeleteMessageAppResponseBodyResult()
            self.result = temp_model.from_map(m['Result'])
        return self


class DeleteMessageAppResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMessageAppResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMessageAppResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMixStreamRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        mix_stream_id: str = None,
        owner_id: int = None,
        region_id: str = None,
        stream_name: str = None,
    ):
        # The name of the application.
        self.app_name = app_name
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        # The ID of the stream mixing task. If the task was created by calling the [CreateMixStream](https://help.aliyun.com/document_detail/2848087.html) operation, check the value of the response parameter MixStreamId to obtain the ID.
        # 
        # This parameter is required.
        self.mix_stream_id = mix_stream_id
        self.owner_id = owner_id
        self.region_id = region_id
        # The name of the output stream.
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.mix_stream_id is not None:
            result['MixStreamId'] = self.mix_stream_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('MixStreamId') is not None:
            self.mix_stream_id = m.get('MixStreamId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DeleteMixStreamResponseBody(TeaModel):
    def __init__(
        self,
        mix_stream_id: str = None,
        request_id: str = None,
    ):
        # The ID of the stream mixing task.
        self.mix_stream_id = mix_stream_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mix_stream_id is not None:
            result['MixStreamId'] = self.mix_stream_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MixStreamId') is not None:
            self.mix_stream_id = m.get('MixStreamId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteMixStreamResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMixStreamResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMixStreamResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePlaylistRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        program_id: str = None,
        region_id: str = None,
    ):
        self.owner_id = owner_id
        # The ID of the episode list. If the episode list was created by calling the [AddPlaylistItems](https://help.aliyun.com/document_detail/2848078.html) operation, check the value of the response parameter ProgramId to obtain the ID.
        # 
        # This parameter is required.
        self.program_id = program_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.program_id is not None:
            result['ProgramId'] = self.program_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProgramId') is not None:
            self.program_id = m.get('ProgramId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeletePlaylistResponseBody(TeaModel):
    def __init__(
        self,
        program_id: str = None,
        request_id: str = None,
    ):
        # The ID of the episode list. You can use the ID as a request parameter in the API operation that is used to query the information about the episode list, start the episode list, or stop the episode list.
        self.program_id = program_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.program_id is not None:
            result['ProgramId'] = self.program_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProgramId') is not None:
            self.program_id = m.get('ProgramId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePlaylistResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeletePlaylistResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePlaylistResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePlaylistItemsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        program_id: str = None,
        program_item_ids: str = None,
        region_id: str = None,
    ):
        self.owner_id = owner_id
        # The ID of the episode list. If the episode list was created by calling the [AddPlaylistItems](https://help.aliyun.com/document_detail/2848078.html) operation, check the value of the response parameter ProgramId to obtain the ID.
        # 
        # This parameter is required.
        self.program_id = program_id
        # The IDs of the episodes that you want to remove.
        # 
        # This parameter is required.
        self.program_item_ids = program_item_ids
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.program_id is not None:
            result['ProgramId'] = self.program_id
        if self.program_item_ids is not None:
            result['ProgramItemIds'] = self.program_item_ids
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProgramId') is not None:
            self.program_id = m.get('ProgramId')
        if m.get('ProgramItemIds') is not None:
            self.program_item_ids = m.get('ProgramItemIds')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeletePlaylistItemsResponseBody(TeaModel):
    def __init__(
        self,
        program_id: str = None,
        request_id: str = None,
    ):
        # The ID of the episode list. You can use the ID as a request parameter in the API operation that is used to query the episodes in the episode list, edit the episode list, delete the episode list, query the information about the episode list, or stop the episode list.
        self.program_id = program_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.program_id is not None:
            result['ProgramId'] = self.program_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProgramId') is not None:
            self.program_id = m.get('ProgramId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePlaylistItemsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeletePlaylistItemsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePlaylistItemsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRtcAsrTaskRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        region_id: str = None,
        task_id: str = None,
    ):
        self.owner_id = owner_id
        self.region_id = region_id
        # The task ID. You can obtain the ID from the response to the [CreateRtcAsrTask](https://help.aliyun.com/document_detail/2848217.html) operation.
        # 
        # This parameter is required.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DeleteRtcAsrTaskResponseBody(TeaModel):
    def __init__(
        self,
        description: str = None,
        request_id: str = None,
        ret_code: int = None,
    ):
        # The result of the request. If success is returned, the request is successful. If an error message is returned, the request failed.
        self.description = description
        # The ID of the request.
        self.request_id = request_id
        # The returned HTTP status code. HTTP status code 2000 indicates that the request is successful. If another HTTP status code is returned, the request failed.
        self.ret_code = ret_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ret_code is not None:
            result['RetCode'] = self.ret_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RetCode') is not None:
            self.ret_code = m.get('RetCode')
        return self


class DeleteRtcAsrTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteRtcAsrTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRtcAsrTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRtcMPUEventSubRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
    ):
        # The ID of the application.
        # 
        # >  The ID can be up to 64 characters in length and can contain letters, digits, underscores (_), and hyphens (-).
        # 
        # This parameter is required.
        self.app_id = app_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        return self


class DeleteRtcMPUEventSubResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteRtcMPUEventSubResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteRtcMPUEventSubResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRtcMPUEventSubResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSnapshotCallbackAuthRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        self.owner_id = owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteSnapshotCallbackAuthResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSnapshotCallbackAuthResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSnapshotCallbackAuthResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSnapshotCallbackAuthResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSnapshotFilesRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        create_timestamp_list: List[int] = None,
        domain_name: str = None,
        owner_id: int = None,
        region_id: str = None,
        remove_file: bool = None,
        stream_name: str = None,
    ):
        # The name of the application to which the live stream belongs.
        # 
        # This parameter is required.
        self.app_name = app_name
        # The timestamps when the snapshots that you want to delete were captured.
        # 
        # This parameter is required.
        self.create_timestamp_list = create_timestamp_list
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        self.owner_id = owner_id
        self.region_id = region_id
        # Specifies whether to also delete the corresponding file in Object Storage Service (OSS) at the same time. Value values:
        # 
        # *   **true**: deletes the corresponding file in OSS.
        # *   **false**: does not delete the corresponding file in OSS.
        # 
        # >  To delete the corresponding file in OSS, you must have the permissions on the OSS bucket.
        # 
        # This parameter is required.
        self.remove_file = remove_file
        # The name of the live stream.
        # 
        # This parameter is required.
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.create_timestamp_list is not None:
            result['CreateTimestampList'] = self.create_timestamp_list
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.remove_file is not None:
            result['RemoveFile'] = self.remove_file
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('CreateTimestampList') is not None:
            self.create_timestamp_list = m.get('CreateTimestampList')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RemoveFile') is not None:
            self.remove_file = m.get('RemoveFile')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DeleteSnapshotFilesResponseBodySnapshotDeleteInfoListSnapshotDeleteInfo(TeaModel):
    def __init__(
        self,
        create_timestamp: int = None,
        message: str = None,
    ):
        # The timestamp when the snapshot was captured. Unit: milliseconds.
        self.create_timestamp = create_timestamp
        # The processing result of the snapshot. Valid values:
        # 
        # *   **OK**: The snapshot was deleted.
        # *   **FileNotFound**: The snapshot was not found.
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class DeleteSnapshotFilesResponseBodySnapshotDeleteInfoList(TeaModel):
    def __init__(
        self,
        snapshot_delete_info: List[DeleteSnapshotFilesResponseBodySnapshotDeleteInfoListSnapshotDeleteInfo] = None,
    ):
        self.snapshot_delete_info = snapshot_delete_info

    def validate(self):
        if self.snapshot_delete_info:
            for k in self.snapshot_delete_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SnapshotDeleteInfo'] = []
        if self.snapshot_delete_info is not None:
            for k in self.snapshot_delete_info:
                result['SnapshotDeleteInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.snapshot_delete_info = []
        if m.get('SnapshotDeleteInfo') is not None:
            for k in m.get('SnapshotDeleteInfo'):
                temp_model = DeleteSnapshotFilesResponseBodySnapshotDeleteInfoListSnapshotDeleteInfo()
                self.snapshot_delete_info.append(temp_model.from_map(k))
        return self


class DeleteSnapshotFilesResponseBody(TeaModel):
    def __init__(
        self,
        failure_count: int = None,
        request_id: str = None,
        snapshot_delete_info_list: DeleteSnapshotFilesResponseBodySnapshotDeleteInfoList = None,
        success_count: int = None,
    ):
        # The number of snapshots that failed to be deleted.
        self.failure_count = failure_count
        # The request ID.
        self.request_id = request_id
        # The information about the snapshots.
        self.snapshot_delete_info_list = snapshot_delete_info_list
        # The number of successful screenshot deletions.
        self.success_count = success_count

    def validate(self):
        if self.snapshot_delete_info_list:
            self.snapshot_delete_info_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failure_count is not None:
            result['FailureCount'] = self.failure_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.snapshot_delete_info_list is not None:
            result['SnapshotDeleteInfoList'] = self.snapshot_delete_info_list.to_map()
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailureCount') is not None:
            self.failure_count = m.get('FailureCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SnapshotDeleteInfoList') is not None:
            temp_model = DeleteSnapshotFilesResponseBodySnapshotDeleteInfoList()
            self.snapshot_delete_info_list = temp_model.from_map(m['SnapshotDeleteInfoList'])
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        return self


class DeleteSnapshotFilesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSnapshotFilesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSnapshotFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteStudioLayoutRequest(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        layout_id: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The ID of the production studio.
        # 
        # *   If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation, check the value of the response parameter CasterId to obtain the ID.
        # *   If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        # 
        # >  You can find the ID of the production studio in the Instance ID/Name column.
        # 
        # This parameter is required.
        self.caster_id = caster_id
        # The ID of the layout. If the layout was added by calling the [AddStudioLayout](https://help.aliyun.com/document_detail/2848062.html) operation, check the value of the response parameter LayoutId to obtain the ID.
        # 
        # This parameter is required.
        self.layout_id = layout_id
        self.owner_id = owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteStudioLayoutResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteStudioLayoutResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteStudioLayoutResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteStudioLayoutResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAutoShowListTasksRequest(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The ID of the production studio for which you want to query scheduled tasks.
        # 
        # >  If the scheduled tasks were created by calling the [InitializeAutoShowListTask](https://help.aliyun.com/document_detail/2848056.html) operation, check the value of the response parameter CasterId to obtain the ID. If you do not specify this parameter, the system queries all the scheduled tasks that belong to the user specified by the OwnerId parameter.
        self.caster_id = caster_id
        self.owner_id = owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeAutoShowListTasksResponseBody(TeaModel):
    def __init__(
        self,
        auto_show_list_tasks: str = None,
        request_id: str = None,
    ):
        # The information about the scheduled tasks. The following fields are included:
        # 
        # *   Status: the status of the scheduled task. Valid values: 0 and 1. A value of 0 indicates that the scheduled task is paused. A value of 1 indicates that the scheduled task is started.
        # *   LiveTemplate: the transcoding templates.
        # *   TranscodeConfig: the transcoding configuration for the source URL.
        # *   CasterId: the ID of the production studio.
        self.auto_show_list_tasks = auto_show_list_tasks
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_show_list_tasks is not None:
            result['AutoShowListTasks'] = self.auto_show_list_tasks
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoShowListTasks') is not None:
            self.auto_show_list_tasks = m.get('AutoShowListTasks')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAutoShowListTasksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAutoShowListTasksResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAutoShowListTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterChannelsRequest(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The ID of the production studio.
        # 
        # *   If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation, check the value of the response parameter CasterId to obtain the ID.
        # *   If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        # 
        # >  You can find the ID of the production studio in the Instance ID/Name column.
        # 
        # This parameter is required.
        self.caster_id = caster_id
        self.owner_id = owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeCasterChannelsResponseBodyChannelsChannel(TeaModel):
    def __init__(
        self,
        channel_id: str = None,
        face_beauty: str = None,
        resource_id: str = None,
        rtmp_url: str = None,
        stream_url: str = None,
    ):
        # The ID of the channel.
        # 
        # The layout references the channel ID when the channel is enabled. You can specify up to one video resource for the channel. The value of this parameter must be in the RV[Number] format, such as RV01 and RV12.
        self.channel_id = channel_id
        # The face retouching effect. Valid values: 0 (all effects), 1 (skin smoothing), 2 (skin whitening), 3 (dark circles removal), and 4 (nasolabial folds removal).
        self.face_beauty = face_beauty
        # The ID of the video resource.
        self.resource_id = resource_id
        # The URL in the Real-Time Messaging Protocol (RTMP) format.
        self.rtmp_url = rtmp_url
        # The URL of the output content in the channel.
        self.stream_url = stream_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.face_beauty is not None:
            result['FaceBeauty'] = self.face_beauty
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.rtmp_url is not None:
            result['RtmpUrl'] = self.rtmp_url
        if self.stream_url is not None:
            result['StreamUrl'] = self.stream_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('FaceBeauty') is not None:
            self.face_beauty = m.get('FaceBeauty')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('RtmpUrl') is not None:
            self.rtmp_url = m.get('RtmpUrl')
        if m.get('StreamUrl') is not None:
            self.stream_url = m.get('StreamUrl')
        return self


class DescribeCasterChannelsResponseBodyChannels(TeaModel):
    def __init__(
        self,
        channel: List[DescribeCasterChannelsResponseBodyChannelsChannel] = None,
    ):
        self.channel = channel

    def validate(self):
        if self.channel:
            for k in self.channel:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Channel'] = []
        if self.channel is not None:
            for k in self.channel:
                result['Channel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.channel = []
        if m.get('Channel') is not None:
            for k in m.get('Channel'):
                temp_model = DescribeCasterChannelsResponseBodyChannelsChannel()
                self.channel.append(temp_model.from_map(k))
        return self


class DescribeCasterChannelsResponseBody(TeaModel):
    def __init__(
        self,
        channels: DescribeCasterChannelsResponseBodyChannels = None,
        request_id: str = None,
        total: int = None,
    ):
        # The channels.
        self.channels = channels
        # The request ID.
        self.request_id = request_id
        # The total number of channels.
        self.total = total

    def validate(self):
        if self.channels:
            self.channels.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channels is not None:
            result['Channels'] = self.channels.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Channels') is not None:
            temp_model = DescribeCasterChannelsResponseBodyChannels()
            self.channels = temp_model.from_map(m['Channels'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeCasterChannelsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCasterChannelsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCasterChannelsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterComponentsRequest(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        component_id: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The ID of the production studio.
        # 
        # *   If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation, check the value of the response parameter CasterId to obtain the ID.
        # *   If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        # 
        # >  You can find the ID of the production studio in the Instance ID/Name column.
        # 
        # This parameter is required.
        self.caster_id = caster_id
        # The component ID. If the component was added by calling the [AddCasterComponent](https://help.aliyun.com/document_detail/2848030.html) operation, check the value of the response parameter ComponentId to obtain the ID.
        self.component_id = component_id
        self.owner_id = owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeCasterComponentsResponseBodyComponentsComponentCaptionLayerContent(TeaModel):
    def __init__(
        self,
        border_color: str = None,
        border_width_normalized: float = None,
        color: str = None,
        font_name: str = None,
        line_space_normalized: float = None,
        location_id: str = None,
        pts_offset: int = None,
        show_source_lan: bool = None,
        size_normalized: float = None,
        source_lan: str = None,
        target_lan: str = None,
        word_count_per_line: int = None,
        word_space_normalized: float = None,
        words_count: int = None,
    ):
        # The color of the text border.
        # 
        # Valid values: **0x000000 to 0xffffff**. If the value of this parameter is "", this parameter does not take effect.
        self.border_color = border_color
        # The normalized value of the width of the text border. The value of this parameter equals the border width divided by the font size.
        # 
        # The maximum width of the text border is **16**, even if the border width calculated based on this parameter is greater than **16**.
        self.border_width_normalized = border_width_normalized
        # The color of the text. Valid values: **0x000000 to 0xffffff**.
        self.color = color
        # The font of the text, which is specified by the system. Valid values:
        # 
        # *   **KaiTi**\
        # *   **AlibabaPuHuiTi-Regular**\
        # *   **AlibabaPuHuiTi-Bold**\
        # *   **NAlibabaPuHuiTi-Light**\
        # *   **NotoSansHans-Regular**\
        # *   **NotoSansHans-Bold**\
        # *   **NotoSansHans-Light**\
        # 
        # ****\
        self.font_name = font_name
        # The line spacing, which indicates the interval between every two lines.
        self.line_space_normalized = line_space_normalized
        # The location ID of the component. If the value of the ComponentType parameter is caption, the LocationId parameter indicates the channel ID of the video source that is referenced by the component.
        self.location_id = location_id
        # The offset between the presentation timestamps (PTS) of the subtitles and the audio.
        # 
        # Valid values: **-10000 to 10000**. Default value: **0**.
        self.pts_offset = pts_offset
        # Indicates whether the source language of the subtitles is displayed. Valid values:
        # 
        # *   **true**: The source language is displayed.
        # *   **false**: The source language is not displayed.
        self.show_source_lan = show_source_lan
        # The normalized value of the font size of the subtitles. The value of this parameter equals the font size divided by the output height.``
        # 
        # The maximum font size of the subtitles is **1,024**, even if the font size calculated based on this parameter is greater than **1,024**. If the value of this parameter is **-1**, this parameter does not take effect.
        self.size_normalized = size_normalized
        # The source language of the audio in the video source. Valid values:
        # 
        # *   **en**: English
        # *   **cn**: Chinese
        # *   **es**: Spanish
        # *   **ru**: Russian
        self.source_lan = source_lan
        # The target language of the audio in the video source. Valid values:
        # 
        # *   **en**: English
        # *   **cn**: Chinese
        # *   **es**: Spanish
        # *   **ru**: Russian
        self.target_lan = target_lan
        # The maximum number of words displayed in each line.
        self.word_count_per_line = word_count_per_line
        # The word spacing, which indicates the interval between every two words.
        self.word_space_normalized = word_space_normalized
        # The number of words displayed on the component. The value of this parameter can be specified based on the font size.
        # 
        # Valid values: **10 to 50**.
        self.words_count = words_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.border_color is not None:
            result['BorderColor'] = self.border_color
        if self.border_width_normalized is not None:
            result['BorderWidthNormalized'] = self.border_width_normalized
        if self.color is not None:
            result['Color'] = self.color
        if self.font_name is not None:
            result['FontName'] = self.font_name
        if self.line_space_normalized is not None:
            result['LineSpaceNormalized'] = self.line_space_normalized
        if self.location_id is not None:
            result['LocationId'] = self.location_id
        if self.pts_offset is not None:
            result['PtsOffset'] = self.pts_offset
        if self.show_source_lan is not None:
            result['ShowSourceLan'] = self.show_source_lan
        if self.size_normalized is not None:
            result['SizeNormalized'] = self.size_normalized
        if self.source_lan is not None:
            result['SourceLan'] = self.source_lan
        if self.target_lan is not None:
            result['TargetLan'] = self.target_lan
        if self.word_count_per_line is not None:
            result['WordCountPerLine'] = self.word_count_per_line
        if self.word_space_normalized is not None:
            result['WordSpaceNormalized'] = self.word_space_normalized
        if self.words_count is not None:
            result['WordsCount'] = self.words_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BorderColor') is not None:
            self.border_color = m.get('BorderColor')
        if m.get('BorderWidthNormalized') is not None:
            self.border_width_normalized = m.get('BorderWidthNormalized')
        if m.get('Color') is not None:
            self.color = m.get('Color')
        if m.get('FontName') is not None:
            self.font_name = m.get('FontName')
        if m.get('LineSpaceNormalized') is not None:
            self.line_space_normalized = m.get('LineSpaceNormalized')
        if m.get('LocationId') is not None:
            self.location_id = m.get('LocationId')
        if m.get('PtsOffset') is not None:
            self.pts_offset = m.get('PtsOffset')
        if m.get('ShowSourceLan') is not None:
            self.show_source_lan = m.get('ShowSourceLan')
        if m.get('SizeNormalized') is not None:
            self.size_normalized = m.get('SizeNormalized')
        if m.get('SourceLan') is not None:
            self.source_lan = m.get('SourceLan')
        if m.get('TargetLan') is not None:
            self.target_lan = m.get('TargetLan')
        if m.get('WordCountPerLine') is not None:
            self.word_count_per_line = m.get('WordCountPerLine')
        if m.get('WordSpaceNormalized') is not None:
            self.word_space_normalized = m.get('WordSpaceNormalized')
        if m.get('WordsCount') is not None:
            self.words_count = m.get('WordsCount')
        return self


class DescribeCasterComponentsResponseBodyComponentsComponentComponentLayerPositionNormalizeds(TeaModel):
    def __init__(
        self,
        position: List[float] = None,
    ):
        self.position = position

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.position is not None:
            result['Position'] = self.position
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Position') is not None:
            self.position = m.get('Position')
        return self


class DescribeCasterComponentsResponseBodyComponentsComponentComponentLayer(TeaModel):
    def __init__(
        self,
        height_normalized: float = None,
        position_normalizeds: DescribeCasterComponentsResponseBodyComponentsComponentComponentLayerPositionNormalizeds = None,
        position_refer: str = None,
        transparency: int = None,
        width_normalized: float = None,
    ):
        # The normalized value for heights of the elements in the layer. The widths of the elements are proportionally scaled based on this parameter.
        # 
        # If the value of this parameter is **0**, the elements in the layer are not scaled.
        self.height_normalized = height_normalized
        # The normalized value of the position of the layer, in the format of `[x,y]`. Example: `[0,0]`.
        # 
        # >  The values of x and y need to be normalized.
        self.position_normalizeds = position_normalizeds
        # The reference coordinates of the layer. Valid values:
        # 
        # *   **topLeft**: the upper-left corner
        # *   **topRight**: the upper-right corner
        # *   **bottomLeft**: the lower-left corner
        # *   **bottomRight**: the lower-right corner
        self.position_refer = position_refer
        # The transparency of the layer. Valid values: 0 to 255.
        # 
        # A value of **0** indicates that the layer is completely transparent. A value of **255** indicates that the layer is completely opaque.
        self.transparency = transparency
        # The normalized value for widths of the elements in the layer. The heights of the elements are proportionally scaled based on this parameter. If the value of this parameter is **0**, the elements in the layer are not scaled.
        # 
        # >  This parameter conflicts with the HeightNormalized parameter. If both of them are specified, only the HeightNormalized parameter takes effect. If only one of them is specified, the latest specified value is used.
        self.width_normalized = width_normalized

    def validate(self):
        if self.position_normalizeds:
            self.position_normalizeds.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.height_normalized is not None:
            result['HeightNormalized'] = self.height_normalized
        if self.position_normalizeds is not None:
            result['PositionNormalizeds'] = self.position_normalizeds.to_map()
        if self.position_refer is not None:
            result['PositionRefer'] = self.position_refer
        if self.transparency is not None:
            result['Transparency'] = self.transparency
        if self.width_normalized is not None:
            result['WidthNormalized'] = self.width_normalized
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HeightNormalized') is not None:
            self.height_normalized = m.get('HeightNormalized')
        if m.get('PositionNormalizeds') is not None:
            temp_model = DescribeCasterComponentsResponseBodyComponentsComponentComponentLayerPositionNormalizeds()
            self.position_normalizeds = temp_model.from_map(m['PositionNormalizeds'])
        if m.get('PositionRefer') is not None:
            self.position_refer = m.get('PositionRefer')
        if m.get('Transparency') is not None:
            self.transparency = m.get('Transparency')
        if m.get('WidthNormalized') is not None:
            self.width_normalized = m.get('WidthNormalized')
        return self


class DescribeCasterComponentsResponseBodyComponentsComponentImageLayerContent(TeaModel):
    def __init__(
        self,
        material_id: str = None,
    ):
        # The ID of the material from the media library.
        self.material_id = material_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.material_id is not None:
            result['MaterialId'] = self.material_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaterialId') is not None:
            self.material_id = m.get('MaterialId')
        return self


class DescribeCasterComponentsResponseBodyComponentsComponentTextLayerContent(TeaModel):
    def __init__(
        self,
        border_color: str = None,
        border_width_normalized: float = None,
        color: str = None,
        font_name: str = None,
        size_normalized: float = None,
        text: str = None,
    ):
        # The color of the text border. Valid values: **0x000000 to 0xffffff**. If the value of this parameter is **""**, this parameter does not take effect.
        self.border_color = border_color
        # The normalized value of the width of the text border. The value of this parameter equals the border width divided by the font size.****\
        # 
        # The maximum width of the text border is **16**, even if the border width calculated based on this parameter is greater than **16**.
        self.border_width_normalized = border_width_normalized
        # The color of the text. Valid values: **0x000000 to 0xffffff**.
        self.color = color
        # The font of the text, which is specified by the system. Valid values:
        # 
        # *   **KaiTi**\
        # *   **AlibabaPuHuiTi-Regular**\
        # *   **AlibabaPuHuiTi-Bold**\
        # *   **NAlibabaPuHuiTi-Light**\
        # *   **NotoSansHans-Regular**\
        # *   **NotoSansHans-Bold**\
        # *   **NotoSansHans-Light**\
        # 
        # ****\
        self.font_name = font_name
        # The normalized value of the font size of the text.
        # 
        # The value of this parameter equals the font size divided by the output height.**** The maximum font size of the text is **1,024**, even if the font size calculated based on this parameter is greater than **1,024**. If the value of this parameter is **-1**, this parameter does not take effect.
        self.size_normalized = size_normalized
        # The content of the text.
        self.text = text

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.border_color is not None:
            result['BorderColor'] = self.border_color
        if self.border_width_normalized is not None:
            result['BorderWidthNormalized'] = self.border_width_normalized
        if self.color is not None:
            result['Color'] = self.color
        if self.font_name is not None:
            result['FontName'] = self.font_name
        if self.size_normalized is not None:
            result['SizeNormalized'] = self.size_normalized
        if self.text is not None:
            result['Text'] = self.text
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BorderColor') is not None:
            self.border_color = m.get('BorderColor')
        if m.get('BorderWidthNormalized') is not None:
            self.border_width_normalized = m.get('BorderWidthNormalized')
        if m.get('Color') is not None:
            self.color = m.get('Color')
        if m.get('FontName') is not None:
            self.font_name = m.get('FontName')
        if m.get('SizeNormalized') is not None:
            self.size_normalized = m.get('SizeNormalized')
        if m.get('Text') is not None:
            self.text = m.get('Text')
        return self


class DescribeCasterComponentsResponseBodyComponentsComponent(TeaModel):
    def __init__(
        self,
        caption_layer_content: DescribeCasterComponentsResponseBodyComponentsComponentCaptionLayerContent = None,
        component_id: str = None,
        component_layer: DescribeCasterComponentsResponseBodyComponentsComponentComponentLayer = None,
        component_name: str = None,
        component_type: str = None,
        effect: str = None,
        image_layer_content: DescribeCasterComponentsResponseBodyComponentsComponentImageLayerContent = None,
        location_id: str = None,
        text_layer_content: DescribeCasterComponentsResponseBodyComponentsComponentTextLayerContent = None,
    ):
        # The information about the subtitle component.
        self.caption_layer_content = caption_layer_content
        # The component ID.
        self.component_id = component_id
        # The information about the component layer, such as the size and layout.
        self.component_layer = component_layer
        # The name of the component. By default, the name is the ID of the component.
        self.component_name = component_name
        # The type of the component. Valid values:
        # 
        # *   **text**: a text component
        # *   **image**: an image component
        # *   **caption**: a caption component
        self.component_type = component_type
        # The display effect for the component. Valid values:
        # 
        # *   **none**\
        # *   **animateH**: horizontal scrolling
        # *   **animateV**: vertical scrolling
        self.effect = effect
        # The information about the image component. This parameter is returned only for image components.
        self.image_layer_content = image_layer_content
        # The location ID of the component.
        # 
        # Each location ID can be assigned to only one component and must be in the RC[Number] format. The values of this parameter are in ascending order, for example, from RC01 to RC12.
        self.location_id = location_id
        # The information about the text component. This parameter is returned only for text components.
        self.text_layer_content = text_layer_content

    def validate(self):
        if self.caption_layer_content:
            self.caption_layer_content.validate()
        if self.component_layer:
            self.component_layer.validate()
        if self.image_layer_content:
            self.image_layer_content.validate()
        if self.text_layer_content:
            self.text_layer_content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caption_layer_content is not None:
            result['CaptionLayerContent'] = self.caption_layer_content.to_map()
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        if self.component_layer is not None:
            result['ComponentLayer'] = self.component_layer.to_map()
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.component_type is not None:
            result['ComponentType'] = self.component_type
        if self.effect is not None:
            result['Effect'] = self.effect
        if self.image_layer_content is not None:
            result['ImageLayerContent'] = self.image_layer_content.to_map()
        if self.location_id is not None:
            result['LocationId'] = self.location_id
        if self.text_layer_content is not None:
            result['TextLayerContent'] = self.text_layer_content.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CaptionLayerContent') is not None:
            temp_model = DescribeCasterComponentsResponseBodyComponentsComponentCaptionLayerContent()
            self.caption_layer_content = temp_model.from_map(m['CaptionLayerContent'])
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        if m.get('ComponentLayer') is not None:
            temp_model = DescribeCasterComponentsResponseBodyComponentsComponentComponentLayer()
            self.component_layer = temp_model.from_map(m['ComponentLayer'])
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('ComponentType') is not None:
            self.component_type = m.get('ComponentType')
        if m.get('Effect') is not None:
            self.effect = m.get('Effect')
        if m.get('ImageLayerContent') is not None:
            temp_model = DescribeCasterComponentsResponseBodyComponentsComponentImageLayerContent()
            self.image_layer_content = temp_model.from_map(m['ImageLayerContent'])
        if m.get('LocationId') is not None:
            self.location_id = m.get('LocationId')
        if m.get('TextLayerContent') is not None:
            temp_model = DescribeCasterComponentsResponseBodyComponentsComponentTextLayerContent()
            self.text_layer_content = temp_model.from_map(m['TextLayerContent'])
        return self


class DescribeCasterComponentsResponseBodyComponents(TeaModel):
    def __init__(
        self,
        component: List[DescribeCasterComponentsResponseBodyComponentsComponent] = None,
    ):
        self.component = component

    def validate(self):
        if self.component:
            for k in self.component:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Component'] = []
        if self.component is not None:
            for k in self.component:
                result['Component'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.component = []
        if m.get('Component') is not None:
            for k in m.get('Component'):
                temp_model = DescribeCasterComponentsResponseBodyComponentsComponent()
                self.component.append(temp_model.from_map(k))
        return self


class DescribeCasterComponentsResponseBody(TeaModel):
    def __init__(
        self,
        components: DescribeCasterComponentsResponseBodyComponents = None,
        request_id: str = None,
        total: int = None,
    ):
        # The components.
        self.components = components
        # The request ID.
        self.request_id = request_id
        # The total number of entries.
        self.total = total

    def validate(self):
        if self.components:
            self.components.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.components is not None:
            result['Components'] = self.components.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Components') is not None:
            temp_model = DescribeCasterComponentsResponseBodyComponents()
            self.components = temp_model.from_map(m['Components'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeCasterComponentsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCasterComponentsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCasterComponentsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterConfigRequest(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The ID of the production studio.
        # 
        # *   If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation, check the value of the response parameter CasterId to obtain the ID.
        # *   If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        # 
        # >  You can find the ID of the production studio in the Instance ID/Name column.
        # 
        # This parameter is required.
        self.caster_id = caster_id
        self.owner_id = owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeCasterConfigResponseBodyRecordConfigRecordFormatRecordFormat(TeaModel):
    def __init__(
        self,
        cycle_duration: int = None,
        format: str = None,
        oss_object_prefix: str = None,
        slice_oss_object_prefix: str = None,
    ):
        # The length of the recording.
        self.cycle_duration = cycle_duration
        # The format of the recording.
        self.format = format
        # The name of the recording.
        self.oss_object_prefix = oss_object_prefix
        # The name of the segment.
        self.slice_oss_object_prefix = slice_oss_object_prefix

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cycle_duration is not None:
            result['CycleDuration'] = self.cycle_duration
        if self.format is not None:
            result['Format'] = self.format
        if self.oss_object_prefix is not None:
            result['OssObjectPrefix'] = self.oss_object_prefix
        if self.slice_oss_object_prefix is not None:
            result['SliceOssObjectPrefix'] = self.slice_oss_object_prefix
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CycleDuration') is not None:
            self.cycle_duration = m.get('CycleDuration')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('OssObjectPrefix') is not None:
            self.oss_object_prefix = m.get('OssObjectPrefix')
        if m.get('SliceOssObjectPrefix') is not None:
            self.slice_oss_object_prefix = m.get('SliceOssObjectPrefix')
        return self


class DescribeCasterConfigResponseBodyRecordConfigRecordFormat(TeaModel):
    def __init__(
        self,
        record_format: List[DescribeCasterConfigResponseBodyRecordConfigRecordFormatRecordFormat] = None,
    ):
        self.record_format = record_format

    def validate(self):
        if self.record_format:
            for k in self.record_format:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RecordFormat'] = []
        if self.record_format is not None:
            for k in self.record_format:
                result['RecordFormat'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.record_format = []
        if m.get('RecordFormat') is not None:
            for k in m.get('RecordFormat'):
                temp_model = DescribeCasterConfigResponseBodyRecordConfigRecordFormatRecordFormat()
                self.record_format.append(temp_model.from_map(k))
        return self


class DescribeCasterConfigResponseBodyRecordConfig(TeaModel):
    def __init__(
        self,
        on_demand: int = None,
        oss_bucket: str = None,
        oss_endpoint: str = None,
        record_format: DescribeCasterConfigResponseBodyRecordConfigRecordFormat = None,
    ):
        # On-demand recording. Values:
        # - 0: Off. 
        # - 1: Via HTTP callback. 
        # - 2: Parse streaming parameters for on-demand recording. 
        # - 7: Default to not record.
        self.on_demand = on_demand
        # The OSS bucket for storage.
        self.oss_bucket = oss_bucket
        # The Object Storage Service (OSS) endpoint.
        self.oss_endpoint = oss_endpoint
        # The recording configuration.
        self.record_format = record_format

    def validate(self):
        if self.record_format:
            self.record_format.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.on_demand is not None:
            result['OnDemand'] = self.on_demand
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        if self.record_format is not None:
            result['RecordFormat'] = self.record_format.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OnDemand') is not None:
            self.on_demand = m.get('OnDemand')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        if m.get('RecordFormat') is not None:
            temp_model = DescribeCasterConfigResponseBodyRecordConfigRecordFormat()
            self.record_format = temp_model.from_map(m['RecordFormat'])
        return self


class DescribeCasterConfigResponseBodySyncGroupsConfigSyncGroupResourceIds(TeaModel):
    def __init__(
        self,
        resource_id: List[str] = None,
    ):
        self.resource_id = resource_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class DescribeCasterConfigResponseBodySyncGroupsConfigSyncGroup(TeaModel):
    def __init__(
        self,
        host_resource_id: str = None,
        mode: int = None,
        resource_ids: DescribeCasterConfigResponseBodySyncGroupsConfigSyncGroupResourceIds = None,
    ):
        # The ID of the resource in the production studio.
        self.host_resource_id = host_resource_id
        # The cache mode of the Static Page Caching policy. Valid values:
        # 
        # *   0: standard mode
        # *   1: force mode
        # *   2: no cache
        self.mode = mode
        # The IDs of the resources for which you want to modify the resource group. The number of resource IDs is 1 to 50.
        self.resource_ids = resource_ids

    def validate(self):
        if self.resource_ids:
            self.resource_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host_resource_id is not None:
            result['HostResourceId'] = self.host_resource_id
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.resource_ids is not None:
            result['ResourceIds'] = self.resource_ids.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HostResourceId') is not None:
            self.host_resource_id = m.get('HostResourceId')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('ResourceIds') is not None:
            temp_model = DescribeCasterConfigResponseBodySyncGroupsConfigSyncGroupResourceIds()
            self.resource_ids = temp_model.from_map(m['ResourceIds'])
        return self


class DescribeCasterConfigResponseBodySyncGroupsConfig(TeaModel):
    def __init__(
        self,
        sync_group: List[DescribeCasterConfigResponseBodySyncGroupsConfigSyncGroup] = None,
    ):
        self.sync_group = sync_group

    def validate(self):
        if self.sync_group:
            for k in self.sync_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SyncGroup'] = []
        if self.sync_group is not None:
            for k in self.sync_group:
                result['SyncGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.sync_group = []
        if m.get('SyncGroup') is not None:
            for k in m.get('SyncGroup'):
                temp_model = DescribeCasterConfigResponseBodySyncGroupsConfigSyncGroup()
                self.sync_group.append(temp_model.from_map(k))
        return self


class DescribeCasterConfigResponseBodyTranscodeConfigCustomParamsVideo(TeaModel):
    def __init__(
        self,
        bitrate: int = None,
        fps: int = None,
        height: int = None,
        width: int = None,
    ):
        # The video bitrate.
        self.bitrate = bitrate
        # The video frame rate.
        self.fps = fps
        # The video height. Unit: pixels.
        self.height = height
        # The video width. Unit: pixels.
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['bitrate'] = self.bitrate
        if self.fps is not None:
            result['fps'] = self.fps
        if self.height is not None:
            result['height'] = self.height
        if self.width is not None:
            result['width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bitrate') is not None:
            self.bitrate = m.get('bitrate')
        if m.get('fps') is not None:
            self.fps = m.get('fps')
        if m.get('height') is not None:
            self.height = m.get('height')
        if m.get('width') is not None:
            self.width = m.get('width')
        return self


class DescribeCasterConfigResponseBodyTranscodeConfigCustomParams(TeaModel):
    def __init__(
        self,
        video: DescribeCasterConfigResponseBodyTranscodeConfigCustomParamsVideo = None,
    ):
        # The video parameters.
        self.video = video

    def validate(self):
        if self.video:
            self.video.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.video is not None:
            result['video'] = self.video.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('video') is not None:
            temp_model = DescribeCasterConfigResponseBodyTranscodeConfigCustomParamsVideo()
            self.video = temp_model.from_map(m['video'])
        return self


class DescribeCasterConfigResponseBodyTranscodeConfigLiveTemplateIds(TeaModel):
    def __init__(
        self,
        location_id: List[str] = None,
    ):
        self.location_id = location_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.location_id is not None:
            result['LocationId'] = self.location_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LocationId') is not None:
            self.location_id = m.get('LocationId')
        return self


class DescribeCasterConfigResponseBodyTranscodeConfig(TeaModel):
    def __init__(
        self,
        caster_template: str = None,
        custom_params: DescribeCasterConfigResponseBodyTranscodeConfigCustomParams = None,
        live_template_ids: DescribeCasterConfigResponseBodyTranscodeConfigLiveTemplateIds = None,
    ):
        # The transcoding template of the production studio. Valid values:
        # 
        # *   **lp_ld**: low definition
        # *   **lp_sd**: standard definition
        # *   **lp_hd**: high definition
        # *   **lp_ud**: ultra high definition
        # *   **lp_ld_v**: low definition (portrait mode)
        # *   **lp_sd_v**: standard definition (portrait mode)
        # *   **lp_hd_v**: high definition (portrait mode)
        # *   **lp_ud_v**: ultra high definition (portrait mode)
        self.caster_template = caster_template
        # The custom settings.
        self.custom_params = custom_params
        # The transcoding setting for live streams.
        self.live_template_ids = live_template_ids

    def validate(self):
        if self.custom_params:
            self.custom_params.validate()
        if self.live_template_ids:
            self.live_template_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_template is not None:
            result['CasterTemplate'] = self.caster_template
        if self.custom_params is not None:
            result['CustomParams'] = self.custom_params.to_map()
        if self.live_template_ids is not None:
            result['LiveTemplateIds'] = self.live_template_ids.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterTemplate') is not None:
            self.caster_template = m.get('CasterTemplate')
        if m.get('CustomParams') is not None:
            temp_model = DescribeCasterConfigResponseBodyTranscodeConfigCustomParams()
            self.custom_params = temp_model.from_map(m['CustomParams'])
        if m.get('LiveTemplateIds') is not None:
            temp_model = DescribeCasterConfigResponseBodyTranscodeConfigLiveTemplateIds()
            self.live_template_ids = temp_model.from_map(m['LiveTemplateIds'])
        return self


class DescribeCasterConfigResponseBody(TeaModel):
    def __init__(
        self,
        auto_switch_urgent_config: str = None,
        auto_switch_urgent_on: str = None,
        callback_url: str = None,
        caster_id: str = None,
        caster_name: str = None,
        channel_enable: int = None,
        delay: float = None,
        domain_name: str = None,
        program_effect: int = None,
        program_name: str = None,
        record_config: DescribeCasterConfigResponseBodyRecordConfig = None,
        request_id: str = None,
        side_output_url: str = None,
        side_output_url_list: str = None,
        sync_groups_config: DescribeCasterConfigResponseBodySyncGroupsConfig = None,
        transcode_config: DescribeCasterConfigResponseBodyTranscodeConfig = None,
        urgent_image_id: str = None,
        urgent_image_url: str = None,
        urgent_live_stream_url: str = None,
        urgent_material_id: str = None,
    ):
        # The configuration for automatic switchover to the standby resource. The `eofThres` field specifies the duration after which the production studio automatically switches to the standby resource if a stream interruption occurs. Unit: seconds.
        self.auto_switch_urgent_config = auto_switch_urgent_config
        # Indicates whether the production studio automatically switches to the standby resource in case of a stream interruption.
        # 
        # *   **true**\
        # *   **false**\
        self.auto_switch_urgent_on = auto_switch_urgent_on
        # The callback URL.
        self.callback_url = callback_url
        # The ID of the production studio.
        self.caster_id = caster_id
        # The name of the production studio.
        self.caster_name = caster_name
        # Indicates whether channels are enabled for the production studio. Valid values:
        # 
        # *   **0**: Channels are disabled.
        # *   **1**: Channels are enabled.
        self.channel_enable = channel_enable
        # Indicates whether stream delay is enabled. Unit: seconds.
        # 
        # *   **0**: Stream delay is disabled.
        # *   **A value greater than 0**: Stream delay is enabled.
        self.delay = delay
        # The main streaming domain.
        self.domain_name = domain_name
        # Indicates whether the carousel playback feature is enabled. Valid values:
        # 
        # *   **0**: The carousel playback feature is disabled.
        # *   **1**: The carousel playback feature is enabled.
        self.program_effect = program_effect
        # The name of the playlist for carousel playback.
        self.program_name = program_name
        # The recording configuration. If this parameter is empty, the recording feature is disabled.
        self.record_config = record_config
        # The ID of the request.
        self.request_id = request_id
        # The custom stream redirect URL.
        self.side_output_url = side_output_url
        # The list of custom stream redirect URLs.
        self.side_output_url_list = side_output_url_list
        # The storage configuration.
        self.sync_groups_config = sync_groups_config
        # The transcoding configuration.
        self.transcode_config = transcode_config
        # Prepared broadcast image media asset ID.
        self.urgent_image_id = urgent_image_id
        # URL of the standby image material.
        self.urgent_image_url = urgent_image_url
        # The URL of the standby live stream.
        self.urgent_live_stream_url = urgent_live_stream_url
        # The ID of the material that is used as the standby video from the media library.
        self.urgent_material_id = urgent_material_id

    def validate(self):
        if self.record_config:
            self.record_config.validate()
        if self.sync_groups_config:
            self.sync_groups_config.validate()
        if self.transcode_config:
            self.transcode_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_switch_urgent_config is not None:
            result['AutoSwitchUrgentConfig'] = self.auto_switch_urgent_config
        if self.auto_switch_urgent_on is not None:
            result['AutoSwitchUrgentOn'] = self.auto_switch_urgent_on
        if self.callback_url is not None:
            result['CallbackUrl'] = self.callback_url
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.caster_name is not None:
            result['CasterName'] = self.caster_name
        if self.channel_enable is not None:
            result['ChannelEnable'] = self.channel_enable
        if self.delay is not None:
            result['Delay'] = self.delay
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.program_effect is not None:
            result['ProgramEffect'] = self.program_effect
        if self.program_name is not None:
            result['ProgramName'] = self.program_name
        if self.record_config is not None:
            result['RecordConfig'] = self.record_config.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.side_output_url is not None:
            result['SideOutputUrl'] = self.side_output_url
        if self.side_output_url_list is not None:
            result['SideOutputUrlList'] = self.side_output_url_list
        if self.sync_groups_config is not None:
            result['SyncGroupsConfig'] = self.sync_groups_config.to_map()
        if self.transcode_config is not None:
            result['TranscodeConfig'] = self.transcode_config.to_map()
        if self.urgent_image_id is not None:
            result['UrgentImageId'] = self.urgent_image_id
        if self.urgent_image_url is not None:
            result['UrgentImageUrl'] = self.urgent_image_url
        if self.urgent_live_stream_url is not None:
            result['UrgentLiveStreamUrl'] = self.urgent_live_stream_url
        if self.urgent_material_id is not None:
            result['UrgentMaterialId'] = self.urgent_material_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoSwitchUrgentConfig') is not None:
            self.auto_switch_urgent_config = m.get('AutoSwitchUrgentConfig')
        if m.get('AutoSwitchUrgentOn') is not None:
            self.auto_switch_urgent_on = m.get('AutoSwitchUrgentOn')
        if m.get('CallbackUrl') is not None:
            self.callback_url = m.get('CallbackUrl')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('CasterName') is not None:
            self.caster_name = m.get('CasterName')
        if m.get('ChannelEnable') is not None:
            self.channel_enable = m.get('ChannelEnable')
        if m.get('Delay') is not None:
            self.delay = m.get('Delay')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('ProgramEffect') is not None:
            self.program_effect = m.get('ProgramEffect')
        if m.get('ProgramName') is not None:
            self.program_name = m.get('ProgramName')
        if m.get('RecordConfig') is not None:
            temp_model = DescribeCasterConfigResponseBodyRecordConfig()
            self.record_config = temp_model.from_map(m['RecordConfig'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SideOutputUrl') is not None:
            self.side_output_url = m.get('SideOutputUrl')
        if m.get('SideOutputUrlList') is not None:
            self.side_output_url_list = m.get('SideOutputUrlList')
        if m.get('SyncGroupsConfig') is not None:
            temp_model = DescribeCasterConfigResponseBodySyncGroupsConfig()
            self.sync_groups_config = temp_model.from_map(m['SyncGroupsConfig'])
        if m.get('TranscodeConfig') is not None:
            temp_model = DescribeCasterConfigResponseBodyTranscodeConfig()
            self.transcode_config = temp_model.from_map(m['TranscodeConfig'])
        if m.get('UrgentImageId') is not None:
            self.urgent_image_id = m.get('UrgentImageId')
        if m.get('UrgentImageUrl') is not None:
            self.urgent_image_url = m.get('UrgentImageUrl')
        if m.get('UrgentLiveStreamUrl') is not None:
            self.urgent_live_stream_url = m.get('UrgentLiveStreamUrl')
        if m.get('UrgentMaterialId') is not None:
            self.urgent_material_id = m.get('UrgentMaterialId')
        return self


class DescribeCasterConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCasterConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCasterConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterLayoutsRequest(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        layout_id: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The ID of the production studio.
        # 
        # *   If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation, check the value of the response parameter CasterId to obtain the ID.
        # *   If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        # 
        # >  You can find the ID of the production studio in the Instance ID/Name column.
        # 
        # This parameter is required.
        self.caster_id = caster_id
        # The ID of the layout.
        # 
        # If you do not specify a layout ID, all layouts of the production studio are queried.
        self.layout_id = layout_id
        self.owner_id = owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeCasterLayoutsResponseBodyLayoutsLayoutAudioLayersAudioLayer(TeaModel):
    def __init__(
        self,
        fixed_delay_duration: int = None,
        valid_channel: str = None,
        volume_rate: float = None,
    ):
        # The fixed delay of the audio layer. This parameter is used to synchronize the audio with subtitles.
        # 
        # Unit: milliseconds. Default value: **0**. Valid values: **0 to 5000**.
        self.fixed_delay_duration = fixed_delay_duration
        # The sound channels that are used for volume input in the audio layer. Valid values:
        # 
        # *   **leftChannel**: the left channel
        # *   **rightChannel**: the right channel
        # *   **all** (default): both the left and right channels
        self.valid_channel = valid_channel
        # The normalized value of the height of the audio layer. The width of the audio layer is proportionally scaled based on this parameter.
        # 
        # >  The default value is **0**, which indicates that the audio layer is not scaled.
        self.volume_rate = volume_rate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fixed_delay_duration is not None:
            result['FixedDelayDuration'] = self.fixed_delay_duration
        if self.valid_channel is not None:
            result['ValidChannel'] = self.valid_channel
        if self.volume_rate is not None:
            result['VolumeRate'] = self.volume_rate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FixedDelayDuration') is not None:
            self.fixed_delay_duration = m.get('FixedDelayDuration')
        if m.get('ValidChannel') is not None:
            self.valid_channel = m.get('ValidChannel')
        if m.get('VolumeRate') is not None:
            self.volume_rate = m.get('VolumeRate')
        return self


class DescribeCasterLayoutsResponseBodyLayoutsLayoutAudioLayers(TeaModel):
    def __init__(
        self,
        audio_layer: List[DescribeCasterLayoutsResponseBodyLayoutsLayoutAudioLayersAudioLayer] = None,
    ):
        self.audio_layer = audio_layer

    def validate(self):
        if self.audio_layer:
            for k in self.audio_layer:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioLayer'] = []
        if self.audio_layer is not None:
            for k in self.audio_layer:
                result['AudioLayer'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.audio_layer = []
        if m.get('AudioLayer') is not None:
            for k in m.get('AudioLayer'):
                temp_model = DescribeCasterLayoutsResponseBodyLayoutsLayoutAudioLayersAudioLayer()
                self.audio_layer.append(temp_model.from_map(k))
        return self


class DescribeCasterLayoutsResponseBodyLayoutsLayoutBlendList(TeaModel):
    def __init__(
        self,
        location_id: List[str] = None,
    ):
        self.location_id = location_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.location_id is not None:
            result['LocationId'] = self.location_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LocationId') is not None:
            self.location_id = m.get('LocationId')
        return self


class DescribeCasterLayoutsResponseBodyLayoutsLayoutMixList(TeaModel):
    def __init__(
        self,
        location_id: List[str] = None,
    ):
        self.location_id = location_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.location_id is not None:
            result['LocationId'] = self.location_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LocationId') is not None:
            self.location_id = m.get('LocationId')
        return self


class DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayersVideoLayerPositionNormalizeds(TeaModel):
    def __init__(
        self,
        position: List[float] = None,
    ):
        self.position = position

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.position is not None:
            result['Position'] = self.position
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Position') is not None:
            self.position = m.get('Position')
        return self


class DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayersVideoLayer(TeaModel):
    def __init__(
        self,
        fill_mode: str = None,
        fixed_delay_duration: int = None,
        height_normalized: float = None,
        position_normalizeds: DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayersVideoLayerPositionNormalizeds = None,
        position_refer: str = None,
        width_normalized: float = None,
    ):
        # The scaling mode of the video layer. Valid values:
        # 
        # *   **none** (default): specifies that the video layer is not scaled. The video layer is displayed based on its original size.
        # *   **fit**: specifies that the video layer is adapted to the fill area. The video layer is displayed based on the fill area. In this case, the video layer is scaled proportionally, with its original aspect ratio retained. The video layer is placed in the center, with its longer sides aligned with the fill area. If the aspect ratio of the video layer is different from that of the fill area, the content of the lower layer is displayed alongside the shorter sides. If there is no lower layer, black bars are displayed instead.
        self.fill_mode = fill_mode
        # The fixed delay of the video layer. This parameter is used to synchronize the video with subtitles.
        # 
        # Unit: milliseconds. Default value: **0**. Valid values: **0 to 5000**.
        self.fixed_delay_duration = fixed_delay_duration
        # The normalized value of the height of the video layer.
        # 
        # *   If the FillMode parameter of the video layer is set to none, the width of the video layer is proportionally scaled based on this parameter. The default value is **0**, which indicates that the video layer is not scaled.
        # *   If the FillMode parameter of the video layer is set to fit, the value of this parameter is greater than **0**.
        self.height_normalized = height_normalized
        # The normalized value of the position of the video layer, in the format of `[x,y]`. Default value: `[0,0]`.
        # 
        # >  The values of x and y are normalized.
        self.position_normalizeds = position_normalizeds
        # The reference coordinates of the video layer. Valid values:
        # 
        # *   **topLeft** (default): the upper-left corner
        # *   **topRight**: the upper-right corner
        # *   **bottomLeft**: the lower-left corner
        # *   **bottomRight**: the lower-right corner
        # *   **center**: the center
        # *   **topCenter**: the upper center
        # *   **bottomCenter**: the lower center
        # *   **leftCenter**: the left center
        # *   **rightCenter**: the right center
        self.position_refer = position_refer
        # The normalized value of the width of the video layer.
        # 
        # *   If the FillMode parameter of the video layer is set to none, the height of the video layer is scaled based on this parameter. The default value is **0**, which indicates that the video layer is not scaled.
        # *   If the FillMode parameter of the video layer is set to fit, the value of this parameter is greater than **0**.
        self.width_normalized = width_normalized

    def validate(self):
        if self.position_normalizeds:
            self.position_normalizeds.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fill_mode is not None:
            result['FillMode'] = self.fill_mode
        if self.fixed_delay_duration is not None:
            result['FixedDelayDuration'] = self.fixed_delay_duration
        if self.height_normalized is not None:
            result['HeightNormalized'] = self.height_normalized
        if self.position_normalizeds is not None:
            result['PositionNormalizeds'] = self.position_normalizeds.to_map()
        if self.position_refer is not None:
            result['PositionRefer'] = self.position_refer
        if self.width_normalized is not None:
            result['WidthNormalized'] = self.width_normalized
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FillMode') is not None:
            self.fill_mode = m.get('FillMode')
        if m.get('FixedDelayDuration') is not None:
            self.fixed_delay_duration = m.get('FixedDelayDuration')
        if m.get('HeightNormalized') is not None:
            self.height_normalized = m.get('HeightNormalized')
        if m.get('PositionNormalizeds') is not None:
            temp_model = DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayersVideoLayerPositionNormalizeds()
            self.position_normalizeds = temp_model.from_map(m['PositionNormalizeds'])
        if m.get('PositionRefer') is not None:
            self.position_refer = m.get('PositionRefer')
        if m.get('WidthNormalized') is not None:
            self.width_normalized = m.get('WidthNormalized')
        return self


class DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayers(TeaModel):
    def __init__(
        self,
        video_layer: List[DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayersVideoLayer] = None,
    ):
        self.video_layer = video_layer

    def validate(self):
        if self.video_layer:
            for k in self.video_layer:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VideoLayer'] = []
        if self.video_layer is not None:
            for k in self.video_layer:
                result['VideoLayer'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.video_layer = []
        if m.get('VideoLayer') is not None:
            for k in m.get('VideoLayer'):
                temp_model = DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayersVideoLayer()
                self.video_layer.append(temp_model.from_map(k))
        return self


class DescribeCasterLayoutsResponseBodyLayoutsLayout(TeaModel):
    def __init__(
        self,
        audio_layers: DescribeCasterLayoutsResponseBodyLayoutsLayoutAudioLayers = None,
        blend_list: DescribeCasterLayoutsResponseBodyLayoutsLayoutBlendList = None,
        layout_id: str = None,
        mix_list: DescribeCasterLayoutsResponseBodyLayoutsLayoutMixList = None,
        video_layers: DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayers = None,
    ):
        # The configurations of the audio layers.
        self.audio_layers = audio_layers
        # The location IDs of the video layers, which are in the same order as the video layers.
        self.blend_list = blend_list
        # The ID of the layout.
        self.layout_id = layout_id
        # The location IDs of the audio layers, which are in the same order as the audio layers.
        self.mix_list = mix_list
        # The configurations of the video layers, which are in the default array sequence.
        self.video_layers = video_layers

    def validate(self):
        if self.audio_layers:
            self.audio_layers.validate()
        if self.blend_list:
            self.blend_list.validate()
        if self.mix_list:
            self.mix_list.validate()
        if self.video_layers:
            self.video_layers.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_layers is not None:
            result['AudioLayers'] = self.audio_layers.to_map()
        if self.blend_list is not None:
            result['BlendList'] = self.blend_list.to_map()
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        if self.mix_list is not None:
            result['MixList'] = self.mix_list.to_map()
        if self.video_layers is not None:
            result['VideoLayers'] = self.video_layers.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AudioLayers') is not None:
            temp_model = DescribeCasterLayoutsResponseBodyLayoutsLayoutAudioLayers()
            self.audio_layers = temp_model.from_map(m['AudioLayers'])
        if m.get('BlendList') is not None:
            temp_model = DescribeCasterLayoutsResponseBodyLayoutsLayoutBlendList()
            self.blend_list = temp_model.from_map(m['BlendList'])
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        if m.get('MixList') is not None:
            temp_model = DescribeCasterLayoutsResponseBodyLayoutsLayoutMixList()
            self.mix_list = temp_model.from_map(m['MixList'])
        if m.get('VideoLayers') is not None:
            temp_model = DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayers()
            self.video_layers = temp_model.from_map(m['VideoLayers'])
        return self


class DescribeCasterLayoutsResponseBodyLayouts(TeaModel):
    def __init__(
        self,
        layout: List[DescribeCasterLayoutsResponseBodyLayoutsLayout] = None,
    ):
        self.layout = layout

    def validate(self):
        if self.layout:
            for k in self.layout:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Layout'] = []
        if self.layout is not None:
            for k in self.layout:
                result['Layout'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.layout = []
        if m.get('Layout') is not None:
            for k in m.get('Layout'):
                temp_model = DescribeCasterLayoutsResponseBodyLayoutsLayout()
                self.layout.append(temp_model.from_map(k))
        return self


class DescribeCasterLayoutsResponseBody(TeaModel):
    def __init__(
        self,
        layouts: DescribeCasterLayoutsResponseBodyLayouts = None,
        request_id: str = None,
        total: int = None,
    ):
        # The layouts.
        self.layouts = layouts
        # The request ID.
        self.request_id = request_id
        # The total number of entries.
        self.total = total

    def validate(self):
        if self.layouts:
            self.layouts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.layouts is not None:
            result['Layouts'] = self.layouts.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Layouts') is not None:
            temp_model = DescribeCasterLayoutsResponseBodyLayouts()
            self.layouts = temp_model.from_map(m['Layouts'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeCasterLayoutsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCasterLayoutsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCasterLayoutsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterProgramRequest(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        end_time: str = None,
        episode_id: str = None,
        episode_type: str = None,
        owner_id: int = None,
        page_num: int = None,
        page_size: int = None,
        region_id: str = None,
        start_time: str = None,
        status: int = None,
    ):
        # The ID of the production studio.
        # 
        # *   If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation, check the value of the response parameter CasterId to obtain the ID.
        # *   If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        # 
        # >  You can find the ID of the production studio in the Instance ID/Name column.
        # 
        # This parameter is required.
        self.caster_id = caster_id
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.end_time = end_time
        # The ID of the episode.
        self.episode_id = episode_id
        # The type of the episode. Valid values:
        # 
        # *   **Resource**: a video resource
        # *   **Component**: a component
        self.episode_type = episode_type
        self.owner_id = owner_id
        # The page number.
        self.page_num = page_num
        # The number of entries per page.
        self.page_size = page_size
        self.region_id = region_id
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        self.start_time = start_time
        # The status of the episode. Valid values:
        # 
        # *   **0**: The episode is not played.
        # *   **1**: The episode is being played.
        # *   **2**: The playback of the episode is complete.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.episode_id is not None:
            result['EpisodeId'] = self.episode_id
        if self.episode_type is not None:
            result['EpisodeType'] = self.episode_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EpisodeId') is not None:
            self.episode_id = m.get('EpisodeId')
        if m.get('EpisodeType') is not None:
            self.episode_type = m.get('EpisodeType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeCasterProgramResponseBodyEpisodesEpisodeComponentIds(TeaModel):
    def __init__(
        self,
        component_id: List[str] = None,
    ):
        self.component_id = component_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        return self


class DescribeCasterProgramResponseBodyEpisodesEpisode(TeaModel):
    def __init__(
        self,
        component_ids: DescribeCasterProgramResponseBodyEpisodesEpisodeComponentIds = None,
        end_time: str = None,
        episode_id: str = None,
        episode_name: str = None,
        episode_type: str = None,
        resource_id: str = None,
        start_time: str = None,
        status: int = None,
        switch_type: str = None,
    ):
        # The components.
        self.component_ids = component_ids
        # The end of the time range during which data was queried. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.end_time = end_time
        # The ID of the episode.
        self.episode_id = episode_id
        # The name of the episode.
        self.episode_name = episode_name
        # The type of the episode. Valid values:
        # 
        # *   **Resource**: a video resource
        # *   **Component**: a component
        self.episode_type = episode_type
        # The ID of the video resource.
        self.resource_id = resource_id
        # The beginning of the time range during which data was queried. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.start_time = start_time
        # The status of the episode.
        self.status = status
        # The policy for switching episodes. Valid values:
        # 
        # *   **TimeFirst**: The episode starts when the previous episode ends and ends when the next episode starts. If no next episode exists, the episode keeps repeating until a new episode is added or the production studio stops. This value is required for live video resources.
        # *   **ContentFirst**: The episode starts and ends as scheduled.
        self.switch_type = switch_type

    def validate(self):
        if self.component_ids:
            self.component_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.component_ids is not None:
            result['ComponentIds'] = self.component_ids.to_map()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.episode_id is not None:
            result['EpisodeId'] = self.episode_id
        if self.episode_name is not None:
            result['EpisodeName'] = self.episode_name
        if self.episode_type is not None:
            result['EpisodeType'] = self.episode_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.switch_type is not None:
            result['SwitchType'] = self.switch_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComponentIds') is not None:
            temp_model = DescribeCasterProgramResponseBodyEpisodesEpisodeComponentIds()
            self.component_ids = temp_model.from_map(m['ComponentIds'])
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EpisodeId') is not None:
            self.episode_id = m.get('EpisodeId')
        if m.get('EpisodeName') is not None:
            self.episode_name = m.get('EpisodeName')
        if m.get('EpisodeType') is not None:
            self.episode_type = m.get('EpisodeType')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SwitchType') is not None:
            self.switch_type = m.get('SwitchType')
        return self


class DescribeCasterProgramResponseBodyEpisodes(TeaModel):
    def __init__(
        self,
        episode: List[DescribeCasterProgramResponseBodyEpisodesEpisode] = None,
    ):
        self.episode = episode

    def validate(self):
        if self.episode:
            for k in self.episode:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Episode'] = []
        if self.episode is not None:
            for k in self.episode:
                result['Episode'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.episode = []
        if m.get('Episode') is not None:
            for k in m.get('Episode'):
                temp_model = DescribeCasterProgramResponseBodyEpisodesEpisode()
                self.episode.append(temp_model.from_map(k))
        return self


class DescribeCasterProgramResponseBody(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        episodes: DescribeCasterProgramResponseBodyEpisodes = None,
        program_effect: int = None,
        program_name: str = None,
        request_id: str = None,
        total: int = None,
    ):
        # The ID of the production studio.
        self.caster_id = caster_id
        # The list of the episodes.
        self.episodes = episodes
        # Indicates whether carousel playback is enabled.
        # 
        # *   **0**: Carousel playback is disabled.
        # *   **1**: Carousel playback is enabled.
        self.program_effect = program_effect
        # The name of the episode list.
        self.program_name = program_name
        # The request ID.
        self.request_id = request_id
        # The total number of entries.
        self.total = total

    def validate(self):
        if self.episodes:
            self.episodes.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.episodes is not None:
            result['Episodes'] = self.episodes.to_map()
        if self.program_effect is not None:
            result['ProgramEffect'] = self.program_effect
        if self.program_name is not None:
            result['ProgramName'] = self.program_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('Episodes') is not None:
            temp_model = DescribeCasterProgramResponseBodyEpisodes()
            self.episodes = temp_model.from_map(m['Episodes'])
        if m.get('ProgramEffect') is not None:
            self.program_effect = m.get('ProgramEffect')
        if m.get('ProgramName') is not None:
            self.program_name = m.get('ProgramName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeCasterProgramResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCasterProgramResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCasterProgramResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterSceneAudioRequest(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        owner_id: int = None,
        region_id: str = None,
        scene_id: str = None,
    ):
        # The ID of the production studio.
        # 
        # *   If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/69338.html) operation, check the value of the response parameter CasterId to obtain the ID.
        # *   If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        # 
        # >  You can find the ID of the production studio in the Instance Name column.
        # 
        # This parameter is required.
        self.caster_id = caster_id
        self.owner_id = owner_id
        self.region_id = region_id
        # The ID of the scene.
        # 
        # This parameter is required.
        self.scene_id = scene_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.scene_id is not None:
            result['SceneId'] = self.scene_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SceneId') is not None:
            self.scene_id = m.get('SceneId')
        return self


class DescribeCasterSceneAudioResponseBodyAudioLayersAudioLayer(TeaModel):
    def __init__(
        self,
        fixed_delay_duration: int = None,
        valid_channel: str = None,
        volume_rate: float = None,
    ):
        # The fixed delay of the audio layer. Unit: milliseconds.
        self.fixed_delay_duration = fixed_delay_duration
        # The sound channel type of the audio layer. Valid values:
        # 
        # *   **left**: the left channel
        # *   **right**: the right channel
        # *   **all** (default): both the left and right channels
        self.valid_channel = valid_channel
        # The volume of the audio layer.
        self.volume_rate = volume_rate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fixed_delay_duration is not None:
            result['FixedDelayDuration'] = self.fixed_delay_duration
        if self.valid_channel is not None:
            result['ValidChannel'] = self.valid_channel
        if self.volume_rate is not None:
            result['VolumeRate'] = self.volume_rate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FixedDelayDuration') is not None:
            self.fixed_delay_duration = m.get('FixedDelayDuration')
        if m.get('ValidChannel') is not None:
            self.valid_channel = m.get('ValidChannel')
        if m.get('VolumeRate') is not None:
            self.volume_rate = m.get('VolumeRate')
        return self


class DescribeCasterSceneAudioResponseBodyAudioLayers(TeaModel):
    def __init__(
        self,
        audio_layer: List[DescribeCasterSceneAudioResponseBodyAudioLayersAudioLayer] = None,
    ):
        self.audio_layer = audio_layer

    def validate(self):
        if self.audio_layer:
            for k in self.audio_layer:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioLayer'] = []
        if self.audio_layer is not None:
            for k in self.audio_layer:
                result['AudioLayer'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.audio_layer = []
        if m.get('AudioLayer') is not None:
            for k in m.get('AudioLayer'):
                temp_model = DescribeCasterSceneAudioResponseBodyAudioLayersAudioLayer()
                self.audio_layer.append(temp_model.from_map(k))
        return self


class DescribeCasterSceneAudioResponseBodyMixList(TeaModel):
    def __init__(
        self,
        location_id: List[str] = None,
    ):
        self.location_id = location_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.location_id is not None:
            result['LocationId'] = self.location_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LocationId') is not None:
            self.location_id = m.get('LocationId')
        return self


class DescribeCasterSceneAudioResponseBody(TeaModel):
    def __init__(
        self,
        audio_layers: DescribeCasterSceneAudioResponseBodyAudioLayers = None,
        caster_id: str = None,
        follow_enable: int = None,
        mix_list: DescribeCasterSceneAudioResponseBodyMixList = None,
        request_id: str = None,
    ):
        # The configurations of the audio layers.
        self.audio_layers = audio_layers
        # The ID of the production studio. You can specify the ID in a request to start a scene in the production studio.
        self.caster_id = caster_id
        # The audio mode. By default, the audio follows video (AFV) mode is used. Valid values:
        # 
        # *   **0**: the audio mixing mode
        # *   **1**: the AFV mode
        self.follow_enable = follow_enable
        self.mix_list = mix_list
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.audio_layers:
            self.audio_layers.validate()
        if self.mix_list:
            self.mix_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_layers is not None:
            result['AudioLayers'] = self.audio_layers.to_map()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.follow_enable is not None:
            result['FollowEnable'] = self.follow_enable
        if self.mix_list is not None:
            result['MixList'] = self.mix_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AudioLayers') is not None:
            temp_model = DescribeCasterSceneAudioResponseBodyAudioLayers()
            self.audio_layers = temp_model.from_map(m['AudioLayers'])
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('FollowEnable') is not None:
            self.follow_enable = m.get('FollowEnable')
        if m.get('MixList') is not None:
            temp_model = DescribeCasterSceneAudioResponseBodyMixList()
            self.mix_list = temp_model.from_map(m['MixList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCasterSceneAudioResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCasterSceneAudioResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCasterSceneAudioResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterScenesRequest(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        owner_id: int = None,
        region_id: str = None,
        scene_id: str = None,
    ):
        # The ID of the production studio.
        # 
        # *   If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/69338.html) operation, check the value of the response parameter CasterId to obtain the ID.
        # *   If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        # 
        # >  You can find the ID of the production studio in the Instance ID/Name column.
        # 
        # This parameter is required.
        self.caster_id = caster_id
        self.owner_id = owner_id
        self.region_id = region_id
        # The ID of the scene.
        self.scene_id = scene_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.scene_id is not None:
            result['SceneId'] = self.scene_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SceneId') is not None:
            self.scene_id = m.get('SceneId')
        return self


class DescribeCasterScenesResponseBodySceneListSceneComponentIds(TeaModel):
    def __init__(
        self,
        component_id: List[str] = None,
    ):
        self.component_id = component_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.component_id is not None:
            result['componentId'] = self.component_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('componentId') is not None:
            self.component_id = m.get('componentId')
        return self


class DescribeCasterScenesResponseBodySceneListSceneStreamInfosStreamInfo(TeaModel):
    def __init__(
        self,
        output_stream_url: str = None,
        transcode_config: str = None,
        video_format: str = None,
    ):
        # The streaming URL.
        self.output_stream_url = output_stream_url
        # The transcoding configuration. Valid values:
        # 
        # *   **sd**: standard definition
        # *   **lld**: low definition
        # *   **lud**: ultra-high definition
        # *   **lhd**: high definition
        self.transcode_config = transcode_config
        # The format. Valid values:
        # 
        # *   **flv**\
        # *   **mp4**\
        # *   **m3u8**\
        self.video_format = video_format

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.output_stream_url is not None:
            result['OutputStreamUrl'] = self.output_stream_url
        if self.transcode_config is not None:
            result['TranscodeConfig'] = self.transcode_config
        if self.video_format is not None:
            result['VideoFormat'] = self.video_format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OutputStreamUrl') is not None:
            self.output_stream_url = m.get('OutputStreamUrl')
        if m.get('TranscodeConfig') is not None:
            self.transcode_config = m.get('TranscodeConfig')
        if m.get('VideoFormat') is not None:
            self.video_format = m.get('VideoFormat')
        return self


class DescribeCasterScenesResponseBodySceneListSceneStreamInfos(TeaModel):
    def __init__(
        self,
        stream_info: List[DescribeCasterScenesResponseBodySceneListSceneStreamInfosStreamInfo] = None,
    ):
        self.stream_info = stream_info

    def validate(self):
        if self.stream_info:
            for k in self.stream_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['StreamInfo'] = []
        if self.stream_info is not None:
            for k in self.stream_info:
                result['StreamInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.stream_info = []
        if m.get('StreamInfo') is not None:
            for k in m.get('StreamInfo'):
                temp_model = DescribeCasterScenesResponseBodySceneListSceneStreamInfosStreamInfo()
                self.stream_info.append(temp_model.from_map(k))
        return self


class DescribeCasterScenesResponseBodySceneListScene(TeaModel):
    def __init__(
        self,
        component_ids: DescribeCasterScenesResponseBodySceneListSceneComponentIds = None,
        layout_id: str = None,
        output_type: str = None,
        scene_id: str = None,
        scene_name: str = None,
        status: int = None,
        stream_infos: DescribeCasterScenesResponseBodySceneListSceneStreamInfos = None,
        stream_url: str = None,
    ):
        # The components.
        self.component_ids = component_ids
        # The ID of the layout.
        self.layout_id = layout_id
        # Indicates whether the output video is in PVW mode or PGM mode. Valid values:
        # 
        # *   **0**: in PVW mode.
        # *   **1**: in PGM mode.
        self.output_type = output_type
        # The ID of the scene. You can use the ID as a request parameter in the API operation that is used to modify the audio configurations of the scene, query the audio configurations of the scene, start the scene, or stop the scene.
        self.scene_id = scene_id
        # The name of the scene.
        self.scene_name = scene_name
        # The status of the scene. Valid values:
        # 
        # *   **0**: disabled
        # *   **1**: enabled
        self.status = status
        # The information about the stream.
        self.stream_infos = stream_infos
        # The URL of the output stream.
        self.stream_url = stream_url

    def validate(self):
        if self.component_ids:
            self.component_ids.validate()
        if self.stream_infos:
            self.stream_infos.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.component_ids is not None:
            result['ComponentIds'] = self.component_ids.to_map()
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        if self.output_type is not None:
            result['OutputType'] = self.output_type
        if self.scene_id is not None:
            result['SceneId'] = self.scene_id
        if self.scene_name is not None:
            result['SceneName'] = self.scene_name
        if self.status is not None:
            result['Status'] = self.status
        if self.stream_infos is not None:
            result['StreamInfos'] = self.stream_infos.to_map()
        if self.stream_url is not None:
            result['StreamUrl'] = self.stream_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComponentIds') is not None:
            temp_model = DescribeCasterScenesResponseBodySceneListSceneComponentIds()
            self.component_ids = temp_model.from_map(m['ComponentIds'])
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        if m.get('OutputType') is not None:
            self.output_type = m.get('OutputType')
        if m.get('SceneId') is not None:
            self.scene_id = m.get('SceneId')
        if m.get('SceneName') is not None:
            self.scene_name = m.get('SceneName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StreamInfos') is not None:
            temp_model = DescribeCasterScenesResponseBodySceneListSceneStreamInfos()
            self.stream_infos = temp_model.from_map(m['StreamInfos'])
        if m.get('StreamUrl') is not None:
            self.stream_url = m.get('StreamUrl')
        return self


class DescribeCasterScenesResponseBodySceneList(TeaModel):
    def __init__(
        self,
        scene: List[DescribeCasterScenesResponseBodySceneListScene] = None,
    ):
        self.scene = scene

    def validate(self):
        if self.scene:
            for k in self.scene:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Scene'] = []
        if self.scene is not None:
            for k in self.scene:
                result['Scene'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.scene = []
        if m.get('Scene') is not None:
            for k in m.get('Scene'):
                temp_model = DescribeCasterScenesResponseBodySceneListScene()
                self.scene.append(temp_model.from_map(k))
        return self


class DescribeCasterScenesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        scene_list: DescribeCasterScenesResponseBodySceneList = None,
        total: int = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The scenes.
        self.scene_list = scene_list
        # The total number of entries.
        self.total = total

    def validate(self):
        if self.scene_list:
            self.scene_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.scene_list is not None:
            result['SceneList'] = self.scene_list.to_map()
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SceneList') is not None:
            temp_model = DescribeCasterScenesResponseBodySceneList()
            self.scene_list = temp_model.from_map(m['SceneList'])
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeCasterScenesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCasterScenesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCasterScenesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterStreamUrlRequest(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The ID of the production studio.
        # 
        # If you create a production studio through the [CreateCaster](~~69338#doc-api-live-CreateCaster~~) interface, check the value of the CasterId parameter in the response.
        # 
        # If you create a production studio through the ApsaraVideo Live Console, log in to the console, then check the ID of the production studio through the following path:
        # 
        # Production Studios > Production Studio Management
        # 
        # >  The CasterId is reflected in the Name column on the Production Studio Management page.
        # 
        # This parameter is required.
        self.caster_id = caster_id
        self.owner_id = owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStreamStreamInfosStreamInfo(TeaModel):
    def __init__(
        self,
        output_stream_url: str = None,
        transcode_config: str = None,
        video_format: str = None,
    ):
        # The streaming URL.
        self.output_stream_url = output_stream_url
        # The resolution to which the scene transcodes the stream for playback. Valid values:
        # 
        # *   **lsd**: standard definition.
        # *   **lld**: low definition.
        # *   **lud**: ultra high definition.
        # *   **lhd**: high definition.
        self.transcode_config = transcode_config
        # The format to which the scene transcodes the stream for playback. Valid values:
        # 
        # *   **flv**.
        # *   **rtmp**.
        # *   **m3u8**.
        self.video_format = video_format

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.output_stream_url is not None:
            result['OutputStreamUrl'] = self.output_stream_url
        if self.transcode_config is not None:
            result['TranscodeConfig'] = self.transcode_config
        if self.video_format is not None:
            result['VideoFormat'] = self.video_format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OutputStreamUrl') is not None:
            self.output_stream_url = m.get('OutputStreamUrl')
        if m.get('TranscodeConfig') is not None:
            self.transcode_config = m.get('TranscodeConfig')
        if m.get('VideoFormat') is not None:
            self.video_format = m.get('VideoFormat')
        return self


class DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStreamStreamInfos(TeaModel):
    def __init__(
        self,
        stream_info: List[DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStreamStreamInfosStreamInfo] = None,
    ):
        self.stream_info = stream_info

    def validate(self):
        if self.stream_info:
            for k in self.stream_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['StreamInfo'] = []
        if self.stream_info is not None:
            for k in self.stream_info:
                result['StreamInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.stream_info = []
        if m.get('StreamInfo') is not None:
            for k in m.get('StreamInfo'):
                temp_model = DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStreamStreamInfosStreamInfo()
                self.stream_info.append(temp_model.from_map(k))
        return self


class DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStream(TeaModel):
    def __init__(
        self,
        output_type: int = None,
        rtmp_url: str = None,
        scene_id: str = None,
        stream_infos: DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStreamStreamInfos = None,
        stream_url: str = None,
    ):
        # Indicates whether the output stream is in preview mode or program mode.
        # 
        # *   **0**: indicates that the output videos of the scene are in preview mode.
        # *   **1**: indicates that the output videos of the scene are in program mode.
        self.output_type = output_type
        # The Real Time Messaging Protocol (RTMP) URL.
        self.rtmp_url = rtmp_url
        # The ID of the scene.
        self.scene_id = scene_id
        # The information about the stream.
        self.stream_infos = stream_infos
        # The streaming URL.
        self.stream_url = stream_url

    def validate(self):
        if self.stream_infos:
            self.stream_infos.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.output_type is not None:
            result['OutputType'] = self.output_type
        if self.rtmp_url is not None:
            result['RtmpUrl'] = self.rtmp_url
        if self.scene_id is not None:
            result['SceneId'] = self.scene_id
        if self.stream_infos is not None:
            result['StreamInfos'] = self.stream_infos.to_map()
        if self.stream_url is not None:
            result['StreamUrl'] = self.stream_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OutputType') is not None:
            self.output_type = m.get('OutputType')
        if m.get('RtmpUrl') is not None:
            self.rtmp_url = m.get('RtmpUrl')
        if m.get('SceneId') is not None:
            self.scene_id = m.get('SceneId')
        if m.get('StreamInfos') is not None:
            temp_model = DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStreamStreamInfos()
            self.stream_infos = temp_model.from_map(m['StreamInfos'])
        if m.get('StreamUrl') is not None:
            self.stream_url = m.get('StreamUrl')
        return self


class DescribeCasterStreamUrlResponseBodyCasterStreams(TeaModel):
    def __init__(
        self,
        caster_stream: List[DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStream] = None,
    ):
        self.caster_stream = caster_stream

    def validate(self):
        if self.caster_stream:
            for k in self.caster_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CasterStream'] = []
        if self.caster_stream is not None:
            for k in self.caster_stream:
                result['CasterStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.caster_stream = []
        if m.get('CasterStream') is not None:
            for k in m.get('CasterStream'):
                temp_model = DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStream()
                self.caster_stream.append(temp_model.from_map(k))
        return self


class DescribeCasterStreamUrlResponseBody(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        caster_streams: DescribeCasterStreamUrlResponseBodyCasterStreams = None,
        request_id: str = None,
        total: int = None,
    ):
        # The ID of the production studio.
        self.caster_id = caster_id
        # The information about the streams of the production studio.
        self.caster_streams = caster_streams
        # The ID of the request.
        self.request_id = request_id
        # The number of streams that were returned.
        self.total = total

    def validate(self):
        if self.caster_streams:
            self.caster_streams.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.caster_streams is not None:
            result['CasterStreams'] = self.caster_streams.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('CasterStreams') is not None:
            temp_model = DescribeCasterStreamUrlResponseBodyCasterStreams()
            self.caster_streams = temp_model.from_map(m['CasterStreams'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeCasterStreamUrlResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCasterStreamUrlResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCasterStreamUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterVideoResourcesRequest(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The ID of the production studio.
        # 
        # *   If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/2848009.html) operation, check the value of the response parameter CasterId to obtain the ID.
        # *   If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the **ApsaraVideo Live console** and click **Production Studios** in the left-side navigation pane.
        # 
        # >  You can find the ID of the production studio in the Instance ID/Name column.
        # 
        # This parameter is required.
        self.caster_id = caster_id
        self.owner_id = owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeCasterVideoResourcesResponseBodyVideoResourcesVideoResource(TeaModel):
    def __init__(
        self,
        begin_offset: int = None,
        end_offset: int = None,
        flv_url: str = None,
        image_id: str = None,
        image_url: str = None,
        live_stream_url: str = None,
        location_id: str = None,
        material_id: str = None,
        pts_callback_interval: int = None,
        repeat_num: int = None,
        resource_id: str = None,
        resource_name: str = None,
        vod_url: str = None,
    ):
        # The offset of the position where the system starts to read the video resource. This parameter takes effect only if the input source is a video file. Unit: milliseconds.
        # 
        # A value **greater than 0** indicates an offset from the first frame.
        self.begin_offset = begin_offset
        # The offset of the position where the system stops reading the video file. This parameter takes effect only if the input source is a video file. Unit: milliseconds.
        # 
        # *   A value greater than **0** indicates an offset from the first frame.
        # *   A value smaller than **0** indicates an offset from the last frame.
        self.end_offset = end_offset
        # The source URL.
        self.flv_url = flv_url
        # The image ID.
        self.image_id = image_id
        # The image URL.
        self.image_url = image_url
        # The URL of the live stream.
        self.live_stream_url = live_stream_url
        # The position of the video resource.
        self.location_id = location_id
        # The material ID.
        self.material_id = material_id
        # The interval between presentation timestamp (PTS) callbacks. If you set the value to 0, the PTS callback is disabled. This parameter is returned only when the video resource is a video-on-demand (VOD) file.
        self.pts_callback_interval = pts_callback_interval
        # The number of playback times after the first playback is complete. This parameter takes effect only when the input source is a video file. Valid values:
        # 
        # *   **0** (default): The video file is played only once.
        # *   **-1**: The video file is played in loop mode.
        self.repeat_num = repeat_num
        # The resource ID.
        self.resource_id = resource_id
        # The resource name.
        self.resource_name = resource_name
        # The URL of the VOD file.
        # 
        # This parameter is returned only when the video resource is an MP4, FLV, or TS file that is not from the media library.
        self.vod_url = vod_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin_offset is not None:
            result['BeginOffset'] = self.begin_offset
        if self.end_offset is not None:
            result['EndOffset'] = self.end_offset
        if self.flv_url is not None:
            result['FlvUrl'] = self.flv_url
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_url is not None:
            result['ImageUrl'] = self.image_url
        if self.live_stream_url is not None:
            result['LiveStreamUrl'] = self.live_stream_url
        if self.location_id is not None:
            result['LocationId'] = self.location_id
        if self.material_id is not None:
            result['MaterialId'] = self.material_id
        if self.pts_callback_interval is not None:
            result['PtsCallbackInterval'] = self.pts_callback_interval
        if self.repeat_num is not None:
            result['RepeatNum'] = self.repeat_num
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        if self.vod_url is not None:
            result['VodUrl'] = self.vod_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BeginOffset') is not None:
            self.begin_offset = m.get('BeginOffset')
        if m.get('EndOffset') is not None:
            self.end_offset = m.get('EndOffset')
        if m.get('FlvUrl') is not None:
            self.flv_url = m.get('FlvUrl')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageUrl') is not None:
            self.image_url = m.get('ImageUrl')
        if m.get('LiveStreamUrl') is not None:
            self.live_stream_url = m.get('LiveStreamUrl')
        if m.get('LocationId') is not None:
            self.location_id = m.get('LocationId')
        if m.get('MaterialId') is not None:
            self.material_id = m.get('MaterialId')
        if m.get('PtsCallbackInterval') is not None:
            self.pts_callback_interval = m.get('PtsCallbackInterval')
        if m.get('RepeatNum') is not None:
            self.repeat_num = m.get('RepeatNum')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        if m.get('VodUrl') is not None:
            self.vod_url = m.get('VodUrl')
        return self


class DescribeCasterVideoResourcesResponseBodyVideoResources(TeaModel):
    def __init__(
        self,
        video_resource: List[DescribeCasterVideoResourcesResponseBodyVideoResourcesVideoResource] = None,
    ):
        self.video_resource = video_resource

    def validate(self):
        if self.video_resource:
            for k in self.video_resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VideoResource'] = []
        if self.video_resource is not None:
            for k in self.video_resource:
                result['VideoResource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.video_resource = []
        if m.get('VideoResource') is not None:
            for k in m.get('VideoResource'):
                temp_model = DescribeCasterVideoResourcesResponseBodyVideoResourcesVideoResource()
                self.video_resource.append(temp_model.from_map(k))
        return self


class DescribeCasterVideoResourcesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        total: int = None,
        video_resources: DescribeCasterVideoResourcesResponseBodyVideoResources = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The total number of returned entries.
        self.total = total
        # The input sources.
        self.video_resources = video_resources

    def validate(self):
        if self.video_resources:
            self.video_resources.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        if self.video_resources is not None:
            result['VideoResources'] = self.video_resources.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('VideoResources') is not None:
            temp_model = DescribeCasterVideoResourcesResponseBodyVideoResources()
            self.video_resources = temp_model.from_map(m['VideoResources'])
        return self


class DescribeCasterVideoResourcesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCasterVideoResourcesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCasterVideoResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCastersRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The key of the tag.
        self.key = key
        # The value of the tag.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeCastersRequest(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        caster_name: str = None,
        charge_type: int = None,
        end_time: str = None,
        norm_type: str = None,
        order_by_modify_asc: str = None,
        owner_id: int = None,
        page_num: int = None,
        page_size: int = None,
        region_id: str = None,
        resource_group_id: str = None,
        start_time: str = None,
        status: int = None,
        tag: List[DescribeCastersRequestTag] = None,
    ):
        # The ID of the production studio.
        # 
        # *   If the production studio was created by calling the [CreateCaster](https://help.aliyun.com/document_detail/2848012.html) operation, check the value of the response parameter CasterId to obtain the ID.
        # *   If the production studio was created by using the ApsaraVideo Live console, obtain the ID on the **Production Studio Management** page. To go to the page, log on to the ApsaraVideo Live console and click Production Studios in the left-side navigation pane.
        # 
        # > 
        # 
        # *   You can find the ID of the production studio in the Instance ID/Name column.
        # 
        # *   If you leave this parameter empty, the data of all production studios is returned.
        self.caster_id = caster_id
        # The name of the production studio.
        self.caster_name = caster_name
        # The billing method. Valid values:
        # 
        # *   0: the subscription billing method
        # *   1: the pay-as-you-go billing method
        self.charge_type = charge_type
        # The end of the time range to query. Specify the time in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.end_time = end_time
        # The type of the production studio. Valid values:
        # 
        # *   1: general mode
        # *   3: lightweight carousel playback mode
        # *   4: virtual studio
        # *   6: playlist mode
        self.norm_type = norm_type
        # Specifies whether to sort the production studios in ascending order based on the modification time.
        # 
        # >  If you leave this parameter empty, the default value is used. Default value: false.
        self.order_by_modify_asc = order_by_modify_asc
        self.owner_id = owner_id
        # The number of the page to return.
        self.page_num = page_num
        # The number of templates to return on each page. If you leave this parameter empty, the default value is used. Default value: 100.
        self.page_size = page_size
        self.region_id = region_id
        # The resource group ID. For more information about resource groups, see [Resource groups](https://help.aliyun.com/document_detail/2381067.html).
        self.resource_group_id = resource_group_id
        # The beginning of the time range to query. Specify the time in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time
        # The status of the production studio. Valid values:
        # 
        # *   0: idle
        # *   1: streaming
        self.status = status
        # The tags.
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.caster_name is not None:
            result['CasterName'] = self.caster_name
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.norm_type is not None:
            result['NormType'] = self.norm_type
        if self.order_by_modify_asc is not None:
            result['OrderByModifyAsc'] = self.order_by_modify_asc
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('CasterName') is not None:
            self.caster_name = m.get('CasterName')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('NormType') is not None:
            self.norm_type = m.get('NormType')
        if m.get('OrderByModifyAsc') is not None:
            self.order_by_modify_asc = m.get('OrderByModifyAsc')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeCastersRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeCastersResponseBodyCasterListCasterTagsTag(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # The key of the tag.
        self.tag_key = tag_key
        # The value of the tag.
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class DescribeCastersResponseBodyCasterListCasterTags(TeaModel):
    def __init__(
        self,
        tag: List[DescribeCastersResponseBodyCasterListCasterTagsTag] = None,
    ):
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag = []
        if m.get('tag') is not None:
            for k in m.get('tag'):
                temp_model = DescribeCastersResponseBodyCasterListCasterTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeCastersResponseBodyCasterListCaster(TeaModel):
    def __init__(
        self,
        caster_id: str = None,
        caster_name: str = None,
        caster_template: str = None,
        channel_enable: int = None,
        charge_type: str = None,
        client_token_id: str = None,
        create_time: str = None,
        duration: str = None,
        expire_time: str = None,
        last_modified: str = None,
        norm_type: int = None,
        purchase_time: str = None,
        resource_group_id: str = None,
        start_time: str = None,
        status: int = None,
        tags: DescribeCastersResponseBodyCasterListCasterTags = None,
    ):
        # The ID of the production studio. You can specify the ID in a request to query the streaming URLs of the production studio, start the production studio, add a video resource, a layout, a component, or a playlist to the production studio, or query layouts of the production studio.
        self.caster_id = caster_id
        # The name of the production studio.
        self.caster_name = caster_name
        # The resolution in which the production studio plays videos. This parameter is returned if the subscription billing method is used. Valid values:
        # 
        # *   lp_ld: low definition
        # *   lp_sd: standard definition
        # *   lp_hd: high definition
        # *   lp_ud: ultra high definition.
        # *   lp_ld_v: low definition (portrait mode)
        # *   lp_sd_v: standard definition (portrait mode)
        # *   lp_hd_v: high definition (portrait mode)
        # *   lp_ud_v: ultra high definition (portrait mode)
        self.caster_template = caster_template
        # Indicates whether the channel is enabled for the production studio.
        # 
        # *   0: The channel is disabled.
        # *   1: The channel is enabled.
        self.channel_enable = channel_enable
        # The billing method. Valid values:
        # 
        # *   PrePaid: the subscription billing method
        # *   PostPaid: the pay-as-you-go billing method
        self.charge_type = charge_type
        # The client token that is used to ensure the idempotence of the request.
        self.client_token_id = client_token_id
        # The time when the production studio was created.
        self.create_time = create_time
        # The streaming duration. Format: hh:mm:ss.
        self.duration = duration
        # The time when the production studio expires.
        self.expire_time = expire_time
        # The time when the production studio was last modified. For example, the time when the production studio was last started, stopped, or modified is returned.
        self.last_modified = last_modified
        # The type of the production studio. Valid values:
        # 
        # *   0: playlist mode
        # *   1: general mode
        self.norm_type = norm_type
        # The time when the production studio was purchased.
        self.purchase_time = purchase_time
        # The resource group ID. For more information about resource groups, see [Resource groups](https://help.aliyun.com/document_detail/2381067.html).
        self.resource_group_id = resource_group_id
        # The time when the production studio was started. This parameter is returned if the production studio is in the streaming status.
        self.start_time = start_time
        # The status of the production studio. Valid values:
        # 
        # *   0: idle
        # *   1: streaming
        self.status = status
        # The tags.
        self.tags = tags

    def validate(self):
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.caster_name is not None:
            result['CasterName'] = self.caster_name
        if self.caster_template is not None:
            result['CasterTemplate'] = self.caster_template
        if self.channel_enable is not None:
            result['ChannelEnable'] = self.channel_enable
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.client_token_id is not None:
            result['ClientTokenId'] = self.client_token_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.last_modified is not None:
            result['LastModified'] = self.last_modified
        if self.norm_type is not None:
            result['NormType'] = self.norm_type
        if self.purchase_time is not None:
            result['PurchaseTime'] = self.purchase_time
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('CasterName') is not None:
            self.caster_name = m.get('CasterName')
        if m.get('CasterTemplate') is not None:
            self.caster_template = m.get('CasterTemplate')
        if m.get('ChannelEnable') is not None:
            self.channel_enable = m.get('ChannelEnable')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('ClientTokenId') is not None:
            self.client_token_id = m.get('ClientTokenId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('LastModified') is not None:
            self.last_modified = m.get('LastModified')
        if m.get('NormType') is not None:
            self.norm_type = m.get('NormType')
        if m.get('PurchaseTime') is not None:
            self.purchase_time = m.get('PurchaseTime')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tags') is not None:
            temp_model = DescribeCastersResponseBodyCasterListCasterTags()
            self.tags = temp_model.from_map(m['Tags'])
        return self


class DescribeCastersResponseBodyCasterList(TeaModel):
    def __init__(
        self,
        caster: List[DescribeCastersResponseBodyCasterListCaster] = None,
    ):
        self.caster = caster

    def validate(self):
        if self.caster:
            for k in self.caster:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Caster'] = []
        if self.caster is not None:
            for k in self.caster:
                result['Caster'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.caster = []
        if m.get('Caster') is not None:
            for k in m.get('Caster'):
                temp_model = DescribeCastersResponseBodyCasterListCaster()
                self.caster.append(temp_model.from_map(k))
        return self


class DescribeCastersResponseBody(TeaModel):
    def __init__(
        self,
        caster_list: DescribeCastersResponseBodyCasterList = None,
        request_id: str = None,
        total: int = None,
    ):
        # The production studios.
        self.caster_list = caster_list
        # The request ID.
        self.request_id = request_id
        # The number of production studios.
        self.total = total

    def validate(self):
        if self.caster_list:
            self.caster_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_list is not None:
            result['CasterList'] = self.caster_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CasterList') is not None:
            temp_model = DescribeCastersResponseBodyCasterList()
            self.caster_list = temp_model.from_map(m['CasterList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeCastersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCastersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCastersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeChannelParticipantsRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        channel_id: str = None,
        order: str = None,
        page_num: int = None,
        page_size: int = None,
    ):
        # The ID of the application. You can specify only one application ID.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The ID of the channel. You can specify only one channel ID.
        # 
        # This parameter is required.
        self.channel_id = channel_id
        # The sort order. Valid values:
        # 
        # *   **asc**: ascending order.
        # *   **desc**: descending order. This is the default value.
        self.order = order
        # The number of the page to return. Default value: 1.
        self.page_num = page_num
        # The number of entries to return on each page. Default value: 10.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.order is not None:
            result['Order'] = self.order
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeChannelParticipantsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        times: int = None,
        total_num: int = None,
        total_page: int = None,
        user_list: List[str] = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The time elapsed until the result was returned. Unit: seconds. The value is a UNIX timestamp.
        self.times = times
        # The number of entries returned.
        self.total_num = total_num
        # The page number of the returned page.
        self.total_page = total_page
        # The list of user IDs.
        self.user_list = user_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.times is not None:
            result['Times'] = self.times
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        if self.user_list is not None:
            result['UserList'] = self.user_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        if m.get('UserList') is not None:
            self.user_list = m.get('UserList')
        return self


class DescribeChannelParticipantsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeChannelParticipantsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeChannelParticipantsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeChannelUsersRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        channel_id: str = None,
    ):
        # The application ID. You can specify only one application ID in a request.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The channel ID. You can specify only one channel ID in a request.
        # 
        # This parameter is required.
        self.channel_id = channel_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        return self


class DescribeChannelUsersResponseBody(TeaModel):
    def __init__(
        self,
        interactive_user_list: List[str] = None,
        interactive_user_number: int = None,
        is_channel_exists: bool = None,
        live_user_list: List[str] = None,
        live_user_number: int = None,
        request_id: str = None,
        timestamp: int = None,
    ):
        # The list of streamers/co-streamers.
        self.interactive_user_list = interactive_user_list
        # The number of co-streamers.
        self.interactive_user_number = interactive_user_number
        # Indicates whether the channel exists. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        # 
        # > After all users leave the channel, the system requires a few seconds to clear the cache. If you call the operation during this period, the value of this parameter is true, and the value of InteractiveUserNumber and LiveUserNumber is 0.
        self.is_channel_exists = is_channel_exists
        # The list of viewers.
        self.live_user_list = live_user_list
        # The number of viewers.
        self.live_user_number = live_user_number
        # The ID of the request.
        self.request_id = request_id
        # The UTC timestamp when the response is returned.
        self.timestamp = timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.interactive_user_list is not None:
            result['InteractiveUserList'] = self.interactive_user_list
        if self.interactive_user_number is not None:
            result['InteractiveUserNumber'] = self.interactive_user_number
        if self.is_channel_exists is not None:
            result['IsChannelExists'] = self.is_channel_exists
        if self.live_user_list is not None:
            result['LiveUserList'] = self.live_user_list
        if self.live_user_number is not None:
            result['LiveUserNumber'] = self.live_user_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InteractiveUserList') is not None:
            self.interactive_user_list = m.get('InteractiveUserList')
        if m.get('InteractiveUserNumber') is not None:
            self.interactive_user_number = m.get('InteractiveUserNumber')
        if m.get('IsChannelExists') is not None:
            self.is_channel_exists = m.get('IsChannelExists')
        if m.get('LiveUserList') is not None:
            self.live_user_list = m.get('LiveUserList')
        if m.get('LiveUserNumber') is not None:
            self.live_user_number = m.get('LiveUserNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class DescribeChannelUsersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeChannelUsersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeChannelUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainUsageDataRequest(TeaModel):
    def __init__(
        self,
        area: str = None,
        data_protocol: str = None,
        domain_name: str = None,
        end_time: str = None,
        field: str = None,
        interval: str = None,
        owner_id: int = None,
        region_id: str = None,
        start_time: str = None,
        type: str = None,
    ):
        # The billable region. Valid values:
        # 
        # *   **CN**: Chinese mainland
        # *   **OverSeas**: outside the Chinese mainland
        # *   **AP1**: Asia Pacific 1
        # *   **AP2**: Asia Pacific 2
        # *   **AP3**: Asia Pacific 3
        # *   **NA**: North America
        # *   **SA**: South America
        # *   **EU**: Europe
        # *   **MEAA**: Middle East and Africa
        # *   **all**: all regions
        # 
        # >  If you do not specify this parameter, the default value CN is used. Alibaba Cloud supports the following countries and regions outside the Chinese mainland: - Asia Pacific 1: Hong Kong (China), Macao (China), Taiwan (China), Japan, and Southeast Asia excluding Vietnam and Indonesia. - Asia Pacific 2: Indonesia, South Korea, and Vietnam. - Asia Pacific 3: Australia and New Zealand. - North America: US and Canada. - South America: Brazil. Europe: Ukraine, UK, France, Netherlands, Spain, Italy, Sweden, and Germany. - Middle East and Africa: South Africa, Oman, UAE, and Kuwait.
        self.area = area
        # The protocol of the data to query. Valid values:
        # 
        # *   **http**: HTTP
        # *   **https**: HTTPS
        # *   **quic**: QUIC
        # *   **all** (default): HTTP, HTTPS, and QUIC
        self.data_protocol = data_protocol
        # The domain name.
        # 
        # *   You can query one or more domain names. If you specify multiple domain names, separate them with commas (,).
        # *   If you leave this parameter empty, the data of all domain names within your Alibaba Cloud account is returned.
        self.domain_name = domain_name
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        # 
        # The end time must be later than the start time. The maximum time range that you can specify is **31** days.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The category of the resource usage data to query. Valid values:
        # 
        # *   **bps**: streaming bandwidth
        # *   **traf**: streaming traffic
        # *   **req_traf**: stream ingest traffic if you set Type to push, or stream relay traffic if you set Type to push_proxy
        # *   **req_bps**: stream ingest bandwidth if you set Type to push, or stream relay bandwidth if you set Type to push_proxy
        # 
        # This parameter is required.
        self.field = field
        # The time interval between the data entries to return. Unit: seconds. Valid values: **300** (5 minutes), **3600** (1 hour), and **86400** (1 day).
        self.interval = interval
        self.owner_id = owner_id
        self.region_id = region_id
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        # 
        # This parameter is required.
        self.start_time = start_time
        # The type of the resource usage data to query.
        # 
        # Valid values if you set **Field** to **bps** or **traf**:
        # 
        # *   **rts**: bandwidth or traffic for Real-Time Streaming (RTS)
        # *   **quic**: bandwidth or traffic for QUIC
        # *   **all**: all bandwidth or traffic
        # 
        # Valid values if you set **Field** to **req_traf** or **req_bps**:
        # 
        # *   **push**: stream ingest bandwidth or traffic
        # *   **push_proxy**: stream relay bandwidth or traffic
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.area is not None:
            result['Area'] = self.area
        if self.data_protocol is not None:
            result['DataProtocol'] = self.data_protocol
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.field is not None:
            result['Field'] = self.field
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Area') is not None:
            self.area = m.get('Area')
        if m.get('DataProtocol') is not None:
            self.data_protocol = m.get('DataProtocol')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Field') is not None:
            self.field = m.get('Field')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeDomainUsageDataResponseBodyUsageDataPerIntervalDataModule(TeaModel):
    def __init__(
        self,
        time_stamp: str = None,
        value: str = None,
    ):
        # The timestamp of the returned data. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.time_stamp = time_stamp
        # The amount of resource usage.
        # 
        # *   If the value of the Field parameter is traf or req_traf, the returned data is measured in bytes.
        # *   If the value of the Field parameter is bps or req_bps, the returned data is measured in bit/s.
        # *   If the value of the Field parameter is acc, the returned data is measured by count.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDomainUsageDataResponseBodyUsageDataPerInterval(TeaModel):
    def __init__(
        self,
        data_module: List[DescribeDomainUsageDataResponseBodyUsageDataPerIntervalDataModule] = None,
    ):
        self.data_module = data_module

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeDomainUsageDataResponseBodyUsageDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeDomainUsageDataResponseBody(TeaModel):
    def __init__(
        self,
        area: str = None,
        data_interval: str = None,
        domain_name: str = None,
        end_time: str = None,
        request_id: str = None,
        start_time: str = None,
        type: str = None,
        usage_data_per_interval: DescribeDomainUsageDataResponseBodyUsageDataPerInterval = None,
    ):
        # The billable region where the resource usage data was generated.
        self.area = area
        # The time interval between the returned entries. Unit: seconds.
        self.data_interval = data_interval
        # The domain name.
        self.domain_name = domain_name
        # The end of the time range for which the resource usage data was queried. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.end_time = end_time
        # The ID of the request.
        self.request_id = request_id
        # The beginning of the time range for which the resource usage data was queried. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        self.start_time = start_time
        # The type of the resource usage data.
        self.type = type
        # The resource usage data that was collected for each time interval.
        self.usage_data_per_interval = usage_data_per_interval

    def validate(self):
        if self.usage_data_per_interval:
            self.usage_data_per_interval.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.area is not None:
            result['Area'] = self.area
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.type is not None:
            result['Type'] = self.type
        if self.usage_data_per_interval is not None:
            result['UsageDataPerInterval'] = self.usage_data_per_interval.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Area') is not None:
            self.area = m.get('Area')
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UsageDataPerInterval') is not None:
            temp_model = DescribeDomainUsageDataResponseBodyUsageDataPerInterval()
            self.usage_data_per_interval = temp_model.from_map(m['UsageDataPerInterval'])
        return self


class DescribeDomainUsageDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDomainUsageDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDomainUsageDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainWithIntegrityRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        integrity: float = None,
        owner_id: int = None,
        region_id: str = None,
        start_time: str = None,
    ):
        # The end of the time range to query. The end time must be later than the start time. Specify the time in the ISO 8601 standard. The time must be in UTC.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The integrity.
        # 
        # This parameter is required.
        self.integrity = integrity
        self.owner_id = owner_id
        self.region_id = region_id
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard. The time must be in UTC.
        # 
        # This parameter is required.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.integrity is not None:
            result['Integrity'] = self.integrity
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Integrity') is not None:
            self.integrity = m.get('Integrity')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDomainWithIntegrityResponseBodyContent(TeaModel):
    def __init__(
        self,
        columns: List[str] = None,
        name: str = None,
        points: List[str] = None,
    ):
        # The column names.
        self.columns = columns
        # The table name.
        self.name = name
        # The subpoints.
        self.points = points

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.columns is not None:
            result['Columns'] = self.columns
        if self.name is not None:
            result['Name'] = self.name
        if self.points is not None:
            result['Points'] = self.points
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Columns') is not None:
            self.columns = m.get('Columns')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Points') is not None:
            self.points = m.get('Points')
        return self


class DescribeDomainWithIntegrityResponseBody(TeaModel):
    def __init__(
        self,
        content: List[DescribeDomainWithIntegrityResponseBodyContent] = None,
        request_id: str = None,
    ):
        # The verification information.
        self.content = content
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.content:
            for k in self.content:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Content'] = []
        if self.content is not None:
            for k in self.content:
                result['Content'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.content = []
        if m.get('Content') is not None:
            for k in m.get('Content'):
                temp_model = DescribeDomainWithIntegrityResponseBodyContent()
                self.content.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDomainWithIntegrityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDomainWithIntegrityResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDomainWithIntegrityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHlsLiveStreamRealTimeBpsDataRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        owner_id: int = None,
        region_id: str = None,
        time: str = None,
    ):
        # The domain names to query. Separate them with commas (,). A domain name cannot contain double-byte characters.
        self.domain_name = domain_name
        self.owner_id = owner_id
        self.region_id = region_id
        # The timestamp.
        # 
        # This parameter is required.
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageDataStreamInfosInfos(TeaModel):
    def __init__(
        self,
        down_flow: float = None,
        online: float = None,
        rate: str = None,
    ):
        # The bandwidth. Unit: bit/s.
        self.down_flow = down_flow
        # The number of online users.
        self.online = online
        # The bitrate.
        self.rate = rate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.down_flow is not None:
            result['DownFlow'] = self.down_flow
        if self.online is not None:
            result['Online'] = self.online
        if self.rate is not None:
            result['Rate'] = self.rate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DownFlow') is not None:
            self.down_flow = m.get('DownFlow')
        if m.get('Online') is not None:
            self.online = m.get('Online')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        return self


class DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageDataStreamInfos(TeaModel):
    def __init__(
        self,
        infos: List[DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageDataStreamInfosInfos] = None,
        stream_name: str = None,
    ):
        # The statistics on the HLS stream.
        self.infos = infos
        # The name of the stream.
        self.stream_name = stream_name

    def validate(self):
        if self.infos:
            for k in self.infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Infos'] = []
        if self.infos is not None:
            for k in self.infos:
                result['Infos'].append(k.to_map() if k else None)
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.infos = []
        if m.get('Infos') is not None:
            for k in m.get('Infos'):
                temp_model = DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageDataStreamInfosInfos()
                self.infos.append(temp_model.from_map(k))
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageData(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        stream_infos: List[DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageDataStreamInfos] = None,
    ):
        # The domain name.
        self.domain_name = domain_name
        # Details about the statistics on each HLS stream under the domain name.
        self.stream_infos = stream_infos

    def validate(self):
        if self.stream_infos:
            for k in self.stream_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        result['StreamInfos'] = []
        if self.stream_infos is not None:
            for k in self.stream_infos:
                result['StreamInfos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        self.stream_infos = []
        if m.get('StreamInfos') is not None:
            for k in m.get('StreamInfos'):
                temp_model = DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageDataStreamInfos()
                self.stream_infos.append(temp_model.from_map(k))
        return self


class DescribeHlsLiveStreamRealTimeBpsDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        time: str = None,
        usage_data: List[DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageData] = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The timestamp for which the data was queried.
        self.time = time
        # The usage data.
        self.usage_data = usage_data

    def validate(self):
        if self.usage_data:
            for k in self.usage_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.time is not None:
            result['Time'] = self.time
        result['UsageData'] = []
        if self.usage_data is not None:
            for k in self.usage_data:
                result['UsageData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        self.usage_data = []
        if m.get('UsageData') is not None:
            for k in m.get('UsageData'):
                temp_model = DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageData()
                self.usage_data.append(temp_model.from_map(k))
        return self


class DescribeHlsLiveStreamRealTimeBpsDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeHlsLiveStreamRealTimeBpsDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHlsLiveStreamRealTimeBpsDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveAIProduceRulesRequest(TeaModel):
    def __init__(
        self,
        app: str = None,
        domain: str = None,
        owner_id: int = None,
        page_number: str = None,
        page_size: str = None,
        region_id: str = None,
        rules_id: str = None,
        suffix_name: str = None,
    ):
        # The name of the application to which the live stream belongs.
        self.app = app
        # The main streaming domain.
        self.domain = domain
        self.owner_id = owner_id
        # The page number. Valid values: [1,100].
        self.page_number = page_number
        # The number of entries per page. Valid values: [1,100].
        self.page_size = page_size
        self.region_id = region_id
        # The ID of the subtitle rule.
        self.rules_id = rules_id
        # The suffix of the subtitle rule.
        # 
        # > Set the value to the name of the subtitle template.
        self.suffix_name = suffix_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app is not None:
            result['App'] = self.app
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rules_id is not None:
            result['RulesId'] = self.rules_id
        if self.suffix_name is not None:
            result['SuffixName'] = self.suffix_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RulesId') is not None:
            self.rules_id = m.get('RulesId')
        if m.get('SuffixName') is not None:
            self.suffix_name = m.get('SuffixName')
        return self


class DescribeLiveAIProduceRulesResponseBodyRuleInfoListRuleInfo(TeaModel):
    def __init__(
        self,
        app: str = None,
        description: str = None,
        domain: str = None,
        gmt_modify_time: str = None,
        is_lazy: bool = None,
        live_template: str = None,
        rules_id: str = None,
        studio_name: str = None,
        subtitle_name: str = None,
        suffix_name: str = None,
    ):
        # The name of the application to which the live stream belongs.
        self.app = app
        # The description of the rule.
        self.description = description
        # The streaming domain.
        self.domain = domain
        # The last time when the rule was modified. The value is a timestamp.
        self.gmt_modify_time = gmt_modify_time
        # Indicates whether the rule takes effect when stream pulling starts.
        self.is_lazy = is_lazy
        # The specification of the exported subtitles.
        self.live_template = live_template
        # The ID of the subtitle rule.
        self.rules_id = rules_id
        # The name of the virtual background template.
        self.studio_name = studio_name
        # The name of the subtitle template.
        self.subtitle_name = subtitle_name
        # The suffix of the subtitle rule.
        self.suffix_name = suffix_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app is not None:
            result['App'] = self.app
        if self.description is not None:
            result['Description'] = self.description
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.gmt_modify_time is not None:
            result['GmtModifyTime'] = self.gmt_modify_time
        if self.is_lazy is not None:
            result['IsLazy'] = self.is_lazy
        if self.live_template is not None:
            result['LiveTemplate'] = self.live_template
        if self.rules_id is not None:
            result['RulesId'] = self.rules_id
        if self.studio_name is not None:
            result['StudioName'] = self.studio_name
        if self.subtitle_name is not None:
            result['SubtitleName'] = self.subtitle_name
        if self.suffix_name is not None:
            result['SuffixName'] = self.suffix_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('GmtModifyTime') is not None:
            self.gmt_modify_time = m.get('GmtModifyTime')
        if m.get('IsLazy') is not None:
            self.is_lazy = m.get('IsLazy')
        if m.get('LiveTemplate') is not None:
            self.live_template = m.get('LiveTemplate')
        if m.get('RulesId') is not None:
            self.rules_id = m.get('RulesId')
        if m.get('StudioName') is not None:
            self.studio_name = m.get('StudioName')
        if m.get('SubtitleName') is not None:
            self.subtitle_name = m.get('SubtitleName')
        if m.get('SuffixName') is not None:
            self.suffix_name = m.get('SuffixName')
        return self


class DescribeLiveAIProduceRulesResponseBodyRuleInfoList(TeaModel):
    def __init__(
        self,
        rule_info: List[DescribeLiveAIProduceRulesResponseBodyRuleInfoListRuleInfo] = None,
    ):
        self.rule_info = rule_info

    def validate(self):
        if self.rule_info:
            for k in self.rule_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RuleInfo'] = []
        if self.rule_info is not None:
            for k in self.rule_info:
                result['RuleInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.rule_info = []
        if m.get('RuleInfo') is not None:
            for k in m.get('RuleInfo'):
                temp_model = DescribeLiveAIProduceRulesResponseBodyRuleInfoListRuleInfo()
                self.rule_info.append(temp_model.from_map(k))
        return self


class DescribeLiveAIProduceRulesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        rule_info_list: DescribeLiveAIProduceRulesResponseBodyRuleInfoList = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The subtitle rules.
        self.rule_info_list = rule_info_list

    def validate(self):
        if self.rule_info_list:
            self.rule_info_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rule_info_list is not None:
            result['RuleInfoList'] = self.rule_info_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RuleInfoList') is not None:
            temp_model = DescribeLiveAIProduceRulesResponseBodyRuleInfoList()
            self.rule_info_list = temp_model.from_map(m['RuleInfoList'])
        return self


class DescribeLiveAIProduceRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeLiveAIProduceRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveAIProduceRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveAIStudioRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        studio_id: str = None,
        studio_name: str = None,
    ):
        self.owner_id = owner_id
        # The page number. Default value: **1**.
        self.page_number = page_number
        # The number of entries per page. Default value: 10. Valid values: 1 to 50.
        self.page_size = page_size
        self.region_id = region_id
        # The ID of the virtual studio template that you want to query. This parameter is optional.
        self.studio_id = studio_id
        # The name of the virtual studio template.
        self.studio_name = studio_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.studio_id is not None:
            result['StudioId'] = self.studio_id
        if self.studio_name is not None:
            result['StudioName'] = self.studio_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StudioId') is not None:
            self.studio_id = m.get('StudioId')
        if m.get('StudioName') is not None:
            self.studio_name = m.get('StudioName')
        return self


class DescribeLiveAIStudioResponseBodyStudioConfigsSubtitleConfigRuleIds(TeaModel):
    def __init__(
        self,
        rule_id: List[str] = None,
    ):
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['ruleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ruleId') is not None:
            self.rule_id = m.get('ruleId')
        return self


class DescribeLiveAIStudioResponseBodyStudioConfigsSubtitleConfig(TeaModel):
    def __init__(
        self,
        background_resource_id: str = None,
        background_resource_url: str = None,
        background_type: str = None,
        description: str = None,
        height: str = None,
        matting_layout: str = None,
        matting_type: str = None,
        media_layout: str = None,
        media_resource_id: str = None,
        media_resource_url: str = None,
        media_type: str = None,
        rule_ids: DescribeLiveAIStudioResponseBodyStudioConfigsSubtitleConfigRuleIds = None,
        template_id: str = None,
        template_name: str = None,
        width: str = None,
    ):
        # The ID of the background material.
        self.background_resource_id = background_resource_id
        # The URL of the background material. Make sure that the URL is accessible over the Internet. Either this parameter or the BackgroundResourceId parameter is returned.
        self.background_resource_url = background_resource_url
        # The type of the background material. Valid values:
        # 
        # *   VOD: a video in ApsaraVideo VOD
        # *   PIC: an image
        # *   LIVE: a live stream
        self.background_type = background_type
        # The custom description.
        self.description = description
        # The preview height. Unit: pixels.
        # 
        # The following preview specifications (width × height) are supported:
        # 
        # *   Landscape low definition 360p (640×360)
        # *   Portrait low definition 360p (360×640)
        # *   Landscape standard definition 480p (854×480)
        # *   Portrait standard definition 480p (480×854)
        # *   Landscape high definition 720p (1280×720)
        # *   Portrait high definition 720p (720×1280)
        # *   Landscape ultra-high definition 1080p (1920×1080)
        # *   Portrait ultra-high definition 1080p (1080×1920)
        self.height = height
        # The layout information of the multimedia material.
        self.matting_layout = matting_layout
        # The type of chroma key that is performed on ingested streams. Valid values:
        # 
        # *   green: green-key chroma key
        # *   blue: blue-screen chroma key
        # *   complex: background replacement
        self.matting_type = matting_type
        # LIVE, live streaming
        self.media_layout = media_layout
        # The ID of the multimedia material in ApsaraVideo VOD.
        self.media_resource_id = media_resource_id
        # The URL of the multimedia material.
        self.media_resource_url = media_resource_url
        # The type of the multimedia material. Valid values:
        # 
        # *   VOD: a video in ApsaraVideo VOD
        # *   PIC: an image
        # *   LIVE: a live stream
        self.media_type = media_type
        # The IDs of the bound rules.
        self.rule_ids = rule_ids
        # The ID of the virtual studio template.
        self.template_id = template_id
        # The name of the virtual studio template. The name is the same as the value of the StudioName parameter that was specified when you called the CreateLiveAiStudio operation to create the virtual studio template.
        self.template_name = template_name
        # The preview width.
        self.width = width

    def validate(self):
        if self.rule_ids:
            self.rule_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.background_resource_id is not None:
            result['BackgroundResourceId'] = self.background_resource_id
        if self.background_resource_url is not None:
            result['BackgroundResourceUrl'] = self.background_resource_url
        if self.background_type is not None:
            result['BackgroundType'] = self.background_type
        if self.description is not None:
            result['Description'] = self.description
        if self.height is not None:
            result['Height'] = self.height
        if self.matting_layout is not None:
            result['MattingLayout'] = self.matting_layout
        if self.matting_type is not None:
            result['MattingType'] = self.matting_type
        if self.media_layout is not None:
            result['MediaLayout'] = self.media_layout
        if self.media_resource_id is not None:
            result['MediaResourceId'] = self.media_resource_id
        if self.media_resource_url is not None:
            result['MediaResourceUrl'] = self.media_resource_url
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.rule_ids is not None:
            result['RuleIds'] = self.rule_ids.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackgroundResourceId') is not None:
            self.background_resource_id = m.get('BackgroundResourceId')
        if m.get('BackgroundResourceUrl') is not None:
            self.background_resource_url = m.get('BackgroundResourceUrl')
        if m.get('BackgroundType') is not None:
            self.background_type = m.get('BackgroundType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MattingLayout') is not None:
            self.matting_layout = m.get('MattingLayout')
        if m.get('MattingType') is not None:
            self.matting_type = m.get('MattingType')
        if m.get('MediaLayout') is not None:
            self.media_layout = m.get('MediaLayout')
        if m.get('MediaResourceId') is not None:
            self.media_resource_id = m.get('MediaResourceId')
        if m.get('MediaResourceUrl') is not None:
            self.media_resource_url = m.get('MediaResourceUrl')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('RuleIds') is not None:
            temp_model = DescribeLiveAIStudioResponseBodyStudioConfigsSubtitleConfigRuleIds()
            self.rule_ids = temp_model.from_map(m['RuleIds'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class DescribeLiveAIStudioResponseBodyStudioConfigs(TeaModel):
    def __init__(
        self,
        subtitle_config: List[DescribeLiveAIStudioResponseBodyStudioConfigsSubtitleConfig] = None,
    ):
        self.subtitle_config = subtitle_config

    def validate(self):
        if self.subtitle_config:
            for k in self.subtitle_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SubtitleConfig'] = []
        if self.subtitle_config is not None:
            for k in self.subtitle_config:
                result['SubtitleConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.subtitle_config = []
        if m.get('SubtitleConfig') is not None:
            for k in m.get('SubtitleConfig'):
                temp_model = DescribeLiveAIStudioResponseBodyStudioConfigsSubtitleConfig()
                self.subtitle_config.append(temp_model.from_map(k))
        return self


class DescribeLiveAIStudioResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        studio_configs: DescribeLiveAIStudioResponseBodyStudioConfigs = None,
        total: int = None,
    ):
        # The page number.
        self.page_number = page_number
        # The number of entries per page. Default value: 10. Valid values: 1 to 50.
        self.page_size = page_size
        # The request ID.
        self.request_id = request_id
        # The virtual studio templates.
        self.studio_configs = studio_configs
        # The total number of templates.
        self.total = total

    def validate(self):
        if self.studio_configs:
            self.studio_configs.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.studio_configs is not None:
            result['StudioConfigs'] = self.studio_configs.to_map()
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StudioConfigs') is not None:
            temp_model = DescribeLiveAIStudioResponseBodyStudioConfigs()
            self.studio_configs = temp_model.from_map(m['StudioConfigs'])
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeLiveAIStudioResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeLiveAIStudioResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveAIStudioResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveAISubtitleRequest(TeaModel):
    def __init__(
        self,
        is_default: bool = None,
        owner_id: int = None,
        page_number: str = None,
        page_size: str = None,
        region_id: str = None,
        subtitle_id: str = None,
        subtitle_name: str = None,
    ):
        # Specifies whether to query the default subtitle template. Valid values:
        # 
        # *   true
        # 
        # *   false
        # 
        #     **\
        # 
        #     **Note **The default template includes the built-in parameter configurations. You can specify the copyFrom parameter when you call the AddLiveAISubtitle operation to use the default template.
        self.is_default = is_default
        self.owner_id = owner_id
        # The page number. Valid values: [1,100].
        self.page_number = page_number
        # The number of entries per page. Valid values: [1,100].
        self.page_size = page_size
        self.region_id = region_id
        # The ID of the subtitle template.
        self.subtitle_id = subtitle_id
        # The name of the subtitle template. The name can contain only digits, letters, and hyphens (-). The name cannot start with a hyphen.
        self.subtitle_name = subtitle_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.subtitle_id is not None:
            result['SubtitleId'] = self.subtitle_id
        if self.subtitle_name is not None:
            result['SubtitleName'] = self.subtitle_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SubtitleId') is not None:
            self.subtitle_id = m.get('SubtitleId')
        if m.get('SubtitleName') is not None:
            self.subtitle_name = m.get('SubtitleName')
        return self


class DescribeLiveAISubtitleResponseBodySubtitleConfigsSubtitleConfigPositionNormalized(TeaModel):
    def __init__(
        self,
        position: List[float] = None,
    ):
        self.position = position

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.position is not None:
            result['Position'] = self.position
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Position') is not None:
            self.position = m.get('Position')
        return self


class DescribeLiveAISubtitleResponseBodySubtitleConfigsSubtitleConfigRulesRefer(TeaModel):
    def __init__(
        self,
        rules_id: List[str] = None,
    ):
        self.rules_id = rules_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rules_id is not None:
            result['RulesId'] = self.rules_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RulesId') is not None:
            self.rules_id = m.get('RulesId')
        return self


class DescribeLiveAISubtitleResponseBodySubtitleConfigsSubtitleConfig(TeaModel):
    def __init__(
        self,
        bg_color: str = None,
        bg_width_normalized: float = None,
        border_width_normalized: float = None,
        description: str = None,
        dst_language: str = None,
        font_color: str = None,
        font_name: str = None,
        font_size_normalized: str = None,
        height: str = None,
        max_lines: int = None,
        position_normalized: DescribeLiveAISubtitleResponseBodySubtitleConfigsSubtitleConfigPositionNormalized = None,
        rules_refer: DescribeLiveAISubtitleResponseBodySubtitleConfigsSubtitleConfigRulesRefer = None,
        show_source_lan: int = None,
        src_language: str = None,
        subtitle_id: str = None,
        subtitle_name: str = None,
        width: str = None,
        word_perline: int = None,
    ):
        # The background color of the subtitles.
        self.bg_color = bg_color
        # The size of the background image.
        self.bg_width_normalized = bg_width_normalized
        # The font weight.
        self.border_width_normalized = border_width_normalized
        # The description of the template.
        self.description = description
        # The language to which the subtitles are translated.
        self.dst_language = dst_language
        # The font color.
        self.font_color = font_color
        # The font.
        self.font_name = font_name
        # The font size.
        self.font_size_normalized = font_size_normalized
        # The height of the preview image.
        self.height = height
        # The number of displayed lines.
        self.max_lines = max_lines
        # The position of the subtitles.
        self.position_normalized = position_normalized
        # The ID of the subtitle rule.
        self.rules_refer = rules_refer
        # Indicates whether the source language of the subtitle is displayed.
        self.show_source_lan = show_source_lan
        # The source language of the subtitles.
        self.src_language = src_language
        # The ID of the subtitle template.
        self.subtitle_id = subtitle_id
        # The name of the subtitle template.
        self.subtitle_name = subtitle_name
        # The width of the preview image.
        self.width = width
        # The number of words per line.
        self.word_perline = word_perline

    def validate(self):
        if self.position_normalized:
            self.position_normalized.validate()
        if self.rules_refer:
            self.rules_refer.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bg_color is not None:
            result['BgColor'] = self.bg_color
        if self.bg_width_normalized is not None:
            result['BgWidthNormalized'] = self.bg_width_normalized
        if self.border_width_normalized is not None:
            result['BorderWidthNormalized'] = self.border_width_normalized
        if self.description is not None:
            result['Description'] = self.description
        if self.dst_language is not None:
            result['DstLanguage'] = self.dst_language
        if self.font_color is not None:
            result['FontColor'] = self.font_color
        if self.font_name is not None:
            result['FontName'] = self.font_name
        if self.font_size_normalized is not None:
            result['FontSizeNormalized'] = self.font_size_normalized
        if self.height is not None:
            result['Height'] = self.height
        if self.max_lines is not None:
            result['MaxLines'] = self.max_lines
        if self.position_normalized is not None:
            result['PositionNormalized'] = self.position_normalized.to_map()
        if self.rules_refer is not None:
            result['RulesRefer'] = self.rules_refer.to_map()
        if self.show_source_lan is not None:
            result['ShowSourceLan'] = self.show_source_lan
        if self.src_language is not None:
            result['SrcLanguage'] = self.src_language
        if self.subtitle_id is not None:
            result['SubtitleId'] = self.subtitle_id
        if self.subtitle_name is not None:
            result['SubtitleName'] = self.subtitle_name
        if self.width is not None:
            result['Width'] = self.width
        if self.word_perline is not None:
            result['WordPerline'] = self.word_perline
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BgColor') is not None:
            self.bg_color = m.get('BgColor')
        if m.get('BgWidthNormalized') is not None:
            self.bg_width_normalized = m.get('BgWidthNormalized')
        if m.get('BorderWidthNormalized') is not None:
            self.border_width_normalized = m.get('BorderWidthNormalized')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DstLanguage') is not None:
            self.dst_language = m.get('DstLanguage')
        if m.get('FontColor') is not None:
            self.font_color = m.get('FontColor')
        if m.get('FontName') is not None:
            self.font_name = m.get('FontName')
        if m.get('FontSizeNormalized') is not None:
            self.font_size_normalized = m.get('FontSizeNormalized')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MaxLines') is not None:
            self.max_lines = m.get('MaxLines')
        if m.get('PositionNormalized') is not None:
            temp_model = DescribeLiveAISubtitleResponseBodySubtitleConfigsSubtitleConfigPositionNormalized()
            self.position_normalized = temp_model.from_map(m['PositionNormalized'])
        if m.get('RulesRefer') is not None:
            temp_model = DescribeLiveAISubtitleResponseBodySubtitleConfigsSubtitleConfigRulesRefer()
            self.rules_refer = temp_model.from_map(m['RulesRefer'])
        if m.get('ShowSourceLan') is not None:
            self.show_source_lan = m.get('ShowSourceLan')
        if m.get('SrcLanguage') is not None:
            self.src_language = m.get('SrcLanguage')
        if m.get('SubtitleId') is not None:
            self.subtitle_id = m.get('SubtitleId')
        if m.get('SubtitleName') is not None:
            self.subtitle_name = m.get('SubtitleName')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('WordPerline') is not None:
            self.word_perline = m.get('WordPerline')
        return self


class DescribeLiveAISubtitleResponseBodySubtitleConfigs(TeaModel):
    def __init__(
        self,
        subtitle_config: List[DescribeLiveAISubtitleResponseBodySubtitleConfigsSubtitleConfig] = None,
    ):
        self.subtitle_config = subtitle_config

    def validate(self):
        if self.subtitle_config:
            for k in self.subtitle_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SubtitleConfig'] = []
        if self.subtitle_config is not None:
            for k in self.subtitle_config:
                result['SubtitleConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.subtitle_config = []
        if m.get('SubtitleConfig') is not None:
            for k in m.get('SubtitleConfig'):
                temp_model = DescribeLiveAISubtitleResponseBodySubtitleConfigsSubtitleConfig()
                self.subtitle_config.append(temp_model.from_map(k))
        return self


class DescribeLiveAISubtitleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        subtitle_configs: DescribeLiveAISubtitleResponseBodySubtitleConfigs = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The information about the subtitle templates.
        self.subtitle_configs = subtitle_configs

    def validate(self):
        if self.subtitle_configs:
            self.subtitle_configs.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.subtitle_configs is not None:
            result['SubtitleConfigs'] = self.subtitle_configs.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SubtitleConfigs') is not None:
            temp_model = DescribeLiveAISubtitleResponseBodySubtitleConfigs()
            self.subtitle_configs = temp_model.from_map(m['SubtitleConfigs'])
        return self


class DescribeLiveAISubtitleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeLiveAISubtitleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveAISubtitleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveAudioAuditConfigRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        owner_id: int = None,
        region_id: str = None,
        stream_name: str = None,
    ):
        # The name of the application to which the live stream belongs.
        self.app_name = app_name
        # The main streaming domain.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        self.owner_id = owner_id
        self.region_id = region_id
        # The name of the live stream.
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigListLiveAudioAuditConfigScenes(TeaModel):
    def __init__(
        self,
        scene: List[str] = None,
    ):
        self.scene = scene

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scene is not None:
            result['scene'] = self.scene
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('scene') is not None:
            self.scene = m.get('scene')
        return self


class DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigListLiveAudioAuditConfig(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        biz_type: str = None,
        domain_name: str = None,
        scenes: DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigListLiveAudioAuditConfigScenes = None,
        stream_name: str = None,
    ):
        # The name of the application to which the live stream belongs.
        self.app_name = app_name
        # The business type. You can specify a model. The default value is the domain name.
        self.biz_type = biz_type
        # The main streaming domain.
        self.domain_name = domain_name
        # The moderation scenarios.
        self.scenes = scenes
        # The name of the live stream.
        self.stream_name = stream_name

    def validate(self):
        if self.scenes:
            self.scenes.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.scenes is not None:
            result['Scenes'] = self.scenes.to_map()
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Scenes') is not None:
            temp_model = DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigListLiveAudioAuditConfigScenes()
            self.scenes = temp_model.from_map(m['Scenes'])
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigList(TeaModel):
    def __init__(
        self,
        live_audio_audit_config: List[DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigListLiveAudioAuditConfig] = None,
    ):
        self.live_audio_audit_config = live_audio_audit_config

    def validate(self):
        if self.live_audio_audit_config:
            for k in self.live_audio_audit_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LiveAudioAuditConfig'] = []
        if self.live_audio_audit_config is not None:
            for k in self.live_audio_audit_config:
                result['LiveAudioAuditConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.live_audio_audit_config = []
        if m.get('LiveAudioAuditConfig') is not None:
            for k in m.get('LiveAudioAuditConfig'):
                temp_model = DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigListLiveAudioAuditConfig()
                self.live_audio_audit_config.append(temp_model.from_map(k))
        return self


class DescribeLiveAudioAuditConfigResponseBody(TeaModel):
    def __init__(
        self,
        live_audio_audit_config_list: DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigList = None,
        request_id: str = None,
    ):
        # The list of audio moderation configurations.
        self.live_audio_audit_config_list = live_audio_audit_config_list
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.live_audio_audit_config_list:
            self.live_audio_audit_config_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_audio_audit_config_list is not None:
            result['LiveAudioAuditConfigList'] = self.live_audio_audit_config_list.to_map()
        i