# MIOFlow

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

## Setup

Create conda environment

``` bash
$ conda create -n mioflow python=3.10
$ conda activate mioflow
```

install pytorch according to instructions
https://pytorch.org/get-started/

we used

``` bash
$ conda install pytorch pytorch-cuda=11.6 -c pytorch -c nvidia
```

install requirements and MIOFlow

``` bash
$ pip install -e .
```

Remove unused packages and caches.

``` bash
$ conda clean --all
```

Install MIOFlow for developers and internal use:

``` bash
$ cd path/to/this/repository
$ pip install -e MIOFlow
```

### Data
Most datasets are available in the directory `data`. The file `eb_v4_df_pca200.npy` can be downloaded [here](https://drive.google.com/file/d/1HvEUDO1U73iHmt-vY4YbTvOUxr6IdpK_/view?usp=drive_link).

### Add kernel to Jupyter Notebook

#### automatic conda kernels

For greater detail see the official docs for
[`nb_conda_kernels`](https://github.com/Anaconda-Platform/nb_conda_kernels).
In short, install `nb_conda_kernels` in the environment from which you
launch JupyterLab / Jupyter Notebooks from (e.g. `base`) via:

``` bash
$ conda install -n <notebook_env> nb_conda_kernels
```

to add a new or exist conda environment to Jupyter simply install
`ipykernel` into that conda environment e.g.

``` bash
$ conda install -n <python_env> ipykernel
```

#### manual ipykernel

add to your Jupyter Notebook kernels via

``` bash
$ python -m ipykernel install --user --name sklab-mioflow
```

It can be removed via:

``` bash
$ jupyter kernelspec uninstall sklab-mioflow
```

#### list kernels found by Jupyter

kernels recognized by conda

``` bash
$ python -m nb_conda_kernels list
```

check which kernels are discovered by Jupyter:

``` bash
$ jupyter kernelspec list
```

## How to use

This repository consists of our python library `MIOFlow` as well as a
directory of scripts for running and using it.

### Scripts

To recreate our results with MMD loss and density regulariazation you
can run the following command:

``` bash
python scripts/run.py -d petals -c mmd -n petal-mmd
```

This will generate the directory `results/petals-mmd` and save
everything there.

For a full list of parameters try running:

``` bash
python scripts/run.py --help
```

### Python Package

One could simply import everything and use it piecemeal:

``` python
from MIOFlow.ode import *
from MIOFlow.losses import *
from MIOFlow.utils import *
from MIOFlow.models import *
from MIOFlow.plots import *
from MIOFlow.train import *
from MIOFlow.constants import *
from MIOFlow.datasets import *
from MIOFlow.exp import *
from MIOFlow.geo import *
from MIOFlow.eval import *
```

### Tutorials

One can also consult or modify the tutorial notebooks for their uses: -
[EB Bodies
tutorial](https://github.com/KrishnaswamyLab/MIOFlow/blob/main/notebooks/%5BTutorial%5D%20EB-Hold-out.ipynb) -
[Dyngen
tutorial](https://github.com/KrishnaswamyLab/MIOFlow/blob/main/notebooks/%5BTutorial%5D%20Dyngen.ipynb) -
[Petals
tutorial](https://github.com/KrishnaswamyLab/MIOFlow/blob/main/notebooks/%5BTutorial%5D%20Petal.ipynb)
