import { Construct } from "constructs";
import { TerraformBackend } from "../terraform-backend";
import { TerraformRemoteState, DataTerraformRemoteStateConfig } from "../terraform-remote-state";
/**
 * @deprecated CDK for Terraform no longer supports the artifactory backend. Terraform deprecated artifactory in v1.2.3 and removed it in v1.3.
 */
export declare class ArtifactoryBackend extends TerraformBackend {
    private readonly props;
    constructor(scope: Construct, props: ArtifactoryBackendConfig);
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    getRemoteStateDataSource(scope: Construct, name: string, _fromStack: string): TerraformRemoteState;
}
/**
 * @deprecated CDK for Terraform no longer supports the artifactory backend. Terraform deprecated artifactory in v1.2.3 and removed it in v1.3.
 */
export declare class DataTerraformRemoteStateArtifactory extends TerraformRemoteState {
    constructor(scope: Construct, id: string, config: DataTerraformRemoteStateArtifactoryConfig);
}
/**
 * Stores the state as an artifact in a given repository in Artifactory.
 * Generic HTTP repositories are supported, and state from different configurations
 * may be kept at different subpaths within the repository.
 *
 * Note: The URL must include the path to the Artifactory installation.
 * It will likely end in /artifactory.
 *
 * This backend does not support state locking.
 *
 * Read more about this backend in the Terraform docs:
 * https://developer.hashicorp.com/terraform/language/v1.2.x/settings/backends/artifactory
 *
 * @deprecated CDK for Terraform no longer supports the artifactory backend. Terraform deprecated artifactory in v1.2.3 and removed it in v1.3.
 */
export interface ArtifactoryBackendConfig {
    /**
     * (Required) - The username
     */
    readonly username: string;
    /**
     * (Required) - The password
     */
    readonly password: string;
    /**
     * (Required) - The URL.
     *
     * Note that this is the base url to artifactory not the full repo and subpath.
     */
    readonly url: string;
    /**
     * (Required) - The repository name
     */
    readonly repo: string;
    /**
     * (Required) - Path within the repository
     */
    readonly subpath: string;
}
/**
 * @deprecated CDK for Terraform no longer supports the artifactory backend. Terraform deprecated artifactory in v1.2.3 and removed it in v1.3.
 */
export interface DataTerraformRemoteStateArtifactoryConfig extends DataTerraformRemoteStateConfig, ArtifactoryBackendConfig {
}
