import { Construct } from "constructs";
import { TerraformBackend } from "../terraform-backend";
import { TerraformRemoteState, DataTerraformRemoteStateConfig } from "../terraform-remote-state";
/**
 * @deprecated CDK for Terraform no longer supports the etcd backend. Terraform deprecated etcd in v1.2.3 and removed it in v1.3.
 */
export declare class EtcdBackend extends TerraformBackend {
    private readonly props;
    constructor(scope: Construct, props: EtcdBackendConfig);
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    getRemoteStateDataSource(scope: Construct, name: string, _fromStack: string): TerraformRemoteState;
}
/**
 * @deprecated CDK for Terraform no longer supports the etcd backend. Terraform deprecated etcd in v1.2.3 and removed it in v1.3.
 */
export declare class DataTerraformRemoteStateEtcd extends TerraformRemoteState {
    constructor(scope: Construct, id: string, config: DataTerraformRemoteStateEtcdConfig);
}
/**
 * Stores the state in etcd 2.x at a given path.
 *
 * This backend does not support state locking.
 *
 * Read more about this backend in the Terraform docs:
 * https://developer.hashicorp.com/terraform/language/v1.2.x/settings/backends/etcd
 *
 * @deprecated CDK for Terraform no longer supports the etcd backend. Terraform deprecated etcd in v1.2.3 and removed it in v1.3.
 */
export interface EtcdBackendConfig {
    /**
     * (Required) The path where to store the state
     */
    readonly path: string;
    /**
     * (Required) A space-separated list of the etcd endpoints
     */
    readonly endpoints: string;
    /**
     * (Optional) The username
     */
    readonly username?: string;
    /**
     * (Optional) The password
     */
    readonly password?: string;
}
/**
 * @deprecated CDK for Terraform no longer supports the etcd backend. Terraform deprecated etcd in v1.2.3 and removed it in v1.3.
 */
export interface DataTerraformRemoteStateEtcdConfig extends DataTerraformRemoteStateConfig, EtcdBackendConfig {
}
