import { TerraformDynamicExpression } from "./terraform-dynamic-expression";
import { ITerraformIterator } from "./terraform-iterator";
import { IResolvable } from "./tokens";
export declare class TerraformDynamicBlock implements IResolvable {
    readonly creationStack: string[];
    readonly forEach: ITerraformIterator;
    readonly iterator = "each";
    readonly content: {
        [key: string]: any;
    };
    private constructor();
    static fromDynamicExpression(expr: TerraformDynamicExpression): TerraformDynamicBlock;
    resolve(): any;
    toTerraformDynamicBlockJson(): IResolvable;
    toString(): string;
    /**
     * Turn this Dynamic Block into JSON
     *
     * Called automatically when JSON.stringify() is called on this.
     */
    toJSON(): any;
    static isTerraformDynamicBlock(x: any): x is TerraformDynamicBlock;
}
