import { ITerraformIterator } from "./terraform-iterator";
import { IResolvable } from "./tokens";
/**
 * A TerraformDynamicExpression is returned by TerraformIterator.dynamic
 * and can be passed to list attributes of e.g. TerraformResources
 * As it resolves to a for expression, it can be used directly on attributes of
 * a list(object) type (or similar) and in Terraform functions that take a list.
 * When used in attributes that are of a block type which need to be modeled as
 * a dynamic block, the listMapper for that attribute will change this to a
 * TerraformDynamicBlock, which in turn will be properly handled by the
 * processDynamicAttributes() utility function.
 */
export declare class TerraformDynamicExpression implements IResolvable {
    readonly creationStack: string[];
    readonly iterator: ITerraformIterator;
    readonly content: {
        [key: string]: any;
    };
    constructor(args: {
        iterator: ITerraformIterator;
        content: {
            [key: string]: any;
        };
    });
    /**
     * resolves this as a Terraform for expression.
     * This allows using iterator.dynamic() on attributes that are not blocks but
     * lists of objects (which is not visible to the user when working with provider
     * mappings as it is abstracted away)
     */
    resolve(): any;
    toString(): string;
    /**
     * Turn this Dynamic Expression into JSON
     *
     * Called automatically when JSON.stringify() is called on this.
     */
    toJSON(): any;
    static isTerraformDynamicExpression(x: any): x is TerraformDynamicExpression;
}
