import { Construct } from "constructs";
import { TerraformStack } from "./terraform-stack";
export interface TerraformElementMetadata {
    readonly path: string;
    readonly uniqueId: string;
    readonly stackTrace: string[];
}
export declare class TerraformElement extends Construct {
    protected readonly rawOverrides: any;
    /**
     * An explicit logical ID provided by `overrideLogicalId`.
     */
    private _logicalIdOverride?;
    /**
     * Type of this element, used for fqn.
     * This is undefined for
     * - elements not referable, like TerraformOutput
     * - elements using their own fqn implementation, like TerraformProvider
     */
    private readonly _elementType?;
    constructor(scope: Construct, id: string, elementType?: string);
    get cdktfStack(): TerraformStack;
    static isTerraformElement(x: any): x is TerraformElement;
    toTerraform(): any;
    toMetadata(): any;
    private _fqnToken?;
    get fqn(): string;
    private _friendlyUniqueId?;
    get friendlyUniqueId(): string;
    /**
     * Overrides the auto-generated logical ID with a specific ID.
     * @param newLogicalId The new logical ID to use for this stack element.
     */
    overrideLogicalId(newLogicalId: string): void;
    /**
     * Resets a previously passed logical Id to use the auto-generated logical id again
     */
    resetOverrideLogicalId(): void;
    addOverride(path: string, value: any): void;
    protected get constructNodeMetadata(): {
        [key: string]: any;
    };
}
