import { AnyMap, AnyMapList, BooleanMap, BooleanMapList, ComplexList, ComplexMap, NumberMap, NumberMapList, StringMap, StringMapList } from "./complex-computed-list";
import { IResolvable } from "./tokens";
export interface ITerraformIterator {
    /**
     * @internal used by TerraformResource to set the for_each expression
     */
    _getForEachExpression(): any;
}
type ListType = Array<string> | Array<number> | Array<boolean | IResolvable> | IResolvable | ComplexList | StringMapList | NumberMapList | BooleanMapList | AnyMapList;
type MapType = {
    [key: string]: any;
} | {
    [key: string]: string;
} | {
    [key: string]: number;
} | StringMap | NumberMap | BooleanMap | AnyMap | ComplexMap;
export declare abstract class TerraformIterator implements ITerraformIterator {
    /**
     * @internal used by TerraformResource to set the for_each expression
     */
    abstract _getForEachExpression(): any;
    /**
     * Creates a new iterator from a list
     */
    static fromList(list: ListType): ListTerraformIterator;
    /**
     * Creates a new iterator from a map
     */
    static fromMap(map: ComplexMap | {
        [key: string]: any;
    } | {
        [key: string]: string;
    } | {
        [key: string]: number;
    } | {
        [key: string]: boolean;
    }): MapTerraformIterator;
    /**
     * @param attribute name of the property to retrieve
     * @returns the given attribute of the current item iterated over as a string
     */
    getString(attribute: string): string;
    /**
     * @param attribute name of the property to retrieve
     * @returns the given attribute of the current item iterated over as a number
     */
    getNumber(attribute: string): number;
    /**
     * @param attribute name of the property to retrieve
     * @returns the given attribute of the current item iterated over as a boolean
     */
    getBoolean(attribute: string): IResolvable;
    /**
     * @param attribute name of the property to retrieve
     * @returns the given attribute of the current item iterated over as any
     */
    getAny(attribute: string): IResolvable;
    /**
     * @param attribute name of the property to retrieve
     * @returns the given attribute of the current item iterated over as a (string) list
     */
    getList(attribute: string): string[];
    /**
     * @param attribute name of the property to retrieve
     * @returns the given attribute of the current item iterated over as a number list
     */
    getNumberList(attribute: string): number[];
    /**
     * @param attribute name of the property to retrieve
     * @returns the given attribute of the current item iterated over as a map
     */
    getMap(attribute: string): {
        [key: string]: any;
    };
    /**
     * @param attribute name of the property to retrieve
     * @returns the given attribute of the current item iterated over as a map of strings
     */
    getStringMap(attribute: string): {
        [key: string]: string;
    };
    /**
     * @param attribute name of the property to retrieve
     * @returns the given attribute of the current item iterated over as a map of numbers
     */
    getNumberMap(attribute: string): {
        [key: string]: number;
    };
    /**
     * @param attribute name of the property to retrieve
     * @returns the given attribute of the current item iterated over as a map of booleans
     */
    getBooleanMap(attribute: string): {
        [key: string]: boolean;
    };
    /**
     * @param attribute name of the property to retrieve
     * @returns the given attribute of the current item iterated over as a map of any
     */
    getAnyMap(attribute: string): {
        [key: string]: any;
    };
    /**
     * @internal
     */
    protected _getValue(): any;
    /**
     * @internal
     */
    protected _getKey(): any;
    dynamic(attributes: {
        [key: string]: any;
    }): IResolvable;
}
export declare class ListTerraformIterator extends TerraformIterator {
    private readonly list;
    constructor(list: ListType);
    /**
     * Returns the currenty entry in the list or set that is being iterated over.
     * For lists this is the same as `iterator.value`. If you need the index,
     * use count using the escape hatch:
     * https://developer.hashicorp.com/terraform/cdktf/concepts/resources#escape-hatch
     */
    get key(): any;
    /**
     * Returns the value of the current item iterated over.
     */
    get value(): any;
    /**
     * @internal used by TerraformResource to set the for_each expression
     */
    _getForEachExpression(): any;
}
export declare class MapTerraformIterator extends TerraformIterator {
    private readonly map;
    constructor(map: MapType);
    /**
     * @internal used by TerraformResource to set the for_each expression
     */
    _getForEachExpression(): any;
    /**
     * Returns the key of the current entry in the map that is being iterated over.
     */
    get key(): string;
    /**
     * Returns the value of the current item iterated over.
     */
    get value(): any;
}
export {};
