import { Construct } from "constructs";
import { TerraformElement } from "./terraform-element";
import { IResolvable } from "./tokens/resolvable";
import { ITerraformAddressable } from "./terraform-addressable";
export declare class TerraformLocal extends TerraformElement implements ITerraformAddressable {
    private _expression;
    constructor(scope: Construct, id: string, expression: any);
    set expression(value: any);
    get expression(): any;
    get asString(): string;
    get asNumber(): number;
    get asList(): string[];
    get asStringMap(): {
        [key: string]: string;
    };
    get asNumberMap(): {
        [key: string]: number;
    };
    get asBooleanMap(): {
        [key: string]: boolean;
    };
    get asAnyMap(): {
        [key: string]: any;
    };
    get asBoolean(): IResolvable;
    private interpolation;
    toTerraform(): any;
    toMetadata(): any;
    /**
     * @returns a string token referencing the value of this local
     */
    toString(): string;
}
