/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Expression } from "./tfExpression";
import { IResolvable } from "./tokens/resolvable";
/**
 * This class contains static functions for all arithmetical and logical operators
 * in the Terraform configutation language.
 */
export declare class Op {
    /**
     * Renders !expression
     */
    static not(expression: Expression): IResolvable;
    /**
     * Renders -expression
     */
    static negate(expression: Expression): IResolvable;
    /**
     * Renders left * right
     */
    static mul(left: Expression, right: Expression): IResolvable;
    /**
     * Renders left / right
     */
    static div(left: Expression, right: Expression): IResolvable;
    /**
     * Renders left % right
     */
    static mod(left: Expression, right: Expression): IResolvable;
    /**
     * Renders left + right
     */
    static add(left: Expression, right: Expression): IResolvable;
    /**
     * Renders left - right
     */
    static sub(left: Expression, right: Expression): IResolvable;
    /**
     * Renders left > right
     */
    static gt(left: Expression, right: Expression): IResolvable;
    /**
     * Renders left >= right
     */
    static gte(left: Expression, right: Expression): IResolvable;
    /**
     * Renders left < right
     */
    static lt(left: Expression, right: Expression): IResolvable;
    /**
     * Renders left <= right
     */
    static lte(left: Expression, right: Expression): IResolvable;
    /**
     * Renders left == right
     */
    static eq(left: Expression, right: Expression): IResolvable;
    /**
     * Renders left != right
     */
    static neq(left: Expression, right: Expression): IResolvable;
    /**
     * Renders left && right
     */
    static and(left: Expression, right: Expression): IResolvable;
    /**
     * Renders left || right
     */
    static or(left: Expression, right: Expression): IResolvable;
}
