export interface TerraformConstructor {
    readonly tfResourceType: string;
}
export type SynthesizedStack = {
    resource: Record<string, any>;
    data: Record<string, any>;
    provider: Record<string, any>;
};
/**
 * Class representing the contents of a return by an assertion
 */
export declare class AssertionReturn {
    readonly message: string;
    readonly pass: boolean;
    /**
     * Create an AssertionReturn
     * @param message - String message containing information about the result of the assertion
     * @param pass - Boolean pass denoting the success of the assertion
     */
    constructor(message: string, pass: boolean);
}
export type MatcherReturnJest = {
    message: () => string;
    pass: boolean;
};
/**
 * Reformats the contents of the base testing matcher return type AssertionReturn into type useable by jest
 * @param toReturn
 * @returns {MatcherReturnJest}
 */
export declare function returnMatcherToJest(toReturn: AssertionReturn): MatcherReturnJest;
/**
 * Compares expected and received. All expected properties are matched and considered equal even if
 * there are more properties in the received object than in the expected object in which case it will still return true.
 * @param expected
 * @param received
 * @returns {boolean}
 */
export declare function asymetricDeepEqualIgnoringObjectCasing(expected: unknown, received: unknown): boolean;
/**
 * Returns the function toHaveDataSourceWithProperties using the evaluation properties of customPassEvaluation
 * @param customPassEvaluation
 * @returns {getToHaveDataSourceWithProperties~toHaveDataSourceWithProperties}
 */
export declare function getToHaveDataSourceWithProperties(customPassEvaluation?: (items: any, assertedProperties: Record<string, any>) => boolean): (received: string, resourceType: TerraformConstructor, properties?: Record<string, any>) => AssertionReturn;
/**
 * Returns the function toHaveResourceWithProperties using the evaluation properties of customPassEvaluation
 * @param customPassEvaluation
 * @returns
 */
export declare function getToHaveResourceWithProperties(customPassEvaluation?: (items: any, assertedProperties: Record<string, any>) => boolean): (received: string, resourceType: TerraformConstructor, properties?: Record<string, any>) => AssertionReturn;
/**
 * Returns the function toHaveProviderWithProperties using the evaluation properties of customPassEvaluation
 * @param customPassEvaluation
 * @returns {getToHaveProviderWithProperties~toHaveProviderWithProperties}
 */
export declare function getToHaveProviderWithProperties(customPassEvaluation?: (items: any, assertedProperties: Record<string, any>) => boolean): (received: string, resourceType: TerraformConstructor, properties?: Record<string, any>) => AssertionReturn;
/**
 * Evaluates the validity of the received stack
 * @param received
 * @returns {AssertionReturn}
 */
export declare function toBeValidTerraform(received: string): AssertionReturn;
/**
 * Evaluates the ability for the received stack to successfully plan
 * @param received
 * @returns {AssertionReturn}
 */
export declare function toPlanSuccessfully(received: string): AssertionReturn;
