import { IConstruct, IValidation } from "constructs";
import { TerraformProvider } from "../terraform-provider";
/**
 * A validation that is added by default, ensuring that all providers
 * used are defined via Constructs.
 */
export declare class ValidateProviderPresence implements IValidation {
    protected host: IConstruct;
    /**
     * All provider names found in the construct tree.
     */
    providerNames: Set<string>;
    /**
     * All TerraformProviders found in the construct tree.
     */
    foundProviders: TerraformProvider[];
    /**
     * Creates a ValidateProviderPresence
     */
    constructor(host: IConstruct);
    /**
     * Checks the construct tree recursively
     */
    check(node: IConstruct): void;
    /**
     * Run the validation
     */
    validate(): string[];
}
