"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolve = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const tokens_1 = require("./tokens");
const TOKEN_RESOLVER = new tokens_1.DefaultTokenResolver(new tokens_1.StringConcat());
// eslint-disable-next-line jsdoc/require-jsdoc
function resolve(scope, obj, preparing = false) {
    return tokens_1.Tokenization.resolve(obj, {
        scope,
        preparing,
        resolver: TOKEN_RESOLVER,
    });
}
exports.resolve = resolve;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiX3Rva2Vucy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIl90b2tlbnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsK0JBQStCO0FBQy9CLG1DQUFtQztBQUNuQyxxQ0FBNEU7QUFHNUUsTUFBTSxjQUFjLEdBQUcsSUFBSSw2QkFBb0IsQ0FBQyxJQUFJLHFCQUFZLEVBQUUsQ0FBQyxDQUFDO0FBRXBFLCtDQUErQztBQUMvQyxTQUFnQixPQUFPLENBQUksS0FBZ0IsRUFBRSxHQUFNLEVBQUUsU0FBUyxHQUFHLEtBQUs7SUFDcEUsT0FBTyxxQkFBWSxDQUFDLE9BQU8sQ0FBQyxHQUFHLEVBQUU7UUFDL0IsS0FBSztRQUNMLFNBQVM7UUFDVCxRQUFRLEVBQUUsY0FBYztLQUN6QixDQUFDLENBQUM7QUFDTCxDQUFDO0FBTkQsMEJBTUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgKGMpIEhhc2hpQ29ycCwgSW5jXG4vLyBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogTVBMLTIuMFxuaW1wb3J0IHsgVG9rZW5pemF0aW9uLCBEZWZhdWx0VG9rZW5SZXNvbHZlciwgU3RyaW5nQ29uY2F0IH0gZnJvbSBcIi4vdG9rZW5zXCI7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tIFwiY29uc3RydWN0c1wiO1xuXG5jb25zdCBUT0tFTl9SRVNPTFZFUiA9IG5ldyBEZWZhdWx0VG9rZW5SZXNvbHZlcihuZXcgU3RyaW5nQ29uY2F0KCkpO1xuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUganNkb2MvcmVxdWlyZS1qc2RvY1xuZXhwb3J0IGZ1bmN0aW9uIHJlc29sdmU8VD4oc2NvcGU6IENvbnN0cnVjdCwgb2JqOiBULCBwcmVwYXJpbmcgPSBmYWxzZSk6IFQge1xuICByZXR1cm4gVG9rZW5pemF0aW9uLnJlc29sdmUob2JqLCB7XG4gICAgc2NvcGUsXG4gICAgcHJlcGFyaW5nLFxuICAgIHJlc29sdmVyOiBUT0tFTl9SRVNPTFZFUixcbiAgfSk7XG59XG4iXX0=