"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Annotations = exports.DISABLE_STACK_TRACE_IN_METADATA = exports.AnnotationMetadataEntryType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
var AnnotationMetadataEntryType;
(function (AnnotationMetadataEntryType) {
    AnnotationMetadataEntryType["INFO"] = "@cdktf/info";
    AnnotationMetadataEntryType["WARN"] = "@cdktf/warn";
    AnnotationMetadataEntryType["ERROR"] = "@cdktf/error";
})(AnnotationMetadataEntryType = exports.AnnotationMetadataEntryType || (exports.AnnotationMetadataEntryType = {}));
exports.DISABLE_STACK_TRACE_IN_METADATA = "@cdktf/disable_stack_trace_in_metadata";
/**
 * Includes API for attaching annotations such as warning messages to constructs.
 */
class Annotations {
    /**
     * Returns the annotations API for a construct scope.
     * @param scope The scope
     */
    static of(scope) {
        return new Annotations(scope);
    }
    constructor(scope) {
        this.scope = scope;
        const disableTrace = scope.node.tryGetContext(exports.DISABLE_STACK_TRACE_IN_METADATA) || false;
        this.stackTraces = !disableTrace;
    }
    /**
     * Adds a warning metadata entry to this construct.
     *
     * The CLI will display the warning when an app is synthesized.
     * In a future release the CLI might introduce a --strict flag which
     * will then fail the synthesis if it encounters a warning.
     *
     * @param message The warning message.
     */
    addWarning(message) {
        this.addMessage(AnnotationMetadataEntryType.WARN, message);
    }
    /**
     * Adds an info metadata entry to this construct.
     *
     * The CLI will display the info message when apps are synthesized.
     *
     * @param message The info message.
     */
    addInfo(message) {
        this.addMessage(AnnotationMetadataEntryType.INFO, message);
    }
    /**
     * Adds an { "error": <message> } metadata entry to this construct.
     * The toolkit will fail synthesis when errors are reported.
     * @param message The error message.
     */
    addError(message) {
        this.addMessage(AnnotationMetadataEntryType.ERROR, message);
    }
    /**
     * Adds a message metadata entry to the construct node, to be displayed by the CDK CLI.
     * @param level The message level
     * @param message The message itself
     */
    addMessage(level, message) {
        this.scope.node.addMetadata(level, message, {
            stackTrace: this.stackTraces,
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
Annotations[_a] = { fqn: "cdktf.Annotations", version: "0.17.0-pre.18" };
exports.Annotations = Annotations;
//# sourceMappingURL=data:application/json;base64,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