"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.App = exports.CONTEXT_ENV = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const constructs_1 = require("constructs");
const fs = require("fs");
const package_json_1 = require("../package.json");
const annotations_1 = require("./annotations");
const manifest_1 = require("./manifest");
const terraform_stack_1 = require("./terraform-stack");
const APP_SYMBOL = Symbol.for("cdktf/App");
exports.CONTEXT_ENV = "CDKTF_CONTEXT_JSON";
/**
 * Represents a cdktf application.
 */
class App extends constructs_1.Construct {
    /**
     * Defines an app
     * @param config configuration
     */
    constructor(config = {}) {
        super(undefined, "");
        Object.defineProperty(this, APP_SYMBOL, { value: true });
        this.outdir = process.env.CDKTF_OUTDIR ?? config.outdir ?? "cdktf.out";
        this.targetStackId = process.env.CDKTF_TARGET_STACK_ID;
        this.skipValidation = config.skipValidation;
        this.loadContext(config.context);
        const node = this.node;
        if (config.stackTraces === false) {
            node.setContext(annotations_1.DISABLE_STACK_TRACE_IN_METADATA, true);
        }
        node.setContext("cdktfVersion", package_json_1.version);
        if (!fs.existsSync(this.outdir)) {
            fs.mkdirSync(this.outdir);
        }
        this.manifest = new manifest_1.Manifest(package_json_1.version, this.outdir);
    }
    static isApp(x) {
        return x !== null && typeof x === "object" && APP_SYMBOL in x;
    }
    static of(construct) {
        return _lookup(construct);
        // eslint-disable-next-line jsdoc/require-jsdoc
        function _lookup(c) {
            if (App.isApp(c)) {
                return c;
            }
            const node = c.node;
            if (!node.scope) {
                throw new Error(`No app could be identified for the construct at path '${construct.node.path}'`);
            }
            return _lookup(node.scope);
        }
    }
    /**
     * Synthesizes all resources to the output directory
     */
    synth() {
        const session = {
            outdir: this.outdir,
            skipValidation: this.skipValidation,
            manifest: this.manifest,
        };
        const stacks = this.node
            .findAll()
            .filter(terraform_stack_1.TerraformStack.isStack);
        stacks.forEach((stack) => stack.prepareStack());
        stacks.forEach((stack) => stack.synthesizer.synthesize(session));
        if (!this.skipValidation) {
            const validations = this.node.validate();
            if (validations.length) {
                const errorList = validations.join("\n  ");
                throw new Error(`App level validation failed with the following errors:\n  ${errorList}`);
            }
        }
        this.manifest.writeToFile();
    }
    /**
     * Creates a reference from one stack to another, invoked on prepareStack since it creates extra resources
     */
    crossStackReference(fromStack, toStack, identifier) {
        toStack.addDependency(fromStack);
        const outputId = fromStack.registerOutgoingCrossStackReference(identifier).friendlyUniqueId;
        const remoteState = toStack.registerIncomingCrossStackReference(fromStack);
        return remoteState.getString(outputId);
    }
    loadContext(defaults = {}) {
        const node = this.node;
        // prime with defaults passed through constructor
        for (const [k, v] of Object.entries(defaults)) {
            node.setContext(k, v);
        }
        // read from environment
        const contextJson = process.env[exports.CONTEXT_ENV];
        const contextFromEnvironment = contextJson ? JSON.parse(contextJson) : {};
        for (const [k, v] of Object.entries(contextFromEnvironment)) {
            node.setContext(k, v);
        }
    }
}
_a = JSII_RTTI_SYMBOL_1;
App[_a] = { fqn: "cdktf.App", version: "0.17.0-pre.18" };
exports.App = App;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBwLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYXBwLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsK0JBQStCO0FBQy9CLG1DQUFtQztBQUNuQywyQ0FBbUQ7QUFDbkQseUJBQXlCO0FBQ3pCLGtEQUEwQztBQUMxQywrQ0FBZ0U7QUFDaEUseUNBQXNDO0FBRXRDLHVEQUFtRDtBQUVuRCxNQUFNLFVBQVUsR0FBRyxNQUFNLENBQUMsR0FBRyxDQUFDLFdBQVcsQ0FBQyxDQUFDO0FBQzlCLFFBQUEsV0FBVyxHQUFHLG9CQUFvQixDQUFDO0FBNkJoRDs7R0FFRztBQUNILE1BQWEsR0FBSSxTQUFRLHNCQUFTO0lBa0JoQzs7O09BR0c7SUFDSCxZQUFZLFNBQW9CLEVBQUU7UUFDaEMsS0FBSyxDQUFDLFNBQWdCLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDNUIsTUFBTSxDQUFDLGNBQWMsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFLEVBQUUsS0FBSyxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7UUFFekQsSUFBSSxDQUFDLE1BQU0sR0FBRyxPQUFPLENBQUMsR0FBRyxDQUFDLFlBQVksSUFBSSxNQUFNLENBQUMsTUFBTSxJQUFJLFdBQVcsQ0FBQztRQUN2RSxJQUFJLENBQUMsYUFBYSxHQUFHLE9BQU8sQ0FBQyxHQUFHLENBQUMscUJBQXFCLENBQUM7UUFDdkQsSUFBSSxDQUFDLGNBQWMsR0FBRyxNQUFNLENBQUMsY0FBYyxDQUFDO1FBRTVDLElBQUksQ0FBQyxXQUFXLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBRWpDLE1BQU0sSUFBSSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUM7UUFDdkIsSUFBSSxNQUFNLENBQUMsV0FBVyxLQUFLLEtBQUssRUFBRTtZQUNoQyxJQUFJLENBQUMsVUFBVSxDQUFDLDZDQUErQixFQUFFLElBQUksQ0FBQyxDQUFDO1NBQ3hEO1FBRUQsSUFBSSxDQUFDLFVBQVUsQ0FBQyxjQUFjLEVBQUUsc0JBQU8sQ0FBQyxDQUFDO1FBRXpDLElBQUksQ0FBQyxFQUFFLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsRUFBRTtZQUMvQixFQUFFLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQztTQUMzQjtRQUNELElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxtQkFBUSxDQUFDLHNCQUFPLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ3JELENBQUM7SUFFTSxNQUFNLENBQUMsS0FBSyxDQUFDLENBQU07UUFDeEIsT0FBTyxDQUFDLEtBQUssSUFBSSxJQUFJLE9BQU8sQ0FBQyxLQUFLLFFBQVEsSUFBSSxVQUFVLElBQUksQ0FBQyxDQUFDO0lBQ2hFLENBQUM7SUFFTSxNQUFNLENBQUMsRUFBRSxDQUFDLFNBQXFCO1FBQ3BDLE9BQU8sT0FBTyxDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBRTFCLCtDQUErQztRQUMvQyxTQUFTLE9BQU8sQ0FBQyxDQUFhO1lBQzVCLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsRUFBRTtnQkFDaEIsT0FBTyxDQUFDLENBQUM7YUFDVjtZQUVELE1BQU0sSUFBSSxHQUFHLENBQUMsQ0FBQyxJQUFJLENBQUM7WUFFcEIsSUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUU7Z0JBQ2YsTUFBTSxJQUFJLEtBQUssQ0FDYix5REFBeUQsU0FBUyxDQUFDLElBQUksQ0FBQyxJQUFJLEdBQUcsQ0FDaEYsQ0FBQzthQUNIO1lBRUQsT0FBTyxPQUFPLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQzdCLENBQUM7SUFDSCxDQUFDO0lBRUQ7O09BRUc7SUFDSSxLQUFLO1FBQ1YsTUFBTSxPQUFPLEdBQXNCO1lBQ2pDLE1BQU0sRUFBRSxJQUFJLENBQUMsTUFBTTtZQUNuQixjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWM7WUFDbkMsUUFBUSxFQUFFLElBQUksQ0FBQyxRQUFRO1NBQ3hCLENBQUM7UUFFRixNQUFNLE1BQU0sR0FBRyxJQUFJLENBQUMsSUFBSTthQUNyQixPQUFPLEVBQUU7YUFDVCxNQUFNLENBQWlCLGdDQUFjLENBQUMsT0FBTyxDQUFDLENBQUM7UUFFbEQsTUFBTSxDQUFDLE9BQU8sQ0FBQyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsS0FBSyxDQUFDLFlBQVksRUFBRSxDQUFDLENBQUM7UUFDaEQsTUFBTSxDQUFDLE9BQU8sQ0FBQyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsS0FBSyxDQUFDLFdBQVcsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztRQUVqRSxJQUFJLENBQUMsSUFBSSxDQUFDLGNBQWMsRUFBRTtZQUN4QixNQUFNLFdBQVcsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsRUFBRSxDQUFDO1lBQ3pDLElBQUksV0FBVyxDQUFDLE1BQU0sRUFBRTtnQkFDdEIsTUFBTSxTQUFTLEdBQUcsV0FBVyxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQztnQkFDM0MsTUFBTSxJQUFJLEtBQUssQ0FDYiw2REFBNkQsU0FBUyxFQUFFLENBQ3pFLENBQUM7YUFDSDtTQUNGO1FBRUQsSUFBSSxDQUFDLFFBQVEsQ0FBQyxXQUFXLEVBQUUsQ0FBQztJQUM5QixDQUFDO0lBRUQ7O09BRUc7SUFDSSxtQkFBbUIsQ0FDeEIsU0FBeUIsRUFDekIsT0FBdUIsRUFDdkIsVUFBa0I7UUFFbEIsT0FBTyxDQUFDLGFBQWEsQ0FBQyxTQUFTLENBQUMsQ0FBQztRQUNqQyxNQUFNLFFBQVEsR0FDWixTQUFTLENBQUMsbUNBQW1DLENBQzNDLFVBQVUsQ0FDWCxDQUFDLGdCQUFnQixDQUFDO1FBRXJCLE1BQU0sV0FBVyxHQUFHLE9BQU8sQ0FBQyxtQ0FBbUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztRQUUzRSxPQUFPLFdBQVcsQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDekMsQ0FBQztJQUVPLFdBQVcsQ0FBQyxXQUFzQyxFQUFFO1FBQzFELE1BQU0sSUFBSSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUM7UUFFdkIsaURBQWlEO1FBQ2pELEtBQUssTUFBTSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsSUFBSSxNQUFNLENBQUMsT0FBTyxDQUFDLFFBQVEsQ0FBQyxFQUFFO1lBQzdDLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO1NBQ3ZCO1FBRUQsd0JBQXdCO1FBQ3hCLE1BQU0sV0FBVyxHQUFHLE9BQU8sQ0FBQyxHQUFHLENBQUMsbUJBQVcsQ0FBQyxDQUFDO1FBQzdDLE1BQU0sc0JBQXNCLEdBQUcsV0FBVyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7UUFFMUUsS0FBSyxNQUFNLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsc0JBQXNCLENBQUMsRUFBRTtZQUMzRCxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztTQUN2QjtJQUNILENBQUM7Ozs7QUF0SVUsa0JBQUciLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgKGMpIEhhc2hpQ29ycCwgSW5jXG4vLyBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogTVBMLTIuMFxuaW1wb3J0IHsgQ29uc3RydWN0LCBJQ29uc3RydWN0IH0gZnJvbSBcImNvbnN0cnVjdHNcIjtcbmltcG9ydCAqIGFzIGZzIGZyb20gXCJmc1wiO1xuaW1wb3J0IHsgdmVyc2lvbiB9IGZyb20gXCIuLi9wYWNrYWdlLmpzb25cIjtcbmltcG9ydCB7IERJU0FCTEVfU1RBQ0tfVFJBQ0VfSU5fTUVUQURBVEEgfSBmcm9tIFwiLi9hbm5vdGF0aW9uc1wiO1xuaW1wb3J0IHsgTWFuaWZlc3QgfSBmcm9tIFwiLi9tYW5pZmVzdFwiO1xuaW1wb3J0IHsgSVN5bnRoZXNpc1Nlc3Npb24gfSBmcm9tIFwiLi9zeW50aGVzaXplXCI7XG5pbXBvcnQgeyBUZXJyYWZvcm1TdGFjayB9IGZyb20gXCIuL3RlcnJhZm9ybS1zdGFja1wiO1xuXG5jb25zdCBBUFBfU1lNQk9MID0gU3ltYm9sLmZvcihcImNka3RmL0FwcFwiKTtcbmV4cG9ydCBjb25zdCBDT05URVhUX0VOViA9IFwiQ0RLVEZfQ09OVEVYVF9KU09OXCI7XG5leHBvcnQgaW50ZXJmYWNlIEFwcENvbmZpZyB7XG4gIC8qKlxuICAgKiBUaGUgZGlyZWN0b3J5IHRvIG91dHB1dCBUZXJyYWZvcm0gcmVzb3VyY2VzLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIENES1RGX09VVERJUiBpZiBkZWZpbmVkLCBvdGhlcndpc2UgXCJjZGt0Zi5vdXRcIlxuICAgKi9cbiAgcmVhZG9ubHkgb3V0ZGlyPzogc3RyaW5nO1xuICByZWFkb25seSBzdGFja1RyYWNlcz86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIEFkZGl0aW9uYWwgY29udGV4dCB2YWx1ZXMgZm9yIHRoZSBhcHBsaWNhdGlvbi5cbiAgICpcbiAgICogQ29udGV4dCBzZXQgYnkgdGhlIENMSSBvciB0aGUgYGNvbnRleHRgIGtleSBpbiBgY2RrdGYuanNvbmAgaGFzIHByZWNlZGVuY2UuXG4gICAqXG4gICAqIENvbnRleHQgY2FuIGJlIHJlYWQgZnJvbSBhbnkgY29uc3RydWN0IHVzaW5nIGBub2RlLmdldENvbnRleHQoa2V5KWAuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm8gYWRkaXRpb25hbCBjb250ZXh0XG4gICAqL1xuICByZWFkb25seSBjb250ZXh0PzogeyBba2V5OiBzdHJpbmddOiBhbnkgfTtcblxuICAvKipcbiAgICogV2hldGhlciB0byBza2lwIHRoZSB2YWxpZGF0aW9uIGR1cmluZyBzeW50aGVzaXMgb2YgdGhlIGFwcFxuICAgKlxuICAgKiBAZGVmYXVsdCAtIGZhbHNlXG4gICAqL1xuICByZWFkb25seSBza2lwVmFsaWRhdGlvbj86IGJvb2xlYW47XG59XG5cbi8qKlxuICogUmVwcmVzZW50cyBhIGNka3RmIGFwcGxpY2F0aW9uLlxuICovXG5leHBvcnQgY2xhc3MgQXBwIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgLyoqXG4gICAqIFRoZSBvdXRwdXQgZGlyZWN0b3J5IGludG8gd2hpY2ggcmVzb3VyY2VzIHdpbGwgYmUgc3ludGhlc2l6ZWQuXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgb3V0ZGlyOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBzdGFjayB3aGljaCB3aWxsIGJlIHN5bnRoZXNpemVkLiBJZiBub3Qgc2V0LCBhbGwgc3RhY2tzIHdpbGwgYmUgc3ludGhlc2l6ZWQuXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgdGFyZ2V0U3RhY2tJZDogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gIHB1YmxpYyByZWFkb25seSBtYW5pZmVzdDogTWFuaWZlc3Q7XG5cbiAgLyoqXG4gICAqIFdoZXRoZXIgdG8gc2tpcCB0aGUgdmFsaWRhdGlvbiBkdXJpbmcgc3ludGhlc2lzIG9mIHRoZSBhcHBcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBza2lwVmFsaWRhdGlvbj86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIERlZmluZXMgYW4gYXBwXG4gICAqIEBwYXJhbSBjb25maWcgY29uZmlndXJhdGlvblxuICAgKi9cbiAgY29uc3RydWN0b3IoY29uZmlnOiBBcHBDb25maWcgPSB7fSkge1xuICAgIHN1cGVyKHVuZGVmaW5lZCBhcyBhbnksIFwiXCIpO1xuICAgIE9iamVjdC5kZWZpbmVQcm9wZXJ0eSh0aGlzLCBBUFBfU1lNQk9MLCB7IHZhbHVlOiB0cnVlIH0pO1xuXG4gICAgdGhpcy5vdXRkaXIgPSBwcm9jZXNzLmVudi5DREtURl9PVVRESVIgPz8gY29uZmlnLm91dGRpciA/PyBcImNka3RmLm91dFwiO1xuICAgIHRoaXMudGFyZ2V0U3RhY2tJZCA9IHByb2Nlc3MuZW52LkNES1RGX1RBUkdFVF9TVEFDS19JRDtcbiAgICB0aGlzLnNraXBWYWxpZGF0aW9uID0gY29uZmlnLnNraXBWYWxpZGF0aW9uO1xuXG4gICAgdGhpcy5sb2FkQ29udGV4dChjb25maWcuY29udGV4dCk7XG5cbiAgICBjb25zdCBub2RlID0gdGhpcy5ub2RlO1xuICAgIGlmIChjb25maWcuc3RhY2tUcmFjZXMgPT09IGZhbHNlKSB7XG4gICAgICBub2RlLnNldENvbnRleHQoRElTQUJMRV9TVEFDS19UUkFDRV9JTl9NRVRBREFUQSwgdHJ1ZSk7XG4gICAgfVxuXG4gICAgbm9kZS5zZXRDb250ZXh0KFwiY2RrdGZWZXJzaW9uXCIsIHZlcnNpb24pO1xuXG4gICAgaWYgKCFmcy5leGlzdHNTeW5jKHRoaXMub3V0ZGlyKSkge1xuICAgICAgZnMubWtkaXJTeW5jKHRoaXMub3V0ZGlyKTtcbiAgICB9XG4gICAgdGhpcy5tYW5pZmVzdCA9IG5ldyBNYW5pZmVzdCh2ZXJzaW9uLCB0aGlzLm91dGRpcik7XG4gIH1cblxuICBwdWJsaWMgc3RhdGljIGlzQXBwKHg6IGFueSk6IHggaXMgQXBwIHtcbiAgICByZXR1cm4geCAhPT0gbnVsbCAmJiB0eXBlb2YgeCA9PT0gXCJvYmplY3RcIiAmJiBBUFBfU1lNQk9MIGluIHg7XG4gIH1cblxuICBwdWJsaWMgc3RhdGljIG9mKGNvbnN0cnVjdDogSUNvbnN0cnVjdCk6IEFwcCB7XG4gICAgcmV0dXJuIF9sb29rdXAoY29uc3RydWN0KTtcblxuICAgIC8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBqc2RvYy9yZXF1aXJlLWpzZG9jXG4gICAgZnVuY3Rpb24gX2xvb2t1cChjOiBJQ29uc3RydWN0KTogQXBwIHtcbiAgICAgIGlmIChBcHAuaXNBcHAoYykpIHtcbiAgICAgICAgcmV0dXJuIGM7XG4gICAgICB9XG5cbiAgICAgIGNvbnN0IG5vZGUgPSBjLm5vZGU7XG5cbiAgICAgIGlmICghbm9kZS5zY29wZSkge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoXG4gICAgICAgICAgYE5vIGFwcCBjb3VsZCBiZSBpZGVudGlmaWVkIGZvciB0aGUgY29uc3RydWN0IGF0IHBhdGggJyR7Y29uc3RydWN0Lm5vZGUucGF0aH0nYFxuICAgICAgICApO1xuICAgICAgfVxuXG4gICAgICByZXR1cm4gX2xvb2t1cChub2RlLnNjb3BlKTtcbiAgICB9XG4gIH1cblxuICAvKipcbiAgICogU3ludGhlc2l6ZXMgYWxsIHJlc291cmNlcyB0byB0aGUgb3V0cHV0IGRpcmVjdG9yeVxuICAgKi9cbiAgcHVibGljIHN5bnRoKCk6IHZvaWQge1xuICAgIGNvbnN0IHNlc3Npb246IElTeW50aGVzaXNTZXNzaW9uID0ge1xuICAgICAgb3V0ZGlyOiB0aGlzLm91dGRpcixcbiAgICAgIHNraXBWYWxpZGF0aW9uOiB0aGlzLnNraXBWYWxpZGF0aW9uLFxuICAgICAgbWFuaWZlc3Q6IHRoaXMubWFuaWZlc3QsXG4gICAgfTtcblxuICAgIGNvbnN0IHN0YWNrcyA9IHRoaXMubm9kZVxuICAgICAgLmZpbmRBbGwoKVxuICAgICAgLmZpbHRlcjxUZXJyYWZvcm1TdGFjaz4oVGVycmFmb3JtU3RhY2suaXNTdGFjayk7XG5cbiAgICBzdGFja3MuZm9yRWFjaCgoc3RhY2spID0+IHN0YWNrLnByZXBhcmVTdGFjaygpKTtcbiAgICBzdGFja3MuZm9yRWFjaCgoc3RhY2spID0+IHN0YWNrLnN5bnRoZXNpemVyLnN5bnRoZXNpemUoc2Vzc2lvbikpO1xuXG4gICAgaWYgKCF0aGlzLnNraXBWYWxpZGF0aW9uKSB7XG4gICAgICBjb25zdCB2YWxpZGF0aW9ucyA9IHRoaXMubm9kZS52YWxpZGF0ZSgpO1xuICAgICAgaWYgKHZhbGlkYXRpb25zLmxlbmd0aCkge1xuICAgICAgICBjb25zdCBlcnJvckxpc3QgPSB2YWxpZGF0aW9ucy5qb2luKFwiXFxuICBcIik7XG4gICAgICAgIHRocm93IG5ldyBFcnJvcihcbiAgICAgICAgICBgQXBwIGxldmVsIHZhbGlkYXRpb24gZmFpbGVkIHdpdGggdGhlIGZvbGxvd2luZyBlcnJvcnM6XFxuICAke2Vycm9yTGlzdH1gXG4gICAgICAgICk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgdGhpcy5tYW5pZmVzdC53cml0ZVRvRmlsZSgpO1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgYSByZWZlcmVuY2UgZnJvbSBvbmUgc3RhY2sgdG8gYW5vdGhlciwgaW52b2tlZCBvbiBwcmVwYXJlU3RhY2sgc2luY2UgaXQgY3JlYXRlcyBleHRyYSByZXNvdXJjZXNcbiAgICovXG4gIHB1YmxpYyBjcm9zc1N0YWNrUmVmZXJlbmNlKFxuICAgIGZyb21TdGFjazogVGVycmFmb3JtU3RhY2ssXG4gICAgdG9TdGFjazogVGVycmFmb3JtU3RhY2ssXG4gICAgaWRlbnRpZmllcjogc3RyaW5nXG4gICk6IHN0cmluZyB7XG4gICAgdG9TdGFjay5hZGREZXBlbmRlbmN5KGZyb21TdGFjayk7XG4gICAgY29uc3Qgb3V0cHV0SWQgPVxuICAgICAgZnJvbVN0YWNrLnJlZ2lzdGVyT3V0Z29pbmdDcm9zc1N0YWNrUmVmZXJlbmNlKFxuICAgICAgICBpZGVudGlmaWVyXG4gICAgICApLmZyaWVuZGx5VW5pcXVlSWQ7XG5cbiAgICBjb25zdCByZW1vdGVTdGF0ZSA9IHRvU3RhY2sucmVnaXN0ZXJJbmNvbWluZ0Nyb3NzU3RhY2tSZWZlcmVuY2UoZnJvbVN0YWNrKTtcblxuICAgIHJldHVybiByZW1vdGVTdGF0ZS5nZXRTdHJpbmcob3V0cHV0SWQpO1xuICB9XG5cbiAgcHJpdmF0ZSBsb2FkQ29udGV4dChkZWZhdWx0czogeyBba2V5OiBzdHJpbmddOiBzdHJpbmcgfSA9IHt9KSB7XG4gICAgY29uc3Qgbm9kZSA9IHRoaXMubm9kZTtcblxuICAgIC8vIHByaW1lIHdpdGggZGVmYXVsdHMgcGFzc2VkIHRocm91Z2ggY29uc3RydWN0b3JcbiAgICBmb3IgKGNvbnN0IFtrLCB2XSBvZiBPYmplY3QuZW50cmllcyhkZWZhdWx0cykpIHtcbiAgICAgIG5vZGUuc2V0Q29udGV4dChrLCB2KTtcbiAgICB9XG5cbiAgICAvLyByZWFkIGZyb20gZW52aXJvbm1lbnRcbiAgICBjb25zdCBjb250ZXh0SnNvbiA9IHByb2Nlc3MuZW52W0NPTlRFWFRfRU5WXTtcbiAgICBjb25zdCBjb250ZXh0RnJvbUVudmlyb25tZW50ID0gY29udGV4dEpzb24gPyBKU09OLnBhcnNlKGNvbnRleHRKc29uKSA6IHt9O1xuXG4gICAgZm9yIChjb25zdCBbaywgdl0gb2YgT2JqZWN0LmVudHJpZXMoY29udGV4dEZyb21FbnZpcm9ubWVudCkpIHtcbiAgICAgIG5vZGUuc2V0Q29udGV4dChrLCB2KTtcbiAgICB9XG4gIH1cbn1cbiJdfQ==