"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataTerraformRemoteStateAzurerm = exports.AzurermBackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_backend_1 = require("../terraform-backend");
const util_1 = require("../util");
const terraform_remote_state_1 = require("../terraform-remote-state");
// eslint-disable-next-line jsdoc/require-jsdoc
class AzurermBackend extends terraform_backend_1.TerraformBackend {
    constructor(scope, props) {
        super(scope, "backend", "azurerm");
        this.props = props;
    }
    synthesizeAttributes() {
        return (0, util_1.keysToSnakeCase)({ ...this.props });
    }
    getRemoteStateDataSource(scope, name, _fromStack) {
        return new DataTerraformRemoteStateAzurerm(scope, name, {
            ...this.props,
            workspace: "${terraform.workspace}",
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
AzurermBackend[_a] = { fqn: "cdktf.AzurermBackend", version: "0.17.0-pre.18" };
exports.AzurermBackend = AzurermBackend;
// eslint-disable-next-line jsdoc/require-jsdoc
class DataTerraformRemoteStateAzurerm extends terraform_remote_state_1.TerraformRemoteState {
    constructor(scope, id, config) {
        super(scope, id, "azurerm", config);
    }
}
_b = JSII_RTTI_SYMBOL_1;
DataTerraformRemoteStateAzurerm[_b] = { fqn: "cdktf.DataTerraformRemoteStateAzurerm", version: "0.17.0-pre.18" };
exports.DataTerraformRemoteStateAzurerm = DataTerraformRemoteStateAzurerm;
//# sourceMappingURL=data:application/json;base64,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