"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataTerraformRemoteStateCos = exports.CosBackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_backend_1 = require("../terraform-backend");
const util_1 = require("../util");
const terraform_remote_state_1 = require("../terraform-remote-state");
// eslint-disable-next-line jsdoc/require-jsdoc
class CosBackend extends terraform_backend_1.TerraformBackend {
    constructor(scope, props) {
        super(scope, "backend", "cos");
        this.props = props;
    }
    synthesizeAttributes() {
        return (0, util_1.keysToSnakeCase)({ ...this.props });
    }
    getRemoteStateDataSource(scope, name, _fromStack) {
        return new DataTerraformRemoteStateCos(scope, name, {
            ...this.props,
            workspace: "${terraform.workspace}",
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
CosBackend[_a] = { fqn: "cdktf.CosBackend", version: "0.17.0-pre.18" };
exports.CosBackend = CosBackend;
// eslint-disable-next-line jsdoc/require-jsdoc
class DataTerraformRemoteStateCos extends terraform_remote_state_1.TerraformRemoteState {
    constructor(scope, id, config) {
        super(scope, id, "cos", config);
    }
}
_b = JSII_RTTI_SYMBOL_1;
DataTerraformRemoteStateCos[_b] = { fqn: "cdktf.DataTerraformRemoteStateCos", version: "0.17.0-pre.18" };
exports.DataTerraformRemoteStateCos = DataTerraformRemoteStateCos;
//# sourceMappingURL=data:application/json;base64,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