"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataTerraformRemoteStateGcs = exports.GcsBackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_backend_1 = require("../terraform-backend");
const util_1 = require("../util");
const terraform_remote_state_1 = require("../terraform-remote-state");
// eslint-disable-next-line jsdoc/require-jsdoc
class GcsBackend extends terraform_backend_1.TerraformBackend {
    constructor(scope, props) {
        super(scope, "backend", "gcs");
        this.props = props;
    }
    synthesizeAttributes() {
        return (0, util_1.keysToSnakeCase)({ ...this.props });
    }
    getRemoteStateDataSource(scope, name, _fromStack) {
        return new DataTerraformRemoteStateGcs(scope, name, {
            ...this.props,
            workspace: "${terraform.workspace}",
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
GcsBackend[_a] = { fqn: "cdktf.GcsBackend", version: "0.17.0-pre.18" };
exports.GcsBackend = GcsBackend;
// eslint-disable-next-line jsdoc/require-jsdoc
class DataTerraformRemoteStateGcs extends terraform_remote_state_1.TerraformRemoteState {
    constructor(scope, id, config) {
        super(scope, id, "gcs", config);
    }
}
_b = JSII_RTTI_SYMBOL_1;
DataTerraformRemoteStateGcs[_b] = { fqn: "cdktf.DataTerraformRemoteStateGcs", version: "0.17.0-pre.18" };
exports.DataTerraformRemoteStateGcs = DataTerraformRemoteStateGcs;
//# sourceMappingURL=data:application/json;base64,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