"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataTerraformRemoteStateLocal = exports.LocalBackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const path = require("path");
const terraform_backend_1 = require("../terraform-backend");
const util_1 = require("../util");
const terraform_remote_state_1 = require("../terraform-remote-state");
const __1 = require("..");
// eslint-disable-next-line jsdoc/require-jsdoc
class LocalBackend extends terraform_backend_1.TerraformBackend {
    constructor(scope, props = {}) {
        super(scope, "backend", "local");
        const stackId = __1.TerraformStack.of(this).node.id;
        this.props = {
            ...props,
            path: props.path || path.join(process.cwd(), `terraform.${stackId}.tfstate`),
        };
    }
    synthesizeAttributes() {
        return (0, util_1.keysToSnakeCase)({ ...this.props });
    }
    getRemoteStateDataSource(scope, name, fromStack) {
        return new DataTerraformRemoteStateLocal(scope, name, {
            workspaceDir: this.props.workspaceDir,
            path: this.props.path ||
                path.join(process.cwd(), `terraform.${fromStack}.tfstate`),
            workspace: "${terraform.workspace}",
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
LocalBackend[_a] = { fqn: "cdktf.LocalBackend", version: "0.17.0-pre.18" };
exports.LocalBackend = LocalBackend;
// eslint-disable-next-line jsdoc/require-jsdoc
class DataTerraformRemoteStateLocal extends terraform_remote_state_1.TerraformRemoteState {
    constructor(scope, id, config) {
        super(scope, id, "local", config);
    }
}
_b = JSII_RTTI_SYMBOL_1;
DataTerraformRemoteStateLocal[_b] = { fqn: "cdktf.DataTerraformRemoteStateLocal", version: "0.17.0-pre.18" };
exports.DataTerraformRemoteStateLocal = DataTerraformRemoteStateLocal;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibG9jYWwtYmFja2VuZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImxvY2FsLWJhY2tlbmQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSwrQkFBK0I7QUFDL0IsbUNBQW1DO0FBQ25DLDZCQUE2QjtBQUU3Qiw0REFBd0Q7QUFDeEQsa0NBQTBDO0FBQzFDLHNFQUdtQztBQUNuQywwQkFBb0M7QUFFcEMsK0NBQStDO0FBQy9DLE1BQWEsWUFBYSxTQUFRLG9DQUFnQjtJQUVoRCxZQUFZLEtBQWdCLEVBQUUsUUFBNEIsRUFBRTtRQUMxRCxLQUFLLENBQUMsS0FBSyxFQUFFLFNBQVMsRUFBRSxPQUFPLENBQUMsQ0FBQztRQUVqQyxNQUFNLE9BQU8sR0FBRyxrQkFBYyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDO1FBQ2hELElBQUksQ0FBQyxLQUFLLEdBQUc7WUFDWCxHQUFHLEtBQUs7WUFDUixJQUFJLEVBQ0YsS0FBSyxDQUFDLElBQUksSUFBSSxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxHQUFHLEVBQUUsRUFBRSxhQUFhLE9BQU8sVUFBVSxDQUFDO1NBQ3pFLENBQUM7SUFDSixDQUFDO0lBRVMsb0JBQW9CO1FBQzVCLE9BQU8sSUFBQSxzQkFBZSxFQUFDLEVBQUUsR0FBRyxJQUFJLENBQUMsS0FBSyxFQUFFLENBQUMsQ0FBQztJQUM1QyxDQUFDO0lBRU0sd0JBQXdCLENBQzdCLEtBQWdCLEVBQ2hCLElBQVksRUFDWixTQUFpQjtRQUVqQixPQUFPLElBQUksNkJBQTZCLENBQUMsS0FBSyxFQUFFLElBQUksRUFBRTtZQUNwRCxZQUFZLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZO1lBQ3JDLElBQUksRUFDRixJQUFJLENBQUMsS0FBSyxDQUFDLElBQUk7Z0JBQ2YsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsR0FBRyxFQUFFLEVBQUUsYUFBYSxTQUFTLFVBQVUsQ0FBQztZQUM1RCxTQUFTLEVBQUUsd0JBQXdCO1NBQ3BDLENBQUMsQ0FBQztJQUNMLENBQUM7Ozs7QUE3QlUsb0NBQVk7QUFnQ3pCLCtDQUErQztBQUMvQyxNQUFhLDZCQUE4QixTQUFRLDZDQUFvQjtJQUNyRSxZQUNFLEtBQWdCLEVBQ2hCLEVBQVUsRUFDVixNQUEyQztRQUUzQyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxPQUFPLEVBQUUsTUFBTSxDQUFDLENBQUM7SUFDcEMsQ0FBQzs7OztBQVBVLHNFQUE2QiIsInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCAoYykgSGFzaGlDb3JwLCBJbmNcbi8vIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBNUEwtMi4wXG5pbXBvcnQgKiBhcyBwYXRoIGZyb20gXCJwYXRoXCI7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tIFwiY29uc3RydWN0c1wiO1xuaW1wb3J0IHsgVGVycmFmb3JtQmFja2VuZCB9IGZyb20gXCIuLi90ZXJyYWZvcm0tYmFja2VuZFwiO1xuaW1wb3J0IHsga2V5c1RvU25ha2VDYXNlIH0gZnJvbSBcIi4uL3V0aWxcIjtcbmltcG9ydCB7XG4gIFRlcnJhZm9ybVJlbW90ZVN0YXRlLFxuICBEYXRhVGVycmFmb3JtUmVtb3RlU3RhdGVDb25maWcsXG59IGZyb20gXCIuLi90ZXJyYWZvcm0tcmVtb3RlLXN0YXRlXCI7XG5pbXBvcnQgeyBUZXJyYWZvcm1TdGFjayB9IGZyb20gXCIuLlwiO1xuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUganNkb2MvcmVxdWlyZS1qc2RvY1xuZXhwb3J0IGNsYXNzIExvY2FsQmFja2VuZCBleHRlbmRzIFRlcnJhZm9ybUJhY2tlbmQge1xuICBwcml2YXRlIHJlYWRvbmx5IHByb3BzOiBMb2NhbEJhY2tlbmRDb25maWc7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIHByb3BzOiBMb2NhbEJhY2tlbmRDb25maWcgPSB7fSkge1xuICAgIHN1cGVyKHNjb3BlLCBcImJhY2tlbmRcIiwgXCJsb2NhbFwiKTtcblxuICAgIGNvbnN0IHN0YWNrSWQgPSBUZXJyYWZvcm1TdGFjay5vZih0aGlzKS5ub2RlLmlkO1xuICAgIHRoaXMucHJvcHMgPSB7XG4gICAgICAuLi5wcm9wcyxcbiAgICAgIHBhdGg6XG4gICAgICAgIHByb3BzLnBhdGggfHwgcGF0aC5qb2luKHByb2Nlc3MuY3dkKCksIGB0ZXJyYWZvcm0uJHtzdGFja0lkfS50ZnN0YXRlYCksXG4gICAgfTtcbiAgfVxuXG4gIHByb3RlY3RlZCBzeW50aGVzaXplQXR0cmlidXRlcygpOiB7IFtuYW1lOiBzdHJpbmddOiBhbnkgfSB7XG4gICAgcmV0dXJuIGtleXNUb1NuYWtlQ2FzZSh7IC4uLnRoaXMucHJvcHMgfSk7XG4gIH1cblxuICBwdWJsaWMgZ2V0UmVtb3RlU3RhdGVEYXRhU291cmNlKFxuICAgIHNjb3BlOiBDb25zdHJ1Y3QsXG4gICAgbmFtZTogc3RyaW5nLFxuICAgIGZyb21TdGFjazogc3RyaW5nXG4gICk6IFRlcnJhZm9ybVJlbW90ZVN0YXRlIHtcbiAgICByZXR1cm4gbmV3IERhdGFUZXJyYWZvcm1SZW1vdGVTdGF0ZUxvY2FsKHNjb3BlLCBuYW1lLCB7XG4gICAgICB3b3Jrc3BhY2VEaXI6IHRoaXMucHJvcHMud29ya3NwYWNlRGlyLFxuICAgICAgcGF0aDpcbiAgICAgICAgdGhpcy5wcm9wcy5wYXRoIHx8XG4gICAgICAgIHBhdGguam9pbihwcm9jZXNzLmN3ZCgpLCBgdGVycmFmb3JtLiR7ZnJvbVN0YWNrfS50ZnN0YXRlYCksXG4gICAgICB3b3Jrc3BhY2U6IFwiJHt0ZXJyYWZvcm0ud29ya3NwYWNlfVwiLFxuICAgIH0pO1xuICB9XG59XG5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBqc2RvYy9yZXF1aXJlLWpzZG9jXG5leHBvcnQgY2xhc3MgRGF0YVRlcnJhZm9ybVJlbW90ZVN0YXRlTG9jYWwgZXh0ZW5kcyBUZXJyYWZvcm1SZW1vdGVTdGF0ZSB7XG4gIGNvbnN0cnVjdG9yKFxuICAgIHNjb3BlOiBDb25zdHJ1Y3QsXG4gICAgaWQ6IHN0cmluZyxcbiAgICBjb25maWc6IERhdGFUZXJyYWZvcm1SZW1vdGVTdGF0ZUxvY2FsQ29uZmlnXG4gICkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgXCJsb2NhbFwiLCBjb25maWcpO1xuICB9XG59XG4vKipcbiAqIFRoZSBsb2NhbCBiYWNrZW5kIHN0b3JlcyBzdGF0ZSBvbiB0aGUgbG9jYWwgZmlsZXN5c3RlbSxcbiAqIGxvY2tzIHRoYXQgc3RhdGUgdXNpbmcgc3lzdGVtIEFQSXMsIGFuZCBwZXJmb3JtcyBvcGVyYXRpb25zIGxvY2FsbHkuXG4gKlxuICogUmVhZCBtb3JlIGFib3V0IHRoaXMgYmFja2VuZCBpbiB0aGUgVGVycmFmb3JtIGRvY3M6XG4gKiBodHRwczovL2RldmVsb3Blci5oYXNoaWNvcnAuY29tL3RlcnJhZm9ybS9sYW5ndWFnZS9zZXR0aW5ncy9iYWNrZW5kcy9sb2NhbFxuICovXG5leHBvcnQgaW50ZXJmYWNlIExvY2FsQmFja2VuZENvbmZpZyB7XG4gIC8qKlxuICAgKiBQYXRoIHdoZXJlIHRoZSBzdGF0ZSBmaWxlIGlzIHN0b3JlZC5cbiAgICogQGRlZmF1bHQgLSBkZWZhdWx0cyB0byB0ZXJyYWZvcm0uJHtzdGFja0lkfS50ZnN0YXRlXG4gICAqL1xuICByZWFkb25seSBwYXRoPzogc3RyaW5nO1xuICAvKipcbiAgICogKE9wdGlvbmFsKSBUaGUgcGF0aCB0byBub24tZGVmYXVsdCB3b3Jrc3BhY2VzLlxuICAgKi9cbiAgcmVhZG9ubHkgd29ya3NwYWNlRGlyPzogc3RyaW5nO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIERhdGFUZXJyYWZvcm1SZW1vdGVTdGF0ZUxvY2FsQ29uZmlnXG4gIGV4dGVuZHMgRGF0YVRlcnJhZm9ybVJlbW90ZVN0YXRlQ29uZmlnLFxuICAgIExvY2FsQmFja2VuZENvbmZpZyB7fVxuIl19