"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataTerraformRemoteStatePg = exports.PgBackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_backend_1 = require("../terraform-backend");
const util_1 = require("../util");
const terraform_remote_state_1 = require("../terraform-remote-state");
// eslint-disable-next-line jsdoc/require-jsdoc
class PgBackend extends terraform_backend_1.TerraformBackend {
    constructor(scope, props) {
        super(scope, "backend", "pg");
        this.props = props;
    }
    synthesizeAttributes() {
        return (0, util_1.keysToSnakeCase)({ ...this.props });
    }
    getRemoteStateDataSource(scope, name, _fromStack) {
        return new DataTerraformRemoteStatePg(scope, name, {
            ...this.props,
            workspace: "${terraform.workspace}",
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
PgBackend[_a] = { fqn: "cdktf.PgBackend", version: "0.17.0-pre.18" };
exports.PgBackend = PgBackend;
// eslint-disable-next-line jsdoc/require-jsdoc
class DataTerraformRemoteStatePg extends terraform_remote_state_1.TerraformRemoteState {
    constructor(scope, id, config) {
        super(scope, id, "pg", config);
    }
}
_b = JSII_RTTI_SYMBOL_1;
DataTerraformRemoteStatePg[_b] = { fqn: "cdktf.DataTerraformRemoteStatePg", version: "0.17.0-pre.18" };
exports.DataTerraformRemoteStatePg = DataTerraformRemoteStatePg;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGctYmFja2VuZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInBnLWJhY2tlbmQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFHQSw0REFBd0Q7QUFDeEQsa0NBQTBDO0FBQzFDLHNFQUdtQztBQUVuQywrQ0FBK0M7QUFDL0MsTUFBYSxTQUFVLFNBQVEsb0NBQWdCO0lBQzdDLFlBQVksS0FBZ0IsRUFBbUIsS0FBc0I7UUFDbkUsS0FBSyxDQUFDLEtBQUssRUFBRSxTQUFTLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFEZSxVQUFLLEdBQUwsS0FBSyxDQUFpQjtJQUVyRSxDQUFDO0lBRVMsb0JBQW9CO1FBQzVCLE9BQU8sSUFBQSxzQkFBZSxFQUFDLEVBQUUsR0FBRyxJQUFJLENBQUMsS0FBSyxFQUFFLENBQUMsQ0FBQztJQUM1QyxDQUFDO0lBRU0sd0JBQXdCLENBQzdCLEtBQWdCLEVBQ2hCLElBQVksRUFDWixVQUFrQjtRQUVsQixPQUFPLElBQUksMEJBQTBCLENBQUMsS0FBSyxFQUFFLElBQUksRUFBRTtZQUNqRCxHQUFHLElBQUksQ0FBQyxLQUFLO1lBQ2IsU0FBUyxFQUFFLHdCQUF3QjtTQUNwQyxDQUFDLENBQUM7SUFDTCxDQUFDOzs7O0FBbEJVLDhCQUFTO0FBcUJ0QiwrQ0FBK0M7QUFDL0MsTUFBYSwwQkFBMkIsU0FBUSw2Q0FBb0I7SUFDbEUsWUFDRSxLQUFnQixFQUNoQixFQUFVLEVBQ1YsTUFBd0M7UUFFeEMsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsSUFBSSxFQUFFLE1BQU0sQ0FBQyxDQUFDO0lBQ2pDLENBQUM7Ozs7QUFQVSxnRUFBMEIiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgKGMpIEhhc2hpQ29ycCwgSW5jXG4vLyBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogTVBMLTIuMFxuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSBcImNvbnN0cnVjdHNcIjtcbmltcG9ydCB7IFRlcnJhZm9ybUJhY2tlbmQgfSBmcm9tIFwiLi4vdGVycmFmb3JtLWJhY2tlbmRcIjtcbmltcG9ydCB7IGtleXNUb1NuYWtlQ2FzZSB9IGZyb20gXCIuLi91dGlsXCI7XG5pbXBvcnQge1xuICBUZXJyYWZvcm1SZW1vdGVTdGF0ZSxcbiAgRGF0YVRlcnJhZm9ybVJlbW90ZVN0YXRlQ29uZmlnLFxufSBmcm9tIFwiLi4vdGVycmFmb3JtLXJlbW90ZS1zdGF0ZVwiO1xuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUganNkb2MvcmVxdWlyZS1qc2RvY1xuZXhwb3J0IGNsYXNzIFBnQmFja2VuZCBleHRlbmRzIFRlcnJhZm9ybUJhY2tlbmQge1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBwcml2YXRlIHJlYWRvbmx5IHByb3BzOiBQZ0JhY2tlbmRDb25maWcpIHtcbiAgICBzdXBlcihzY29wZSwgXCJiYWNrZW5kXCIsIFwicGdcIik7XG4gIH1cblxuICBwcm90ZWN0ZWQgc3ludGhlc2l6ZUF0dHJpYnV0ZXMoKTogeyBbbmFtZTogc3RyaW5nXTogYW55IH0ge1xuICAgIHJldHVybiBrZXlzVG9TbmFrZUNhc2UoeyAuLi50aGlzLnByb3BzIH0pO1xuICB9XG5cbiAgcHVibGljIGdldFJlbW90ZVN0YXRlRGF0YVNvdXJjZShcbiAgICBzY29wZTogQ29uc3RydWN0LFxuICAgIG5hbWU6IHN0cmluZyxcbiAgICBfZnJvbVN0YWNrOiBzdHJpbmdcbiAgKTogVGVycmFmb3JtUmVtb3RlU3RhdGUge1xuICAgIHJldHVybiBuZXcgRGF0YVRlcnJhZm9ybVJlbW90ZVN0YXRlUGcoc2NvcGUsIG5hbWUsIHtcbiAgICAgIC4uLnRoaXMucHJvcHMsXG4gICAgICB3b3Jrc3BhY2U6IFwiJHt0ZXJyYWZvcm0ud29ya3NwYWNlfVwiLFxuICAgIH0pO1xuICB9XG59XG5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBqc2RvYy9yZXF1aXJlLWpzZG9jXG5leHBvcnQgY2xhc3MgRGF0YVRlcnJhZm9ybVJlbW90ZVN0YXRlUGcgZXh0ZW5kcyBUZXJyYWZvcm1SZW1vdGVTdGF0ZSB7XG4gIGNvbnN0cnVjdG9yKFxuICAgIHNjb3BlOiBDb25zdHJ1Y3QsXG4gICAgaWQ6IHN0cmluZyxcbiAgICBjb25maWc6IERhdGFUZXJyYWZvcm1SZW1vdGVTdGF0ZVBnQ29uZmlnXG4gICkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgXCJwZ1wiLCBjb25maWcpO1xuICB9XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgUGdCYWNrZW5kQ29uZmlnIHtcbiAgcmVhZG9ubHkgY29ublN0cjogc3RyaW5nO1xuICByZWFkb25seSBzY2hlbWFOYW1lPzogc3RyaW5nO1xuICByZWFkb25seSBza2lwU2NoZW1hQ3JlYXRpb24/OiBib29sZWFuO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIERhdGFUZXJyYWZvcm1SZW1vdGVTdGF0ZVBnQ29uZmlnXG4gIGV4dGVuZHMgRGF0YVRlcnJhZm9ybVJlbW90ZVN0YXRlQ29uZmlnLFxuICAgIFBnQmFja2VuZENvbmZpZyB7fVxuIl19