import { Construct } from "constructs";
import { TerraformBackend } from "../terraform-backend";
import { TerraformRemoteState, DataTerraformRemoteStateConfig } from "../terraform-remote-state";
export declare class RemoteBackend extends TerraformBackend {
    private readonly props;
    constructor(scope: Construct, props: RemoteBackendConfig);
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    toMetadata(): any;
    getRemoteStateDataSource(scope: Construct, name: string, _fromStack: string): TerraformRemoteState;
}
export declare class DataTerraformRemoteState extends TerraformRemoteState {
    constructor(scope: Construct, id: string, config: DataTerraformRemoteStateRemoteConfig);
}
export interface RemoteBackendConfig {
    readonly hostname?: string;
    readonly organization: string;
    readonly token?: string;
    readonly workspaces: IRemoteWorkspace;
}
export interface IRemoteWorkspace {
}
export declare class NamedRemoteWorkspace implements IRemoteWorkspace {
    name: string;
    constructor(name: string);
}
export declare class PrefixedRemoteWorkspaces implements IRemoteWorkspace {
    prefix: string;
    constructor(prefix: string);
}
export interface DataTerraformRemoteStateRemoteConfig extends DataTerraformRemoteStateConfig, RemoteBackendConfig {
}
