"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrefixedRemoteWorkspaces = exports.NamedRemoteWorkspace = exports.DataTerraformRemoteState = exports.RemoteBackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_backend_1 = require("../terraform-backend");
const util_1 = require("../util");
const terraform_remote_state_1 = require("../terraform-remote-state");
const cloud_backend_1 = require("./cloud-backend");
// eslint-disable-next-line jsdoc/require-jsdoc
class RemoteBackend extends terraform_backend_1.TerraformBackend {
    constructor(scope, props) {
        super(scope, "backend", "remote");
        this.props = props;
    }
    synthesizeAttributes() {
        return (0, util_1.keysToSnakeCase)({ ...this.props });
    }
    toMetadata() {
        const cloud = (0, cloud_backend_1.getHostNameType)(this.props.hostname);
        return { ...super.toMetadata(), cloud };
    }
    getRemoteStateDataSource(scope, name, _fromStack) {
        return new DataTerraformRemoteState(scope, name, {
            ...this.props,
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
RemoteBackend[_a] = { fqn: "cdktf.RemoteBackend", version: "0.17.0-pre.18" };
exports.RemoteBackend = RemoteBackend;
// eslint-disable-next-line jsdoc/require-jsdoc
class DataTerraformRemoteState extends terraform_remote_state_1.TerraformRemoteState {
    constructor(scope, id, config) {
        super(scope, id, "remote", config);
    }
}
_b = JSII_RTTI_SYMBOL_1;
DataTerraformRemoteState[_b] = { fqn: "cdktf.DataTerraformRemoteState", version: "0.17.0-pre.18" };
exports.DataTerraformRemoteState = DataTerraformRemoteState;
// eslint-disable-next-line jsdoc/require-jsdoc
class NamedRemoteWorkspace {
    constructor(name) {
        this.name = name;
    }
}
_c = JSII_RTTI_SYMBOL_1;
NamedRemoteWorkspace[_c] = { fqn: "cdktf.NamedRemoteWorkspace", version: "0.17.0-pre.18" };
exports.NamedRemoteWorkspace = NamedRemoteWorkspace;
// eslint-disable-next-line jsdoc/require-jsdoc
class PrefixedRemoteWorkspaces {
    constructor(prefix) {
        this.prefix = prefix;
    }
}
_d = JSII_RTTI_SYMBOL_1;
PrefixedRemoteWorkspaces[_d] = { fqn: "cdktf.PrefixedRemoteWorkspaces", version: "0.17.0-pre.18" };
exports.PrefixedRemoteWorkspaces = PrefixedRemoteWorkspaces;
//# sourceMappingURL=data:application/json;base64,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