"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataTerraformRemoteStateS3 = exports.S3Backend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_backend_1 = require("../terraform-backend");
const util_1 = require("../util");
const terraform_remote_state_1 = require("../terraform-remote-state");
// eslint-disable-next-line jsdoc/require-jsdoc
class S3Backend extends terraform_backend_1.TerraformBackend {
    constructor(scope, props) {
        super(scope, "backend", "s3");
        this.props = props;
    }
    synthesizeAttributes() {
        return (0, util_1.keysToSnakeCase)({ ...this.props });
    }
    getRemoteStateDataSource(scope, name, _fromStack) {
        return new DataTerraformRemoteStateS3(scope, name, {
            ...this.props,
            workspace: "${terraform.workspace}",
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
S3Backend[_a] = { fqn: "cdktf.S3Backend", version: "0.17.0-pre.18" };
exports.S3Backend = S3Backend;
// eslint-disable-next-line jsdoc/require-jsdoc
class DataTerraformRemoteStateS3 extends terraform_remote_state_1.TerraformRemoteState {
    constructor(scope, id, config) {
        super(scope, id, "s3", config);
    }
}
_b = JSII_RTTI_SYMBOL_1;
DataTerraformRemoteStateS3[_b] = { fqn: "cdktf.DataTerraformRemoteStateS3", version: "0.17.0-pre.18" };
exports.DataTerraformRemoteStateS3 = DataTerraformRemoteStateS3;
//# sourceMappingURL=data:application/json;base64,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