"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AnyListMap = exports.BooleanListMap = exports.NumberListMap = exports.StringListMap = exports.AnyMapList = exports.BooleanMapList = exports.NumberMapList = exports.StringMapList = exports.MapList = exports.ComplexObject = exports.ComplexMap = exports.BooleanList = exports.ComplexList = exports.ComplexComputedList = exports.AnyMap = exports.BooleanMap = exports.NumberMap = exports.StringMap = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const tokens_1 = require("./tokens");
const _1 = require(".");
const stack_trace_1 = require("./tokens/private/stack-trace");
// eslint-disable-next-line jsdoc/require-jsdoc
class ComplexResolvable {
    constructor(terraformResource, terraformAttribute) {
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.creationStack = (0, stack_trace_1.captureStackTrace)();
    }
    get fqn() {
        if (!this._fqn) {
            this._fqn = this.computeFqn();
        }
        return this._fqn;
    }
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    resolve(_context) {
        return this.fqn;
    }
    toString() {
        return tokens_1.Token.asString(this);
    }
}
// eslint-disable-next-line jsdoc/require-jsdoc
class ComplexComputedAttribute extends ComplexResolvable {
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    getStringAttribute(terraformAttribute) {
        return tokens_1.Token.asString(this.interpolationForAttribute(terraformAttribute));
    }
    getNumberAttribute(terraformAttribute) {
        return tokens_1.Token.asNumber(this.interpolationForAttribute(terraformAttribute));
    }
    getListAttribute(terraformAttribute) {
        return tokens_1.Token.asList(this.interpolationForAttribute(terraformAttribute));
    }
    getBooleanAttribute(terraformAttribute) {
        return this.interpolationForAttribute(terraformAttribute);
    }
    getNumberListAttribute(terraformAttribute) {
        return tokens_1.Token.asNumberList(this.interpolationForAttribute(terraformAttribute));
    }
    getStringMapAttribute(terraformAttribute) {
        return tokens_1.Token.asStringMap(this.interpolationForAttribute(terraformAttribute));
    }
    getNumberMapAttribute(terraformAttribute) {
        return tokens_1.Token.asNumberMap(this.interpolationForAttribute(terraformAttribute));
    }
    getBooleanMapAttribute(terraformAttribute) {
        return tokens_1.Token.asBooleanMap(this.interpolationForAttribute(terraformAttribute));
    }
    getAnyMapAttribute(terraformAttribute) {
        return tokens_1.Token.asAnyMap(this.interpolationForAttribute(terraformAttribute));
    }
}
// eslint-disable-next-line jsdoc/require-jsdoc
class StringMap extends ComplexResolvable {
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    lookup(key) {
        return tokens_1.Token.asString(this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}["${key}"]`));
    }
    computeFqn() {
        return tokens_1.Token.asString(this.terraformResource.interpolationForAttribute(this.terraformAttribute));
    }
}
_a = JSII_RTTI_SYMBOL_1;
StringMap[_a] = { fqn: "cdktf.StringMap", version: "0.17.0-pre.18" };
exports.StringMap = StringMap;
// eslint-disable-next-line jsdoc/require-jsdoc
class NumberMap extends ComplexResolvable {
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    lookup(key) {
        return tokens_1.Token.asNumber(this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}["${key}"]`));
    }
    computeFqn() {
        return tokens_1.Token.asString(this.terraformResource.interpolationForAttribute(this.terraformAttribute));
    }
}
_b = JSII_RTTI_SYMBOL_1;
NumberMap[_b] = { fqn: "cdktf.NumberMap", version: "0.17.0-pre.18" };
exports.NumberMap = NumberMap;
// eslint-disable-next-line jsdoc/require-jsdoc
class BooleanMap extends ComplexResolvable {
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    lookup(key) {
        return this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}["${key}"]`);
    }
    computeFqn() {
        return tokens_1.Token.asString(this.terraformResource.interpolationForAttribute(this.terraformAttribute));
    }
}
_c = JSII_RTTI_SYMBOL_1;
BooleanMap[_c] = { fqn: "cdktf.BooleanMap", version: "0.17.0-pre.18" };
exports.BooleanMap = BooleanMap;
// eslint-disable-next-line jsdoc/require-jsdoc
class AnyMap extends ComplexResolvable {
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    lookup(key) {
        return tokens_1.Token.asAny(this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}["${key}"]`));
    }
    computeFqn() {
        return tokens_1.Token.asString(this.terraformResource.interpolationForAttribute(this.terraformAttribute));
    }
}
_d = JSII_RTTI_SYMBOL_1;
AnyMap[_d] = { fqn: "cdktf.AnyMap", version: "0.17.0-pre.18" };
exports.AnyMap = AnyMap;
/**
 * @deprecated Going to be replaced by Array of ComplexListItem
 * and will be removed in the future
 */
class ComplexComputedList extends ComplexComputedAttribute {
    constructor(terraformResource, terraformAttribute, complexComputedListIndex, wrapsSet) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.complexComputedListIndex = complexComputedListIndex;
        this.wrapsSet = wrapsSet;
        throw new Error("Version mismatch detected: The provider bindings seem to have been built for an older version of CDKTF. Upgrade your pre-built provider or re-run cdktf get with a more recent version (>= 0.10) of the cdktf-cli.");
    }
    interpolationForAttribute(property) {
        if (this.wrapsSet) {
            return (0, _1.propertyAccess)(_1.Fn.tolist(this.terraformResource.interpolationForAttribute(this.terraformAttribute)), [this.complexComputedListIndex, property]);
        }
        return this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}[${this.complexComputedListIndex}].${property}`);
    }
    computeFqn() {
        if (this.wrapsSet) {
            return tokens_1.Token.asString((0, _1.propertyAccess)(_1.Fn.tolist(this.terraformResource.interpolationForAttribute(this.terraformAttribute)), [this.complexComputedListIndex]));
        }
        return tokens_1.Token.asString(this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}[${this.complexComputedListIndex}]`));
    }
}
_e = JSII_RTTI_SYMBOL_1;
ComplexComputedList[_e] = { fqn: "cdktf.ComplexComputedList", version: "0.17.0-pre.18" };
exports.ComplexComputedList = ComplexComputedList;
// eslint-disable-next-line jsdoc/require-jsdoc
class ComplexList extends ComplexResolvable {
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    computeFqn() {
        if (this.wrapsSet) {
            return tokens_1.Token.asString(_1.Fn.tolist(this.terraformResource.interpolationForAttribute(this.terraformAttribute)));
        }
        else {
            return tokens_1.Token.asString(this.terraformResource.interpolationForAttribute(this.terraformAttribute));
        }
    }
}
_f = JSII_RTTI_SYMBOL_1;
ComplexList[_f] = { fqn: "cdktf.ComplexList", version: "0.17.0-pre.18" };
exports.ComplexList = ComplexList;
// eslint-disable-next-line jsdoc/require-jsdoc
class BooleanList extends ComplexList {
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    get(index) {
        return _1.Fn.element(this, index);
    }
}
_g = JSII_RTTI_SYMBOL_1;
BooleanList[_g] = { fqn: "cdktf.BooleanList", version: "0.17.0-pre.18" };
exports.BooleanList = BooleanList;
// eslint-disable-next-line jsdoc/require-jsdoc
class ComplexMap extends ComplexResolvable {
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    computeFqn() {
        return tokens_1.Token.asString(this.terraformResource.interpolationForAttribute(this.terraformAttribute));
    }
    interpolationForAttribute(property) {
        return (0, _1.propertyAccess)(this.terraformResource.interpolationForAttribute(this.terraformAttribute), [property]);
    }
}
_h = JSII_RTTI_SYMBOL_1;
ComplexMap[_h] = { fqn: "cdktf.ComplexMap", version: "0.17.0-pre.18" };
exports.ComplexMap = ComplexMap;
// eslint-disable-next-line jsdoc/require-jsdoc
class ComplexObject extends ComplexComputedAttribute {
    /**
     * @param terraformResource
     * @param terraformAttribute
     * @param complexObjectIndex the index of the complex object in a list
     * @param complexObjectIsFromSet set to true if this item is from inside a set and needs tolist() for accessing it
     *                               set to "0" for single list items
     */
    constructor(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.complexObjectIsFromSet = complexObjectIsFromSet;
        this.complexObjectIndex = complexObjectIndex;
    }
    interpolationForAttribute(property) {
        if (this.complexObjectIsFromSet) {
            return (0, _1.propertyAccess)(_1.Fn.tolist(this.terraformResource.interpolationForAttribute(this.terraformAttribute)), [this.complexObjectIndex, property]);
        }
        return this.terraformResource.interpolationForAttribute(this.complexObjectIndex !== undefined
            ? `${this.terraformAttribute}[${this.complexObjectIndex}].${property}`
            : `${this.terraformAttribute}.${property}`);
    }
    interpolationAsList() {
        return this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}.*`);
    }
    computeFqn() {
        if (this.complexObjectIsFromSet) {
            return tokens_1.Token.asString((0, _1.propertyAccess)(_1.Fn.tolist(this.terraformResource.interpolationForAttribute(this.terraformAttribute)), [this.complexObjectIndex]));
        }
        return tokens_1.Token.asString(this.terraformResource.interpolationForAttribute(this.complexObjectIndex !== undefined
            ? `${this.terraformAttribute}[${this.complexObjectIndex}]`
            : this.terraformAttribute));
    }
}
_j = JSII_RTTI_SYMBOL_1;
ComplexObject[_j] = { fqn: "cdktf.ComplexObject", version: "0.17.0-pre.18" };
exports.ComplexObject = ComplexObject;
// eslint-disable-next-line jsdoc/require-jsdoc
class MapList extends ComplexResolvable {
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    computeFqn() {
        if (this.wrapsSet) {
            return tokens_1.Token.asString(_1.Fn.tolist(this.terraformResource.interpolationForAttribute(this.terraformAttribute)));
        }
        else {
            return tokens_1.Token.asString(this.terraformResource.interpolationForAttribute(this.terraformAttribute));
        }
    }
    interpolationForAttribute(property) {
        if (this.wrapsSet) {
            const matches = property.match(/\[([^\]]*)\]/); // need to extract out the index
            if (matches) {
                return (0, _1.propertyAccess)(_1.Fn.tolist(this.terraformResource.interpolationForAttribute(this.terraformAttribute)), [matches[1], property]);
            }
        }
        return this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}${property}`);
    }
}
_k = JSII_RTTI_SYMBOL_1;
MapList[_k] = { fqn: "cdktf.MapList", version: "0.17.0-pre.18" };
exports.MapList = MapList;
// eslint-disable-next-line jsdoc/require-jsdoc
class StringMapList extends MapList {
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    get(index) {
        return new StringMap(this, `[${index}]`);
    }
}
_l = JSII_RTTI_SYMBOL_1;
StringMapList[_l] = { fqn: "cdktf.StringMapList", version: "0.17.0-pre.18" };
exports.StringMapList = StringMapList;
// eslint-disable-next-line jsdoc/require-jsdoc
class NumberMapList extends MapList {
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    get(index) {
        return new NumberMap(this, `[${index}]`);
    }
}
_m = JSII_RTTI_SYMBOL_1;
NumberMapList[_m] = { fqn: "cdktf.NumberMapList", version: "0.17.0-pre.18" };
exports.NumberMapList = NumberMapList;
// eslint-disable-next-line jsdoc/require-jsdoc
class BooleanMapList extends MapList {
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    get(index) {
        return new BooleanMap(this, `[${index}]`);
    }
}
_o = JSII_RTTI_SYMBOL_1;
BooleanMapList[_o] = { fqn: "cdktf.BooleanMapList", version: "0.17.0-pre.18" };
exports.BooleanMapList = BooleanMapList;
// eslint-disable-next-line jsdoc/require-jsdoc
class AnyMapList extends MapList {
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    get(index) {
        return new AnyMap(this, `[${index}]`);
    }
}
_p = JSII_RTTI_SYMBOL_1;
AnyMapList[_p] = { fqn: "cdktf.AnyMapList", version: "0.17.0-pre.18" };
exports.AnyMapList = AnyMapList;
// eslint-disable-next-line jsdoc/require-jsdoc
class StringListMap extends ComplexMap {
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    get(key) {
        return tokens_1.Token.asList(this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}[${key}]`));
    }
}
_q = JSII_RTTI_SYMBOL_1;
StringListMap[_q] = { fqn: "cdktf.StringListMap", version: "0.17.0-pre.18" };
exports.StringListMap = StringListMap;
// eslint-disable-next-line jsdoc/require-jsdoc
class NumberListMap extends ComplexMap {
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    get(key) {
        return tokens_1.Token.asNumberList(this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}[${key}]`));
    }
}
_r = JSII_RTTI_SYMBOL_1;
NumberListMap[_r] = { fqn: "cdktf.NumberListMap", version: "0.17.0-pre.18" };
exports.NumberListMap = NumberListMap;
// eslint-disable-next-line jsdoc/require-jsdoc
class BooleanListMap extends ComplexMap {
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    get(key) {
        // This isn't fully supported
        return this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}[${key}]`);
    }
}
_s = JSII_RTTI_SYMBOL_1;
BooleanListMap[_s] = { fqn: "cdktf.BooleanListMap", version: "0.17.0-pre.18" };
exports.BooleanListMap = BooleanListMap;
// eslint-disable-next-line jsdoc/require-jsdoc
class AnyListMap extends ComplexMap {
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    get(key) {
        // This isn't fully supported
        return this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}[${key}]`);
    }
}
_t = JSII_RTTI_SYMBOL_1;
AnyListMap[_t] = { fqn: "cdktf.AnyListMap", version: "0.17.0-pre.18" };
exports.AnyListMap = AnyListMap;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29tcGxleC1jb21wdXRlZC1saXN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiY29tcGxleC1jb21wdXRlZC1saXN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsK0JBQStCO0FBQy9CLG1DQUFtQztBQUNuQyxxQ0FBK0Q7QUFLL0Qsd0JBQXVDO0FBQ3ZDLDhEQUFpRTtBQUVqRSwrQ0FBK0M7QUFDL0MsTUFBZSxpQkFBaUI7SUFROUIsWUFDWSxpQkFBdUMsRUFDdkMsa0JBQTBCO1FBRDFCLHNCQUFpQixHQUFqQixpQkFBaUIsQ0FBc0I7UUFDdkMsdUJBQWtCLEdBQWxCLGtCQUFrQixDQUFRO1FBRXBDLElBQUksQ0FBQyxhQUFhLEdBQUcsSUFBQSwrQkFBaUIsR0FBRSxDQUFDO0lBQzNDLENBQUM7SUFJRCxJQUFJLEdBQUc7UUFDTCxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRTtZQUNkLElBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDLFVBQVUsRUFBRSxDQUFDO1NBQy9CO1FBRUQsT0FBTyxJQUFJLENBQUMsSUFBSSxDQUFDO0lBQ25CLENBQUM7SUFFRCw2REFBNkQ7SUFDN0QsT0FBTyxDQUFDLFFBQXlCO1FBQy9CLE9BQU8sSUFBSSxDQUFDLEdBQUcsQ0FBQztJQUNsQixDQUFDO0lBRUQsUUFBUTtRQUNOLE9BQU8sY0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUM5QixDQUFDO0NBQ0Y7QUFFRCwrQ0FBK0M7QUFDL0MsTUFBZSx3QkFDYixTQUFRLGlCQUFpQjtJQUd6QixZQUNZLGlCQUF1QyxFQUN2QyxrQkFBMEI7UUFFcEMsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixDQUFDLENBQUM7UUFIbkMsc0JBQWlCLEdBQWpCLGlCQUFpQixDQUFzQjtRQUN2Qyx1QkFBa0IsR0FBbEIsa0JBQWtCLENBQVE7SUFHdEMsQ0FBQztJQUVNLGtCQUFrQixDQUFDLGtCQUEwQjtRQUNsRCxPQUFPLGNBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLHlCQUF5QixDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQztJQUM1RSxDQUFDO0lBRU0sa0JBQWtCLENBQUMsa0JBQTBCO1FBQ2xELE9BQU8sY0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMseUJBQXlCLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxDQUFDO0lBQzVFLENBQUM7SUFFTSxnQkFBZ0IsQ0FBQyxrQkFBMEI7UUFDaEQsT0FBTyxjQUFLLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyx5QkFBeUIsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLENBQUM7SUFDMUUsQ0FBQztJQUVNLG1CQUFtQixDQUFDLGtCQUEwQjtRQUNuRCxPQUFPLElBQUksQ0FBQyx5QkFBeUIsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQzVELENBQUM7SUFFTSxzQkFBc0IsQ0FBQyxrQkFBMEI7UUFDdEQsT0FBTyxjQUFLLENBQUMsWUFBWSxDQUN2QixJQUFJLENBQUMseUJBQXlCLENBQUMsa0JBQWtCLENBQUMsQ0FDbkQsQ0FBQztJQUNKLENBQUM7SUFFTSxxQkFBcUIsQ0FBQyxrQkFBMEI7UUFDckQsT0FBTyxjQUFLLENBQUMsV0FBVyxDQUN0QixJQUFJLENBQUMseUJBQXlCLENBQUMsa0JBQWtCLENBQUMsQ0FDbkQsQ0FBQztJQUNKLENBQUM7SUFFTSxxQkFBcUIsQ0FBQyxrQkFBMEI7UUFDckQsT0FBTyxjQUFLLENBQUMsV0FBVyxDQUN0QixJQUFJLENBQUMseUJBQXlCLENBQUMsa0JBQWtCLENBQUMsQ0FDbkQsQ0FBQztJQUNKLENBQUM7SUFFTSxzQkFBc0IsQ0FBQyxrQkFBMEI7UUFDdEQsT0FBTyxjQUFLLENBQUMsWUFBWSxDQUN2QixJQUFJLENBQUMseUJBQXlCLENBQUMsa0JBQWtCLENBQUMsQ0FDbkQsQ0FBQztJQUNKLENBQUM7SUFFTSxrQkFBa0IsQ0FBQyxrQkFBMEI7UUFDbEQsT0FBTyxjQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyx5QkFBeUIsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLENBQUM7SUFDNUUsQ0FBQztDQUdGO0FBRUQsK0NBQStDO0FBQy9DLE1BQWEsU0FDWCxTQUFRLGlCQUFpQjtJQUd6QixZQUNZLGlCQUF1QyxFQUN2QyxrQkFBMEI7UUFFcEMsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixDQUFDLENBQUM7UUFIbkMsc0JBQWlCLEdBQWpCLGlCQUFpQixDQUFzQjtRQUN2Qyx1QkFBa0IsR0FBbEIsa0JBQWtCLENBQVE7SUFHdEMsQ0FBQztJQUVNLE1BQU0sQ0FBQyxHQUFXO1FBQ3ZCLE9BQU8sY0FBSyxDQUFDLFFBQVEsQ0FDbkIsSUFBSSxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixDQUM5QyxHQUFHLElBQUksQ0FBQyxrQkFBa0IsS0FBSyxHQUFHLElBQUksQ0FDdkMsQ0FDRixDQUFDO0lBQ0osQ0FBQztJQUVELFVBQVU7UUFDUixPQUFPLGNBQUssQ0FBQyxRQUFRLENBQ25CLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsQ0FBQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsQ0FDMUUsQ0FBQztJQUNKLENBQUM7Ozs7QUF2QlUsOEJBQVM7QUEwQnRCLCtDQUErQztBQUMvQyxNQUFhLFNBQ1gsU0FBUSxpQkFBaUI7SUFHekIsWUFDWSxpQkFBdUMsRUFDdkMsa0JBQTBCO1FBRXBDLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsQ0FBQyxDQUFDO1FBSG5DLHNCQUFpQixHQUFqQixpQkFBaUIsQ0FBc0I7UUFDdkMsdUJBQWtCLEdBQWxCLGtCQUFrQixDQUFRO0lBR3RDLENBQUM7SUFFTSxNQUFNLENBQUMsR0FBVztRQUN2QixPQUFPLGNBQUssQ0FBQyxRQUFRLENBQ25CLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsQ0FDOUMsR0FBRyxJQUFJLENBQUMsa0JBQWtCLEtBQUssR0FBRyxJQUFJLENBQ3ZDLENBQ0YsQ0FBQztJQUNKLENBQUM7SUFFRCxVQUFVO1FBQ1IsT0FBTyxjQUFLLENBQUMsUUFBUSxDQUNuQixJQUFJLENBQUMsaUJBQWlCLENBQUMseUJBQXlCLENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLENBQzFFLENBQUM7SUFDSixDQUFDOzs7O0FBdkJVLDhCQUFTO0FBMEJ0QiwrQ0FBK0M7QUFDL0MsTUFBYSxVQUNYLFNBQVEsaUJBQWlCO0lBR3pCLFlBQ1ksaUJBQXVDLEVBQ3ZDLGtCQUEwQjtRQUVwQyxLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztRQUhuQyxzQkFBaUIsR0FBakIsaUJBQWlCLENBQXNCO1FBQ3ZDLHVCQUFrQixHQUFsQixrQkFBa0IsQ0FBUTtJQUd0QyxDQUFDO0lBRU0sTUFBTSxDQUFDLEdBQVc7UUFDdkIsT0FBTyxJQUFJLENBQUMsaUJBQWlCLENBQUMseUJBQXlCLENBQ3JELEdBQUcsSUFBSSxDQUFDLGtCQUFrQixLQUFLLEdBQUcsSUFBSSxDQUN2QyxDQUFDO0lBQ0osQ0FBQztJQUVELFVBQVU7UUFDUixPQUFPLGNBQUssQ0FBQyxRQUFRLENBQ25CLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsQ0FBQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsQ0FDMUUsQ0FBQztJQUNKLENBQUM7Ozs7QUFyQlUsZ0NBQVU7QUF3QnZCLCtDQUErQztBQUMvQyxNQUFhLE1BQU8sU0FBUSxpQkFBaUI7SUFDM0MsWUFDWSxpQkFBdUMsRUFDdkMsa0JBQTBCO1FBRXBDLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsQ0FBQyxDQUFDO1FBSG5DLHNCQUFpQixHQUFqQixpQkFBaUIsQ0FBc0I7UUFDdkMsdUJBQWtCLEdBQWxCLGtCQUFrQixDQUFRO0lBR3RDLENBQUM7SUFFTSxNQUFNLENBQUMsR0FBVztRQUN2QixPQUFPLGNBQUssQ0FBQyxLQUFLLENBQ2hCLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsQ0FDOUMsR0FBRyxJQUFJLENBQUMsa0JBQWtCLEtBQUssR0FBRyxJQUFJLENBQ3ZDLENBQ0YsQ0FBQztJQUNKLENBQUM7SUFFRCxVQUFVO1FBQ1IsT0FBTyxjQUFLLENBQUMsUUFBUSxDQUNuQixJQUFJLENBQUMsaUJBQWlCLENBQUMseUJBQXlCLENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLENBQzFFLENBQUM7SUFDSixDQUFDOzs7O0FBcEJVLHdCQUFNO0FBdUJuQjs7O0dBR0c7QUFDSCxNQUFhLG1CQUFvQixTQUFRLHdCQUF3QjtJQUMvRCxZQUNZLGlCQUF1QyxFQUN2QyxrQkFBMEIsRUFDMUIsd0JBQWdDLEVBQ2hDLFFBQWtCO1FBRTVCLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsQ0FBQyxDQUFDO1FBTG5DLHNCQUFpQixHQUFqQixpQkFBaUIsQ0FBc0I7UUFDdkMsdUJBQWtCLEdBQWxCLGtCQUFrQixDQUFRO1FBQzFCLDZCQUF3QixHQUF4Qix3QkFBd0IsQ0FBUTtRQUNoQyxhQUFRLEdBQVIsUUFBUSxDQUFVO1FBRzVCLE1BQU0sSUFBSSxLQUFLLENBQ2Isb05BQW9OLENBQ3JOLENBQUM7SUFDSixDQUFDO0lBRU0seUJBQXlCLENBQUMsUUFBZ0I7UUFDL0MsSUFBSSxJQUFJLENBQUMsUUFBUSxFQUFFO1lBQ2pCLE9BQU8sSUFBQSxpQkFBYyxFQUNuQixLQUFFLENBQUMsTUFBTSxDQUNQLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsQ0FDOUMsSUFBSSxDQUFDLGtCQUFrQixDQUN4QixDQUNGLEVBQ0QsQ0FBQyxJQUFJLENBQUMsd0JBQXdCLEVBQUUsUUFBUSxDQUFDLENBQzFDLENBQUM7U0FDSDtRQUVELE9BQU8sSUFBSSxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixDQUNyRCxHQUFHLElBQUksQ0FBQyxrQkFBa0IsSUFBSSxJQUFJLENBQUMsd0JBQXdCLEtBQUssUUFBUSxFQUFFLENBQzNFLENBQUM7SUFDSixDQUFDO0lBRUQsVUFBVTtRQUNSLElBQUksSUFBSSxDQUFDLFFBQVEsRUFBRTtZQUNqQixPQUFPLGNBQUssQ0FBQyxRQUFRLENBQ25CLElBQUEsaUJBQWMsRUFDWixLQUFFLENBQUMsTUFBTSxDQUNQLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsQ0FDOUMsSUFBSSxDQUFDLGtCQUFrQixDQUN4QixDQUNGLEVBQ0QsQ0FBQyxJQUFJLENBQUMsd0JBQXdCLENBQUMsQ0FDaEMsQ0FDRixDQUFDO1NBQ0g7UUFFRCxPQUFPLGNBQUssQ0FBQyxRQUFRLENBQ25CLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsQ0FDOUMsR0FBRyxJQUFJLENBQUMsa0JBQWtCLElBQUksSUFBSSxDQUFDLHdCQUF3QixHQUFHLENBQy9ELENBQ0YsQ0FBQztJQUNKLENBQUM7Ozs7QUFqRFUsa0RBQW1CO0FBb0RoQywrQ0FBK0M7QUFDL0MsTUFBc0IsV0FDcEIsU0FBUSxpQkFBaUI7SUFHekIsWUFDWSxpQkFBdUMsRUFDdkMsa0JBQTBCLEVBQzFCLFFBQWlCO1FBRTNCLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsQ0FBQyxDQUFDO1FBSm5DLHNCQUFpQixHQUFqQixpQkFBaUIsQ0FBc0I7UUFDdkMsdUJBQWtCLEdBQWxCLGtCQUFrQixDQUFRO1FBQzFCLGFBQVEsR0FBUixRQUFRLENBQVM7SUFHN0IsQ0FBQztJQUVELFVBQVU7UUFDUixJQUFJLElBQUksQ0FBQyxRQUFRLEVBQUU7WUFDakIsT0FBTyxjQUFLLENBQUMsUUFBUSxDQUNuQixLQUFFLENBQUMsTUFBTSxDQUNQLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsQ0FDOUMsSUFBSSxDQUFDLGtCQUFrQixDQUN4QixDQUNGLENBQ0YsQ0FBQztTQUNIO2FBQU07WUFDTCxPQUFPLGNBQUssQ0FBQyxRQUFRLENBQ25CLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsQ0FDOUMsSUFBSSxDQUFDLGtCQUFrQixDQUN4QixDQUNGLENBQUM7U0FDSDtJQUNILENBQUM7Ozs7QUE1Qm1CLGtDQUFXO0FBK0JqQywrQ0FBK0M7QUFDL0MsTUFBYSxXQUFZLFNBQVEsV0FBVztJQUMxQyxZQUNZLGlCQUF1QyxFQUN2QyxrQkFBMEIsRUFDMUIsUUFBaUI7UUFFM0IsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLFFBQVEsQ0FBQyxDQUFDO1FBSjdDLHNCQUFpQixHQUFqQixpQkFBaUIsQ0FBc0I7UUFDdkMsdUJBQWtCLEdBQWxCLGtCQUFrQixDQUFRO1FBQzFCLGFBQVEsR0FBUixRQUFRLENBQVM7SUFHN0IsQ0FBQztJQUVNLEdBQUcsQ0FBQyxLQUFhO1FBQ3RCLE9BQU8sS0FBRSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDakMsQ0FBQzs7OztBQVhVLGtDQUFXO0FBY3hCLCtDQUErQztBQUMvQyxNQUFzQixVQUNwQixTQUFRLGlCQUFpQjtJQUd6QixZQUNZLGlCQUF1QyxFQUN2QyxrQkFBMEI7UUFFcEMsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixDQUFDLENBQUM7UUFIbkMsc0JBQWlCLEdBQWpCLGlCQUFpQixDQUFzQjtRQUN2Qyx1QkFBa0IsR0FBbEIsa0JBQWtCLENBQVE7SUFHdEMsQ0FBQztJQUVELFVBQVU7UUFDUixPQUFPLGNBQUssQ0FBQyxRQUFRLENBQ25CLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsQ0FBQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsQ0FDMUUsQ0FBQztJQUNKLENBQUM7SUFFRCx5QkFBeUIsQ0FBQyxRQUFnQjtRQUN4QyxPQUFPLElBQUEsaUJBQWMsRUFDbkIsSUFBSSxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixDQUFDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxFQUN6RSxDQUFDLFFBQVEsQ0FBQyxDQUNYLENBQUM7SUFDSixDQUFDOzs7O0FBdEJtQixnQ0FBVTtBQXlCaEMsK0NBQStDO0FBQy9DLE1BQWEsYUFBYyxTQUFRLHdCQUF3QjtJQUN6RDs7Ozs7O09BTUc7SUFDSCxZQUNZLGlCQUF1QyxFQUN2QyxrQkFBMEIsRUFDMUIsc0JBQStCLEVBQy9CLGtCQUFvQztRQUU5QyxLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztRQUxuQyxzQkFBaUIsR0FBakIsaUJBQWlCLENBQXNCO1FBQ3ZDLHVCQUFrQixHQUFsQixrQkFBa0IsQ0FBUTtRQUMxQiwyQkFBc0IsR0FBdEIsc0JBQXNCLENBQVM7UUFDL0IsdUJBQWtCLEdBQWxCLGtCQUFrQixDQUFrQjtJQUdoRCxDQUFDO0lBRU0seUJBQXlCLENBQUMsUUFBZ0I7UUFDL0MsSUFBSSxJQUFJLENBQUMsc0JBQXNCLEVBQUU7WUFDL0IsT0FBTyxJQUFBLGlCQUFjLEVBQ25CLEtBQUUsQ0FBQyxNQUFNLENBQ1AsSUFBSSxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixDQUM5QyxJQUFJLENBQUMsa0JBQWtCLENBQ3hCLENBQ0YsRUFDRCxDQUFDLElBQUksQ0FBQyxrQkFBa0IsRUFBRSxRQUFRLENBQUMsQ0FDcEMsQ0FBQztTQUNIO1FBRUQsT0FBTyxJQUFJLENBQUMsaUJBQWlCLENBQUMseUJBQXlCLENBQ3JELElBQUksQ0FBQyxrQkFBa0IsS0FBSyxTQUFTO1lBQ25DLENBQUMsQ0FBQyxHQUFHLElBQUksQ0FBQyxrQkFBa0IsSUFBSSxJQUFJLENBQUMsa0JBQWtCLEtBQUssUUFBUSxFQUFFO1lBQ3RFLENBQUMsQ0FBQyxHQUFHLElBQUksQ0FBQyxrQkFBa0IsSUFBSSxRQUFRLEVBQUUsQ0FDN0MsQ0FBQztJQUNKLENBQUM7SUFFUyxtQkFBbUI7UUFDM0IsT0FBTyxJQUFJLENBQUMsaUJBQWlCLENBQUMseUJBQXlCLENBQ3JELEdBQUcsSUFBSSxDQUFDLGtCQUFrQixJQUFJLENBQy9CLENBQUM7SUFDSixDQUFDO0lBRUQsVUFBVTtRQUNSLElBQUksSUFBSSxDQUFDLHNCQUFzQixFQUFFO1lBQy9CLE9BQU8sY0FBSyxDQUFDLFFBQVEsQ0FDbkIsSUFBQSxpQkFBYyxFQUNaLEtBQUUsQ0FBQyxNQUFNLENBQ1AsSUFBSSxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixDQUM5QyxJQUFJLENBQUMsa0JBQWtCLENBQ3hCLENBQ0YsRUFDRCxDQUFDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxDQUMxQixDQUNGLENBQUM7U0FDSDtRQUVELE9BQU8sY0FBSyxDQUFDLFFBQVEsQ0FDbkIsSUFBSSxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixDQUM5QyxJQUFJLENBQUMsa0JBQWtCLEtBQUssU0FBUztZQUNuQyxDQUFDLENBQUMsR0FBRyxJQUFJLENBQUMsa0JBQWtCLElBQUksSUFBSSxDQUFDLGtCQUFrQixHQUFHO1lBQzFELENBQUMsQ0FBQyxJQUFJLENBQUMsa0JBQWtCLENBQzVCLENBQ0YsQ0FBQztJQUNKLENBQUM7Ozs7QUEvRFUsc0NBQWE7QUFrRTFCLCtDQUErQztBQUMvQyxNQUFzQixPQUNwQixTQUFRLGlCQUFpQjtJQUd6QixZQUNZLGlCQUF1QyxFQUN2QyxrQkFBMEIsRUFDMUIsUUFBaUI7UUFFM0IsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixDQUFDLENBQUM7UUFKbkMsc0JBQWlCLEdBQWpCLGlCQUFpQixDQUFzQjtRQUN2Qyx1QkFBa0IsR0FBbEIsa0JBQWtCLENBQVE7UUFDMUIsYUFBUSxHQUFSLFFBQVEsQ0FBUztJQUc3QixDQUFDO0lBRUQsVUFBVTtRQUNSLElBQUksSUFBSSxDQUFDLFFBQVEsRUFBRTtZQUNqQixPQUFPLGNBQUssQ0FBQyxRQUFRLENBQ25CLEtBQUUsQ0FBQyxNQUFNLENBQ1AsSUFBSSxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixDQUM5QyxJQUFJLENBQUMsa0JBQWtCLENBQ3hCLENBQ0YsQ0FDRixDQUFDO1NBQ0g7YUFBTTtZQUNMLE9BQU8sY0FBSyxDQUFDLFFBQVEsQ0FDbkIsSUFBSSxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixDQUM5QyxJQUFJLENBQUMsa0JBQWtCLENBQ3hCLENBQ0YsQ0FBQztTQUNIO0lBQ0gsQ0FBQztJQUVELHlCQUF5QixDQUFDLFFBQWdCO1FBQ3hDLElBQUksSUFBSSxDQUFDLFFBQVEsRUFBRTtZQUNqQixNQUFNLE9BQU8sR0FBRyxRQUFRLENBQUMsS0FBSyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsZ0NBQWdDO1lBQ2hGLElBQUksT0FBTyxFQUFFO2dCQUNYLE9BQU8sSUFBQSxpQkFBYyxFQUNuQixLQUFFLENBQUMsTUFBTSxDQUNQLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsQ0FDOUMsSUFBSSxDQUFDLGtCQUFrQixDQUN4QixDQUNGLEVBQ0QsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUUsUUFBUSxDQUFDLENBQ3ZCLENBQUM7YUFDSDtTQUNGO1FBRUQsT0FBTyxJQUFJLENBQUMsaUJBQWlCLENBQUMseUJBQXlCLENBQ3JELEdBQUcsSUFBSSxDQUFDLGtCQUFrQixHQUFHLFFBQVEsRUFBRSxDQUN4QyxDQUFDO0lBQ0osQ0FBQzs7OztBQWhEbUIsMEJBQU87QUFtRDdCLCtDQUErQztBQUMvQyxNQUFhLGFBQWMsU0FBUSxPQUFPO0lBQ3hDLFlBQ1ksaUJBQXVDLEVBQ3ZDLGtCQUEwQixFQUMxQixRQUFpQjtRQUUzQixLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLEVBQUUsUUFBUSxDQUFDLENBQUM7UUFKN0Msc0JBQWlCLEdBQWpCLGlCQUFpQixDQUFzQjtRQUN2Qyx1QkFBa0IsR0FBbEIsa0JBQWtCLENBQVE7UUFDMUIsYUFBUSxHQUFSLFFBQVEsQ0FBUztJQUc3QixDQUFDO0lBRU0sR0FBRyxDQUFDLEtBQWE7UUFDdEIsT0FBTyxJQUFJLFNBQVMsQ0FBQyxJQUFJLEVBQUUsSUFBSSxLQUFLLEdBQUcsQ0FBQyxDQUFDO0lBQzNDLENBQUM7Ozs7QUFYVSxzQ0FBYTtBQWMxQiwrQ0FBK0M7QUFDL0MsTUFBYSxhQUFjLFNBQVEsT0FBTztJQUN4QyxZQUNZLGlCQUF1QyxFQUN2QyxrQkFBMEIsRUFDMUIsUUFBaUI7UUFFM0IsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLFFBQVEsQ0FBQyxDQUFDO1FBSjdDLHNCQUFpQixHQUFqQixpQkFBaUIsQ0FBc0I7UUFDdkMsdUJBQWtCLEdBQWxCLGtCQUFrQixDQUFRO1FBQzFCLGFBQVEsR0FBUixRQUFRLENBQVM7SUFHN0IsQ0FBQztJQUVNLEdBQUcsQ0FBQyxLQUFhO1FBQ3RCLE9BQU8sSUFBSSxTQUFTLENBQUMsSUFBSSxFQUFFLElBQUksS0FBSyxHQUFHLENBQUMsQ0FBQztJQUMzQyxDQUFDOzs7O0FBWFUsc0NBQWE7QUFjMUIsK0NBQStDO0FBQy9DLE1BQWEsY0FBZSxTQUFRLE9BQU87SUFDekMsWUFDWSxpQkFBdUMsRUFDdkMsa0JBQTBCLEVBQzFCLFFBQWlCO1FBRTNCLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxRQUFRLENBQUMsQ0FBQztRQUo3QyxzQkFBaUIsR0FBakIsaUJBQWlCLENBQXNCO1FBQ3ZDLHVCQUFrQixHQUFsQixrQkFBa0IsQ0FBUTtRQUMxQixhQUFRLEdBQVIsUUFBUSxDQUFTO0lBRzdCLENBQUM7SUFFTSxHQUFHLENBQUMsS0FBYTtRQUN0QixPQUFPLElBQUksVUFBVSxDQUFDLElBQUksRUFBRSxJQUFJLEtBQUssR0FBRyxDQUFDLENBQUM7SUFDNUMsQ0FBQzs7OztBQVhVLHdDQUFjO0FBYzNCLCtDQUErQztBQUMvQyxNQUFhLFVBQVcsU0FBUSxPQUFPO0lBQ3JDLFlBQ1ksaUJBQXVDLEVBQ3ZDLGtCQUEwQixFQUMxQixRQUFpQjtRQUUzQixLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLEVBQUUsUUFBUSxDQUFDLENBQUM7UUFKN0Msc0JBQWlCLEdBQWpCLGlCQUFpQixDQUFzQjtRQUN2Qyx1QkFBa0IsR0FBbEIsa0JBQWtCLENBQVE7UUFDMUIsYUFBUSxHQUFSLFFBQVEsQ0FBUztJQUc3QixDQUFDO0lBRU0sR0FBRyxDQUFDLEtBQWE7UUFDdEIsT0FBTyxJQUFJLE1BQU0sQ0FBQyxJQUFJLEVBQUUsSUFBSSxLQUFLLEdBQUcsQ0FBQyxDQUFDO0lBQ3hDLENBQUM7Ozs7QUFYVSxnQ0FBVTtBQWN2QiwrQ0FBK0M7QUFDL0MsTUFBYSxhQUFjLFNBQVEsVUFBVTtJQUMzQyxZQUNZLGlCQUF1QyxFQUN2QyxrQkFBMEI7UUFFcEMsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixDQUFDLENBQUM7UUFIbkMsc0JBQWlCLEdBQWpCLGlCQUFpQixDQUFzQjtRQUN2Qyx1QkFBa0IsR0FBbEIsa0JBQWtCLENBQVE7SUFHdEMsQ0FBQztJQUVNLEdBQUcsQ0FBQyxHQUFXO1FBQ3BCLE9BQU8sY0FBSyxDQUFDLE1BQU0sQ0FDakIsSUFBSSxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixDQUM5QyxHQUFHLElBQUksQ0FBQyxrQkFBa0IsSUFBSSxHQUFHLEdBQUcsQ0FDckMsQ0FDRixDQUFDO0lBQ0osQ0FBQzs7OztBQWRVLHNDQUFhO0FBaUIxQiwrQ0FBK0M7QUFDL0MsTUFBYSxhQUFjLFNBQVEsVUFBVTtJQUMzQyxZQUNZLGlCQUF1QyxFQUN2QyxrQkFBMEI7UUFFcEMsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixDQUFDLENBQUM7UUFIbkMsc0JBQWlCLEdBQWpCLGlCQUFpQixDQUFzQjtRQUN2Qyx1QkFBa0IsR0FBbEIsa0JBQWtCLENBQVE7SUFHdEMsQ0FBQztJQUVNLEdBQUcsQ0FBQyxHQUFXO1FBQ3BCLE9BQU8sY0FBSyxDQUFDLFlBQVksQ0FDdkIsSUFBSSxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixDQUM5QyxHQUFHLElBQUksQ0FBQyxrQkFBa0IsSUFBSSxHQUFHLEdBQUcsQ0FDckMsQ0FDRixDQUFDO0lBQ0osQ0FBQzs7OztBQWRVLHNDQUFhO0FBaUIxQiwrQ0FBK0M7QUFDL0MsTUFBYSxjQUFlLFNBQVEsVUFBVTtJQUM1QyxZQUNZLGlCQUF1QyxFQUN2QyxrQkFBMEI7UUFFcEMsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixDQUFDLENBQUM7UUFIbkMsc0JBQWlCLEdBQWpCLGlCQUFpQixDQUFzQjtRQUN2Qyx1QkFBa0IsR0FBbEIsa0JBQWtCLENBQVE7SUFHdEMsQ0FBQztJQUVNLEdBQUcsQ0FBQyxHQUFXO1FBQ3BCLDZCQUE2QjtRQUM3QixPQUFPLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsQ0FDckQsR0FBRyxJQUFJLENBQUMsa0JBQWtCLElBQUksR0FBRyxHQUFHLENBQ3JDLENBQUM7SUFDSixDQUFDOzs7O0FBYlUsd0NBQWM7QUFnQjNCLCtDQUErQztBQUMvQyxNQUFhLFVBQVcsU0FBUSxVQUFVO0lBQ3hDLFlBQ1ksaUJBQXVDLEVBQ3ZDLGtCQUEwQjtRQUVwQyxLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztRQUhuQyxzQkFBaUIsR0FBakIsaUJBQWlCLENBQXNCO1FBQ3ZDLHVCQUFrQixHQUFsQixrQkFBa0IsQ0FBUTtJQUd0QyxDQUFDO0lBRU0sR0FBRyxDQUFDLEdBQVc7UUFDcEIsNkJBQTZCO1FBQzdCLE9BQU8sSUFBSSxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixDQUNyRCxHQUFHLElBQUksQ0FBQyxrQkFBa0IsSUFBSSxHQUFHLEdBQUcsQ0FDckMsQ0FBQztJQUNKLENBQUM7Ozs7QUFiVSxnQ0FBVSIsInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCAoYykgSGFzaGlDb3JwLCBJbmNcbi8vIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBNUEwtMi4wXG5pbXBvcnQgeyBJUmVzb2x2YWJsZSwgVG9rZW4sIElSZXNvbHZlQ29udGV4dCB9IGZyb20gXCIuL3Rva2Vuc1wiO1xuaW1wb3J0IHtcbiAgSUludGVycG9sYXRpbmdQYXJlbnQsXG4gIElUZXJyYWZvcm1BZGRyZXNzYWJsZSxcbn0gZnJvbSBcIi4vdGVycmFmb3JtLWFkZHJlc3NhYmxlXCI7XG5pbXBvcnQgeyBwcm9wZXJ0eUFjY2VzcywgRm4gfSBmcm9tIFwiLlwiO1xuaW1wb3J0IHsgY2FwdHVyZVN0YWNrVHJhY2UgfSBmcm9tIFwiLi90b2tlbnMvcHJpdmF0ZS9zdGFjay10cmFjZVwiO1xuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUganNkb2MvcmVxdWlyZS1qc2RvY1xuYWJzdHJhY3QgY2xhc3MgQ29tcGxleFJlc29sdmFibGUgaW1wbGVtZW50cyBJUmVzb2x2YWJsZSwgSVRlcnJhZm9ybUFkZHJlc3NhYmxlIHtcbiAgcHVibGljIHJlYWRvbmx5IGNyZWF0aW9uU3RhY2s6IHN0cmluZ1tdO1xuXG4gIC8qKlxuICAgKiBAaW50ZXJuYWxcbiAgICovXG4gIHByb3RlY3RlZCBfZnFuPzogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1SZXNvdXJjZTogSUludGVycG9sYXRpbmdQYXJlbnQsXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nXG4gICkge1xuICAgIHRoaXMuY3JlYXRpb25TdGFjayA9IGNhcHR1cmVTdGFja1RyYWNlKCk7XG4gIH1cblxuICBhYnN0cmFjdCBjb21wdXRlRnFuKCk6IHN0cmluZztcblxuICBnZXQgZnFuKCk6IHN0cmluZyB7XG4gICAgaWYgKCF0aGlzLl9mcW4pIHtcbiAgICAgIHRoaXMuX2ZxbiA9IHRoaXMuY29tcHV0ZUZxbigpO1xuICAgIH1cblxuICAgIHJldHVybiB0aGlzLl9mcW47XG4gIH1cblxuICAvLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgQHR5cGVzY3JpcHQtZXNsaW50L25vLXVudXNlZC12YXJzXG4gIHJlc29sdmUoX2NvbnRleHQ6IElSZXNvbHZlQ29udGV4dCk6IGFueSB7XG4gICAgcmV0dXJuIHRoaXMuZnFuO1xuICB9XG5cbiAgdG9TdHJpbmcoKTogc3RyaW5nIHtcbiAgICByZXR1cm4gVG9rZW4uYXNTdHJpbmcodGhpcyk7XG4gIH1cbn1cblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGpzZG9jL3JlcXVpcmUtanNkb2NcbmFic3RyYWN0IGNsYXNzIENvbXBsZXhDb21wdXRlZEF0dHJpYnV0ZVxuICBleHRlbmRzIENvbXBsZXhSZXNvbHZhYmxlXG4gIGltcGxlbWVudHMgSUludGVycG9sYXRpbmdQYXJlbnRcbntcbiAgY29uc3RydWN0b3IoXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybVJlc291cmNlOiBJSW50ZXJwb2xhdGluZ1BhcmVudCxcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmdcbiAgKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSk7XG4gIH1cblxuICBwdWJsaWMgZ2V0U3RyaW5nQXR0cmlidXRlKHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nKSB7XG4gICAgcmV0dXJuIFRva2VuLmFzU3RyaW5nKHRoaXMuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZSh0ZXJyYWZvcm1BdHRyaWJ1dGUpKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXROdW1iZXJBdHRyaWJ1dGUodGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcpIHtcbiAgICByZXR1cm4gVG9rZW4uYXNOdW1iZXIodGhpcy5pbnRlcnBvbGF0aW9uRm9yQXR0cmlidXRlKHRlcnJhZm9ybUF0dHJpYnV0ZSkpO1xuICB9XG5cbiAgcHVibGljIGdldExpc3RBdHRyaWJ1dGUodGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcpIHtcbiAgICByZXR1cm4gVG9rZW4uYXNMaXN0KHRoaXMuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZSh0ZXJyYWZvcm1BdHRyaWJ1dGUpKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXRCb29sZWFuQXR0cmlidXRlKHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nKTogSVJlc29sdmFibGUge1xuICAgIHJldHVybiB0aGlzLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUodGVycmFmb3JtQXR0cmlidXRlKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXROdW1iZXJMaXN0QXR0cmlidXRlKHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nKSB7XG4gICAgcmV0dXJuIFRva2VuLmFzTnVtYmVyTGlzdChcbiAgICAgIHRoaXMuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZSh0ZXJyYWZvcm1BdHRyaWJ1dGUpXG4gICAgKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXRTdHJpbmdNYXBBdHRyaWJ1dGUodGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcpIHtcbiAgICByZXR1cm4gVG9rZW4uYXNTdHJpbmdNYXAoXG4gICAgICB0aGlzLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUodGVycmFmb3JtQXR0cmlidXRlKVxuICAgICk7XG4gIH1cblxuICBwdWJsaWMgZ2V0TnVtYmVyTWFwQXR0cmlidXRlKHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nKSB7XG4gICAgcmV0dXJuIFRva2VuLmFzTnVtYmVyTWFwKFxuICAgICAgdGhpcy5pbnRlcnBvbGF0aW9uRm9yQXR0cmlidXRlKHRlcnJhZm9ybUF0dHJpYnV0ZSlcbiAgICApO1xuICB9XG5cbiAgcHVibGljIGdldEJvb2xlYW5NYXBBdHRyaWJ1dGUodGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcpIHtcbiAgICByZXR1cm4gVG9rZW4uYXNCb29sZWFuTWFwKFxuICAgICAgdGhpcy5pbnRlcnBvbGF0aW9uRm9yQXR0cmlidXRlKHRlcnJhZm9ybUF0dHJpYnV0ZSlcbiAgICApO1xuICB9XG5cbiAgcHVibGljIGdldEFueU1hcEF0dHJpYnV0ZSh0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZykge1xuICAgIHJldHVybiBUb2tlbi5hc0FueU1hcCh0aGlzLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUodGVycmFmb3JtQXR0cmlidXRlKSk7XG4gIH1cblxuICBwdWJsaWMgYWJzdHJhY3QgaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZSh0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZyk6IGFueTtcbn1cblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGpzZG9jL3JlcXVpcmUtanNkb2NcbmV4cG9ydCBjbGFzcyBTdHJpbmdNYXBcbiAgZXh0ZW5kcyBDb21wbGV4UmVzb2x2YWJsZVxuICBpbXBsZW1lbnRzIElUZXJyYWZvcm1BZGRyZXNzYWJsZVxue1xuICBjb25zdHJ1Y3RvcihcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtUmVzb3VyY2U6IElJbnRlcnBvbGF0aW5nUGFyZW50LFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZ1xuICApIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlKTtcbiAgfVxuXG4gIHB1YmxpYyBsb29rdXAoa2V5OiBzdHJpbmcpOiBzdHJpbmcge1xuICAgIHJldHVybiBUb2tlbi5hc1N0cmluZyhcbiAgICAgIHRoaXMudGVycmFmb3JtUmVzb3VyY2UuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZShcbiAgICAgICAgYCR7dGhpcy50ZXJyYWZvcm1BdHRyaWJ1dGV9W1wiJHtrZXl9XCJdYFxuICAgICAgKVxuICAgICk7XG4gIH1cblxuICBjb21wdXRlRnFuKCk6IHN0cmluZyB7XG4gICAgcmV0dXJuIFRva2VuLmFzU3RyaW5nKFxuICAgICAgdGhpcy50ZXJyYWZvcm1SZXNvdXJjZS5pbnRlcnBvbGF0aW9uRm9yQXR0cmlidXRlKHRoaXMudGVycmFmb3JtQXR0cmlidXRlKVxuICAgICk7XG4gIH1cbn1cblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGpzZG9jL3JlcXVpcmUtanNkb2NcbmV4cG9ydCBjbGFzcyBOdW1iZXJNYXBcbiAgZXh0ZW5kcyBDb21wbGV4UmVzb2x2YWJsZVxuICBpbXBsZW1lbnRzIElUZXJyYWZvcm1BZGRyZXNzYWJsZVxue1xuICBjb25zdHJ1Y3RvcihcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtUmVzb3VyY2U6IElJbnRlcnBvbGF0aW5nUGFyZW50LFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZ1xuICApIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlKTtcbiAgfVxuXG4gIHB1YmxpYyBsb29rdXAoa2V5OiBzdHJpbmcpOiBudW1iZXIge1xuICAgIHJldHVybiBUb2tlbi5hc051bWJlcihcbiAgICAgIHRoaXMudGVycmFmb3JtUmVzb3VyY2UuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZShcbiAgICAgICAgYCR7dGhpcy50ZXJyYWZvcm1BdHRyaWJ1dGV9W1wiJHtrZXl9XCJdYFxuICAgICAgKVxuICAgICk7XG4gIH1cblxuICBjb21wdXRlRnFuKCk6IHN0cmluZyB7XG4gICAgcmV0dXJuIFRva2VuLmFzU3RyaW5nKFxuICAgICAgdGhpcy50ZXJyYWZvcm1SZXNvdXJjZS5pbnRlcnBvbGF0aW9uRm9yQXR0cmlidXRlKHRoaXMudGVycmFmb3JtQXR0cmlidXRlKVxuICAgICk7XG4gIH1cbn1cblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGpzZG9jL3JlcXVpcmUtanNkb2NcbmV4cG9ydCBjbGFzcyBCb29sZWFuTWFwXG4gIGV4dGVuZHMgQ29tcGxleFJlc29sdmFibGVcbiAgaW1wbGVtZW50cyBJVGVycmFmb3JtQWRkcmVzc2FibGVcbntcbiAgY29uc3RydWN0b3IoXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybVJlc291cmNlOiBJSW50ZXJwb2xhdGluZ1BhcmVudCxcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmdcbiAgKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSk7XG4gIH1cblxuICBwdWJsaWMgbG9va3VwKGtleTogc3RyaW5nKTogSVJlc29sdmFibGUge1xuICAgIHJldHVybiB0aGlzLnRlcnJhZm9ybVJlc291cmNlLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUoXG4gICAgICBgJHt0aGlzLnRlcnJhZm9ybUF0dHJpYnV0ZX1bXCIke2tleX1cIl1gXG4gICAgKTtcbiAgfVxuXG4gIGNvbXB1dGVGcW4oKTogc3RyaW5nIHtcbiAgICByZXR1cm4gVG9rZW4uYXNTdHJpbmcoXG4gICAgICB0aGlzLnRlcnJhZm9ybVJlc291cmNlLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUodGhpcy50ZXJyYWZvcm1BdHRyaWJ1dGUpXG4gICAgKTtcbiAgfVxufVxuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUganNkb2MvcmVxdWlyZS1qc2RvY1xuZXhwb3J0IGNsYXNzIEFueU1hcCBleHRlbmRzIENvbXBsZXhSZXNvbHZhYmxlIGltcGxlbWVudHMgSVRlcnJhZm9ybUFkZHJlc3NhYmxlIHtcbiAgY29uc3RydWN0b3IoXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybVJlc291cmNlOiBJSW50ZXJwb2xhdGluZ1BhcmVudCxcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmdcbiAgKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSk7XG4gIH1cblxuICBwdWJsaWMgbG9va3VwKGtleTogc3RyaW5nKTogYW55IHtcbiAgICByZXR1cm4gVG9rZW4uYXNBbnkoXG4gICAgICB0aGlzLnRlcnJhZm9ybVJlc291cmNlLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUoXG4gICAgICAgIGAke3RoaXMudGVycmFmb3JtQXR0cmlidXRlfVtcIiR7a2V5fVwiXWBcbiAgICAgIClcbiAgICApO1xuICB9XG5cbiAgY29tcHV0ZUZxbigpOiBzdHJpbmcge1xuICAgIHJldHVybiBUb2tlbi5hc1N0cmluZyhcbiAgICAgIHRoaXMudGVycmFmb3JtUmVzb3VyY2UuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZSh0aGlzLnRlcnJhZm9ybUF0dHJpYnV0ZSlcbiAgICApO1xuICB9XG59XG5cbi8qKlxuICogQGRlcHJlY2F0ZWQgR29pbmcgdG8gYmUgcmVwbGFjZWQgYnkgQXJyYXkgb2YgQ29tcGxleExpc3RJdGVtXG4gKiBhbmQgd2lsbCBiZSByZW1vdmVkIGluIHRoZSBmdXR1cmVcbiAqL1xuZXhwb3J0IGNsYXNzIENvbXBsZXhDb21wdXRlZExpc3QgZXh0ZW5kcyBDb21wbGV4Q29tcHV0ZWRBdHRyaWJ1dGUge1xuICBjb25zdHJ1Y3RvcihcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtUmVzb3VyY2U6IElJbnRlcnBvbGF0aW5nUGFyZW50LFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZyxcbiAgICBwcm90ZWN0ZWQgY29tcGxleENvbXB1dGVkTGlzdEluZGV4OiBzdHJpbmcsXG4gICAgcHJvdGVjdGVkIHdyYXBzU2V0PzogYm9vbGVhblxuICApIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlKTtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXG4gICAgICBcIlZlcnNpb24gbWlzbWF0Y2ggZGV0ZWN0ZWQ6IFRoZSBwcm92aWRlciBiaW5kaW5ncyBzZWVtIHRvIGhhdmUgYmVlbiBidWlsdCBmb3IgYW4gb2xkZXIgdmVyc2lvbiBvZiBDREtURi4gVXBncmFkZSB5b3VyIHByZS1idWlsdCBwcm92aWRlciBvciByZS1ydW4gY2RrdGYgZ2V0IHdpdGggYSBtb3JlIHJlY2VudCB2ZXJzaW9uICg+PSAwLjEwKSBvZiB0aGUgY2RrdGYtY2xpLlwiXG4gICAgKTtcbiAgfVxuXG4gIHB1YmxpYyBpbnRlcnBvbGF0aW9uRm9yQXR0cmlidXRlKHByb3BlcnR5OiBzdHJpbmcpIHtcbiAgICBpZiAodGhpcy53cmFwc1NldCkge1xuICAgICAgcmV0dXJuIHByb3BlcnR5QWNjZXNzKFxuICAgICAgICBGbi50b2xpc3QoXG4gICAgICAgICAgdGhpcy50ZXJyYWZvcm1SZXNvdXJjZS5pbnRlcnBvbGF0aW9uRm9yQXR0cmlidXRlKFxuICAgICAgICAgICAgdGhpcy50ZXJyYWZvcm1BdHRyaWJ1dGVcbiAgICAgICAgICApXG4gICAgICAgICksXG4gICAgICAgIFt0aGlzLmNvbXBsZXhDb21wdXRlZExpc3RJbmRleCwgcHJvcGVydHldXG4gICAgICApO1xuICAgIH1cblxuICAgIHJldHVybiB0aGlzLnRlcnJhZm9ybVJlc291cmNlLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUoXG4gICAgICBgJHt0aGlzLnRlcnJhZm9ybUF0dHJpYnV0ZX1bJHt0aGlzLmNvbXBsZXhDb21wdXRlZExpc3RJbmRleH1dLiR7cHJvcGVydHl9YFxuICAgICk7XG4gIH1cblxuICBjb21wdXRlRnFuKCk6IHN0cmluZyB7XG4gICAgaWYgKHRoaXMud3JhcHNTZXQpIHtcbiAgICAgIHJldHVybiBUb2tlbi5hc1N0cmluZyhcbiAgICAgICAgcHJvcGVydHlBY2Nlc3MoXG4gICAgICAgICAgRm4udG9saXN0KFxuICAgICAgICAgICAgdGhpcy50ZXJyYWZvcm1SZXNvdXJjZS5pbnRlcnBvbGF0aW9uRm9yQXR0cmlidXRlKFxuICAgICAgICAgICAgICB0aGlzLnRlcnJhZm9ybUF0dHJpYnV0ZVxuICAgICAgICAgICAgKVxuICAgICAgICAgICksXG4gICAgICAgICAgW3RoaXMuY29tcGxleENvbXB1dGVkTGlzdEluZGV4XVxuICAgICAgICApXG4gICAgICApO1xuICAgIH1cblxuICAgIHJldHVybiBUb2tlbi5hc1N0cmluZyhcbiAgICAgIHRoaXMudGVycmFmb3JtUmVzb3VyY2UuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZShcbiAgICAgICAgYCR7dGhpcy50ZXJyYWZvcm1BdHRyaWJ1dGV9WyR7dGhpcy5jb21wbGV4Q29tcHV0ZWRMaXN0SW5kZXh9XWBcbiAgICAgIClcbiAgICApO1xuICB9XG59XG5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBqc2RvYy9yZXF1aXJlLWpzZG9jXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgQ29tcGxleExpc3RcbiAgZXh0ZW5kcyBDb21wbGV4UmVzb2x2YWJsZVxuICBpbXBsZW1lbnRzIElUZXJyYWZvcm1BZGRyZXNzYWJsZVxue1xuICBjb25zdHJ1Y3RvcihcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtUmVzb3VyY2U6IElJbnRlcnBvbGF0aW5nUGFyZW50LFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZyxcbiAgICBwcm90ZWN0ZWQgd3JhcHNTZXQ6IGJvb2xlYW5cbiAgKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSk7XG4gIH1cblxuICBjb21wdXRlRnFuKCk6IHN0cmluZyB7XG4gICAgaWYgKHRoaXMud3JhcHNTZXQpIHtcbiAgICAgIHJldHVybiBUb2tlbi5hc1N0cmluZyhcbiAgICAgICAgRm4udG9saXN0KFxuICAgICAgICAgIHRoaXMudGVycmFmb3JtUmVzb3VyY2UuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZShcbiAgICAgICAgICAgIHRoaXMudGVycmFmb3JtQXR0cmlidXRlXG4gICAgICAgICAgKVxuICAgICAgICApXG4gICAgICApO1xuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gVG9rZW4uYXNTdHJpbmcoXG4gICAgICAgIHRoaXMudGVycmFmb3JtUmVzb3VyY2UuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZShcbiAgICAgICAgICB0aGlzLnRlcnJhZm9ybUF0dHJpYnV0ZVxuICAgICAgICApXG4gICAgICApO1xuICAgIH1cbiAgfVxufVxuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUganNkb2MvcmVxdWlyZS1qc2RvY1xuZXhwb3J0IGNsYXNzIEJvb2xlYW5MaXN0IGV4dGVuZHMgQ29tcGxleExpc3Qge1xuICBjb25zdHJ1Y3RvcihcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtUmVzb3VyY2U6IElJbnRlcnBvbGF0aW5nUGFyZW50LFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZyxcbiAgICBwcm90ZWN0ZWQgd3JhcHNTZXQ6IGJvb2xlYW5cbiAgKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgd3JhcHNTZXQpO1xuICB9XG5cbiAgcHVibGljIGdldChpbmRleDogbnVtYmVyKTogSVJlc29sdmFibGUge1xuICAgIHJldHVybiBGbi5lbGVtZW50KHRoaXMsIGluZGV4KTtcbiAgfVxufVxuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUganNkb2MvcmVxdWlyZS1qc2RvY1xuZXhwb3J0IGFic3RyYWN0IGNsYXNzIENvbXBsZXhNYXBcbiAgZXh0ZW5kcyBDb21wbGV4UmVzb2x2YWJsZVxuICBpbXBsZW1lbnRzIElUZXJyYWZvcm1BZGRyZXNzYWJsZVxue1xuICBjb25zdHJ1Y3RvcihcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtUmVzb3VyY2U6IElJbnRlcnBvbGF0aW5nUGFyZW50LFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZ1xuICApIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlKTtcbiAgfVxuXG4gIGNvbXB1dGVGcW4oKTogc3RyaW5nIHtcbiAgICByZXR1cm4gVG9rZW4uYXNTdHJpbmcoXG4gICAgICB0aGlzLnRlcnJhZm9ybVJlc291cmNlLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUodGhpcy50ZXJyYWZvcm1BdHRyaWJ1dGUpXG4gICAgKTtcbiAgfVxuXG4gIGludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUocHJvcGVydHk6IHN0cmluZykge1xuICAgIHJldHVybiBwcm9wZXJ0eUFjY2VzcyhcbiAgICAgIHRoaXMudGVycmFmb3JtUmVzb3VyY2UuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZSh0aGlzLnRlcnJhZm9ybUF0dHJpYnV0ZSksXG4gICAgICBbcHJvcGVydHldXG4gICAgKTtcbiAgfVxufVxuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUganNkb2MvcmVxdWlyZS1qc2RvY1xuZXhwb3J0IGNsYXNzIENvbXBsZXhPYmplY3QgZXh0ZW5kcyBDb21wbGV4Q29tcHV0ZWRBdHRyaWJ1dGUge1xuICAvKipcbiAgICogQHBhcmFtIHRlcnJhZm9ybVJlc291cmNlXG4gICAqIEBwYXJhbSB0ZXJyYWZvcm1BdHRyaWJ1dGVcbiAgICogQHBhcmFtIGNvbXBsZXhPYmplY3RJbmRleCB0aGUgaW5kZXggb2YgdGhlIGNvbXBsZXggb2JqZWN0IGluIGEgbGlzdFxuICAgKiBAcGFyYW0gY29tcGxleE9iamVjdElzRnJvbVNldCBzZXQgdG8gdHJ1ZSBpZiB0aGlzIGl0ZW0gaXMgZnJvbSBpbnNpZGUgYSBzZXQgYW5kIG5lZWRzIHRvbGlzdCgpIGZvciBhY2Nlc3NpbmcgaXRcbiAgICogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgc2V0IHRvIFwiMFwiIGZvciBzaW5nbGUgbGlzdCBpdGVtc1xuICAgKi9cbiAgY29uc3RydWN0b3IoXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybVJlc291cmNlOiBJSW50ZXJwb2xhdGluZ1BhcmVudCxcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcsXG4gICAgcHJvdGVjdGVkIGNvbXBsZXhPYmplY3RJc0Zyb21TZXQ6IGJvb2xlYW4sXG4gICAgcHJvdGVjdGVkIGNvbXBsZXhPYmplY3RJbmRleD86IG51bWJlciB8IHN0cmluZ1xuICApIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlKTtcbiAgfVxuXG4gIHB1YmxpYyBpbnRlcnBvbGF0aW9uRm9yQXR0cmlidXRlKHByb3BlcnR5OiBzdHJpbmcpIHtcbiAgICBpZiAodGhpcy5jb21wbGV4T2JqZWN0SXNGcm9tU2V0KSB7XG4gICAgICByZXR1cm4gcHJvcGVydHlBY2Nlc3MoXG4gICAgICAgIEZuLnRvbGlzdChcbiAgICAgICAgICB0aGlzLnRlcnJhZm9ybVJlc291cmNlLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUoXG4gICAgICAgICAgICB0aGlzLnRlcnJhZm9ybUF0dHJpYnV0ZVxuICAgICAgICAgIClcbiAgICAgICAgKSxcbiAgICAgICAgW3RoaXMuY29tcGxleE9iamVjdEluZGV4LCBwcm9wZXJ0eV1cbiAgICAgICk7XG4gICAgfVxuXG4gICAgcmV0dXJuIHRoaXMudGVycmFmb3JtUmVzb3VyY2UuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZShcbiAgICAgIHRoaXMuY29tcGxleE9iamVjdEluZGV4ICE9PSB1bmRlZmluZWRcbiAgICAgICAgPyBgJHt0aGlzLnRlcnJhZm9ybUF0dHJpYnV0ZX1bJHt0aGlzLmNvbXBsZXhPYmplY3RJbmRleH1dLiR7cHJvcGVydHl9YFxuICAgICAgICA6IGAke3RoaXMudGVycmFmb3JtQXR0cmlidXRlfS4ke3Byb3BlcnR5fWBcbiAgICApO1xuICB9XG5cbiAgcHJvdGVjdGVkIGludGVycG9sYXRpb25Bc0xpc3QoKSB7XG4gICAgcmV0dXJuIHRoaXMudGVycmFmb3JtUmVzb3VyY2UuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZShcbiAgICAgIGAke3RoaXMudGVycmFmb3JtQXR0cmlidXRlfS4qYFxuICAgICk7XG4gIH1cblxuICBjb21wdXRlRnFuKCk6IHN0cmluZyB7XG4gICAgaWYgKHRoaXMuY29tcGxleE9iamVjdElzRnJvbVNldCkge1xuICAgICAgcmV0dXJuIFRva2VuLmFzU3RyaW5nKFxuICAgICAgICBwcm9wZXJ0eUFjY2VzcyhcbiAgICAgICAgICBGbi50b2xpc3QoXG4gICAgICAgICAgICB0aGlzLnRlcnJhZm9ybVJlc291cmNlLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUoXG4gICAgICAgICAgICAgIHRoaXMudGVycmFmb3JtQXR0cmlidXRlXG4gICAgICAgICAgICApXG4gICAgICAgICAgKSxcbiAgICAgICAgICBbdGhpcy5jb21wbGV4T2JqZWN0SW5kZXhdXG4gICAgICAgIClcbiAgICAgICk7XG4gICAgfVxuXG4gICAgcmV0dXJuIFRva2VuLmFzU3RyaW5nKFxuICAgICAgdGhpcy50ZXJyYWZvcm1SZXNvdXJjZS5pbnRlcnBvbGF0aW9uRm9yQXR0cmlidXRlKFxuICAgICAgICB0aGlzLmNvbXBsZXhPYmplY3RJbmRleCAhPT0gdW5kZWZpbmVkXG4gICAgICAgICAgPyBgJHt0aGlzLnRlcnJhZm9ybUF0dHJpYnV0ZX1bJHt0aGlzLmNvbXBsZXhPYmplY3RJbmRleH1dYFxuICAgICAgICAgIDogdGhpcy50ZXJyYWZvcm1BdHRyaWJ1dGVcbiAgICAgIClcbiAgICApO1xuICB9XG59XG5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBqc2RvYy9yZXF1aXJlLWpzZG9jXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgTWFwTGlzdFxuICBleHRlbmRzIENvbXBsZXhSZXNvbHZhYmxlXG4gIGltcGxlbWVudHMgSVRlcnJhZm9ybUFkZHJlc3NhYmxlLCBJSW50ZXJwb2xhdGluZ1BhcmVudFxue1xuICBjb25zdHJ1Y3RvcihcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtUmVzb3VyY2U6IElJbnRlcnBvbGF0aW5nUGFyZW50LFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZyxcbiAgICBwcm90ZWN0ZWQgd3JhcHNTZXQ6IGJvb2xlYW5cbiAgKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSk7XG4gIH1cblxuICBjb21wdXRlRnFuKCk6IHN0cmluZyB7XG4gICAgaWYgKHRoaXMud3JhcHNTZXQpIHtcbiAgICAgIHJldHVybiBUb2tlbi5hc1N0cmluZyhcbiAgICAgICAgRm4udG9saXN0KFxuICAgICAgICAgIHRoaXMudGVycmFmb3JtUmVzb3VyY2UuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZShcbiAgICAgICAgICAgIHRoaXMudGVycmFmb3JtQXR0cmlidXRlXG4gICAgICAgICAgKVxuICAgICAgICApXG4gICAgICApO1xuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gVG9rZW4uYXNTdHJpbmcoXG4gICAgICAgIHRoaXMudGVycmFmb3JtUmVzb3VyY2UuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZShcbiAgICAgICAgICB0aGlzLnRlcnJhZm9ybUF0dHJpYnV0ZVxuICAgICAgICApXG4gICAgICApO1xuICAgIH1cbiAgfVxuXG4gIGludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUocHJvcGVydHk6IHN0cmluZyk6IElSZXNvbHZhYmxlIHtcbiAgICBpZiAodGhpcy53cmFwc1NldCkge1xuICAgICAgY29uc3QgbWF0Y2hlcyA9IHByb3BlcnR5Lm1hdGNoKC9cXFsoW15cXF1dKilcXF0vKTsgLy8gbmVlZCB0byBleHRyYWN0IG91dCB0aGUgaW5kZXhcbiAgICAgIGlmIChtYXRjaGVzKSB7XG4gICAgICAgIHJldHVybiBwcm9wZXJ0eUFjY2VzcyhcbiAgICAgICAgICBGbi50b2xpc3QoXG4gICAgICAgICAgICB0aGlzLnRlcnJhZm9ybVJlc291cmNlLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUoXG4gICAgICAgICAgICAgIHRoaXMudGVycmFmb3JtQXR0cmlidXRlXG4gICAgICAgICAgICApXG4gICAgICAgICAgKSxcbiAgICAgICAgICBbbWF0Y2hlc1sxXSwgcHJvcGVydHldXG4gICAgICAgICk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgcmV0dXJuIHRoaXMudGVycmFmb3JtUmVzb3VyY2UuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZShcbiAgICAgIGAke3RoaXMudGVycmFmb3JtQXR0cmlidXRlfSR7cHJvcGVydHl9YFxuICAgICk7XG4gIH1cbn1cblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGpzZG9jL3JlcXVpcmUtanNkb2NcbmV4cG9ydCBjbGFzcyBTdHJpbmdNYXBMaXN0IGV4dGVuZHMgTWFwTGlzdCB7XG4gIGNvbnN0cnVjdG9yKFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1SZXNvdXJjZTogSUludGVycG9sYXRpbmdQYXJlbnQsXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nLFxuICAgIHByb3RlY3RlZCB3cmFwc1NldDogYm9vbGVhblxuICApIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlLCB3cmFwc1NldCk7XG4gIH1cblxuICBwdWJsaWMgZ2V0KGluZGV4OiBudW1iZXIpIHtcbiAgICByZXR1cm4gbmV3IFN0cmluZ01hcCh0aGlzLCBgWyR7aW5kZXh9XWApO1xuICB9XG59XG5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBqc2RvYy9yZXF1aXJlLWpzZG9jXG5leHBvcnQgY2xhc3MgTnVtYmVyTWFwTGlzdCBleHRlbmRzIE1hcExpc3Qge1xuICBjb25zdHJ1Y3RvcihcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtUmVzb3VyY2U6IElJbnRlcnBvbGF0aW5nUGFyZW50LFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZyxcbiAgICBwcm90ZWN0ZWQgd3JhcHNTZXQ6IGJvb2xlYW5cbiAgKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgd3JhcHNTZXQpO1xuICB9XG5cbiAgcHVibGljIGdldChpbmRleDogbnVtYmVyKSB7XG4gICAgcmV0dXJuIG5ldyBOdW1iZXJNYXAodGhpcywgYFske2luZGV4fV1gKTtcbiAgfVxufVxuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUganNkb2MvcmVxdWlyZS1qc2RvY1xuZXhwb3J0IGNsYXNzIEJvb2xlYW5NYXBMaXN0IGV4dGVuZHMgTWFwTGlzdCB7XG4gIGNvbnN0cnVjdG9yKFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1SZXNvdXJjZTogSUludGVycG9sYXRpbmdQYXJlbnQsXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nLFxuICAgIHByb3RlY3RlZCB3cmFwc1NldDogYm9vbGVhblxuICApIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlLCB3cmFwc1NldCk7XG4gIH1cblxuICBwdWJsaWMgZ2V0KGluZGV4OiBudW1iZXIpIHtcbiAgICByZXR1cm4gbmV3IEJvb2xlYW5NYXAodGhpcywgYFske2luZGV4fV1gKTtcbiAgfVxufVxuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUganNkb2MvcmVxdWlyZS1qc2RvY1xuZXhwb3J0IGNsYXNzIEFueU1hcExpc3QgZXh0ZW5kcyBNYXBMaXN0IHtcbiAgY29uc3RydWN0b3IoXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybVJlc291cmNlOiBJSW50ZXJwb2xhdGluZ1BhcmVudCxcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcsXG4gICAgcHJvdGVjdGVkIHdyYXBzU2V0OiBib29sZWFuXG4gICkge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIHdyYXBzU2V0KTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQoaW5kZXg6IG51bWJlcikge1xuICAgIHJldHVybiBuZXcgQW55TWFwKHRoaXMsIGBbJHtpbmRleH1dYCk7XG4gIH1cbn1cblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGpzZG9jL3JlcXVpcmUtanNkb2NcbmV4cG9ydCBjbGFzcyBTdHJpbmdMaXN0TWFwIGV4dGVuZHMgQ29tcGxleE1hcCB7XG4gIGNvbnN0cnVjdG9yKFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1SZXNvdXJjZTogSUludGVycG9sYXRpbmdQYXJlbnQsXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nXG4gICkge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUpO1xuICB9XG5cbiAgcHVibGljIGdldChrZXk6IHN0cmluZykge1xuICAgIHJldHVybiBUb2tlbi5hc0xpc3QoXG4gICAgICB0aGlzLnRlcnJhZm9ybVJlc291cmNlLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUoXG4gICAgICAgIGAke3RoaXMudGVycmFmb3JtQXR0cmlidXRlfVske2tleX1dYFxuICAgICAgKVxuICAgICk7XG4gIH1cbn1cblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGpzZG9jL3JlcXVpcmUtanNkb2NcbmV4cG9ydCBjbGFzcyBOdW1iZXJMaXN0TWFwIGV4dGVuZHMgQ29tcGxleE1hcCB7XG4gIGNvbnN0cnVjdG9yKFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1SZXNvdXJjZTogSUludGVycG9sYXRpbmdQYXJlbnQsXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nXG4gICkge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUpO1xuICB9XG5cbiAgcHVibGljIGdldChrZXk6IHN0cmluZykge1xuICAgIHJldHVybiBUb2tlbi5hc051bWJlckxpc3QoXG4gICAgICB0aGlzLnRlcnJhZm9ybVJlc291cmNlLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUoXG4gICAgICAgIGAke3RoaXMudGVycmFmb3JtQXR0cmlidXRlfVske2tleX1dYFxuICAgICAgKVxuICAgICk7XG4gIH1cbn1cblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGpzZG9jL3JlcXVpcmUtanNkb2NcbmV4cG9ydCBjbGFzcyBCb29sZWFuTGlzdE1hcCBleHRlbmRzIENvbXBsZXhNYXAge1xuICBjb25zdHJ1Y3RvcihcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtUmVzb3VyY2U6IElJbnRlcnBvbGF0aW5nUGFyZW50LFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZ1xuICApIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQoa2V5OiBzdHJpbmcpIHtcbiAgICAvLyBUaGlzIGlzbid0IGZ1bGx5IHN1cHBvcnRlZFxuICAgIHJldHVybiB0aGlzLnRlcnJhZm9ybVJlc291cmNlLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUoXG4gICAgICBgJHt0aGlzLnRlcnJhZm9ybUF0dHJpYnV0ZX1bJHtrZXl9XWBcbiAgICApO1xuICB9XG59XG5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBqc2RvYy9yZXF1aXJlLWpzZG9jXG5leHBvcnQgY2xhc3MgQW55TGlzdE1hcCBleHRlbmRzIENvbXBsZXhNYXAge1xuICBjb25zdHJ1Y3RvcihcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtUmVzb3VyY2U6IElJbnRlcnBvbGF0aW5nUGFyZW50LFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZ1xuICApIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQoa2V5OiBzdHJpbmcpIHtcbiAgICAvLyBUaGlzIGlzbid0IGZ1bGx5IHN1cHBvcnRlZFxuICAgIHJldHVybiB0aGlzLnRlcnJhZm9ybVJlc291cmNlLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUoXG4gICAgICBgJHt0aGlzLnRlcnJhZm9ybUF0dHJpYnV0ZX1bJHtrZXl9XWBcbiAgICApO1xuICB9XG59XG4iXX0=