import { IResolvable } from "../tokens/resolvable";
type TFValue<T> = {
    variadic?: boolean;
    value: T;
};
type TFValueValidator<T> = (value: T) => TFValue<T>;
type ExecutableTfFunction = (...args: any[]) => IResolvable;
export declare function anyValue<T>(value: T): TFValue<T>;
export declare function mapValue<T>(value: T): TFValue<T>;
export declare function stringValue<T extends string>(value: T): TFValue<T>;
export declare function numericValue<T>(value: T): TFValue<T>;
export declare function listOf<T>(type: TFValueValidator<T>): TFValueValidator<T[]>;
export declare function variadic<T>(type: TFValueValidator<T>): TFValueValidator<T[]>;
export declare function asString(value: IResolvable): string;
export declare function asNumber(value: IResolvable): number;
export declare function asList(value: IResolvable): string[];
export declare function asStringMap(value: IResolvable): {
    [key: string]: string;
};
export declare function asBoolean(value: IResolvable): IResolvable;
export declare function asAny(value: IResolvable): any;
export declare function terraformFunction(name: string, argValidators: TFValueValidator<any>[]): ExecutableTfFunction;
export {};
