export declare class FnGenerated {
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/abs abs} returns the absolute value of the given number. In other words, if the number is zero or positive then it is returned as-is, but if it is negative then it is multiplied by -1 to make it positive before returning it.
     * @param {number} num
     */
    static abs(num: number): number;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/abspath abspath} takes a string containing a filesystem path and converts it to an absolute path. That is, if the path is not absolute, it will be joined with the current working directory.
     * @param {string} path
     */
    static abspath(path: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/alltrue alltrue} returns `true` if all elements in a given collection are `true` or `&#34;true&#34;`. It also returns `true` if the collection is empty.
     * @param {Array<any>} list
     */
    static alltrue(list: any[]): import("..").IResolvable;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/anytrue anytrue} returns `true` if any element in a given collection is `true` or `&#34;true&#34;`. It also returns `false` if the collection is empty.
     * @param {Array<any>} list
     */
    static anytrue(list: any[]): import("..").IResolvable;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/base64decode base64decode} takes a string containing a Base64 character sequence and returns the original string.
     * @param {string} str
     */
    static base64decode(str: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/base64encode base64encode} applies Base64 encoding to a string.
     * @param {string} str
     */
    static base64encode(str: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/base64gzip base64gzip} compresses a string with gzip and then encodes the result in Base64 encoding.
     * @param {string} str
     */
    static base64gzip(str: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/base64sha256 base64sha256} computes the SHA256 hash of a given string and encodes it with Base64. This is not equivalent to `base64encode(sha256(&#34;test&#34;))` since `sha256()` returns hexadecimal representation.
     * @param {string} str
     */
    static base64sha256(str: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/base64sha512 base64sha512} computes the SHA512 hash of a given string and encodes it with Base64. This is not equivalent to `base64encode(sha512(&#34;test&#34;))` since `sha512()` returns hexadecimal representation.
     * @param {string} str
     */
    static base64sha512(str: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/basename basename} takes a string containing a filesystem path and removes all except the last portion from it.
     * @param {string} path
     */
    static basename(path: string): string;
    /**
     * @internal
     * {@link https://developer.hashicorp.com/terraform/language/functions/bcrypt bcrypt} computes a hash of the given string using the Blowfish cipher, returning a string in [the _Modular Crypt Format_](https://passlib.readthedocs.io/en/stable/modular_crypt_format.html) usually expected in the shadow password file on many Unix systems.
     * @param {string} str
     * @param {Array<number>} cost
     */
    static _bcrypt(str: string, cost: number[]): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/can can} evaluates the given expression and returns a boolean value indicating whether the expression produced a result without any errors.
     * @param {any} expression
     */
    static can(expression: any): import("..").IResolvable;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/ceil ceil} returns the closest whole number that is greater than or equal to the given value, which may be a fraction.
     * @param {number} num
     */
    static ceil(num: number): number;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/chomp chomp} removes newline characters at the end of a string.
     * @param {string} str
     */
    static chomp(str: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/chunklist chunklist} splits a single list into fixed-size chunks, returning a list of lists.
     * @param {Array<any>} list
     * @param {number} size
     */
    static chunklist(list: any[], size: number): string[];
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/cidrhost cidrhost} calculates a full host IP address for a given host number within a given IP network address prefix.
     * @param {string} prefix
     * @param {number} hostnum
     */
    static cidrhost(prefix: string, hostnum: number): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/cidrnetmask cidrnetmask} converts an IPv4 address prefix given in CIDR notation into a subnet mask address.
     * @param {string} prefix
     */
    static cidrnetmask(prefix: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/cidrsubnet cidrsubnet} calculates a subnet address within given IP network address prefix.
     * @param {string} prefix
     * @param {number} newbits
     * @param {number} netnum
     */
    static cidrsubnet(prefix: string, newbits: number, netnum: number): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/cidrsubnets cidrsubnets} calculates a sequence of consecutive IP address ranges within a particular CIDR prefix.
     * @param {string} prefix
     * @param {Array<number>} newbits
     */
    static cidrsubnets(prefix: string, newbits: number[]): string[];
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/coalesce coalesce} takes any number of arguments and returns the first one that isn&#39;t null or an empty string.
     * @param {Array<any>} vals
     */
    static coalesce(vals: any[]): any;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/coalescelist coalescelist} takes any number of list arguments and returns the first one that isn&#39;t empty.
     * @param {Array<any>} vals
     */
    static coalescelist(vals: any[]): any;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/compact compact} takes a list of strings and returns a new list with any empty string elements removed.
     * @param {Array<string>} list
     */
    static compact(list: string[]): string[];
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/concat concat} takes two or more lists and combines them into a single list.
     * @param {Array<any>} seqs
     */
    static concat(seqs: any[]): any;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/contains contains} determines whether a given list or set contains a given single value as one of its elements.
     * @param {any} list
     * @param {any} value
     */
    static contains(list: any, value: any): any;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/csvdecode csvdecode} decodes a string containing CSV-formatted data and produces a list of maps representing that data.
     * @param {string} str
     */
    static csvdecode(str: string): any;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/dirname dirname} takes a string containing a filesystem path and removes the last portion from it.
     * @param {string} path
     */
    static dirname(path: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/distinct distinct} takes a list and returns a new list with any duplicate elements removed.
     * @param {Array<any>} list
     */
    static distinct(list: any[]): string[];
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/element element} retrieves a single element from a list.
     * @param {any} list
     * @param {number} index
     */
    static element(list: any, index: number): any;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/endswith endswith} takes two values: a string to check and a suffix string. The function returns true if the first string ends with that exact suffix.
     * @param {string} str
     * @param {string} suffix
     */
    static endswith(str: string, suffix: string): import("..").IResolvable;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/file file} reads the contents of a file at the given path and returns them as a string.
     * @param {string} path
     */
    static file(path: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/filebase64 filebase64} reads the contents of a file at the given path and returns them as a base64-encoded string.
     * @param {string} path
     */
    static filebase64(path: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/filebase64sha256 filebase64sha256} is a variant of `base64sha256` that hashes the contents of a given file rather than a literal string.
     * @param {string} path
     */
    static filebase64sha256(path: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/filebase64sha512 filebase64sha512} is a variant of `base64sha512` that hashes the contents of a given file rather than a literal string.
     * @param {string} path
     */
    static filebase64sha512(path: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/fileexists fileexists} determines whether a file exists at a given path.
     * @param {string} path
     */
    static fileexists(path: string): import("..").IResolvable;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/filemd5 filemd5} is a variant of `md5` that hashes the contents of a given file rather than a literal string.
     * @param {string} path
     */
    static filemd5(path: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/fileset fileset} enumerates a set of regular file names given a path and pattern. The path is automatically removed from the resulting set of file names and any result still containing path separators always returns forward slash (`/`) as the path separator for cross-system compatibility.
     * @param {string} path
     * @param {string} pattern
     */
    static fileset(path: string, pattern: string): string[];
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/filesha1 filesha1} is a variant of `sha1` that hashes the contents of a given file rather than a literal string.
     * @param {string} path
     */
    static filesha1(path: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/filesha256 filesha256} is a variant of `sha256` that hashes the contents of a given file rather than a literal string.
     * @param {string} path
     */
    static filesha256(path: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/filesha512 filesha512} is a variant of `sha512` that hashes the contents of a given file rather than a literal string.
     * @param {string} path
     */
    static filesha512(path: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/flatten flatten} takes a list and replaces any elements that are lists with a flattened sequence of the list contents.
     * @param {any} list
     */
    static flatten(list: any): any;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/floor floor} returns the closest whole number that is less than or equal to the given value, which may be a fraction.
     * @param {number} num
     */
    static floor(num: number): number;
    /**
     * The {@link https://developer.hashicorp.com/terraform/language/functions/format format} function produces a string by formatting a number of other values according to a specification string. It is similar to the `printf` function in C, and other similar functions in other programming languages.
     * @param {string} format
     * @param {Array<any>} args
     */
    static format(format: string, args: any[]): any;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/formatdate formatdate} converts a timestamp into a different time format.
     * @param {string} format
     * @param {string} time
     */
    static formatdate(format: string, time: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/formatlist formatlist} produces a list of strings by formatting a number of other values according to a specification string.
     * @param {string} format
     * @param {Array<any>} args
     */
    static formatlist(format: string, args: any[]): any;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/indent indent} adds a given number of spaces to the beginnings of all but the first line in a given multi-line string.
     * @param {number} spaces
     * @param {string} str
     */
    static indent(spaces: number, str: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/index index} finds the element index for a given value in a list.
     * @param {any} list
     * @param {any} value
     */
    static index(list: any, value: any): any;
    /**
     * @internal
     * {@link https://developer.hashicorp.com/terraform/language/functions/join join} produces a string by concatenating together all elements of a given list of strings with the given delimiter.
     * @param {string} separator
     * @param {Array<Array<string>>} lists
     */
    static _join(separator: string, lists: string[][]): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/jsondecode jsondecode} interprets a given string as JSON, returning a representation of the result of decoding that string.
     * @param {string} str
     */
    static jsondecode(str: string): any;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/jsonencode jsonencode} encodes a given value to a string using JSON syntax.
     * @param {any} val
     */
    static jsonencode(val: any): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/keys keys} takes a map and returns a list containing the keys from that map.
     * @param {any} inputMap
     */
    static keys(inputMap: any): any;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/length length} determines the length of a given list, map, or string.
     * @param {any} value
     */
    static lengthOf(value: any): number;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/log log} returns the logarithm of a given number in a given base.
     * @param {number} num
     * @param {number} base
     */
    static log(num: number, base: number): number;
    /**
     * @internal
     * {@link https://developer.hashicorp.com/terraform/language/functions/lookup lookup} retrieves the value of a single element from a map, given its key. If the given key does not exist, the given default value is returned instead.
     * @param {any} inputMap
     * @param {string} key
     * @param {Array<any>} defaultValue
     */
    static _lookup(inputMap: any, key: string, defaultValue: any[]): any;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/lower lower} converts all cased letters in the given string to lowercase.
     * @param {string} str
     */
    static lower(str: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/matchkeys matchkeys} constructs a new list by taking a subset of elements from one list whose indexes match the corresponding indexes of values in another list.
     * @param {Array<any>} values
     * @param {Array<any>} keys
     * @param {Array<any>} searchset
     */
    static matchkeys(values: any[], keys: any[], searchset: any[]): string[];
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/max max} takes one or more numbers and returns the greatest number from the set.
     * @param {Array<number>} numbers
     */
    static max(numbers: number[]): number;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/md5 md5} computes the MD5 hash of a given string and encodes it with hexadecimal digits.
     * @param {string} str
     */
    static md5(str: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/merge merge} takes an arbitrary number of maps or objects, and returns a single map or object that contains a merged set of elements from all arguments.
     * @param {Array<any>} maps
     */
    static merge(maps: any[]): any;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/min min} takes one or more numbers and returns the smallest number from the set.
     * @param {Array<number>} numbers
     */
    static min(numbers: number[]): number;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/nonsensitive nonsensitive} takes a sensitive value and returns a copy of that value with the sensitive marking removed, thereby exposing the sensitive value.
     * @param {any} value
     */
    static nonsensitive(value: any): any;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/one one} takes a list, set, or tuple value with either zero or one elements. If the collection is empty, `one` returns `null`. Otherwise, `one` returns the first element. If there are two or more elements then `one` will return an error.
     * @param {any} list
     */
    static one(list: any): any;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/parseint parseint} parses the given string as a representation of an integer in the specified base and returns the resulting number. The base must be between 2 and 62 inclusive.
     * @param {any} number
     * @param {number} base
     */
    static parseint(number: any, base: number): any;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/pathexpand pathexpand} takes a filesystem path that might begin with a `~` segment, and if so it replaces that segment with the current user&#39;s home directory path.
     * @param {string} path
     */
    static pathexpand(path: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/pow pow} calculates an exponent, by raising its first argument to the power of the second argument.
     * @param {number} num
     * @param {number} power
     */
    static pow(num: number, power: number): number;
    /**
     * @internal
     * {@link https://developer.hashicorp.com/terraform/language/functions/range range} generates a list of numbers using a start value, a limit value, and a step value.
     * @param {Array<number>} params
     */
    static _range(params: number[]): string[];
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/regex regex} applies a [regular expression](https://en.wikipedia.org/wiki/Regular_expression) to a string and returns the matching substrings.
     * @param {string} pattern
     * @param {string} str
     */
    static regex(pattern: string, str: string): any;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/regexall regexall} applies a [regular expression](https://en.wikipedia.org/wiki/Regular_expression) to a string and returns a list of all matches.
     * @param {string} pattern
     * @param {string} str
     */
    static regexall(pattern: string, str: string): string[];
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/replace replace} searches a given string for another given substring, and replaces each occurrence with a given replacement string.
     * @param {string} str
     * @param {string} substr
     * @param {string} replace
     */
    static replace(str: string, substr: string, replace: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/reverse reverse} takes a sequence and produces a new sequence of the same length with all of the same elements as the given sequence but in reverse order.
     * @param {any} list
     */
    static reverse(list: any): any;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/rsadecrypt rsadecrypt} decrypts an RSA-encrypted ciphertext, returning the corresponding cleartext.
     * @param {string} ciphertext
     * @param {string} privatekey
     */
    static rsadecrypt(ciphertext: string, privatekey: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/sensitive sensitive} takes any value and returns a copy of it marked so that Terraform will treat it as sensitive, with the same meaning and behavior as for [sensitive input variables](/language/values/variables#suppressing-values-in-cli-output).
     * @param {any} value
     */
    static sensitive(value: any): any;
    /**
     * The {@link https://developer.hashicorp.com/terraform/language/functions/setintersection setintersection} function takes multiple sets and produces a single set containing only the elements that all of the given sets have in common. In other words, it computes the [intersection](https://en.wikipedia.org/wiki/Intersection_\(set_theory\)) of the sets.
     * @param {Array<any>} first_set
     * @param {Array<Array<any>>} other_sets
     */
    static setintersection(first_set: any[], other_sets: any[][]): string[];
    /**
     * The {@link https://developer.hashicorp.com/terraform/language/functions/setproduct setproduct} function finds all of the possible combinations of elements from all of the given sets by computing the [Cartesian product](https://en.wikipedia.org/wiki/Cartesian_product).
     * @param {Array<any>} sets
     */
    static setproduct(sets: any[]): any;
    /**
     * The {@link https://developer.hashicorp.com/terraform/language/functions/setsubtract setsubtract} function returns a new set containing the elements from the first set that are not present in the second set. In other words, it computes the [relative complement](https://en.wikipedia.org/wiki/Complement_\(set_theory\)#Relative_complement) of the second set.
     * @param {Array<any>} a
     * @param {Array<any>} b
     */
    static setsubtract(a: any[], b: any[]): string[];
    /**
     * The {@link https://developer.hashicorp.com/terraform/language/functions/setunion setunion} function takes multiple sets and produces a single set containing the elements from all of the given sets. In other words, it computes the [union](https://en.wikipedia.org/wiki/Union_\(set_theory\)) of the sets.
     * @param {Array<any>} first_set
     * @param {Array<Array<any>>} other_sets
     */
    static setunion(first_set: any[], other_sets: any[][]): string[];
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/sha1 sha1} computes the SHA1 hash of a given string and encodes it with hexadecimal digits.
     * @param {string} str
     */
    static sha1(str: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/sha256 sha256} computes the SHA256 hash of a given string and encodes it with hexadecimal digits.
     * @param {string} str
     */
    static sha256(str: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/sha512 sha512} computes the SHA512 hash of a given string and encodes it with hexadecimal digits.
     * @param {string} str
     */
    static sha512(str: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/signum signum} determines the sign of a number, returning a number between -1 and 1 to represent the sign.
     * @param {number} num
     */
    static signum(num: number): number;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/slice slice} extracts some consecutive elements from within a list.
     * @param {any} list
     * @param {number} start_index
     * @param {number} end_index
     */
    static slice(list: any, start_index: number, end_index: number): any;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/sort sort} takes a list of strings and returns a new list with those strings sorted lexicographically.
     * @param {Array<string>} list
     */
    static sort(list: string[]): string[];
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/split split} produces a list by dividing a given string at all occurrences of a given separator.
     * @param {string} separator
     * @param {string} str
     */
    static split(separator: string, str: string): string[];
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/startswith startswith} takes two values: a string to check and a prefix string. The function returns true if the string begins with that exact prefix.
     * @param {string} str
     * @param {string} prefix
     */
    static startswith(str: string, prefix: string): import("..").IResolvable;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/strrev strrev} reverses the characters in a string. Note that the characters are treated as _Unicode characters_ (in technical terms, Unicode [grapheme cluster boundaries](https://unicode.org/reports/tr29/#Grapheme_Cluster_Boundaries) are respected).
     * @param {string} str
     */
    static strrev(str: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/substr substr} extracts a substring from a given string by offset and (maximum) length.
     * @param {string} str
     * @param {number} offset
     * @param {number} length
     */
    static substr(str: string, offset: number, length: number): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/sum sum} takes a list or set of numbers and returns the sum of those numbers.
     * @param {any} list
     */
    static sum(list: any): any;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/templatefile templatefile} reads the file at the given path and renders its content as a template using a supplied set of template variables.
     * @param {string} path
     * @param {any} vars
     */
    static templatefile(path: string, vars: any): any;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/textdecodebase64 textdecodebase64} function decodes a string that was previously Base64-encoded, and then interprets the result as characters in a specified character encoding.
     * @param {string} source
     * @param {string} encoding
     */
    static textdecodebase64(source: string, encoding: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/textencodebase64 textencodebase64} encodes the unicode characters in a given string using a specified character encoding, returning the result base64 encoded because Terraform language strings are always sequences of unicode characters.
     * @param {string} str
     * @param {string} encoding
     */
    static textencodebase64(str: string, encoding: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/timeadd timeadd} adds a duration to a timestamp, returning a new timestamp.
     * @param {string} timestamp
     * @param {string} duration
     */
    static timeadd(timestamp: string, duration: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/timecmp timecmp} compares two timestamps and returns a number that represents the ordering of the instants those timestamps represent.
     * @param {string} timestamp_a
     * @param {string} timestamp_b
     */
    static timecmp(timestamp_a: string, timestamp_b: string): number;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/timestamp timestamp} returns a UTC timestamp string in [RFC 3339](https://tools.ietf.org/html/rfc3339) format.
     */
    static timestamp(): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/title title} converts the first letter of each word in the given string to uppercase.
     * @param {string} str
     */
    static title(str: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/tobool tobool} converts its argument to a boolean value.
     * @param {any} v
     */
    static tobool(v: any): import("..").IResolvable;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/tolist tolist} converts its argument to a list value.
     * @param {any} v
     */
    static tolist(v: any): string[];
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/tomap tomap} converts its argument to a map value.
     * @param {any} v
     */
    static tomap(v: any): any;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/tonumber tonumber} converts its argument to a number value.
     * @param {any} v
     */
    static tonumber(v: any): number;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/toset toset} converts its argument to a set value.
     * @param {any} v
     */
    static toset(v: any): string[];
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/tostring tostring} converts its argument to a string value.
     * @param {any} v
     */
    static tostring(v: any): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/transpose transpose} takes a map of lists of strings and swaps the keys and values to produce a new map of lists of strings.
     * @param {Object<string, Array<string>>} values
     */
    static transpose(values: any): any;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/trim trim} removes the specified set of characters from the start and end of the given string.
     * @param {string} str
     * @param {string} cutset
     */
    static trim(str: string, cutset: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/trimprefix trimprefix} removes the specified prefix from the start of the given string. If the string does not start with the prefix, the string is returned unchanged.
     * @param {string} str
     * @param {string} prefix
     */
    static trimprefix(str: string, prefix: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/trimspace trimspace} removes any space characters from the start and end of the given string.
     * @param {string} str
     */
    static trimspace(str: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/trimsuffix trimsuffix} removes the specified suffix from the end of the given string.
     * @param {string} str
     * @param {string} suffix
     */
    static trimsuffix(str: string, suffix: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/try try} evaluates all of its argument expressions in turn and returns the result of the first one that does not produce any errors.
     * @param {Array<any>} expressions
     */
    static try(expressions: any[]): any;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/upper upper} converts all cased letters in the given string to uppercase.
     * @param {string} str
     */
    static upper(str: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/urlencode urlencode} applies URL encoding to a given string.
     * @param {string} str
     */
    static urlencode(str: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/uuid uuid} generates a unique identifier string.
     */
    static uuid(): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/uuidv5 uuidv5} generates a _name-based_ UUID, as described in [RFC 4122 section 4.3](https://tools.ietf.org/html/rfc4122#section-4.3), also known as a &#34;version 5&#34; UUID.
     * @param {string} namespace
     * @param {string} name
     */
    static uuidv5(namespace: string, name: string): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/values values} takes a map and returns a list containing the values of the elements in that map.
     * @param {any} mapping
     */
    static values(mapping: any): any;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/yamldecode yamldecode} parses a string as a subset of YAML, and produces a representation of its value.
     * @param {string} src
     */
    static yamldecode(src: string): any;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/yamlencode yamlencode} encodes a given value to a string using [YAML 1.2](https://yaml.org/spec/1.2/spec.html) block syntax.
     * @param {any} value
     */
    static yamlencode(value: any): string;
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/zipmap zipmap} constructs a map from a list of keys and a corresponding list of values.
     * @param {Array<string>} keys
     * @param {any} values
     */
    static zipmap(keys: string[], values: any): any;
}
