"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FnGenerated = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
/*
 * This file is generated by tools/generate-function-bindings.
 * To update this file execute 'yarn run generate-function-bindings' in the root of the repository
 */
const helpers_1 = require("./helpers");
// eslint-disable-next-line jsdoc/require-jsdoc
class FnGenerated {
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/abs abs} returns the absolute value of the given number. In other words, if the number is zero or positive then it is returned as-is, but if it is negative then it is multiplied by -1 to make it positive before returning it.
     * @param {number} num
     */
    static abs(num) {
        return (0, helpers_1.asNumber)((0, helpers_1.terraformFunction)("abs", [helpers_1.numericValue])(num));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/abspath abspath} takes a string containing a filesystem path and converts it to an absolute path. That is, if the path is not absolute, it will be joined with the current working directory.
     * @param {string} path
     */
    static abspath(path) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("abspath", [helpers_1.stringValue])(path));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/alltrue alltrue} returns `true` if all elements in a given collection are `true` or `&#34;true&#34;`. It also returns `true` if the collection is empty.
     * @param {Array<any>} list
     */
    static alltrue(list) {
        return (0, helpers_1.asBoolean)((0, helpers_1.terraformFunction)("alltrue", [(0, helpers_1.listOf)(helpers_1.anyValue)])(list));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/anytrue anytrue} returns `true` if any element in a given collection is `true` or `&#34;true&#34;`. It also returns `false` if the collection is empty.
     * @param {Array<any>} list
     */
    static anytrue(list) {
        return (0, helpers_1.asBoolean)((0, helpers_1.terraformFunction)("anytrue", [(0, helpers_1.listOf)(helpers_1.anyValue)])(list));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/base64decode base64decode} takes a string containing a Base64 character sequence and returns the original string.
     * @param {string} str
     */
    static base64decode(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("base64decode", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/base64encode base64encode} applies Base64 encoding to a string.
     * @param {string} str
     */
    static base64encode(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("base64encode", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/base64gzip base64gzip} compresses a string with gzip and then encodes the result in Base64 encoding.
     * @param {string} str
     */
    static base64gzip(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("base64gzip", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/base64sha256 base64sha256} computes the SHA256 hash of a given string and encodes it with Base64. This is not equivalent to `base64encode(sha256(&#34;test&#34;))` since `sha256()` returns hexadecimal representation.
     * @param {string} str
     */
    static base64sha256(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("base64sha256", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/base64sha512 base64sha512} computes the SHA512 hash of a given string and encodes it with Base64. This is not equivalent to `base64encode(sha512(&#34;test&#34;))` since `sha512()` returns hexadecimal representation.
     * @param {string} str
     */
    static base64sha512(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("base64sha512", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/basename basename} takes a string containing a filesystem path and removes all except the last portion from it.
     * @param {string} path
     */
    static basename(path) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("basename", [helpers_1.stringValue])(path));
    }
    /**
     * @internal
     * {@link https://developer.hashicorp.com/terraform/language/functions/bcrypt bcrypt} computes a hash of the given string using the Blowfish cipher, returning a string in [the _Modular Crypt Format_](https://passlib.readthedocs.io/en/stable/modular_crypt_format.html) usually expected in the shadow password file on many Unix systems.
     * @param {string} str
     * @param {Array<number>} cost
     */
    static _bcrypt(str, cost) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("bcrypt", [helpers_1.stringValue, (0, helpers_1.variadic)(helpers_1.numericValue)])(str, cost));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/can can} evaluates the given expression and returns a boolean value indicating whether the expression produced a result without any errors.
     * @param {any} expression
     */
    static can(expression) {
        return (0, helpers_1.asBoolean)((0, helpers_1.terraformFunction)("can", [helpers_1.anyValue])(expression));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/ceil ceil} returns the closest whole number that is greater than or equal to the given value, which may be a fraction.
     * @param {number} num
     */
    static ceil(num) {
        return (0, helpers_1.asNumber)((0, helpers_1.terraformFunction)("ceil", [helpers_1.numericValue])(num));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/chomp chomp} removes newline characters at the end of a string.
     * @param {string} str
     */
    static chomp(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("chomp", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/chunklist chunklist} splits a single list into fixed-size chunks, returning a list of lists.
     * @param {Array<any>} list
     * @param {number} size
     */
    static chunklist(list, size) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("chunklist", [(0, helpers_1.listOf)(helpers_1.anyValue), helpers_1.numericValue])(list, size));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/cidrhost cidrhost} calculates a full host IP address for a given host number within a given IP network address prefix.
     * @param {string} prefix
     * @param {number} hostnum
     */
    static cidrhost(prefix, hostnum) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("cidrhost", [helpers_1.stringValue, helpers_1.numericValue])(prefix, hostnum));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/cidrnetmask cidrnetmask} converts an IPv4 address prefix given in CIDR notation into a subnet mask address.
     * @param {string} prefix
     */
    static cidrnetmask(prefix) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("cidrnetmask", [helpers_1.stringValue])(prefix));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/cidrsubnet cidrsubnet} calculates a subnet address within given IP network address prefix.
     * @param {string} prefix
     * @param {number} newbits
     * @param {number} netnum
     */
    static cidrsubnet(prefix, newbits, netnum) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("cidrsubnet", [
            helpers_1.stringValue,
            helpers_1.numericValue,
            helpers_1.numericValue,
        ])(prefix, newbits, netnum));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/cidrsubnets cidrsubnets} calculates a sequence of consecutive IP address ranges within a particular CIDR prefix.
     * @param {string} prefix
     * @param {Array<number>} newbits
     */
    static cidrsubnets(prefix, newbits) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("cidrsubnets", [helpers_1.stringValue, (0, helpers_1.variadic)(helpers_1.numericValue)])(prefix, newbits));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/coalesce coalesce} takes any number of arguments and returns the first one that isn&#39;t null or an empty string.
     * @param {Array<any>} vals
     */
    static coalesce(vals) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("coalesce", [(0, helpers_1.variadic)(helpers_1.anyValue)])(vals));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/coalescelist coalescelist} takes any number of list arguments and returns the first one that isn&#39;t empty.
     * @param {Array<any>} vals
     */
    static coalescelist(vals) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("coalescelist", [(0, helpers_1.variadic)(helpers_1.anyValue)])(vals));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/compact compact} takes a list of strings and returns a new list with any empty string elements removed.
     * @param {Array<string>} list
     */
    static compact(list) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("compact", [(0, helpers_1.listOf)(helpers_1.anyValue)])(list));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/concat concat} takes two or more lists and combines them into a single list.
     * @param {Array<any>} seqs
     */
    static concat(seqs) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("concat", [(0, helpers_1.variadic)(helpers_1.anyValue)])(seqs));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/contains contains} determines whether a given list or set contains a given single value as one of its elements.
     * @param {any} list
     * @param {any} value
     */
    static contains(list, value) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("contains", [helpers_1.anyValue, helpers_1.anyValue])(list, value));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/csvdecode csvdecode} decodes a string containing CSV-formatted data and produces a list of maps representing that data.
     * @param {string} str
     */
    static csvdecode(str) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("csvdecode", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/dirname dirname} takes a string containing a filesystem path and removes the last portion from it.
     * @param {string} path
     */
    static dirname(path) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("dirname", [helpers_1.stringValue])(path));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/distinct distinct} takes a list and returns a new list with any duplicate elements removed.
     * @param {Array<any>} list
     */
    static distinct(list) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("distinct", [(0, helpers_1.listOf)(helpers_1.anyValue)])(list));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/element element} retrieves a single element from a list.
     * @param {any} list
     * @param {number} index
     */
    static element(list, index) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("element", [helpers_1.anyValue, helpers_1.numericValue])(list, index));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/endswith endswith} takes two values: a string to check and a suffix string. The function returns true if the first string ends with that exact suffix.
     * @param {string} str
     * @param {string} suffix
     */
    static endswith(str, suffix) {
        return (0, helpers_1.asBoolean)((0, helpers_1.terraformFunction)("endswith", [helpers_1.stringValue, helpers_1.stringValue])(str, suffix));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/file file} reads the contents of a file at the given path and returns them as a string.
     * @param {string} path
     */
    static file(path) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("file", [helpers_1.stringValue])(path));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/filebase64 filebase64} reads the contents of a file at the given path and returns them as a base64-encoded string.
     * @param {string} path
     */
    static filebase64(path) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("filebase64", [helpers_1.stringValue])(path));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/filebase64sha256 filebase64sha256} is a variant of `base64sha256` that hashes the contents of a given file rather than a literal string.
     * @param {string} path
     */
    static filebase64sha256(path) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("filebase64sha256", [helpers_1.stringValue])(path));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/filebase64sha512 filebase64sha512} is a variant of `base64sha512` that hashes the contents of a given file rather than a literal string.
     * @param {string} path
     */
    static filebase64sha512(path) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("filebase64sha512", [helpers_1.stringValue])(path));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/fileexists fileexists} determines whether a file exists at a given path.
     * @param {string} path
     */
    static fileexists(path) {
        return (0, helpers_1.asBoolean)((0, helpers_1.terraformFunction)("fileexists", [helpers_1.stringValue])(path));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/filemd5 filemd5} is a variant of `md5` that hashes the contents of a given file rather than a literal string.
     * @param {string} path
     */
    static filemd5(path) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("filemd5", [helpers_1.stringValue])(path));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/fileset fileset} enumerates a set of regular file names given a path and pattern. The path is automatically removed from the resulting set of file names and any result still containing path separators always returns forward slash (`/`) as the path separator for cross-system compatibility.
     * @param {string} path
     * @param {string} pattern
     */
    static fileset(path, pattern) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("fileset", [helpers_1.stringValue, helpers_1.stringValue])(path, pattern));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/filesha1 filesha1} is a variant of `sha1` that hashes the contents of a given file rather than a literal string.
     * @param {string} path
     */
    static filesha1(path) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("filesha1", [helpers_1.stringValue])(path));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/filesha256 filesha256} is a variant of `sha256` that hashes the contents of a given file rather than a literal string.
     * @param {string} path
     */
    static filesha256(path) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("filesha256", [helpers_1.stringValue])(path));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/filesha512 filesha512} is a variant of `sha512` that hashes the contents of a given file rather than a literal string.
     * @param {string} path
     */
    static filesha512(path) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("filesha512", [helpers_1.stringValue])(path));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/flatten flatten} takes a list and replaces any elements that are lists with a flattened sequence of the list contents.
     * @param {any} list
     */
    static flatten(list) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("flatten", [helpers_1.anyValue])(list));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/floor floor} returns the closest whole number that is less than or equal to the given value, which may be a fraction.
     * @param {number} num
     */
    static floor(num) {
        return (0, helpers_1.asNumber)((0, helpers_1.terraformFunction)("floor", [helpers_1.numericValue])(num));
    }
    /**
     * The {@link https://developer.hashicorp.com/terraform/language/functions/format format} function produces a string by formatting a number of other values according to a specification string. It is similar to the `printf` function in C, and other similar functions in other programming languages.
     * @param {string} format
     * @param {Array<any>} args
     */
    static format(format, args) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("format", [helpers_1.stringValue, (0, helpers_1.variadic)(helpers_1.anyValue)])(format, args));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/formatdate formatdate} converts a timestamp into a different time format.
     * @param {string} format
     * @param {string} time
     */
    static formatdate(format, time) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("formatdate", [helpers_1.stringValue, helpers_1.stringValue])(format, time));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/formatlist formatlist} produces a list of strings by formatting a number of other values according to a specification string.
     * @param {string} format
     * @param {Array<any>} args
     */
    static formatlist(format, args) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("formatlist", [helpers_1.stringValue, (0, helpers_1.variadic)(helpers_1.anyValue)])(format, args));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/indent indent} adds a given number of spaces to the beginnings of all but the first line in a given multi-line string.
     * @param {number} spaces
     * @param {string} str
     */
    static indent(spaces, str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("indent", [helpers_1.numericValue, helpers_1.stringValue])(spaces, str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/index index} finds the element index for a given value in a list.
     * @param {any} list
     * @param {any} value
     */
    static index(list, value) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("index", [helpers_1.anyValue, helpers_1.anyValue])(list, value));
    }
    /**
     * @internal
     * {@link https://developer.hashicorp.com/terraform/language/functions/join join} produces a string by concatenating together all elements of a given list of strings with the given delimiter.
     * @param {string} separator
     * @param {Array<Array<string>>} lists
     */
    static _join(separator, lists) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("join", [helpers_1.stringValue, (0, helpers_1.variadic)((0, helpers_1.listOf)(helpers_1.anyValue))])(separator, lists));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/jsondecode jsondecode} interprets a given string as JSON, returning a representation of the result of decoding that string.
     * @param {string} str
     */
    static jsondecode(str) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("jsondecode", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/jsonencode jsonencode} encodes a given value to a string using JSON syntax.
     * @param {any} val
     */
    static jsonencode(val) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("jsonencode", [helpers_1.anyValue])(val));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/keys keys} takes a map and returns a list containing the keys from that map.
     * @param {any} inputMap
     */
    static keys(inputMap) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("keys", [helpers_1.anyValue])(inputMap));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/length length} determines the length of a given list, map, or string.
     * @param {any} value
     */
    static lengthOf(value) {
        return (0, helpers_1.asNumber)((0, helpers_1.terraformFunction)("length", [helpers_1.anyValue])(value));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/log log} returns the logarithm of a given number in a given base.
     * @param {number} num
     * @param {number} base
     */
    static log(num, base) {
        return (0, helpers_1.asNumber)((0, helpers_1.terraformFunction)("log", [helpers_1.numericValue, helpers_1.numericValue])(num, base));
    }
    /**
     * @internal
     * {@link https://developer.hashicorp.com/terraform/language/functions/lookup lookup} retrieves the value of a single element from a map, given its key. If the given key does not exist, the given default value is returned instead.
     * @param {any} inputMap
     * @param {string} key
     * @param {Array<any>} defaultValue
     */
    static _lookup(inputMap, key, defaultValue) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("lookup", [helpers_1.anyValue, helpers_1.stringValue, (0, helpers_1.variadic)(helpers_1.anyValue)])(inputMap, key, defaultValue));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/lower lower} converts all cased letters in the given string to lowercase.
     * @param {string} str
     */
    static lower(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("lower", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/matchkeys matchkeys} constructs a new list by taking a subset of elements from one list whose indexes match the corresponding indexes of values in another list.
     * @param {Array<any>} values
     * @param {Array<any>} keys
     * @param {Array<any>} searchset
     */
    static matchkeys(values, keys, searchset) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("matchkeys", [
            (0, helpers_1.listOf)(helpers_1.anyValue),
            (0, helpers_1.listOf)(helpers_1.anyValue),
            (0, helpers_1.listOf)(helpers_1.anyValue),
        ])(values, keys, searchset));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/max max} takes one or more numbers and returns the greatest number from the set.
     * @param {Array<number>} numbers
     */
    static max(numbers) {
        return (0, helpers_1.asNumber)((0, helpers_1.terraformFunction)("max", [(0, helpers_1.variadic)(helpers_1.numericValue)])(numbers));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/md5 md5} computes the MD5 hash of a given string and encodes it with hexadecimal digits.
     * @param {string} str
     */
    static md5(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("md5", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/merge merge} takes an arbitrary number of maps or objects, and returns a single map or object that contains a merged set of elements from all arguments.
     * @param {Array<any>} maps
     */
    static merge(maps) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("merge", [(0, helpers_1.variadic)(helpers_1.anyValue)])(maps));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/min min} takes one or more numbers and returns the smallest number from the set.
     * @param {Array<number>} numbers
     */
    static min(numbers) {
        return (0, helpers_1.asNumber)((0, helpers_1.terraformFunction)("min", [(0, helpers_1.variadic)(helpers_1.numericValue)])(numbers));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/nonsensitive nonsensitive} takes a sensitive value and returns a copy of that value with the sensitive marking removed, thereby exposing the sensitive value.
     * @param {any} value
     */
    static nonsensitive(value) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("nonsensitive", [helpers_1.anyValue])(value));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/one one} takes a list, set, or tuple value with either zero or one elements. If the collection is empty, `one` returns `null`. Otherwise, `one` returns the first element. If there are two or more elements then `one` will return an error.
     * @param {any} list
     */
    static one(list) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("one", [helpers_1.anyValue])(list));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/parseint parseint} parses the given string as a representation of an integer in the specified base and returns the resulting number. The base must be between 2 and 62 inclusive.
     * @param {any} number
     * @param {number} base
     */
    static parseint(number, base) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("parseint", [helpers_1.anyValue, helpers_1.numericValue])(number, base));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/pathexpand pathexpand} takes a filesystem path that might begin with a `~` segment, and if so it replaces that segment with the current user&#39;s home directory path.
     * @param {string} path
     */
    static pathexpand(path) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("pathexpand", [helpers_1.stringValue])(path));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/pow pow} calculates an exponent, by raising its first argument to the power of the second argument.
     * @param {number} num
     * @param {number} power
     */
    static pow(num, power) {
        return (0, helpers_1.asNumber)((0, helpers_1.terraformFunction)("pow", [helpers_1.numericValue, helpers_1.numericValue])(num, power));
    }
    /**
     * @internal
     * {@link https://developer.hashicorp.com/terraform/language/functions/range range} generates a list of numbers using a start value, a limit value, and a step value.
     * @param {Array<number>} params
     */
    static _range(params) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("range", [(0, helpers_1.variadic)(helpers_1.numericValue)])(params));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/regex regex} applies a [regular expression](https://en.wikipedia.org/wiki/Regular_expression) to a string and returns the matching substrings.
     * @param {string} pattern
     * @param {string} str
     */
    static regex(pattern, str) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("regex", [helpers_1.stringValue, helpers_1.stringValue])(pattern, str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/regexall regexall} applies a [regular expression](https://en.wikipedia.org/wiki/Regular_expression) to a string and returns a list of all matches.
     * @param {string} pattern
     * @param {string} str
     */
    static regexall(pattern, str) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("regexall", [helpers_1.stringValue, helpers_1.stringValue])(pattern, str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/replace replace} searches a given string for another given substring, and replaces each occurrence with a given replacement string.
     * @param {string} str
     * @param {string} substr
     * @param {string} replace
     */
    static replace(str, substr, replace) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("replace", [helpers_1.stringValue, helpers_1.stringValue, helpers_1.stringValue])(str, substr, replace));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/reverse reverse} takes a sequence and produces a new sequence of the same length with all of the same elements as the given sequence but in reverse order.
     * @param {any} list
     */
    static reverse(list) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("reverse", [helpers_1.anyValue])(list));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/rsadecrypt rsadecrypt} decrypts an RSA-encrypted ciphertext, returning the corresponding cleartext.
     * @param {string} ciphertext
     * @param {string} privatekey
     */
    static rsadecrypt(ciphertext, privatekey) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("rsadecrypt", [helpers_1.stringValue, helpers_1.stringValue])(ciphertext, privatekey));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/sensitive sensitive} takes any value and returns a copy of it marked so that Terraform will treat it as sensitive, with the same meaning and behavior as for [sensitive input variables](/language/values/variables#suppressing-values-in-cli-output).
     * @param {any} value
     */
    static sensitive(value) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("sensitive", [helpers_1.anyValue])(value));
    }
    /**
     * The {@link https://developer.hashicorp.com/terraform/language/functions/setintersection setintersection} function takes multiple sets and produces a single set containing only the elements that all of the given sets have in common. In other words, it computes the [intersection](https://en.wikipedia.org/wiki/Intersection_\(set_theory\)) of the sets.
     * @param {Array<any>} first_set
     * @param {Array<Array<any>>} other_sets
     */
    static setintersection(first_set, other_sets) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("setintersection", [
            (0, helpers_1.listOf)(helpers_1.anyValue),
            (0, helpers_1.variadic)((0, helpers_1.listOf)(helpers_1.anyValue)),
        ])(first_set, other_sets));
    }
    /**
     * The {@link https://developer.hashicorp.com/terraform/language/functions/setproduct setproduct} function finds all of the possible combinations of elements from all of the given sets by computing the [Cartesian product](https://en.wikipedia.org/wiki/Cartesian_product).
     * @param {Array<any>} sets
     */
    static setproduct(sets) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("setproduct", [(0, helpers_1.variadic)(helpers_1.anyValue)])(sets));
    }
    /**
     * The {@link https://developer.hashicorp.com/terraform/language/functions/setsubtract setsubtract} function returns a new set containing the elements from the first set that are not present in the second set. In other words, it computes the [relative complement](https://en.wikipedia.org/wiki/Complement_\(set_theory\)#Relative_complement) of the second set.
     * @param {Array<any>} a
     * @param {Array<any>} b
     */
    static setsubtract(a, b) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("setsubtract", [(0, helpers_1.listOf)(helpers_1.anyValue), (0, helpers_1.listOf)(helpers_1.anyValue)])(a, b));
    }
    /**
     * The {@link https://developer.hashicorp.com/terraform/language/functions/setunion setunion} function takes multiple sets and produces a single set containing the elements from all of the given sets. In other words, it computes the [union](https://en.wikipedia.org/wiki/Union_\(set_theory\)) of the sets.
     * @param {Array<any>} first_set
     * @param {Array<Array<any>>} other_sets
     */
    static setunion(first_set, other_sets) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("setunion", [
            (0, helpers_1.listOf)(helpers_1.anyValue),
            (0, helpers_1.variadic)((0, helpers_1.listOf)(helpers_1.anyValue)),
        ])(first_set, other_sets));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/sha1 sha1} computes the SHA1 hash of a given string and encodes it with hexadecimal digits.
     * @param {string} str
     */
    static sha1(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("sha1", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/sha256 sha256} computes the SHA256 hash of a given string and encodes it with hexadecimal digits.
     * @param {string} str
     */
    static sha256(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("sha256", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/sha512 sha512} computes the SHA512 hash of a given string and encodes it with hexadecimal digits.
     * @param {string} str
     */
    static sha512(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("sha512", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/signum signum} determines the sign of a number, returning a number between -1 and 1 to represent the sign.
     * @param {number} num
     */
    static signum(num) {
        return (0, helpers_1.asNumber)((0, helpers_1.terraformFunction)("signum", [helpers_1.numericValue])(num));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/slice slice} extracts some consecutive elements from within a list.
     * @param {any} list
     * @param {number} start_index
     * @param {number} end_index
     */
    static slice(list, start_index, end_index) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("slice", [helpers_1.anyValue, helpers_1.numericValue, helpers_1.numericValue])(list, start_index, end_index));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/sort sort} takes a list of strings and returns a new list with those strings sorted lexicographically.
     * @param {Array<string>} list
     */
    static sort(list) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("sort", [(0, helpers_1.listOf)(helpers_1.anyValue)])(list));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/split split} produces a list by dividing a given string at all occurrences of a given separator.
     * @param {string} separator
     * @param {string} str
     */
    static split(separator, str) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("split", [helpers_1.stringValue, helpers_1.stringValue])(separator, str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/startswith startswith} takes two values: a string to check and a prefix string. The function returns true if the string begins with that exact prefix.
     * @param {string} str
     * @param {string} prefix
     */
    static startswith(str, prefix) {
        return (0, helpers_1.asBoolean)((0, helpers_1.terraformFunction)("startswith", [helpers_1.stringValue, helpers_1.stringValue])(str, prefix));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/strrev strrev} reverses the characters in a string. Note that the characters are treated as _Unicode characters_ (in technical terms, Unicode [grapheme cluster boundaries](https://unicode.org/reports/tr29/#Grapheme_Cluster_Boundaries) are respected).
     * @param {string} str
     */
    static strrev(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("strrev", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/substr substr} extracts a substring from a given string by offset and (maximum) length.
     * @param {string} str
     * @param {number} offset
     * @param {number} length
     */
    static substr(str, offset, length) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("substr", [helpers_1.stringValue, helpers_1.numericValue, helpers_1.numericValue])(str, offset, length));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/sum sum} takes a list or set of numbers and returns the sum of those numbers.
     * @param {any} list
     */
    static sum(list) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("sum", [helpers_1.anyValue])(list));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/templatefile templatefile} reads the file at the given path and renders its content as a template using a supplied set of template variables.
     * @param {string} path
     * @param {any} vars
     */
    static templatefile(path, vars) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("templatefile", [helpers_1.stringValue, helpers_1.anyValue])(path, vars));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/textdecodebase64 textdecodebase64} function decodes a string that was previously Base64-encoded, and then interprets the result as characters in a specified character encoding.
     * @param {string} source
     * @param {string} encoding
     */
    static textdecodebase64(source, encoding) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("textdecodebase64", [helpers_1.stringValue, helpers_1.stringValue])(source, encoding));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/textencodebase64 textencodebase64} encodes the unicode characters in a given string using a specified character encoding, returning the result base64 encoded because Terraform language strings are always sequences of unicode characters.
     * @param {string} str
     * @param {string} encoding
     */
    static textencodebase64(str, encoding) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("textencodebase64", [helpers_1.stringValue, helpers_1.stringValue])(str, encoding));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/timeadd timeadd} adds a duration to a timestamp, returning a new timestamp.
     * @param {string} timestamp
     * @param {string} duration
     */
    static timeadd(timestamp, duration) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("timeadd", [helpers_1.stringValue, helpers_1.stringValue])(timestamp, duration));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/timecmp timecmp} compares two timestamps and returns a number that represents the ordering of the instants those timestamps represent.
     * @param {string} timestamp_a
     * @param {string} timestamp_b
     */
    static timecmp(timestamp_a, timestamp_b) {
        return (0, helpers_1.asNumber)((0, helpers_1.terraformFunction)("timecmp", [helpers_1.stringValue, helpers_1.stringValue])(timestamp_a, timestamp_b));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/timestamp timestamp} returns a UTC timestamp string in [RFC 3339](https://tools.ietf.org/html/rfc3339) format.
     */
    static timestamp() {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("timestamp", [])());
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/title title} converts the first letter of each word in the given string to uppercase.
     * @param {string} str
     */
    static title(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("title", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/tobool tobool} converts its argument to a boolean value.
     * @param {any} v
     */
    static tobool(v) {
        return (0, helpers_1.asBoolean)((0, helpers_1.terraformFunction)("tobool", [helpers_1.anyValue])(v));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/tolist tolist} converts its argument to a list value.
     * @param {any} v
     */
    static tolist(v) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("tolist", [helpers_1.anyValue])(v));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/tomap tomap} converts its argument to a map value.
     * @param {any} v
     */
    static tomap(v) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("tomap", [helpers_1.anyValue])(v));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/tonumber tonumber} converts its argument to a number value.
     * @param {any} v
     */
    static tonumber(v) {
        return (0, helpers_1.asNumber)((0, helpers_1.terraformFunction)("tonumber", [helpers_1.anyValue])(v));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/toset toset} converts its argument to a set value.
     * @param {any} v
     */
    static toset(v) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("toset", [helpers_1.anyValue])(v));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/tostring tostring} converts its argument to a string value.
     * @param {any} v
     */
    static tostring(v) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("tostring", [helpers_1.anyValue])(v));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/transpose transpose} takes a map of lists of strings and swaps the keys and values to produce a new map of lists of strings.
     * @param {Object<string, Array<string>>} values
     */
    static transpose(values) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("transpose", [helpers_1.mapValue])(values));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/trim trim} removes the specified set of characters from the start and end of the given string.
     * @param {string} str
     * @param {string} cutset
     */
    static trim(str, cutset) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("trim", [helpers_1.stringValue, helpers_1.stringValue])(str, cutset));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/trimprefix trimprefix} removes the specified prefix from the start of the given string. If the string does not start with the prefix, the string is returned unchanged.
     * @param {string} str
     * @param {string} prefix
     */
    static trimprefix(str, prefix) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("trimprefix", [helpers_1.stringValue, helpers_1.stringValue])(str, prefix));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/trimspace trimspace} removes any space characters from the start and end of the given string.
     * @param {string} str
     */
    static trimspace(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("trimspace", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/trimsuffix trimsuffix} removes the specified suffix from the end of the given string.
     * @param {string} str
     * @param {string} suffix
     */
    static trimsuffix(str, suffix) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("trimsuffix", [helpers_1.stringValue, helpers_1.stringValue])(str, suffix));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/try try} evaluates all of its argument expressions in turn and returns the result of the first one that does not produce any errors.
     * @param {Array<any>} expressions
     */
    static try(expressions) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("try", [(0, helpers_1.variadic)(helpers_1.anyValue)])(expressions));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/upper upper} converts all cased letters in the given string to uppercase.
     * @param {string} str
     */
    static upper(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("upper", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/urlencode urlencode} applies URL encoding to a given string.
     * @param {string} str
     */
    static urlencode(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("urlencode", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/uuid uuid} generates a unique identifier string.
     */
    static uuid() {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("uuid", [])());
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/uuidv5 uuidv5} generates a _name-based_ UUID, as described in [RFC 4122 section 4.3](https://tools.ietf.org/html/rfc4122#section-4.3), also known as a &#34;version 5&#34; UUID.
     * @param {string} namespace
     * @param {string} name
     */
    static uuidv5(namespace, name) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("uuidv5", [helpers_1.stringValue, helpers_1.stringValue])(namespace, name));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/values values} takes a map and returns a list containing the values of the elements in that map.
     * @param {any} mapping
     */
    static values(mapping) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("values", [helpers_1.anyValue])(mapping));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/yamldecode yamldecode} parses a string as a subset of YAML, and produces a representation of its value.
     * @param {string} src
     */
    static yamldecode(src) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("yamldecode", [helpers_1.stringValue])(src));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/yamlencode yamlencode} encodes a given value to a string using [YAML 1.2](https://yaml.org/spec/1.2/spec.html) block syntax.
     * @param {any} value
     */
    static yamlencode(value) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("yamlencode", [helpers_1.anyValue])(value));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/zipmap zipmap} constructs a map from a list of keys and a corresponding list of values.
     * @param {Array<string>} keys
     * @param {any} values
     */
    static zipmap(keys, values) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("zipmap", [(0, helpers_1.listOf)(helpers_1.anyValue), helpers_1.anyValue])(keys, values));
    }
}
_a = JSII_RTTI_SYMBOL_1;
FnGenerated[_a] = { fqn: "cdktf.FnGenerated", version: "0.17.0-pre.18" };
exports.FnGenerated = FnGenerated;
//# sourceMappingURL=data:application/json;base64,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