"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Manifest = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const path = require("path");
const fs = require("fs");
// eslint-disable-next-line jsdoc/require-jsdoc
class Manifest {
    constructor(version, outdir) {
        this.version = version;
        this.outdir = outdir;
        this.stacks = {};
        const stacksPath = path.join(this.outdir, Manifest.stacksFolder);
        if (!fs.existsSync(stacksPath))
            fs.mkdirSync(stacksPath);
    }
    forStack(stack) {
        const node = stack.node;
        const name = node.id;
        if (this.stacks[name]) {
            return this.stacks[name];
        }
        const manifest = {
            name,
            constructPath: node.path,
            workingDirectory: path.join(Manifest.stacksFolder, node.id),
            synthesizedStackPath: path.join(Manifest.stacksFolder, node.id, Manifest.stackFileName),
            annotations: [],
            dependencies: stack.dependencies.map((item) => item.node.path),
        };
        this.stacks[name] = manifest;
        return manifest;
    }
    buildManifest() {
        return {
            version: this.version,
            stacks: this.stacks,
        };
    }
    writeToFile() {
        fs.writeFileSync(path.join(this.outdir, Manifest.fileName), JSON.stringify(this.buildManifest(), undefined, 2));
    }
}
_a = JSII_RTTI_SYMBOL_1;
Manifest[_a] = { fqn: "cdktf.Manifest", version: "0.17.0-pre.18" };
Manifest.fileName = "manifest.json";
Manifest.stacksFolder = "stacks";
Manifest.stackFileName = "cdk.tf.json";
exports.Manifest = Manifest;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWFuaWZlc3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJtYW5pZmVzdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLCtCQUErQjtBQUMvQixtQ0FBbUM7QUFDbkMsNkJBQTZCO0FBQzdCLHlCQUF5QjtBQXdCekIsK0NBQStDO0FBQy9DLE1BQWEsUUFBUTtJQU9uQixZQUE0QixPQUFlLEVBQWtCLE1BQWM7UUFBL0MsWUFBTyxHQUFQLE9BQU8sQ0FBUTtRQUFrQixXQUFNLEdBQU4sTUFBTSxDQUFRO1FBRjNELFdBQU0sR0FBaUQsRUFBRSxDQUFDO1FBR3hFLE1BQU0sVUFBVSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFBRSxRQUFRLENBQUMsWUFBWSxDQUFDLENBQUM7UUFDakUsSUFBSSxDQUFDLEVBQUUsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDO1lBQUUsRUFBRSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUMzRCxDQUFDO0lBRU0sUUFBUSxDQUFDLEtBQXFCO1FBQ25DLE1BQU0sSUFBSSxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUM7UUFDeEIsTUFBTSxJQUFJLEdBQUcsSUFBSSxDQUFDLEVBQUUsQ0FBQztRQUVyQixJQUFJLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLEVBQUU7WUFDckIsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDO1NBQzFCO1FBRUQsTUFBTSxRQUFRLEdBQWtCO1lBQzlCLElBQUk7WUFDSixhQUFhLEVBQUUsSUFBSSxDQUFDLElBQUk7WUFDeEIsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsWUFBWSxFQUFFLElBQUksQ0FBQyxFQUFFLENBQUM7WUFDM0Qsb0JBQW9CLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FDN0IsUUFBUSxDQUFDLFlBQVksRUFDckIsSUFBSSxDQUFDLEVBQUUsRUFDUCxRQUFRLENBQUMsYUFBYSxDQUN2QjtZQUNELFdBQVcsRUFBRSxFQUFFO1lBQ2YsWUFBWSxFQUFFLEtBQUssQ0FBQyxZQUFZLENBQUMsR0FBRyxDQUFDLENBQUMsSUFBSSxFQUFFLEVBQUUsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQztTQUMvRCxDQUFDO1FBQ0YsSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsR0FBRyxRQUFRLENBQUM7UUFFN0IsT0FBTyxRQUFRLENBQUM7SUFDbEIsQ0FBQztJQUVNLGFBQWE7UUFDbEIsT0FBTztZQUNMLE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBTztZQUNyQixNQUFNLEVBQUUsSUFBSSxDQUFDLE1BQU07U0FDcEIsQ0FBQztJQUNKLENBQUM7SUFFTSxXQUFXO1FBQ2hCLEVBQUUsQ0FBQyxhQUFhLENBQ2QsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLFFBQVEsQ0FBQyxRQUFRLENBQUMsRUFDekMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsYUFBYSxFQUFFLEVBQUUsU0FBUyxFQUFFLENBQUMsQ0FBQyxDQUNuRCxDQUFDO0lBQ0osQ0FBQzs7OztBQWhEc0IsaUJBQVEsR0FBRyxlQUFlLEFBQWxCLENBQW1CO0FBQzNCLHFCQUFZLEdBQUcsUUFBUSxBQUFYLENBQVk7QUFDeEIsc0JBQWEsR0FBRyxhQUFhLEFBQWhCLENBQWlCO0FBSDFDLDRCQUFRIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IChjKSBIYXNoaUNvcnAsIEluY1xuLy8gU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IE1QTC0yLjBcbmltcG9ydCAqIGFzIHBhdGggZnJvbSBcInBhdGhcIjtcbmltcG9ydCAqIGFzIGZzIGZyb20gXCJmc1wiO1xuaW1wb3J0IHsgVGVycmFmb3JtU3RhY2sgfSBmcm9tIFwiLi90ZXJyYWZvcm0tc3RhY2tcIjtcbmltcG9ydCB7IEFubm90YXRpb25NZXRhZGF0YUVudHJ5VHlwZSB9IGZyb20gXCIuL2Fubm90YXRpb25zXCI7XG5cbmV4cG9ydCBpbnRlcmZhY2UgU3RhY2tBbm5vdGF0aW9uIHtcbiAgcmVhZG9ubHkgY29uc3RydWN0UGF0aDogc3RyaW5nO1xuICByZWFkb25seSBsZXZlbDogQW5ub3RhdGlvbk1ldGFkYXRhRW50cnlUeXBlO1xuICByZWFkb25seSBtZXNzYWdlOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHN0YWNrdHJhY2U/OiBzdHJpbmdbXTtcbn1cbmV4cG9ydCBpbnRlcmZhY2UgU3RhY2tNYW5pZmVzdCB7XG4gIHJlYWRvbmx5IG5hbWU6IHN0cmluZztcbiAgcmVhZG9ubHkgY29uc3RydWN0UGF0aDogc3RyaW5nO1xuICByZWFkb25seSBzeW50aGVzaXplZFN0YWNrUGF0aDogc3RyaW5nO1xuICByZWFkb25seSB3b3JraW5nRGlyZWN0b3J5OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGFubm90YXRpb25zOiBTdGFja0Fubm90YXRpb25bXTtcbiAgcmVhZG9ubHkgZGVwZW5kZW5jaWVzOiBzdHJpbmdbXTtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBJTWFuaWZlc3Qge1xuICByZWFkb25seSBzdGFja3M6IFJlY29yZDxTdGFja01hbmlmZXN0W1wibmFtZVwiXSwgU3RhY2tNYW5pZmVzdD47XG4gIHJlYWRvbmx5IHZlcnNpb246IHN0cmluZztcbn1cblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGpzZG9jL3JlcXVpcmUtanNkb2NcbmV4cG9ydCBjbGFzcyBNYW5pZmVzdCBpbXBsZW1lbnRzIElNYW5pZmVzdCB7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgZmlsZU5hbWUgPSBcIm1hbmlmZXN0Lmpzb25cIjtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBzdGFja3NGb2xkZXIgPSBcInN0YWNrc1wiO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IHN0YWNrRmlsZU5hbWUgPSBcImNkay50Zi5qc29uXCI7XG5cbiAgcHVibGljIHJlYWRvbmx5IHN0YWNrczogUmVjb3JkPFN0YWNrTWFuaWZlc3RbXCJuYW1lXCJdLCBTdGFja01hbmlmZXN0PiA9IHt9O1xuXG4gIGNvbnN0cnVjdG9yKHB1YmxpYyByZWFkb25seSB2ZXJzaW9uOiBzdHJpbmcsIHB1YmxpYyByZWFkb25seSBvdXRkaXI6IHN0cmluZykge1xuICAgIGNvbnN0IHN0YWNrc1BhdGggPSBwYXRoLmpvaW4odGhpcy5vdXRkaXIsIE1hbmlmZXN0LnN0YWNrc0ZvbGRlcik7XG4gICAgaWYgKCFmcy5leGlzdHNTeW5jKHN0YWNrc1BhdGgpKSBmcy5ta2RpclN5bmMoc3RhY2tzUGF0aCk7XG4gIH1cblxuICBwdWJsaWMgZm9yU3RhY2soc3RhY2s6IFRlcnJhZm9ybVN0YWNrKTogU3RhY2tNYW5pZmVzdCB7XG4gICAgY29uc3Qgbm9kZSA9IHN0YWNrLm5vZGU7XG4gICAgY29uc3QgbmFtZSA9IG5vZGUuaWQ7XG5cbiAgICBpZiAodGhpcy5zdGFja3NbbmFtZV0pIHtcbiAgICAgIHJldHVybiB0aGlzLnN0YWNrc1tuYW1lXTtcbiAgICB9XG5cbiAgICBjb25zdCBtYW5pZmVzdDogU3RhY2tNYW5pZmVzdCA9IHtcbiAgICAgIG5hbWUsXG4gICAgICBjb25zdHJ1Y3RQYXRoOiBub2RlLnBhdGgsXG4gICAgICB3b3JraW5nRGlyZWN0b3J5OiBwYXRoLmpvaW4oTWFuaWZlc3Quc3RhY2tzRm9sZGVyLCBub2RlLmlkKSxcbiAgICAgIHN5bnRoZXNpemVkU3RhY2tQYXRoOiBwYXRoLmpvaW4oXG4gICAgICAgIE1hbmlmZXN0LnN0YWNrc0ZvbGRlcixcbiAgICAgICAgbm9kZS5pZCxcbiAgICAgICAgTWFuaWZlc3Quc3RhY2tGaWxlTmFtZVxuICAgICAgKSxcbiAgICAgIGFubm90YXRpb25zOiBbXSwgLy8gd2lsbCBiZSByZXBsYWNlZCBsYXRlciB3aGVuIHByb2Nlc3NlZCBpbiBBcHBcbiAgICAgIGRlcGVuZGVuY2llczogc3RhY2suZGVwZW5kZW5jaWVzLm1hcCgoaXRlbSkgPT4gaXRlbS5ub2RlLnBhdGgpLFxuICAgIH07XG4gICAgdGhpcy5zdGFja3NbbmFtZV0gPSBtYW5pZmVzdDtcblxuICAgIHJldHVybiBtYW5pZmVzdDtcbiAgfVxuXG4gIHB1YmxpYyBidWlsZE1hbmlmZXN0KCk6IElNYW5pZmVzdCB7XG4gICAgcmV0dXJuIHtcbiAgICAgIHZlcnNpb246IHRoaXMudmVyc2lvbixcbiAgICAgIHN0YWNrczogdGhpcy5zdGFja3MsXG4gICAgfTtcbiAgfVxuXG4gIHB1YmxpYyB3cml0ZVRvRmlsZSgpIHtcbiAgICBmcy53cml0ZUZpbGVTeW5jKFxuICAgICAgcGF0aC5qb2luKHRoaXMub3V0ZGlyLCBNYW5pZmVzdC5maWxlTmFtZSksXG4gICAgICBKU09OLnN0cmluZ2lmeSh0aGlzLmJ1aWxkTWFuaWZlc3QoKSwgdW5kZWZpbmVkLCAyKVxuICAgICk7XG4gIH1cbn1cbiJdfQ==